/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

class DDFile {
    private static final boolean DEBUG = false;
    private static int[] m_filenameToResID;
    private static int m_filenameToResIDNum;
    private static final int FTRID_HASH = 0;
    private static final int FTRID_RESID = 1;
    private static final int INVALID_RESID = -1;

    DDFile() {
    }

    public static void fileInit() {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(0);
            int n = sDKInputStream.getLength() >> 2;
            m_filenameToResIDNum = n >> 1;
            m_filenameToResID = new int[n];
            for (int i = 0; i < n; ++i) {
                DDFile.m_filenameToResID[i] = sDKInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int get16bits(String string, int n) {
        return string.charAt(n + 0) & 0xFF | (string.charAt(n + 1) & 0xFF) << 8;
    }

    private static int SuperFastHash(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = 0;
        int n4 = n & 3;
        n >>>= 2;
        while (n > 0) {
            int n5 = DDFile.get16bits(string, n3 + 2) << 11 ^ (n2 += DDFile.get16bits(string, n3));
            n2 = n2 << 16 ^ n5;
            n3 += 4;
            n2 += n2 >>> 11;
            --n;
        }
        switch (n4) {
            case 3: {
                n2 += DDFile.get16bits(string, n3);
                n2 ^= n2 << 16;
                n2 ^= (string.charAt(n3 + 2) & 0xFF) << 18;
                n2 += n2 >>> 11;
                break;
            }
            case 2: {
                n2 += DDFile.get16bits(string, n3);
                n2 ^= n2 << 11;
                n2 += n2 >>> 17;
                break;
            }
            case 1: {
                n2 += string.charAt(n3) & 0xFF;
                n2 ^= n2 << 10;
                n2 += n2 >>> 1;
            }
        }
        n2 ^= n2 << 3;
        n2 += n2 >>> 5;
        n2 ^= n2 << 4;
        n2 += n2 >>> 17;
        n2 ^= n2 << 25;
        n2 += n2 >>> 6;
        return n2;
    }

    private static int getResIDFromFilename(String string) {
        try {
            int n = DDFile.SuperFastHash(string);
            for (int i = 0; i < m_filenameToResIDNum; ++i) {
                if (m_filenameToResID[(i << 1) + 0] != n) continue;
                int n2 = m_filenameToResID[(i << 1) + 1];
                return n2;
            }
        }
        catch (Exception exception) {
            System.out.println("failed getResIDFromFilename " + exception);
        }
        return -1;
    }

    public static int getFileLength(String string) {
        int n = DDFile.getResIDFromFilename(string);
        if (n == -1) {
            return -1;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            return sDKInputStream.getLength();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static SDKImage loadImage(String string) {
        SDKImage sDKImage = null;
        int n = DDFile.getResIDFromFilename(string);
        if (n == -1) {
            return sDKImage;
        }
        try {
            sDKImage = SDKInputStream.loadImageObject(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sDKImage;
    }

    public static byte[] loadFileBytes(String string, int n) {
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return null;
        }
        return SDKInputStream.loadResourceAsByteArray(n2);
    }

    public static byte[] loadFileBytes(String string) {
        int n = DDFile.getResIDFromFilename(string);
        if (n == -1) {
            return null;
        }
        return SDKInputStream.loadResourceAsByteArray(n);
    }

    public static short[] loadFileShorts(String string) {
        return DDFile.loadFileShorts(string, false);
    }

    public static short[] loadFileShorts(String string, boolean bl) {
        short[] sArray = null;
        int n = DDFile.getResIDFromFilename(string);
        if (n == -1) {
            return null;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            int n2 = sDKInputStream.getLength() >> 1;
            sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = bl ? sDKInputStream.readShortBE() : sDKInputStream.readShort();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sArray;
    }

    public static int[] loadFileInts(String string) {
        return DDFile.loadFileInts(string, true);
    }

    public static int[] loadFileInts(String string, boolean bl) {
        int[] nArray = null;
        int n = DDFile.getResIDFromFilename(string);
        if (n == -1) {
            return null;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            int n2 = sDKInputStream.getLength() >> 2;
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = bl ? sDKInputStream.readIntBE() : sDKInputStream.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    public static byte[] loadRMSFile(int n) {
        return SDKUtils.loadRecord(n);
    }

    public static boolean doesRMSFileExist(int n) {
        return !SDKUtils.isRecordEmpty(n);
    }

    public static void deleteRMSFile(int n) {
        SDKUtils.removeRecord(n);
    }

    public static boolean saveRMSFile(int n, byte[] byArray, int n2) {
        if (byArray.length != n2) {
            // empty if block
        }
        SDKUtils.saveRecord(n, byArray);
        return true;
    }

    public static short retrieveShort(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (short)((byArray[n + 1] & 0xFF) << 8 | (byArray[n + 0] & 0xFF) << 0);
        }
        return (short)((byArray[n + 0] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 0);
    }
}

