/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDDebug;
import com.distinctive.DDFile;
import com.distinctive.DDImage;
import com.distinctive.DDMath;
import com.ea.sdk.SDKGraphics;

public class DDAnimation {
    private static final String ANIM_FILE_EXTENSION = ".anim";
    public static final int DIR_EAST = 0;
    public static final int DIR_SOUTHEAST = 1;
    public static final int DIR_SOUTH = 2;
    public static final int DIR_SOUTHWEST = 3;
    public static final int DIR_WEST = 4;
    public static final int DIR_NORTHWEST = 5;
    public static final int DIR_NORTH = 6;
    public static final int DIR_NORTHEAST = 7;
    private static final int DIR_COUNT = 8;
    private static final int DIR_MASK = 7;
    private static final int METADATA = 0;
    private static final int METADATA_DIRECTIONS = 0;
    private static final int METADATA_CONTROLTYPE = 1;
    private static final int METADATA_TEMPO = 2;
    private static final int METADATA_FRAMECOUNT = 3;
    private static final int METADATA_SIZE = 4;
    private static final int CONTROL_TYPE_EXTEND_LAST_FRAME = 0;
    private static final int CONTROL_TYPE_LOOP = 1;
    private DDImage m_sprite;
    private int[][][] m_data;

    public static DDAnimation createAnimation(String string) {
        return DDAnimation.createPalletizedAnimation(string, new boolean[]{true});
    }

    public static DDAnimation createPalletizedAnimation(String string, int n, int n2) {
        boolean[] blArray = new boolean[n2];
        blArray[n] = true;
        return DDAnimation.createPalletizedAnimation(string, blArray);
    }

    public static DDAnimation createPalletizedAnimation(String string, int n) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        return DDAnimation.createPalletizedAnimation(string, blArray);
    }

    public static DDAnimation createPalletizedAnimation(String string, boolean[] blArray) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith(ANIM_FILE_EXTENSION)) {
            string = string.substring(0, string.length() - ANIM_FILE_EXTENSION.length());
        }
        DDImage dDImage = null;
        int[][][] nArray = DDAnimation.loadAnimationData(string + ANIM_FILE_EXTENSION);
        DDAnimation dDAnimation = null;
        if (dDImage != null && nArray != null) {
            dDAnimation = new DDAnimation(dDImage, nArray);
        }
        return dDAnimation;
    }

    private DDAnimation(DDImage dDImage, int[][][] nArray) {
        this.m_sprite = dDImage;
        this.m_data = nArray;
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        this.drawFrame(sDKGraphics, n, n2, n3, n4, 6, 0, 20, 0);
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawFrame(sDKGraphics, n, n2, n3, n4, n5, n6, 20, 0);
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.getSpriteFrameId(n3, n4, n5);
        if (n9 != -1) {
            this.m_sprite.drawFrame(sDKGraphics, n, n2, n9, n6, n7, n8);
        }
    }

    public int getSequenceLength(int n) {
        return this.m_data[n][0][3] * this.m_data[n][0][2];
    }

    public int getFrameHeight(int n, int n2, int n3) {
        int n4 = this.getSpriteFrameId(n, n2, n3);
        if (n4 != -1) {
            return this.m_sprite.getFrameHeight(n4);
        }
        return -1;
    }

    public int getFrameWidth(int n, int n2, int n3) {
        int n4 = this.getSpriteFrameId(n, n2, n3);
        if (n4 != -1) {
            return this.m_sprite.getFrameWidth(n4);
        }
        return -1;
    }

    public int getSpriteFrameId(int n, int n2, int n3) {
        if (n >= 0 && n < this.m_data.length) {
            int n4;
            int n5 = 0;
            int[] nArray = null;
            do {
                n4 = (n3 + n5 & 7) + 1;
                int n6 = (n3 - n5 & 7) + 1;
                if (this.m_data[n][n4] != null) {
                    nArray = this.m_data[n][n4];
                    continue;
                }
                if (this.m_data[n][n6] != null) {
                    nArray = this.m_data[n][n6];
                    continue;
                }
                if (n5 >= 4) {
                    return -1;
                }
                ++n5;
            } while (nArray == null);
            n2 /= this.m_data[n][0][2];
            n4 = this.m_data[n][0][3];
            switch (this.m_data[n][0][1]) {
                case 0: {
                    return nArray[DDMath.min(n2, n4 - 1)];
                }
                case 1: {
                    return nArray[n2 % n4];
                }
            }
            DDDebug.msg("Unknown control type: " + this.m_data[n][0][1]);
            return 0;
        }
        if (n >= 0) {
            DDDebug.msg("Warning: invalid animation sequence requested: " + n + ", seq count: " + this.m_data.length);
        }
        return -1;
    }

    private static int[][][] loadAnimationData(String string) {
        int n;
        Object object = null;
        int n2 = 0;
        byte[] byArray = DDFile.loadFileBytes(string);
        if (byArray == null) {
            return null;
        }
        int n3 = byArray[n2++] & 0xFF;
        n2 += 2;
        int n4 = byArray[n2++] & 0xFF;
        if (n3 == 221) {
            // empty if block
        }
        if (n4 >= 2) {
            n = byArray[n2++] & 0xFF;
        }
        n = DDFile.retrieveShort(byArray, n2, true);
        n2 += 2;
        object = new int[n][][];
        n2 += 2;
        n2 += 2 * n;
        n2 += 2;
        for (int i = 0; i < n; ++i) {
            int n5 = byArray[n2++] & 0xFF;
            int n6 = DDMath.countSetBits(n5);
            int n7 = ++n2;
            ++n2;
            int n8 = byArray[n7] & 0xFF;
            n2 += 2;
            int n9 = byArray[n2++] & 0xFF;
            int n10 = DDFile.retrieveShort(byArray, n2, true);
            n2 += 2;
            object[i] = new int[9][];
            object[i][0] = new int[4];
            object[i][0][0] = n5;
            object[i][0][1] = n8;
            object[i][0][2] = n9;
            object[i][0][3] = n10;
            for (int j = 1; j <= n6; ++j) {
                int n11 = byArray[n2++] + 1;
                object[i][n11] = new int[n10];
                for (int k = 0; k < n10; ++k) {
                    object[i][n11][k] = byArray[n2++] & 0xFF;
                }
            }
        }
        return object;
    }
}

