/*
 * Decompiled with CFR 0.152.
 */
package samartham;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import samartham.BaseCanvas;
import samartham.SFont;

public class GridMenu {
    public final int SLIDE_NOT_PAGE;
    public final int SLIDE_RIGHT_NEXT_PAGE;
    public final int SLIDE_RIGHT_SAME_PAGE;
    public final int SLIDE_LEFT_NEXT_PAGE;
    public final int SLIDE_LEFT_SAME_PAGE;
    public final int SLIDE_DRAW_LEFT_PAGE;
    public final int SLIDE_DRAW_RIGHT_PAGE;
    BaseCanvas m_pBase;
    Image tabNormal;
    Image tabLock;
    Image gridSelection;
    int START_GRID_X;
    int START_GRID_Y;
    int Grid_X;
    int Grid_Y;
    int GRID_DOT_GAP;
    int GRID_DOT_WIDTH;
    int BOTTOM_HEIGHT;
    int ROW;
    int COLUMN;
    int grid_pressX;
    int grid_pressY;
    int grid_moveX;
    int grid_moveY;
    int grid_move;
    int noOfPages;
    int curPageNo;
    int noOfRows;
    int noOfColumns;
    int GRID_MAX_ID;
    int GRID_MAX_TABS;
    int gridFocusId;
    int gridStartFocusId;
    int gridEndFocusId;
    int tabwid;
    int tabhgt;
    int pX;
    int pY;
    int gridState;
    Image star;
    boolean pressed = false;
    int bestScore;
    int levelScore;

    GridMenu(BaseCanvas base) {
        this.SLIDE_NOT_PAGE = -1;
        this.SLIDE_RIGHT_NEXT_PAGE = 0;
        this.SLIDE_RIGHT_SAME_PAGE = 1;
        this.SLIDE_LEFT_NEXT_PAGE = 2;
        this.SLIDE_LEFT_SAME_PAGE = 3;
        this.SLIDE_DRAW_LEFT_PAGE = 4;
        this.SLIDE_DRAW_RIGHT_PAGE = 5;
        this.m_pBase = base;
    }

    public void inIt() {
        this.loadImage();
        this.Grid_X = 0;
        this.Grid_Y = 0;
        this.grid_pressX = 0;
        this.grid_pressY = 0;
        this.grid_moveX = 0;
        this.grid_moveY = 0;
        this.grid_move = -1;
        this.gridFocusId = 0;
        this.curPageNo = 1;
        this.gridFocusId = 0;
        this.GRID_MAX_ID = 40;
        this.START_GRID_X = 40;
        this.START_GRID_Y = 130;
        this.GRID_DOT_GAP = 4;
        this.GRID_DOT_WIDTH = 8;
        this.tabhgt = this.tabNormal.getHeight() + 5;
        this.tabwid = this.tabNormal.getWidth();
        this.pX = this.tabwid / 2;
        this.pY = this.tabhgt / 4;
        this.BOTTOM_HEIGHT = 60;
        this.ROW = this.getNoOfRow();
        this.COLUMN = this.getNoOfColumn();
        this.gridState = 11;
    }

    int getNoOfColumn() {
        int col = 1;
        boolean find = true;
        int wid = this.tabwid;
        while (find) {
            if (wid + this.tabwid + this.pX <= this.m_pBase.width - 2 * this.START_GRID_X) {
                wid += this.tabwid + this.pX;
                ++col;
                continue;
            }
            find = false;
        }
        this.pX += (this.m_pBase.width - 2 * this.START_GRID_X - wid) / col;
        return col;
    }

    int getNoOfRow() {
        int row = 1;
        boolean find = true;
        int hgt = this.tabhgt + this.pY;
        while (find) {
            if (hgt + this.tabhgt + this.pY <= this.m_pBase.height - (this.START_GRID_Y + this.BOTTOM_HEIGHT)) {
                hgt += this.tabhgt + this.pY;
                ++row;
                continue;
            }
            find = false;
        }
        this.pY += (this.m_pBase.height - (this.START_GRID_Y + this.BOTTOM_HEIGHT) - hgt) / row;
        System.out.println(" row " + hgt + "  " + (this.m_pBase.height - (this.START_GRID_Y + this.BOTTOM_HEIGHT)));
        return row;
    }

    void loadImage() {
        try {
            if (this.tabNormal == null) {
                this.tabNormal = Image.createImage((String)"/lvl_1.png");
            }
            if (this.tabLock == null) {
                this.tabLock = Image.createImage((String)"/lvl_lock.png");
            }
            if (this.gridSelection == null) {
                this.gridSelection = Image.createImage((String)"/lvl_selection.png");
            }
            try {
                if (this.star == null) {
                    this.star = Image.createImage((String)"/star_lvl.png");
                }
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            System.out.println("Grid Menu error in loadImage " + e.toString());
        }
    }

    void unloadImage() {
        this.tabNormal = null;
        this.tabLock = null;
        this.gridSelection = null;
        System.gc();
    }

    void DrawGrid(Graphics g) {
        for (int l = 1; l <= this.noOfPages; ++l) {
            if (this.grid_moveX < 0 && this.curPageNo != 1 && l == this.curPageNo - 1) {
                this.drawPage(g, this.gridStartFocusId - this.ROW * this.COLUMN, this.gridStartFocusId, -1);
            }
            if (l == this.curPageNo) {
                this.drawPage(g, this.gridStartFocusId, this.gridEndFocusId, 0);
            }
            if (this.grid_moveX > 0 && this.curPageNo != this.noOfPages && l == this.curPageNo + 1) {
                this.drawPage(g, this.gridStartFocusId + this.GRID_MAX_TABS, this.gridEndFocusId + this.GRID_MAX_TABS, 1);
            }
            this.Draw_Dot_Square(g);
        }
    }

    void drawPage(Graphics g, int x, int y, int page) {
        int i = 0;
        int j = 0;
        int k = 0;
        if (y > this.GRID_MAX_ID) {
            y = this.GRID_MAX_ID;
        }
        for (i = x; i < y; ++i) {
            this.Grid_X = this.START_GRID_X + j * this.pX + this.tabwid * j - this.grid_moveX + page * this.m_pBase.width;
            this.Grid_Y = this.START_GRID_Y + k * this.pY + this.tabhgt * k;
            g.setColor(200, 100, 100);
            if (this.tabNormal != null) {
                g.drawImage(this.tabNormal, this.Grid_X + this.tabwid / 2, this.Grid_Y + this.tabhgt / 2, 3);
            }
            String name = i + 1 + "";
            if (i <= this.m_pBase.savedata.levelUnlocked) {
                SFont.drawString(g, name, this.Grid_X + this.tabwid / 2, this.Grid_Y + this.tabhgt / 2, 3, SFont.CFONT_HEIGHT, SFont.BLACK);
            } else if (this.tabLock != null) {
                g.drawImage(this.tabLock, this.Grid_X + this.tabwid / 2, this.Grid_Y + this.tabhgt / 2, 3);
            }
            if (i == this.gridFocusId && this.gridSelection != null) {
                if (!this.m_pBase.isTouchDevice) {
                    g.drawImage(this.gridSelection, this.Grid_X + this.tabwid / 2, this.Grid_Y + this.tabhgt / 2, 3);
                } else if (this.pressed) {
                    g.drawImage(this.gridSelection, this.Grid_X + this.tabwid / 2, this.Grid_Y + this.tabhgt / 2, 3);
                }
            }
            if (++j < this.noOfColumns) continue;
            j = 0;
            ++k;
        }
    }

    void Draw_Dot_Square(Graphics g) {
        int y = this.m_pBase.height;
        y = this.m_pBase.height - this.BOTTOM_HEIGHT - this.GRID_DOT_WIDTH > this.START_GRID_Y + (this.tabhgt + this.pY) * this.ROW ? this.m_pBase.height - this.BOTTOM_HEIGHT - this.GRID_DOT_WIDTH : this.START_GRID_Y + (this.tabhgt + this.pY) * this.ROW;
        for (int ll = 0; ll < this.noOfPages && this.noOfPages != 1; ++ll) {
            if (ll + 1 == this.curPageNo) {
                g.setColor(255, 255, 255);
            } else {
                g.setColor(255, 2, 25);
            }
            g.fillRoundRect(ll * (this.GRID_DOT_GAP + this.GRID_DOT_WIDTH) + (this.m_pBase.width - this.noOfPages * (this.GRID_DOT_GAP + this.GRID_DOT_WIDTH)) / 2, y, this.GRID_DOT_WIDTH, this.GRID_DOT_WIDTH, this.GRID_DOT_WIDTH / 2, this.GRID_DOT_WIDTH / 2);
        }
    }

    void UpdateGrid() {
        this.gridState = 11;
        this.noOfColumns = this.COLUMN;
        this.noOfRows = this.ROW;
        this.GRID_MAX_TABS = this.noOfColumns * this.noOfRows;
        if (this.GRID_MAX_TABS != 0) {
            this.noOfPages = this.GRID_MAX_ID % this.GRID_MAX_TABS == 0 ? this.GRID_MAX_ID / this.GRID_MAX_TABS : this.GRID_MAX_ID / this.GRID_MAX_TABS + 1;
        }
        if (this.GRID_MAX_TABS > this.GRID_MAX_ID) {
            this.GRID_MAX_TABS = this.GRID_MAX_ID;
        }
        if (this.gridFocusId < this.GRID_MAX_TABS) {
            if (this.gridFocusId < 0) {
                this.gridFocusId = 0;
            }
            this.curPageNo = 1;
        } else if (this.gridFocusId == this.GRID_MAX_TABS) {
            this.curPageNo = 2;
        } else if (this.gridFocusId > this.GRID_MAX_TABS) {
            this.curPageNo = this.gridFocusId / this.GRID_MAX_TABS + 1;
        }
        if (this.curPageNo == this.noOfPages) {
            this.gridStartFocusId = this.GRID_MAX_TABS * (this.noOfPages - 1);
            this.gridEndFocusId = this.gridStartFocusId + this.GRID_MAX_TABS;
            if (this.gridEndFocusId > this.GRID_MAX_ID) {
                this.gridEndFocusId = this.GRID_MAX_ID;
            }
            if (this.gridEndFocusId - this.gridStartFocusId < this.GRID_MAX_TABS) {
                this.noOfRows = (this.gridEndFocusId - this.gridStartFocusId) / this.noOfColumns;
                if ((this.gridEndFocusId - this.gridStartFocusId) % this.noOfColumns != 0) {
                    this.noOfRows = (this.gridEndFocusId - this.gridStartFocusId) / this.noOfColumns + 1;
                }
            }
        } else {
            this.gridStartFocusId = (this.curPageNo - 1) * this.GRID_MAX_TABS;
            this.gridEndFocusId = this.gridStartFocusId + this.GRID_MAX_TABS;
        }
        this.updatePointerMove();
        this.gridState = 12;
    }

    void updatePointerMove() {
        if (this.grid_move == 0) {
            this.grid_moveX += this.tabwid / 2;
            if (this.m_pBase.width - this.grid_moveX < 0) {
                this.grid_moveX = 0;
                this.grid_moveY = 0;
                this.grid_move = -1;
                if (this.curPageNo < this.noOfPages) {
                    ++this.curPageNo;
                    this.gridFocusId += this.GRID_MAX_TABS;
                    this.UpdateGrid();
                    if (this.gridFocusId >= this.gridEndFocusId) {
                        this.gridFocusId = this.gridEndFocusId - 1;
                    }
                }
            }
        } else if (this.grid_move == 2) {
            this.grid_moveX -= this.tabwid / 2;
            if (this.m_pBase.width + this.grid_moveX < 0) {
                this.grid_moveX = 0;
                this.grid_moveY = 0;
                this.grid_move = -1;
                if (this.curPageNo > 1) {
                    --this.curPageNo;
                    this.gridFocusId -= this.GRID_MAX_TABS;
                    this.UpdateGrid();
                }
            }
        } else if (this.grid_move == 3) {
            this.grid_moveX -= this.tabwid / 3;
            if (this.grid_moveX < 0) {
                this.grid_moveX = 0;
                this.grid_moveY = 0;
                this.grid_move = -1;
            }
        } else if (this.grid_move == 1) {
            this.grid_moveX += this.tabwid / 3;
            if (this.grid_moveX > 0) {
                this.grid_moveX = 0;
                this.grid_moveY = 0;
                this.grid_move = -1;
            }
        }
    }

    protected void paint(Graphics g) {
        if (this.gridState == 12) {
            try {
                SFont.drawString(g, "LEVELS", this.m_pBase.getWidth() / 2, this.m_pBase.getWidth() / 9 + this.m_pBase.DIFF_Y / 2, 3, SFont.CFONT_HEIGHT, 3);
                this.DrawGrid(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(int keyCode) throws IOException {
        this.HandleEvent(keyCode);
    }

    public void run() {
        this.UpdateGrid();
        this.m_pBase.midlet.sound_play(2);
    }

    void HandleEvent(int wParam) throws IOException {
        switch (wParam) {
            case -6: 
            case -5: {
                this.unloadImage();
                this.m_pBase.nullImage();
                this.m_pBase.mState = 7;
                this.m_pBase.GameCoins = 0;
                this.m_pBase.m_pGameClass.initLevel(this.gridFocusId + 1);
                break;
            }
            case -7: {
                this.m_pBase.room.init();
                this.m_pBase.mState = 14;
                this.unloadImage();
                break;
            }
            case -4: {
                if (this.gridFocusId + 1 >= this.GRID_MAX_ID) {
                    this.gridFocusId = 0;
                    this.curPageNo = 1;
                } else if (this.gridFocusId == this.gridEndFocusId - 1) {
                    if (this.curPageNo < this.noOfPages) {
                        ++this.curPageNo;
                    }
                    this.gridFocusId = this.gridEndFocusId;
                } else {
                    ++this.gridFocusId;
                }
                this.UpdateGrid();
                break;
            }
            case -3: {
                if (this.gridFocusId == 0) {
                    this.curPageNo = this.noOfPages;
                    this.gridFocusId = this.GRID_MAX_ID - 1;
                } else if (this.gridFocusId == this.gridStartFocusId) {
                    this.gridFocusId = this.gridStartFocusId - 1;
                    if (this.curPageNo > 1) {
                        --this.curPageNo;
                    }
                } else {
                    --this.gridFocusId;
                }
                this.UpdateGrid();
                break;
            }
            case -1: {
                if (this.gridFocusId - this.noOfColumns >= this.gridStartFocusId) {
                    this.gridFocusId -= this.noOfColumns;
                } else {
                    this.gridFocusId += this.noOfColumns * (this.noOfRows - 1);
                    if (this.gridFocusId >= this.gridEndFocusId) {
                        this.gridFocusId = this.gridEndFocusId - this.noOfColumns;
                    }
                }
                this.UpdateGrid();
                break;
            }
            case -2: {
                if (this.gridFocusId + this.noOfColumns <= this.gridEndFocusId - 1) {
                    this.gridFocusId += this.noOfColumns;
                } else {
                    this.gridFocusId -= this.noOfColumns * (this.ROW - 1);
                    if (this.gridFocusId <= this.gridStartFocusId) {
                        this.gridFocusId = this.gridStartFocusId;
                    }
                }
                this.UpdateGrid();
                break;
            }
        }
    }

    public int pointerPressed(int x, int y) {
        if (this.grid_move == 0 || this.grid_move == 1 || this.grid_move == 2 || this.grid_move == 3) {
            return -1;
        }
        int Id = -1;
        if (x >= this.START_GRID_X - this.tabwid / 3 && x <= this.START_GRID_X + this.noOfColumns * this.tabwid + this.pX * (this.noOfColumns - 1) + this.tabwid / 3 && y >= this.START_GRID_Y - this.tabwid / 3 && y <= this.m_pBase.height - this.BOTTOM_HEIGHT) {
            this.grid_pressX = x;
            this.grid_pressY = y;
            this.grid_moveX = 0;
            this.grid_moveY = 0;
            int touchTabX = (x - this.START_GRID_X) / (this.pX + this.tabwid);
            int touchTabY = (y - this.START_GRID_Y) / (this.pY + this.tabhgt);
            Id = this.gridStartFocusId + touchTabX + touchTabY * this.noOfColumns;
            if (Id >= this.gridEndFocusId) {
                Id = -1;
            }
            if (Id != -1) {
                this.gridFocusId = Id;
                this.pressed = true;
            }
        }
        return Id;
    }

    public int pointerDragged(int x, int y) {
        if (this.grid_move == 0 || this.grid_move == 1 || this.grid_move == 2 || this.grid_move == 3) {
            return -1;
        }
        int Id = -1;
        if (x >= this.START_GRID_X - this.tabwid / 3 && x <= this.START_GRID_X + this.noOfColumns * this.tabwid + this.pX * (this.noOfColumns - 1) + this.tabwid / 3 && y >= this.START_GRID_Y - this.tabwid / 3 && y <= this.m_pBase.height - this.BOTTOM_HEIGHT) {
            if (this.noOfPages == 1) {
                int touchTabX = (x - this.START_GRID_X) / (this.pX + this.tabwid);
                int touchTabY = (y - this.START_GRID_Y) / (this.pY + this.tabhgt);
                Id = this.gridStartFocusId + touchTabX + touchTabY * this.noOfColumns;
                if (Id >= this.gridEndFocusId) {
                    Id = -1;
                }
                if (Id != -1) {
                    this.gridFocusId = Id;
                    this.pressed = true;
                }
            } else {
                int touchTabX = (x - this.START_GRID_X + this.grid_moveX) / (this.pX + this.tabwid);
                int touchTabY = (y - this.START_GRID_Y) / (this.pY + this.tabhgt);
                Id = this.gridStartFocusId + touchTabX + touchTabY * this.noOfColumns;
                if (Id >= this.gridEndFocusId) {
                    Id = -1;
                }
                if (Id != -1) {
                    this.gridFocusId = Id;
                    this.pressed = true;
                }
                this.grid_moveX = this.grid_pressX - x;
                this.grid_moveY = this.grid_pressY - y;
                if (Math.abs(this.grid_moveY) > this.tabhgt * 2 / 3) {
                    this.m_pBase.pointDragged = true;
                }
                if (this.grid_moveX < 0) {
                    this.grid_move = 4;
                    if (this.curPageNo == 1 && this.grid_moveX < -this.m_pBase.height / 3) {
                        this.grid_moveX = -this.m_pBase.width / 3;
                    }
                } else if (this.grid_moveX > 0) {
                    this.grid_move = 5;
                    if (this.curPageNo == this.noOfPages && this.grid_moveX > this.m_pBase.width / 3) {
                        this.grid_moveX = this.m_pBase.width / 3;
                    }
                }
            }
        }
        return Id;
    }

    public int pointerReleased(int x, int y) throws IOException {
        this.pressed = false;
        if (this.grid_move == 0 || this.grid_move == 1 || this.grid_move == 2 || this.grid_move == 3) {
            return -1;
        }
        int Id = -1;
        if (x >= this.START_GRID_X - this.tabwid / 3 && x <= this.START_GRID_X + this.noOfColumns * this.tabwid + this.pX * (this.noOfColumns - 1) + this.tabwid / 3 && y >= this.START_GRID_Y - this.tabwid / 3 && y <= this.m_pBase.height - this.BOTTOM_HEIGHT) {
            if (Math.abs(this.grid_moveX) < this.tabwid / 2) {
                int touchTabX = (x - this.START_GRID_X) / (this.pX + this.tabwid);
                int touchTabY = (y - this.START_GRID_Y) / (this.pY + this.tabhgt);
                Id = this.gridStartFocusId + touchTabX + touchTabY * this.noOfColumns;
                if (Id >= this.gridEndFocusId) {
                    Id = -1;
                }
                if (Id != -1) {
                    this.gridFocusId = Id;
                    this.HandleEvent(-5);
                }
            }
        } else if (Math.abs(this.grid_moveX) >= this.tabwid / 2 || Math.abs(this.grid_moveY) >= this.tabhgt / 2) {
            this.m_pBase.pointDragged = true;
        }
        if (Math.abs(this.grid_moveX) >= this.tabwid) {
            if (this.grid_moveX >= this.tabwid) {
                this.grid_move = this.curPageNo < this.noOfPages ? 0 : 1;
            } else if (this.grid_moveX <= -this.tabwid) {
                this.grid_move = this.curPageNo > 1 ? 2 : 3;
            }
        } else if (this.grid_moveX > 0) {
            this.grid_move = 3;
        } else if (this.grid_moveX < 0) {
            this.grid_move = 1;
        }
        return Id;
    }
}

