/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CPrince
extends CActorShell {
    static final int INDEX_PRINCE_ASSASSIN_GROUND = 0;
    static final int INDEX_PRINCE_ASSASSIN_DARK_GROUND = 1;
    static final int INDEX_PRINCE_ASSASSIN_AIR = 2;
    static final int INDEX_PRINCE_ASSASSIN_ROPE = 3;
    static final int INDEX_PRINCE_ASSASSIN_H_WALLING = 4;
    static final int INDEX_PRINCE_ASSASSIN_UPWARDS = 5;
    static final int FLAG_PRINCE_ASSASSIN_GROUND = 1;
    static final int FLAG_PRINCE_ASSASSIN_DARK_GROUND = 2;
    static final int FLAG_PRINCE_ASSASSIN_AIR = 4;
    static final int FLAG_PRINCE_ASSASSIN_ROPE = 8;
    static final int FLAG_PRINCE_ASSASSIN_H_WALLING = 16;
    static final int FLAG_PRINCE_ASSASSIN_UPWARDS = 32;
    static final int FLAG_PRINCE_FOR_DARK_ON_GROUND = 34;
    static final int UNIT = 10;
    static final short[] PRINCE_ASSASSIN_BOX_MAX = new short[]{-80, -1, 80, 0, -170, -1, 170, 0, -60, -160, 60, -40, -20, -120, 20, 0, -70, -100, 70, 0, -100, 10, 100, 100};
    static final short[] PRINCE_ASSASSIN_BOX_MIN = new short[]{-30, -1, 30, 1, -40, -1, 40, 1};
    static int m_nMaxBlood;
    static int m_specialFlags;
    static boolean m_isSwordInHand;
    static int m_lastBarActorID;
    static CActorShell m_chainGrabActor;
    static int m_chainGrabX;
    static int m_chainGrabY;
    static CActorShell m_leftObjective;
    static CActorShell m_rightObjective;
    static CActorShell m_justAttackedEnemy;
    static CActorShell m_assassinActor;
    static CActorShell m_indicator;
    static CActorShell m_barActor;
    static boolean m_isDarkPrince;
    static int m_nSotCount;
    static int m_nBonusCount;
    static int m_posInCamera;
    static boolean m_isInAir;
    static CActorShell m_knobActor;
    static int m_tickInvincible;
    static int m_counter;
    static int m_prevTactic;
    static final int SHOW_STATUS_NONE = -3;
    static final int SHOW_STATUS_LAST_ACTION = -2;
    static final int SHOW_STATUS_INTERURPTTED = -1;
    static final int SHOW_STATUS_WAIT_FOR_KEY = 0;
    static final int SHOW_STATUS_CONTINUEED = 1;
    static int m_otherCamera;
    static int m_tickCombo;
    static boolean m_isAutomaticBar;
    static CActorShell m_waterActor;
    static CActorShell m_leftCombatActor;
    static CActorShell m_rightCombatActor;
    static CActorShell m_ropeActor;
    static CActorShell m_rushEnemyAxe;
    static final int TIME_WALLING = 12;

    void Initialize() {
        this.m_blood = 60;
        m_nMaxBlood = 60;
        m_lastBarActorID = -1;
        m_tickCombo = -1;
        m_indicator = this.AllocActor(9, 7, false, 0, 0);
        m_chainGrabActor = null;
        m_barActor = null;
        m_ropeActor = null;
        m_leftCombatActor = null;
        m_rightCombatActor = null;
        m_otherCamera = 0;
        super.Initialize();
        this.ChangePrince(this.m_classID == 8);
        this.DragToGround();
        m_isSwordInHand = false;
        this.SetTactic(0);
        this.SetAnimAction(this.m_nextAction);
        this.UpdateCamera();
    }

    void UpdatePrinceAI() {
        ++this.m_timer;
        switch (this.m_currentTactic) {
            case 2: {
                this.AiRun();
                break;
            }
            case 15: {
                this.AiAttack();
                break;
            }
            case 1: {
                this.AiWaitSword();
                break;
            }
            case 3: {
                this.AiJump();
                break;
            }
            case 11: {
                this.AiHWalling();
                break;
            }
            case 19: {
                this.AiVWalling();
                break;
            }
            case 7: {
                if (this.m_animActionID == 18) {
                    int n = this.m_x;
                    int n2 = this.m_y;
                    CGame.CheckEnv(0);
                    if (s_bBlockedFront || s_bBlockedTop) {
                        this.m_x = n;
                        this.m_y = n2;
                        this.m_nextAction = 19;
                        this.SetFlag(0x40008000);
                        break;
                    }
                    this.CanAttackEnemy(-1);
                    CActorShell cActorShell = this.GetBlockWalkableActor(this.TestFlag(-2147483647) ? -16 : 16);
                    if (cActorShell != null) {
                        cActorShell.m_x = cActorShell.GetPosAfterCollision(this);
                    }
                    if (!this.TestFlag(0x48000000)) break;
                    this.SetTactic(0);
                    this.SetActionWithCollision(this.m_nextAction, (short)8214, (short)-1);
                    break;
                }
                if (this.m_animActionID != 19 || !this.TestFlag(0x48000000)) break;
                this.SetTactic(6);
                break;
            }
            case 12: {
                this.AiDefend();
                break;
            }
            case 13: {
                if (this.CanAssissinEnemy(m_isDarkPrince ? 34 : 1)) {
                    return;
                }
                if (!this.TestFlag(0x48000000)) break;
                m_isSwordInHand = false;
                this.SetTactic(this.GetActorInfo((short)8192));
                break;
            }
            case 5: {
                if (this.HandleInAirCommon()) break;
                if (this.m_animActionID == 16) {
                    if (!m_isDarkPrince || !CGame.IsKeyPressed(16384) || !this.TrySwing(null)) break;
                    break;
                }
                if (this.m_animActionID != 83 || !this.TestFlag(0x48000000)) break;
                this.ClearFlag(0x42000000);
                this.m_nextAction = 15;
                break;
            }
            case 6: {
                this.AiHang();
                break;
            }
            case 16: {
                this.AiHurt();
                break;
            }
            case 9: {
                if (!this.TestFlag(0x48000000)) break;
                this.TurnAround();
                int n = (this.GetActorInfo((short)8214) - this.GetActorInfo((short)8215)) / 2;
                this.m_x += -n << 8;
                this.SetFlag(0x40000400);
                this.SetFlag(0x40001000);
                this.SetTactic(3);
                this.ClearFlag(0x41000000);
                if (this.TestFlag(0x40000100)) {
                    this.ClearFlag(0x40000100);
                    this.m_nextAction = 11;
                    break;
                }
                this.m_nextAction = 8;
                break;
            }
            case 10: {
                this.AiRope();
                break;
            }
            case 4: {
                if (this.m_animActionID == 13 || this.m_animActionID == 14) {
                    if (this.TestFlag(0x40800000)) {
                        this.SetTactic(8);
                        break;
                    }
                    m_specialFlags |= 4;
                    if (CGame.IsKeyPressed(97)) {
                        CGame.CheckEnv(0);
                        if (s_bBlockedTop) break;
                        this.SetTactic(0);
                        break;
                    }
                    if (CGame.IsKeyPressed(2 | this.GetDirectionKey(true))) {
                        this.m_nextAction = 20;
                        m_specialFlags |= 5;
                        break;
                    }
                    if (CGame.IsKeyPressed(this.GetDirectionKey(false))) {
                        this.TurnAround();
                        break;
                    }
                    if (!CGame.IsKeyPressed(16384)) break;
                    CGame.CheckEnv(0);
                    if (s_bBlockedTop) break;
                    this.SetTactic(15);
                    break;
                }
                if (this.m_animActionID != 20) break;
                m_specialFlags |= 5;
                if (!this.TestFlag(0x48000000)) break;
                if (m_rushEnemyAxe != null) {
                    this.SetFaceTo(m_rushEnemyAxe);
                    this.SetTactic(15);
                    CPrince.m_rushEnemyAxe.m_enemyInvincible = false;
                    break;
                }
                this.m_nextAction = m_isSwordInHand ? 14 : 13;
                break;
            }
            case 21: {
                this.AiWait();
                if (!this.TestFlag(0x48000000)) break;
                this.SetTactic(0);
                break;
            }
            case 20: {
                m_specialFlags |= 6;
                if (CGame.IsKeyHold(this.GetDirectionKey(false))) break;
                this.SetTactic(1);
                break;
            }
            case 23: {
                this.AiFlyReady(false);
                break;
            }
            case 24: {
                if (this.HandleInAirCommon()) {
                    this.SetFlag(0x42000000);
                    m_chainGrabActor = null;
                    break;
                }
                if (this.m_timer <= this.GetActorInfo((short)8198)) break;
                m_barActor = m_chainGrabActor;
                m_chainGrabActor = null;
                this.SetTactic(25);
                break;
            }
            case 14: {
                m_tickInvincible = 5;
                if (!this.TestFlag(0x48000000)) break;
                if (this.m_animActionID == 33) {
                    this.ChangePrince(!m_isDarkPrince);
                    this.m_nextAction = 34;
                    break;
                }
                this.SetTactic(0);
                m_tickInvincible = 0;
                this.SetFlag(-2147483584);
                break;
            }
            case 17: {
                this.AiAssassin();
                break;
            }
            case 0: {
                this.AiWait();
                break;
            }
            case 25: {
                this.AiOnBar();
                break;
            }
            case 26: {
                this.AiShow();
                break;
            }
            case 27: {
                if (m_barActor != null) {
                    this.SetTactic(25);
                } else {
                    CGame.CheckEnv(0);
                    if (s_bBlockedFront) {
                        this.SetTactic(5);
                        this.m_y += 20480;
                    }
                }
                if (this.m_timer % 5 != 0 || CGame.m_curLevel >= 2) break;
                this.AllocActor(35, 1, this.TestFlag(-2147483647), 0, 0);
                break;
            }
            case 29: {
                if (CPrince.m_chainGrabActor.m_animActionID != 17 && CPrince.m_chainGrabActor.m_animActionID != 15) break;
                m_chainGrabActor = null;
                this.SetTactic(0);
                break;
            }
            case 30: {
                if (!this.TestFlag(0x48000000)) break;
                this.SetTactic(1);
                break;
            }
            case 8: {
                this.AiSmallCombo();
                break;
            }
            case 31: {
                if (this.TestFlag(0x48000000)) {
                    this.SetTactic(1);
                    m_assassinActor = null;
                    m_chainGrabActor = null;
                    break;
                }
                if (!m_isDarkPrince) {
                    this.m_x = this.StickFrontTo(m_assassinActor);
                    if (CPrince.m_assassinActor.m_classID != 1) break;
                    CGame.m_bShowMap = this.m_actionSequenceID != 13;
                    break;
                }
                if (this.m_actionSequenceID < 8) break;
                m_chainGrabActor = m_assassinActor;
                break;
            }
            case 32: {
                if (this.m_animActionID == 5) {
                    if (this.XDistanceToActor(m_assassinActor) > 20) break;
                    if (CPrince.m_assassinActor.m_classID == 3) {
                        this.SetTactic(26);
                        this.m_nextAction = 86;
                        m_assassinActor.SetActorInfo((short)8196, 3);
                        m_assassinActor.SetEnemyTactic(12);
                        break;
                    }
                    this.m_x = this.StickFrontTo(m_assassinActor);
                    this.m_nextAction = 61;
                    m_specialFlags &= 0xFFFFFFF7;
                    break;
                }
                if (this.TestFlag(0x48000000)) {
                    this.SetTactic(1);
                    this.m_x += (this.GetActorInfo((short)8214) + this.GetActorInfo((short)8215) << 8) / 2;
                    break;
                }
                if (this.m_actionSequenceID != 5) break;
                this.AllocActor(14, 12, this.TestFlag(-2147483647), 0, 0);
                CGame.playtwo();
                CPrince.m_assassinActor.m_currentTactic = 10;
                m_assassinActor = null;
                break;
            }
            case 34: {
                m_specialFlags |= 6;
                m_indicator.ClearFlag(0x40000100);
                CPrince.m_indicator.m_y = this.m_y + -20480;
                CPrince.m_indicator.m_x = this.m_x;
                m_indicator.SetAnimAction(3);
                if (m_assassinActor == null || CPrince.m_assassinActor.m_blood <= 0) {
                    this.SetTactic(1);
                    break;
                }
                if (this.m_animActionID == 116) {
                    this.m_x = this.StickBackTo(m_assassinActor);
                    if (!this.TestFlag(0x48000000)) break;
                    this.TurnAround();
                    this.m_x += (this.GetActorInfo((short)8214) + this.GetActorInfo((short)8215) << 8) / 2;
                    this.SetTactic(1);
                    m_assassinActor = null;
                    break;
                }
                if (this.m_animActionID != 120) break;
                this.SetFaceTo(m_assassinActor);
                this.m_x = this.StickFrontTo(m_assassinActor);
                CGame.CheckEnv(0);
                if (s_bBlockedBack) {
                    CPrince.m_assassinActor.m_x = m_assassinActor.StickFrontTo(this);
                }
                if (CGame.IsKeyPressed(this.GetJumpKey(true) | 1)) {
                    CGame.ShowPrinceActionName(79);
                    m_assassinActor.SetAnimAction(37);
                    this.m_nextAction = 116;
                    this.SetFlag(0x44000000);
                    m_specialFlags = 0;
                    break;
                }
                m_indicator.SetFlag(0x40000100);
                break;
            }
            case 39: {
                m_specialFlags |= 6;
                if (m_rushEnemyAxe != null && CPrince.m_rushEnemyAxe.m_animActionID == 30) {
                    this.SetFaceTo(m_rushEnemyAxe);
                    this.m_x = this.StickFrontTo(m_rushEnemyAxe);
                    CGame.CheckEnv(0);
                    if (s_bBlockedBack) {
                        CPrince.m_rushEnemyAxe.m_x = m_rushEnemyAxe.StickFrontTo(this);
                    }
                    if (!CGame.IsKeyPressed(2)) break;
                    this.SetTactic(4);
                    break;
                }
                if (CPrince.m_rushEnemyAxe.m_animActionID == 30) break;
                this.ClearFlag(0x40800000);
                this.SetTactic(0);
                break;
            }
            case 33: {
                int n = this.GetActorInfo((short)8203) << 8;
                int n3 = this.GetActorInfo((short)8204) << 8;
                if (this.m_x < n) {
                    this.m_x = n;
                } else if (this.m_x > n3) {
                    this.m_x = n3;
                }
                this.m_y = this.GetActorInfo((short)8206) << 8;
                m_specialFlags |= 1;
                if (m_isDarkPrince && CGame.IsKeyPressed(16384) && this.TrySwing(null)) {
                    this.SetActionWithCollision(this.m_nextAction, (short)-1, (short)8221);
                    this.m_y -= 5120;
                    this.AiFlyReady(true);
                    break;
                }
                if (this.m_animActionID == 67) {
                    if (CGame.IsKeyPressed(this.GetDirectionKey(true)) || CGame.IsKeyHold(this.GetDirectionKey(true))) {
                        this.m_nextAction = 68;
                        break;
                    }
                    if (CGame.IsKeyPressed(this.GetDirectionKey(false))) {
                        this.TurnAround();
                        break;
                    }
                    if (CGame.IsKeyPressed(16384)) {
                        this.m_nextAction = 63;
                        break;
                    }
                    if (CGame.IsKeyPressed(2) || m_ropeActor == null) {
                        this.SetTactic(5);
                        this.SetAnimAction(this.m_nextAction);
                        this.m_y += 20 - this.GetActorInfo((short)8221) << 8;
                        this.TryDropFromRope();
                        break;
                    }
                    if (!CGame.IsKeyPressed(1)) break;
                    this.m_nextAction = 123;
                    break;
                }
                if (this.m_animActionID == 68) {
                    if (this.TryDropFromRope()) {
                        // empty if block
                    }
                    if (!CGame.IsKeyHold(this.GetDirectionKey(true))) {
                        this.m_nextAction = 67;
                    }
                    if (this.m_timer % 5 != 0 || CGame.m_curLevel >= 2) break;
                    this.AllocActor(35, 1, this.TestFlag(-2147483647), 0, 0);
                    break;
                }
                if (this.m_animActionID == 63) {
                    this.CanAttackEnemy(99);
                    if (!this.TestFlag(0x48000000)) break;
                    this.m_nextAction = 67;
                    break;
                }
                if (this.m_animActionID != 123 || !this.TestFlag(0x48000000)) break;
                this.m_nextAction = 67;
                break;
            }
            case 35: {
                if (this.TestFlag(0x40020000)) {
                    this.ClearFlag(0x40020000);
                    this.SetFlag(0x40001000);
                    this.SetTactic(3);
                    this.m_nextAction = 8;
                    break;
                }
                if (this.m_animActionID == 94 || this.m_animActionID == 98) {
                    if (this.TestFlag(0x48000000)) {
                        this.m_nextAction = 13;
                        break;
                    }
                    this.CanAttackEnemy(-1);
                    break;
                }
                if (!CGame.IsKeyPressed(16384)) break;
                this.m_nextAction = m_isDarkPrince ? 98 : 94;
                break;
            }
            case 36: {
                if (this.m_timer <= 1) {
                    m_counter = 0;
                    m_indicator.SetFlag(0x40000100);
                    CPrince.m_indicator.m_y = this.m_y + -20480;
                    CPrince.m_indicator.m_x = this.m_x;
                    m_indicator.SetAnimAction(6);
                } else if (this.m_timer > 20) {
                    m_indicator.ClearFlag(0x40000100);
                    CActorShell cActorShell = this.GetNearestActor(47, 0, 0, 0, 0);
                    if (m_counter >= 3) {
                        this.SetTactic(0);
                        cActorShell.SetAnimAction(8);
                        cActorShell.m_timer = 0;
                        this.m_nextAction = 60;
                        this.SetTactic(38);
                    } else {
                        this.m_nextAction = 122;
                        this.SetFlag(0x44000000);
                        cActorShell.SetAnimAction(20);
                        cActorShell.SetFlag(0x44000000);
                    }
                } else if (CGame.IsKeyPressed(16384)) {
                    ++m_counter;
                }
                if (this.m_animActionID != 122 || !this.TestFlag(0x48000000)) break;
                CGame.PlaySound(1);
                CGame.ChangeState(24);
                break;
            }
            case 38: {
                if (this.m_animActionID == 131) {
                    m_otherCamera |= 0x3000000;
                    m_specialFlags = 0;
                    if (this.m_x >> 8 >= CGame.m_cameraLeft - 40) break;
                    CGame.ChangeState(24);
                    break;
                }
                if (this.m_animActionID != 60 || !this.TestFlag(0x48000000)) break;
                this.SetTactic(0);
                break;
            }
            case 40: {
                m_specialFlags |= 2;
                if (this.m_animActionID == 116) {
                    m_specialFlags |= 4;
                    this.m_x = this.StickBackTo(m_assassinActor);
                    if (!this.TestFlag(0x48000000)) break;
                    this.TurnAround();
                    this.m_x += (this.GetActorInfo((short)8214) + this.GetActorInfo((short)8215) << 8) / 2;
                    this.SetTactic(1);
                    m_assassinActor = null;
                    break;
                }
                if (this.m_animActionID != 60 && this.m_animActionID != 119 || !this.TestFlag(0x48000000)) break;
                this.SetTactic(0);
                break;
            }
        }
    }

    void SetTactic(int n) {
        CGame.SetSlowMotion(false);
        if (this.m_currentTactic == 29) {
            m_chainGrabActor = null;
        }
        boolean bl = m_isInAir;
        m_isInAir = false;
        m_prevTactic = this.m_currentTactic;
        this.m_currentTactic = n;
        this.m_timer = 0;
        m_specialFlags = 8;
        this.SetFlag(0x44000000);
        this.ClearFlag(-2147483584);
        m_posInCamera = 1549;
        switch (n) {
            case 0: {
                CGame.m_bShowMap = true;
                this.ClearFlag(0x44000000);
                if (m_isSwordInHand) {
                    this.SetTactic(1);
                } else {
                    this.m_nextAction = m_isDarkPrince ? 3 : 1;
                }
                m_specialFlags |= 6;
                break;
            }
            case 1: {
                if (m_isDarkPrince) {
                    m_isSwordInHand = false;
                    this.SetTactic(0);
                    return;
                }
                m_isSwordInHand = true;
                this.ClearFlag(0x44000000);
                this.m_nextAction = 2;
                m_specialFlags |= 6;
                break;
            }
            case 2: {
                this.m_nextAction = m_isSwordInHand ? 5 : 4;
                this.ClearFlag(0x44000000);
                this.ClearFlag(0x40010000);
                m_specialFlags |= 5;
                break;
            }
            case 11: {
                this.SetActorInfo((short)8194, this.m_y >> 8);
                m_isInAir = true;
                this.m_nextAction = 27;
                m_posInCamera |= 0x2000000;
                break;
            }
            case 3: {
                if (m_isSwordInHand) {
                    m_specialFlags |= 2;
                    this.m_nextAction = 58;
                    return;
                }
                this.SetActorInfo((short)8194, this.m_y >> 8);
                if (this.TestFlag(0x40001000)) {
                    m_isInAir = true;
                    this.SetFlag(0x41000000);
                    this.ClearFlag(0x40001000);
                    return;
                }
                this.ClearFlag(0x41000000);
                this.SetFlag(0x40000400);
                int n2 = this.GetJumpPos();
                if (n2 == -1 || n2 == -3) {
                    this.m_nextAction = 6;
                    break;
                }
                if (n2 < 0) break;
                this.m_x = n2 - this.GetActorInfo((short)8214) << 8;
                this.m_nextAction = 7;
                break;
            }
            case 15: {
                CActorShell cActorShell;
                m_specialFlags |= 5;
                m_isSwordInHand = !m_isDarkPrince;
                CActorShell cActorShell2 = cActorShell = this.TestFlag(-2147483647) ? m_leftCombatActor : m_rightCombatActor;
                if (!m_isDarkPrince && cActorShell != null && cActorShell.m_classID == 2 && cActorShell.m_animActionID != 34 && cActorShell.m_animActionID != 35) {
                    CGame.playone();
                    this.m_nextAction = 117;
                    cActorShell.SetAnimAction(38);
                } else {
                    this.m_nextAction = m_isDarkPrince ? 98 : 94;
                }
                this.StartRecordCombo(this.m_nextAction + 1);
                break;
            }
            case 4: {
                m_isSwordInHand = m_isDarkPrince ? false : m_isSwordInHand;
                int n3 = this.m_nextAction = m_isSwordInHand ? 14 : 13;
                if (!m_isDarkPrince) break;
                if (m_rushEnemyAxe != null && this.IsFaceTo(m_rushEnemyAxe)) {
                    this.m_nextAction = 20;
                    this.clearIndicator();
                    break;
                }
                this.StartRecordCombo(107);
                break;
            }
            case 13: {
                this.m_nextAction = 32;
                break;
            }
            case 19: {
                m_posInCamera = 1549;
                m_isInAir = true;
                this.m_x = s_vWallingLineX - (this.GetActorInfo((short)8214) << 8);
                this.SetActionWithCollision(28, (short)8214, (short)-1);
                break;
            }
            case 7: {
                m_tickInvincible = 15;
                m_specialFlags = 0;
                this.m_nextAction = this.GetActorInfo((short)8193);
                this.SetFlag(0x42000000);
                this.SetAnimAction(this.m_nextAction);
                if (this.m_nextAction != 19) break;
                this.SetFlag(0x40008000);
                break;
            }
            case 10: {
                CGame.GetActorActivateBoxInfo(CPrince.m_ropeActor.m_actorID, s_colBox1);
                this.SetActorInfo((short)8203, s_colBox1[1]);
                if (this.m_y < s_colBox1[1] << 8) {
                    this.m_y = s_colBox1[1] << 8;
                }
                m_isInAir = true;
                m_specialFlags = 0;
                this.SetActionWithCollision(25, (short)-1, (short)8221);
                this.m_nextAction = 25;
                m_posInCamera = 2055;
                this.ClearFlag(0x40000200);
                break;
            }
            case 21: {
                short s = this.GetActorInfo((short)8194);
                int n4 = this.m_y >> 8;
                this.m_y &= 0xFFFF00;
                if (m_waterActor == null) {
                    this.AllocActor(14, 1, this.TestFlag(-2147483647), 0, 0);
                }
                if (n4 - s > 140) {
                    this.BeAttacked(this, 15);
                    CGame.m_isRepaintInterface = true;
                    CGame.m_actSOT.SetFlag(0x40004000);
                }
                if (n4 - s > 200 || this.m_blood <= 0) {
                    this.BeAttacked(this, this.m_blood);
                    this.m_nextAction = 41;
                    CGame.m_actSOT.SetFlag(0x40004000);
                    return;
                }
                if (this.TestFlag(0x40100000)) {
                    this.m_nextAction = 76;
                    this.ClearFlag(0x40100000);
                    break;
                }
                this.m_nextAction = 12;
                break;
            }
            case 17: {
                m_specialFlags = 0;
                this.m_z -= 10;
                short s = this.GetActorInfo((short)8196);
                switch (s) {
                    case 2: {
                        m_isInAir = true;
                        this.m_nextAction = 74;
                        this.SetAnimAction(this.m_nextAction);
                        this.m_vX = (CPrince.m_assassinActor.m_x - this.m_x) / 4;
                        this.m_vY = (CPrince.m_assassinActor.m_y - this.m_y + (m_assassinActor.GetActorInfo((short)8221) - this.GetActorInfo((short)8223) << 8)) / 4;
                        break;
                    }
                    case 1: {
                        this.m_nextAction = 90;
                        break;
                    }
                    case 0: {
                        if (CPrince.m_assassinActor.m_classID == 3) {
                            this.m_nextAction = 81;
                            break;
                        }
                        this.m_nextAction = 77;
                        break;
                    }
                    case 4: {
                        this.m_nextAction = 79;
                        this.ClearFlag(0x42000000);
                        break;
                    }
                    case 3: {
                        this.m_nextAction = 80;
                        this.SetActionWithCollision(this.m_nextAction, (short)-1, (short)8221);
                        m_posInCamera = 1543;
                        if (this.TestFlag(-2147483647) == m_assassinActor.TestFlag(-2147483647)) break;
                        this.TurnAround();
                        break;
                    }
                    case 5: {
                        m_assassinActor.SetEnemyTactic(24);
                        m_chainGrabActor = m_assassinActor;
                        this.m_nextAction = 42;
                        this.m_vX = (CPrince.m_assassinActor.m_x - this.m_x + (m_assassinActor.GetActorInfo((short)8215) << 8)) / 5;
                        this.m_vY = (CPrince.m_assassinActor.m_y - this.m_y) / 5;
                        this.SetActorInfo((short)8198, 5);
                        this.ClearFlag(0x42000000);
                        this.SetFaceDir(CPrince.m_assassinActor.m_x - this.m_x);
                    }
                }
                break;
            }
            case 14: {
                m_tickInvincible = 15;
                this.SetAnimAction(33);
                this.m_nextAction = 33;
                m_chainGrabActor = null;
                CGame.PlaySound(0);
                break;
            }
            case 5: {
                m_isInAir = true;
                m_specialFlags = 0;
                this.m_nextAction = 15;
                if (this.m_vX == 0) {
                    this.ClearFlag(0x40000400);
                } else {
                    this.SetFlag(0x40000400);
                }
                this.SetActorInfo((short)8194, (this.m_y >> 8) + this.GetActorInfo((short)8223));
                break;
            }
            case 23: {
                this.m_nextAction = bl ? this.GetSwingAction() : this.GetSwingReadyAction();
                this.ClearFlag(0x42000000);
                break;
            }
            case 24: {
                m_isInAir = true;
                this.SetActorInfo((short)8194, this.m_y >> 8);
                this.ClearFlag(0x42000000);
                this.m_nextAction = this.GetSwingAction();
                break;
            }
            case 16: {
                m_specialFlags |= 2;
                m_tickInvincible = 15;
                break;
            }
            case 20: {
                this.ClearFlag(0x44000000);
                m_specialFlags |= 2;
                this.m_nextAction = 40;
                break;
            }
            case 6: {
                m_isInAir = true;
                m_specialFlags = 0;
                this.m_nextAction = 17;
                break;
            }
            case 12: {
                this.m_nextAction = m_isDarkPrince ? 30 : 29;
                this.ClearFlag(0x44000000);
                this.ClearFlag(0x40080000);
                m_tickInvincible = 15;
                break;
            }
            case 25: {
                m_isInAir = true;
                m_posInCamera = 1545;
                m_lastBarActorID = CPrince.m_barActor.m_actorID;
                this.ClearFlag(0x44000000);
                this.SetFlag(0x42000000);
                this.m_nextAction = 53;
                this.m_x = CPrince.m_barActor.m_x;
                this.m_y = CPrince.m_barActor.m_y;
                this.ClearFlag(0x40000200);
                this.ClearFlag(0x40020000);
                this.SetFlag(0x41000000);
                m_isAutomaticBar = false;
                if (m_barActor.GetActorInfo((short)16395) == 1) {
                    if (m_barActor.GetActorInfo((short)16394) == 1 != this.TestFlag(-2147483647)) {
                        this.SetFlag(0x40000200);
                    } else {
                        this.ClearFlag(0x40000200);
                    }
                    m_isAutomaticBar = true;
                }
                if (m_barActor.GetActorInfo((short)16396) == 1) {
                    this.SetFlag(0x40002000);
                } else {
                    this.ClearFlag(0x40002000);
                }
                this.SetActorInfo((short)8205, CPrince.m_barActor.m_actorID);
                m_specialFlags = 0;
                break;
            }
            case 26: {
                this.StartShow(true);
                m_specialFlags = 0;
                break;
            }
            case 27: {
                m_posInCamera = 1538;
                this.m_nextAction = 56;
                this.SetAnimAction(this.m_nextAction);
                this.ClearFlag(0x44000000);
                break;
            }
            case 29: {
                this.m_nextAction = 57;
                break;
            }
            case 30: {
                this.m_nextAction = 59;
                this.SetAnimAction(this.m_nextAction);
                break;
            }
            case 8: {
                this.m_nextAction = this.GetActorInfo((short)8200);
                m_specialFlags |= 1;
                this.ClearFlag(0x40800000);
                break;
            }
            case 31: {
                CGame.m_scoreArray[2] = CGame.m_scoreArray[2] + 1;
                m_specialFlags = 0;
                this.AllocActor(23, 0, false, 0, 0);
                break;
            }
            case 32: {
                this.m_nextAction = 5;
                break;
            }
            case 34: {
                this.m_nextAction = 120;
                this.SetAnimAction(this.m_nextAction);
                this.ClearFlag(0x44000000);
                break;
            }
            case 39: {
                this.m_nextAction = 120;
                this.SetAnimAction(this.m_nextAction);
                this.ClearFlag(0x44000000);
                break;
            }
            case 33: {
                int n5 = this.GetActorInfo((short)8203) << 8;
                int n6 = this.GetActorInfo((short)8204) << 8;
                if (this.m_x <= n5) {
                    this.m_x = n5 + 256;
                } else if (this.m_x >= n6) {
                    this.m_x = n6 - 256;
                }
                m_specialFlags |= 1;
                this.m_nextAction = 67;
                this.SetAnimAction(this.m_nextAction);
                this.ClearFlag(0x44000000);
                m_posInCamera = 1538;
                break;
            }
            case 35: {
                this.m_nextAction = 13;
                this.SetAnimAction(this.m_nextAction);
                m_specialFlags = 0;
                break;
            }
            case 38: {
                m_specialFlags = 0;
            }
        }
    }

    void Update() {
        if (CGame.m_currentTrailerIndex >= 0 && (CGame.m_currentTrailerCamera.GetActorInfo((short)16394) == 0 || CGame.m_currentTrailerCamera.GetActorInfo((short)16394) == 3)) {
            return;
        }
        if ((CGame.m_currentTrailerIndex >= 0 || (m_otherCamera & Integer.MIN_VALUE) != 0) && this.m_y >> 8 > CGame.m_cameraTop + 375 && this.m_blood > 0) {
            this.BeAttacked(this, this.m_blood);
        }
        if (m_tickInvincible > 0) {
            --m_tickInvincible;
        }
        if (m_tickCombo > 0) {
            --m_tickCombo;
            if (CGame.IsKeyPressed(16384)) {
                m_tickCombo = -1;
                this.SetFlag(0x40800000);
            }
        }
        boolean bl = this.TestFlag(-2147483647);
        this.m_nextAction = this.m_animActionID;
        if (CGame.IsKeyPressed(1024)) {
            if (CGame.m_bUsingSOT) {
                CGame.SetSandOfTimeStatus(false);
            } else if (m_nSotCount > 0) {
                m_nSotCount = 0;
                CGame.SetSandOfTimeStatus(true);
            }
        }
        this.UpdatePrinceAI();
        if (this.m_nextAction != this.m_animActionID || (bl ^ this.TestFlag(-2147483647)) != this.TestFlag(0x40040000)) {
            this.SetAnimAction(this.m_nextAction);
        }
        boolean bl2 = false;
        if ((m_specialFlags & 7) != 0) {
            CGame.CheckEnv(0);
            if ((m_specialFlags & 1) != 0 && s_bBlockedFront) {
                bl2 = true;
            }
            if ((m_specialFlags & 2) != 0 && s_bBlockedBack) {
                bl2 = true;
            }
            if ((m_specialFlags & 4) != 0) {
                if (s_bInDeadZone) {
                    this.BeAttacked(this, this.m_blood);
                    this.SetAnimAction(41);
                } else if (!s_bBlockedBottom) {
                    this.SetTactic(5);
                    this.SetAnimAction(15);
                } else if (s_bCanClimbDown && !s_bBlockedBottomCenter) {
                    this.SetFaceDir(s_climbdownFaceDir);
                    this.m_x = s_climbdownPointX;
                    this.m_y = s_climbdownPointY;
                    this.SetActorInfo((short)8193, 19);
                    this.TryDrawInSword(7);
                    this.SetAnimAction(this.m_nextAction);
                }
            }
        }
        if ((m_specialFlags & 8) != 0) {
            CActorShell cActorShell;
            int n = this.m_vX >> 8;
            if (n == 0) {
                int n2 = n = this.TestFlag(-2147483647) ? -1 : 1;
            }
            if ((cActorShell = this.GetBlockWalkableActor(n)) != null && (m_rushEnemyAxe == null || cActorShell != m_rushEnemyAxe || this.m_animActionID != 20 || m_prevTactic != 39 && CPrince.m_rushEnemyAxe.m_animActionID != 12 || CPrince.m_rushEnemyAxe.m_currentTactic != 15)) {
                if (this.m_currentTactic == 10 || this.m_animActionID == 72) {
                    if (this.m_y < cActorShell.m_y && this.m_vY >= 0) {
                        this.m_y = cActorShell.m_y - (this.GetActorInfo((short)8223) << 8);
                    } else if (this.m_y > cActorShell.m_y && this.m_vY <= 0) {
                        this.m_y = cActorShell.m_y + (cActorShell.GetActorInfo((short)8223) << 8);
                    }
                } else if (bl2) {
                    cActorShell.m_x = cActorShell.GetPosAfterCollision(this);
                } else {
                    this.m_x = this.GetPosAfterCollision(cActorShell);
                }
                bl2 = true;
            }
        }
        if (this.m_vX != 0 || this.m_vY != 0) {
            if ((m_specialFlags & 0x10) == 0) {
                this.ApplyVelocityWithCollision(bl2 ? 0 : this.m_vX, this.m_vY);
            } else {
                this.m_x += this.m_vX;
                this.m_y += this.m_vY;
            }
        }
        this.m_vX += this.m_aX;
        this.m_vY += this.m_aY;
        this.UpdateCamera();
        m_leftObjective = null;
        m_rightObjective = null;
        m_leftCombatActor = null;
        m_rightCombatActor = null;
        m_justAttackedEnemy = null;
        m_barActor = null;
        m_ropeActor = null;
        m_waterActor = null;
        m_rushEnemyAxe = null;
    }

    void UpdateCamera() {
        int n;
        if (this.m_currentTactic == 26) {
            m_otherCamera = 0x3000000;
            m_leftCombatActor = null;
            m_rightCombatActor = null;
        }
        int n2 = m_otherCamera & 0xFF000000;
        if (m_otherCamera != 0 && n2 == 0) {
            n2 = m_otherCamera;
        } else {
            n2 |= ((m_otherCamera & 0xFF) != 0 ? m_otherCamera : m_posInCamera) & 0xFF;
            n2 |= ((m_otherCamera & 0xFF00) != 0 ? m_otherCamera : m_posInCamera) & 0xFF00;
        }
        if ((n2 & 0xFF000000) == 0x2000000) {
            n = CGame.m_cameraCenterY;
        } else {
            n = (this.m_y >> 8) - ((n2 & 0xFF) - 8) * 18;
            if ((n2 & Integer.MIN_VALUE) != 0 && CGame.m_cameraCenterY < n) {
                n = CGame.m_cameraCenterY;
            }
        }
        if (!(m_leftCombatActor == null && m_rightCombatActor == null || CGame.m_bSurviveMode)) {
            int n3 = m_leftCombatActor == null ? CPrince.m_rightCombatActor.m_x + this.m_x >> 9 : (m_rightCombatActor == null ? CPrince.m_leftCombatActor.m_x + this.m_x >> 9 : this.m_x >> 8);
            CGame.setCameraCenter(n3, n);
        } else {
            int n4;
            int n5 = n4 = (n2 & 0x1000000) != 0 ? (this.m_x >> 8) - CGame.m_cameraCenterX : ((n2 & 0xFF00) - 2048 >> 8) * 15;
            if ((n2 & 0x1000000) == 0 && (m_otherCamera & 0xFF00) == 0 && this.TestFlag(-2147483647)) {
                n4 = -n4;
            }
            CGame.setCameraCenter((this.m_x >> 8) - n4, n);
        }
        m_otherCamera = 0;
    }

    void AiWait() {
        CGame.CheckEnv(0);
        boolean bl = m_leftCombatActor != null || m_rightCombatActor != null;
        if (this.CanAssissinEnemy(m_isDarkPrince ? 34 : 1)) {
            return;
        }
        if (CGame.IsKeyPressed(2)) {
            if (!(!s_bCanClimbDown || s_bBlockedBottomFront && s_bBlockedBottomBack)) {
                this.SetFaceDir(s_climbdownFaceDir);
                this.m_x = s_climbdownPointX;
                this.m_y = s_climbdownPointY;
                this.SetActorInfo((short)8193, 19);
                this.SetTactic(7);
            } else {
                this.SetTactic(4);
            }
            return;
        }
        if (CGame.IsKeyPressed(this.GetDirectionKey(true)) || CGame.IsKeyHold(this.GetDirectionKey(true))) {
            System.out.println("key pressed ");
            this.SetTactic(2);
            return;
        }
        if (CGame.IsKeyPressed(this.GetDirectionKey(false))) {
            this.TurnAround();
            m_specialFlags |= 1;
            return;
        }
        if (CGame.IsKeyPressed(1 | this.GetJumpKey(true))) {
            if (!m_isDarkPrince && !m_isSwordInHand && s_bVWallingable) {
                this.SetTactic(19);
            } else {
                this.ClearFlag(0x40001000);
                this.SetTactic(3);
            }
            return;
        }
        if (CGame.IsKeyPressed(this.GetJumpKey(false))) {
            if (!bl) {
                this.TurnAround();
                this.TryDrawInSword(3);
            } else {
                m_isSwordInHand = true;
                this.SetTactic(3);
            }
            return;
        }
        if (CGame.IsKeyPressed(16384)) {
            if (m_isDarkPrince && this.TryToUseSwing()) {
                return;
            }
            this.SetTactic(15);
            return;
        }
    }

    void AiWaitSword() {
        CActorShell cActorShell;
        boolean bl = m_leftCombatActor != null || m_rightCombatActor != null;
        CActorShell cActorShell2 = this.TestFlag(-2147483647) ? m_rightCombatActor : m_leftCombatActor;
        CActorShell cActorShell3 = cActorShell = this.TestFlag(-2147483647) ? m_leftCombatActor : m_rightCombatActor;
        if (this.CanAssissinEnemy(1)) {
            return;
        }
        if (CGame.IsKeyPressed(this.GetDirectionKey(true)) || CGame.IsKeyHold(this.GetDirectionKey(true))) {
            if (bl) {
                this.SetTactic(2);
            } else {
                this.TryDrawInSword(2);
            }
            return;
        }
        if ((CGame.IsKeyPressed(this.GetJumpKey(false)) || CGame.IsKeyDblPressed(this.GetDirectionKey(false))) && cActorShell2 == null) {
            if (bl) {
                this.SetTactic(3);
            } else {
                this.TryDrawInSword(3);
            }
            return;
        }
        if (CGame.IsKeyPressed(this.GetDirectionKey(false))) {
            if (cActorShell != null) {
                this.SetTactic(20);
            } else if (cActorShell2 != null) {
                this.TurnAround();
            } else {
                this.TurnAround();
                this.TryDrawInSword(2);
            }
            return;
        }
        if (CGame.IsKeyPressed(1) || CGame.IsKeyHold(1)) {
            if (bl) {
                this.SetTactic(12);
            } else {
                this.TryDrawInSword(3);
            }
            return;
        }
        if (CGame.IsKeyPressed(this.GetJumpKey(true)) && !bl) {
            this.TryDrawInSword(3);
        }
        if (CGame.IsKeyPressed(16384)) {
            this.SetTactic(15);
            return;
        }
        if (CGame.IsKeyPressed(2)) {
            if (!(!s_bCanClimbDown || s_bBlockedBottomFront && s_bBlockedBottomBack)) {
                this.SetFaceDir(s_climbdownFaceDir);
                this.m_x = s_climbdownPointX;
                this.m_y = s_climbdownPointY;
                this.SetActorInfo((short)8193, 19);
                this.SetTactic(7);
            } else {
                this.SetTactic(4);
            }
        }
        if (CGame.IsKeyPressed(16)) {
            if (bl) {
                CActorShell cActorShell4;
                CActorShell cActorShell5 = cActorShell4 = cActorShell2 == null ? cActorShell : cActorShell2;
                if (cActorShell4 != null && (cActorShell4.m_classID == 29 || cActorShell4.m_classID == 47)) {
                    return;
                }
            }
            this.TryDrawInSword(0);
            return;
        }
    }

    void TryDrawInSword(int n) {
        if (m_isSwordInHand) {
            this.SetActorInfo((short)8192, n);
            this.SetTactic(13);
        } else {
            m_isSwordInHand = false;
            this.SetTactic(n);
        }
    }

    void AiDefend() {
        m_tickInvincible = 5;
        if (this.m_animActionID == 29 || this.m_animActionID == 30) {
            if (!CGame.IsKeyHold(1)) {
                m_tickInvincible = 0;
                this.SetTactic(0);
            }
        } else {
            m_specialFlags |= 2;
            if (this.TestFlag(0x48000000)) {
                this.SetTactic(1);
            }
        }
    }

    void AiShow() {
        short s = this.GetActorInfo((short)8199);
        if (s >= 0 && CGame.IsAnyKeyPressed()) {
            m_indicator.ClearFlag(0x40000100);
            if (CGame.IsKeyPressed(this.GetActorInfo((short)8195))) {
                this.SetActorInfo((short)8199, 1);
            } else {
                this.SetActorInfo((short)8199, -1);
            }
        }
        if (this.TestFlag(0x48000000)) {
            s = this.GetActorInfo((short)8199);
            if (s == -2) {
                this.EndShow(false);
                CGame.PlaySound(8);
            } else if (s == 1) {
                this.StartShow(false);
                this.TickShow();
            } else {
                this.EndShow(true);
            }
        } else {
            if (this.m_animActionID == 86) {
                this.m_x = this.GetPosAfterCollision(m_assassinActor);
            }
            if (this.m_animActionID == 89 && this.m_actionSequenceID == 5) {
                this.m_vX = 0;
            }
            if (this.m_animActionID == 101 && this.m_actionSequenceID == 3) {
                this.m_vX = (this.XDistanceToActor(m_assassinActor) << 8) / 8;
                this.m_vX /= 2;
                if (CPrince.m_assassinActor.m_x < this.m_x) {
                    this.m_vX = -this.m_vX;
                }
                CPrince.m_assassinActor.m_vX = -this.m_vX;
                m_chainGrabActor = m_assassinActor;
            } else if (this.m_animActionID == 102) {
                this.m_x = this.StickFrontTo(m_assassinActor);
            } else if (this.m_animActionID == 103 || this.m_animActionID == 104) {
                CPrince.m_assassinActor.m_x = m_assassinActor.StickBackTo(this);
            }
        }
    }

    void EndShow(boolean bl) {
        if (bl) {
            m_assassinActor.SetFlag(0x40001000);
        } else {
            if (this.m_animActionID == 104) {
                this.m_x += (this.GetActorInfo((short)8214) + this.GetActorInfo((short)8215) << 8) / 2;
            }
            CGame.PlaySound(8);
        }
        CGame.ChangeState(10);
        if (bl) {
            this.BeAttacked(m_assassinActor, 4);
        } else {
            this.SetTactic(1);
        }
        m_assassinActor = null;
        m_chainGrabActor = null;
        this.SetActorInfo((short)8199, -3);
        m_indicator.ClearFlag(0x40000100);
        CGame.SetSandOfTimeStatus(false);
    }

    void StartShow(boolean bl) {
        int n;
        if (bl) {
            m_indicator.ClearFlag(0x40000100);
            CGame.ChangeState(15);
        } else {
            m_indicator.SetFlag(0x40000100);
        }
        CPrince.m_indicator.m_x = this.m_x;
        CPrince.m_indicator.m_y = this.m_y + -20480;
        int n2 = n = bl ? 1 : CGame.Random(0, 1);
        m_indicator.SetAnimAction(n == 0 ? (this.TestFlag(-2147483647) ? 13 : 2) : 6);
        this.SetActorInfo((short)8195, n == 0 ? this.GetDirectionKey(true) : 16384);
        this.SetActorInfo((short)8199, 0);
    }

    void TickShow() {
        this.m_timer = 0;
        ++this.m_nextAction;
        this.SetAnimAction(this.m_nextAction);
        if (this.m_animActionID == 87) {
            this.m_x = this.StickFrontTo(m_assassinActor);
        } else if (this.m_animActionID == 88) {
            this.m_x = this.StickFrontTo(m_assassinActor);
        } else if (this.m_animActionID == 89) {
            this.m_vX = CPrince.m_assassinActor.m_x - this.m_x - (this.GetActorInfo((short)8215) << 8) >> 2;
        } else if (this.m_animActionID == 102) {
            m_chainGrabActor = null;
            this.m_x = this.StickFrontTo(m_assassinActor);
        } else if (this.m_animActionID == 103) {
            m_assassinActor.TurnAround();
            this.m_x = this.StickFrontTo(m_assassinActor);
        } else if (this.m_animActionID == 104) {
            this.m_x = this.StickFrontTo(m_assassinActor);
        }
        if (this.m_nextAction == 89 || this.m_nextAction == 104) {
            this.SetActorInfo((short)8199, -2);
            m_indicator.ClearFlag(0x40000100);
        }
    }

    void AiRun() {
        System.out.println("in runnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn ");
        CGame.CheckEnv(0);
        m_specialFlags |= 5;
        if (this.CanAssissinEnemy(m_isDarkPrince ? 34 : 1)) {
            return;
        }
        if (!m_isDarkPrince && !m_isSwordInHand && s_bVWallingable && CGame.IsKeyHold(this.GetDirectionKey(true))) {
            System.out.println(" ******************************************************************************");
            this.SetTactic(19);
            return;
        }
        if (this.TestFlag(0x48000000) && !m_isSwordInHand) {
            this.SetFlag(0x40010000);
        }
        if (!CGame.IsKeyHold(this.GetDirectionKey(true))) {
            this.SetTactic(0);
            return;
        }
    }

    void AiRope() {
        m_specialFlags = 0;
        switch (this.m_animActionID) {
            case 25: {
                m_specialFlags = 8;
                if (this.CanAssissinEnemy(8)) {
                    return;
                }
                if (CGame.IsKeyPressed(12)) {
                    this.m_nextAction = 24;
                    return;
                }
                if (CGame.IsKeyPressed(this.GetJumpKey(false)) || this.TestFlag(0x40000200)) {
                    this.ClearFlag(0x40000200);
                    this.TurnAround();
                    this.SetFlag(0x40001000);
                    this.SetFlag(0x40000400);
                    this.SetTactic(3);
                    this.m_nextAction = 11;
                    this.SetActionWithCollision(this.m_nextAction, (short)-1, (short)8221);
                    return;
                }
                if (CGame.IsKeyPressed(this.GetJumpKey(true))) {
                    this.m_nextAction = 24;
                    this.SetFlag(0x40000200);
                    return;
                }
                if (CGame.IsKeyPressed(1)) {
                    this.m_nextAction = 23;
                    this.ClearFlag(0x44000000);
                    return;
                }
                if (CGame.IsKeyPressed(2)) {
                    if (this.TryDropFromRope()) {
                        return;
                    }
                    this.m_nextAction = 26;
                    this.ClearFlag(0x44000000);
                    return;
                }
                if (!CGame.IsKeyPressed(16384)) break;
                this.m_nextAction = 63;
                break;
            }
            case 26: {
                m_specialFlags = 8;
                if (this.m_timer % 5 == 0 && CGame.m_curLevel < 2) {
                    this.AllocActor(35, 1, this.TestFlag(-2147483647), 0, 0);
                }
                if (this.TryDropFromRope()) {
                    return;
                }
                if (CGame.IsKeyHold(2)) break;
                this.m_nextAction = 25;
                break;
            }
            case 23: {
                int n = this.GetActorInfo((short)8203) << 8;
                if (this.m_y < n) {
                    this.m_y = n;
                }
                m_specialFlags = 8;
                if (this.TestFlag(0x48000000) && !CGame.IsKeyHold(1)) {
                    this.m_nextAction = 25;
                    return;
                }
                CGame.CheckEnv(0);
                if (!s_bBlockedTop) break;
                this.m_vY = 0;
                break;
            }
            case 66: {
                if (!this.TestFlag(0x48000000)) break;
                this.m_nextAction = 25;
                break;
            }
            case 24: {
                if (!this.TestFlag(0x48000000)) break;
                this.TurnAround();
                this.m_nextAction = 25;
                break;
            }
            case 63: {
                this.CanAttackEnemy(-1);
                if (!this.TestFlag(0x48000000)) break;
                this.m_nextAction = 25;
                break;
            }
            case 64: {
                if (!CGame.IsKeyPressed(16384)) break;
                this.CanAttackEnemy(10);
                m_indicator.ClearFlag(0x40000100);
                this.m_nextAction = 66;
            }
        }
    }

    boolean TryDropFromRope() {
        if (m_ropeActor == null) {
            this.SetTactic(5);
            this.SetActionWithCollision(15, (short)8214, (short)8221);
            return true;
        }
        return false;
    }

    void AiVWalling() {
        CGame.CheckEnv(0);
        if (s_bCanClimbUp) {
            this.m_x = s_climbupPointX;
            this.m_y = s_climbupPointY;
            this.SetTactic(6);
        } else if (s_bBlockedTop) {
            this.SetFlag(0x40000400);
            this.SetTactic(5);
            this.SetActionWithCollision(15, (short)8214, (short)-1);
        } else if (this.TestFlag(0x48000000)) {
            this.SetTactic(9);
            this.m_nextAction = 21;
        }
    }

    void AiHWalling() {
        if (m_barActor != null) {
            this.SetTactic(25);
            return;
        }
        this.SetActorInfo((short)8197, this.m_timer);
        this.SetFlag(0x40004000);
        if (this.m_timer < 12 && this.CanAssissinEnemy(16)) {
            return;
        }
        this.ClearFlag(0x40004000);
        if (this.m_timer >= 12) {
            m_indicator.ClearFlag(0x40000100);
        }
        if (!(this.HandleHWallingCommon() || CGame.IsKeyHold(1 | this.GetJumpKey(true)) && !this.TestFlag(0x48000000))) {
            int n = this.m_vX >>= 1;
            int n2 = this.m_vY > 0 ? this.m_vY : 0;
            this.SetTactic(5);
            m_specialFlags |= 8;
            this.SetAnimAction(this.m_nextAction);
            this.m_vX = n;
            this.m_vY = n2;
        }
    }

    boolean HandleHWallingCommon() {
        CGame.CheckEnv(0);
        if (m_ropeActor != null && CPrince.m_ropeActor.m_animActionID == 2) {
            this.m_x = CPrince.m_ropeActor.m_x;
            this.m_y = CPrince.m_ropeActor.m_y;
            this.SetTactic(27);
        } else if (!s_bHWallingable || s_bBlockedTop || s_bBlockedBottomFront) {
            this.SetTactic(5);
        } else if (s_bBlockedBottom) {
            this.SetTactic(21);
            this.SetActionWithCollision(this.m_nextAction, (short)-1, (short)8223);
        } else {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void AiAttack() {
        block15: {
            block18: {
                block27: {
                    block16: {
                        block26: {
                            block25: {
                                block19: {
                                    block21: {
                                        block23: {
                                            block24: {
                                                block22: {
                                                    block20: {
                                                        block17: {
                                                            var1_1 = this.TestFlag(-2147483647) != false ? CPrince.m_leftObjective : CPrince.m_rightObjective;
                                                            CPrince.m_specialFlags |= 1;
                                                            if (this.CanAttackEnemy(-1)) {
                                                                this.SetFlag(0x40080000);
                                                            } else if (CPrince.s_attackResult == -1 && var1_1 != null && var1_1.m_classID == 2) {
                                                                this.m_nextAction = 31;
                                                                return;
                                                            }
                                                            if (!CPrince.m_isDarkPrince && var1_1 != null) {
                                                                if (var1_1.m_animActionID == 21 || var1_1.m_animActionID == 12 && var1_1.m_actionSequenceID < 5) {
                                                                    this.SetTactic(30);
                                                                    return;
                                                                }
                                                                if (CGame.IsKeyPressed(1)) {
                                                                    this.SetTactic(12);
                                                                    return;
                                                                }
                                                                if (CGame.IsKeyPressed(this.GetJumpKey(false)) || CGame.IsKeyDblPressed(this.GetDirectionKey(false))) {
                                                                    this.SetTactic(3);
                                                                    return;
                                                                }
                                                            }
                                                            if (!this.TestFlag(0x48000000)) break block15;
                                                            if (!this.TestFlag(0x40800000) || var1_1 == null || var1_1.m_blood <= 0) ** GOTO lbl-1000
                                                            if (CPrince.m_isDarkPrince) break block16;
                                                            if (this.m_animActionID != 94) break block17;
                                                            this.m_nextAction = this.m_animActionID + 1;
                                                            this.StartRecordCombo(this.m_nextAction);
                                                            break block18;
                                                        }
                                                        if (!this.TestFlag(0x40080000)) break block19;
                                                        var2_2 = -1;
                                                        if (var1_1.m_classID != 1) break block20;
                                                        this.m_nextAction = 96;
                                                        var2_2 = 16;
                                                        break block21;
                                                    }
                                                    if (var1_1.m_classID != 3) break block22;
                                                    this.m_nextAction = 97;
                                                    var2_2 = 27;
                                                    break block21;
                                                }
                                                if (var1_1.m_classID != 2) break block23;
                                                if (this.m_animActionID != 117) break block24;
                                                this.m_nextAction = this.m_animActionID + 1;
                                                this.StartRecordCombo(119);
                                                var1_1.SetAnimAction(39);
                                                break block18;
                                            }
                                            if (this.m_animActionID != 118) break block21;
                                            this.m_nextAction = this.m_animActionID + 1;
                                            var1_1.m_nextAction = 40;
                                            var1_1.SetEnemyTactic(27);
                                            break block18;
                                        }
                                        if (var1_1.m_classID != 47) break block21;
                                        this.m_nextAction = 97;
                                        break block18;
                                    }
                                    if (var2_2 < 0) break block19;
                                    CPrince.m_assassinActor = var1_1;
                                    CPrince.m_assassinActor.ClearFlag(0x40000100);
                                    this.SetTactic(31);
                                    CGame.ShowPrinceActionName(77);
                                    CPrince.m_assassinActor.m_nextAction = var2_2;
                                    CPrince.m_assassinActor.SetEnemyTactic(27);
                                    CPrince.m_assassinActor.SetFlag(0x44000000);
                                    break block18;
                                }
                                if (var1_1.m_classID != 29) ** GOTO lbl-1000
                                if (this.m_animActionID != 95) break block25;
                                this.m_nextAction = 117;
                                this.StartRecordCombo(118);
                                break block18;
                            }
                            if (this.m_nextAction != 117) break block26;
                            this.m_nextAction = 118;
                            this.StartRecordCombo(119);
                            break block18;
                        }
                        if (this.m_nextAction != 118) ** GOTO lbl-1000
                        this.m_nextAction = 119;
                        break block18;
                    }
                    if (!this.TestFlag(0x40080000)) ** GOTO lbl-1000
                    if (this.m_animActionID != 98) break block27;
                    this.m_nextAction = this.m_animActionID + 1;
                    this.StartRecordCombo(this.m_nextAction);
                    break block18;
                }
                if (!this.TestFlag(0x40080000)) ** GOTO lbl-1000
                var2_3 = -1;
                if (var1_1.m_classID == 1 || var1_1.m_classID == 2) {
                    var2_3 = var1_1.m_classID == 2 ? 43 : 30;
                    this.m_nextAction = 100;
                    CGame.ShowPrinceActionName(78);
                    CPrince.m_assassinActor = var1_1;
                    CPrince.m_assassinActor.ClearFlag(0x40000100);
                    this.SetTactic(31);
                    CPrince.m_assassinActor.m_nextAction = var2_3;
                    CPrince.m_assassinActor.SetEnemyTactic(27);
                    CPrince.m_assassinActor.SetFlag(0x44000000);
                } else if (var1_1.m_classID == 3) {
                    CPrince.m_assassinActor = var1_1;
                    CPrince.m_assassinActor.ClearFlag(0x40000100);
                    if (var1_1.m_blood < 20) {
                        var2_3 = 7;
                        this.m_nextAction = 101;
                        CPrince.m_assassinActor.SetActorInfo((short)8196, var2_3);
                        CPrince.m_assassinActor.SetEnemyTactic(12);
                        this.SetTactic(26);
                    } else {
                        var2_3 = 29;
                        this.m_nextAction = 106;
                        CPrince.m_specialFlags &= -5;
                        CPrince.m_assassinActor.m_nextAction = var2_3;
                        CPrince.m_assassinActor.SetEnemyTactic(27);
                    }
                } else if (var1_1.m_classID == 47) {
                    this.m_nextAction = 106;
                } else lbl-1000:
                // 6 sources

                {
                    this.SetTactic(1);
                    this.SetActionWithCollision(this.m_nextAction, (short)8214, (short)-1);
                    CGame.InitKey();
                }
            }
            this.ClearFlag(0x40080000);
            this.ClearFlag(0x40800000);
        }
    }

    boolean CanAttackEnemy(int n) {
        if (n < 0) {
            n = CGame.Random(2, 9);
        }
        this.GetActorBoxInfo(2, s_colBox1);
        if (m_leftObjective != null) {
            m_leftObjective.GetActorBoxInfo(1, s_colBox2);
            if (CGame.IsIntersecting(s_colBox1, s_colBox2) && (0 == (8 & CGame.m_classesFlags[CPrince.m_leftObjective.m_classID]) || CGame.TestConnectivity(CPrince.m_leftObjective.m_x >> 8, (CPrince.m_leftObjective.m_y >> 8) + m_leftObjective.GetActorInfo((short)8221), this.m_x >> 8, this.m_y >> 8))) {
                m_justAttackedEnemy = m_leftObjective;
                return m_leftObjective.BeAttacked(this, n);
            }
        }
        if (m_rightObjective != null) {
            m_rightObjective.GetActorBoxInfo(1, s_colBox2);
            if (CGame.IsIntersecting(s_colBox1, s_colBox2) && (0 == (8 & CGame.m_classesFlags[CPrince.m_rightObjective.m_classID]) || CGame.TestConnectivity(CPrince.m_rightObjective.m_x >> 8, (CPrince.m_rightObjective.m_y >> 8) + m_rightObjective.GetActorInfo((short)8221), this.m_x >> 8, this.m_y >> 8))) {
                m_justAttackedEnemy = m_rightObjective;
                return m_rightObjective.BeAttacked(this, n);
            }
        }
        return false;
    }

    void AiLand() {
        if (this.TestFlag(0x48000000)) {
            this.SetTactic(0);
        } else {
            this.AiWait();
        }
    }

    void AiOnBar() {
        this.m_timer %= 10;
        switch (this.m_animActionID) {
            case 53: {
                this.CanAttackEnemy(99);
                this.ClearFlag(0x40040000);
                if (m_isAutomaticBar) {
                    if (this.m_timer == 1 && !this.TestFlag(0x40000200)) {
                        this.SetFlag(0x40020000);
                        this.SetActorInfo((short)8195, 1);
                        if (this.TestFlag(0x40002000)) {
                            CActorShell cActorShell = CGame.m_actorShells[CGame.m_actorsShellID[this.GetActorInfo((short)8205)]];
                            cActorShell.SetFlag(0x44000000);
                            cActorShell.SetAnimAction(11);
                        }
                    }
                } else {
                    if (CGame.IsKeyPressed(97)) {
                        this.SetActorInfo((short)8195, CGame.m_keyPressed);
                        this.SetFlag(0x40020000);
                    }
                    if (CGame.IsKeyPressed(12)) {
                        this.SetFlag(0x40000200);
                    }
                }
                if (this.TestFlag(0x40020000)) {
                    if (this.m_timer == 3 && this.TestFlag(0x40002000)) {
                        this.m_timer = 0;
                        this.ClearFlag(0x44000000);
                        this.m_nextAction = 62;
                    }
                    if (this.m_timer == 4) {
                        this.ClearFlag(0x44000000);
                        this.m_nextAction = 54;
                        this.m_timer = 0;
                        int n = this.GetActorInfo((short)8195);
                        if (n == 1) {
                            n = this.TestFlag(-2147483647) ? 32 : 64;
                        }
                        if (n == 32 != this.TestFlag(-2147483647)) {
                            this.TurnAround();
                        }
                        this.m_x += (n == 32 ? -30 : 30) << 8;
                        this.SetFlag(0x40000400);
                    }
                }
                if (this.m_timer == 6 && this.TestFlag(0x40000200)) {
                    this.ClearFlag(0x40000200);
                    this.TurnAround();
                    this.SetAnimAction(53);
                    for (int i = 0; i < 6; ++i) {
                        this.UpdateAnimation();
                    }
                    this.SetFlag(0x40040000);
                }
                if (!CGame.IsKeyPressed(2) || m_isAutomaticBar) break;
                if (m_barActor.GetActorInfo((short)16397) == 1) {
                    m_chainGrabActor = m_barActor;
                    this.m_y = CPrince.m_chainGrabActor.m_y;
                    this.m_nextAction = 26;
                    break;
                }
                this.ClearFlag(0x40040000);
                this.SetTactic(5);
                this.SetAnimAction(15);
                this.m_y += 20 - this.GetActorInfo((short)8221) << 8;
                break;
            }
            case 62: {
                if (this.m_timer > 3 && this.HandleInAirCommon() || !m_isDarkPrince || !CGame.IsKeyPressed(16384) || !this.TrySwing(null)) break;
                break;
            }
            case 54: {
                if (this.m_timer > 4 && this.HandleInAirCommon() || !m_isDarkPrince || !CGame.IsKeyPressed(16384) || this.TrySwing(null)) {
                    // empty if block
                }
                if (!this.TestFlag(0x48000000)) break;
                this.SetTactic(5);
                m_specialFlags |= 9;
                this.m_nextAction = 16;
                this.SetActionWithCollision(this.m_nextAction, (short)8214, (short)-1);
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                CGame.CheckEnv(0);
                if (s_bBlockedBottom) {
                    m_chainGrabActor = null;
                    this.SetTactic(0);
                    break;
                }
                if (this.CanAssissinEnemy(8)) {
                    m_chainGrabActor = null;
                    return;
                }
                if (CGame.IsKeyHold(1)) {
                    this.m_nextAction = 23;
                    if (this.m_y > CPrince.m_chainGrabActor.m_y) break;
                    m_barActor = m_chainGrabActor;
                    m_chainGrabActor = null;
                    this.SetTactic(25);
                    break;
                }
                this.m_nextAction = CGame.IsKeyHold(2) ? 26 : 25;
            }
        }
    }

    void AiJump() {
        switch (this.m_animActionID) {
            case 6: {
                if (this.TestFlag(0x40800000)) {
                    this.SetTactic(8);
                    return;
                }
            }
            case 7: {
                CGame.CheckEnv(0);
                if (s_bCanClimbUp) {
                    this.m_x = s_climbupPointX;
                    this.m_y = s_climbupPointY;
                    this.SetTactic(6);
                    return;
                }
                if (!this.TestFlag(0x48000000)) break;
                this.m_nextAction = this.m_animActionID == 6 ? 8 : 9;
                m_specialFlags |= 1;
                this.m_timer = 0;
                m_isInAir = true;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 132: {
                m_isInAir = true;
                if (this.HandleInAirCommon()) break;
                if (!m_isDarkPrince) {
                    if (CGame.IsKeyHold(1 | this.GetJumpKey(true)) && s_bHWallingable && this.m_vY <= 0) {
                        this.SetTactic(11);
                        return;
                    }
                    if (!CGame.IsKeyPressed(97)) break;
                    this.SetFlag(0x41000000);
                    break;
                }
                if (!CGame.IsKeyPressed(16384)) break;
                this.TrySwing(null);
                break;
            }
            case 58: {
                m_specialFlags = this.m_animActionID == 58 ? (m_specialFlags |= 2) : (m_specialFlags |= 1);
                if (!this.TestFlag(0x48000000)) break;
                CGame.CheckEnv(0);
                if (s_bBlockedBottom) {
                    this.SetTactic(1);
                    break;
                }
                m_isSwordInHand = false;
                this.SetTactic(5);
                this.SetActionWithCollision(15, (short)8214, (short)-1);
            }
        }
    }

    int GetJumpPos() {
        CActorShell cActorShell = this.GetNearestActor(21, 0, 240, 0, -1);
        if (cActorShell != null) {
            int n = Math.abs(cActorShell.m_x - this.m_x);
            int n2 = Math.abs(cActorShell.m_y - this.m_y);
            if (n < 10240 && n2 < 30720) {
                if (cActorShell.TestFlag(-2147483640)) {
                    m_barActor = cActorShell;
                    this.SetTactic(25);
                    return -2;
                }
                if (cActorShell.GetFaceDir() == this.GetFaceDir() && this.IsFaceTo(cActorShell)) {
                    return cActorShell.m_x >> 8;
                }
            } else if (this.TestFlag(-2147483647) == cActorShell.m_x < this.m_x && n < 25600 && n2 < 25600) {
                return -3;
            }
        }
        return -1;
    }

    void AiFlyReady(boolean bl) {
        if (this.TestFlag(0x48000000) || bl) {
            int n = CPrince.m_chainGrabActor.m_x;
            int n2 = CPrince.m_chainGrabActor.m_y;
            int n3 = this.m_x;
            int n4 = this.m_y;
            n4 += this.GetActorInfo((short)8217) << 8;
            if (m_chainGrabX <= 0 && m_chainGrabY <= 0) {
                m_chainGrabX = n3;
                m_chainGrabY = n4;
            }
            int n5 = n - n3;
            int n6 = n2 - n4;
            int n7 = CGame.ArcTan(n5, n6);
            int n8 = 30;
            int n9 = CGame.LenCos(n8 << 8, n7);
            int n10 = CGame.LenSin(n8 << 8, n7);
            if (Math.abs(n9) >= Math.abs(m_chainGrabX - n) || Math.abs(n10) >= Math.abs(m_chainGrabY - n2) || bl) {
                m_chainGrabX = 0;
                m_chainGrabY = 0;
                this.SetTactic(24);
                if (this.TestFlag(-2147483647) != n5 < 0) {
                    this.TurnAround();
                }
                this.m_vX = CGame.LenCos(5120, n7);
                this.m_vY = CGame.LenSin(5120, n7);
                int n11 = Math.abs(this.m_vX) > Math.abs(this.m_vY) ? n5 / this.m_vX : n6 / this.m_vY;
                this.SetActorInfo((short)8198, n11);
                return;
            }
            m_chainGrabX += n9;
            m_chainGrabY += n10;
        }
    }

    boolean TryToUseSwing() {
        CActorShell cActorShell;
        CActorShell cActorShell2 = this.FindNextSwingBar();
        CActorShell cActorShell3 = cActorShell = this.TestFlag(-2147483647) ? m_leftObjective : m_rightObjective;
        if (cActorShell != null) {
            if (cActorShell.m_classID == 25) {
                int n = this.m_x - cActorShell.m_x >> 8;
                int n2 = this.m_y - cActorShell.m_y >> 8;
                if (n < 0) {
                    n = -n;
                }
                if (n < 80 && n2 > 0 && n2 < 160) {
                    m_chainGrabActor = cActorShell;
                    m_chainGrabActor.SetFlag(0x40000100);
                    if (CPrince.m_chainGrabActor.m_animActionID == 14) {
                        m_chainGrabActor.SetAnimAction(14);
                    } else {
                        m_chainGrabActor.SetAnimAction(16);
                    }
                    this.SetTactic(29);
                    return true;
                }
            } else if (cActorShell2 != null && CGame.GetDistance(this.m_x - cActorShell.m_x, this.m_y - cActorShell.m_y) < CGame.GetDistance(this.m_x - cActorShell2.m_x, this.m_y - cActorShell2.m_y)) {
                return false;
            }
        }
        if (cActorShell2 == null) {
            return false;
        }
        return this.TrySwing(cActorShell2);
    }

    int GetSwingAngle(int n, int n2) {
        return 360 - CGame.ArcTan(n, n2) * 360 / 256;
    }

    int GetSwingAction() {
        int n;
        int n2 = this.m_x - CPrince.m_chainGrabActor.m_x >> 8;
        int n3 = this.m_y - CPrince.m_chainGrabActor.m_y >> 8;
        if (n3 < 10) {
            return 46;
        }
        if (this.TestFlag(-2147483647)) {
            n2 = -n2;
        }
        if ((n = this.GetSwingAngle(n2, n3)) > 300) {
            return 47;
        }
        if (n > 290) {
            return 46;
        }
        if (n > 280) {
            return 45;
        }
        if (n > 270) {
            return 44;
        }
        if (n > 260) {
            return 43;
        }
        return 42;
    }

    int GetSwingReadyAction() {
        int n = this.m_x - CPrince.m_chainGrabActor.m_x >> 8;
        this.SetFaceDir(-n);
        return 50;
    }

    boolean TrySwing(CActorShell cActorShell) {
        if (cActorShell == null) {
            cActorShell = this.FindNextSwingBar();
        }
        if (cActorShell == null) {
            return false;
        }
        if (!CGame.TestConnectivity(cActorShell.m_x >> 8, cActorShell.m_y >> 8, this.m_x >> 8, this.m_y >> 8)) {
            return false;
        }
        this.SetFaceDir(cActorShell.m_x - this.m_x);
        m_chainGrabX = -1;
        m_chainGrabY = -1;
        m_chainGrabActor = cActorShell;
        this.SetTactic(23);
        return true;
    }

    CActorShell FindNextSwingBar() {
        CActorShell cActorShell = null;
        int n = Integer.MAX_VALUE;
        int n2 = m_isInAir ? 140 : 210;
        int n3 = m_isInAir ? n2 : 0;
        m_lastBarActorID = m_isInAir ? m_lastBarActorID : -1;
        int n4 = CGame.m_activeActorsListHead;
        while (n4 >= 0) {
            CActorShell cActorShell2 = CGame.m_actorShells[n4];
            if (cActorShell2.m_classID == 21 && cActorShell2.m_actorID != m_lastBarActorID) {
                int n5;
                int n6 = cActorShell2.m_x - this.m_x >> 8;
                int n7 = cActorShell2.m_y - this.m_y >> 8;
                if (n6 > -n2 && n6 < n2 && n7 > -n2 && n7 < n3 && (n5 = CGame.GetDistance(n6, n7)) < n) {
                    cActorShell = cActorShell2;
                    n = n5;
                }
            }
            n4 = CGame.m_nextActorShellID[n4];
        }
        return cActorShell;
    }

    CActorShell FindFinalKillActor() {
        CActorShell cActorShell;
        if (this.m_currentTactic != 0 && this.m_currentTactic != 1) {
            return null;
        }
        CActorShell cActorShell2 = cActorShell = this.TestFlag(-2147483647) ? m_leftCombatActor : m_rightCombatActor;
        if (cActorShell != null && cActorShell.m_currentTactic == 27) {
            return cActorShell;
        }
        return null;
    }

    boolean TryJumpOver(CActorShell cActorShell) {
        if (cActorShell == null || this.m_y == cActorShell.m_y) {
            // empty if block
        }
        return false;
    }

    int GetDirectionKey(boolean bl) {
        return bl ^ this.TestFlag(-2147483647) ? 8 : 4;
    }

    int GetJumpKey(boolean bl) {
        return bl != this.TestFlag(-2147483647) ? 64 : 32;
    }

    boolean HandleHangCommon() {
        if (!this.TestFlag(0x40008000) || CGame.IsKeyPressed(1)) {
            this.SetActorInfo((short)8193, 18);
            this.SetTactic(7);
            return true;
        }
        if (CGame.IsKeyPressed(2) || CPrince.GetTilePhyEnv(((this.m_x >> 8) + (this.TestFlag(-2147483647) ? -2 : 2)) / 20, ((this.m_y >> 8) + 2) / 20) < 10) {
            this.SetTactic(5);
            this.m_y = ((this.m_y >> 8) + 80) / 20 * 20 << 8;
            this.SetActionWithCollision(15, (short)8214, (short)-1);
            return true;
        }
        return false;
    }

    boolean HandleInAirCommon() {
        this.SetFlag(0x40004000);
        if (this.CanAssissinEnemy(4)) {
            return true;
        }
        this.ClearFlag(0x40004000);
        if (m_ropeActor != null) {
            if (CPrince.m_ropeActor.m_animActionID == 0 && (m_prevTactic != 33 || this.m_timer > 3)) {
                this.m_y = CPrince.m_ropeActor.m_y;
                CGame.GetActorActivateBoxInfo(CPrince.m_ropeActor.m_actorID, s_colBox1);
                this.SetActorInfo((short)8203, s_colBox1[0]);
                this.SetActorInfo((short)8204, s_colBox1[2]);
                this.SetActorInfo((short)8206, CPrince.m_ropeActor.m_y >> 8);
                if (this.m_x < s_colBox1[0] << 8) {
                    this.m_x = s_colBox1[0] << 8;
                } else if (this.m_x > s_colBox1[2] << 8) {
                    this.m_x = s_colBox1[2] << 8;
                }
                this.SetTactic(33);
            } else if (CPrince.m_ropeActor.m_animActionID == 2 && (m_prevTactic != 27 || this.m_timer > 3)) {
                this.m_x = CPrince.m_ropeActor.m_x;
                this.m_y = CPrince.m_ropeActor.m_y;
                this.SetFaceDir(m_ropeActor.GetFaceDir());
                this.SetTactic(27);
            } else if (CPrince.m_ropeActor.m_animActionID == 1 && (m_prevTactic != 10 || this.m_timer > 3)) {
                this.m_x = CPrince.m_ropeActor.m_x;
                this.SetTactic(10);
                int n = m_ropeActor.GetActorInfo((short)16391) << 8;
                if (this.m_y < n) {
                    this.m_y = n;
                }
            }
            return true;
        }
        if (m_barActor != null && (this.m_currentTactic != 24 || m_barActor == m_chainGrabActor)) {
            this.SetTactic(25);
            return true;
        }
        CGame.CheckEnv(0);
        if (s_bInDeadZone) {
            this.BeAttacked(this, this.m_blood);
            this.m_nextAction = 41;
            return true;
        }
        if (s_bCanClimbUp && (m_prevTactic != 6 || this.m_timer > 5) && this.m_vY < 10240) {
            m_indicator.ClearFlag(0x40000100);
            this.m_x = s_climbupPointX;
            this.m_y = s_climbupPointY;
            this.SetTactic(6);
            return true;
        }
        if (s_bBlockedFront) {
            this.m_vX = 0;
            if (!m_isDarkPrince && this.m_vY < 10240 && this.TestFlag(0x40000400) && (CGame.IsKeyPressed(1 | this.GetJumpKey(false)) || this.TestFlag(0x41000000)) && s_bReboundable) {
                this.SetTactic(9);
                this.SetActionWithCollision(22, (short)8214, (short)-1);
                return true;
            }
        }
        if (m_isInAir && s_bBlockedBottom) {
            if (s_bCanClimbDown && (!s_bBlockedBottomFront && !s_bBlockedBottomCenter || !s_bBlockedBottomBack) && this.m_vY < 10240) {
                this.m_x = s_climbdownPointX;
                this.m_y = s_climbdownPointY;
                this.SetFaceDir(s_climbdownFaceDir);
                this.SetActorInfo((short)8193, 19);
                this.SetTactic(7);
                this.ClearFlag(0x40008000);
            } else {
                this.SetTactic(21);
            }
            return true;
        }
        if (s_bBlockedTop && this.m_vY < 0) {
            this.m_vY = 0;
        }
        return false;
    }

    void AiHang() {
        if (!this.HandleHangCommon()) {
            if (CGame.IsKeyPressed(97)) {
                m_posInCamera = 1549;
                this.SetTactic(9);
                this.SetActionWithCollision(21, (short)-1, (short)8223);
                this.SetFlag(0x40000100);
            }
        } else {
            this.ClearFlag(0x40008000);
        }
    }

    boolean BeAttacked(CActorShell cActorShell, int n) {
        s_attackResult = 1;
        if (this.m_blood <= 0) {
            s_attackResult = -1;
            return false;
        }
        if ((this.m_currentTactic == 17 || this.m_currentTactic == 26) && cActorShell != m_assassinActor) {
            s_attackResult = -1;
            return false;
        }
        boolean bl = false;
        if (cActorShell.m_classID != 24) {
            if (this.m_currentTactic == 12) {
                if (this.IsFaceTo(cActorShell)) {
                    if (cActorShell.m_classID == 3) {
                        n = 2;
                        if (n >= this.m_blood) {
                            n = this.m_blood - 1;
                        }
                    } else {
                        n = 0;
                    }
                    CGame.PlaySound(9);
                    this.SetAnimAction(m_isDarkPrince ? 124 : 31);
                    this.SetFlag(0x44000000);
                    this.AllocActor(14, 17, !this.TestFlag(-2147483647), 0, -9728);
                    bl = true;
                    s_attackResult = -1;
                }
            } else if (m_tickInvincible > 0 && cActorShell != this) {
                return false;
            }
        }
        if (this.m_currentTactic == 21) {
            bl = true;
        } else if (this.m_animActionID == 120) {
            bl = true;
        }
        if (cActorShell != this) {
            this.SetFaceTo(cActorShell);
        }
        if (cActorShell.m_classID == 16) {
            this.GrabBoxesInfo();
            this.m_x = this.StickFrontTo(cActorShell);
        }
        if (n > 0) {
            m_tickInvincible = 15;
            this.m_blood -= n;
            if (this.m_blood < 0) {
                this.m_blood = 0;
            }
            CGame.m_isRepaintInterface = true;
            CGame.m_actSOT.SetFlag(0x40004000);
        }
        this.m_nextAction = this.m_animActionID;
        if (this.m_blood > 0) {
            if (bl) {
                return n > 0;
            }
            if (this.m_currentTactic == 10) {
                if (cActorShell.m_classID == 4) {
                    if (this.m_animActionID == 64) {
                        this.ClearFlag(0x44000000);
                        return true;
                    }
                    if (cActorShell.m_animActionID == 21) {
                        m_specialFlags &= 0xFFFFFFF7;
                        this.ClearFlag(0x44000000);
                        this.SetAnimAction(64);
                        return true;
                    }
                    this.m_nextAction = 72;
                } else {
                    this.m_nextAction = 72;
                }
            } else if (this.m_currentTactic == 26 || this.m_currentTactic == 40) {
                this.m_nextAction = 60;
            } else if (this.m_currentTactic == 33) {
                m_specialFlags &= 0xFFFFFFFD;
                this.m_nextAction = 70;
            } else if (this.m_currentTactic == 4) {
                this.m_nextAction = 38;
            } else if (m_isInAir) {
                this.m_nextAction = 37;
            } else {
                this.m_nextAction = !m_isSwordInHand | m_isDarkPrince ? 35 : 36;
                m_specialFlags |= 4;
            }
        } else {
            if (this.m_currentTactic == 36) {
                this.m_nextAction = 122;
            } else if (cActorShell.m_classID == 43) {
                this.m_nextAction = 122;
            } else if (this.m_currentTactic == 10) {
                this.m_nextAction = 71;
            } else if (this.m_currentTactic == 33) {
                this.m_nextAction = 71;
            } else {
                this.m_nextAction = 41;
                s_attackResult = -1;
            }
            CGame.PlaySound(1);
            this.SetFlag(0x42000000);
        }
        if (this.m_blood <= 0) {
            this.SetActionWithCollision(this.m_nextAction, (short)-1, (short)8223);
        } else {
            this.SetAnimAction(this.m_nextAction);
        }
        m_chainGrabActor = null;
        boolean bl2 = m_isInAir;
        this.SetTactic(16);
        m_isInAir = bl2;
        CGame.m_bShowMap = true;
        return n > 0;
    }

    boolean BeAttacked_old(CActorShell cActorShell, int n) {
        m_chainGrabActor = null;
        if (this.m_blood <= 0) {
            return false;
        }
        if (n == 101) {
            this.m_x = this.GetPosAfterCollision(cActorShell);
            this.SetTactic(36);
            this.SetAnimAction(122);
            return true;
        }
        if (m_tickInvincible > 0) {
            if (this.m_currentTactic != 12) {
                return false;
            }
            if (this.m_currentTactic == 12 && cActorShell.TestFlag(-2147483647) ^ this.TestFlag(-2147483647)) {
                if (cActorShell.m_classID == 3) {
                    this.m_blood -= n / 3;
                    CGame.m_actSOT.SetFlag(0x40004000);
                    if (this.m_blood < 0) {
                        this.m_blood = 1;
                    }
                }
                if (this.m_blood > 0) {
                    CGame.PlaySound(9);
                    this.SetAnimAction(m_isDarkPrince ? 124 : 31);
                    this.SetFlag(0x44000000);
                    this.AllocActor(14, 17, !this.TestFlag(-2147483647), 0, -9728);
                }
                return false;
            }
        }
        if (CGame.m_isGodFlag) {
            return false;
        }
        CGame.m_actSOT.SetFlag(0x40004000);
        boolean bl = m_isInAir;
        this.m_blood -= n;
        if (cActorShell.m_animActionID == 35 && this.m_blood > 6) {
            CGame.m_isRepaintInterface = true;
            return true;
        }
        int n2 = this.m_currentTactic;
        this.SetTactic(16);
        if (cActorShell == this) {
            m_specialFlags &= 0xFFFFFFFD;
            return true;
        }
        this.SetFaceDir(cActorShell.m_x - this.m_x);
        if (this.m_blood <= 0) {
            if (this.m_animActionID == 64) {
                this.SetAnimAction(65);
                this.m_nextAction = 65;
            } else if (n2 == 33) {
                this.m_nextAction = 71;
                this.SetAnimAction(71);
            } else {
                this.SetAnimAction(41);
                this.m_nextAction = 41;
            }
            CGame.PlaySound(1);
            return true;
        }
        if (cActorShell.m_classID == 16) {
            this.m_x = this.GetPosAfterCollision(cActorShell);
        }
        if (bl) {
            m_isInAir = true;
            if (n2 == 10 && cActorShell.m_classID == 4) {
                if (cActorShell.m_animActionID == 21) {
                    m_specialFlags &= 0xFFFFFFF7;
                    this.ClearFlag(0x44000000);
                    this.SetAnimAction(64);
                    this.m_nextAction = 64;
                } else {
                    this.SetAnimAction(72);
                    this.m_nextAction = 72;
                }
                return true;
            }
            if (this.m_animActionID == 64) {
                this.ClearFlag(0x44000000);
                return true;
            }
            this.SetActionWithCollision(37, (short)8215, (short)8221);
            this.ApplyVelocityWithCollision(this.TestFlag(-2147483647) ? 5120 : -5120, 0);
            return true;
        }
        if (n2 == 26) {
            this.SetAnimAction(60);
            this.m_nextAction = 60;
            return true;
        }
        if (n2 == 33) {
            m_specialFlags &= 0xFFFFFFFD;
            this.m_nextAction = 70;
            this.SetAnimAction(70);
            return true;
        }
        if (n2 == 4) {
            this.m_nextAction = 38;
            this.SetAnimAction(this.m_nextAction);
            return true;
        }
        m_specialFlags |= 4;
        this.SetAnimAction(!m_isSwordInHand | m_isDarkPrince ? 35 : 36);
        this.m_nextAction = this.m_animActionID;
        return true;
    }

    void AiHurt() {
        m_specialFlags |= 2;
        boolean bl = this.TestFlag(0x48000000);
        switch (this.m_animActionID) {
            case 60: {
                m_specialFlags |= 4;
            }
            case 35: 
            case 36: {
                if (!bl) break;
                this.SetTactic(0);
                return;
            }
            case 38: {
                if (!bl) break;
                this.SetTactic(4);
                break;
            }
            case 37: {
                CGame.CheckEnv(0);
                if (s_bBlockedBottom) {
                    if (this.m_blood > 0) {
                        this.SetTactic(21);
                        break;
                    }
                    this.m_nextAction = 41;
                    s_attackResult = -1;
                    break;
                }
                if (this.m_blood <= 0 || this.m_timer <= 4 || !this.HandleInAirCommon()) break;
                break;
            }
            case 70: {
                if (!this.TestFlag(0x48000000)) break;
                this.SetTactic(33);
                break;
            }
            case 72: {
                if (!this.TestFlag(0x48000000)) break;
                this.SetTactic(10);
                break;
            }
            default: {
                this.m_aX = 0;
                this.m_vX = 0;
                if (this.m_vY > 0) {
                    CGame.CheckEnv(0);
                    if (s_bBlockedBottom) {
                        this.m_vY = 0;
                        this.m_aY = 0;
                        this.m_nextAction = 41;
                    }
                }
                if (bl && this.m_timer == 30) {
                    CGame.ChangeState(24);
                }
                m_otherCamera |= 0x3000000;
            }
        }
    }

    void AiAssassin() {
        boolean bl = this.TestFlag(0x48000000);
        switch (this.m_animActionID) {
            case 74: {
                if (this.m_timer < (CGame.m_bSlowMotion ? 12 : 4)) break;
                if (CPrince.m_assassinActor.m_classID == 3) {
                    this.SetFlag(0x48000000);
                    this.m_animActionID = 81;
                    this.AiAssassin();
                    return;
                }
                this.m_nextAction = 75;
                this.SetAnimAction(this.m_nextAction);
                this.m_y = CPrince.m_assassinActor.m_y + (m_assassinActor.GetActorInfo((short)8221) << 8);
                CGame.playtwo();
                m_assassinActor.BeAttacked(this, 99);
                CGame.m_scoreArray[3] = CGame.m_scoreArray[3] + 1;
                break;
            }
            case 75: {
                if (!bl) break;
                int n = this.GetJumpPos();
                if (n == -3) {
                    this.SetFlag(0x40000400);
                    this.SetFlag(0x40001000);
                    this.SetTactic(3);
                    this.m_nextAction = 8;
                } else if (n != -2) {
                    this.m_nextAction = 76;
                    this.DragToGround();
                }
                CGame.playtwo();
                break;
            }
            case 76: {
                if (!bl) break;
                this.m_z = CGame.m_classesDefaultZ[this.m_classID];
                m_assassinActor = null;
                this.SetTactic(0);
                break;
            }
            case 77: {
                if (!this.TestColliding(m_assassinActor) && !bl) break;
                this.m_nextAction = 78;
                this.SetAnimAction(this.m_nextAction);
                this.m_x = this.StickFrontTo(m_assassinActor);
                m_assassinActor.SetEnemyTactic(21);
                CGame.playtwo();
                break;
            }
            case 81: {
                if (!this.TestColliding(m_assassinActor) && !bl) break;
                if (bl) {
                    this.m_nextAction = 82;
                    this.m_x = CPrince.m_assassinActor.m_x;
                    this.m_y = CPrince.m_assassinActor.m_y;
                    m_assassinActor.SetActorInfo((short)8196, 2);
                    m_assassinActor.SetEnemyTactic(12);
                    m_counter = 0;
                    m_indicator.SetFlag(0x40000100);
                    CPrince.m_indicator.m_y = this.m_y + Short.MIN_VALUE;
                    CPrince.m_indicator.m_x = this.m_x + (this.GetActorInfo((short)8214) + this.GetActorInfo((short)8215) << 8) / 2;
                    m_indicator.SetAnimAction(19);
                    break;
                }
                this.m_x = this.StickFrontTo(m_assassinActor);
                break;
            }
            case 78: {
                if (!bl) break;
                m_assassinActor.BeAttacked(this, 99);
                CGame.m_scoreArray[3] = CGame.m_scoreArray[3] + 1;
                m_assassinActor = null;
                this.SetTactic(1);
                this.SetActionWithCollision(this.m_nextAction, (short)8214, (short)-1);
                break;
            }
            case 82: {
                if (bl) {
                    m_indicator.ClearFlag(0x40000100);
                    if (m_counter >= 3) {
                        CPrince.m_assassinActor.m_blood = -1;
                        m_assassinActor = null;
                        int n = this.GetJumpPos();
                        if (n == -3) {
                            this.SetFlag(0x40000400);
                            this.SetFlag(0x40001000);
                            this.SetTactic(3);
                            m_specialFlags &= 0xFFFFFFF7;
                            this.m_nextAction = 8;
                        } else if (n != -2) {
                            this.m_nextAction = 84;
                        }
                        CGame.playtwo();
                    } else {
                        this.SetTactic(5);
                        this.m_nextAction = 83;
                        m_assassinActor.TurnAround();
                        CPrince.m_assassinActor.m_nextAction = 21;
                        m_assassinActor.SetEnemyTactic(6);
                        m_assassinActor.ClearFlag(0x40000800);
                    }
                    m_assassinActor = null;
                    break;
                }
                if (!CGame.IsKeyPressed(16384)) break;
                ++m_counter;
                break;
            }
            case 92: {
                if (this.m_actionSequenceID == 2) {
                    m_chainGrabActor = null;
                    m_assassinActor.SetActorInfo((short)8196, 28);
                    m_assassinActor.SetEnemyTactic(12);
                }
                if (!bl) {
                    CPrince.m_assassinActor.m_x = m_assassinActor.StickBackTo(this);
                }
                if (!bl) break;
                this.m_z = CGame.m_classesDefaultZ[this.m_classID];
                m_isSwordInHand = false;
                this.SetTactic(0);
                break;
            }
            case 91: {
                if (bl) {
                    m_indicator.ClearFlag(0x40000100);
                    if (m_counter >= 3) {
                        this.m_nextAction = 92;
                        m_assassinActor.SetEnemyTactic(20);
                        CPrince.m_assassinActor.m_vX = (m_assassinActor.StickBackTo(this) - CPrince.m_assassinActor.m_x) / 3;
                    } else {
                        this.SetTactic(1);
                        m_assassinActor.TurnAround();
                        CPrince.m_assassinActor.m_nextAction = 11;
                        m_assassinActor.SetEnemyTactic(6);
                        m_assassinActor.ClearFlag(0x40000800);
                        m_chainGrabActor = null;
                    }
                    CGame.playtwo();
                    break;
                }
                if (!CGame.IsKeyPressed(16384)) break;
                ++m_counter;
                break;
            }
            case 90: {
                if (!bl) break;
                this.m_nextAction = 91;
                m_assassinActor.SetAnimAction(0);
                m_counter = 0;
                m_indicator.SetFlag(0x40000100);
                CPrince.m_indicator.m_x = this.m_x;
                CPrince.m_indicator.m_y = this.m_y + -24576;
                m_indicator.SetAnimAction(19);
                m_chainGrabActor = m_assassinActor;
                break;
            }
            case 84: {
                if (!bl) break;
                this.m_z = CGame.m_classesDefaultZ[this.m_classID];
                this.TryDrawInSword(0);
                break;
            }
            case 80: {
                if (this.m_timer == 5) {
                    CGame.playtwo();
                    m_assassinActor.BeAttacked(this, 99);
                    CGame.m_scoreArray[3] = CGame.m_scoreArray[3] + 1;
                }
                if (!bl) break;
                this.SetTactic(5);
                this.SetActionWithCollision(15, (short)8214, (short)8223);
                break;
            }
            case 79: {
                boolean bl2 = this.HandleHWallingCommon();
                if (this.m_timer == 4) {
                    this.m_z = CGame.m_classesDefaultZ[this.m_classID];
                    CGame.playtwo();
                    m_assassinActor.BeAttacked(this, 99);
                    CGame.m_scoreArray[3] = CGame.m_scoreArray[3] + 1;
                    m_assassinActor = null;
                }
                if (!bl || bl2) break;
                int n = this.m_vX;
                this.SetTactic(5);
                this.SetAnimAction(this.m_nextAction);
                this.m_vX = n;
                this.SetFlag(0x40100000);
                break;
            }
            case 42: {
                if (this.m_timer < this.GetActorInfo((short)8198)) break;
                this.m_x = CPrince.m_chainGrabActor.m_x;
                this.m_y = CPrince.m_chainGrabActor.m_y;
                m_chainGrabActor = null;
                this.m_nextAction = 85;
                this.SetAnimAction(this.m_nextAction);
                m_assassinActor.TurnAround();
                m_assassinActor.SetActorInfo((short)8196, 4);
                m_assassinActor.SetEnemyTactic(12);
                CGame.playtwo();
                break;
            }
            case 85: {
                if (this.CanAssissinEnemy(m_isDarkPrince ? 34 : 1)) {
                    return;
                }
                if (!bl) break;
                m_assassinActor = null;
                this.SetTactic(1);
            }
        }
    }

    CActorShell FindAssassinEnemy(int n) {
        CActorShell cActorShell = null;
        if (n == 3) {
            cActorShell = this.GetNearestActor(-1, 1, 360, 0, 1);
        } else if (n == 5) {
            cActorShell = this.GetNearestActor(-1, 1, 360, 0, -1);
        } else {
            CActorShell cActorShell2 = cActorShell = this.TestFlag(-2147483647) ? m_leftObjective : m_rightObjective;
        }
        if (cActorShell == null) {
            return null;
        }
        if (cActorShell.m_blood <= 0) {
            return null;
        }
        if (n == 1 && cActorShell.m_classID != 3) {
            if (!(this.XDistanceToActor(cActorShell) > 3 || cActorShell.IsFaceTo(this) || cActorShell.m_classID != 1 && cActorShell.m_classID != 2)) {
                cActorShell.TurnAround();
            }
            return null;
        }
        if (n == 3 && cActorShell.m_classID == 4 && cActorShell.m_animActionID != 24 && cActorShell.m_animActionID != 17) {
            return null;
        }
        if (n == 5 ? cActorShell.m_classID != 1 || cActorShell.TestFlag(-2147483647) != this.m_x > cActorShell.m_x : n != 3 && (cActorShell.m_classID != 1 && cActorShell.m_classID != 3 && cActorShell.m_classID != 2 || cActorShell.TestFlag(-2147483647) != this.TestFlag(-2147483647) || cActorShell.TestFlag(-2147483647) != this.m_x > cActorShell.m_x)) {
            return null;
        }
        if (!CGame.TestConnectivity(cActorShell.m_x >> 8, (cActorShell.m_y >> 8) + this.GetActorInfo((short)8221), this.m_x >> 8, (this.m_y >> 8) + this.GetActorInfo((short)8221))) {
            return null;
        }
        this.GetActorBoxInfo(1, s_colBox1);
        int n2 = (cActorShell.m_y >> 8) + cActorShell.GetActorInfo((short)8223);
        s_colBox1[0] = (short)(s_colBox1[0] - (cActorShell.m_x >> 8));
        s_colBox1[1] = (short)(s_colBox1[1] - n2);
        s_colBox1[2] = (short)(s_colBox1[2] - (cActorShell.m_x >> 8));
        s_colBox1[3] = (short)(s_colBox1[3] - n2);
        System.arraycopy(PRINCE_ASSASSIN_BOX_MAX, n << 2, s_colBox2, 0, 4);
        if (CGame.IsIntersecting(s_colBox1, s_colBox2)) {
            if (n != 0 && n != 1) {
                return cActorShell;
            }
            System.arraycopy(PRINCE_ASSASSIN_BOX_MIN, n << 2, s_colBox2, 0, 4);
            if (CGame.IsIntersecting(s_colBox1, s_colBox2)) {
                cActorShell.TurnAround();
            } else {
                return cActorShell;
            }
        }
        return null;
    }

    boolean CanAssissinEnemy(int n) {
        int n2 = 0;
        while (n != 0 && ((n & 1) == 0 || (m_assassinActor = this.FindAssassinEnemy(n2)) == null)) {
            ++n2;
            n >>= 1;
        }
        if (m_assassinActor == null) {
            m_assassinActor = this.FindFinalKillActor();
            n2 = -1;
        }
        if (m_assassinActor == null) {
            if (!m_indicator.TestFlag(0x40000200)) {
                m_indicator.ClearFlag(0x40000100);
            }
            CGame.SetSlowMotion(false);
            return false;
        }
        if (m_assassinActor == m_rushEnemyAxe) {
            return false;
        }
        if (CPrince.m_assassinActor.m_classID == 2 && n2 != -1) {
            m_assassinActor.SetAnimAction(33);
            m_assassinActor.SetFaceTo(this);
            return false;
        }
        if (n2 == 5) {
            CPrince.m_indicator.m_y = this.m_y + -20480;
            CPrince.m_indicator.m_x = this.m_x;
        } else {
            CPrince.m_indicator.m_y = CPrince.m_assassinActor.m_y + -20480;
            CPrince.m_indicator.m_x = CPrince.m_assassinActor.m_x;
        }
        m_indicator.SetFlag(0x40000100);
        if (CPrince.m_indicator.m_animActionID != 6) {
            m_indicator.SetAnimAction(6);
        }
        if (CGame.IsKeyPressed(16384) || this.TestFlag(0x40004000)) {
            this.ClearFlag(0x40004000);
            if (n2 == -1) {
                this.SetTactic(32);
                return true;
            }
            m_indicator.ClearFlag(0x40000100);
            m_assassinActor.SetEnemyTactic(13);
            m_assassinActor.SetFlag(0x40000800);
            this.SetActorInfo((short)8196, n2);
            this.SetTactic(17);
            return true;
        }
        if (n2 == 2) {
            CGame.SetSlowMotion(true);
        }
        return false;
    }

    void DrawChain() {
        int n;
        int n2;
        if (!m_isDarkPrince || m_chainGrabX < 0 || m_chainGrabY < 0 || m_chainGrabActor == null) {
            return;
        }
        if (m_chainGrabX > 0 && m_chainGrabY > 0) {
            n2 = m_chainGrabX >> 8;
            n = m_chainGrabY >> 8;
        } else {
            n2 = m_chainGrabActor.GetActorInfo(this.TestFlag(-2147483647) ? (short)8218 : 8216) + (CPrince.m_chainGrabActor.m_x >> 8);
            n = m_chainGrabActor.GetActorInfo((short)8217) + (CPrince.m_chainGrabActor.m_y >> 8);
        }
        int n3 = this.GetActorInfo(this.TestFlag(-2147483647) ? (short)8216 : 8218) + (this.m_x >> 8);
        int n4 = this.GetActorInfo((short)8217) + (this.m_y >> 8);
        this.drawChain(n3, n4, n2, n, this.m_animationID, 52, 5);
    }

    void Paint(Graphics graphics) {
        boolean bl;
        this.DrawChain();
        boolean bl2 = bl = CGame.m_currentTrailerIndex < 0 || this.m_timelineIndex < 0;
        if (bl) {
            this.m_y -= 1536;
        }
        CAnimation cAnimation = CGame.m_animations[this.m_animationID];
        int n = cAnimation.m_actionData[this.m_animActionID][this.m_actionSequenceID] >> 6 & 0x3FF;
        if (m_isDarkPrince) {
            cAnimation.m_gli.SetPalette(1);
        } else {
            cAnimation.m_gli.SetPalette(0);
        }
        cAnimation.DrawFrame(n, (this.m_x >> 8) - CGame.m_cameraLeft, (this.m_y >> 8) - CGame.m_cameraTop, this.TestFlag(-2147483647));
        if (bl) {
            this.m_y += 1536;
        }
    }

    void ChangePrince(boolean bl) {
        m_isDarkPrince = bl;
        this.m_classID = bl ? 8 : 0;
        m_isSwordInHand = false;
    }

    public void StartRecordCombo(int n) {
        m_tickCombo = 6;
        this.ClearFlag(0x40800000);
        this.m_timer = 0;
        this.SetActorInfo((short)8200, n);
    }

    public void AiSmallCombo() {
        if (this.CanAttackEnemy(-1)) {
            this.SetFlag(0x40080000);
        }
        if (this.m_animActionID == 108 && m_justAttackedEnemy != null && CPrince.m_justAttackedEnemy.m_classID == 1) {
            CPrince.m_justAttackedEnemy.m_nextAction = 31;
            m_justAttackedEnemy.SetEnemyTactic(27);
            m_justAttackedEnemy.ClearFlag(0x40000100);
        }
        if (this.TestFlag(0x48000000)) {
            boolean bl = true;
            if (this.m_animActionID == 107) {
                if (this.TestFlag(0x40080000)) {
                    this.m_nextAction = 108;
                    CGame.ShowPrinceActionName(80);
                } else {
                    bl = false;
                }
            } else if (this.m_animActionID == 108) {
                this.m_nextAction = 109;
            } else {
                bl = false;
            }
            if (!bl) {
                this.ClearFlag(0x40080000);
                this.SetTactic(1);
            }
        }
    }
}

