/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class gameTopLevel
extends MOBCanvas {
    public static final int INGAME_SOFTKEY_ADD_X = 7;
    public static final int INGAME_SOFTKEY_SUB_Y = 5;
    public static gameTopLevel topLevel;
    private static boolean applicationInterrupted;
    private static int applicationRunningTime;
    private static boolean saveValid;
    public static int gameState;
    private static int nextGameState;
    private static boolean gameStateValid;
    public static int keyPressed;
    public static int keyDown;
    public static boolean displayLeftSoftkey;
    public static boolean displayRightSoftkey;
    public static int rightSoftkeyNb;
    public static Image imgSoftkey;
    public static byte[] sincos;
    public static short[] atan;
    public static final int IAtanANGLEGU = 2048;
    public static final int IAtanSIZE = 10;
    public static final int IAtanSIZENUM = 1024;
    public static MediaManager mediaManager;

    public gameTopLevel(MIDlet mIDlet) {
        super(mIDlet);
        topLevel = this;
    }

    private void onInit() {
        saveValid = saveGame.loadGameData();
        if (!saveValid) {
            saveGame.initGameData();
            gameTopLevel.enableVibrator(false);
        } else if (saveGame.gameData[2] == 1) {
            gameTopLevel.enableVibrator(true);
        } else {
            gameTopLevel.enableVibrator(false);
        }
        menuGame.initDialog();
        imgSoftkey = gameTopLevel.getImage("/Softkeys.png");
        gameTopLevel.activateSoftkeys(false, false, -1);
        nextGameState = saveValid ? 4 : 2;
    }

    private void onExit() {
        saveGame.saveGameData();
    }

    private void onKeyPressed(int n) {
        keyPressed |= n;
        keyDown |= n;
    }

    private void onKeyReleased(int n) {
        keyPressed &= ~n;
    }

    private void onTimerTick() {
        if (nextGameState != -1) {
            switch (nextGameState) {
                case 2: {
                    gameStateValid = outGame.initLanguageSelection();
                    break;
                }
                case 3: {
                    gameStateValid = outGame.initSoundYesNo();
                    break;
                }
                case 4: {
                    gameStateValid = outGame.initOutGameLoading();
                    break;
                }
                case 6: {
                    gameStateValid = menuGame.init(0);
                    break;
                }
                case 7: {
                    gameStateValid = menuGame.init(9);
                    nextGameState = 6;
                    gameTopLevel.activateSoftkeys(true, true, 2);
                    break;
                }
                case 8: {
                    gameStateValid = inGame.initIngame();
                    break;
                }
                case 9: {
                    inGame.levelNb = 255;
                    Board.initNewGame();
                    Bonus.initNewGame();
                    Hero.initNewGame();
                    Enemy.initNewGame();
                    gameStateValid = inGame.initIngame();
                    nextGameState = 8;
                    break;
                }
                case 10: {
                    inGame.levelNb = 512;
                    Board.initNewGame();
                    Bonus.initNewGame();
                    Hero.initNewGame();
                    Enemy.initNewGame();
                    gameStateValid = inGame.initIngame();
                    nextGameState = 8;
                    break;
                }
                case 11: {
                    gameStateValid = inGame.initLevelFinished();
                    break;
                }
                case 12: {
                    gameStateValid = outGame.initGameFinished();
                    break;
                }
                case 13: {
                    gameStateValid = outGame.initGameOver();
                    break;
                }
                case 255: {
                    this.exit();
                    break;
                }
                default: {
                    gameStateValid = outGame.initUserState(nextGameState);
                }
            }
            if (gameStateValid) {
                gameState = nextGameState;
                nextGameState = -1;
            }
        }
        if (gameStateValid) {
            switch (gameState) {
                case 2: {
                    nextGameState = outGame.updateLanguageSelection();
                    break;
                }
                case 3: {
                    nextGameState = outGame.updateSoundYesNo();
                    break;
                }
                case 4: {
                    nextGameState = outGame.updateOutGameLoading();
                    break;
                }
                case 6: {
                    nextGameState = menuGame.update();
                    break;
                }
                case 8: {
                    nextGameState = inGame.updateIngame();
                    break;
                }
                case 11: {
                    nextGameState = inGame.updateLevelFinished();
                    break;
                }
                case 12: {
                    nextGameState = outGame.updateGameFinished();
                    break;
                }
                case 13: {
                    nextGameState = outGame.updateGameOver();
                    break;
                }
                case 255: {
                    break;
                }
                default: {
                    nextGameState = outGame.updateUserState(gameState);
                }
            }
        }
        keyDown = 0;
    }

    private void drawGradient(Graphics graphics) {
        int n = this.getHeight();
        int n2 = 63;
        while (n2 < 184) {
            graphics.setColor(n2, n2, n2);
            graphics.fillRect(0, n, this.getWidth(), 1);
            ++n2;
            --n;
        }
        graphics.fillRect(0, 71, this.getWidth(), n - 71 + 1);
        n = 70;
        n2 = 184;
        while (n2 > 113) {
            graphics.setColor(n2, n2, n2);
            graphics.fillRect(0, n, this.getWidth(), 1);
            --n2;
            --n;
        }
    }

    private void draw(Graphics graphics) {
        if (!gameStateValid) {
            return;
        }
        if (nextGameState == -1) {
            switch (gameState) {
                case 2: {
                    outGame.drawLanguageSelection(graphics);
                    break;
                }
                case 3: {
                    outGame.drawSoundYesNo(graphics);
                    break;
                }
                case 4: {
                    outGame.drawOutGameLoading(graphics);
                    break;
                }
                case 6: {
                    menuGame.draw(graphics);
                    break;
                }
                case 8: {
                    inGame.drawIngame(graphics);
                    break;
                }
                case 11: {
                    inGame.drawLevelFinished(graphics);
                    break;
                }
                case 12: {
                    outGame.drawGameFinished(graphics);
                    break;
                }
                case 13: {
                    outGame.drawGameOver(graphics);
                    break;
                }
                case 255: {
                    break;
                }
                default: {
                    outGame.drawUserState(graphics, gameState);
                }
            }
            if (displayLeftSoftkey) {
                if (gameState == 8 || gameState == 11 || gameState == 13) {
                    graphics.drawRegion(imgSoftkey, 0, 0, imgSoftkey.getWidth() / 5, imgSoftkey.getHeight(), 0, 7, MOBCanvas.CANVAS_HEIGHT - imgSoftkey.getHeight() - 5, 0x10 | 4);
                } else {
                    graphics.drawRegion(imgSoftkey, 0, 0, imgSoftkey.getWidth() / 5, imgSoftkey.getHeight(), 0, 0, MOBCanvas.CANVAS_HEIGHT - imgSoftkey.getHeight(), 0x10 | 4);
                }
            }
            if (displayRightSoftkey) {
                if (gameState == 8 || gameState == 11 || gameState == 13) {
                    graphics.drawRegion(imgSoftkey, rightSoftkeyNb * (imgSoftkey.getWidth() / 5), 0, imgSoftkey.getWidth() / 5, imgSoftkey.getHeight(), 0, MOBCanvas.CANVAS_WIDTH - imgSoftkey.getWidth() / 5 - 7, MOBCanvas.CANVAS_HEIGHT - imgSoftkey.getHeight() - 5, 0x10 | 4);
                } else {
                    graphics.drawRegion(imgSoftkey, rightSoftkeyNb * (imgSoftkey.getWidth() / 5), 0, imgSoftkey.getWidth() / 5, imgSoftkey.getHeight(), 0, MOBCanvas.CANVAS_WIDTH - imgSoftkey.getWidth() / 5, MOBCanvas.CANVAS_HEIGHT - imgSoftkey.getHeight(), 0x10 | 4);
                }
            }
            if (menuGame.isCheat && gameState == 6 && (applicationRunningTime / 1000 & 1) == 1) {
                graphics.setColor(255, 0, 0);
                graphics.drawString("Cheat", MOBCanvas.CANVAS_WIDTH / 2, 0, 0x10 | 1);
            }
        }
        if (nextGameState != -1) {
            switch (gameState) {
                case 2: {
                    outGame.closeLanguageSelection();
                    break;
                }
                case 3: {
                    outGame.closeSoundYesNo();
                    break;
                }
                case 4: {
                    outGame.closeOutGameLoading();
                    break;
                }
                case 6: {
                    menuGame.close();
                    break;
                }
                case 8: {
                    if (nextGameState == 11 || nextGameState == 13) break;
                    inGame.closeIngame();
                    break;
                }
                case 11: {
                    inGame.closeLevelFinished();
                    break;
                }
                case 12: {
                    outGame.closeGameFinished();
                    break;
                }
                case 13: {
                    outGame.closeGameOver();
                    break;
                }
                case 255: {
                    break;
                }
                default: {
                    outGame.closeUserState(gameState);
                }
            }
            gameStateValid = false;
            System.gc();
            try {
                Thread.sleep(25L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Image getImage(String string) {
        return topLevel.getResourceImage(string);
    }

    public static Image getImageSimple(String string) {
        return topLevel.getResourceImageSimple(string);
    }

    public static Image getImage(String string, String string2) {
        byte[] byArray = topLevel.getResourceBytes(string2);
        return topLevel.getResourceImage(string, byArray);
    }

    public static byte[] getRawData(String string) {
        return topLevel.getResourceBytes(string);
    }

    public static short[] getRawDataShort(String string) {
        return topLevel.getResourceShort(string);
    }

    public static void enableVibrator(boolean bl) {
        topLevel.setVibrationEnabled(bl);
    }

    public static void vibration(int n) {
        topLevel.vibrate(n);
    }

    public static boolean isVibratorEnabled() {
        return topLevel.isVibrationEnabled();
    }

    public static void activateSoftkeys(boolean bl, boolean bl2, int n) {
        displayLeftSoftkey = bl;
        displayRightSoftkey = bl2;
        rightSoftkeyNb = n;
    }

    public static boolean isSoundEnabled() {
        return mediaManager.isEnabled();
    }

    public static void enableSound(boolean bl) {
        mediaManager.setEnabled(bl);
    }

    public static int getTime() {
        return applicationRunningTime;
    }

    public static void destruct(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
    }

    static int sincos(int n) {
        return sincos[n & 0xFF] << 4;
    }

    static int sin(int n) {
        return gameTopLevel.sincos(n);
    }

    static int cos(int n) {
        return gameTopLevel.sincos(n + 64);
    }

    static int ratan2(int n, int n2) {
        int n3;
        if (n2 == 0) {
            ++n2;
        }
        if (n == 0) {
            ++n;
        }
        if (n2 >= 0) {
            if (n >= 0) {
                if (n2 >= n) {
                    int n4 = (n << 10) / n2;
                    n3 = atan[n4];
                } else {
                    int n5 = (n2 << 10) / n;
                    n3 = 1024 - atan[n5];
                }
            } else if (n2 >= (n = -n)) {
                int n6 = (n << 10) / n2;
                n3 = 4096 - atan[n6];
            } else {
                int n7 = (n2 << 10) / n;
                n3 = 3072 + atan[n7];
            }
        } else {
            n2 = -n2;
            if (n > 0) {
                if (n2 >= n) {
                    int n8 = (n << 10) / n2;
                    n3 = 2048 - atan[n8];
                } else {
                    int n9 = (n2 << 10) / n;
                    n3 = 1024 + atan[n9];
                }
            } else if (n2 >= (n = -n)) {
                int n10 = (n << 10) / n2;
                n3 = 2048 + atan[n10];
            } else {
                int n11 = (n2 << 10) / n;
                n3 = 3072 - atan[n11];
            }
        }
        return n3;
    }

    public void exit() {
        this.postSystemEvent(0);
    }

    public void onSystemEvent(int n) {
        if (n == 1) {
            mediaManager = new MediaManager(this, 15);
            soundGame.init(mediaManager);
            applicationInterrupted = false;
            applicationRunningTime = 0;
            this.setMaxMillisPerTick(40);
            this.setMinMillisPerTick(100);
            keyPressed = 0;
            keyDown = 0;
            sincos = gameTopLevel.getRawData("/SinCos.bin");
            atan = gameTopLevel.getRawDataShort("/Ratan.bin");
            this.onInit();
        } else if (n == 2) {
            mediaManager.stopMusic();
            applicationInterrupted = true;
            if (gameState == 8) {
                inGame.pauseIngame();
            }
            keyPressed = 0;
            keyDown = 0;
            saveGame.saveGameData();
        } else if (n == 3) {
            applicationInterrupted = false;
            Board.drawStatus = 9;
        } else if (n != 4 && n == 0) {
            this.onExit();
        }
        super.onSystemEvent(n);
    }

    public void tickGameLogic() {
        if (applicationInterrupted) {
            return;
        }
        int n = this.getElapsedMillisSinceLastTick();
        applicationRunningTime += n;
        this.updateKeyStates();
        if (this.getKeyTypedStates() != 0) {
            this.onKeyPressed(this.getKeyTypedStates());
        }
        if (this.getKeyReleasedStates() != 0) {
            this.onKeyReleased(this.getKeyReleasedStates());
        }
        this.resetKeyStates();
        this.onTimerTick();
    }

    public void paintGameView(Graphics graphics) {
        if (applicationInterrupted) {
            return;
        }
        this.draw(graphics);
    }
}

