/*
 * Decompiled with CFR 0.152.
 */
public class Waves {
    public static final int PUPCOPTER_MIN_TIME_NORMAL = 14;
    public static final int PUPCOPTER_MIN_TIME_SURVIVAL = 6;
    public static final int TIMER_BETWEEN_WAVES_START = 2;
    public static final int TIMER_BETWEEN_WAVES = 2;
    public static short[] levelData;
    public static int offsetStartWave;
    public static int nbWaves;
    public static short[] offsetWaves;
    public static int pupcopterTimer;
    public static int timerBetweenWaves;
    public static int selectedWave;
    public static int timerCurrentWave;
    public static int nbEnemiesCurrentWave;
    public static short[] timerEnemies;
    public static int survivalLevel;
    static int paramForBigMissile;

    static void initLevel(short[] sArray, int n) {
        levelData = sArray;
        if (inGame.levelNb == 255) {
            pupcopterTimer = 150;
            survivalLevel = 0;
        } else {
            pupcopterTimer = (14 - inGame.levelNb / 3) * 25;
        }
        nbWaves = levelData[n];
        offsetWaves = new short[nbWaves];
        int n2 = 0;
        for (int i = 0; i < nbWaves; ++i) {
            Waves.offsetWaves[i] = (short)(n + 1 + nbWaves + n2);
            n2 += levelData[n + 1 + i];
        }
        timerBetweenWaves = 50;
    }

    static void closeLevel() {
        levelData = null;
        offsetWaves = null;
        timerEnemies = null;
    }

    static void pushParamForBigMissile(int n) {
        paramForBigMissile = n;
    }

    static int getParamForBigMissile() {
        return paramForBigMissile;
    }

    public static void newEnemyWave() {
        timerBetweenWaves = 50;
        timerEnemies = null;
        if (inGame.levelNb == 255 && Board.survivalTime / 60000 > survivalLevel) {
            survivalLevel = Board.survivalTime / 60000;
            Bonus.survivalNewLevel();
            int n = survivalLevel % 20 != 0 ? offsetWaves[nbWaves - 1] + 2 + levelData[offsetWaves[nbWaves - 1] + 1] * 2 : 11 + levelData[10];
            nbWaves = levelData[n];
            offsetWaves = new short[nbWaves];
            int n2 = 0;
            for (int i = 0; i < nbWaves; ++i) {
                Waves.offsetWaves[i] = (short)(n + 1 + nbWaves + n2);
                n2 += levelData[n + 1 + i];
            }
        }
    }

    static void update() {
        int n;
        if ((inGame.gameStatus & 0xC) != 0) {
            timerBetweenWaves = 1;
            return;
        }
        if (--pupcopterTimer <= 0 && (Math.abs(Enemy.rnd.nextInt()) & 0x7F) == 0 && Board.laser != 100 && Bonus.type[0] == -1 && Bonus.takenType == -1) {
            Bonus.updatePossibleBonus();
            if (Bonus.nbBonusPossible != 0) {
                Enemy.addEnemy(11, 255);
                pupcopterTimer = inGame.levelNb == 255 ? 150 : (14 - inGame.levelNb / 3) * 25;
            }
        }
        if (--timerBetweenWaves == 0) {
            selectedWave = Math.abs(Enemy.rnd.nextInt()) % nbWaves;
            timerCurrentWave = levelData[offsetWaves[selectedWave]];
            nbEnemiesCurrentWave = levelData[offsetWaves[selectedWave] + 1];
            timerEnemies = new short[nbEnemiesCurrentWave];
            for (n = 0; n < nbEnemiesCurrentWave; ++n) {
                Waves.timerEnemies[n] = (short)(levelData[offsetWaves[selectedWave]] / levelData[offsetWaves[selectedWave] + 2 + 2 * n + 1]);
            }
        }
        if (timerBetweenWaves < 0) {
            if (--timerCurrentWave < 0) {
                Waves.newEnemyWave();
            } else {
                for (n = 0; n < nbEnemiesCurrentWave; ++n) {
                    int n2 = n;
                    timerEnemies[n2] = (short)(timerEnemies[n2] - 1);
                    if (timerEnemies[n] != 0) continue;
                    short s = levelData[offsetWaves[selectedWave] + 2 + 2 * n];
                    if (s == 10) {
                        int n3 = 2;
                        int n4 = inGame.levelNb;
                        if (n4 == 255) {
                            n4 = survivalLevel;
                        }
                        if (n4 >= 5) {
                            ++n3;
                        }
                        if (n4 >= 7) {
                            ++n3;
                        }
                        for (int i = 0; i < n3; ++i) {
                            Waves.pushParamForBigMissile(MOBCanvas.CANVAS_WIDTH / (n3 + 1) * (i + 1));
                            Enemy.addEnemy(s);
                        }
                    } else {
                        Enemy.addEnemy(s);
                    }
                    Waves.timerEnemies[n] = (short)(levelData[offsetWaves[selectedWave]] / levelData[offsetWaves[selectedWave] + 2 + 2 * n + 1]);
                }
            }
        }
    }
}

