/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class MyGameCanvas
extends Canvas {
    public static byte startRank = 0;
    public static final int SCREEN_WIDTH = 360;
    public static final int SCREEN_HEIGHT = 360;
    protected static final Font FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    protected static final Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    protected static final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    public static final int KEY_UP = -1;
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_LS = -6;
    public static final int KEY_RS = -7;
    public static final int KEY_OK = -5;
    public static final int KEY_BACK = -4;
    public static final byte KEY_0 = 48;
    public static final byte KEY_1 = 49;
    public static final byte KEY_2 = 50;
    public static final byte KEY_3 = 51;
    public static final byte KEY_4 = 52;
    public static final byte KEY_5 = 53;
    public static final byte KEY_6 = 54;
    public static final byte KEY_7 = 55;
    public static final byte KEY_8 = 56;
    public static final byte KEY_9 = 57;
    public static final byte KEY_STAR = 42;
    public static final byte KEY_SHARP = 35;
    protected static final byte ST_M = -3;
    protected static final byte ST_SP = -2;
    protected static final byte ST_CP = -1;
    protected static final byte ST_ASK_SOUND = 0;
    protected static final byte ST_OPEN = 19;
    protected static final byte ST_LOAD = 1;
    protected static final byte ST_MENU = 2;
    protected static final byte ST_MIDMENU = 3;
    protected static final byte ST_SETUP = 4;
    protected static final byte ST_HELP = 5;
    protected static final byte ST_ABOUT = 6;
    protected static final byte ST_PLAY = 7;
    protected static final byte ST_OVER = 8;
    protected static final byte ST_PAUSE = 9;
    protected static final byte ST_TALK = 10;
    protected static final byte ST_IN_DOOR_EFFECT = 11;
    protected static final byte ST_START_MAZE = 13;
    protected static final byte ST_START_EFFECT = 14;
    protected static final byte ST_PASS_EFFECT = 15;
    protected static final byte ST_READY = 16;
    protected static final byte ST_OP = 17;
    protected static final byte ST_PASS_GAME = 18;
    protected static final byte ST_PHONE = 20;
    static byte gameStatus = 0;
    static byte lastStatus = 0;
    static int index = 0;
    static boolean isNewGame = true;
    GameEngine engine;
    SoundPlayerUtil soundPlayer = new SoundPlayerUtil();
    static MyGameCanvas me;
    static String[][] TalkContent;
    byte[][] roles = new byte[][]{{0}};
    static final byte COL_MAX = 8;
    static final byte ROW_MAX = 2;
    static String talkString;
    static int startIndex;
    static int endIndex;
    static byte eventType;
    static byte eventCourse;
    static int icon;
    boolean talkkeyPressed;
    private static final String[] strAbout;
    static final String[] helpInfo;
    final int ROW_NUMBER;
    private int pages;
    int soundIsOpen = 0;
    int key;
    boolean isBreak = false;
    byte lasttele;
    static int keys;
    static short[][] playPos;

    public MyGameCanvas() {
        this.ROW_NUMBER = 11;
        this.setFullScreenMode(true);
        me = this;
        this.engine = new GameEngine();
    }

    public static void setST(byte st) {
        index = 0;
        lastStatus = gameStatus;
        gameStatus = st;
    }

    private void drawMenu(int x, int y, int lev) {
        Tools.addObject(32, x, y, 20, (byte)0, lev);
        int startX = x + 180;
        int startY = y + 360 - 42;
        Tools.addObject(20, startX, startY, 17, (byte)0, lev);
        byte[] motion = new byte[]{0, 1, 3, 2, 4, 5};
        Tools.addObject(26, startX, startY + 15, 0, 14 * motion[index], 85, 14, 17, (byte)0, lev);
    }

    private void drawMidMenu(int x, int y, int lev) {
        this.drawMenuBg(x, y, lev);
        int startX = x + 180;
        int startY = y + 360 - 62;
        Tools.addObject(20, startX, startY, 17, (byte)0, lev);
        byte[] motion = new byte[]{1, 3, 2, 6};
        Tools.addObject(26, startX, startY + 15, 0, 14 * motion[index], 85, 14, 17, (byte)0, lev);
    }

    public void drawMenuBg(int x, int y, int lev) {
        Tools.addObject((byte)1, x, y, 360, 360, true, 20, 0x556655, lev);
        int h1 = 42;
        Tools.addObject((byte)1, x, y, 360, h1, true, 20, 0x224422, lev);
        Tools.addObject((byte)1, x, y + h1 + 5, 360, 4, true, 20, 0x224422, lev);
        int h2 = 34;
        Tools.addObject((byte)1, x, y + h2, 360, 1, true, 20, 0x556655, lev);
        Tools.addObject((byte)1, x, y + 360, 360, h1, true, 36, 0x224422, lev);
        Tools.addObject((byte)1, x, y + 360 - h1 - 5, 360, 4, true, 36, 0x224422, lev);
        Tools.addObject((byte)1, x, y + 360 - h2, 360, 1, true, 36, 0x556655, lev);
    }

    public void drawCleanScreen(int color) {
        Tools.addObject((byte)1, GameMap.setOffX, GameMap.setOffY, 360, 360, true, 20, color, 0);
    }

    private void drawPassGame() {
        if (++index > 25) {
            Tools.removeAllImage();
            MyGameCanvas.setST((byte)2);
        } else {
            int y = Math.min(index * 5, 180);
            Tools.addObject((byte)4, "Game Completed.", 180, y, 17, 1193046, 0);
        }
    }

    private void drawLogo(Graphics g, int type) {
        int imgLogo = 0;
        int col = 0xFFFFFF;
        switch (type) {
            case -3: {
                imgLogo = 29;
                break;
            }
            case -2: {
                imgLogo = 43;
                break;
            }
            case -1: {
                imgLogo = 5;
                col = 0;
            }
        }
        if (++index < 15) {
            this.drawCleanScreen(col);
            Tools.addObject(imgLogo, 180, 180, 3, (byte)0, 0);
        } else {
            this.keyPressed(48);
        }
    }

    public void drawOpen(int x, int y) {
        Tools.addObject(32, x, y, 20, (byte)0, 0);
        if (GameMIDlet.gameIndex % 4 / 2 == 0) {
            Tools.addObject((byte)4, "Press any key.", x + 180, y + 360 - 40, 17, 0xFFFFFF, 1);
        }
    }

    private void drawButton(String str1, String str2, int x, int y, int lev) {
        Tools.addObject((byte)4, str1, x + 2, y + 360 - 3, 36, 0xFFFFFF, lev);
        Tools.addObject((byte)4, str2, x + 360 - 2, y + 360 - 3, 40, 0xFFFFFF, lev);
    }

    protected void paint(Graphics g) {
        g.setFont(FONT_SMALL);
        switch (gameStatus) {
            case 0: {
                this.drawAskSound();
                break;
            }
            case 4: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawSetup(g, GameMap.setOffX, GameMap.setOffY);
                break;
            }
            case 8: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawOver(GameMap.setOffX, GameMap.setOffY, 2000);
                break;
            }
            case 3: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawMidMenu(GameMap.setOffX, GameMap.setOffY, 2000);
                break;
            }
            case -2: {
                this.drawLogo(g, -2);
                break;
            }
            case -1: {
                this.drawLogo(g, -1);
                break;
            }
            case -3: {
                this.drawLogo(g, -3);
                break;
            }
            case 19: {
                this.drawOpen(GameMap.setOffX, GameMap.setOffY);
                break;
            }
            case 2: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawMenu(GameMap.setOffX, GameMap.setOffY, 0);
                break;
            }
            case 1: {
                this.drawLoad(g);
                break;
            }
            case 5: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawHelp(g, GameMap.setOffX, GameMap.setOffY);
                break;
            }
            case 14: {
                this.engine.drawGame(g, false);
                this.drawStartEffect(g);
                break;
            }
            case 15: {
                this.drawPassEffect(g);
                break;
            }
            case 6: {
                g.translate(-GameMap.setOffX, -GameMap.setOffY);
                this.drawAbout(g, GameMap.setOffX, GameMap.setOffY);
                break;
            }
            case 16: {
                this.drawReady(g);
                break;
            }
            case 7: {
                this.engine.runGame();
                this.engine.drawGame(g, true);
                if (!this.isBreak) break;
                gameStatus = (byte)9;
                break;
            }
            case 10: {
                this.engine.drawGame(g, true);
                break;
            }
            case 9: 
            case 20: {
                Tools.addObject((byte)1, 0, 0, 360, 360, true, 20, 0, 100);
                Tools.addObject((byte)4, "Pause", 180, 180, 0x10 | 1, 0xFF0000, 100);
                Tools.addObject((byte)4, "Resume", 358, 357, 40, 0xFF0000, 100);
                this.isBreak = false;
                break;
            }
            case 18: {
                this.drawCleanScreen(0);
                this.drawPassGame();
            }
        }
        this.drawAll(g);
        if (gameStatus != 9) {
            GameMap cfr_ignored_0 = this.engine.map;
            GameMap cfr_ignored_1 = this.engine.map;
            g.drawImage(Tools.getImage(48), GameMap.setOffX, GameMap.setOffY, 20);
            GameMap cfr_ignored_2 = this.engine.map;
            GameMap cfr_ignored_3 = this.engine.map;
            g.drawImage(Tools.getImage(49), GameMap.setOffX + 640 - 140, GameMap.setOffY, 20);
        }
    }

    private void drawReady(Graphics g) {
        switch (this.engine.gameRank) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.engine.role.isLeft = false;
                if (this.engine.role.curStatus != 11) {
                    this.engine.role.setStatus((byte)11);
                }
                if (this.engine.role.x <= 25) break;
                if (this.engine.gameRank == 4) {
                    this.engine.toTalkStatus(7);
                } else {
                    MyGameCanvas.setST((byte)7);
                }
                GameRole cfr_ignored_0 = this.engine.role;
                GameRole.isAuto = false;
                this.engine.role.setStatus((byte)5);
            }
        }
        this.engine.role.move();
        GameMap cfr_ignored_1 = this.engine.map;
        GameMap cfr_ignored_2 = this.engine.map;
        GameMap.setOff(0, GameMap.setOffY);
        this.engine.drawGame(g, true);
    }

    private void drawOver(int x, int y, int lev) {
        this.drawMenuBg(x, y, lev);
        int startX = x + 180;
        int startY = y + 360 - 62;
        Tools.addObject(20, startX, startY, 17, (byte)0, lev);
        byte[] motion = new byte[]{1, 6, 5};
        Tools.addObject(26, startX, startY + 15, 0, 13 * motion[index], 58, 13, 17, (byte)0, lev);
    }

    private void drawLoad(Graphics g) {
        switch (index) {
            case 4: {
                this.engine.initGame((byte)0);
                break;
            }
            case 8: {
                this.engine.initGame((byte)1);
                break;
            }
            case 12: {
                this.engine.initGame((byte)2);
                break;
            }
            case 17: {
                MyGameCanvas.setST((byte)14);
                SoundPlayerUtil.playmusic(1);
                return;
            }
        }
        g.translate(-GameMap.setOffX, -GameMap.setOffY);
        this.drawMenuBg(GameMap.setOffX, GameMap.setOffY, 0);
        int tempx = GameMap.setOffX + 180 - 51;
        int tempy = GameMap.setOffY + 180;
        Tools.addObject((byte)1, tempx, tempy, 102, 11, true, 20, 0xFFFFFF, 0);
        Tools.addObject((byte)1, tempx + 1, tempy + 1, 99, 8, false, 20, 0, 0);
        Tools.addObject(25, tempx + 3, tempy + 3, 0, 0, 6 * index, 5, 20, (byte)0, 0);
        ++index;
    }

    static void initTalk() {
        talkString = TalkContent[eventType][eventCourse];
        startIndex = 0;
        endIndex = 0;
    }

    public void endTalk() {
        MyGameCanvas.setST((byte)7);
    }

    private void drawPassEffect(Graphics g) {
        GameMap cfr_ignored_0 = this.engine.map;
        GameMap.setOff(0, 0);
        if (index < 10) {
            int i = 0;
            while (i < 4) {
                GameMap cfr_ignored_1 = this.engine.map;
                GameMap cfr_ignored_2 = this.engine.map;
                Tools.addObject((byte)2, GameMap.setOffX - 400 + 180, GameMap.setOffY - 400 + 180, 800, 800, 90 * i, index * 10, true, 20, 0, 9999);
                ++i;
            }
        } else if (this.engine.gameRank == 5) {
            MyGameCanvas.setST((byte)18);
        } else if (this.engine.role.HP <= 0) {
            MyGameCanvas.setST((byte)8);
            index = -1;
        } else {
            this.engine.gameRank = (byte)((this.engine.gameRank + 1) % 6);
            this.engine.writeDB();
            MyGameCanvas.setST((byte)1);
            index = -1;
        }
        ++index;
    }

    private void drawStartEffect(Graphics g) {
        if (index < 10) {
            int i = 0;
            while (i < 4) {
                GameMap cfr_ignored_0 = this.engine.map;
                GameMap cfr_ignored_1 = this.engine.map;
                Tools.addObject((byte)2, GameMap.setOffX - 400 + 180, GameMap.setOffY - 400 + 180, 800, 800, 90 * i, (10 - index) * 9, true, 20, 0, 9999);
                ++i;
            }
        } else {
            MyGameCanvas.setST((byte)7);
        }
        ++index;
    }

    private void drawAbout(Graphics g, int x, int y) {
        this.drawMenuBg(x, y, 1);
        Tools.addObject((byte)4, "About", x + 180, y + 20, 0x10 | 1, 0xFFFFFF, 1);
        int i = 0;
        while (i < strAbout.length) {
            Tools.addObject((byte)4, strAbout[i], x + 180, y + 45 + i * 20, 0x10 | 1, 0xFFFFFF, 1);
            ++i;
        }
        this.drawButton("", "Resume", x, y, 3000);
    }

    private void drawHelp(Graphics g, int x, int y) {
        this.drawMenuBg(x, y, 3000);
        this.pages = (helpInfo.length - 1) / 11 + 1;
        if (index >= this.pages || index < 0) {
            index = (index + this.pages) % this.pages;
        }
        int start = index * 11;
        Tools.addObject((byte)4, "Help", x + 180 + 1, y + 30, 17, 0xFFFFFF, 3000);
        int i = 0;
        while (i < 11 && start + i < helpInfo.length) {
            Tools.addObject((byte)4, helpInfo[start + i], x + 180, y + 55 + i * 20, 17, 0xFFFFFF, 3000);
            ++i;
        }
        if (index != 0) {
            Tools.addObject((byte)4, "<<", x + 180 - 1, y + 360 - 5, 40, 0xFFFFFF, 3000);
        }
        if (index != this.pages - 1) {
            Tools.addObject((byte)4, ">>", x + 180 + 1, y + 360 - 5, 36, 0xFFFFFF, 3000);
        }
        this.drawButton("", "Return", x, y, 3000);
    }

    public void drawSetup(Graphics g, int x, int y) {
        this.drawMenuBg(x, y, 3000);
        Tools.addObject((byte)4, "Settings", 181 + x, 10 + y, 17, 0xFFFFFF, 3000);
        Tools.addObject((byte)4, "Sound", 170 + x, 40 + y, 24, 0xFFFFFF, 3000);
        Tools.addObject((byte)4, SoundPlayerUtil.soundIsOpen ? "open" : "close", 190 + x, 40 + y, 20, 0xFF0000, 3000);
        this.drawButton("OK", "Return", x, y, 3000);
    }

    public void playMusic() {
        switch (gameStatus) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                SoundPlayerUtil.playmusic(0);
                break;
            }
            default: {
                SoundPlayerUtil.playmusic(1);
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.key = keyCode;
        MyGameCanvas.press(this.key);
        switch (gameStatus) {
            case 0: {
                switch (this.key) {
                    case -6: 
                    case -5: 
                    case 53: {
                        SoundPlayerUtil.soundIsOpen = true;
                        SoundPlayerUtil.playmusic(0);
                        MyGameCanvas.setST((byte)19);
                        break;
                    }
                    case -7: {
                        SoundPlayerUtil.soundIsOpen = false;
                        MyGameCanvas.setST((byte)19);
                    }
                }
                break;
            }
            case 4: {
                switch (this.key) {
                    case -6: 
                    case -5: 
                    case 53: {
                        SoundPlayerUtil.soundIsOpen = !SoundPlayerUtil.soundIsOpen;
                        if (SoundPlayerUtil.soundIsOpen) {
                            if (lastStatus == 2) {
                                SoundPlayerUtil.playmusic(0);
                                break;
                            }
                            SoundPlayerUtil.playmusic(1);
                            break;
                        }
                        MyGameCanvas myGameCanvas = this;
                        myGameCanvas.soundPlayer.stopAllMusic();
                        break;
                    }
                    case -7: {
                        MyGameCanvas.setST(lastStatus);
                    }
                }
                break;
            }
            case 8: {
                block25 : switch (keyCode) {
                    case -4: 
                    case 54: {
                        index = index + 1 >= 3 ? 0 : index + 1;
                        break;
                    }
                    case -3: 
                    case 52: {
                        index = index - 1 <= -1 ? 2 : index - 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        switch (index) {
                            case 0: {
                                MyGameCanvas.setST((byte)1);
                                break block25;
                            }
                            case 1: {
                                MyGameCanvas.setST((byte)2);
                                SoundPlayerUtil.playmusic(0);
                                break block25;
                            }
                            case 2: {
                                GameMIDlet.quitApp();
                            }
                        }
                    }
                }
                break;
            }
            case -2: {
                Tools.removeImage(43);
                SoundPlayerUtil.playmusic(0);
                MyGameCanvas.setST((byte)19);
                break;
            }
            case -1: {
                Tools.removeImage(5);
                SoundPlayerUtil.playmusic(0);
                MyGameCanvas.setST((byte)19);
                break;
            }
            case -3: {
                Tools.removeImage(29);
                MyGameCanvas.setST((byte)-2);
                break;
            }
            case 19: {
                MyGameCanvas.setST((byte)2);
                break;
            }
            case 2: {
                block35 : switch (keyCode) {
                    case -3: 
                    case 52: {
                        if (index > 0) {
                            --index;
                            break;
                        }
                        index = 5;
                        break;
                    }
                    case -4: 
                    case 54: {
                        if (index < 5) {
                            ++index;
                            break;
                        }
                        index = 0;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        switch (index) {
                            case 0: {
                                Tools.removeAllImage();
                                this.engine.gameRank = 0;
                                this.engine.score = 0;
                                this.engine.passNum = 0;
                                this.engine.passNum2 = 0;
                                MyGameCanvas.setST((byte)1);
                                break block35;
                            }
                            case 1: {
                                Tools.removeAllImage();
                                this.engine.passNum = 0;
                                this.engine.passNum2 = 0;
                                this.engine.readDB();
                                MyGameCanvas.setST((byte)1);
                                break block35;
                            }
                            case 2: {
                                MyGameCanvas.setST((byte)5);
                                break block35;
                            }
                            case 3: {
                                MyGameCanvas.setST((byte)4);
                                break block35;
                            }
                            case 4: {
                                MyGameCanvas.setST((byte)6);
                                break block35;
                            }
                            case 5: {
                                GameMIDlet.quitApp();
                            }
                        }
                    }
                }
                break;
            }
            case 3: {
                block48 : switch (keyCode) {
                    case -3: 
                    case 52: {
                        if (index > 0) {
                            --index;
                            break;
                        }
                        index = 3;
                        break;
                    }
                    case -4: 
                    case 54: {
                        if (index < 3) {
                            ++index;
                            break;
                        }
                        index = 0;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        switch (index) {
                            case 0: {
                                MyGameCanvas.setST((byte)7);
                                break block48;
                            }
                            case 1: {
                                MyGameCanvas.setST((byte)5);
                                break block48;
                            }
                            case 2: {
                                MyGameCanvas.setST((byte)4);
                                break block48;
                            }
                            case 3: {
                                MyGameCanvas.setST((byte)2);
                                Tools.removeAllImage();
                                GameMap cfr_ignored_0 = this.engine.map;
                                GameMap.setOff(0, 0);
                                SoundPlayerUtil.playmusic(0);
                            }
                        }
                    }
                }
                break;
            }
            case 5: {
                switch (keyCode) {
                    case -4: {
                        if (index >= this.pages - 1) break;
                        ++index;
                        break;
                    }
                    case -3: {
                        if (index <= 0) break;
                        --index;
                        break;
                    }
                    case -7: 
                    case -5: {
                        index = 0;
                        MyGameCanvas.setST(lastStatus);
                    }
                }
                break;
            }
            case 6: {
                switch (keyCode) {
                    case -7: 
                    case -5: {
                        MyGameCanvas.setST(lastStatus);
                    }
                }
                break;
            }
            case 7: {
                this.engine.ctrl(keyCode);
                switch (keyCode) {
                    case -6: {
                        this.engine.role.keyIsDealed = true;
                        MyGameCanvas.setST((byte)3);
                        break;
                    }
                    case -7: {
                        MyGameCanvas.setST((byte)9);
                        MyGameCanvas myGameCanvas = this;
                        myGameCanvas.soundPlayer.stopAllMusic();
                    }
                }
                break;
            }
            case 20: {
                switch (this.key) {
                    case -7: {
                        gameStatus = this.lasttele;
                        this.isBreak = false;
                        this.playMusic();
                    }
                }
                break;
            }
            case 9: {
                switch (keyCode) {
                    case -7: {
                        MyGameCanvas.setST((byte)7);
                        this.playMusic();
                    }
                }
                break;
            }
            case 10: {
                switch (keyCode) {
                    case -5: 
                    case 53: {
                        switch (this.key) {
                            case -5: 
                            case 53: {
                                this.talkkeyPressed = true;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
        MyGameCanvas.release(keyCode);
        if (gameStatus == 7) {
            this.engine.ctrlReleased(keyCode);
        }
    }

    private void drawAll(Graphics g) {
        this.sort();
        int i = 0;
        while (i < Tools.max_obj) {
            Tools.drawMe(g, Tools.drawObj[i]);
            ++i;
        }
        Tools.max_obj = 0;
    }

    private void sort() {
        boolean cout = false;
        int i = 1;
        while (i < Tools.max_obj) {
            if (Tools.drawLevel[Tools.drawObj[i]] < Tools.drawLevel[Tools.drawObj[i - 1]]) {
                int temp = Tools.drawObj[i];
                int j = i - 1;
                do {
                    Tools.drawObj[j + 1] = Tools.drawObj[j];
                } while (--j >= 0 && Tools.drawLevel[temp] < Tools.drawLevel[Tools.drawObj[j]]);
                Tools.drawObj[j + 1] = temp;
            }
            ++i;
        }
    }

    public void showNotify() {
        this.key = 0;
        if (gameStatus <= 0) {
            return;
        }
        MyGameCanvas myGameCanvas = this;
        myGameCanvas.soundPlayer.stopAllMusic();
        if (!this.isBreak) {
            this.lasttele = gameStatus;
        }
        this.isBreak = true;
        gameStatus = (byte)20;
    }

    public void hideNotify() {
        this.key = 0;
        if (gameStatus <= 0) {
            return;
        }
        MyGameCanvas myGameCanvas = this;
        myGameCanvas.soundPlayer.stopAllMusic();
        if (!this.isBreak) {
            this.lasttele = gameStatus;
        }
        this.isBreak = true;
        gameStatus = (byte)20;
    }

    public static int getKeyIndex(int key) {
        switch (key) {
            case -1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case -3: {
                return 4;
            }
            case -4: {
                return 8;
            }
            case -6: {
                return 16;
            }
            case -7: {
                return 32;
            }
            case -5: {
                return 64;
            }
            case 48: {
                return 128;
            }
            case 49: {
                return 256;
            }
            case 50: {
                return 512;
            }
            case 51: {
                return 1024;
            }
            case 52: {
                return 2048;
            }
            case 53: {
                return 4096;
            }
            case 54: {
                return 8192;
            }
            case 55: {
                return 16384;
            }
            case 56: {
                return 32768;
            }
            case 57: {
                return 65536;
            }
        }
        return 0;
    }

    public static boolean isPressed(int key) {
        return (keys & MyGameCanvas.getKeyIndex(key)) != 0;
    }

    public static void press(int key) {
        keys |= MyGameCanvas.getKeyIndex(key);
    }

    public static void release(int key) {
        keys &= ~MyGameCanvas.getKeyIndex(key);
    }

    private void drawAskSound() {
        this.drawCleanScreen(0);
        Tools.addObject(42, 167, 273, 20, (byte)0, 10);
        Tools.addObject((byte)4, "Open Sound?", 180, 309, 17, 0xFFFFFF, 10);
        Tools.addObject((byte)4, "Yes", 10, 354, 36, 0xFFFFFF, 10);
        Tools.addObject((byte)4, "No", 350, 354, 40, 0xFFFFFF, 10);
    }

    public static int getButton(int x, int y, short[][] buttons) {
        int i = 0;
        while (i < buttons.length) {
            if (MyGameCanvas.hitButton(x, y, buttons[i][0], buttons[i][1], buttons[i][2], buttons[i][3])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean hitButton(int x1, int y1, int x2, int y2, int w2, int h2) {
        return x1 <= x2 + w2 && x1 >= x2 && y1 <= y2 + h2 && y1 >= y2;
    }

    public void pointerPressed(int x, int y) {
        int button = -1;
        button = MyGameCanvas.getButton(x, y, playPos);
        switch (button) {
            case 0: {
                this.keyPressed(-1);
                break;
            }
            case 1: {
                this.keyPressed(-2);
                break;
            }
            case 2: {
                this.keyPressed(-3);
                break;
            }
            case 3: {
                this.keyPressed(-4);
                break;
            }
            case 4: {
                this.keyPressed(-5);
                break;
            }
            case 5: {
                this.keyPressed(-6);
                break;
            }
            case 6: {
                this.keyPressed(-7);
                break;
            }
            case 7: {
                this.keyPressed(35);
                break;
            }
            case 8: {
                this.keyPressed(42);
                break;
            }
            case 9: {
                this.keyPressed(48);
                break;
            }
            case 10: {
                this.keyPressed(55);
                break;
            }
            case 11: {
                this.keyPressed(57);
                break;
            }
            case 12: {
                this.keyPressed(49);
                break;
            }
            case 13: {
                this.keyPressed(51);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        this.keyReleased(-1);
        this.keyReleased(-2);
        this.keyReleased(-3);
        this.keyReleased(-4);
        this.keyReleased(-5);
        this.keyReleased(-6);
        this.keyReleased(-7);
        this.keyReleased(35);
        this.keyReleased(42);
        this.keyReleased(48);
        this.keyReleased(55);
        this.keyReleased(57);
        this.keyReleased(49);
        this.keyReleased(51);
    }

    static {
        TalkContent = new String[][]{{""}};
        strAbout = new String[]{"Metal Gun", "v1.0.0", "2012 M3GWORKS", "All rights reserved.", "Developed by:", "TouchMagic", "Help and support:", "support@m3gworks.com", "www.m3gworks.com"};
        helpInfo = new String[]{"Controls", "Left Soft Key: Confirm/In-game Menu", "Right Soft Key: Resume/Pause", "Left/Num 4: Move Left", "Right/Num 6: Move Right", "Up/Num 2: Jump", "Down/Num 8: Squat", "Num 5: Attack", "Num 1/Num 3: Attack Upward", "Num 8: Attack Downward while jumping", "Num 7/Num 9: Throw Grenade"};
        playPos = new short[][]{{50, 135, 37, 31}, {50, 195, 37, 32}, {5, 165, 46, 33}, {86, 165, 48, 33}, {543, 114, 52, 53}, {0, 114, 43, 27}, {96, 114, 43, 25}, {549, 210, 42, 25}, {596, 210, 42, 25}, {502, 210, 42, 25}, {501, 170, 43, 25}, {595, 170, 43, 25}, {501, 86, 43, 25}, {595, 86, 43, 25}};
    }
}

