/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class GameMap {
    static final int TILE_PASS = 0;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static byte tileWidth;
    static byte tileHight;
    int[] mapSize = new int[2];
    short[] tileProperties;
    String[] name;
    static int setOffX;
    static int setOffY;
    short roleY;
    short roleX;
    byte boardXSpeed;
    byte boardYSpeed;
    byte[] mapData;
    byte gameRank;
    short[][] doorPos;
    short[][] deckPos;
    short[][] ice_boardPos;
    short[][] arrowPos;
    static byte shakeTime;
    public static final byte SCEEN_MOVE = 10;
    public static byte[] deckImage;

    public void free() {
        this.mapData = null;
        this.doorPos = null;
        this.deckPos = null;
        this.ice_boardPos = null;
        this.arrowPos = null;
        System.gc();
    }

    public GameMap(int sw, int sh) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
        GameMap.setOff(0, 0);
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void screenShake() {
        if (shakeTime > 0) {
            setOffY = (shakeTime = (byte)(shakeTime - 1)) % 2 == 0 ? (short)(setOffY + 4) : (short)(setOffY - 4);
        }
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, this.mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public void init(int GameRank) {
        this.gameRank = (byte)GameRank;
        this.free();
        this.loadMap("" + GameRank + ".dat");
        Tools.createImage(this.name, 1);
        switch (GameRank) {
            case 3: {
                this.deckPos = new short[][]{{496, 304, 4, 0}, {1680, 240, 4, 0}, {2619, 307, 2, 0}, {183, 379, 1, 0}, {1107, 315, 1, 0}, {2332, 251, 1, 0}, {2903, 315, 1, 0}, {2621, 247, 3, 0}, {0, 350, 0, 0}, {324, 315, 0, 0}, {499, 284, 0, 0}, {1062, 285, 0, 0}, {1329, 253, 0, 0}, {2284, 252, 0, 0}, {2492, 283, 0, 0}, {2734, 286, 0, 0}, {2994, 316, 0, 0}, {3189, 348, 0, 0}, {3342, 348, 0, 0}};
                break;
            }
            case 4: {
                this.deckPos = new short[][]{{0, 350, 0, 0}, {333, 349, 0, 0}, {559, 348, 0, 0}, {918, 348, 0, 0}, {1120, 349, 0, 0}, {1379, 346, 0, 0}, {1611, 346, 0, 0}, {1847, 346, 0, 0}, {2089, 348, 0, 0}, {2290, 347, 0, 0}, {2619, 348, 0, 0}, {2879, 315, 0, 0}, {3162, 347, 0, 0}, {672, 371, 4, 0}, {1008, 371, 4, 0}, {2848, 338, 4, 0}, {2896, 338, 4, 0}, {3152, 338, 4, 0}, {862, 379, 1, 0}, {2810, 347, 1, 0}, {218, 371, 2, 0}, {2491, 371, 2, 0}, {3257, 370, 2, 0}, {1050, 370, 2, 0}, {219, 313, 3, 0}, {1051, 310, 3, 0}, {3258, 310, 3, 0}, {2494, 312, 3, 0}};
                break;
            }
            case 5: {
                this.deckPos = new short[][]{{0, 350, 0, 0}, {327, 348, 0, 0}, {569, 315, 0, 0}, {807, 282, 0, 0}, {1425, 283, 0, 0}, {1589, 313, 0, 0}, {1830, 349, 0, 0}, {2119, 348, 0, 0}, {2354, 351, 0, 0}, {2615, 349, 0, 0}, {2867, 312, 0, 0}, {3054, 346, 0, 0}, {3308, 344, 0, 0}, {593, 349, 1, 0}, {989, 318, 1, 0}, {2813, 347, 1, 0}, {154, 312, 3, 0}, {153, 372, 2, 0}, {880, 304, 4, 0}, {1680, 304, 4, 0}, {3376, 368, 4, 0}};
                break;
            }
            default: {
                this.deckPos = GameEngine.getPosData("deck" + GameRank + ".dat");
            }
        }
        switch (GameRank) {
            case 0: {
                this.doorPos = new short[][]{{2828, 402, 32, 128}};
                break;
            }
            case 1: {
                this.doorPos = new short[][]{{3517, 407, 32, 128}};
                break;
            }
            case 2: {
                this.doorPos = new short[][]{{1276, 392, 32, 128}};
                break;
            }
            case 3: {
                this.doorPos = new short[][]{{3560, 392, 32, 128}};
                break;
            }
            case 4: {
                this.doorPos = new short[][]{{3550, 392, 32, 128}};
            }
        }
    }

    public void setMapBG(Graphics g) {
        switch (this.gameRank) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                GameMap.drawFullScreenBG(1, setOffY, 80, 0);
            }
        }
    }

    public void setTile() {
        int n = setOffX / tileWidth * this.mapSize[1] + setOffY / tileHight;
        int nw = SCREEN_WIDTH / tileWidth + 2;
        int nh = SCREEN_HEIGHT / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * this.mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData.length && i >= 0 && this.mapData[i] != -1) {
                    int dataTemp = GameMap.getLow(this.mapData[i]);
                    int x = i / this.mapSize[1] * tileHight;
                    int y = i % this.mapSize[1] * tileWidth;
                    byte trans = (byte)GameMap.getTrans(this.mapData[i]);
                    Tools.addObject(100 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, trans, 10);
                }
                ++i;
            }
            ++j;
        }
    }

    public void setMap(Graphics g) {
        this.setMapBG(g);
        if (this.mapData != null) {
            this.setTile();
        }
        this.setMapFG();
    }

    public void setMapFG() {
        this.drawDecks(this.deckPos);
    }

    public void moveSrceen(int x, int y, boolean isLeft) {
        int posX = isLeft ? 100 : 75;
        int posY = 116;
        setOffX = Math.abs(x - setOffX - posX) > 10 ? (x - setOffX - posX >= 10 ? (setOffX += 10) : (setOffX -= 10)) : (int)((short)(x - posX));
        setOffX = (short)Math.max(setOffX, GameRole.sceen_min);
        setOffX = (short)Math.min(setOffX, GameRole.sceen_max - SCREEN_WIDTH);
        setOffY = Math.abs(y - setOffY - posY) > 10 ? (y - setOffY - posY >= 10 ? (setOffY += 10) : (setOffY -= 10)) : (int)((short)(y - posY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, this.mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public void adjustSrceen(int x, int y, boolean isLeft) {
        int posX = isLeft ? 100 : 75;
        int posY = 116;
        setOffX = (short)(x - posX);
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, this.mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = (short)(y - posY);
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, this.mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public boolean canUp(int x, int y) {
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)13);
    }

    public final boolean canFall(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)14);
    }

    public boolean onBoard(int x, int y, int w, int h) {
        if (this.ice_boardPos != null) {
            int i = 0;
            while (i < this.ice_boardPos.length) {
                if (Tools.hit(x, y, w, 5, this.ice_boardPos[i][0], this.ice_boardPos[i][1] + 10, 48, 10)) {
                    this.roleY = (short)(this.ice_boardPos[i][1] - 1);
                    if (this.ice_boardPos[i][3] == 1) {
                        this.boardXSpeed = (byte)(this.ice_boardPos[i][4] * this.ice_boardPos[i][6]);
                        this.boardYSpeed = (byte)(this.ice_boardPos[i][4] * this.ice_boardPos[i][8]);
                    } else {
                        this.boardXSpeed = 0;
                        this.boardYSpeed = 0;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean canRun(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)15);
    }

    private byte inMapData(int x, int y) {
        int n = x / tileWidth * this.mapSize[1] + y / tileHight;
        if (n < 0 || n >= this.mapData.length) {
            return -1;
        }
        return this.mapData[n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int times = SCREEN_WIDTH / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, height, 20, (byte)0, level);
            ++i;
        }
    }

    public void drawSingeThings(int imgIndex, short[][] things, boolean isMirror, int level, int tileSize) {
        short imgWidth = (short)Tools.getImage(imgIndex).getWidth();
        short imgHight = (short)Tools.getImage(imgIndex).getHeight();
        int i = 0;
        while (i < things.length) {
            int x = things[i][0] * tileSize;
            int y = things[i][1] * tileSize;
            if (x > setOffX + SCREEN_WIDTH) {
                return;
            }
            if (x + imgWidth >= setOffX) {
                Tools.addObject(imgIndex, x, y, 0, 0, imgWidth, imgHight, 20, (byte)0, level);
            }
            ++i;
        }
    }

    public void drawDecks(short[][] things) {
        if (things == null) {
            return;
        }
        int i = 0;
        while (i < things.length) {
            if (this.gameRank != 1 || things[i][2] != 2 && things[i][2] != 3) {
                int lev = 0;
                switch (things[i][2]) {
                    case 0: {
                        lev = 0;
                        break;
                    }
                    case 1: {
                        lev = 101;
                        break;
                    }
                    case 2: {
                        lev = 10;
                        break;
                    }
                    case 3: {
                        lev = 101;
                        break;
                    }
                    case 4: {
                        lev = 10;
                    }
                }
                Tools.addObject(deckImage[things[i][2]], things[i][0], things[i][1], 36, things[i][3] == 1 ? (byte)1 : 0, lev);
            }
            ++i;
        }
    }

    public void moveIceBoard() {
        if (this.ice_boardPos != null) {
            int i = 0;
            while (i < this.ice_boardPos.length) {
                switch (this.ice_boardPos[i][3]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (this.ice_boardPos[i][2] == this.ice_boardPos[i][7]) {
                            short[] sArray = this.ice_boardPos[i];
                            sArray[6] = (short)(sArray[6] * -1);
                            short[] sArray2 = this.ice_boardPos[i];
                            sArray2[8] = (short)(sArray2[8] * -1);
                            this.ice_boardPos[i][2] = 0;
                            this.ice_boardPos[i][3] = 2;
                            break;
                        }
                        short[] sArray = this.ice_boardPos[i];
                        sArray[0] = (short)(sArray[0] + this.ice_boardPos[i][4] * this.ice_boardPos[i][6]);
                        short[] sArray3 = this.ice_boardPos[i];
                        sArray3[1] = (short)(sArray3[1] + this.ice_boardPos[i][5] * this.ice_boardPos[i][8]);
                        short[] sArray4 = this.ice_boardPos[i];
                        sArray4[2] = (short)(sArray4[2] + 1);
                        break;
                    }
                    case 2: {
                        short[] sArray = this.ice_boardPos[i];
                        sArray[2] = (short)(sArray[2] + 1);
                        if (sArray[2] < 10) break;
                        this.ice_boardPos[i][2] = 0;
                        this.ice_boardPos[i][3] = 1;
                    }
                }
                ++i;
            }
        }
    }

    public void loadMap(String file) {
        this.mapData = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream("/mapDat/" + file));
        try {
            this.mapSize[0] = Tools.bToi(in.readByte());
            this.mapSize[1] = Tools.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = this.mapSize[0] * this.mapSize[1];
            this.mapData = new byte[size];
            in.read(this.mapData);
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i] = new String(names);
                this.tileProperties[i] = in.readShort();
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        shakeTime = 0;
        deckImage = new byte[]{6, 7, 8, 9, 10};
    }
}

