/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImageColorMap {
    InputStream is;
    boolean bBWMode;
    int[] fromColorMap;
    int[] toColorMap;
    int nColorMapSize;
    int[] crc_table;

    public Image loadImage(String string) {
        byte[] byArray = new byte[]{};
        try {
            this.is = this.getClass().getResourceAsStream(string);
            byArray = new byte[this.is.available()];
            int n = this.is.read(byArray);
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.nColorMapSize > 0 || this.bBWMode) {
            this.changeColors(byArray);
        }
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        byArray = null;
        System.gc();
        return image;
    }

    public void initMapping(boolean bl) {
        this.bBWMode = bl;
        this.releaseMap();
        this.make_crc_table();
    }

    public void registerMap(int[] nArray, int[] nArray2, boolean bl) {
        this.bBWMode = bl;
        this.releaseMap();
        this.make_crc_table();
        this.nColorMapSize = nArray.length;
        if (this.fromColorMap == null) {
            this.fromColorMap = new int[this.nColorMapSize];
            this.toColorMap = new int[this.nColorMapSize];
        }
        for (int i = 0; i < this.nColorMapSize; ++i) {
            this.fromColorMap[i] = nArray[i];
            this.toColorMap[i] = nArray2[i];
        }
    }

    public void releaseMap() {
        this.fromColorMap = null;
        this.toColorMap = null;
        this.nColorMapSize = 0;
        this.crc_table = null;
        this.bBWMode = false;
    }

    void changeColors(byte[] byArray) {
        int n;
        int n2 = n = this.findPos(byArray, "PLTE");
        int n3 = ImageColorMap.readInt(byArray, n - 4) / 3;
        n += 4;
        int n4 = 0;
        while (n4 < n3) {
            boolean bl = false;
            int n5 = ImageColorMap.readInt(byArray, n) >>> 8;
            for (int i = 0; i < this.nColorMapSize; ++i) {
                if (n5 != this.fromColorMap[i]) continue;
                byArray[n] = (byte)(this.toColorMap[i] >>> 16 & 0xFF);
                byArray[n + 1] = (byte)(this.toColorMap[i] >>> 8 & 0xFF);
                byArray[n + 2] = (byte)(this.toColorMap[i] & 0xFF);
                bl = true;
                break;
            }
            if (!bl && this.bBWMode) {
                int n6 = ((n5 >>> 16 & 0xFF) + (n5 >>> 8 & 0xFF) + (n5 & 0xFF)) / 3;
                byArray[n] = (byte)n6;
                byArray[n + 1] = (byte)n6;
                byArray[n + 2] = (byte)n6;
            }
            ++n4;
            n += 3;
        }
        int n7 = this.crc(byArray, n2, n3 * 3 + 4);
        ImageColorMap.writeInt(byArray, n2 + n3 * 3 + 4, n7);
    }

    int findPos(byte[] byArray, String string) {
        return this.findPos(byArray, string.getBytes());
    }

    int findPos(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            while (byArray[i + n] == byArray2[n]) {
                if (++n != byArray2.length) continue;
                return i;
            }
        }
        return -1;
    }

    void make_crc_table() {
        this.crc_table = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) == 1) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            this.crc_table[i] = n;
        }
    }

    int update_crc(int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            n4 = this.crc_table[(n4 ^ byArray[i + n2]) & 0xFF] ^ n4 >>> 8;
        }
        return n4;
    }

    int crc(byte[] byArray, int n, int n2) {
        return ~this.update_crc(-1, byArray, n, n2);
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 = (byArray[n] & 0xFF) << 24;
        n2 += (byArray[n + 1] & 0xFF) << 16;
        n2 += (byArray[n + 2] & 0xFF) << 8;
        return n2 += byArray[n + 3] & 0xFF;
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 0] = (byte)(n2 >> 24 & 0xFF);
    }
}

