/*
 * Decompiled with CFR 0.152.
 */
package generic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.World;

public final class PostEffects {
    public static final int MODULATE = 66;
    public static final int ALPHA_ADD = 65;
    private int m_viewportX;
    private int m_viewportY;
    private int m_viewportW = 1;
    private int m_viewportH = 1;
    private World m_postEffectsWorld;
    private Image2D m_postEffectsImage;
    private CompositingMode m_postEffectsCompositingMode;
    private final byte[] m_fadeColor = new byte[4];

    public PostEffects() {
        Appearance appearance = new Appearance();
        this.m_postEffectsCompositingMode = new CompositingMode();
        this.m_postEffectsCompositingMode.setDepthTestEnable(false);
        this.m_postEffectsCompositingMode.setDepthWriteEnable(false);
        appearance.setCompositingMode(this.m_postEffectsCompositingMode);
        this.m_postEffectsImage = new Image2D(100, 1, 1);
        Sprite3D sprite3D = new Sprite3D(true, this.m_postEffectsImage, appearance);
        sprite3D.setScale(100.0f, 100.0f, 1.0f);
        this.m_postEffectsWorld = new World();
        Camera camera = new Camera();
        this.m_postEffectsWorld.addChild((Node)camera);
        this.m_postEffectsWorld.setActiveCamera(camera);
        Background background = new Background();
        background.setColorClearEnable(false);
        background.setDepthClearEnable(false);
        this.m_postEffectsWorld.setBackground(background);
        this.m_postEffectsWorld.addChild((Node)sprite3D);
        camera.setParallel(90.0f, 1.0f, -1.0f, 1.0f);
    }

    public void setColor(int n) {
        this.m_fadeColor[0] = (byte)((n & 0xFF0000) >> 16);
        this.m_fadeColor[1] = (byte)((n & 0xFF00) >> 8);
        this.m_fadeColor[2] = (byte)(n & 0xFF);
        this.m_fadeColor[3] = (byte)((n & 0xFF000000) >> 24);
        this.m_postEffectsImage.set(0, 0, 1, 1, this.m_fadeColor);
    }

    public void setBlendMode(int n) {
        this.m_postEffectsCompositingMode.setBlending(n);
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.m_viewportX = n;
        this.m_viewportY = n2;
        this.m_viewportW = n3;
        this.m_viewportH = n4;
    }

    public void apply(Graphics graphics) {
        Graphics3D graphics3D = Graphics3D.getInstance();
        graphics3D.bindTarget((Object)graphics);
        graphics3D.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportW, this.m_viewportH);
        graphics3D.render(this.m_postEffectsWorld);
        graphics3D.releaseTarget();
    }
}

