/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import generic.MathExt;

public class NonUniformSpline {
    private static final int MAX_NODES = 500;
    private static final int MAX_TRACKING = 20;
    private static final int IDX_X = 0;
    private static final int IDX_Y = 1;
    private static final int IDX_Z = 2;
    private static final int IDX_SIZE = 3;
    private int[] m_nodePositionF;
    private int[] m_nodeVelocityF;
    private int[] m_nodeScaledVelocityF;
    private int[] m_nodeDistanceF;
    private int[] m_nodeDistanceInvF;
    private int[] m_nodeFullDistanceF;
    private byte[] m_nodeCornerRating;
    private byte[] m_nodeFlags;
    private byte[] m_nodeSection;
    private int m_maxDistanceF;
    private int m_maxDistanceInvF;
    private int m_nodeCount;
    private int[] m_trackingNodes = new int[20];
    private int[] m_trackingDistancesF = new int[20];
    private int[][] m_trackingPositionsF = new int[20][3];
    private int[][] m_trackingTangentsF = new int[20][3];
    private int[][] m_trackingBiNormalsF = new int[20][3];
    private byte[] m_trackingFlags = new byte[20];
    private static final byte TRACKING_NEEDSUPDATE = 1;
    private int m_trackingCount;
    private static int[] s_tempVec3_1 = new int[3];
    private static int[] s_tempVec3_2 = new int[3];
    private static int[] s_tempVec3_3 = new int[3];
    private static int[] s_tempVec3_4 = new int[3];
    private static int[] s_tempVec3_5 = new int[3];
    private static int[] s_tempVec3_6 = new int[3];
    private final int H00;
    private final int H01;
    private final int H10;
    private final int H11;
    private final int H12;
    private final int HD10;
    private final int HD11;
    private final int HD12;
    private final int HD13;
    private final int HD20;
    private final int HD21;
    private final int HD22;
    private final int HD23;

    public NonUniformSpline() {
        this.H00 = 2;
        this.H01 = -2;
        this.H10 = -3;
        this.H11 = 3;
        this.H12 = -2;
        this.HD10 = 6;
        this.HD11 = -6;
        this.HD12 = 3;
        this.HD13 = 3;
        this.HD20 = -6;
        this.HD21 = 6;
        this.HD22 = -4;
        this.HD23 = -2;
        this.clear();
    }

    public void clear() {
        this.m_nodePositionF = new int[1500];
        this.m_nodeVelocityF = new int[1500];
        this.m_nodeScaledVelocityF = new int[1500];
        this.m_nodeDistanceF = new int[500];
        this.m_nodeDistanceInvF = new int[500];
        this.m_nodeFullDistanceF = new int[500];
        this.m_nodeCornerRating = new byte[500];
        this.m_nodeFlags = new byte[500];
        this.m_nodeSection = new byte[500];
        this.m_nodeCount = 0;
    }

    public void addNode(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int[] nArray = this.m_nodePositionF;
        int[] nArray2 = this.m_nodeDistanceF;
        int[] nArray3 = this.m_nodeDistanceInvF;
        if (this.m_nodeCount == 0) {
            this.m_maxDistanceF = 0;
        } else {
            int n9;
            n8 = this.m_nodeCount - 1;
            n7 = n8 * 3;
            int[] nArray4 = s_tempVec3_1;
            nArray4[0] = nArray[n7 + 0] - n;
            nArray4[1] = nArray[n7 + 1] - n2;
            nArray4[2] = nArray[n7 + 2] - n3;
            nArray2[n8] = n9 = MathExt.Fsqrt(MathExt.Fmag3Sqr(nArray4));
            nArray3[n8] = MathExt.Fdiv(65536, n9);
            this.m_maxDistanceF += n9;
        }
        n8 = this.m_nodeCount++;
        n7 = n8 * 3;
        nArray[n7 + 0] = n;
        nArray[n7 + 1] = n2;
        nArray[n7 + 2] = n3;
        this.m_nodeCornerRating[n8] = (byte)n4;
        this.m_nodeFlags[n8] = (byte)n5;
        this.m_nodeSection[n8] = (byte)n6;
        this.m_nodeFullDistanceF[n8] = this.m_maxDistanceF;
    }

    public void buildSpline(boolean bl) {
        int n;
        int n2;
        int n3;
        int[] nArray = this.m_nodePositionF;
        int[] nArray2 = this.m_nodeVelocityF;
        int[] nArray3 = this.m_nodeScaledVelocityF;
        int[] nArray4 = s_tempVec3_1;
        int[] nArray5 = s_tempVec3_2;
        int[] nArray6 = s_tempVec3_3;
        int n4 = 1;
        do {
            n3 = (n4 + 1) % this.m_nodeCount;
            n2 = (n4 - 1 + this.m_nodeCount) % this.m_nodeCount;
            n = n4 * 3;
            int n5 = n3 * 3;
            int n6 = n2 * 3;
            if (bl || n4 != this.m_nodeCount - 1) {
                nArray4[0] = nArray[n5 + 0] - nArray[n + 0];
                nArray4[1] = nArray[n5 + 1] - nArray[n + 1];
                nArray4[2] = nArray[n5 + 2] - nArray[n + 2];
                MathExt.normalise3(nArray4);
            } else {
                nArray4[0] = 0;
                nArray5[1] = 0;
                nArray6[2] = 0;
            }
            if (bl || n4 != 0) {
                nArray5[0] = nArray[n6 + 0] - nArray[n + 0];
                nArray5[1] = nArray[n6 + 1] - nArray[n + 1];
                nArray5[2] = nArray[n6 + 2] - nArray[n + 2];
                MathExt.normalise3(nArray5);
            } else {
                nArray5[0] = 0;
                nArray5[1] = 0;
                nArray5[2] = 0;
            }
            nArray6[0] = nArray4[0] - nArray5[0];
            nArray6[1] = nArray4[1] - nArray5[1];
            nArray6[2] = nArray4[2] - nArray5[2];
            MathExt.normalise3(nArray6);
            System.arraycopy(nArray6, 0, nArray2, n, 3);
        } while ((n4 = (n4 + 1) % this.m_nodeCount) != 1);
        if (bl) {
            n3 = this.m_nodeCount - 1;
            n2 = n3 * 3;
            nArray4[0] = nArray[0] - nArray[n2 + 0];
            nArray4[1] = nArray[1] - nArray[n2 + 1];
            nArray4[2] = nArray[2] - nArray[n2 + 2];
            this.m_nodeDistanceF[n3] = n = MathExt.Fsqrt(MathExt.Fmag3Sqr(nArray4));
            this.m_nodeDistanceInvF[n3] = MathExt.Fdiv(65536, n);
            this.m_maxDistanceF += n;
        }
        this.m_maxDistanceInvF = MathExt.Fdiv(65536, this.m_maxDistanceF);
        for (n3 = 0; n3 < this.m_nodeCount; ++n3) {
            n2 = n3 * 3;
            n = this.m_nodeDistanceF[n3];
            nArray3[n2 + 0] = MathExt.Fmul(nArray2[n2 + 0], n);
            nArray3[n2 + 1] = MathExt.Fmul(nArray2[n2 + 1], n);
            nArray3[n2 + 2] = MathExt.Fmul(nArray2[n2 + 2], n);
        }
    }

    public int getMaxDistance() {
        return this.m_maxDistanceF;
    }

    public int getMaxDistanceInv() {
        return this.m_maxDistanceInvF;
    }

    public int getNodeCount() {
        return this.m_nodeCount;
    }

    public int getDistanceAtNode(int n) {
        return this.m_nodeFullDistanceF[n];
    }

    public int getDistanceAtSection(int n) {
        for (int i = 0; i < this.m_nodeCount; ++i) {
            if (this.m_nodeSection[i] != n) continue;
            return this.m_nodeFullDistanceF[i];
        }
        return 0;
    }

    public int getDistanceOfSection(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_nodeCount; ++i) {
            if (this.m_nodeSection[i] != n) continue;
            n2 += this.m_nodeDistanceF[i];
        }
        return n2;
    }

    public int getNodeCornerRating(int n) {
        return this.m_nodeCornerRating[n];
    }

    public int getNodeFlags(int n) {
        return this.m_nodeFlags[n];
    }

    public int getSectionAtNode(int n) {
        return this.m_nodeSection[n];
    }

    public int getNumSections() {
        return this.m_nodeSection[this.m_nodeCount - 1] + 1;
    }

    public int startTracking() {
        int n;
        AppEngine.ASSERT((n = this.m_trackingCount++) < 20, "run out of tracking ids!");
        this.m_trackingNodes[n] = 0;
        this.m_trackingDistancesF[n] = 0;
        this.m_trackingPositionsF[n][0] = 0;
        this.m_trackingPositionsF[n][1] = 0;
        this.m_trackingPositionsF[n][2] = 0;
        this.m_trackingTangentsF[n][0] = 0;
        this.m_trackingTangentsF[n][1] = 0;
        this.m_trackingTangentsF[n][2] = 0;
        this.m_trackingBiNormalsF[n][0] = 0;
        this.m_trackingBiNormalsF[n][1] = 0;
        this.m_trackingBiNormalsF[n][2] = 0;
        this.m_trackingFlags[n] = 1;
        return n;
    }

    public int getTrackingNode(int n) {
        this.cacheTracking(n);
        return this.m_trackingNodes[n];
    }

    public void setTrackingDistance(int n, int n2) {
        if (this.m_trackingDistancesF[n] != (n2 = this.normaliseDistance(n2))) {
            this.m_trackingDistancesF[n] = n2;
            int n3 = n;
            this.m_trackingFlags[n3] = (byte)(this.m_trackingFlags[n3] | 1);
        }
    }

    public int normaliseDistance(int n) {
        if (n > this.m_maxDistanceF) {
            n -= this.m_maxDistanceF;
        }
        if (n < 0) {
            n += this.m_maxDistanceF;
        }
        return n;
    }

    public int getTrackingDistance(int n) {
        return this.m_trackingDistancesF[n];
    }

    public int[] getTrackingPosition(int n) {
        this.cacheTracking(n);
        return this.m_trackingPositionsF[n];
    }

    public int[] getTrackingTangent(int n) {
        this.cacheTracking(n);
        return this.m_trackingTangentsF[n];
    }

    public int[] getTrackingBiNormal(int n) {
        this.cacheTracking(n);
        return this.m_trackingBiNormalsF[n];
    }

    public int getTrackingRelativeDistance(int n, int n2) {
        int n3 = this.m_trackingDistancesF[n2];
        int n4 = this.m_trackingDistancesF[n];
        int n5 = n3 - n4;
        if (n5 > this.m_maxDistanceF >> 1) {
            n5 -= this.m_maxDistanceF;
        } else if (n5 < -this.m_maxDistanceF >> 1) {
            n5 += this.m_maxDistanceF;
        }
        return n5;
    }

    public void updateTracking(int n, int n2) {
        this.setTrackingDistance(n, this.m_trackingDistancesF[n] + n2);
    }

    private void cacheTracking(int n) {
        if ((this.m_trackingFlags[n] & 1) != 0) {
            this.m_trackingNodes[n] = this.getPositionAndTangent(this.m_trackingDistancesF[n], this.m_trackingPositionsF[n], this.m_trackingTangentsF[n], null);
            int n2 = n;
            this.m_trackingFlags[n2] = (byte)(this.m_trackingFlags[n2] & 0xFFFFFFFE);
        }
    }

    public void coordWorldToSpline(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3 + 1;
        int n8 = this.getNumSections();
        if (n7 >= n8) {
            n7 -= n8;
        }
        int n9 = this.getDistanceAtSection(n3);
        int n10 = this.getDistanceAtSection(n7);
        if (n10 == 0) {
            n10 = this.m_maxDistanceF;
        }
        int[] nArray2 = s_tempVec3_5;
        int[] nArray3 = s_tempVec3_6;
        do {
            this.getPositionAndTangent(n9, nArray2, null, null);
            this.getPositionAndTangent(n10, nArray3, null, null);
            n6 = MathExt.Fmag2Sqr(nArray2[0] - n, nArray2[2] - n2);
            n5 = MathExt.Fmag2Sqr(nArray3[0] - n, nArray3[2] - n2);
            n4 = n10 + n9 >> 1;
            if (n6 < n5) {
                n10 = n4;
                continue;
            }
            n9 = n4;
        } while (Math.abs(n9 - n10) > 65);
        nArray[1] = n6 = n10 + n9 >> 1;
        this.getPositionAndTangent(n6, nArray2, nArray3, null);
        n5 = nArray2[0] - n;
        n4 = nArray2[2] - n2;
        int n11 = MathExt.Fmag2(n5, n4);
        int n12 = MathExt.Fmul(n5, nArray3[2]) - MathExt.Fmul(n4, nArray3[0]);
        if (n12 < 0) {
            n11 = -n11;
        }
        nArray[0] = n11;
    }

    public int getNodeAtDistance(int n) {
        int[] nArray = this.m_nodeDistanceF;
        int n2 = 0;
        int n3 = 0;
        while (n2 + nArray[n3] < n) {
            n2 += nArray[n3];
            if (++n3 != this.m_nodeCount) continue;
            n3 = 0;
        }
        return n3;
    }

    public void getNodePosition(int n, int[] nArray) {
        int n2 = n * 3;
        System.arraycopy(this.m_nodePositionF, n2, nArray, 0, 3);
    }

    public int getPositionAndTangent(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = this.getNodeAtDistance(n);
        int n3 = n2 + 1 >= this.m_nodeCount ? 0 : n2 + 1;
        int n4 = n2 * 3;
        int n5 = n3 * 3;
        int n6 = n - this.m_nodeFullDistanceF[n2];
        n6 = MathExt.Fmul(n6, this.m_nodeDistanceInvF[n2]);
        int[] nArray4 = this.m_nodeVelocityF;
        int[] nArray5 = s_tempVec3_1;
        int[] nArray6 = s_tempVec3_2;
        int[] nArray7 = s_tempVec3_3;
        int[] nArray8 = s_tempVec3_4;
        int n7 = this.m_nodeDistanceF[n2];
        nArray5[0] = MathExt.Fmul(nArray4[n5 + 0], n7);
        nArray5[1] = MathExt.Fmul(nArray4[n5 + 1], n7);
        nArray5[2] = MathExt.Fmul(nArray4[n5 + 2], n7);
        System.arraycopy(this.m_nodePositionF, n5, nArray7, 0, 3);
        System.arraycopy(this.m_nodePositionF, n4, nArray6, 0, 3);
        System.arraycopy(this.m_nodeScaledVelocityF, n4, nArray8, 0, 3);
        if (nArray != null) {
            this.getPositionOnCubic(nArray6, nArray8, nArray7, nArray5, n6, nArray);
        }
        if (nArray2 != null) {
            this.getTangentOnCubic(nArray6, nArray8, nArray7, nArray5, n6, nArray2);
        }
        if (nArray3 != null) {
            // empty if block
        }
        return n2;
    }

    private void getPositionOnCubic(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int[] nArray5) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray3[0];
        int n6 = nArray3[1];
        int n7 = nArray3[2];
        int n8 = nArray2[0];
        int n9 = nArray2[1];
        int n10 = nArray2[2];
        int n11 = nArray4[0];
        int n12 = nArray4[1];
        int n13 = nArray4[2];
        int n14 = 2 * n2 + -2 * n5 + n8 + n11;
        int n15 = 2 * n3 + -2 * n6 + n9 + n12;
        int n16 = 2 * n4 + -2 * n7 + n10 + n13;
        int n17 = -3 * n2 + 3 * n5 + -2 * n8 - n11;
        int n18 = -3 * n3 + 3 * n6 + -2 * n9 - n12;
        int n19 = -3 * n4 + 3 * n7 + -2 * n10 - n13;
        int n20 = n8;
        int n21 = n9;
        int n22 = n10;
        int n23 = n2;
        int n24 = n3;
        int n25 = n4;
        long l = MathExt.Fmul(n, n);
        long l2 = MathExt.Fmul(n, (int)l);
        long l3 = n;
        nArray5[0] = (int)(l2 * (long)n14 + l * (long)n17 + l3 * (long)n20 >> 16) + n23;
        nArray5[1] = (int)(l2 * (long)n15 + l * (long)n18 + l3 * (long)n21 >> 16) + n24;
        nArray5[2] = (int)(l2 * (long)n16 + l * (long)n19 + l3 * (long)n22 >> 16) + n25;
    }

    private void getTangentOnCubic(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int[] nArray5) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray3[0];
        int n6 = nArray3[1];
        int n7 = nArray3[2];
        int n8 = nArray2[0];
        int n9 = nArray2[1];
        int n10 = nArray2[2];
        int n11 = nArray4[0];
        int n12 = nArray4[1];
        int n13 = nArray4[2];
        int n14 = 6 * n2 + -6 * n5 + 3 * n8 + 3 * n11;
        int n15 = 6 * n3 + -6 * n6 + 3 * n9 + 3 * n12;
        int n16 = 6 * n4 + -6 * n7 + 3 * n10 + 3 * n13;
        int n17 = -6 * n2 + 6 * n5 + -4 * n8 + -2 * n11;
        int n18 = -6 * n3 + 6 * n6 + -4 * n9 + -2 * n12;
        int n19 = -6 * n4 + 6 * n7 + -4 * n10 + -2 * n13;
        int n20 = n8;
        int n21 = n9;
        int n22 = n10;
        long l = MathExt.Fmul(n, n);
        long l2 = n;
        nArray5[0] = (int)(l * (long)n14 + l2 * (long)n17 >> 16) + n20;
        nArray5[1] = (int)(l * (long)n15 + l2 * (long)n18 >> 16) + n21;
        nArray5[2] = (int)(l * (long)n16 + l2 * (long)n19 >> 16) + n22;
    }
}

