/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.AnimPlayer3D;
import generic.ResourceManager;
import java.io.DataInputStream;

public final class AnimationManager3D {
    private short[] m_animStartFrame;
    private short[] m_animEndFrame;
    private short[][] m_animWindowStartFrame;
    private short[][] m_animWindowEndFrame;
    private byte[][] m_animWindowFlags;

    public boolean loadAnimFile(ResourceManager resourceManager) {
        try {
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(0));
            int n = dataInputStream.readShort();
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            short[][] sArrayArray = new short[n][];
            short[][] sArrayArray2 = new short[n][];
            byte[][] byArrayArray = new byte[n][];
            for (int i = 0; i < n; ++i) {
                sArray[i] = dataInputStream.readShort();
                sArray2[i] = dataInputStream.readShort();
                int n2 = dataInputStream.readShort();
                if (n2 <= 0) continue;
                sArrayArray[i] = new short[n2];
                sArrayArray2[i] = new short[n2];
                byArrayArray[i] = new byte[n2];
                for (int j = 0; j < n2; ++j) {
                    sArrayArray[i][j] = dataInputStream.readShort();
                    sArrayArray2[i][j] = dataInputStream.readShort();
                    byArrayArray[i][j] = dataInputStream.readByte();
                }
            }
            this.m_animStartFrame = sArray;
            this.m_animEndFrame = sArray2;
            this.m_animWindowFlags = byArrayArray;
            this.m_animWindowStartFrame = sArrayArray;
            this.m_animWindowEndFrame = sArrayArray2;
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public AnimPlayer3D createAnimPlayer3D() {
        return new AnimPlayer3D(this);
    }

    public int getNumAnimations() {
        return this.m_animStartFrame.length;
    }

    public int getAnimStartFrame(int n) {
        return this.m_animStartFrame[n];
    }

    public int getAnimEndFrame(int n) {
        return this.m_animEndFrame[n];
    }

    public int getAnimationDuration(int n) {
        int n2 = this.getAnimStartFrame(n);
        int n3 = this.getAnimEndFrame(n);
        int n4 = n3 - n2;
        if (n4 <= 0 || n2 == 0 || n3 == 0) {
            return 0;
        }
        return n4 * 40;
    }

    public int getAnimNumWindows(int n) {
        return this.m_animWindowStartFrame[n] == null ? 0 : this.m_animWindowStartFrame[n].length;
    }

    public int getAnimWindowStartFrame(int n, int n2) {
        return this.m_animWindowStartFrame[n][n2];
    }

    public int getAnimWindowEndFrame(int n, int n2) {
        return this.m_animWindowEndFrame[n][n2];
    }

    public int getAnimWindowFlags(int n, int n2) {
        return this.m_animWindowFlags[n][n2];
    }
}

