/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.AnimationManager;
import javax.microedition.lcdui.Graphics;

public final class AnimPlayer {
    private int m_animID = -1;
    private int m_currentFrame = 0;
    private int m_currentFrameTime = 0;
    private boolean m_initialised = false;
    private boolean m_animating = false;
    private boolean m_loop = false;
    private boolean m_reverse = false;

    public final void updateAnim(int n) {
        if (!this.m_animating) {
            return;
        }
        this.m_currentFrameTime += n;
        if (this.m_currentFrameTime > AnimationManager.animFrameGetDuration(this.m_animID, this.m_currentFrame)) {
            if (this.m_reverse) {
                this.prevFrame();
            } else {
                this.nextFrame();
            }
        }
    }

    public final void nextFrame() {
        this.m_currentFrameTime -= AnimationManager.animFrameGetDuration(this.m_animID, this.m_currentFrame);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        ++this.m_currentFrame;
        if (this.m_currentFrame >= AnimationManager.animGetNumFrames(this.m_animID)) {
            if (this.m_loop) {
                this.m_currentFrame = 0;
            } else {
                this.m_currentFrame = AnimationManager.animGetNumFrames(this.m_animID) - 1;
                this.m_animating = false;
            }
        }
    }

    public final void prevFrame() {
        this.m_currentFrameTime -= AnimationManager.animFrameGetDuration(this.m_animID, this.m_currentFrame);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        --this.m_currentFrame;
        if (this.m_currentFrame <= 0) {
            if (this.m_loop) {
                this.m_currentFrame = AnimationManager.animGetNumFrames(this.m_animID) - 1;
            } else {
                this.m_currentFrame = 0;
                this.m_animating = false;
            }
        }
    }

    public void startAnim(int n, boolean bl, boolean bl2) {
        if (bl || this.m_animID != n) {
            this.m_animID = n;
            this.m_currentFrame = this.m_reverse ? AnimationManager.animGetNumFrames(this.m_animID) - 1 : 0;
            this.m_currentFrameTime = 0;
        } else if (this.m_currentFrame >= AnimationManager.animGetNumFrames(this.m_animID)) {
            this.m_currentFrame = 0;
        } else if (this.m_currentFrame < 0) {
            this.m_currentFrame = AnimationManager.animGetNumFrames(this.m_animID) - 1;
        }
        this.m_initialised = true;
        this.m_animating = true;
        this.m_loop = bl2;
    }

    public final void drawAnim(Graphics graphics, int n, int n2) {
        if (this.m_animID >= 0) {
            AnimationManager.drawAnimFrame(graphics, this.m_animID, this.m_currentFrame, n, n2);
        }
    }

    public final void setReverse(boolean bl) {
        this.m_reverse = bl;
    }

    public final int getAnimID() {
        return this.m_animID;
    }

    public final int getCurrAnimFrame() {
        return this.m_currentFrame;
    }

    public final int getNumAnimFrames() {
        return this.m_animID == -1 ? 0 : AnimationManager.animGetNumFrames(this.m_animID);
    }

    public final int getAnimDuration() {
        if (this.m_animID == -1) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < AnimationManager.animGetNumFrames(this.m_animID); ++i) {
            n += AnimationManager.animFrameGetDuration(this.m_animID, i);
        }
        return n;
    }

    public final int getNumFirePointsCurrFrame() {
        return AnimationManager.getAnimFrameFirePointCount(this.m_animID, this.m_currentFrame);
    }

    public final boolean getFirePointCurrFrame(int[] nArray, int n) {
        return AnimationManager.getAnimFrameFirePoint(nArray, this.m_animID, this.m_currentFrame, n);
    }

    public final boolean getCollBoxCurrFrame(int[] nArray) {
        return AnimationManager.getAnimFrameCollisionBox(nArray, this.m_animID, this.m_currentFrame);
    }

    public final boolean isAnimating() {
        return this.m_animating;
    }

    public final boolean isInitialised() {
        return this.m_initialised;
    }

    public final void setAnimating(boolean bl) {
        this.m_animating = bl;
    }

    public final void setFrame(int n) {
        this.m_currentFrame = n;
    }
}

