/*
 * Decompiled with CFR 0.152.
 */
package generic;

import constants.Anim3DConstants;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.Merge3DConstants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import constants.TunerShopConstants;
import game.AppEngine;
import game.GlobalConstants;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;

public final class ResourceManager
implements AnimConstants,
ColourConstants,
IStringConstants,
SoundEventConstants,
Anim3DConstants,
Merge3DConstants,
ResourceConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants,
TunerShopConstants {
    public static final byte NULL = -1;
    private static final int MAX_CACHE = 100;
    public static final int CACHE_GROUP_NONE = 0;
    public static final int CACHE_GROUP0 = 1;
    public static final int CACHE_GROUP1 = 2;
    public static final int CACHE_GROUP2 = 3;
    public static final int CACHE_GROUP3 = 4;
    public static final int CACHE_GROUP4 = 5;
    public static final int CACHE_GROUP5 = 6;
    public static final int CACHE_GROUP6 = 7;
    public static final int CACHE_GROUP_MASK = 7;
    public static final int CACHE_KEEP = 16;
    private Object[] m_cachedResources = new Object[100];
    private byte[] m_cachedFlags = new byte[100];
    private short[] m_cachedIDs = new short[100];
    private byte[] m_cachedGroupCounts = new byte[7];
    private byte[] m_cachedGroupMaxCounts = new byte[7];
    private byte[] m_cachedGroupIndexes = new byte[7];
    private static final int M3G_IMAGE2D = 0;
    private static final int M3G_NODE = 1;
    private static final int M3G_LIST = 2;

    public ResourceManager() {
        AppEngine.fillArray(this.m_cachedIDs, -1);
        AppEngine.fillArray(this.m_cachedGroupCounts, 0);
        AppEngine.fillArray(this.m_cachedGroupMaxCounts, 100);
        AppEngine.fillArray(this.m_cachedGroupIndexes, 0);
    }

    public static final int getFileSize(int n) {
        return ResourceConstants.RESOURCE_FILESIZE_LIST[n];
    }

    public static final String getFileName(int n) {
        return ResourceConstants.RESOURCE_FILENAMES_LIST[n];
    }

    public final Image loadImage(int n) {
        try {
            return Image.createImage((String)ResourceManager.getFileName(n));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final InputStream loadBinaryFile(int n) {
        return this.getClass().getResourceAsStream(ResourceManager.getFileName(n));
    }

    public byte[] loadBinaryFileToByteArray(int n) {
        int n2 = ResourceConstants.RESOURCE_FILESIZE_LIST[n];
        byte[] byArray = new byte[n2];
        if (byArray == null) {
            return null;
        }
        try {
            InputStream inputStream = this.loadBinaryFile(n);
            if (inputStream == null) {
                return null;
            }
            inputStream.read(byArray);
            inputStream = null;
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private static final void DEBUG_NODE_LOAD(String string, int n) {
    }

    public Object3D[] loadM3GFile(int n) {
        ResourceManager.DEBUG_NODE_LOAD("loading m3g...", n);
        String string = ResourceManager.getFileName(n);
        Object3D[] object3DArray = null;
        try {
            object3DArray = Loader.load((String)string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object3DArray;
    }

    public Node loadM3GNode(int n) {
        Object3D[] object3DArray = this.loadM3GFile(n);
        AppEngine.ASSERT(object3DArray != null, "failed to load m3g node list");
        AppEngine.ASSERT(object3DArray[0] instanceof Node, "non-Node in root of M3G asset");
        if (object3DArray != null) {
            return (Node)object3DArray[0];
        }
        return null;
    }

    public Image2D loadM3GImage2D(int n) {
        Object3D[] object3DArray = this.loadM3GFile(n);
        AppEngine.ASSERT(object3DArray != null, "failed to load m3g texture");
        AppEngine.ASSERT(object3DArray[0] instanceof Image2D, "non-Image2D in image load");
        return (Image2D)object3DArray[0];
    }

    public static int getCacheFlags(int n) {
        return AppEngine.getCanvas().getCacheFlags(n);
    }

    public void setCacheGroupLimit(int n, int n2) {
        this.m_cachedGroupMaxCounts[n - 1] = (byte)(n2 == -1 ? 100 : n2);
    }

    public Object cachedLoadM3GObject3D(int n, int n2) {
        Object object = null;
        int n3 = ResourceManager.getCacheFlags(n);
        int n4 = AppEngine.indexOf(n, this.m_cachedIDs);
        if (n4 == -1) {
            ResourceManager.DEBUG_NODE_LOAD("loading resource", n);
            int n5 = n3 & 7;
            int n6 = n5 - 1;
            if (n6 != -1) {
                if (this.m_cachedGroupCounts[n6] >= this.m_cachedGroupMaxCounts[n6]) {
                    int n7 = AppEngine.indexOf(n5, this.m_cachedFlags, this.m_cachedGroupIndexes[n6] + 1);
                    if (n7 == -1) {
                        n7 = AppEngine.indexOf(n5, this.m_cachedFlags);
                        AppEngine.ASSERT(n7 != -1, "couldn't find a group asset to unload");
                    }
                    ResourceManager.DEBUG_NODE_LOAD("unloading", this.m_cachedIDs[n7]);
                    this.cacheUnload(n7);
                }
                if ((n4 = AppEngine.indexOf(-1, this.m_cachedIDs, (int)this.m_cachedGroupIndexes[n6])) == -1) {
                    n4 = AppEngine.indexOf(-1, this.m_cachedIDs);
                    AppEngine.ASSERT(n4 != -1, "no room in cache");
                }
                this.m_cachedGroupIndexes[n6] = (byte)n4;
            } else {
                n4 = AppEngine.indexOf(-1, this.m_cachedIDs);
                AppEngine.ASSERT(n4 != -1, "no room in cache");
            }
            object = n2 == 0 ? this.loadM3GImage2D(n) : (n2 == 1 ? this.loadM3GNode(n) : this.loadM3GFile(n));
            AppEngine.ASSERT(object != null, "failed to load M3G asset");
            if (object == null) {
                ResourceManager.DEBUG_NODE_LOAD("failed to load M3G asset", n);
            } else {
                this.m_cachedFlags[n4] = (byte)n3;
                this.m_cachedIDs[n4] = (short)n;
                this.m_cachedResources[n4] = object;
            }
            if (n5 != 0) {
                int n8 = n6;
                this.m_cachedGroupCounts[n8] = (byte)(this.m_cachedGroupCounts[n8] + 1);
            }
        } else {
            ResourceManager.DEBUG_NODE_LOAD("in cache", n);
            object = this.m_cachedResources[n4];
        }
        return object;
    }

    public Image2D cachedLoadM3GImage2D(int n) {
        return (Image2D)this.cachedLoadM3GObject3D(n, 0);
    }

    public Node cachedLoadM3GNode(int n) {
        return (Node)((Object3D)this.cachedLoadM3GObject3D(n, 1)).duplicate();
    }

    public int getMergedM3GOwner(int n) {
        short s = Merge3DConstants.MERGE_FILES[(n & 0xFF00) >> 8];
        return s;
    }

    public Node cachedLoadMergedM3GNode(int n) {
        short s = Merge3DConstants.MERGE_FILES[(n & 0xFF00) >> 8];
        int n2 = n & 0xFFFF00FF;
        Object3D[] object3DArray = (Object3D[])this.cachedLoadM3GObject3D(s, 2);
        return (Node)object3DArray[n2].duplicate();
    }

    public void cacheClear(int n) {
        ResourceManager.DEBUG_NODE_LOAD("clear cache", -1);
        byte[] byArray = this.m_cachedFlags;
        for (int i = 0; i < 100; ++i) {
            byte by = byArray[i];
            if ((by & 0x10) != 0 || n != 0 && (by & 7) != n) continue;
            this.cacheUnload(i);
        }
        AppEngine.doGC();
    }

    private void cacheUnload(int n) {
        int n2 = this.m_cachedFlags[n] & 7;
        if (n2 != 0) {
            int n3 = n2 - 1;
            this.m_cachedGroupCounts[n3] = (byte)(this.m_cachedGroupCounts[n3] - 1);
            AppEngine.ASSERT(this.m_cachedGroupCounts[n2 - 1] >= 0, "too many unloads from a group");
        }
        this.m_cachedFlags[n] = 0;
        this.m_cachedIDs[n] = -1;
        this.m_cachedResources[n] = null;
    }
}

