/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.nfsmw2.MonkeyApp;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKTextUtils;
import constants.Anim3DConstants;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.Merge3DConstants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import constants.TunerShopConstants;
import game.GlobalConstants;
import game.MoreGames;
import game.Scene;
import game.SceneGame;
import game.SceneMTX;
import game.SceneMenu;
import generic.AnimationManager;
import generic.AnimationManager3D;
import generic.MathExt;
import generic.PostEffects;
import generic.ResourceManager;
import generic.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.Transformable;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class AppEngine
extends Canvas
implements AnimConstants,
Anim3DConstants,
Merge3DConstants,
ColourConstants,
IStringConstants,
ResourceConstants,
SoundEventConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants,
TunerShopConstants {
    public MonkeyApp m_midlet;
    private boolean m_gameRunning;
    public Scene m_currentScene;
    private boolean m_paused;
    public static final byte MOREGAMES_UNKNOWN = 0;
    public static final byte MOREGAMES_OFF = 1;
    public static final byte MOREGAMES_WAP = 2;
    public static final byte MOREGAMES_STATIC = 3;
    private byte m_moreGamesMode;
    public String m_moreGamesURI = null;
    public static boolean isFlipped = false;
    public static final int NORMAL = 1;
    public static final int WIDE = 2;
    public static final int DEFAULT = -1;
    static int S_TYPE = -1;
    static int C_TYPE = -1;
    private MoreGames m_moreGames = null;
    private boolean m_moreGamesActive = false;
    private Graphics3D m_graphics3D = Graphics3D.getInstance();
    private ResourceManager m_resourceManager = null;
    private AnimationManager3D m_animationManager3D = null;
    private boolean m_soundPausedIntrrupt = false;
    private boolean m_soundCanResumeIntrrupt = false;
    private SoundManager m_soundManager;
    private Random m_randomInstance;
    private static int[] s_tempInt16 = new int[16];
    private boolean m_runGarbageCollect;
    private static AppEngine s_singletonAppEngine = null;
    public static boolean s_rmsInitialMoney = true;
    public Image qq;
    public Thread m_gameThread = null;
    private static Timer s_gameTimer = null;
    private static final long SLEEP_TIME = 15L;
    private static boolean s_paintScheduled = false;
    public static int tick = 0;
    public boolean recentlyFlipped = false;
    public static Image dummy_screenBuffer = null;
    public static Graphics dummy_screenBufferG = null;
    private static final int KEY_BUFFER_LENGTH = 8;
    private static int s_keysPressedDown;
    private static int s_commandPressedDown;
    private static int[] s_keyBuffer;
    private static int s_keyBufferIndex;
    public static int s_rightCommandID;
    public static int s_leftCommandID;
    public static final int KEYCODE_LSOFTKEY = -6;
    public static final int KEYCODE_RSOFTKEY = -7;
    public static final int KEYCODE_BACKKEY = -8;
    public static final int KEYCODE_BACKKEY_SE = -11;
    public static final int KEYCODE_LSOFTKEY_MOTO = -21;
    public static final int KEYCODE_RSOFTKEY_MOTO = -22;
    public static final int KEYCODE_MSOFTKEY_MOTO = -23;
    public static final int KEYCODE_QKEY_RIM = 113;
    public static final int KEYCODE_PKEY_RIM = 112;
    public static final int KEYCODE_TRACKBALLKEY_RIM = -8;
    public static boolean first;
    private static final byte FONT_SMALL_ORANGE = 0;
    private static final byte FONT_SMALL_WHITE = 1;
    private static final byte FONT_TITLE_WHITE = 2;
    private static final byte FONT_TITLE_ORANGE = 3;
    private static final byte FONT_LARGE_NUMBERS = 4;
    private static final byte FONT_TACHO = 5;
    private static final byte NUM_FONTS = 6;
    private static Object[] s_fonts;
    private static int s_numLanguages;
    private static final int MAX_BLOCK_SIZE = 2600;
    private static byte[] s_blockBuf;
    private static final SDKString s_gsBuffer;
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int MAX_TIME_DECIMALS = 3;
    private static final int MAX_TEMP_STRINGS = 15;
    private static final SDKString[] TEMP_STRING_BUFFER;
    private static final boolean[] ACQUIRED_STRING_BUFFER;
    private static int s_nextFreeString;
    private static final int INT_APPENDER_SIZE = 12;
    private static SDKString s_intAppender;
    public static final int BUFFER_STRING_ID_START = 4096;
    private static final short WRAP_CHAR = 124;
    private static final int MAX_WRAP_OFFSETS = 255;
    private static final int MAX_WRAP_CHUNKS = 4;
    private static final int MAX_WRAP_CHUNK_OFFSETS = 10;
    private static short[] s_wrapOffsets;
    private static SDKString s_wrapString;
    private static short[][] s_wrapChunkOffsets;
    private static SDKString[] s_wrapChunkStrings;
    public static final int FONT_MEDIUM_WHITE = 1;
    public static final int FONT_SOFTKEY_TEXT = 0;
    public static final int FONT_LOADING_TEXT = 0;
    public static final int FONT_MENU_TEXT = 1;
    public static final int FONT_MESSAGE_TEXT = 0;
    public static final int FONT_MENU_TITLE = 0;
    public static final int FONT_HELPABOUT_TEXT = 1;
    public static final int FONT_HELPABOUT_PAGENUM = 2;
    public static final int FONT_LAPTIMES = 1;
    public static final int FONT_DRIFTSCORE = 0;
    public static final int FONT_HUD = 0;
    public static final int FONT_TITLE = 3;
    public static final int FONT_POPUP_TITLE_WHITE = 2;
    public static final int FONT_POPUP_TITLE_ORANGE = 3;
    public static final int FONT_MAIN_MENU_SELECTED = 3;
    public static final int FONT_MENU_ITEM = 1;
    public static final int FONT_MAIN_MENU_ITEM = 3;
    public static final int FONT_TRACK_STATS = 1;
    public static final int FONT_BUSTED_TEXT = 0;
    public static final int FONT_DEBUG = 1;
    public static final int FONT_PERF = 1;
    public static final int FONT_BONUS_NUMBERS = 4;
    public static final int FONT_HUDTACHO = 5;
    private static final int MAX_SCROLLERS = 2;
    private static int[] s_scrollerStringId;
    private static int[] s_scrollerStringWidth;
    private static long[] s_scrollerTime;
    private static int[] s_scrollerOffset;
    private static SDKString[] s_scrollerStringArray;
    public static final int SCROLLER_INITIAL_PAUSE = 1500;
    public static final int SCROLLER_PIXELS_PER_SECOND = 20;
    public static final int SCROLLER_PIXEL_MARGIN = 20;
    private static PostEffects s_postEffects;
    private static boolean s_fading;
    private static int s_fadeColour;
    private static int s_fadeDir;
    private static int s_fadeStep;
    private static boolean s_fadeColorReached;
    private static int s_nextScene;
    private static int s_nextSceneState;
    SceneMTX sceneMTX;
    public static final int VIBRATION_SHORT = 250;
    public static final int VIBRATION_MEDIUM = 400;
    public static final int VIBRATION_LONG = 600;
    public static final byte CHEATS_NUM = 4;
    public static final byte CHEAT_MENU_UNLOCK_EVENTS = 0;
    public static final byte CHEAT_MENU_MONEY = 1;
    public static final byte CHEAT_RACE_WIN = 2;
    public static final byte CHEAT_RACE_LOSE = 3;
    public static final int CHEAT_MONEY_AMOUNT = 1000000;
    private boolean[] m_cheatUsed;
    private static final int[][] CHEAT_CODES;
    public static final int SOFTKEYBAR_HEIGHT = 14;
    public static final byte LOAD_APPENGINE = 1;
    public static final byte LOAD_SCENEMENU = 2;
    public static final byte LOAD_SCENEGAME = 64;
    public static final long UNLOAD_SCENEGAME = -4L;
    public final short IMAGE_COUNT;
    public static final long[] IMAGE_IDS;
    private static final String RMS_SETTINGS = "nfsmw2set";
    private static final String RMS_DATA = "nfsmw2dat";
    private static final int SETTINGS_VERSION = 16;
    private static boolean s_rmsSoundEnabled;
    private static boolean s_rmsVibrationEnabled;
    private static boolean s_rmsCarMarkersEnabled;
    private static boolean s_rmsTutorialCompleted;
    public static final byte QUICKRACE_NUM_LAPS = 3;
    public static final int CAREER_INITIAL_WALLET = 2000;
    public static final byte ACC_ENGINE = 0;
    public static final byte ACC_TRANSMISSION = 1;
    public static final byte ACC_TYRES = 2;
    public static final byte ACC_NITRO = 3;
    public static final byte ACC_KIT = 4;
    public static final byte ACC_ABILLITY = 5;
    public static final byte TUNERSHOP_NUM_ACC = 6;
    public static final byte MAX_CARS = 20;
    public static final int MENU_WIDTH = 130;
    public static final int MENU_LEADING = 14;
    public static final int MENU_BORDER_HEIGHT = 3;
    public static final int MENU_BORDER_WIDTH = 3;
    public static final int MENU_PADDING_WIDTH = 4;
    public static final int MENU_PADDING_HEIGHT = 4;
    public static final int MENU_INNER_WIDTH = 124;
    public static final int MENU_SELECT_WIDTH = 123;
    public static final int MENU_SELECT_BORDER_RIGHT = 10;
    public static final short[] LOADING_STATS_SPRINT;
    public static final short[] LOADING_STATS_CIRCUIT;
    public static final short[] LOADING_STATS_KO;
    public static final short[] LOADING_STATS_CAMERA;
    public static final short[] LOADING_STATS_BOUNTY;
    public static final short[] LOADING_STATS_TAKEOUT;
    public static final short[] LOADING_STATS_BOSS;
    public static final short[] LOADING_STATS_BATTLE;
    private static short[] s_careerTunerMenuStringIDs;
    private static short[] s_careerTunerMenuCompanyNameStringIDs;
    private static short[][] s_careerTunerSubMenuStringIDs;
    private static short[] s_careerTunerAnimIDs;
    private static int[][] s_careerTunerAccessoryPrices;
    private static int[][] s_careerTunerAccessoryBoostsF;
    private static byte s_rmsNumTimesCallToActionShown;
    private static boolean s_rmsGameExists;
    private static byte s_rmsCareerActiveCarIndex;
    public static int s_rmsCareerMoney;
    private static byte s_rmsSectorUnlockedQuickRace;
    private static boolean[][] s_rmsEventsCleared;
    private static byte[] s_rmsCarsOwned;
    private static byte s_careerNumCarsOwned;
    private static byte[] s_carsNotOwned;
    private static byte[][] s_rmsAccessoryLevel;
    private static int[] s_rmsTrackBestLapTimes;
    private static int[] s_rmsTrackBestRaceTimes;
    private static int[] s_rmsTrackBiggestDriftScores;
    private boolean[] m_rmsBossLock;
    private byte m_nextRaceNumLaps;
    public static final int MAX_CASH = 99999999;
    private int m_currentTrack;
    private byte m_numTracks;
    private short[] m_trackSkyDomeMeshResIDs;
    private short[] m_trackSkyDomeTextureResIDs;
    private int[] m_trackGrassColours;
    private short[] m_trackDataResIDs;
    private byte[] m_trackFlags;
    private int[] m_trackDistances;
    private int m_lastTrackLength;
    private int m_currentRaceType;
    private byte m_currentRaceSectorIndex;
    private byte m_currentRaceEventIndex;
    private int m_carNowRacingParamTyres;
    private int m_carNowRacingParamSteeringInc;
    private int m_carNowRacingParamSteeringRecentreInc;
    private int m_carNowRacingParamSteeringMax;
    private int m_carNowRacingParamRollOffset;
    private int m_carNowRacingParamRollSlope;
    private int m_carNowRacingParamRollSteer;
    private int[] m_carNowRacingGearAccels;
    private int[] m_carNowRacingGearMaxSpeeds;
    private int[] m_carNowRacingGearMinSpeeds;
    private int m_carNowRacingNitroExtra;
    public static final int SELECTION_BAR_WIDTH_GAME = 95;
    public static final int SELECTION_BAR_WIDTH = 110;
    public static final int SELECTION_BAR_HEIGHT = 10;
    private static boolean s_drawCornerBrackets;
    private static int s_cursorBracketLeft;
    private static int s_cursorBracketTop;
    private static int s_cursorBracketRight;
    private static int s_cursorBracketBottom;
    private static int s_cursorBracketStartLeft;
    private static int s_cursorBracketStartTop;
    private static int s_cursorBracketStartRight;
    private static int s_cursorBracketStartBottom;
    private static int s_cursorBracketDestLeft;
    private static int s_cursorBracketDestTop;
    private static int s_cursorBracketDestRight;
    private static int s_cursorBracketDestBottom;
    private static int s_cursorBracketDuration;
    private static int s_cursorBracketTime;
    public static final int DUROFACT = 1;
    public static final int CURSOR_DURATION_SHORT = 200;
    public static final int CURSOR_DURATION_MEDIUM = 400;
    public static final int CURSOR_DURATION_LONG = 800;
    public static final int CURSORBRACKET_PAUSE = 200;
    private static final int WINDOW_TITLE_PADDING = 2;
    private static final int WINDOW_PADDING = 2;
    private int m_windowTitle;
    private int m_windowCurPage;
    private int m_windowNumPages;
    private int m_windowNumLinesPerPage;
    private int m_windowPosX;
    private int m_windowPosY;
    private int m_windowWidth;
    private int m_windowHeight;
    private int m_windowTextX;
    private int m_windowTextY;
    private int m_windowTextWidth;
    private int m_windowTextHeight;
    private SDKString m_windowCurPageString = null;
    private SDKString m_windowNumPageString = null;
    private int m_helpAboutTitle;
    private int m_helpAboutCurPage;
    private int m_helpAboutNumPages;
    private int m_helpAboutNumLinesPerPage;
    private SDKString m_helpAboutCurPageString = null;
    private SDKString m_helpAboutNumPageString = null;
    public static final int MENU_SIZE_WIDTH = 142;
    public static final int STAT_SIZE_WIDTH = 153;
    public static final int POP_UP_PADDING = 4;
    private int m_popUpBoxWidthF;
    private int m_popUpBoxHeightF;
    private int m_popUpBarSeperateYF;
    private int m_popUpFont;
    private int m_popUpBoxExpandedWidthF;
    private int m_popUpBoxExpandedHeightF;
    private static final int POPUPBOX_TITLE_PADDING = 2;
    private static final int POPUPBOX_TITLE_BORDER_THICKNESS = 1;
    private static final int POPUPBOX_CONTENT_PADDING = 4;
    private static final int POPUPBOX_BOTTOM_BORDER_THICKNESS = 1;
    private int[][] m_splineBoundingBoxes;
    private int[][][] m_splineNodes;
    private short[] m_carMakes;
    private short[] m_carDescriptions;
    private short[] m_carSectors;
    private short[] m_carMeshChassisResIDs;
    private short[] m_carMeshWheelsResIDs;
    private short[] m_carMeshBodykitResIDs;
    private short[] m_carMeshLODResIDs;
    private short[] m_carTextureResIDs;
    private int[] m_carPrices;
    private int[] m_carUpgradeScales;
    private int[] m_carFlags;
    private int[][] m_carBoundingRects;
    private int[] m_carWidths;
    private int[] m_carLengths;
    private int[] m_carChassisY;
    private int[] m_carWheelFrontX;
    private int[] m_carWheelFrontY;
    private int[] m_carWheelFrontZ;
    private int[] m_carWheelBackX;
    private int[] m_carWheelBackY;
    private int[] m_carWheelBackZ;
    private int[] m_carHeadlightX;
    private int[] m_carHeadlightY;
    private int[] m_carHeadlightZ;
    private int[] m_carBrakelightX;
    private int[] m_carBrakelightY;
    private int[] m_carBrakelightZ;
    private int[] m_carNitroX;
    private int[] m_carNitroY;
    private int[] m_carNitroZ;
    private int[] m_carParamTyres;
    private int[] m_carParamSteeringInc;
    private int[] m_carParamSteeringRecentreInc;
    private int[] m_carParamSteeringMax;
    private int[] m_carParamRollOffset;
    private int[] m_carParamRollSlope;
    private int[] m_carParamRollSteer;
    private byte[] m_carNumGears;
    private int[][] m_carGearAccels;
    private int[][] m_carGearMaxSpeeds;
    private int[][] m_carGearMinSpeeds;
    private short[] m_objectCarTypes;
    private short[] m_objectMeshIds;
    private short[] m_objectFlags;
    private short[] m_objectCosts;
    private int[] m_objectWeights;
    private int m_playerCarIndex;
    private byte m_numEventSectors;
    private short[] m_eventSectorNames;
    private int[] m_eventSectorBossExp;
    private byte[] m_eventSectorEventCounts;
    private byte[][] m_eventTypes;
    private byte[][] m_eventTrackIDs;
    private byte[][] m_eventLaps;
    private int[][] m_eventPurses;
    private short[][] m_eventCostTargets;
    private int[][] m_eventDiffMinF;
    private int[][] m_eventDiffMaxF;
    private int[][] m_eventTrafficScaleF;
    private byte[][] m_eventTrafficMax;
    private byte[][] m_eventTrafficFlags;
    private int[][][] m_eventOpponents;
    private static final int CUTSCENE_TYPE_COUNT = 5;
    public static final int STEP_ELEM_ANIM = 0;
    public static final int STEP_ELEM_STRING = 1;
    public static final int STEP_ELEM_COUNT = 2;
    private short[][][][][] m_cutsceneSteps;
    private static final int ALREADY_CLEARED_SCALE_F = 16384;
    public static final int RACE_TYPE_TUTORIAL = 0;
    public static final int RACE_TYPE_QUICK = 2;
    public static final int RACE_TYPE_CAREER = 3;
    private byte m_postTutorialState;
    private static Appearance[] s_appLibrary;
    private static final byte LAYER_NODEPTH = -1;
    private static final byte LAYER_NORMAL = 0;
    private static final byte LAYER_BLENDED_SUB = 5;
    private static final byte LAYER_BLENDED_ADD = 10;
    private static final byte APP_SKYDOME = 0;
    private static final byte APP_SHADOW = 1;
    private static final byte APP_REPLACE_GARAGE = 2;
    private static final byte APP_ADD_GARAGE = 3;
    private static final byte APP_REPLACE_MASTER = 4;
    private static final byte APP_REPLACE_TRACK = 5;
    private static final byte APP_REPLACE_TRACK_FLIPX = 6;
    private static final byte APP_ADD_MASTER = 7;
    private static final byte APP_ADD_TRACK = 8;
    private static final byte APP_ADD_TRACK_FLIPX = 9;
    private static final byte APP_ALPHA_MASTER = 10;
    private static final byte APP_ALPHA_TRACK = 11;
    private static final byte APP_ALPHA_TRACK_FLIPX = 12;
    private static final byte APP_REPLACE_WHEEL = 13;
    private static final byte APP_REPLACE_CAR = 14;
    private static final byte APP_COUNT = 34;
    public static final byte PROP_SKYDOME = 1;
    public static final byte PROP_TRACK = 2;
    public static final byte PROP_CAR = 4;
    public static final byte PROP_WHEEL = 8;
    public static final byte PROP_FLIPX = 16;
    public static final byte PROP_ALPHA = 32;
    public static final short PROP_GARAGE = 64;
    public static final short PROP_GARAGE_ADD = 128;
    public static final short PROP_ALL = 256;
    private static final short PROPS_COMPOSITINGMODE = 257;
    private static final short PROPS_POLYGONMODE = 19;
    private static final short PROPS_APPERANCE = 275;
    private static final Transform s_tempTransform;
    private static final Transform s_tempTransform2;
    private static final float[] s_tempFloat4;
    private static final float[] s_tempFloat16;
    public static final int CACHE_GROUP_CAR_TEXTURES = 1;
    public static final int CACHE_GROUP_CAR_MODELS = 2;
    public static final int CACHE_GROUP_TRACK_TEXTURES = 3;
    public static final int CACHE_GROUP_TRACK_MODELS = 4;
    public static final int CACHE_GROUP_TEMPORARY = 5;
    private static final int MI_LENGTH = 0;
    private static final int MI_TITLE = 1;
    private static final int MI_TOGGLABLE = 2;
    private static final int MI_TOGGLED = 3;
    private static final int MI_LOCKED = 4;
    private static final int MI_SELECTION = 5;
    private static final int MI_OFFSET = 6;
    private static final int MI_HEIGHT = 7;
    private static final int MI_ITEM0 = 8;
    public static final int MENU_ITEM_TOGGLE_PADDING = 5;
    private int m_lastWindowX = 0;
    private int m_lastWindowY = 0;
    private int m_lastWindowContBottom = 0;
    public int gameCenterID;
    public String gameCenterUrl;
    int STRING_MTX_QQ_WAP = -1;

    public MoreGames getMoreGames() {
        return this.m_moreGames;
    }

    public void setMoreGamesActive(boolean bl) {
        this.m_moreGamesActive = bl;
    }

    public Graphics3D getGraphics3D() {
        return this.m_graphics3D;
    }

    public ResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public AnimationManager3D getAnimationManager3D() {
        return this.m_animationManager3D;
    }

    public SoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public static int[] getTempIntArray() {
        return s_tempInt16;
    }

    public int getHalfWidth() {
        return this.getWidth() >> 1;
    }

    public int getHalfHeight() {
        return this.getHeight() >> 1;
    }

    public static void createAppEngine(MonkeyApp monkeyApp) {
        s_singletonAppEngine = new AppEngine(monkeyApp);
    }

    public static AppEngine getCanvas() {
        return s_singletonAppEngine;
    }

    private AppEngine(MonkeyApp monkeyApp) {
        SDKTextUtils.setMidlet(monkeyApp);
        this.m_midlet = monkeyApp;
        this.m_gameRunning = false;
        this.cornerBracketVisible(false);
        s_keyBuffer = new int[8];
        s_keyBufferIndex = 0;
        this.m_runGarbageCollect = false;
        if (this.getWidth() > this.getHeight()) {
            S_TYPE = 1;
            C_TYPE = 1;
        } else {
            S_TYPE = 2;
            C_TYPE = 2;
        }
        this.m_resourceManager = new ResourceManager();
        this.m_soundManager = new SoundManager(this.m_resourceManager);
        this.m_randomInstance = new Random();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            n = (short)(n + 1);
        }
        this.IMAGE_COUNT = (short)n;
        if (!AnimationManager.loadSubimageFile(this.m_resourceManager)) {
            // empty if block
        }
        if (!AnimationManager.loadAnimFile(this.m_resourceManager)) {
            // empty if block
        }
        AnimationManager.loadColorsFile(this.m_resourceManager);
        this.loadAnimManager3D();
        this.loadTrackData();
        this.loadSplineData();
        this.loadCarData();
        this.loadObjectData();
        this.loadTunershopData();
        this.loadEventSectorData();
        this.loadRMSAppSettings();
        this.resetRMSGameData();
        this.loadRMSGameData();
        this.initWraps();
        this.loadTextSDKStrings();
        AppEngine.initTempStringBuffers();
        this.initCache();
        this.readMoreGamesSetting();
        this.loadImages(1L);
        if (s_rmsInitialMoney) {
            s_rmsCareerMoney = 2000;
            s_rmsInitialMoney = false;
            this.saveRMSGameData();
        }
    }

    final int getMoreGamesMode() {
        return this.m_moreGamesMode;
    }

    void readMoreGamesSetting() {
        if (this.m_moreGamesMode == 0) {
            System.out.println("111111111111");
            this.m_moreGamesMode = 1;
            this.m_moreGamesURI = null;
            try {
                String string = this.m_midlet.getAppProperty("MG_Impl").toLowerCase().trim();
                if (string == null || string.equals("off")) {
                    this.m_moreGamesMode = 1;
                } else if (string.equals("wap") || string.equals("wapstatic")) {
                    this.m_moreGamesMode = (byte)2;
                    this.m_moreGamesURI = this.m_midlet.getAppProperty("MG_WAP_URI");
                    if (this.m_moreGamesURI == null || this.m_moreGamesURI.trim().length() == 0) {
                        if (string.equals("wap")) {
                            this.m_moreGamesMode = 1;
                        } else {
                            System.out.println("coming");
                            this.m_moreGamesMode = (byte)3;
                        }
                    }
                } else if (string.equals("static")) {
                    this.m_moreGamesMode = (byte)3;
                }
            }
            catch (Exception exception) {
                this.m_moreGamesMode = this.m_moreGamesMode == 2 ? (byte)3 : (byte)1;
            }
        }
        System.out.println("m_moreGamesMode" + this.m_moreGamesMode);
    }

    public void initMoreGames() {
        MoreGames moreGames = new MoreGames(this.getWidth(), this.getHeight());
        int[] nArray = new int[]{16291102, 0xFFFFFF, 0xFFFFFF, 16291102, 0xFFFFFF};
        moreGames.setProductData(this.m_resourceManager.loadBinaryFileToByteArray(37));
        this.m_moreGames = moreGames;
        AppEngine.doGC();
    }

    public synchronized void start() {
        int n = -1;
        this.changeScene(0, n);
        AppEngine.initAppearanceLibrary();
        this.m_paused = false;
    }

    public void setMGDimensions() {
        this.m_moreGames.setScreenSize(this.getWidth(), this.getHeight());
    }

    public void end() {
        try {
            this.m_gameRunning = false;
            if (this.m_currentScene != null) {
                this.m_currentScene.end();
            }
            this.saveRMSAppSettings();
            this.saveRMSGameData();
            this.requestGC(true);
            this.m_soundManager.freeAllSounds();
            this.testStringsReleased();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showNotify() {
        if (this.m_paused) {
            this.resumeGame();
            this.startThread();
        }
    }

    public void hideNotify() {
        this.pauseGame();
    }

    public void startSingleThread() {
        try {
            this.m_gameRunning = true;
            this.m_gameThread = new Thread(){

                public void run() {
                    long l = System.currentTimeMillis();
                    while (AppEngine.this.m_gameRunning) {
                        if (!AppEngine.this.m_paused) {
                            if (AppEngine.this.getWidth() > AppEngine.this.getHeight()) {
                                isFlipped = true;
                                C_TYPE = 2;
                            } else {
                                isFlipped = false;
                                C_TYPE = 1;
                            }
                            if (S_TYPE != C_TYPE) {
                                AppEngine.this.changeMode();
                                S_TYPE = C_TYPE;
                            }
                            if (!AppEngine.this.m_paused && !s_paintScheduled) {
                                s_paintScheduled = true;
                                long l2 = System.currentTimeMillis();
                                AppEngine.this.runLoop((int)(l2 - l));
                                l = l2;
                                AppEngine.this.repaint();
                                if (++tick > 100) {
                                    tick = 0;
                                }
                            }
                        }
                        try {
                            Thread.sleep(15L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!AppEngine.this.m_gameRunning) {
                        AppEngine.this.m_midlet.destroyApp(true);
                        return;
                    }
                }
            };
            this.m_gameThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startThread() {
        if (this.m_gameThread == null) {
            this.startSingleThread();
        }
    }

    private void changeMode() {
        block31: {
            this.recentlyFlipped = true;
            try {
                block32: {
                    int n;
                    SceneGame sceneGame;
                    block34: {
                        block33: {
                            this.repaint();
                            if (this.m_moreGames != null) {
                                this.m_moreGames.setScreenSize(this.getWidth(), this.getHeight());
                            }
                            if (this.m_currentScene == null) break block31;
                            if (!(this.m_currentScene instanceof SceneGame)) break block32;
                            sceneGame = (SceneGame)this.m_currentScene;
                            n = sceneGame.m_menuState;
                            sceneGame.initDisplayDimensionsAndOffsets();
                            sceneGame.reSizeCar();
                            if (n == 4) break block33;
                            if (n == 7) break block33;
                            if (n != 11) break block34;
                        }
                        sceneGame.initCutsceneStep();
                    }
                    if (sceneGame.m_eventType == 8) {
                        sceneGame.initCutsceneStep();
                        sceneGame.setTutorialMessage();
                    }
                    if (n == 3 || n == 2 || n == 3 || n == 5 || n == 13 || n == 14 || n == 5 || n == 6 || n == 7) {
                        sceneGame.menuStateTransition(n);
                    } else if (SceneGame.m_state == 4) {
                        sceneGame.stateTransition(SceneGame.m_state);
                    }
                    try {
                        sceneGame.m_hudText = 0;
                        sceneGame.updateHUD(0);
                    }
                    catch (Exception exception) {}
                    break block31;
                }
                if (!(this.m_currentScene instanceof SceneMenu)) break block31;
                SceneMenu sceneMenu = (SceneMenu)this.m_currentScene;
                byte by = sceneMenu.m_state;
                byte by2 = sceneMenu.m_confirmType;
                sceneMenu.initMargins();
                sceneMenu.initializeCarSelect();
                if (by == 99 || by == 6 || by == 14 || by == 19 || by == 21 || by == 17 || by == 20 || by == 8) {
                    sceneMenu.m_state = (byte)-1;
                    sceneMenu.stateTransitionOut(by);
                }
                if (by == 11 || by == 10) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        sceneMenu.m_state = (byte)-1;
                        sceneMenu.stateTransitionOut(by);
                    }
                    sceneMenu.m_state = (byte)-1;
                    sceneMenu.stateTransitionOut(by);
                }
                if (by == 7 && by != 6) {
                    sceneMenu.m_state = (byte)-1;
                    sceneMenu.stateTransitionOut((byte)7);
                }
                if (by2 == 0 && by == 1) {
                    sceneMenu.confirm((byte)0);
                }
                if (by2 == 6 && by == 5) {
                    sceneMenu.confirm((byte)6);
                } else if (by2 == 1 && by == 6) {
                    sceneMenu.confirm((byte)1);
                }
                if (by2 == 2 && by == 8) {
                    sceneMenu.confirm((byte)2);
                }
                if (by2 == 3 && by == 6) {
                    sceneMenu.confirm((byte)3);
                }
                if (by2 == 4 && by == 20) {
                    sceneMenu.confirm((byte)4);
                }
                if (by2 == 5 && by == 8) {
                    sceneMenu.confirm((byte)5);
                }
                if (by2 == 8 && by == 6) {
                    sceneMenu.confirm((byte)8);
                }
                if (by2 == 9 && by == 17) {
                    sceneMenu.confirm((byte)9);
                }
                if (by2 == 7 && (by == 17 || by == 20)) {
                    sceneMenu.confirm((byte)7);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void runLoop(int n) {
        int n2 = this.updateKeyBuffer();
        this.update(n);
        this.clearKeyBit(n2);
        if (this.m_runGarbageCollect) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        }
        if (this.m_soundManager != null) {
            this.m_soundManager.update(n > 0 ? n : 0);
        }
    }

    private int updateKeyBuffer() {
        int n;
        int[] nArray = s_keyBuffer;
        for (n = s_keyBufferIndex - 1; n >= 0; --n) {
            if (nArray[n] >= 0) continue;
            s_keysPressedDown &= ~(-nArray[n]);
            if (-nArray[n] != 131072 && -nArray[n] != 262144 && -nArray[n] != 524288) continue;
            s_commandPressedDown = 0;
        }
        for (n = s_keyBufferIndex - 1; n >= 0; --n) {
            if (nArray[n] <= 0) continue;
            s_keysPressedDown |= nArray[n];
            if (nArray[n] == 524288) {
                s_commandPressedDown |= 4;
                continue;
            }
            if (nArray[n] == 262144) {
                s_commandPressedDown |= s_rightCommandID;
                continue;
            }
            if (nArray[n] != 131072) continue;
            s_commandPressedDown |= s_leftCommandID;
        }
        n = 0;
        for (int i = 1; i <= 18; ++i) {
            for (int j = 0; j < s_keyBufferIndex; ++j) {
                if (nArray[j] < 0) {
                    n |= -nArray[j];
                } else if (n == 1 << i && nArray[j] > 0) {
                    n &= ~nArray[j];
                }
                nArray[j] = 0;
            }
        }
        s_keyBufferIndex = 0;
        return n;
    }

    public boolean endGame(String string) {
        try {
            this.m_midlet.platformRequest(string);
            this.endGame();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void endGame() {
        this.m_soundManager.stopAllSounds();
        this.m_gameRunning = false;
    }

    public void pauseGame() {
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
        if (this.m_soundManager != null) {
            this.m_soundManager.appPause();
            this.m_soundPausedIntrrupt = true;
            this.m_soundCanResumeIntrrupt = false;
        }
        this.m_paused = true;
    }

    public void resumeGame() {
        if (this.m_currentScene != null) {
            this.m_currentScene.resume();
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        s_keyBufferIndex = 0;
        this.m_paused = false;
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    private final void update(int n) {
        if (this.m_soundPausedIntrrupt && this.m_soundCanResumeIntrrupt) {
            if (this.m_soundManager != null) {
                this.m_soundManager.appResume();
            }
            this.m_soundPausedIntrrupt = false;
            this.m_soundCanResumeIntrrupt = false;
        }
        if (n > 200) {
            n = 200;
        }
        if (s_nextScene != -1) {
            this.performChangeScene(s_nextScene, s_nextSceneState);
            s_nextScene = -1;
            s_nextSceneState = -1;
        }
        if (this.m_currentScene != null) {
            if (s_fading) {
                if (s_fadeDir > 0 && (s_fadeColour += s_fadeDir * s_fadeStep * (n >> 3)) >= 0xFFFFFF) {
                    s_fadeColour = 0xFFFFFF;
                    s_fading = false;
                } else if (s_fadeDir < 0 && s_fadeColour <= 0) {
                    s_fadeColour = 0;
                    s_fading = false;
                }
            }
            if (this.m_currentScene != null) {
                this.m_currentScene.processKeys(s_keysPressedDown, s_commandPressedDown);
                this.m_currentScene.update(n);
            }
        }
    }

    public final synchronized void paint(Graphics graphics) {
        try {
            if (this.m_moreGamesActive) {
                this.m_moreGames.paint(graphics);
                s_paintScheduled = false;
                return;
            }
            Graphics graphics2 = graphics;
            SDKTextUtils.setGraphics(graphics2);
            if (this.m_moreGamesActive) {
                this.m_moreGames.paint(graphics2);
                s_paintScheduled = false;
                return;
            }
            if (this.m_currentScene != null && this.m_gameRunning) {
                this.m_currentScene.render(graphics2);
            }
            if (s_fadeColour < 0xFFFFFF) {
                this.renderFade(graphics2);
            }
            if (!this.fadeColourReached() && (s_fadeDir > 0 && s_fadeColour >= 0xFFFFFF || s_fadeDir < 0 && s_fadeColour <= 0)) {
                s_fadeColorReached = true;
            }
            if (s_drawCornerBrackets) {
                this.drawCornerBrackets(graphics2);
            }
            s_paintScheduled = false;
        }
        catch (Exception exception) {
            s_paintScheduled = false;
        }
    }

    public static final void ASSERT(boolean bl, String string) {
    }

    private int translateKeyCode(int n) {
        switch (n) {
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 48: {
                return 1;
            }
            case 35: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case -6: {
                return 131072;
            }
            case -7: {
                return 262144;
            }
            case -8: {
                return 524288;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                return 4096;
            }
            case 1: {
                return 8192;
            }
            case 6: {
                return 16384;
            }
            case 2: {
                return 32768;
            }
            case 5: {
                return 65536;
            }
        }
        return 0;
    }

    public void keyPressed(int n) {
        if (n == -10) {
            return;
        }
        this.m_soundCanResumeIntrrupt = true;
        if (this.m_moreGamesActive) {
            this.m_moreGames.processKey(n);
            return;
        }
        int n2 = this.translateKeyCode(n);
        if (n2 != 0 && s_keyBufferIndex < s_keyBuffer.length) {
            AppEngine.s_keyBuffer[AppEngine.s_keyBufferIndex++] = n2;
            this.processKeysCheats(n);
        }
    }

    public void keyReleased(int n) {
        int n2 = this.translateKeyCode(n);
        if (n2 != 0 && s_keyBufferIndex < s_keyBuffer.length) {
            AppEngine.s_keyBuffer[AppEngine.s_keyBufferIndex++] = -n2;
        }
    }

    public void clearKeyBit(int n) {
        s_keysPressedDown &= ~n;
    }

    public void clearKeysPressedDown() {
        s_keysPressedDown = 0;
    }

    public void clearCommandKeys() {
        s_commandPressedDown = 0;
        this.clearKeyBit(524288);
    }

    public void setSoftKeys(int n, int n2) {
        int n3 = n;
        n = n2;
        n2 = n3;
        if (n2 != s_rightCommandID) {
            s_rightCommandID = n2;
        }
        if (n != s_leftCommandID) {
            s_leftCommandID = n;
        }
    }

    public int getRightCommandID() {
        return s_rightCommandID;
    }

    public int getLeftCommandID() {
        return s_leftCommandID;
    }

    public static int getCommandIconID(int n) {
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 0;
            }
            case 16: {
                return 0;
            }
            case 64: {
                return 3;
            }
            case 128: {
                return 0;
            }
            case 256: {
                return 1;
            }
            case 512: {
                return 0;
            }
            case 1024: {
                return 3;
            }
        }
        return -1;
    }

    private void loadTextSDKStrings() {
        s_blockBuf = new byte[2600];
        byte[] byArray = this.loadBlock("/hdr");
        s_numLanguages = SDKTextUtils.loadTextHeader(byArray);
        byte by = (byte)SDKTextUtils.chooseLanguage(0);
        Object[] objectArray = new Object[6];
        Image[] imageArray = new Image[6];
        s_fonts = objectArray;
        String string = "/" + SDKTextUtils.getFontDifferentiator(by);
        try {
            imageArray[0] = Image.createImage((String)(string + "font_small_orange.png"));
            imageArray[1] = Image.createImage((String)(string + "font_small_white.png"));
            imageArray[2] = Image.createImage((String)(string + "font_title_white.png"));
            imageArray[3] = Image.createImage((String)(string + "font_title_orange.png"));
            imageArray[4] = Image.createImage((String)(string + "font_numbers.png"));
            imageArray[5] = Image.createImage((String)(string + "font_tacho.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray2 = this.loadBlock(string + "font_small.rff");
        objectArray[0] = SDKTextUtils.loadFont(imageArray[0], byArray2);
        objectArray[1] = SDKTextUtils.loadFont(imageArray[1], byArray2);
        byArray2 = this.loadBlock(string + "font_title.rff");
        objectArray[2] = SDKTextUtils.loadFont(imageArray[2], byArray2);
        objectArray[3] = SDKTextUtils.loadFont(imageArray[3], byArray2);
        byArray2 = this.loadBlock(string + "font_numbers.rff");
        objectArray[4] = SDKTextUtils.loadFont(imageArray[4], byArray2);
        byArray2 = this.loadBlock(string + "font_tacho.rff");
        objectArray[5] = SDKTextUtils.loadFont(imageArray[5], byArray2);
        this.loadLanguageChunks(by);
        s_blockBuf = null;
        AppEngine.doGC();
    }

    public int getNumLanguages() {
        return s_numLanguages;
    }

    public void loadLanguageChunks(int n) {
        SDKTextUtils.setCurrentLanguage(n);
        SDKTextUtils.loadStringsChunk(1);
        SDKTextUtils.loadStringsChunk(2);
    }

    private byte[] loadBlock(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                int n = inputStream.read(s_blockBuf);
                int n2 = 0;
                int n3 = 2600;
                while (n > 0) {
                    n = inputStream.read(s_blockBuf, n2 += n, n3 -= n);
                }
                byArray = new byte[n2];
                System.arraycopy(s_blockBuf, 0, byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        SDKString sDKString = AppEngine.getStringBuffer(string);
        SDKTextUtils.setFont(s_fonts[n]);
        this.drawString(graphics, sDKString, n, n2, n3, n4);
        AppEngine.releaseStringBuffer(sDKString);
    }

    public void drawString(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n >= 0) {
            SDKString sDKString = this.getString(n);
            SDKTextUtils.setFont(s_fonts[n2]);
            this.drawString(graphics, sDKString, n2, n3, n4, n5);
        }
    }

    public void drawString(Graphics graphics, SDKString sDKString, int n, int n2, int n3, int n4) {
        if (sDKString != null) {
            SDKTextUtils.setFont(s_fonts[n]);
            if ((n4 & 2) != 0) {
                n3 -= (SDKTextUtils.getBaselinePosition() >> 1) - SDKTextUtils.getLeadingSpacing();
                n4 &= 0xFFFFFFFD;
            }
            SDKTextUtils.drawString(sDKString, n2, n3, n4);
        }
    }

    public int getSpaceWidth(int n) {
        SDKTextUtils.setFont(s_fonts[n]);
        return SDKTextUtils.getSpaceSpacing();
    }

    public int getLineHeight(int n) {
        SDKTextUtils.setFont(s_fonts[n]);
        return SDKTextUtils.getLineSize();
    }

    public int getLineHeightAllCaps(int n) {
        SDKTextUtils.setFont(s_fonts[n]);
        return SDKTextUtils.getBaselinePosition();
    }

    public int getFontLeading(int n) {
        SDKTextUtils.setFont(s_fonts[n]);
        return SDKTextUtils.getLeadingSpacing();
    }

    public SDKString getString(int n) {
        if (n <= 1) {
            return SDKTextUtils.getHeaderString(SDKTextUtils.getCurrentLanguage(), n, s_gsBuffer);
        }
        if (n >= 4096) {
            return TEMP_STRING_BUFFER[n - 4096];
        }
        return SDKTextUtils.getString(n, s_gsBuffer);
    }

    public int getStringLength(int n) {
        SDKString sDKString = this.getString(n);
        return sDKString == null ? 0 : sDKString.length();
    }

    public int getStringWidth(int n, int n2) {
        SDKTextUtils.setFont(s_fonts[n2]);
        SDKString sDKString = this.getString(n);
        return SDKTextUtils.getStringSize(sDKString);
    }

    public boolean stringHasSpaces(int n) {
        SDKString sDKString = this.getString(n);
        for (int i = 0; i <= sDKString.length(); ++i) {
            if (sDKString.charAt(i) != ' ') continue;
            return true;
        }
        return false;
    }

    public int getStringWidth(SDKString sDKString, int n) {
        SDKTextUtils.setFont(s_fonts[n]);
        return SDKTextUtils.getStringSize(sDKString);
    }

    public final void intToSDKString(int n, boolean bl, SDKString sDKString) {
        boolean bl2;
        SDKString sDKString2 = this.getString(260);
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        int n2 = 0;
        if (n == 0) {
            sDKString.setCharAt(0, '0');
            n2 = 1;
        } else {
            int n3 = -1;
            boolean bl4 = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl4) {
                    if (bl2 && !bl4) {
                        sDKString.setCharAt(0, '-');
                    }
                    bl4 = true;
                    sDKString.setCharAt(n2, (char)(48 + n3));
                    ++n2;
                    if (bl && (i == 1000000000 || i == 1000000 || i == 1000)) {
                        sDKString.setLength(n2);
                        sDKString.append(sDKString2);
                        n2 = sDKString.length();
                    }
                }
                n -= n3 * i;
            }
        }
        sDKString.setLength(n2);
    }

    public final void timeToSDKString(int n, int n2, SDKString sDKString) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n3 = n / 1000;
        int n4 = n3 / 60;
        int n5 = n4 / 60;
        n %= 1000;
        n3 %= 60;
        n4 %= 60;
        n2 = n2 <= 3 ? n2 : 3;
        int n6 = 1000;
        for (int i = 0; i < n2; ++i) {
            n6 /= 10;
        }
        n /= n6;
        SDKString sDKString2 = AppEngine.getStringBuffer();
        sDKString.setLength(0);
        if (bl) {
            sDKString.setCharAt(0, '-');
            sDKString.setLength(1);
        }
        if (n5 > 0) {
            this.intToSDKString(n5, false, sDKString2);
            if (sDKString2.length() == 1) {
                sDKString.setCharAt(sDKString.length(), '0');
                sDKString.setLength(sDKString.length() + 1);
            }
            sDKString.append(sDKString2);
            sDKString.setCharAt(sDKString.length(), ':');
            sDKString.setLength(sDKString.length() + 1);
        }
        this.intToSDKString(n4, false, sDKString2);
        if (sDKString2.length() == 1) {
            sDKString.setCharAt(sDKString.length(), '0');
            sDKString.setLength(sDKString.length() + 1);
        }
        sDKString.append(sDKString2);
        sDKString.setCharAt(sDKString.length(), ':');
        sDKString.setLength(sDKString.length() + 1);
        this.intToSDKString(n3, false, sDKString2);
        if (sDKString2.length() == 1) {
            sDKString.setCharAt(sDKString.length(), '0');
            sDKString.setLength(sDKString.length() + 1);
        }
        sDKString.append(sDKString2);
        if (n2 > 0) {
            this.intToSDKString(n, false, sDKString2);
            sDKString.setCharAt(sDKString.length(), '.');
            sDKString.setLength(sDKString.length() + 1);
            int n7 = sDKString2.length();
            if (n7 < n2) {
                int n8 = 0;
                while (n8 + n7 < n2) {
                    sDKString.setCharAt(sDKString.length() + n8, '0');
                    ++n8;
                }
                sDKString.setLength(sDKString.length() + n8);
            }
            sDKString.append(sDKString2);
        }
        AppEngine.releaseStringBuffer(sDKString2);
    }

    public final void moneyToSDKString(int n, SDKString sDKString) {
        boolean bl;
        this.intToSDKString(n, true, sDKString);
        boolean bl2 = bl = n < 0;
        if (bl) {
            int n2 = sDKString.length();
            for (int i = 0; i < n2 - 1; ++i) {
                sDKString.setCharAt(i, sDKString.charAt(i + 1));
            }
            sDKString.setLength(n2 - 1);
        }
        SDKString sDKString2 = this.getString(259).replaceFirst(sDKString);
        sDKString.setLength(0);
        if (bl) {
            sDKString.setCharAt(0, '-');
            sDKString.setLength(1);
        }
        sDKString.append(sDKString2);
    }

    public int getNextFreeStringID() {
        return s_nextFreeString + 4096;
    }

    public static final void releaseStringBuffer(int n) {
        boolean[] blArray = ACQUIRED_STRING_BUFFER;
        if ((n -= 4096) < 15) {
            blArray[n] = false;
            if (s_nextFreeString == -1) {
                s_nextFreeString = n;
            }
        } else {
            AppEngine.ASSERT(false, "Trying to release a string not in the temp list!");
        }
    }

    private static final void DEBUG_STRINGBUFFER(String string) {
    }

    private static final void initTempStringBuffers() {
        SDKString[] sDKStringArray = TEMP_STRING_BUFFER;
        for (int i = 0; i < 15; ++i) {
            sDKStringArray[i] = new SDKString(50, 0);
        }
        s_intAppender = new SDKString(12, 0);
        s_nextFreeString = 0;
    }

    public static final SDKString getStringBuffer() {
        SDKString sDKString;
        SDKString[] sDKStringArray = TEMP_STRING_BUFFER;
        boolean[] blArray = ACQUIRED_STRING_BUFFER;
        int n = s_nextFreeString;
        if (n != -1) {
            sDKString = sDKStringArray[n];
            sDKString.setLength(0);
            blArray[n] = true;
            boolean bl = false;
            for (int i = 0; i < 15; ++i) {
                if (blArray[n = (n + 1) % 15]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = -1;
            }
            s_nextFreeString = n;
        } else {
            AppEngine.ASSERT(false, "All temp strings in use!");
            sDKString = null;
        }
        return sDKString;
    }

    public static final SDKString getStringBuffer(String string) {
        SDKString sDKString = AppEngine.getStringBuffer();
        sDKString.setLength(0);
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            sDKString.setCharAt(i, string.charAt(i));
        }
        sDKString.setLength(n);
        return sDKString;
    }

    public static final void releaseStringBuffer(SDKString sDKString) {
        int n;
        boolean[] blArray = ACQUIRED_STRING_BUFFER;
        SDKString[] sDKStringArray = TEMP_STRING_BUFFER;
        AppEngine.ASSERT(sDKString.isMutable(), "Released string not immutable!");
        for (n = 0; n < 15 && sDKString != sDKStringArray[n]; ++n) {
        }
        if (n < 15) {
            blArray[n] = false;
            if (s_nextFreeString == -1) {
                s_nextFreeString = n;
            }
        } else {
            AppEngine.ASSERT(false, "Trying to release a string not in the temp list!");
        }
    }

    private final void testStringsReleased() {
        boolean[] blArray = ACQUIRED_STRING_BUFFER;
        for (int i = 0; i < 15; ++i) {
            AppEngine.ASSERT(!blArray[i], "Not all temp strings released on exit!");
        }
        AppEngine.DEBUG_STRINGBUFFER("All strings were released! (That's good)");
    }

    public final void copyString(SDKString sDKString, int n) {
        sDKString.setLength(0);
        this.appendString(sDKString, n);
    }

    public final void copyString(SDKString sDKString, SDKString sDKString2) {
        sDKString.setLength(0);
        this.appendString(sDKString, sDKString2);
    }

    public final void copyString(SDKString sDKString, String string) {
        sDKString.setLength(0);
        this.appendString(sDKString, string);
    }

    public final void appendString(SDKString sDKString, int n) {
        sDKString.append(this.getString(n));
    }

    public final void appendString(SDKString sDKString, SDKString sDKString2) {
        sDKString.append(sDKString2);
    }

    public final void appendString(SDKString sDKString, String string) {
        int n = string.length();
        int n2 = sDKString.length();
        for (int i = 0; i != n; ++i) {
            sDKString.setCharAt(n2 + i, string.charAt(i));
        }
        sDKString.setLength(n2 + n);
    }

    public final void appendInt(SDKString sDKString, int n) {
        SDKString sDKString2 = s_intAppender;
        this.intToSDKString(n, false, sDKString2);
        this.appendString(sDKString, sDKString2);
    }

    private void initWraps() {
        s_wrapOffsets = new short[255];
        AppEngine.s_wrapOffsets[0] = 0;
        s_wrapChunkOffsets = new short[4][10];
        for (int i = 0; i < 4; ++i) {
            AppEngine.s_wrapChunkOffsets[i][0] = 0;
        }
        s_wrapChunkStrings = new SDKString[4];
    }

    public int wrapString(int n, int n2, int n3) {
        if (n <= 0) {
            return 0;
        }
        SDKTextUtils.setFont(s_fonts[n2]);
        s_wrapString = this.getString(n).toSDKString();
        if (n == 50) {
            String string = this.m_midlet.getAppProperty("MIDlet-Version");
            s_wrapString = s_wrapString.replaceFirst(string);
        }
        SDKTextUtils.wrapString(s_wrapString, s_wrapOffsets, n3, (short)124);
        return s_wrapOffsets[0];
    }

    public int getNumWrappedLines() {
        return s_wrapOffsets[0];
    }

    public void drawWrappedString(Graphics graphics, int n, int n2, int n3, int n4) {
        SDKTextUtils.setFont(s_fonts[n]);
        SDKTextUtils.drawWrappedString(s_wrapString, s_wrapOffsets, 1, s_wrapOffsets[0], n2, n3, n4);
    }

    public void drawPartWrappedString(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        SDKTextUtils.setFont(s_fonts[n]);
        n6 = Math.min(s_wrapOffsets[0] - n5, n6);
        if ((n4 & 2) != 0) {
            int n7 = SDKTextUtils.getLineSize();
            int n8 = n6 * n7;
            int n9 = n8 >> 1;
            n3 -= n9;
            n4 ^= 2;
            n4 |= 0x10;
        }
        SDKTextUtils.drawWrappedString(s_wrapString, s_wrapOffsets, n5 + 1, n6, n2, n3, n4);
    }

    public int wrapStringChunk(int n, int n2, int n3, int n4) {
        SDKTextUtils.setFont(s_fonts[n3]);
        if (n2 <= 0) {
            return 0;
        }
        AppEngine.s_wrapChunkStrings[n] = this.getString(n2).toSDKString();
        SDKTextUtils.wrapString(s_wrapChunkStrings[n], s_wrapChunkOffsets[n], n4, (short)124);
        return s_wrapChunkOffsets[n][0];
    }

    public int getNumWrappedLinesChunk(int n) {
        return s_wrapChunkOffsets[n][0];
    }

    public void drawWrappedStringChunk(int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        SDKTextUtils.setFont(s_fonts[n2]);
        SDKTextUtils.drawWrappedString(s_wrapChunkStrings[n], s_wrapChunkOffsets[n], 1, s_wrapChunkOffsets[n][0], n3, n4, n5);
    }

    public void resetScrollers() {
        for (int i = 0; i < s_scrollerStringId.length; ++i) {
            AppEngine.s_scrollerStringId[i] = -1;
            AppEngine.s_scrollerStringArray[i] = null;
        }
    }

    private void setupScroller(int n, int n2, int n3) {
        if (n < s_scrollerStringId.length) {
            AppEngine.s_scrollerTime[n] = 0L;
            AppEngine.s_scrollerStringId[n] = n3;
            AppEngine.s_scrollerStringArray[n] = null;
            if (s_scrollerStringId[n] != -1) {
                AppEngine.s_scrollerStringWidth[n] = this.getStringWidth(n3, n2);
                AppEngine.s_scrollerOffset[n] = 0;
            }
        }
    }

    private void setupScroller(int n, int n2, SDKString sDKString) {
        if (n < s_scrollerStringId.length) {
            AppEngine.s_scrollerTime[n] = 0L;
            AppEngine.s_scrollerStringId[n] = -1;
            AppEngine.s_scrollerStringArray[n] = sDKString;
            if (s_scrollerStringId[n] != -1) {
                AppEngine.s_scrollerStringWidth[n] = this.getStringWidth(sDKString, n2);
                AppEngine.s_scrollerOffset[n] = 0;
            }
        }
    }

    public void updateScrollers(long l) {
        for (int i = 0; i < s_scrollerStringId.length; ++i) {
            if (s_scrollerStringId[i] == -1 && s_scrollerStringArray[i] == null) continue;
            int n = i;
            s_scrollerTime[n] = s_scrollerTime[n] + l;
            if (s_scrollerTime[i] <= 1500L) continue;
            long l2 = s_scrollerTime[i] - 1500L;
            AppEngine.s_scrollerOffset[i] = (int)(l2 * 20L >> 10);
            int n2 = s_scrollerStringWidth[i] + 20;
            if (s_scrollerOffset[i] < n2) continue;
            int n3 = i;
            s_scrollerOffset[n3] = s_scrollerOffset[n3] - n2;
            int n4 = i;
            s_scrollerTime[n4] = s_scrollerTime[n4] - (long)((n2 << 10) / 20);
        }
    }

    public void renderScroller(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n >= s_scrollerStringId.length) {
            return;
        }
        if (s_scrollerStringId[n] != n2) {
            this.setupScroller(n, n3, n2);
        }
        if (s_scrollerStringWidth[n] <= n6) {
            this.drawString(graphics, n2, n3, n4, n5, n7);
        } else {
            int n8 = graphics.getClipX();
            int n9 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            int n12 = n4;
            if ((n7 & 1) != 0) {
                n12 = n4 - (n6 >> 1);
            } else if ((n7 & 8) != 0) {
                n12 = n4 - n6;
            }
            graphics.setClip(n12, n9, n6, n11);
            this.drawString(graphics, s_scrollerStringId[n], n3, n4 - s_scrollerOffset[n], n5, n7);
            this.drawString(graphics, s_scrollerStringId[n], n3, n4 - s_scrollerOffset[n] + s_scrollerStringWidth[n] + 20, n5, n7);
            graphics.setClip(n8, n9, n10, n11);
        }
    }

    public void renderScroller(int n, Graphics graphics, SDKString sDKString, int n2, int n3, int n4, int n5, int n6) {
        if (n >= s_scrollerStringArray.length) {
            return;
        }
        if (s_scrollerStringArray[n] != sDKString) {
            this.setupScroller(n, n2, sDKString);
        }
        if (s_scrollerStringWidth[n] <= n5) {
            this.drawString(graphics, sDKString, n2, n3, n4, n6);
        } else {
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipY();
            int n9 = graphics.getClipWidth();
            int n10 = graphics.getClipHeight();
            int n11 = n3;
            if ((n6 & 1) != 0) {
                n11 = n3 - (n5 >> 1);
            } else if ((n6 & 8) != 0) {
                n11 = n3 - n5;
            }
            graphics.setClip(n11, n8, n5, n10);
            this.drawString(graphics, s_scrollerStringId[n], n2, n3 - s_scrollerOffset[n], n4, n6);
            this.drawString(graphics, s_scrollerStringId[n], n2, n3 - s_scrollerOffset[n] + s_scrollerStringWidth[n] + 20, n4, n6);
            graphics.setClip(n7, n8, n9, n10);
        }
    }

    public int getScrollerWidth(int n) {
        return s_scrollerStringWidth[n];
    }

    public void startFadeOut() {
        s_fadeColour = 0xFFFFFF;
        s_fadeDir = -1;
        s_fading = true;
        s_fadeColorReached = false;
    }

    public void startFadeOutDim() {
        s_fadeColour = 0xAAAAAA;
        s_fadeDir = -1;
        s_fading = true;
        s_fadeColorReached = false;
    }

    public void startFadeIn() {
        s_fadeColour = 0;
        s_fadeDir = 1;
        s_fading = true;
        s_fadeColorReached = false;
    }

    public void stopFade() {
        s_fadeColour = 0xFFFFFF;
        s_fadeDir = -1;
        s_fading = false;
    }

    public boolean fadeColourReached() {
        return s_fadeColorReached;
    }

    public boolean isFading() {
        return s_fading && !this.fadeColourReached();
    }

    public boolean isFadingOut() {
        return this.isFading() && s_fadeDir == -1;
    }

    public boolean isFadingIn() {
        return this.isFading() && s_fadeDir == 1;
    }

    public int getFadeDir() {
        return s_fadeDir;
    }

    public void setFadeStep(int n) {
        s_fadeStep = n;
    }

    public void renderFade(Graphics graphics) {
        try {
            s_postEffects.setViewport(0, 0, this.getWidth(), this.getHeight());
            s_postEffects.setBlendMode(66);
            s_postEffects.setColor(s_fadeColour);
            s_postEffects.apply(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderFade(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            s_postEffects.setBlendMode(n);
            s_postEffects.setViewport(n3, n4, n5, n6);
            s_postEffects.setColor(n2);
            s_postEffects.apply(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderBackgroundDim(Graphics graphics) {
        this.renderBackgroundDim(graphics, false);
    }

    public void renderBackgroundDim(Graphics graphics, boolean bl) {
        int n = 0;
        n = !bl ? this.getHeight() - this.getSoftkeyHeight() : this.getHeight();
        s_postEffects.setViewport(0, 0, this.getWidth(), n);
        s_postEffects.setBlendMode(66);
        s_postEffects.setColor(0xAAAAAA);
        s_postEffects.apply(graphics);
    }

    public static final void doGC() {
        Runtime.getRuntime().gc();
        Thread.yield();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void requestGC(boolean bl) {
        if (bl) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        } else {
            this.m_runGarbageCollect = true;
        }
    }

    public Scene getCurrentScene() {
        return this.m_currentScene;
    }

    public SceneGame getSceneGame() {
        return this.m_currentScene instanceof SceneGame ? (SceneGame)this.m_currentScene : null;
    }

    public SceneMenu getSceneMenu() {
        return this.m_currentScene instanceof SceneMenu ? (SceneMenu)this.m_currentScene : null;
    }

    public void changeScene(int n) {
        this.changeScene(n, -1);
    }

    public void changeScene(int n, int n2) {
        s_nextScene = n;
        s_nextSceneState = n2;
    }

    public void initMTX(int n) {
        if (this.sceneMTX == null) {
            this.sceneMTX = new SceneMTX(this);
        }
        this.backupCurrScene();
        this.sceneMTX.init(n);
        this.m_currentScene = this.sceneMTX;
    }

    public void backupCurrScene() {
        this.sceneMTX.setCurrentScene(this.m_currentScene);
    }

    public void restoreScene() {
        this.m_currentScene = this.sceneMTX.getScene();
    }

    private void performChangeScene(int n, int n2) {
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
            this.m_currentScene = null;
            this.requestGC(true);
        }
        this.stopFade();
        switch (n) {
            case 0: {
                this.m_currentScene = new SceneMenu(this);
                this.initMoreGames();
                break;
            }
            case 1: {
                this.m_moreGames = null;
                AppEngine.doGC();
                this.m_currentScene = new SceneGame(this);
                break;
            }
        }
        this.m_currentScene.start(n2);
        this.clearKeysPressedDown();
        this.clearCommandKeys();
        this.repaint();
    }

    public int rand(int n, int n2) {
        int n3 = n2 + 1 - n;
        return n + this.m_randomInstance.nextInt(n3);
    }

    public int randPercent() {
        return this.rand(0, 99);
    }

    public void vibrate(int n) {
        if (s_rmsVibrationEnabled) {
            try {
                Display.getDisplay((MIDlet)this.m_midlet).vibrate(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isVibrationEnabled() {
        return s_rmsVibrationEnabled;
    }

    public void setVibrationEnabled(boolean bl) {
        s_rmsVibrationEnabled = bl;
    }

    public static void debug(String string) {
    }

    public static void timerBegin() {
    }

    public static void timerEnd(String string) {
    }

    public static void timerEnd(String string, int n) {
    }

    private final void DEBUG_CHEATS(String string) {
    }

    public boolean cheatUsed(int n) {
        return this.m_cheatUsed[n];
    }

    public void cheatUnset(int n) {
        this.m_cheatUsed[n] = false;
    }

    private void processKeysCheats(int n) {
        for (int n2 = 0; n2 < CHEAT_CODES.length; n2 = (int)((byte)(n2 + 1))) {
            int[] nArray = CHEAT_CODES[n2];
            int n3 = nArray.length - 1;
            int n4 = nArray[0];
            int n5 = nArray[n4 + 1];
            if (n5 == n) {
                if (++n4 == n3) {
                    boolean bl = false;
                    n4 = 0;
                    nArray[0] = 0;
                    switch (n2) {
                        case 0: 
                        case 1: {
                            if (!(this.m_currentScene instanceof SceneMenu)) break;
                            if (n2 == 0) {
                                this.DEBUG_CHEATS("cheat activated - unlock all sectors and event ");
                                bl = true;
                                break;
                            }
                            if (n2 != 1) break;
                            this.DEBUG_CHEATS("cheat activated - extra career ca$h");
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    this.m_cheatUsed[n2] = true;
                    this.vibrate(250);
                    continue;
                }
                nArray[0] = n4;
                continue;
            }
            nArray[0] = 0;
        }
    }

    public int getSoftkeyHeight() {
        return AnimationManager.getAnimFrameHeight(33, 0);
    }

    public int getSoftKeyWidth() {
        return AnimationManager.getAnimFrameWidth(33, 0);
    }

    public boolean isSoundEnabled() {
        return s_rmsSoundEnabled;
    }

    public void setSoundEnabled(boolean bl) {
        s_rmsSoundEnabled = false;
    }

    public final void playSound(int n) {
        if (SoundEventConstants.SOUND_DATA_SETS[n] >= 0) {
            this.m_soundManager.playSound(n);
        }
    }

    public final void startMusic(int n) {
        if (SoundEventConstants.SOUND_DATA_SETS[n] >= 0) {
            this.m_soundManager.startMusic(n);
        }
    }

    public final void stopMusic() {
        this.m_soundManager.stopMusic();
    }

    private void loadImages(long l) {
        ResourceManager resourceManager = this.getResourceManager();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            if ((IMAGE_IDS[(n << 1) + 1] & l) != 0L) {
                int n2 = (int)IMAGE_IDS[n << 1];
                boolean bl = AnimationManager.loadImage(resourceManager, n2);
                while (!bl) {
                    try {
                        Thread.sleep(16L);
                        System.gc();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = AnimationManager.loadImage(resourceManager, n2);
                }
            }
            ++n;
        }
        AppEngine.doGC();
    }

    public void unloadImages(long l) {
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            if ((IMAGE_IDS[(n << 1) + 1] & l) != 0L) {
                AnimationManager.unloadImage((int)IMAGE_IDS[n << 1]);
            }
            ++n;
        }
        AppEngine.doGC();
    }

    public static final void fillArray(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
    }

    public static final void fillArray(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
    }

    public static final void fillArray(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)n;
        }
    }

    public static final void fillArray(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)n;
        }
    }

    public static final void fillArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static final void fillArray(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            AppEngine.fillArray(nArray[i], n);
        }
    }

    public static final void fillArray(short[][] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            AppEngine.fillArray(sArray[i], n);
        }
    }

    public static final int indexOf(int n, int[] nArray) {
        return AppEngine.indexOf(n, nArray, 0);
    }

    public static final int indexOf(int n, short[] sArray) {
        return AppEngine.indexOf(n, sArray, 0);
    }

    public static final int indexOf(int n, byte[] byArray) {
        return AppEngine.indexOf(n, byArray, 0);
    }

    public static final int indexOf(int n, int[] nArray, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, short[] sArray, int n2) {
        for (int i = n2; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, byte[] byArray, int n2) {
        for (int i = n2; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int countOf(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOf(int n, short[] sArray) {
        int n2 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOf(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int[] copyArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public void setTurorialCompleted(boolean bl) {
        s_rmsTutorialCompleted = bl;
    }

    public boolean getTurorialCompleted() {
        return s_rmsTutorialCompleted;
    }

    private void resetRMSAppSettings() {
        s_rmsSoundEnabled = false;
        s_rmsVibrationEnabled = true;
        s_rmsCarMarkersEnabled = true;
        s_rmsNumTimesCallToActionShown = 0;
    }

    public void resetData() {
        int n;
        s_rmsCareerMoney = 2000;
        System.out.println("deleted");
        SceneMTX.setcareerTimes(0);
        SceneMTX.set911(false);
        for (n = 0; n < 3; ++n) {
            SceneMTX.haveBoost[n] = false;
            SceneMTX.boost[n] = SceneMTX.haveBoost[n];
        }
        SceneMTX.setLose(false);
        for (n = 0; n < SceneMTX.getRaceTimes(); ++n) {
            byte by = -1;
            SceneMTX.setRace(n, by);
        }
        SceneMTX.setEnterUpgradeOver(false);
        SceneMTX.popTnB = false;
        this.saveRMSAppSettings();
    }

    public void resetRMSGameData() {
        int n;
        int n2 = this.getNumCars();
        if (this.m_cheatUsed == null) {
            this.m_cheatUsed = new boolean[4];
        }
        for (n = 0; n < 4; n = (int)((byte)(n + 1))) {
            this.m_cheatUsed[n] = false;
        }
        s_rmsGameExists = false;
        s_rmsCareerActiveCarIndex = 0;
        if (s_rmsTrackBestLapTimes == null) {
            s_rmsTrackBestLapTimes = new int[this.m_numTracks];
        }
        AppEngine.fillArray(s_rmsTrackBestLapTimes, 0);
        if (s_rmsTrackBestRaceTimes == null) {
            s_rmsTrackBestRaceTimes = new int[this.m_numTracks];
        }
        AppEngine.fillArray(s_rmsTrackBestRaceTimes, 0);
        if (s_rmsTrackBiggestDriftScores == null) {
            s_rmsTrackBiggestDriftScores = new int[this.m_numTracks];
        }
        AppEngine.fillArray(s_rmsTrackBiggestDriftScores, 0);
        if (s_rmsEventsCleared == null) {
            s_rmsEventsCleared = new boolean[this.m_numEventSectors][];
        }
        for (n = 0; n < s_rmsEventsCleared.length; n = (int)((byte)(n + 1))) {
            if (s_rmsEventsCleared[n] == null) {
                AppEngine.s_rmsEventsCleared[n] = new boolean[this.getEventCount(n)];
            }
            AppEngine.fillArray(s_rmsEventsCleared[n], false);
        }
        if (s_rmsCarsOwned == null) {
            s_rmsCarsOwned = new byte[n2];
        }
        if (s_carsNotOwned == null) {
            s_carsNotOwned = new byte[n2];
        }
        if (SceneMTX.isBuyCarAlready()) {
            for (n = 0; n < n2; n = (int)((byte)(n + 1))) {
                if (s_rmsCarsOwned[n] != 7) {
                    AppEngine.s_rmsCarsOwned[n] = -1;
                }
                AppEngine.s_carsNotOwned[n] = n;
            }
        } else {
            for (n = 0; n < n2; n = (int)((byte)(n + 1))) {
                AppEngine.s_rmsCarsOwned[n] = -1;
                AppEngine.s_carsNotOwned[n] = n;
            }
        }
        s_careerNumCarsOwned = SceneMTX.isBuyCarAlready() ? (byte)1 : 0;
        if (s_rmsAccessoryLevel == null) {
            s_rmsAccessoryLevel = new byte[n2][6];
        }
        for (n = 0; n < n2; ++n) {
            AppEngine.fillArray(s_rmsAccessoryLevel[n], 0);
        }
        n = this.getNumSectorsInCareer();
        if (this.m_rmsBossLock == null) {
            this.m_rmsBossLock = new boolean[n];
        }
        for (int i = 0; i < n; ++i) {
            this.m_rmsBossLock[i] = true;
        }
    }

    public void loadRMSAppSettings() {
        this.DEBUG_RMS("loadGameData");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 16) {
                int n2;
                s_rmsSoundEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsVibrationEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsCarMarkersEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsNumTimesCallToActionShown = ((DataInputStream)filterInputStream).readByte();
                SceneMTX.setLockStatus(((DataInputStream)filterInputStream).readBoolean());
                SceneMTX.setcareerTimes(((DataInputStream)filterInputStream).readInt());
                SceneMTX.set911(((DataInputStream)filterInputStream).readBoolean());
                for (n2 = 0; n2 < SceneMTX.haveBoost.length; ++n2) {
                    SceneMTX.haveBoost[n2] = ((DataInputStream)filterInputStream).readBoolean();
                    SceneMTX.boost[n2] = ((DataInputStream)filterInputStream).readBoolean();
                }
                SceneMTX.setLose(((DataInputStream)filterInputStream).readBoolean());
                for (n2 = 0; n2 < SceneMTX.getRaceTimes(); ++n2) {
                    SceneMTX.setRace(n2, ((DataInputStream)filterInputStream).readByte());
                }
                SceneMTX.setEnterUpgradeOver(((DataInputStream)filterInputStream).readBoolean());
                SceneMTX.popTnB = ((DataInputStream)filterInputStream).readBoolean();
            } else {
                this.resetRMSAppSettings();
                this.saveRMSAppSettings();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.DEBUG_RMS("game settings recordstore not found");
            this.resetRMSAppSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadRMSGameData() {
        this.DEBUG_RMS("loadGameData");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 16) {
                byte by;
                int n2;
                int n3;
                s_rmsGameExists = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsTutorialCompleted = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsCareerActiveCarIndex = ((DataInputStream)filterInputStream).readByte();
                int n4 = this.getNumCars();
                for (n3 = 0; n3 < n4; n3 = (byte)(n3 + 1)) {
                    AppEngine.s_rmsCarsOwned[n3] = ((DataInputStream)filterInputStream).readByte();
                    if (s_rmsCarsOwned[n3] != -1) {
                        s_careerNumCarsOwned = (byte)(s_careerNumCarsOwned + 1);
                        continue;
                    }
                    this.removeCarFromList(s_carsNotOwned, (byte)n3);
                }
                if (SceneMTX.isBuyCarAlready()) {
                    s_careerNumCarsOwned = (byte)(s_careerNumCarsOwned - 1);
                }
                s_rmsCareerMoney = ((DataInputStream)filterInputStream).readInt();
                s_rmsInitialMoney = ((DataInputStream)filterInputStream).readBoolean();
                n3 = this.getNumSectorsInCareer();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_rmsBossLock[n2] = ((DataInputStream)filterInputStream).readBoolean();
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    for (by = 0; by < 6; ++by) {
                        AppEngine.s_rmsAccessoryLevel[n2][by] = ((DataInputStream)filterInputStream).readByte();
                    }
                }
                for (n2 = 0; n2 < s_rmsEventsCleared.length; n2 = (int)((byte)(n2 + 1))) {
                    for (by = 0; by < this.getEventCount(n2); by = (byte)(by + 1)) {
                        AppEngine.s_rmsEventsCleared[n2][by] = ((DataInputStream)filterInputStream).readBoolean();
                    }
                }
                for (n2 = 0; n2 < this.m_numTracks; ++n2) {
                    AppEngine.s_rmsTrackBestLapTimes[n2] = ((DataInputStream)filterInputStream).readInt();
                    AppEngine.s_rmsTrackBestRaceTimes[n2] = ((DataInputStream)filterInputStream).readInt();
                    AppEngine.s_rmsTrackBiggestDriftScores[n2] = ((DataInputStream)filterInputStream).readInt();
                }
            } else {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.DEBUG_RMS("game settings recordstore not found");
            this.resetRMSGameData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveRMSAppSettings() {
        this.DEBUG_RMS("saveGameData");
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            dataOutputStream.writeInt(16);
            dataOutputStream.writeBoolean(s_rmsSoundEnabled);
            dataOutputStream.writeBoolean(s_rmsVibrationEnabled);
            dataOutputStream.writeBoolean(s_rmsCarMarkersEnabled);
            dataOutputStream.writeByte(s_rmsNumTimesCallToActionShown);
            dataOutputStream.writeBoolean(SceneMTX.isUnlocked());
            dataOutputStream.writeInt(SceneMTX.getCareerTims());
            dataOutputStream.writeBoolean(SceneMTX.isBuyCarAlready());
            for (n = 0; n < SceneMTX.haveBoost.length; ++n) {
                dataOutputStream.writeBoolean(SceneMTX.haveBoost[n]);
                dataOutputStream.writeBoolean(SceneMTX.boost[n]);
            }
            dataOutputStream.writeBoolean(SceneMTX.getLose());
            for (n = 0; n < SceneMTX.getRaceTimes(); ++n) {
                dataOutputStream.writeByte(SceneMTX.getRaceFinished(n));
            }
            dataOutputStream.writeBoolean(SceneMTX.isEnterUpgradeOver());
            dataOutputStream.writeBoolean(SceneMTX.popTnB);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public boolean saveRMSGameData() {
        this.DEBUG_RMS("saveGameData");
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte by;
            int n;
            int n2;
            int n3 = this.getNumCars();
            dataOutputStream.writeInt(16);
            dataOutputStream.writeBoolean(s_rmsGameExists);
            dataOutputStream.writeBoolean(s_rmsTutorialCompleted);
            dataOutputStream.writeByte(s_rmsCareerActiveCarIndex);
            for (n2 = 0; n2 < n3; ++n2) {
                dataOutputStream.writeByte(s_rmsCarsOwned[n2]);
            }
            dataOutputStream.writeInt(s_rmsCareerMoney);
            dataOutputStream.writeBoolean(s_rmsInitialMoney);
            n2 = this.getNumSectorsInCareer();
            for (n = 0; n < n2; ++n) {
                dataOutputStream.writeBoolean(this.m_rmsBossLock[n]);
            }
            for (n = 0; n < n3; ++n) {
                for (by = 0; by < 6; ++by) {
                    dataOutputStream.writeByte(s_rmsAccessoryLevel[n][by]);
                }
            }
            for (n = 0; n < s_rmsEventsCleared.length; n = (int)((byte)(n + 1))) {
                for (by = 0; by < this.getEventCount(n); by = (byte)(by + 1)) {
                    dataOutputStream.writeBoolean(s_rmsEventsCleared[n][by]);
                }
            }
            for (n = 0; n < this.m_numTracks; ++n) {
                dataOutputStream.writeInt(s_rmsTrackBestLapTimes[n]);
                dataOutputStream.writeInt(s_rmsTrackBestRaceTimes[n]);
                dataOutputStream.writeInt(s_rmsTrackBiggestDriftScores[n]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    private void loadTunershopData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(58);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            short[] sArray3 = new short[n];
            short[][] sArrayArray = new short[n][];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            inputStream = this.m_resourceManager.loadBinaryFile(58);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                sArray[i] = TunerShopConstants.TUNERSHOP_LOOKUPS[dataInputStream.readByte()];
                sArray2[i] = TunerShopConstants.TUNERSHOP_LOOKUPS[dataInputStream.readByte()];
                sArray3[i] = TunerShopConstants.TUNERSHOP_LOOKUPS[dataInputStream.readByte()];
                int n2 = dataInputStream.readByte();
                sArrayArray[i] = new short[n2];
                nArrayArray[i] = new int[n2];
                nArrayArray2[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    sArrayArray[i][j] = TunerShopConstants.TUNERSHOP_LOOKUPS[dataInputStream.readByte()];
                    nArrayArray[i][j] = dataInputStream.readInt();
                    nArrayArray2[i][j] = dataInputStream.readInt();
                }
            }
            s_careerTunerMenuStringIDs = sArray;
            s_careerTunerMenuCompanyNameStringIDs = sArray2;
            s_careerTunerAnimIDs = sArray3;
            s_careerTunerSubMenuStringIDs = sArrayArray;
            s_careerTunerAccessoryPrices = nArrayArray;
            s_careerTunerAccessoryBoostsF = nArrayArray2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short[] getCareerTunerMenuStringIDs() {
        return s_careerTunerMenuStringIDs;
    }

    public short[] getCareerTunerMenuCompanyNameStringIDs() {
        return s_careerTunerMenuCompanyNameStringIDs;
    }

    public short[][] getCareerTunerSubMenuStringIDs() {
        return s_careerTunerSubMenuStringIDs;
    }

    public short[] getCareerTunerAnimIDs() {
        return s_careerTunerAnimIDs;
    }

    public int[][] getCareerTunerAccessoryPrices() {
        return s_careerTunerAccessoryPrices;
    }

    public int[][] getCareerTunerAccessoryBoostsF() {
        return s_careerTunerAccessoryBoostsF;
    }

    public int rmsGetNumTimesCallToActionShown() {
        return s_rmsNumTimesCallToActionShown;
    }

    public void rmsSetNumTimesCallToActionShown(int n) {
        s_rmsNumTimesCallToActionShown = (byte)n;
    }

    public byte getCarAccessoryLevel(int n, int n2) {
        return s_rmsAccessoryLevel[n][n2];
    }

    public void purchaseCareerTunerAccessory(int n, int n2, byte by) {
        s_rmsCareerMoney -= MathExt.Fmul(s_careerTunerAccessoryPrices[n2][by - 1], this.m_carUpgradeScales[n]);
        AppEngine.s_rmsAccessoryLevel[n][n2] = by;
    }

    public boolean areCarMarkersEnabled() {
        return s_rmsCarMarkersEnabled;
    }

    public void setCarMarkersEnabled(boolean bl) {
        s_rmsCarMarkersEnabled = bl;
    }

    public boolean rmsGameExists() {
        return s_rmsGameExists;
    }

    public void rmsSetGameExists(boolean bl) {
        s_rmsGameExists = bl;
    }

    public byte rmsGetCareerActiveCarIndex() {
        return s_rmsCareerActiveCarIndex;
    }

    public void rmsSetCareerActiveCarIndex(byte by) {
        s_rmsCareerActiveCarIndex = by;
    }

    public int rmsGetCareerMoney() {
        return s_rmsCareerMoney;
    }

    public void payCareerMoney(int n) {
        s_rmsCareerMoney -= n;
    }

    public int rmsGetTrackBestLapTime(int n) {
        return s_rmsTrackBestLapTimes[n];
    }

    public int rmsGetTrackBestRaceTime(int n) {
        return s_rmsTrackBestRaceTimes[n];
    }

    public int rmsGetTrackBiggestDriftScores(int n) {
        return s_rmsTrackBiggestDriftScores[n];
    }

    public int rmsGetBiggestDriftScore() {
        int[] nArray = s_rmsTrackBiggestDriftScores;
        int n = 0;
        for (int i = s_rmsTrackBiggestDriftScores.length - 1; i >= 0; --i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public void submitBestLapTime(int n) {
        int n2 = s_rmsTrackBestLapTimes[this.m_currentTrack];
        if (n2 <= 0 || n < n2) {
            AppEngine.s_rmsTrackBestLapTimes[this.m_currentTrack] = n;
        }
    }

    public void submitBestRaceTime(int n) {
        int n2 = s_rmsTrackBestRaceTimes[this.m_currentTrack];
        if (n2 == 0 || n < n2) {
            AppEngine.s_rmsTrackBestRaceTimes[this.m_currentTrack] = n;
        }
    }

    public void submitBestRaceSpeed(int n) {
        int n2 = s_rmsTrackBestRaceTimes[this.m_currentTrack];
        if (n2 == 0 || n > n2) {
            AppEngine.s_rmsTrackBestRaceTimes[this.m_currentTrack] = n;
        }
    }

    public void submitBiggestDriftScores(int n) {
        int n2 = s_rmsTrackBiggestDriftScores[this.m_currentTrack];
        if (n2 == 0 || n > n2) {
            AppEngine.s_rmsTrackBiggestDriftScores[this.m_currentTrack] = n;
        }
    }

    public void purchaseCareerCar(byte by) {
        this.purchaseCareerCar(by, true);
    }

    public void purchaseCareerCar(byte by, boolean bl) {
        if (bl) {
            s_rmsCareerMoney -= this.getCarPrice(by);
        }
        this.addCarToList(s_rmsCarsOwned, by);
        this.removeCarFromList(s_carsNotOwned, by);
        s_careerNumCarsOwned = (byte)(s_careerNumCarsOwned + 1);
    }

    public boolean careerCarOwned(byte by) {
        for (int i = 0; i < s_rmsCarsOwned.length; ++i) {
            if (s_rmsCarsOwned[i] != by) continue;
            return true;
        }
        return false;
    }

    public byte getCareerNumCarsOwned() {
        return s_careerNumCarsOwned;
    }

    public byte getNthOwnedCar(byte by) {
        return s_rmsCarsOwned[by];
    }

    public byte getNthNonOwnedCar(byte by) {
        return s_carsNotOwned[by];
    }

    private void addCarToList(byte[] byArray, byte by) {
        for (int i = 0; byArray[i] != -1 && i < byArray.length; ++i) {
        }
        byArray[i] = by;
    }

    private void removeCarFromList(byte[] byArray, byte by) {
        int n;
        int n2 = this.getNumCars();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] != by) continue;
            n3 = n;
        }
        if (n3 >= 0) {
            for (n = n3; n < s_rmsCarsOwned.length - 1; ++n) {
                byArray[n] = byArray[n + 1];
            }
            byArray[n2 - 1] = -1;
        }
    }

    public byte getEventSectorQuickRaceUnlockLevel() {
        return s_rmsSectorUnlockedQuickRace;
    }

    public boolean getEventClearedStatus(int n, int n2) {
        return s_rmsEventsCleared[n][n2];
    }

    public void setEventCleared(int n, int n2) {
        AppEngine.s_rmsEventsCleared[n][n2] = true;
    }

    public void setNextRaceNumLaps(int n) {
        this.m_nextRaceNumLaps = (byte)n;
    }

    public byte getNextRaceNumLaps() {
        return this.m_nextRaceNumLaps;
    }

    public void awardCareerPrizeMoney(int n) {
        if ((s_rmsCareerMoney += n) > 99999999) {
            s_rmsCareerMoney = 99999999;
        }
    }

    public void loadTrackData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(103);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numTracks = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            int n = this.m_numTracks;
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            int[] nArray = new int[n];
            short[] sArray3 = new short[n];
            byte[] byArray = new byte[n];
            int[] nArray2 = new int[n];
            inputStream = this.m_resourceManager.loadBinaryFile(103);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                sArray[i] = TrackConstants.TRACK_LOOKUPS[dataInputStream.readShort()];
                sArray2[i] = TrackConstants.TRACK_LOOKUPS[dataInputStream.readShort()];
                nArray[i] = dataInputStream.readInt();
                sArray3[i] = TrackConstants.TRACK_LOOKUPS[dataInputStream.readShort()];
                byArray[i] = dataInputStream.readByte();
                nArray2[i] = dataInputStream.readInt();
            }
            this.m_trackSkyDomeMeshResIDs = sArray;
            this.m_trackSkyDomeTextureResIDs = sArray2;
            this.m_trackGrassColours = nArray;
            this.m_trackDataResIDs = sArray3;
            this.m_trackFlags = byArray;
            this.m_trackDistances = nArray2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadTrack(int n) {
        this.m_currentTrack = n;
    }

    public int getCurrentTrack() {
        return this.m_currentTrack;
    }

    public int getTrackSkyDomeGeomResID() {
        return this.m_trackSkyDomeMeshResIDs[this.m_currentTrack];
    }

    public int getTrackSkyDomeTextureResID() {
        return this.m_trackSkyDomeTextureResIDs[this.m_currentTrack];
    }

    public int getTrackGrassColour() {
        return this.m_trackGrassColours[this.m_currentTrack];
    }

    public short getTrackDataResID() {
        return this.m_trackDataResIDs[this.m_currentTrack];
    }

    public byte getTrackFlags(int n) {
        return this.m_trackFlags[n];
    }

    public int getTrackDistance(int n) {
        return this.m_trackDistances[n];
    }

    public byte getNumUnlockedTracks() {
        byte by = 0;
        for (byte by2 = 0; by2 < this.m_numTracks; by2 = (byte)(by2 + 1)) {
            byte by3 = this.findTrackEventSectorIndex(by2);
            if (by3 != -1 && this.getEventSectorQuickRaceUnlockLevel() < by3) continue;
            by = (byte)(by + 1);
        }
        return by;
    }

    public byte getNthUnlockedTrack(int n) {
        int n2 = 0;
        for (byte by = 0; by < this.m_numTracks; by = (byte)(by + 1)) {
            byte by2 = this.findTrackEventSectorIndex(by);
            if (by2 != -1 && this.getEventSectorQuickRaceUnlockLevel() < by2) continue;
            int n3 = n2;
            n2 = (byte)(n2 + 1);
            if (n3 != n) continue;
            return by;
        }
        return (byte)n2;
    }

    private byte findTrackEventSectorIndex(byte by) {
        for (int i = 0; i < this.m_numEventSectors; ++i) {
            for (int j = 0; j < this.m_eventTrackIDs[i].length; ++j) {
                if (this.m_eventTrackIDs[i][j] != by) continue;
                return (byte)i;
            }
        }
        return -1;
    }

    public void setLastTrackLength(int n) {
        this.m_lastTrackLength = n;
    }

    public int getLastTrackLength() {
        return this.m_lastTrackLength;
    }

    private void renderMenuVerticalScroll(Graphics graphics, int n, int n2, int n3, short[] sArray, int n4, boolean bl) {
        short s = AppEngine.menuGetSelectedItem(sArray);
        AppEngine.menuSetHeight(sArray, n3 / 11);
        if (AppEngine.menuGetHeight(sArray) > AppEngine.menuGetLength(sArray)) {
            AppEngine.menuSetHeight(sArray, AppEngine.menuGetLength(sArray));
        }
        SDKString sDKString = AppEngine.getStringBuffer();
        int n5 = 0;
        for (int i = 0; i < AppEngine.menuGetHeight(sArray); ++i) {
            int n6;
            int n7;
            int n8 = 1;
            int n9 = i + AppEngine.menuGetOffset(sArray);
            if (bl) {
                n7 = this.getCarFromDescriptionStringID(sArray[8 + n9]);
                this.copyString(sDKString, this.getCarMakeStringID((short)n7));
                this.appendString(sDKString, " ");
                this.appendString(sDKString, sArray[8 + n9]);
            }
            n5 = n2 + i * 11;
            n7 = n5 - 1;
            if (s != sArray[8 + n9]) {
                if (bl) {
                    this.drawString(graphics, sDKString, n8, n, n5, 20);
                } else {
                    this.drawString(graphics, sArray[8 + n9], n8, n, n5, 20);
                }
            } else {
                n6 = n7 + 1;
                this.drawSelectionBar(graphics, n + -2 - 2, n7, n4);
                if (bl) {
                    this.drawString(graphics, sDKString, 3, n + 2, n6 - 1, 20);
                } else {
                    this.drawString(graphics, s, 3, n + 2, n6, 20);
                }
            }
            if (!AppEngine.menuItemHasToggle(sArray, n9)) continue;
            n6 = (this.getWidth() >> 1) + (this.getWidth() >> 2) + (this.getWidth() >> 4);
            int n10 = AppEngine.menuItemIsToggled(sArray, n9) ? 85 : 86;
            this.drawString(graphics, n10, 3, n6, n5, 24);
        }
        AppEngine.releaseStringBuffer(sDKString);
    }

    public void renderMenuVertical(Graphics graphics, int n, int n2, short[] sArray, boolean bl) {
        short s = AppEngine.menuGetSelectedItem(sArray);
        short s2 = AppEngine.menuGetSelection(sArray);
        int n3 = AppEngine.menuGetWidth(3, sArray) + 2;
        int n4 = n2;
        for (int i = 0; i < AppEngine.menuGetLength(sArray); ++i) {
            int n5;
            int n6 = 1;
            n4 = n2 + i * 11;
            int n7 = n4 - 1;
            int n8 = 0;
            if (AppEngine.menuItemHasLock(sArray, i)) {
                n8 = 8;
            }
            if (i != s2 || !bl) {
                if (sArray[8 + i] == 272) {
                    Image image = null;
                    for (n5 = 0; n5 < 28; ++n5) {
                        if (AnimConstants.IMAGE_RES_IDS[n5] != 45) continue;
                        image = AnimationManager.getImage(n5);
                        break;
                    }
                    graphics.drawImage(image, n + n8, n4, 20);
                } else {
                    this.drawString(graphics, sArray[8 + i], n6, n + n8, n4, 20);
                }
            } else {
                int n9 = n7 + 1;
                this.drawSelectionBar(graphics, n - 6 + 2, n7, n3 + 6 - 2);
                this.drawString(graphics, s, 3, n8 + n + 2, n9 - 1, 20);
            }
            if (AppEngine.menuItemHasLock(sArray, i)) {
                AnimationManager.drawAnimFrame(graphics, 92, 0, n, n4 - 1);
            }
            if (!AppEngine.menuItemHasToggle(sArray, i)) continue;
            n5 = n + AppEngine.menuGetWidth(3, sArray);
            int n10 = AppEngine.menuItemIsToggled(sArray, i) ? 85 : 86;
            this.drawString(graphics, n10, 3, n5, n4 - 1, 24);
        }
    }

    public void renderMenuScrollCars(Graphics graphics, int n, int n2, int n3, short[] sArray, int n4) {
        this.renderMenuVerticalScroll(graphics, n, n2, n3, sArray, n4, true);
    }

    public void drawSelectionBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3;
        AnimationManager.setColor(graphics, 100);
        graphics.fillRect(n, n2, 3, n4);
        AnimationManager.setColor(graphics, 108);
        graphics.fillRect(n + 3, n2, n5, n4);
    }

    public void drawSelectionBar(Graphics graphics, int n, int n2, int n3) {
        this.drawSelectionBar(graphics, n, n2, n3, 10);
    }

    public void initCornerBracket(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        s_cursorBracketStartLeft = n;
        s_cursorBracketStartTop = n2;
        s_cursorBracketStartRight = n3;
        s_cursorBracketStartBottom = n4;
        s_cursorBracketDestLeft = n5;
        s_cursorBracketDestTop = n6;
        s_cursorBracketDestRight = n7;
        s_cursorBracketDestBottom = n8;
        s_cursorBracketDuration = n9;
        s_cursorBracketTime = 0;
    }

    public boolean cornerBracketFinished() {
        return s_cursorBracketTime >= s_cursorBracketDuration;
    }

    public boolean cornerBracketFinishedPause() {
        return s_cursorBracketTime >= s_cursorBracketDuration + 200;
    }

    public int getCornerBracketX() {
        return s_cursorBracketLeft;
    }

    public int getCornerBracketY() {
        return s_cursorBracketTop;
    }

    public int getCornerBracketWidth() {
        return s_cursorBracketRight - s_cursorBracketLeft;
    }

    public int getCornerBracketHeight() {
        return s_cursorBracketBottom - s_cursorBracketTop;
    }

    public void initCornerBracket(int n, int n2, int n3, int n4, int n5) {
        this.initCornerBracket(s_cursorBracketLeft, s_cursorBracketTop, s_cursorBracketRight, s_cursorBracketBottom, n, n2, n3, n4, n5);
    }

    public void moveCornerBracketToDest() {
        s_cursorBracketStartLeft = s_cursorBracketDestLeft;
        s_cursorBracketStartTop = s_cursorBracketDestTop;
        s_cursorBracketStartRight = s_cursorBracketDestRight;
        s_cursorBracketStartBottom = s_cursorBracketDestBottom;
    }

    public void centerCornerBracket(int n) {
        int n2 = s_cursorBracketLeft + s_cursorBracketRight >> 1;
        int n3 = s_cursorBracketTop + s_cursorBracketBottom >> 1;
        this.initCornerBracket(s_cursorBracketLeft, s_cursorBracketTop, s_cursorBracketRight, s_cursorBracketBottom, n2, n3, n2, n3, n);
    }

    public void updateCornerBrackets(int n) {
        int n2 = MathExt.smoothstepF(0, s_cursorBracketDuration, s_cursorBracketTime += n);
        s_cursorBracketLeft = s_cursorBracketStartLeft + MathExt.Fmul(n2, s_cursorBracketDestLeft - s_cursorBracketStartLeft);
        s_cursorBracketTop = s_cursorBracketStartTop + MathExt.Fmul(n2, s_cursorBracketDestTop - s_cursorBracketStartTop);
        s_cursorBracketRight = s_cursorBracketStartRight + MathExt.Fmul(n2, s_cursorBracketDestRight - s_cursorBracketStartRight);
        s_cursorBracketBottom = s_cursorBracketStartBottom + MathExt.Fmul(n2, s_cursorBracketDestBottom - s_cursorBracketStartBottom);
        if (s_cursorBracketTime > s_cursorBracketDuration + 200) {
            s_cursorBracketTime = s_cursorBracketDuration + 200;
        }
    }

    public void drawCornerBrackets(Graphics graphics) {
        this.drawCornerBrackets(graphics, s_cursorBracketLeft, s_cursorBracketTop, s_cursorBracketRight, s_cursorBracketBottom);
    }

    public void cornerBracketVisible(boolean bl) {
        s_drawCornerBrackets = bl;
    }

    public void drawCornerBrackets(Graphics graphics, int n, int n2, int n3, int n4) {
        AnimationManager.setColor(graphics, 81);
        graphics.fillRect(n - 1, n2 - 1, 5, 1);
        graphics.fillRect(n - 1, n2, 1, 4);
        graphics.fillRect(n3 - 4, n2 - 1, 5, 1);
        graphics.fillRect(n3, n2, 1, 4);
        graphics.fillRect(n - 1, n4, 5, 1);
        graphics.fillRect(n - 1, n4 - 4, 1, 4);
        graphics.fillRect(n3 - 4, n4, 5, 1);
        graphics.fillRect(n3, n4 - 4, 1, 4);
    }

    public int getTitleHeight() {
        return this.getLineHeight(3) + 4;
    }

    public void initWindow(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_windowTitle = n;
        this.m_windowPosX = n3;
        this.m_windowPosY = n4;
        this.m_windowWidth = n5;
        this.m_windowHeight = n6;
        this.m_windowTextX = n3 + 2;
        this.m_windowTextY = this.m_windowPosY + this.getTitleHeight() + 2;
        this.m_windowTextWidth = n5 - 4;
        this.m_windowTextHeight = n6 - this.getTitleHeight() - 4;
        this.wrapString(n2, 1, this.m_windowTextWidth);
        this.m_windowNumLinesPerPage = this.m_windowTextHeight / this.getLineHeight(1) - 1;
        this.m_windowCurPage = 0;
        this.m_windowNumPages = (this.getNumWrappedLines() + this.m_windowNumLinesPerPage - 1) / this.m_windowNumLinesPerPage;
        if (this.m_windowCurPageString == null || this.m_windowNumPageString == null) {
            this.m_windowCurPageString = new SDKString(2, 0);
            this.m_windowNumPageString = new SDKString(2, 0);
        }
        this.intToSDKString(this.m_windowCurPage + 1, false, this.m_windowCurPageString);
        this.intToSDKString(this.m_windowNumPages, false, this.m_windowNumPageString);
    }

    public int getNumWindowLinesPerPage() {
        return this.m_windowNumLinesPerPage;
    }

    public void processKeysWindow(int n, int n2) {
        if ((n & 0x8010) != 0 && this.m_windowCurPage > 0) {
            this.clearKeyBit(32784);
            --this.m_windowCurPage;
            this.intToSDKString(this.m_windowCurPage + 1, false, this.m_windowCurPageString);
        } else if ((n & 0x10040) != 0 && this.m_windowCurPage < this.m_windowNumPages - 1) {
            this.clearKeyBit(65600);
            ++this.m_windowCurPage;
            this.intToSDKString(this.m_windowCurPage + 1, false, this.m_windowCurPageString);
        }
    }

    public int getWindowTextWrapWidth() {
        return this.m_windowWidth;
    }

    public void renderStripedWindow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = true;
        int n8 = n2;
        for (int i = 0; i < n5; ++i) {
            AnimationManager.setColor(graphics, bl ? n6 : n7);
            graphics.fillRect(n, n8, n3, n4);
            bl = !bl;
            n8 += n4;
        }
    }

    public void renderTitledWindow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 + (n4 >> 1);
        AnimationManager.setColor(graphics, 98);
        graphics.fillRect(n2, n3, n4, n5);
        AnimationManager.setColor(graphics, 96);
        graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        if (n != -1) {
            graphics.fillRect(n2, n3 + this.getTitleHeight() - 1, n4 - 1, 1);
            this.drawString(graphics, n, 3, n6, n3 + 2, 17);
        }
    }

    public void renderWindow(Graphics graphics) {
        int n = this.getLineHeight(2) - this.getFontLeading(2);
        int n2 = AnimationManager.getAnimFrameHeight(95, 0);
        int n3 = Math.max(n, n2);
        int n4 = AnimationManager.getAnimFrameWidth(95, 0);
        int n5 = this.m_windowTextX + this.m_windowTextWidth - 2 - n4;
        int n6 = n5 - 3 - 10;
        int n7 = n6 - 12 - 3 - 2;
        int n8 = n7 - n4 - 3;
        int n9 = this.m_windowTextY + this.m_windowTextHeight - n3;
        int n10 = n9 + 1;
        this.renderTitledWindow(graphics, this.m_windowTitle, this.m_windowPosX, this.m_windowPosY, this.m_windowWidth, this.m_windowHeight);
        this.drawPartWrappedString(graphics, 1, this.m_windowTextX, this.m_windowTextY, 20, this.m_windowCurPage * this.m_windowNumLinesPerPage, this.m_windowNumLinesPerPage);
        this.drawString(graphics, 102, 2, n8, n9, 24);
        if (this.m_windowCurPage != 0) {
            AnimationManager.drawAnimFrame(graphics, 95, 0, n7, n10);
        }
        SDKString sDKString = AppEngine.getStringBuffer();
        this.appendString(sDKString, this.m_windowCurPageString);
        this.appendString(sDKString, 103);
        this.appendString(sDKString, this.m_windowNumPageString);
        this.drawString(graphics, sDKString, 2, n6, n9, 17);
        AppEngine.releaseStringBuffer(sDKString);
        if (this.m_windowCurPage != this.m_windowNumPages - 1) {
            AnimationManager.drawAnimFrame(graphics, 96, 0, n5, n10);
        }
    }

    public int getNumHelpAboutLinesPerPage() {
        return this.m_helpAboutNumLinesPerPage;
    }

    public void initHelpAboutScreen(int n, int n2) {
        this.initHelpAboutScreen(n, n2, false, 0);
    }

    public void initHelpAboutScreen(int n, int n2, boolean bl, int n3) {
        this.m_helpAboutTitle = n;
        this.wrapString(n2, 1, this.getHelpAboutTextWrapWidth());
        int n4 = this.getLineHeight(2) - this.getFontLeading(2);
        int n5 = AnimationManager.getAnimFrameHeight(95, 0);
        int n6 = Math.max(n4, n5);
        int n7 = this.getLineHeight(1);
        int n8 = this.getHeight() - this.getSoftkeyHeight() - this.getTitledWindowHeight() - n6 - n7;
        if (bl) {
            n8 = n6 + n7 + this.getTitledWindowHeight() + this.getNumWrappedLines() * n7;
        }
        int n9 = n8 / n7;
        if (n8 % n7 != 0) {
            --n9;
        }
        this.m_helpAboutCurPage = n3;
        this.m_helpAboutNumPages = (this.getNumWrappedLines() + n9 - 1) / n9;
        this.m_helpAboutNumLinesPerPage = n9;
        if (this.m_helpAboutCurPageString == null || this.m_helpAboutNumPageString == null) {
            this.m_helpAboutCurPageString = new SDKString(2, 0);
            this.m_helpAboutNumPageString = new SDKString(2, 0);
        }
        this.intToSDKString(this.m_helpAboutCurPage + 1, false, this.m_helpAboutCurPageString);
        this.intToSDKString(this.m_helpAboutNumPages, false, this.m_helpAboutNumPageString);
        int n10 = this.getWidth() - 10;
        int n11 = n10 + 2 + 1;
        this.initPopUpBox(true, n11, this.m_helpAboutNumLinesPerPage + 1, 1);
    }

    public int processKeysHelpAbout(int n, int n2) {
        if ((n & 0x8010) != 0 && this.m_helpAboutCurPage > 0) {
            this.clearKeyBit(32784);
            --this.m_helpAboutCurPage;
        } else if ((n & 0x10040) != 0 && this.m_helpAboutCurPage < this.m_helpAboutNumPages - 1) {
            this.clearKeyBit(65600);
            ++this.m_helpAboutCurPage;
        }
        this.intToSDKString(this.m_helpAboutCurPage + 1, false, this.m_helpAboutCurPageString);
        return this.m_helpAboutCurPage;
    }

    public int getHelpAboutTextWrapWidth() {
        return this.getWidth() - 20;
    }

    public void initPopUpBox(boolean bl, int n, int n2, int n3) {
        int n4 = this.getLineHeightAllCaps(n3);
        int n5 = this.getLineHeight(n3);
        int n6 = n5 - n4;
        int n7 = this.getHeight();
        while (n7 >= this.getHeight() - this.getSoftkeyHeight()) {
            if (bl) {
                int n8 = this.getLineHeightAllCaps(3) + 4 + 1;
                n7 = n8 + 4 + (n2 * n5 - n6) + 4 + 1;
            } else {
                n7 = 4 + (n2 * n5 - n6) + 4 + 1;
            }
            if (n7 < this.getHeight() - this.getSoftkeyHeight()) continue;
            --n2;
        }
        this.m_popUpBoxExpandedWidthF = n << 16;
        this.m_popUpBoxExpandedHeightF = n7 << 16;
        this.m_popUpFont = n3;
        this.m_popUpBoxWidthF = this.m_popUpBoxExpandedWidthF;
        this.m_popUpBoxHeightF = this.m_popUpBoxExpandedHeightF;
        this.m_popUpBarSeperateYF = this.getLineHeight(this.m_popUpFont) << 16;
    }

    public int getPopUpBoxExpandedHeight() {
        return this.m_popUpBoxExpandedHeightF >> 16;
    }

    public int getPopUpBoxExpandedWidth() {
        return this.m_popUpBoxExpandedWidthF >> 16;
    }

    public int getPopUpTextFont() {
        return this.m_popUpFont;
    }

    public int getPopUpBoxWidth() {
        return this.m_popUpBoxWidthF >> 16;
    }

    public void renderOpenPopUpBox(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.m_popUpBoxWidthF >> 16;
        int n6 = this.m_popUpBoxHeightF >> 16;
        int n7 = n5 >> 1;
        int n8 = n6 >> 1;
        int n9 = n2 - n7;
        int n10 = n3 - n8;
        int n11 = n9 - 1 - 1;
        int n12 = n10 - 1 - 1;
        int n13 = n9 + n5 + 1 + 1;
        int n14 = n10 + n6 + 1 + 1;
        AnimationManager.setColor(graphics, 81);
        graphics.fillRect(n11, n12, 6, 1);
        graphics.fillRect(n11, n12, 1, 6);
        graphics.fillRect(n13 - 6, n12, 6, 1);
        graphics.fillRect(n13 - 1, n12, 1, 6);
        graphics.fillRect(n11, n14 - 1, 6, 1);
        graphics.fillRect(n11, n14 - 6, 1, 6);
        graphics.fillRect(n13 - 6, n14 - 1, 6, 1);
        graphics.fillRect(n13 - 1, n14 - 6, 1, 6);
        AnimationManager.setColor(graphics, 115);
        graphics.fillRect(n9, n10, n5, n6);
        int n15 = n2 - n7;
        int n16 = n3 - n8;
        int n17 = n5;
        int n18 = 0;
        if (n != -1) {
            n18 = this.getLineHeightAllCaps(n4) + 4;
        }
        int n19 = n15 + (n17 >> 1);
        int n20 = n16 + n18 - 2;
        int n21 = this.getLineHeight(this.m_popUpFont);
        int n22 = n16;
        int n23 = n16 + n18;
        if (n != -1) {
            AnimationManager.setColor(graphics, 114);
            graphics.fillRect(n15, n16, n17, n18);
            this.renderScroller(1, graphics, n, n4, n19, n20, n5 - 6, 65);
        }
        AnimationManager.setColor(graphics, 113);
        graphics.fillRect(n15, n22, n17, 1);
        graphics.fillRect(n15, n23, n17, 1);
        int n24 = graphics.getClipX();
        int n25 = graphics.getClipY();
        int n26 = graphics.getClipWidth();
        int n27 = graphics.getClipHeight();
        graphics.setClip(n15, n16 + n18, n5, n6 - n18);
        AnimationManager.setColor(graphics, 117);
        for (int i = n16 + n18 + 1 + 4 + this.getLineHeightAllCaps(this.m_popUpFont) - n21 + 1; i < n16 + n6; i += this.m_popUpBarSeperateYF >> 16) {
            graphics.fillRect(n15, i, n17, n21);
            i += n21;
        }
        graphics.setClip(n24, n25, n26, n27);
        AnimationManager.setColor(graphics, 0);
        int n28 = n10 + n6 - 1;
        graphics.fillRect(n15, n28, n17, 1);
        this.m_lastWindowX = n15;
        this.m_lastWindowY = n16 + n18 + 1 + 4;
        this.m_lastWindowContBottom = n10 + n6 - 4;
    }

    public void renderHelpAboutBox(Graphics graphics) {
        int n = this.getHalfWidth();
        int n2 = this.getHalfHeight() - 6;
        this.renderOpenPopUpBox(graphics, this.m_helpAboutTitle, n, n2, 3);
        int n3 = this.m_helpAboutNumLinesPerPage;
        int n4 = this.m_lastWindowX + 5;
        int n5 = this.m_lastWindowY;
        int n6 = this.m_lastWindowContBottom;
        int n7 = this.m_popUpBoxWidthF >> 16;
        int n8 = AnimationManager.getAnimFrameWidth(95, 0);
        int n9 = n6;
        int n10 = n9 - 8;
        int n11 = n4 + n7 - n8 - 10;
        int n12 = n11 - 10 - 2;
        int n13 = n12 - n8 - 10 - 2;
        int n14 = n13 - n8 - 2;
        this.drawPartWrappedString(graphics, 1, n4, n5, 20, this.m_helpAboutCurPage * n3, n3);
        this.drawString(graphics, 102, 2, n14, n9, 72);
        if (this.m_helpAboutCurPage != 0) {
            AnimationManager.drawAnimFrame(graphics, 95, 0, n13, n10);
        }
        SDKString sDKString = AppEngine.getStringBuffer();
        this.appendString(sDKString, this.m_helpAboutCurPageString);
        this.appendString(sDKString, 103);
        this.appendString(sDKString, this.m_helpAboutNumPageString);
        this.drawString(graphics, sDKString, 2, n12, n9, 65);
        AppEngine.releaseStringBuffer(sDKString);
        if (this.m_helpAboutCurPage != this.m_helpAboutNumPages - 1) {
            AnimationManager.drawAnimFrame(graphics, 96, 0, n11, n10);
        }
    }

    public void renderInfoWindow(Graphics graphics, int n, int n2, int n3, int n4) {
        this.renderOpenPopUpBox(graphics, n, n2 += this.m_popUpBoxWidthF >> 16 >> 1, n3 += this.m_popUpBoxHeightF >> 16 >> 1, n4);
    }

    public void loadAnimManager3D() {
        if (this.m_animationManager3D == null) {
            this.m_animationManager3D = new AnimationManager3D();
            this.m_animationManager3D.loadAnimFile(this.m_resourceManager);
        }
    }

    public void renderSoftKeys(Graphics graphics) {
        int n;
        int n2 = AppEngine.getCommandIconID(this.getLeftCommandID());
        int n3 = AppEngine.getCommandIconID(this.getRightCommandID());
        int n4 = this.getWidth();
        int n5 = n = this.getHeight();
        int n6 = this.getSoftKeyWidth();
        int n7 = n6 >> 1;
        int n8 = n4 - n7;
        int n9 = 20;
        if (isFlipped) {
            if (n2 != -1) {
                AnimationManager.drawAnimFrame(graphics, 33, 0, 300, this.getHeight());
                AnimationManager.drawAnimFrame(graphics, 32, n2, 310, this.getHeight());
            }
            if (n3 != -1) {
                AnimationManager.drawAnimFrame(graphics, 34, 0, n4, this.getHeight() - 230);
                AnimationManager.drawAnimFrame(graphics, 32, n3, 308, this.getHeight() - 230);
            }
        } else {
            if (n2 != -1) {
                AnimationManager.drawAnimFrame(graphics, 33, 0, 0, n);
                AnimationManager.drawAnimFrame(graphics, 32, n2, n7 - 2, n5);
            }
            if (this.getLeftCommandID() == 2048) {
                int n10 = n - this.getSoftkeyHeight() - 2 - AnimationManager.getAnimFrameHeight(6, 0);
                AnimationManager.drawAnimFrame(graphics, 6, 0, 0, n10);
            }
            if (n3 != -1) {
                AnimationManager.drawAnimFrame(graphics, 34, 0, n4, n);
                AnimationManager.drawAnimFrame(graphics, 32, n3, n8 + 2, n5);
            }
        }
    }

    public void renderLoading(Graphics graphics, int n) {
        this.renderLoading(graphics, n, 0);
    }

    public void renderLoading(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = n4 >> 1;
        int n7 = (n5 >> 1) + n2;
        int[] nArray = s_tempInt16;
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(0, 0, n4, n5);
        AnimationManager.drawAnimFrame(graphics, 81, 0, n6, n7);
        AnimationManager.getAnimFrameFirePoint(nArray, 81, 0, 0);
        this.drawString(graphics, 58, 0, n6 + nArray[0], n7 + nArray[1], 17);
        AnimationManager.getAnimFrameFirePoint(nArray, 81, 0, 1);
        int n8 = n6 + nArray[0];
        int n9 = n7 + nArray[1];
        AnimationManager.getAnimFrameFirePoint(nArray, 81, 0, 2);
        int n10 = n6 + nArray[0] - n8;
        int n11 = n7 + nArray[1] - n9;
        int n12 = n10 * n / 100;
        int n13 = graphics.getClipX();
        int n14 = graphics.getClipY();
        int n15 = graphics.getClipWidth();
        int n16 = graphics.getClipHeight();
        graphics.setClip(n8, n9, n10 + 1, n11 + 1);
        int n17 = n3 = AnimationManager.getAnimFrameWidth(82, 0) - 2;
        AnimationManager.drawAnimFrame(graphics, 82, 0, n8 - n17, n9);
        for (int i = 0; i < n12; i += n3) {
            AnimationManager.drawAnimFrame(graphics, 82, 0, n8 + i, n9);
        }
        graphics.setClip(n13, n14, n15, n16);
    }

    public void loadSplineData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(44);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            int[][] nArray = new int[by][4];
            int[][][] nArrayArray = new int[by][][];
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                nArray[by2][0] = dataInputStream.readInt();
                nArray[by2][1] = dataInputStream.readInt();
                nArray[by2][2] = dataInputStream.readInt();
                nArray[by2][3] = dataInputStream.readInt();
                byte by3 = dataInputStream.readByte();
                nArrayArray[by2] = new int[by3][4];
                for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                    nArrayArray[by2][by4][0] = dataInputStream.readInt();
                    nArrayArray[by2][by4][1] = dataInputStream.readInt();
                    nArrayArray[by2][by4][2] = dataInputStream.readInt();
                    nArrayArray[by2][by4][3] = dataInputStream.readByte();
                }
            }
            this.m_splineBoundingBoxes = nArray;
            this.m_splineNodes = nArrayArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int[] getSplineBoundingBox(int n) {
        return this.m_splineBoundingBoxes[n];
    }

    public int[][] getSplineNodes(int n) {
        return this.m_splineNodes[n];
    }

    public void loadCarData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(8);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readUnsignedByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            short[] sArray3 = new short[n];
            short[] sArray4 = new short[n];
            short[] sArray5 = new short[n];
            short[] sArray6 = new short[n];
            short[] sArray7 = new short[n];
            short[] sArray8 = new short[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[][] nArrayArray = new int[n][];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            int[] nArray6 = new int[n];
            int[] nArray7 = new int[n];
            int[] nArray8 = new int[n];
            int[] nArray9 = new int[n];
            int[] nArray10 = new int[n];
            int[] nArray11 = new int[n];
            int[] nArray12 = new int[n];
            int[] nArray13 = new int[n];
            int[] nArray14 = new int[n];
            int[] nArray15 = new int[n];
            int[] nArray16 = new int[n];
            int[] nArray17 = new int[n];
            int[] nArray18 = new int[n];
            int[] nArray19 = new int[n];
            int[] nArray20 = new int[n];
            int[] nArray21 = new int[n];
            int[] nArray22 = new int[n];
            int[] nArray23 = new int[n];
            int[] nArray24 = new int[n];
            int[] nArray25 = new int[n];
            int[] nArray26 = new int[n];
            int[] nArray27 = new int[n];
            int[] nArray28 = new int[n];
            byte[] byArray = new byte[n];
            int[][] nArrayArray2 = new int[n][];
            int[][] nArrayArray3 = new int[n][];
            int[][] nArrayArray4 = new int[n][];
            inputStream = this.m_resourceManager.loadBinaryFile(8);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readUnsignedByte();
            for (int i = 0; i < n; ++i) {
                int n2;
                sArray[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray2[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray3[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray4[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray5[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray6[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray7[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                sArray8[i] = CarConstants.CAR_LOOKUPS[dataInputStream.readUnsignedByte()];
                nArray[i] = dataInputStream.readInt();
                nArray2[i] = dataInputStream.readInt();
                nArray3[i] = dataInputStream.readInt();
                int[] nArray29 = new int[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    nArray29[n2] = dataInputStream.readInt();
                }
                nArrayArray[i] = nArray29;
                nArray4[i] = nArray29[3] - nArray29[1];
                nArray5[i] = nArray29[2] - nArray29[0];
                nArray6[i] = dataInputStream.readInt();
                nArray7[i] = dataInputStream.readInt();
                nArray8[i] = dataInputStream.readInt();
                nArray9[i] = dataInputStream.readInt();
                nArray10[i] = dataInputStream.readInt();
                nArray11[i] = dataInputStream.readInt();
                nArray12[i] = dataInputStream.readInt();
                nArray13[i] = dataInputStream.readInt();
                nArray14[i] = dataInputStream.readInt();
                nArray15[i] = dataInputStream.readInt();
                nArray16[i] = dataInputStream.readInt();
                nArray17[i] = dataInputStream.readInt();
                nArray18[i] = dataInputStream.readInt();
                nArray19[i] = dataInputStream.readInt();
                nArray20[i] = dataInputStream.readInt();
                nArray21[i] = dataInputStream.readInt();
                nArray22[i] = dataInputStream.readInt();
                nArray23[i] = dataInputStream.readInt();
                nArray24[i] = dataInputStream.readInt();
                nArray25[i] = dataInputStream.readInt();
                nArray26[i] = dataInputStream.readInt();
                nArray27[i] = dataInputStream.readInt();
                nArray28[i] = dataInputStream.readInt();
                n2 = dataInputStream.readByte();
                byArray[i] = (byte)n2;
                nArrayArray2[i] = new int[n2];
                nArrayArray3[i] = new int[n2];
                nArrayArray4[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArrayArray2[i][j] = dataInputStream.readInt();
                    nArrayArray4[i][j] = dataInputStream.readInt();
                    nArrayArray3[i][j] = j == 0 ? 0 : MathExt.Fmul(nArrayArray4[i][j - 1], 54591);
                }
            }
            this.m_carMakes = sArray;
            this.m_carDescriptions = sArray2;
            this.m_carSectors = sArray3;
            this.m_carMeshChassisResIDs = sArray4;
            this.m_carMeshWheelsResIDs = sArray5;
            this.m_carMeshBodykitResIDs = sArray6;
            this.m_carMeshLODResIDs = sArray7;
            this.m_carTextureResIDs = sArray8;
            this.m_carPrices = nArray;
            this.m_carUpgradeScales = nArray2;
            this.m_carFlags = nArray3;
            this.m_carBoundingRects = nArrayArray;
            this.m_carLengths = nArray4;
            this.m_carWidths = nArray5;
            this.m_carChassisY = nArray6;
            this.m_carWheelFrontX = nArray7;
            this.m_carWheelFrontY = nArray8;
            this.m_carWheelFrontZ = nArray9;
            this.m_carWheelBackX = nArray10;
            this.m_carWheelBackY = nArray11;
            this.m_carWheelBackZ = nArray12;
            this.m_carHeadlightX = nArray13;
            this.m_carHeadlightY = nArray14;
            this.m_carHeadlightZ = nArray15;
            this.m_carBrakelightX = nArray16;
            this.m_carBrakelightY = nArray17;
            this.m_carBrakelightZ = nArray18;
            this.m_carNitroX = nArray19;
            this.m_carNitroY = nArray20;
            this.m_carNitroZ = nArray21;
            this.m_carParamTyres = nArray22;
            this.m_carParamSteeringInc = nArray23;
            this.m_carParamSteeringRecentreInc = nArray24;
            this.m_carParamSteeringMax = nArray25;
            this.m_carParamRollOffset = nArray26;
            this.m_carParamRollSlope = nArray27;
            this.m_carParamRollSteer = nArray28;
            this.m_carNumGears = byArray;
            this.m_carGearAccels = nArrayArray2;
            this.m_carGearMinSpeeds = nArrayArray3;
            this.m_carGearMaxSpeeds = nArrayArray4;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumCars() {
        return this.m_carDescriptions.length;
    }

    public short getCarDescriptionStringID(int n) {
        return this.m_carDescriptions[n];
    }

    public short getCarSector(int n) {
        return this.m_carSectors[n];
    }

    public int getQuickraceFromSector(int n) {
        int n2;
        int n3;
        switch (n) {
            case 0: 
            case 2: {
                n3 = 1;
                n2 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                n2 = 4;
                break;
            }
            case 3: {
                n3 = 1;
                n2 = 2;
                break;
            }
            default: {
                n3 = 0;
                n2 = 0;
                AppEngine.ASSERT(false, "Unknown sector for getQuickraceFromSector()!");
            }
        }
        return this.pickOneOfTwoInSector(n, n3, n2);
    }

    public int pickOneOfTwoInSector(int n, int n2, int n3) {
        int n4 = -1;
        boolean bl = this.rand(0, 99) < 50;
        byte[] byArray = this.m_eventTypes[n];
        for (int i = 2; n4 == -1 && i > 0; --i) {
            int n5 = bl ? n2 : n3;
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] != n5) continue;
                return j;
            }
            bl = !bl;
        }
        AppEngine.ASSERT(false, "Couldnt find any events for quickrace sector!");
        return -1;
    }

    public byte getCarFromDescriptionStringID(short s) {
        byte by = this.getNumCars();
        for (byte by2 = 0; by2 != by; by2 = (byte)(by2 + 1)) {
            if (this.m_carDescriptions[by2] != s) continue;
            return by2;
        }
        return -1;
    }

    public short getCarMakeStringID(short s) {
        return this.m_carMakes[s];
    }

    public int getCarPrice(int n) {
        return this.m_carPrices[n];
    }

    public int getCarUpgradeScale(int n) {
        return this.m_carUpgradeScales[n];
    }

    public int getNumCarsBuyable() {
        int n = 0;
        for (int i = 0; i < this.m_carFlags.length; ++i) {
            if (!this.getCarFlags(i, 1)) continue;
            ++n;
        }
        return n;
    }

    public boolean getCarFlags(int n, int n2) {
        return (this.m_carFlags[n] & n2) != 0;
    }

    public short getCarMeshChassisResID(int n) {
        return this.m_carMeshChassisResIDs[n];
    }

    public short getCarMeshWheelsResID(int n) {
        return this.m_carMeshWheelsResIDs[n];
    }

    public short getCarMeshBodykitResID(int n) {
        return this.m_carMeshBodykitResIDs[n];
    }

    public short getCarMeshLODResID(int n) {
        return this.m_carMeshLODResIDs[n];
    }

    public short getCarTextureResID(int n) {
        return this.m_carTextureResIDs[n];
    }

    public int getNumCarsWithTexture(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_carTextureResIDs.length; ++i) {
            if (this.m_carTextureResIDs[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getNthCarWithTexture(int n, int n2) {
        return this.getNthCarWithTexture(n, n2, -1);
    }

    public int getNthCarWithTexture(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.m_carTextureResIDs.length; ++i) {
            if (this.m_carTextureResIDs[i] != n || n3 == i || n4++ != n2) continue;
            return i;
        }
        return -1;
    }

    public int[] getCarBoundingRect(int n) {
        return this.m_carBoundingRects[n];
    }

    public int getCarWidth(int n) {
        return this.m_carWidths[n];
    }

    public int getCarLength(int n) {
        return this.m_carLengths[n];
    }

    public int getCarChassisY(int n) {
        return this.m_carChassisY[n];
    }

    public int getCarWheelFrontX(int n) {
        return this.m_carWheelFrontX[n];
    }

    public int getCarWheelFrontY(int n) {
        return this.m_carWheelFrontY[n];
    }

    public int getCarWheelFrontZ(int n) {
        return this.m_carWheelFrontZ[n];
    }

    public int getCarWheelBackX(int n) {
        return this.m_carWheelBackX[n];
    }

    public int getCarWheelBackY(int n) {
        return this.m_carWheelBackY[n];
    }

    public int getCarWheelBackZ(int n) {
        return this.m_carWheelBackZ[n];
    }

    public int getCarHeadlightX(int n) {
        return this.m_carHeadlightX[n];
    }

    public int getCarHeadlightY(int n) {
        return this.m_carHeadlightY[n];
    }

    public int getCarHeadlightZ(int n) {
        return this.m_carHeadlightZ[n];
    }

    public int getCarBrakelightX(int n) {
        return this.m_carBrakelightX[n];
    }

    public int getCarBrakelightY(int n) {
        return this.m_carBrakelightY[n];
    }

    public int getCarBrakelightZ(int n) {
        return this.m_carBrakelightZ[n];
    }

    public int getCarNitroX(int n) {
        return this.m_carNitroX[n];
    }

    public int getCarNitroY(int n) {
        return this.m_carNitroY[n];
    }

    public int getCarNitroZ(int n) {
        return this.m_carNitroZ[n];
    }

    public int getCarParamTyres() {
        return this.getCarParamTyres(this.m_playerCarIndex);
    }

    public int getCarParamTyres(int n) {
        return this.m_carParamTyres[n];
    }

    public int getCarParamSteeringInc() {
        return this.getCarParamSteeringInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringInc(int n) {
        return this.m_carParamSteeringInc[n];
    }

    public int getCarParamSteeringRecentreInc() {
        return this.getCarParamSteeringRecentreInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringRecentreInc(int n) {
        return this.m_carParamSteeringRecentreInc[n];
    }

    public int getCarParamSteeringMax() {
        return this.getCarParamSteeringMax(this.m_playerCarIndex);
    }

    public int getCarParamRollOffset() {
        return this.getCarParamRollOffset(this.m_playerCarIndex);
    }

    public int getCarParamRollSlope() {
        return this.getCarParamRollSlope(this.m_playerCarIndex);
    }

    public int getCarParamRollSteer() {
        return this.getCarParamRollSteer(this.m_playerCarIndex);
    }

    public int getCarParamSteeringMax(int n) {
        return this.m_carParamSteeringMax[n];
    }

    public int getCarParamRollOffset(int n) {
        return this.m_carParamRollOffset[n];
    }

    public int getCarParamRollSlope(int n) {
        return this.m_carParamRollSlope[n];
    }

    public int getCarParamRollSteer(int n) {
        return this.m_carParamRollSteer[n];
    }

    public byte getCarNumGears() {
        return this.getCarNumGears(this.m_playerCarIndex);
    }

    public byte getCarNumGears(int n) {
        return this.m_carNumGears[n];
    }

    public int getCarGearAccel(byte by) {
        return this.getCarGearAccel(this.m_playerCarIndex, by);
    }

    public int getCarGearAccel(int n, byte by) {
        return this.m_carGearAccels[n][by];
    }

    public int[] getCarGearAccelData() {
        return this.getCarGearAccelData(this.m_playerCarIndex);
    }

    public int[] getCarGearAccelData(int n) {
        return this.m_carGearAccels[n];
    }

    public int[] getCarGearMinSpeedData() {
        return this.getCarGearMinSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMinSpeedData(int n) {
        return this.m_carGearMinSpeeds[n];
    }

    public int[] getCarGearMaxSpeedData() {
        return this.getCarGearMaxSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMaxSpeedData(int n) {
        return this.m_carGearMaxSpeeds[n];
    }

    public int getCarGearMinSpeed(byte by) {
        return this.getCarGearMinSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMinSpeed(int n, byte by) {
        return this.m_carGearMinSpeeds[n][by];
    }

    public int getCarGearMaxSpeed(byte by) {
        return this.getCarGearMaxSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMaxSpeed(int n, byte by) {
        return this.m_carGearMaxSpeeds[n][by];
    }

    private void loadObjectData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(39);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_objectCarTypes = new short[n];
            this.m_objectMeshIds = new short[n];
            this.m_objectFlags = new short[n];
            this.m_objectCosts = new short[n];
            this.m_objectWeights = new int[n];
            inputStream = this.m_resourceManager.loadBinaryFile(39);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                this.m_objectCarTypes[i] = ObjectConstants.OBJECT_LOOKUPS[dataInputStream.readShort()];
                this.m_objectMeshIds[i] = ObjectConstants.OBJECT_LOOKUPS[dataInputStream.readShort()];
                this.m_objectFlags[i] = dataInputStream.readByte();
                this.m_objectCosts[i] = dataInputStream.readShort();
                this.m_objectWeights[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getObjectMesh(int n) {
        return this.m_objectMeshIds[n];
    }

    public int getObjectFlags(int n) {
        return this.m_objectFlags[n];
    }

    public int getObjectCost(int n) {
        return this.m_objectCosts[n];
    }

    public int getObjectWeight(int n) {
        return this.m_objectWeights[n];
    }

    public int getPlayerCarIndex() {
        return this.m_playerCarIndex;
    }

    public void setPlayerCarIndex(int n) {
        this.m_playerCarIndex = n;
    }

    public Node[] prepareCarNodes(int n, Node node, Node node2, Node node3, Node node4, Node node5, Node node6, Node node7, Node node8, boolean bl) {
        Node node9;
        AppEngine.timerBegin();
        Node[] nodeArray = new Node[25];
        int n2 = this.getCarChassisY(n);
        Group group = new Group();
        nodeArray[0] = group;
        Group group2 = new Group();
        nodeArray[1] = group2;
        group.addChild((Node)group2);
        Group group3 = new Group();
        nodeArray[3] = group3;
        Group group4 = null;
        Group group5 = null;
        if (bl) {
            Node node10;
            nodeArray[24] = node10 = this.m_resourceManager.cachedLoadM3GNode(6);
            AppEngine.setScalex((Transformable)node10, 8388);
            group5 = (Group)node10.find(12);
            group4 = (Group)node10.find(13);
            AppEngine.ASSERT(group5 != null, "Could not find car-at joint");
            AppEngine.ASSERT(group4 != null, "Could not find shadow-at joint");
            group2.addChild(node10);
            group5.addChild((Node)group3);
            AppEngine.setScalex((Transformable)group3, 511999);
            n2 -= 42598;
        } else {
            group2.addChild((Node)group3);
        }
        Group group6 = new Group();
        group3.addChild((Node)group6);
        nodeArray[4] = group6;
        AppEngine.setTranslationx((Transformable)group6, 0, n2, 0);
        node = AppEngine.helperDuplicateNode(node);
        group6.addChild(node);
        nodeArray[5] = node;
        if (node3 != null) {
            node3 = AppEngine.helperDuplicateNode(node3);
            group6.addChild(node3);
            nodeArray[6] = node3;
        }
        if (node4 != null) {
            node4 = AppEngine.helperDuplicateNode(node4);
            group6.addChild(node4);
            nodeArray[2] = node4;
        }
        if (node5 != null) {
            this.prepareCarNodesAddBrakelights(nodeArray, n, node5);
        }
        if (node6 != null) {
            this.prepareCarNodesAddHeadlights(nodeArray, n, node6);
        }
        if (node7 != null) {
            this.prepareCarNodesAddNitro(nodeArray, n, node7);
        }
        group6 = new Group();
        group3.addChild((Node)group6);
        nodeArray[7] = group6;
        AppEngine.setTranslationx((Transformable)group6, 0, n2, 0);
        int n3 = this.getCarWheelFrontX(n);
        int n4 = this.getCarWheelFrontY(n);
        int n5 = this.getCarWheelFrontZ(n);
        int n6 = this.getCarWheelBackX(n);
        int n7 = this.getCarWheelBackY(n);
        int n8 = this.getCarWheelBackZ(n);
        nodeArray[10] = node9 = AppEngine.helperDuplicateNode(node2);
        Group group7 = new Group();
        AppEngine.setOrientationx((Transformable)group7, 0xB40000, 0, 65536, 0);
        AppEngine.setTranslationx((Transformable)group7, n3, n4, n5);
        nodeArray[23] = group7;
        group7.addChild(node9);
        group6.addChild((Node)group7);
        nodeArray[11] = node9 = AppEngine.helperDuplicateNode(node2);
        group7 = new Group();
        AppEngine.setTranslationx((Transformable)group7, -n3, n4, n5);
        AppEngine.setOrientationx((Transformable)group7, 0, 0, 65536, 0);
        nodeArray[22] = group7;
        group7.addChild(node9);
        group6.addChild((Node)group7);
        nodeArray[9] = node9 = AppEngine.helperDuplicateNode(node2);
        group7 = new Group();
        AppEngine.setTranslationx((Transformable)group7, n6, n7, n8);
        AppEngine.setOrientationx((Transformable)group7, 0xB40000, 0, 65536, 0);
        nodeArray[21] = group7;
        group7.addChild(node9);
        group6.addChild((Node)group7);
        nodeArray[8] = node9 = AppEngine.helperDuplicateNode(node2);
        group7 = new Group();
        AppEngine.setTranslationx((Transformable)group7, -n6, n7, n8);
        AppEngine.setOrientationx((Transformable)group7, 0, 0, 65536, 0);
        nodeArray[20] = group7;
        group7.addChild(node9);
        group6.addChild((Node)group7);
        group6 = AppEngine.helperDuplicateNode(node8);
        nodeArray[12] = group6;
        if (bl) {
            group4.addChild((Node)group6);
        } else {
            group2.addChild((Node)group6);
        }
        AppEngine.setScaleSafe((Transformable)nodeArray[1], 0.128f);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[5]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[11]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[10]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[8]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[9]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[2]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[16]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[17]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[18]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[19]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[14]);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[15]);
        AppEngine.setScaleSafe((Transformable)nodeArray[12], bl ? 0.7812485f : 0.1f);
        AppEngine.setScaleSafeByJSR184_CAR_SCALE((Transformable)nodeArray[6]);
        AppEngine.carSetLevelOfDetail(0, nodeArray);
        AppEngine.timerEnd("---ppcn");
        return nodeArray;
    }

    private void prepareCarNodesAddBrakelights(Node[] nodeArray, int n, Node node) {
        int n2 = this.getCarBrakelightX(n);
        int n3 = this.getCarBrakelightY(n);
        int n4 = this.getCarBrakelightZ(n);
        Group group = (Group)nodeArray[4];
        nodeArray[16] = node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        AppEngine.setTranslationx((Transformable)node, n2, n3, n4);
        nodeArray[17] = node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        AppEngine.setTranslationx((Transformable)node, -n2, n3, n4);
    }

    private void prepareCarNodesAddHeadlights(Node[] nodeArray, int n, Node node) {
        int n2 = this.getCarHeadlightX(n);
        int n3 = this.getCarHeadlightY(n);
        int n4 = this.getCarHeadlightZ(n);
        Group group = (Group)nodeArray[4];
        nodeArray[18] = node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        AppEngine.setTranslationx((Transformable)node, n2, n3, n4);
        nodeArray[19] = node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        AppEngine.setTranslationx((Transformable)node, -n2, n3, n4);
    }

    private void prepareCarNodesAddNitro(Node[] nodeArray, int n, Node node) {
        Group group = new Group();
        ((Group)nodeArray[4]).addChild((Node)group);
        nodeArray[13] = group;
        int n2 = this.getCarNitroX(n);
        int n3 = this.getCarNitroY(n);
        int n4 = this.getCarNitroZ(n);
        node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        nodeArray[14] = node;
        AppEngine.setTranslationx((Transformable)node, n2, n3, n4);
        node = AppEngine.helperDuplicateNode(node);
        group.addChild(node);
        nodeArray[15] = node;
        AppEngine.setTranslationx((Transformable)node, -n2, n3, n4);
    }

    public static final void carSetSteeringAngle(int n, Node[] nodeArray) {
        AppEngine.setOrientationx((Transformable)nodeArray[22], n, 0, 65536, 0);
        AppEngine.setOrientationx((Transformable)nodeArray[23], 0xB40000 + n, 0, 65536, 0);
    }

    public static final void carSetWheelRotation(int n, Node[] nodeArray) {
        AppEngine.setOrientationx((Transformable)nodeArray[11], n, 65536, 0, 0);
        AppEngine.setOrientationx((Transformable)nodeArray[10], -n, 65536, 0, 0);
        AppEngine.setOrientationx((Transformable)nodeArray[8], n, 65536, 0, 0);
        AppEngine.setOrientationx((Transformable)nodeArray[9], -n, 65536, 0, 0);
    }

    public static final void carSetLightScales(int n, int n2, Node[] nodeArray) {
        Node node;
        n = (int)((float)n * 0.1f);
        n2 = (int)((float)n2 * 0.1f);
        Node node2 = nodeArray[18];
        if (node2 != null) {
            node = nodeArray[19];
            AppEngine.setScalex((Transformable)node2, n);
            AppEngine.setScalex((Transformable)node, n);
        }
        if ((node = nodeArray[16]) != null) {
            Node node3 = nodeArray[17];
            AppEngine.setScalex((Transformable)node, n2);
            AppEngine.setScalex((Transformable)node3, n2);
        }
    }

    public static final void carSetLevelOfDetail(int n, Node[] nodeArray) {
        Node node = nodeArray[5];
        Node node2 = nodeArray[6];
        Node node3 = nodeArray[12];
        Node node4 = nodeArray[7];
        Node node5 = nodeArray[2];
        switch (n) {
            case 0: {
                node.setRenderingEnable(true);
                node3.setRenderingEnable(true);
                node4.setRenderingEnable(true);
                if (node5 == null) break;
                node5.setRenderingEnable(false);
                break;
            }
            case 1: {
                node.setRenderingEnable(true);
                node3.setRenderingEnable(true);
                node4.setRenderingEnable(false);
                if (node5 == null) break;
                node5.setRenderingEnable(false);
                break;
            }
            case 2: {
                node.setRenderingEnable(false);
                node3.setRenderingEnable(false);
                node4.setRenderingEnable(false);
                if (node5 == null) break;
                node5.setRenderingEnable(true);
                break;
            }
            case 3: {
                node.setRenderingEnable(false);
                node3.setRenderingEnable(false);
                node4.setRenderingEnable(false);
                if (node5 == null) break;
                node5.setRenderingEnable(false);
            }
        }
        if (node2 != null) {
            node2.setRenderingEnable(node.isRenderingEnabled());
        }
    }

    private void loadEventSectorData() {
        try {
            int n;
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(20);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numEventSectors = n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_eventSectorNames = new short[n];
            this.m_eventSectorBossExp = new int[n];
            this.m_eventSectorEventCounts = new byte[n];
            this.m_eventTypes = new byte[n][];
            this.m_eventTrackIDs = new byte[n][];
            this.m_eventLaps = new byte[n][];
            this.m_eventPurses = new int[n][];
            this.m_eventCostTargets = new short[n][];
            this.m_eventDiffMinF = new int[n][];
            this.m_eventDiffMaxF = new int[n][];
            this.m_eventTrafficScaleF = new int[n][];
            this.m_eventTrafficMax = new byte[n][];
            this.m_eventTrafficFlags = new byte[n][];
            this.m_eventOpponents = new int[n][][];
            this.m_cutsceneSteps = new short[n][][][][];
            inputStream = this.m_resourceManager.loadBinaryFile(20);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                int n2;
                this.m_eventSectorNames[i] = EventConstants.EVENTS_LOOKUPS[dataInputStream.readByte()];
                this.m_eventSectorBossExp[i] = dataInputStream.readInt();
                this.m_eventSectorEventCounts[i] = n2 = dataInputStream.readByte();
                this.m_eventTypes[i] = new byte[n2];
                this.m_eventTrackIDs[i] = new byte[n2];
                this.m_eventLaps[i] = new byte[n2];
                this.m_eventPurses[i] = new int[n2];
                this.m_eventCostTargets[i] = new short[n2];
                this.m_eventDiffMinF[i] = new int[n2];
                this.m_eventDiffMaxF[i] = new int[n2];
                this.m_eventTrafficScaleF[i] = new int[n2];
                this.m_eventTrafficMax[i] = new byte[n2];
                this.m_eventTrafficFlags[i] = new byte[n2];
                this.m_eventOpponents[i] = new int[n2][];
                this.m_cutsceneSteps[i] = new short[n2][][][];
                for (int j = 0; j < n2; ++j) {
                    int n3;
                    int n4;
                    this.m_eventTypes[i][j] = dataInputStream.readByte();
                    this.m_eventTrackIDs[i][j] = (byte)EventConstants.EVENTS_LOOKUPS[dataInputStream.readByte()];
                    this.m_eventLaps[i][j] = dataInputStream.readByte();
                    this.m_eventPurses[i][j] = dataInputStream.readInt();
                    dataInputStream.readShort();
                    this.m_eventCostTargets[i][j] = dataInputStream.readShort();
                    this.m_eventDiffMinF[i][j] = dataInputStream.readInt();
                    this.m_eventDiffMaxF[i][j] = dataInputStream.readInt();
                    this.m_eventTrafficScaleF[i][j] = dataInputStream.readInt();
                    this.m_eventTrafficMax[i][j] = dataInputStream.readByte();
                    this.m_eventTrafficFlags[i][j] = dataInputStream.readByte();
                    this.m_cutsceneSteps[i][j] = new short[5][][];
                    int n5 = dataInputStream.readByte();
                    for (n4 = 0; n4 < n5; ++n4) {
                        n3 = dataInputStream.readByte();
                        int n6 = dataInputStream.readByte();
                        this.m_cutsceneSteps[i][j][n3] = new short[n6][];
                        for (int k = 0; k < n6; ++k) {
                            this.m_cutsceneSteps[i][j][n3][k] = new short[2];
                            this.m_cutsceneSteps[i][j][n3][k][0] = EventConstants.CUTSCENE_ANIMS[dataInputStream.readByte()];
                            this.m_cutsceneSteps[i][j][n3][k][1] = EventConstants.CUTSCENE_STRINGS[dataInputStream.readByte()];
                        }
                    }
                    n4 = dataInputStream.readByte();
                    this.m_eventOpponents[i][j] = new int[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.m_eventOpponents[i][j][n3] = EventConstants.EVENT_OPPONENTS[dataInputStream.readByte()];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getNumSectors() {
        return this.m_numEventSectors;
    }

    public byte getNumSectorsInCareer() {
        return (byte)(this.m_numEventSectors - 1);
    }

    public short getSectorName(int n) {
        return this.m_eventSectorNames[n];
    }

    public byte getEventCount(int n) {
        return this.m_eventSectorEventCounts[n];
    }

    public short getTotalEvents() {
        short s = 0;
        for (int i = 0; i < this.m_numEventSectors - 1; ++i) {
            s = (short)(s + this.m_eventSectorEventCounts[i]);
        }
        return s;
    }

    public byte getEventType(int n, int n2) {
        return this.m_eventTypes[n][n2];
    }

    public final short getEventName(int n) {
        switch (n) {
            case 0: {
                return 188;
            }
            case 2: {
                return 195;
            }
            case 1: {
                return 189;
            }
            case 3: {
                return 190;
            }
            case 7: {
                return 192;
            }
            case 4: {
                return 191;
            }
            case 5: {
                return 194;
            }
            case 6: {
                return 193;
            }
        }
        AppEngine.ASSERT(false, "invalid event type");
        return 2;
    }

    public byte getEventTrackID(int n, int n2) {
        return this.m_eventTrackIDs[n][n2];
    }

    public byte getEventLaps(int n, int n2) {
        return this.m_eventLaps[n][n2];
    }

    public int getEventPurse(int n, int n2) {
        int n3 = this.getEventClearedStatus(n, n2) ? MathExt.Fmul(this.m_eventPurses[n][n2], 16384) : this.m_eventPurses[n][n2];
        return n3 /= 2;
    }

    public short getEventCostTarget(int n, int n2) {
        return this.m_eventCostTargets[n][n2];
    }

    public byte getCurrentEventType() {
        return this.getEventType(this.getCurrentRaceSectorIndex(), this.getCurrentRaceEventIndex());
    }

    public short getCurrentEventCostTarget() {
        return this.m_eventCostTargets[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventDiffMin() {
        return this.m_eventDiffMinF[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventDiffMax() {
        return this.m_eventDiffMaxF[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficScale() {
        return this.m_eventTrafficScaleF[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficMax() {
        return this.m_eventTrafficMax[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficFlags() {
        return this.m_eventTrafficFlags[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public int[] getCurrentEventOpponents() {
        return this.m_eventOpponents[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public short[][][] getCurrentEventCutscenes() {
        return this.m_cutsceneSteps[this.getCurrentRaceSectorIndex()][this.getCurrentRaceEventIndex()];
    }

    public void setRaceParameters(int n, int n2, int n3) {
        this.m_currentRaceType = n;
        this.m_currentRaceSectorIndex = (byte)n2;
        this.m_currentRaceEventIndex = (byte)n3;
        this.setCarNowRacingParameters();
    }

    private void setCarNowRacingParameters() {
        this.m_carNowRacingParamTyres = this.getCarParamTyres();
        this.m_carNowRacingParamSteeringInc = this.getCarParamSteeringInc();
        this.m_carNowRacingParamSteeringRecentreInc = this.getCarParamSteeringRecentreInc();
        this.m_carNowRacingParamSteeringMax = this.getCarParamSteeringMax();
        this.m_carNowRacingParamRollOffset = this.getCarParamRollOffset();
        this.m_carNowRacingParamRollSlope = this.getCarParamRollSlope();
        this.m_carNowRacingParamRollSteer = this.getCarParamRollSteer();
        this.m_carNowRacingGearAccels = AppEngine.copyArray(this.getCarGearAccelData());
        this.m_carNowRacingGearMinSpeeds = this.getCarGearMinSpeedData();
        this.m_carNowRacingGearMaxSpeeds = AppEngine.copyArray(this.getCarGearMaxSpeedData());
        this.m_carNowRacingNitroExtra = 65536;
        if (this.isCurrentRaceCareer()) {
            this.m_carNowRacingParamTyres = MathExt.Fmul(this.m_carNowRacingParamTyres, this.getCareerAccessoryAdjustment(2));
            int n = this.getCareerAccessoryAdjustment(1);
            int n2 = this.getCareerAccessoryAdjustment(0);
            int n3 = this.getCarNumGears();
            for (int i = 0; i < n3; ++i) {
                this.m_carNowRacingGearAccels[i] = MathExt.Fmul(this.m_carNowRacingGearAccels[i], n);
                this.m_carNowRacingGearMaxSpeeds[i] = MathExt.Fmul(this.m_carNowRacingGearMaxSpeeds[i], n2);
            }
            this.m_carNowRacingNitroExtra = this.getCareerAccessoryAdjustment(3);
        } else {
            this.m_carNowRacingNitroExtra = this.getCareerAccessoryAdjustment(3, this.m_playerCarIndex, 1);
        }
    }

    public int getCarNowRacingParamTyres() {
        return this.m_carNowRacingParamTyres;
    }

    public int getCarNowRacingParamSteeringInc() {
        return this.m_carNowRacingParamSteeringInc;
    }

    public int getCarNowRacingParamSteeringRecentreInc() {
        return this.m_carNowRacingParamSteeringRecentreInc;
    }

    public int getCarNowRacingParamSteeringMax() {
        return this.m_carNowRacingParamSteeringMax;
    }

    public int getCarNowRacingParamRollOffset() {
        return this.m_carNowRacingParamRollOffset;
    }

    public int getCarNowRacingParamRollSlope() {
        return this.m_carNowRacingParamRollSlope;
    }

    public int getCarNowRacingParamRollSteer() {
        return this.m_carNowRacingParamRollSteer;
    }

    public int getCarNowRacingNitroLevel() {
        return this.getCarAccessoryLevel(this.m_playerCarIndex, 3);
    }

    public int getCarNowRacingNitroExtra() {
        return this.m_carNowRacingNitroExtra;
    }

    public boolean getCarNowRacingBodykit() {
        return this.getCarAccessoryLevel(this.m_playerCarIndex, 4) != 0;
    }

    public int[] getCarNowRacingGearAccelData() {
        return this.m_carNowRacingGearAccels;
    }

    public int[] getCarNowRacingGearMinSpeedData() {
        return this.m_carNowRacingGearMinSpeeds;
    }

    public int[] getCarNowRacingGearMaxSpeedData() {
        return this.m_carNowRacingGearMaxSpeeds;
    }

    public int getCareerAccessoryAdjustment(int n) {
        return this.getCareerAccessoryAdjustment(n, this.m_playerCarIndex);
    }

    public int getCareerAccessoryAdjustment(int n, int n2) {
        byte by = s_rmsAccessoryLevel[n2][n];
        return this.getCareerAccessoryAdjustment(n, n2, by);
    }

    public int getCareerAccessoryAdjustment(int n, int n2, int n3) {
        if (n3 > 0) {
            return s_careerTunerAccessoryBoostsF[n][n3 - 1];
        }
        return 65536;
    }

    public boolean isCurrentRaceCareer() {
        return this.m_currentRaceType == 3;
    }

    public boolean isCurrentRaceTutorial() {
        return this.m_currentRaceType == 0;
    }

    public void setPostTutorialState(byte by) {
        this.m_postTutorialState = by;
    }

    public byte getPostTutorialState() {
        return this.m_postTutorialState;
    }

    public byte getCurrentRaceSectorIndex() {
        return this.m_currentRaceSectorIndex;
    }

    public byte getCurrentRaceEventIndex() {
        return this.m_currentRaceEventIndex;
    }

    public static void postRotatex(Transform transform, int n, int n2, int n3, int n4) {
        transform.postRotate(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3), MathExt.fixed16ToFloat(n4));
    }

    public static void postTranslatex(Transform transform, int n, int n2, int n3) {
        transform.postTranslate(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3));
    }

    public static void postScalex(Transform transform, int n, int n2, int n3) {
        transform.postScale(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3));
    }

    public static void transformx(Transform transform, int[] nArray) {
        int n;
        float[] fArray = s_tempFloat4;
        for (n = 0; n < 4; ++n) {
            fArray[n] = MathExt.fixed16ToFloat(nArray[n]);
        }
        transform.transform(fArray);
        for (n = 0; n < 4; ++n) {
            nArray[n] = MathExt.floatToFixed16(fArray[n]);
        }
    }

    public static void setScalex(Transformable transformable, int n) {
        float f = MathExt.fixed16ToFloat(n);
        transformable.setScale(f, f, f);
    }

    public static void setScaleSafex(Transformable transformable, int n) {
        if (transformable != null) {
            float f = MathExt.fixed16ToFloat(n);
            transformable.setScale(f, f, f);
        }
    }

    public static void setScaleSafe(Transformable transformable, float f) {
        if (transformable != null) {
            transformable.setScale(f, f, f);
        }
    }

    public static void setScaleSafeByJSR184_CAR_SCALE(Transformable transformable) {
        if (transformable != null) {
            transformable.setScale(0.1f, 0.1f, 0.1f);
        }
    }

    public static void setScalex(Transformable transformable, int n, int n2, int n3) {
        transformable.setScale(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3));
    }

    public static void setOrientationx(Transformable transformable, int n, int n2, int n3, int n4) {
        transformable.setOrientation(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3), MathExt.fixed16ToFloat(n4));
    }

    public static void setTranslationx(Transformable transformable, int n, int n2, int n3) {
        transformable.setTranslation(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3));
    }

    public static void getTranslationx(Transformable transformable, int[] nArray) {
        transformable.getTranslation(s_tempFloat16);
        nArray[0] = MathExt.floatToFixed16(s_tempFloat16[0]);
        nArray[1] = MathExt.floatToFixed16(s_tempFloat16[1]);
        nArray[2] = MathExt.floatToFixed16(s_tempFloat16[2]);
    }

    public static void setPerspectivex(Camera camera, int n, int n2, int n3, int n4) {
        camera.setPerspective(MathExt.fixed16ToFloat(n), MathExt.fixed16ToFloat(n2), MathExt.fixed16ToFloat(n3), MathExt.fixed16ToFloat(n4));
    }

    public static void getTransformedPointx(Node node, Node node2, int[] nArray) {
        Transform transform = s_tempTransform;
        boolean bl = node.getTransformTo(node2, transform);
        AppEngine.ASSERT(bl, "invalid getTransformTo call");
        AppEngine.transformx(transform, nArray);
    }

    public static void helperApplyTexture(Node node, Image2D image2D) {
        if (node instanceof Mesh) {
            Mesh mesh = (Mesh)node;
            Appearance appearance = mesh.getAppearance(0);
            if (appearance == null && image2D != null) {
                appearance = new Appearance();
                mesh.setAppearance(0, appearance);
            }
            if (appearance != null) {
                Texture2D texture2D = appearance.getTexture(0);
                if (texture2D == null) {
                    if (image2D != null) {
                        texture2D = new Texture2D(image2D);
                        texture2D.setBlending(228);
                        texture2D.setFiltering(210, 209);
                        appearance.setTexture(0, texture2D);
                    }
                } else if (image2D == null) {
                    appearance.setTexture(0, null);
                } else {
                    texture2D.setBlending(228);
                    texture2D.setFiltering(210, 209);
                    texture2D.setImage(image2D);
                }
            }
        } else if (node instanceof Group) {
            Group group = (Group)node;
            int n = group.getChildCount();
            for (int i = 0; i < n; ++i) {
                AppEngine.helperApplyTexture(group.getChild(i), image2D);
            }
        }
    }

    public static Image2D helperGetTexture(Node node) {
        if (node instanceof Mesh) {
            Texture2D texture2D;
            Mesh mesh = (Mesh)node;
            Appearance appearance = mesh.getAppearance(0);
            if (appearance != null && (texture2D = appearance.getTexture(0)) != null) {
                return texture2D.getImage();
            }
        } else if (node instanceof Group) {
            Group group = (Group)node;
            int n = group.getChildCount();
            for (int i = 0; i < n; ++i) {
                Image2D image2D = AppEngine.helperGetTexture(group.getChild(i));
                if (image2D == null) continue;
                return image2D;
            }
        }
        return null;
    }

    private static void initAppearanceLibrary() {
        s_appLibrary = new Appearance[34];
        Appearance appearance = new Appearance();
        appearance.setLayer(-1);
        CompositingMode compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        AppEngine.s_appLibrary[0] = appearance;
        appearance = new Appearance();
        appearance.setLayer(5);
        compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        compositingMode.setBlending(66);
        compositingMode.setDepthTestEnable(true);
        compositingMode.setDepthWriteEnable(false);
        AppEngine.s_appLibrary[1] = appearance;
        appearance = new Appearance();
        appearance.setLayer(0);
        compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        AppEngine.s_appLibrary[2] = appearance;
        AppEngine.s_appLibrary[4] = appearance = (Appearance)appearance.duplicate();
        AppEngine.s_appLibrary[5] = appearance = (Appearance)appearance.duplicate();
        appearance = (Appearance)appearance.duplicate();
        PolygonMode polygonMode = new PolygonMode();
        appearance.setPolygonMode(polygonMode);
        polygonMode.setWinding(169);
        AppEngine.s_appLibrary[6] = appearance;
        appearance = new Appearance();
        appearance.setLayer(10);
        compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        compositingMode.setBlending(65);
        compositingMode.setDepthTestEnable(true);
        compositingMode.setDepthWriteEnable(false);
        polygonMode = new PolygonMode();
        appearance.setPolygonMode(polygonMode);
        polygonMode.setCulling(162);
        AppEngine.s_appLibrary[7] = appearance;
        AppEngine.s_appLibrary[8] = appearance = (Appearance)appearance.duplicate();
        AppEngine.s_appLibrary[3] = appearance = (Appearance)appearance.duplicate();
        appearance = (Appearance)appearance.duplicate();
        polygonMode = new PolygonMode();
        appearance.setPolygonMode(polygonMode);
        polygonMode.setWinding(169);
        AppEngine.s_appLibrary[9] = appearance;
        appearance = new Appearance();
        appearance.setLayer(0);
        compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        compositingMode.setBlending(64);
        AppEngine.s_appLibrary[10] = appearance;
        AppEngine.s_appLibrary[11] = appearance = (Appearance)appearance.duplicate();
        appearance = (Appearance)appearance.duplicate();
        polygonMode = new PolygonMode();
        appearance.setPolygonMode(polygonMode);
        polygonMode.setWinding(169);
        AppEngine.s_appLibrary[12] = appearance;
        appearance = new Appearance();
        appearance.setLayer(0);
        compositingMode = new CompositingMode();
        appearance.setCompositingMode(compositingMode);
        compositingMode.setAlphaThreshold(0.0f);
        AppEngine.s_appLibrary[13] = appearance;
        for (int i = 0; i < 20; ++i) {
            appearance = new Appearance();
            appearance.setLayer(0);
            compositingMode = new CompositingMode();
            appearance.setCompositingMode(compositingMode);
            compositingMode.setAlphaThreshold(0.0f);
            AppEngine.s_appLibrary[14 + i] = appearance;
        }
    }

    public static void helperApplyProperty(Node node, int n) {
        Group group;
        Mesh mesh = node instanceof Mesh ? (Mesh)node : null;
        Group group2 = group = node instanceof Group ? (Group)node : null;
        if (mesh != null) {
            CompositingMode compositingMode;
            int n2 = -1;
            Appearance appearance = mesh.getAppearance(0);
            CompositingMode compositingMode2 = compositingMode = appearance != null ? appearance.getCompositingMode() : null;
            if ((n & 1) != 0) {
                n2 = 0;
            } else if ((n & 0x40) != 0) {
                n2 = 2;
            } else if ((n & 8) != 0) {
                n2 = 13;
            } else if ((n & 4) != 0) {
                Image2D image2D = appearance.getTexture(0).getImage();
                AppEngine.ASSERT(image2D != null, "Car texture is null.");
                for (int i = 0; i < 20; ++i) {
                    Texture2D texture2D = s_appLibrary[14 + i].getTexture(0);
                    Image2D image2D2 = null;
                    if (texture2D != null) {
                        image2D2 = texture2D.getImage();
                    }
                    if (texture2D != null && image2D2 != image2D) continue;
                    n2 = 14 + i;
                    break;
                }
            } else {
                int n3;
                int n4 = n3 = compositingMode == null ? 68 : compositingMode.getBlending();
                if (n3 == 66) {
                    n2 = 1;
                } else if (n3 == 65) {
                    n2 = (n & 2) != 0 ? ((n & 0x10) != 0 ? 9 : 8) : 7;
                } else if (n3 == 64) {
                    n2 = (n & 2) != 0 ? ((n & 0x10) != 0 ? 12 : 11) : 10;
                } else if (n3 == 68) {
                    n2 = (n & 2) != 0 ? ((n & 0x10) != 0 ? ((n & 0x20) != 0 ? 12 : 6) : ((n & 0x20) != 0 ? 11 : 5)) : 4;
                }
            }
            if (n2 != -1) {
                s_appLibrary[n2].setTexture(0, appearance.getTexture(0));
                s_appLibrary[n2].setTexture(1, appearance.getTexture(1));
                mesh.setAppearance(0, s_appLibrary[n2]);
                if (n2 == 3) {
                    s_appLibrary[n2].getTexture(0).setBlending(227);
                }
            } else {
                AppEngine.ASSERT(false, "failed to find an appropriate appearance");
            }
        } else if (group != null) {
            int n5 = group.getChildCount();
            for (int i = 0; i < n5; ++i) {
                AppEngine.helperApplyProperty(group.getChild(i), n);
            }
        }
    }

    public static Node helperOrphan(Node node) {
        if (node != null && node.getParent() != null) {
            ((Group)node.getParent()).removeChild(node);
        }
        return node;
    }

    public static void helperCreateLookAtTransform(Transform transform, int n, int n2, int n3, int n4, int n5, int n6) {
        if (transform == null) {
            return;
        }
        float f = (float)n * 1.5258789E-5f;
        float f2 = (float)n2 * 1.5258789E-5f;
        float f3 = (float)n3 * 1.5258789E-5f;
        float f4 = (float)(n4 - n) * 1.5258789E-5f;
        float f5 = (float)(n5 - n2) * 1.5258789E-5f;
        float f6 = (float)(n6 - n3) * 1.5258789E-5f;
        float f7 = 1.0f / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f8 = -(f6 *= f7);
        float f9 = f4 *= f7;
        float f10 = 1.0f / (float)Math.sqrt(f8 * f8 + f9 * f9);
        float f11 = -((f9 *= f10) * (f5 *= f7));
        float f12 = f9 * f4 - (f8 *= f10) * f6;
        float f13 = f8 * f5;
        float[] fArray = s_tempFloat16;
        fArray[0] = f8;
        fArray[1] = 0.0f;
        fArray[2] = f9;
        fArray[3] = 0.0f;
        fArray[4] = f11;
        fArray[5] = f12;
        fArray[6] = f13;
        fArray[7] = 0.0f;
        fArray[8] = -f4;
        fArray[9] = -f5;
        fArray[10] = -f6;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        transform.set(fArray);
        transform.postTranslate(-f, -f2, -f3);
        transform.invert();
    }

    public static void helperWorldToScreenPrepTrans(Camera camera, Transform transform, Transform transform2) {
        camera.getProjection(transform2);
        Transform transform3 = s_tempTransform2;
        transform3.set(transform);
        transform3.invert();
        transform2.postMultiply(transform3);
    }

    public static void helperWorldToScreen(int[] nArray, int[] nArray2, int n, int n2, Transform transform) {
        float[] fArray = s_tempFloat4;
        fArray[0] = (float)nArray2[0] * 1.5258789E-5f;
        fArray[1] = (float)nArray2[1] * 1.5258789E-5f;
        fArray[2] = (float)nArray2[2] * 1.5258789E-5f;
        fArray[3] = 1.0f;
        transform.transform(fArray);
        float f = fArray[3] * 1.5f;
        if (f > 0.0f) {
            float f2 = 1.0f / f;
            float f3 = fArray[0] * f2;
            float f4 = fArray[1] * f2;
            nArray[0] = (int)((f3 *= 0.8f) * (float)n + (float)(n >> 1));
            nArray[1] = (int)((f4 *= -0.8f) * (float)n2 + (float)(n2 >> 1));
        } else {
            nArray[0] = Integer.MAX_VALUE;
            nArray[1] = Integer.MAX_VALUE;
        }
    }

    public static Node helperDuplicateNode(Node node) {
        int n;
        VertexBuffer vertexBuffer;
        Object object;
        Object object2 = null;
        if (node instanceof Mesh) {
            object = (Mesh)node;
            vertexBuffer = object.getVertexBuffer();
            n = object.getSubmeshCount();
            IndexBuffer[] indexBufferArray = new IndexBuffer[n];
            Appearance[] appearanceArray = new Appearance[n];
            for (int i = 0; i < n; ++i) {
                indexBufferArray[i] = object.getIndexBuffer(i);
                appearanceArray[i] = object.getAppearance(i);
            }
            object2 = new Mesh(vertexBuffer, indexBufferArray, appearanceArray);
        } else if (node instanceof Group) {
            object = new Group();
            vertexBuffer = (Group)node;
            n = vertexBuffer.getChildCount();
            for (int i = 0; i < n; ++i) {
                object.addChild(AppEngine.helperDuplicateNode(vertexBuffer.getChild(i)));
            }
            object2 = object;
        }
        object2.setUserID(node.getUserID());
        object = s_tempFloat4;
        node.getTranslation((float[])object);
        object2.setTranslation((float)object[0], (float)object[1], (float)object[2]);
        node.getOrientation((float[])object);
        object2.setOrientation((float)object[0], (float)object[1], (float)object[2], (float)object[3]);
        node.getScale((float[])object);
        object2.setScale((float)object[0], (float)object[1], (float)object[2]);
        int n2 = node.getAnimationTrackCount();
        for (n = 0; n < n2; ++n) {
            object2.addAnimationTrack(node.getAnimationTrack(n));
        }
        return object2;
    }

    public final int getCacheFlags(int n) {
        if (n == 47 || n == 52 || n == 15 || n == 21 || n == 40 || n == 43 || n == 6) {
            return 16;
        }
        if (n == 53 || n == 55 || n == 56 || n == 54) {
            return 3;
        }
        if (n == 19 || n == 41 || n == 26 || n == 46) {
            return 4;
        }
        if (AppEngine.indexOf(n, this.m_carTextureResIDs) != -1) {
            return 1;
        }
        for (int i = 0; i < this.m_carMeshChassisResIDs.length; ++i) {
            if (this.m_resourceManager.getMergedM3GOwner(this.m_carMeshChassisResIDs[i]) != n) continue;
            return 2;
        }
        return 5;
    }

    private final void initCache() {
        ResourceManager resourceManager = this.m_resourceManager;
        resourceManager.setCacheGroupLimit(2, 99);
        resourceManager.setCacheGroupLimit(1, 99);
        resourceManager.setCacheGroupLimit(3, 99);
        resourceManager.setCacheGroupLimit(4, 99);
        resourceManager.setCacheGroupLimit(5, 99);
    }

    public static short[] menuMake(int n) {
        short[] sArray = new short[8 + n];
        return sArray;
    }

    public static void menuClear(short[] sArray, int n) {
        sArray[1] = (short)n;
        sArray[0] = 0;
        sArray[5] = 0;
        sArray[6] = 0;
        sArray[7] = 0;
        sArray[2] = 0;
        sArray[4] = 0;
    }

    public static void menuAppendItem(short[] sArray, int n) {
        AppEngine.menuAppendItem(sArray, n, false, false);
    }

    public static void menuAppendItem(short[] sArray, int n, boolean bl, boolean bl2) {
        short s = sArray[0];
        sArray[8 + s] = (short)n;
        if (bl) {
            sArray[2] = (short)(sArray[2] | 1 << s);
            AppEngine.menuSetItemToggled(sArray, s, bl2);
        } else {
            sArray[2] = (short)(sArray[2] & (0xFFFF ^ 1 << s));
        }
        sArray[0] = (short)(sArray[0] + 1);
    }

    public static void menuAppendItem(short[] sArray, int n, boolean bl, boolean bl2, boolean bl3) {
        short s = sArray[0];
        sArray[4] = bl3 ? (short)(sArray[4] | 1 << s) : (short)(sArray[4] & (0xFFFF ^ 1 << s));
        AppEngine.menuAppendItem(sArray, n, bl, bl2);
    }

    public static short menuGetTitle(short[] sArray) {
        return sArray[1];
    }

    public static short menuGetLength(short[] sArray) {
        return sArray[0];
    }

    public static short menuGetHeight(short[] sArray) {
        return sArray[7];
    }

    public static short menuGetOffset(short[] sArray) {
        return sArray[6];
    }

    public static int menuGetWidth(int n, short[] sArray) {
        AppEngine appEngine = AppEngine.getCanvas();
        int n2 = AppEngine.getToggleWidth(n);
        int n3 = 0;
        for (int i = sArray[0] - 1; i >= 0; --i) {
            int n4 = appEngine.getStringWidth(sArray[8 + i], n);
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (sArray[2] != 0) {
            n3 += n2;
        }
        return n3;
    }

    public static final int getToggleWidth(int n) {
        int n2;
        int n3;
        int n4 = 0;
        AppEngine appEngine = AppEngine.getCanvas();
        int n5 = appEngine.getStringWidth(85, n3 = n);
        n4 = n5 > (n2 = appEngine.getStringWidth(86, n3)) ? n5 : n2;
        return n4 + 5;
    }

    public static short menuGetSelection(short[] sArray) {
        return sArray[5];
    }

    public static short menuGetSelectedItem(short[] sArray) {
        return sArray[8 + sArray[5]];
    }

    public static void menuSetSelection(short[] sArray, short s) {
        sArray[5] = s;
    }

    public static void menuSetHeight(short[] sArray, int n) {
        sArray[7] = (short)n;
    }

    public static void menuSetOffset(short[] sArray, short s) {
        sArray[6] = s;
    }

    public static void menuSelectFromString(short[] sArray, short s) {
        for (int i = AppEngine.menuGetLength(sArray) - 1; i >= 0; --i) {
            if (sArray[8 + i] != s) continue;
            AppEngine.menuSetSelection(sArray, (short)i);
            return;
        }
        AppEngine.menuSetSelection(sArray, (short)0);
    }

    public static void menuSelectNext(short[] sArray) {
        sArray[5] = (short)((sArray[5] + 1) % sArray[0]);
        if (sArray[5] >= sArray[6] + sArray[7]) {
            sArray[6] = (short)(sArray[5] - sArray[7] + 1);
        }
        if (sArray[5] < sArray[6]) {
            sArray[6] = sArray[5];
        }
    }

    public static void menuSelectPrev(short[] sArray) {
        sArray[5] = (short)((sArray[5] + sArray[0] - 1) % sArray[0]);
        if (sArray[5] < sArray[6]) {
            sArray[6] = sArray[5];
        }
        if (sArray[5] >= sArray[6] + sArray[7]) {
            sArray[6] = (short)(sArray[5] - sArray[7] + 1);
        }
    }

    public static short menuGetItem(short[] sArray, int n) {
        return sArray[8 + n];
    }

    public static boolean menuItemHasToggle(short[] sArray, int n) {
        return (sArray[2] & 1 << n) != 0;
    }

    public static void menuSetItemToggled(short[] sArray, int n, boolean bl) {
        if (bl) {
            sArray[3] = (short)(sArray[3] | 1 << n);
        } else if (AppEngine.menuItemIsToggled(sArray, n)) {
            sArray[3] = (short)(sArray[3] ^ 1 << n);
        }
    }

    public static boolean menuItemHasLock(short[] sArray, int n) {
        return (sArray[4] & 1 << n) != 0;
    }

    public static boolean menuItemIsToggled(short[] sArray, int n) {
        return (sArray[3] & 1 << n) != 0;
    }

    public int getLastWindowX() {
        return this.m_lastWindowX;
    }

    public int getLastWindowY() {
        return this.m_lastWindowY;
    }

    public int getLastWindowBottom() {
        return this.m_lastWindowContBottom;
    }

    public int getTitledWindowHeight() {
        int n = this.getLineHeight(1);
        return this.getLineHeight(3) + 2 + (n >> 1) + (n >> 2);
    }

    public int getBossRequiredExp(int n) {
        return this.m_eventSectorBossExp[n];
    }

    public int getBossTrack(int n) {
        for (int i = 0; i < this.getEventCount(n); ++i) {
            if (this.m_eventTypes[n][i] != 7) continue;
            return i;
        }
        return 0;
    }

    public int getBossLockedSector() {
        for (int i = 0; i < this.m_rmsBossLock.length; ++i) {
            if (!this.m_rmsBossLock[i]) continue;
            return i;
        }
        return this.m_rmsBossLock.length;
    }

    public void setUnlockBoss(int n) {
        this.m_rmsBossLock[n] = false;
    }

    public boolean isBossLocked(int n) {
        return this.m_rmsBossLock[n];
    }

    public boolean eventsCompletedInSector(int n) {
        for (int i = 0; i < this.getEventCount(n); ++i) {
            if (this.m_eventTypes[n][i] == 7 || this.getEventClearedStatus(n, i)) continue;
            return false;
        }
        return true;
    }

    public boolean isSectorLocked(int n) {
        return n > 0 && !this.getEventClearedStatus(--n, this.getBossTrack(n));
    }

    public boolean isNonBossEventsUnlocked(int n) {
        byte by = this.getEventCount(n);
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            if (this.getEventType(n, by2) == 7 || this.getEventClearedStatus(n, by2)) continue;
            return false;
        }
        return true;
    }

    public boolean isGameFinished() {
        int n = this.getNumSectorsInCareer() - 1;
        int n2 = this.getBossTrack(n);
        return this.getEventClearedStatus(n, n2);
    }

    private void DEBUG_RMS(String string) {
    }

    void initGameCenter() {
        String string = this.m_midlet.getAppProperty("GameCenterName");
        String string2 = this.m_midlet.getAppProperty("GameCenterUrl");
        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            this.gameCenterID = this.getNextFreeStringID();
            SDKString sDKString = AppEngine.getStringBuffer();
            this.appendString(sDKString, string);
            this.gameCenterUrl = string2;
        } else {
            this.gameCenterID = this.STRING_MTX_QQ_WAP;
            this.gameCenterUrl = "http://g.3g.qq.com/g/s?aid=g_cp_adver";
        }
    }

    static {
        first = false;
        s_gsBuffer = new SDKString();
        TEMP_STRING_BUFFER = new SDKString[15];
        ACQUIRED_STRING_BUFFER = new boolean[15];
        s_scrollerStringId = new int[2];
        s_scrollerStringWidth = new int[2];
        s_scrollerTime = new long[2];
        s_scrollerOffset = new int[2];
        s_scrollerStringArray = new SDKString[2];
        s_postEffects = new PostEffects();
        CHEAT_CODES = new int[][]{{0, 42, 42, 51, 56, 51, 54, 56, 55, 35, 35}, {0, 42, 42, 54, 54, 54, 51, 57, 35, 35}, {0, 42, 42, 57, 52, 54}, {0, 42, 42, 53, 54, 55, 51}};
        IMAGE_IDS = new long[]{38L, 2L, 32L, 2L, 66L, 2L, 65L, 2L, 34L, 2L, 35L, 2L, 36L, 2L, 42L, 2L, 59L, 1L, 60L, 1L, 33L, 2L, 63L, 2L, 64L, 2L, 27L, 1L, 61L, 1L, 23L, 64L, 1L, 1L, 45L, 2L, 7L, 2L, 28L, 2L, 2L, 2L, 3L, 2L, 25L, 64L, -1L};
        LOADING_STATS_SPRINT = new short[]{93, 94};
        LOADING_STATS_CIRCUIT = new short[]{92, 93, 94};
        LOADING_STATS_KO = new short[]{92, 93, 94};
        LOADING_STATS_CAMERA = new short[]{95, 94};
        LOADING_STATS_BOUNTY = new short[]{96, 94};
        LOADING_STATS_TAKEOUT = new short[]{97, 94};
        LOADING_STATS_BOSS = new short[]{97, 94};
        LOADING_STATS_BATTLE = new short[]{97, 94};
        s_tempTransform = new Transform();
        s_tempTransform2 = new Transform();
        s_tempFloat4 = new float[4];
        s_tempFloat16 = new float[16];
    }
}

