/*
 * Decompiled with CFR 0.152.
 */
package jg.util.text;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import jg.Gob;
import jg.util.IntHashtable;

public class RichFont {
    private static char[] reusableCharBuffer;
    private Font systemFont = Font.getFont((int)0, (int)0, (int)0);
    private int systemFontId = 1;
    private boolean systemFontColorEnabled;
    private int systemFontColor;
    private Gob[] gobFont;
    private IntHashtable gobByChar;

    public boolean isGobFont() {
        return this.gobFont != null;
    }

    public Gob[] getGobFont() {
        return this.gobFont;
    }

    public void setGobFont(Gob[] gobArray) {
        this.gobFont = gobArray;
        if (this.gobFont != null && gobArray[3].collisionHeight == 255) {
            gobArray[3].collisionHeight = 0;
            int n = 0;
            int n2 = 0;
            while (n2 < gobArray.length) {
                Gob gob = gobArray[n2];
                n = (short)(n + ((gob.offsetX << 8) + (gob.offsetY & 0xFF)));
                gob.offsetX = gob.collisionX;
                gob.offsetY = gob.collisionY;
                gob.collisionX = (short)n;
                ++n2;
            }
        }
    }

    public Gob getCharGob(char c) {
        Gob gob = null;
        if (this.gobFont != null) {
            if (this.gobByChar != null) {
                gob = (Gob)this.gobByChar.get(c);
            }
            if (gob == null) {
                int n = 0;
                int n2 = this.gobFont.length - 1;
                while (n <= n2) {
                    int n3 = n + n2 >> 1;
                    char c2 = (char)this.gobFont[n3].collisionX;
                    if (c2 < c) {
                        n = n3 + 1;
                        continue;
                    }
                    if (c2 > c) {
                        n2 = n3 - 1;
                        continue;
                    }
                    gob = this.gobFont[n3];
                    break;
                }
            }
        }
        return gob;
    }

    public int getBaselinePosition() {
        int n = 0;
        if (this.gobFont != null) {
            n = this.gobFont[1].collisionHeight;
        } else if (this.systemFont != null) {
            n = this.systemFont.getBaselinePosition();
        }
        return n;
    }

    public boolean isMonospaced() {
        return this.getMonospaceAdvance() != 0;
    }

    private int getMonospaceAdvance() {
        int n = 0;
        if (this.gobFont != null) {
            n = this.gobFont[6].collisionHeight;
        }
        return n;
    }

    public int getHeight() {
        int n = 0;
        if (this.gobFont != null) {
            n = this.gobFont[0].collisionHeight;
        } else if (this.systemFont != null) {
            n = this.systemFont.getHeight();
        }
        return n;
    }

    public int getWidth(char c) {
        this.ensureCharBufferCapacity(1);
        RichFont.reusableCharBuffer[0] = c;
        return this.getWidth(reusableCharBuffer, 0, 1);
    }

    public int getWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        if (this.gobFont != null) {
            n2 += n;
            while (n < n2) {
                Gob gob = this.getCharGob(cArray[n]);
                n3 += gob != null ? gob.collisionWidth : this.gobFont[2].collisionHeight;
                ++n;
            }
        } else if (n2 != 0 && this.systemFont != null) {
            n3 = this.systemFont.charsWidth(cArray, n, n2);
        }
        return n3;
    }

    private int getStartXOffset(char[] cArray, int n) {
        Gob gob;
        int n2 = 0;
        if (this.gobFont != null && n < cArray.length && (gob = this.getCharGob(cArray[n])) != null) {
            n2 = gob.offsetX;
        }
        return n2;
    }

    private int getPhysicalWidth(char[] cArray, int n, int n2, int n3) {
        if (this.gobFont != null) {
            n2 += n;
            int n4 = 0;
            int n5 = 0;
            while (n < n2) {
                Gob gob = this.getCharGob(cArray[n]);
                if (gob != null) {
                    n4 = n5 + (gob.offsetX + gob.width);
                    n5 += gob.collisionWidth;
                } else {
                    n5 += this.gobFont[2].collisionHeight;
                }
                ++n;
            }
            if (n3 < 0) {
                n4 -= n3;
            }
            return n4;
        }
        return this.getWidth(cArray, n, n2);
    }

    public void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        this.fillCharBuffer(string, n, n2);
        this.drawText(graphics, reusableCharBuffer, 0, n2, n3, n4, n5);
    }

    public void drawText(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = string.length();
        this.fillCharBuffer(string, 0, n4);
        this.drawText(graphics, reusableCharBuffer, 0, n4, n, n2, n3);
    }

    public void drawText(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if ((n5 & 0x40) != 0) {
            n4 -= this.getBaselinePosition();
        } else if ((n5 & 0x20) != 0) {
            n4 -= this.getHeight();
        }
        if ((n5 & 9) != 0) {
            n6 = this.getStartXOffset(cArray, n);
            int n7 = this.isMonospaced() ? this.getWidth(cArray, n, n2) : this.getPhysicalWidth(cArray, n, n2, n6);
            n3 -= n7 >> (n5 & 1);
        }
        if (this.gobFont != null) {
            n2 += n;
            while (n < n2) {
                Gob gob = this.getCharGob(cArray[n]);
                if (gob != null) {
                    gob.paint(graphics, n3, n4, 0);
                    n3 += gob.collisionWidth;
                } else {
                    n3 += this.gobFont[2].collisionHeight;
                }
                ++n;
            }
        } else if (n2 != 0 && this.systemFont != null) {
            if (graphics.getFont() != this.systemFont) {
                graphics.setFont(this.systemFont);
            }
            n6 = 0;
            if (this.systemFontColorEnabled && (n6 = graphics.getColor() & 0xFFFFFF) != this.systemFontColor) {
                graphics.setColor(this.systemFontColor);
            }
            graphics.drawChars(cArray, n, n2, n3, n4, 20);
            if (this.systemFontColorEnabled && n6 != this.systemFontColor) {
                graphics.setColor(n6);
            }
        }
    }

    private void ensureCharBufferCapacity(int n) {
        if (reusableCharBuffer == null || reusableCharBuffer.length < n) {
            reusableCharBuffer = new char[n];
        }
    }

    private void fillCharBuffer(String string, int n, int n2) {
        this.ensureCharBufferCapacity(n2);
        string.getChars(n, n + n2, reusableCharBuffer, 0);
    }
}

