/*
 * Decompiled with CFR 0.152.
 */
package jg.io.resource;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import jg.JgCanvas;
import jg.Resources;

public class ResourcePack {
    protected static int lastActiveResourcePackId = -1;
    protected boolean backingByteArrayLoadingRequired;
    protected boolean resourcePackPreloaded;
    protected int[] resourcePackSizesById;
    protected byte[] resourcePackBackingByteArray;
    protected byte[] resourcePackMetaData;
    private static StringBuffer reusedPackFilename = new StringBuffer(8);

    public Image getImage(int n, byte[] byArray) {
        this.activatePack(n);
        byte[] byArray2 = this.getBackingByteArray(n &= 0x3FF);
        int n2 = this.getResourceOffsetInBackingArray(n);
        Resources.swapPalettes(byArray2, n2, byArray);
        Image image = Resources.getImage(byArray2, n2, this.resourcePackSizesById[n]);
        Resources.swapPalettes(byArray2, n2, byArray);
        return image;
    }

    public byte[] getBytes(int n) {
        this.activatePack(n);
        Resources.runGarbageCollection();
        byte[] byArray = new byte[this.resourcePackSizesById[n &= 0x3FF]];
        if (this.resourcePackPreloaded) {
            System.arraycopy(this.resourcePackBackingByteArray, this.getResourceOffsetInBackingArray(n), byArray, 0, byArray.length);
        } else {
            this.readFileBytes(n, byArray);
        }
        return byArray;
    }

    protected void readFileBytes(int n, byte[] byArray) {
        String string = this.getResourcePackPartName(lastActiveResourcePackId, n);
        DataInputStream dataInputStream = this.getStreamFromFile(string);
        try {
            try {
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        catch (Throwable throwable) {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (Exception exception) {}
    }

    public DataInputStream getStream(int n) {
        this.activatePack(n);
        byte[] byArray = this.getBackingByteArray(n &= 0x3FF);
        return Resources.getSafeDataInputStream(byArray, this.getResourceOffsetInBackingArray(n), this.resourcePackSizesById[n]);
    }

    public int getResourceOffsetInBackingArray(int n) {
        this.activatePack(n);
        n &= 0x3FF;
        int n2 = 0;
        if (this.resourcePackPreloaded) {
            while (--n >= 0) {
                n2 += this.resourcePackSizesById[n];
            }
        }
        return n2;
    }

    public byte getType(int n) {
        this.activatePack(n);
        return this.resourcePackMetaData[n &= 0x3FF];
    }

    public byte[] getBackingByteArray(int n) {
        this.activatePack(n);
        return this.resourcePackPreloaded ? this.resourcePackBackingByteArray : this.getBytes(n);
    }

    public void activatePack(int n) {
        int n2 = n >> 10;
        if (n2 == 0 || n2 == lastActiveResourcePackId) {
            return;
        }
        this.freeActivePack();
        if (n2 > 0) {
            try {
                Resources.runGarbageCollection();
                DataInputStream dataInputStream = this.getResourcePackStream(n2);
                if (dataInputStream != null) {
                    this.activatePackStream(dataInputStream);
                    dataInputStream.close();
                }
                dataInputStream = null;
                Resources.runGarbageCollection();
                Resources.runGarbageCollection();
            }
            catch (Exception exception) {}
            lastActiveResourcePackId = n2;
        }
    }

    void extensionFree() {
    }

    public boolean activatePackStream(DataInputStream dataInputStream) {
        boolean bl;
        this.freeActivePack();
        lastActiveResourcePackId = 0;
        try {
            int n = 0;
            n = dataInputStream.read();
            int n2 = 1 + (n & 1) << 1;
            int n3 = dataInputStream.readChar();
            byte[] byArray = new byte[n2 * n3];
            dataInputStream.readFully(byArray);
            this.resourcePackSizesById = new int[n3];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                int n7 = n2 - 1;
                while (n7 >= 0) {
                    int n8 = n6;
                    this.resourcePackSizesById[n8] = this.resourcePackSizesById[n8] | (0xFF & byArray[n5++]) << (n7 << 3);
                    --n7;
                }
                n4 += this.resourcePackSizesById[n6];
                ++n6;
            }
            this.resourcePackMetaData = new byte[n3];
            dataInputStream.readFully(this.resourcePackMetaData);
            if (this.backingByteArrayLoadingRequired) {
                this.resourcePackBackingByteArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(this.resourcePackBackingByteArray);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.freeActivePack();
            bl = false;
        }
        return bl;
    }

    public void freeActivePack() {
        this.resourcePackSizesById = null;
        this.resourcePackMetaData = null;
        this.resourcePackBackingByteArray = null;
        lastActiveResourcePackId = -1;
        this.extensionFree();
        Resources.runGarbageCollection();
    }

    public DataInputStream getStreamFromFile(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            // empty if block
        }
        return inputStream != null ? new DataInputStream(inputStream) : null;
    }

    public DataInputStream getResourcePackStream(int n) {
        this.resourcePackPreloaded = true;
        this.backingByteArrayLoadingRequired = true;
        return this.getStreamFromFile(this.getResourcePackPartName(n, -1));
    }

    protected String getResourcePackPartName(int n, int n2) {
        return this.getResourcePackPartName(n, n2, null);
    }

    protected String getResourcePackPartName(int n, int n2, String string) {
        reusedPackFilename.setLength(0);
        reusedPackFilename.append('/');
        reusedPackFilename.append("RP");
        JgCanvas.appendInt(reusedPackFilename, n);
        if (n2 != -1) {
            reusedPackFilename.append("part");
            JgCanvas.appendInt(reusedPackFilename, n2);
        }
        reusedPackFilename.append('.');
        if (string == null) {
            string = "rp";
        }
        reusedPackFilename.append(string);
        return reusedPackFilename.toString();
    }
}

