/*
 * Decompiled with CFR 0.152.
 */
package jg.input;

import java.util.Vector;
import jg.JgCanvas;
import jg.input.PointerInputKeyRegion;

public class PointerInputKeyManager {
    private static int POINTER_INPUT_MAX_CONCURRENT_INPUT = 1;
    static int translateX;
    static int translateY;
    private static boolean multitouchEnabled;
    private static Vector keyRegions;
    private static final Object keyRegionMonitor;
    private static KeyState[] keyStates;
    private static int keyStatesCount;
    private static int[] keyStatesIndex;

    static {
        keyRegionMonitor = new Object();
    }

    private PointerInputKeyManager() {
    }

    public static void updateMetrics() {
        PointerInputKeyManager.setTranslation(JgCanvas.jgCanvas.canvasGetXLocation(), JgCanvas.jgCanvas.canvasGetYLocation());
    }

    public static void setTranslation(int n, int n2) {
        translateX = n;
        translateY = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addKeyRegion(PointerInputKeyRegion pointerInputKeyRegion) {
        boolean bl = false;
        if (pointerInputKeyRegion != null) {
            Object object = keyRegionMonitor;
            synchronized (object) {
                if (keyRegions == null) {
                    keyRegions = new Vector();
                }
                if (keyRegions.indexOf(pointerInputKeyRegion) < 0) {
                    keyRegions.addElement(pointerInputKeyRegion);
                    pointerInputKeyRegion.pointerOverDeferred = new boolean[POINTER_INPUT_MAX_CONCURRENT_INPUT];
                    if (pointerInputKeyRegion.type == 1) {
                        pointerInputKeyRegion.buttonPressed = new boolean[POINTER_INPUT_MAX_CONCURRENT_INPUT];
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeKeyRegions(byte by) {
        int n = 0;
        if (by != 0 && by < 64 && by >= -64 || by == 0 || by == 127) {
            Object object = keyRegionMonitor;
            synchronized (object) {
                if (keyRegions != null) {
                    if (by == 0) {
                        keyRegions = null;
                    } else {
                        int n2 = keyRegions.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            PointerInputKeyRegion pointerInputKeyRegion = (PointerInputKeyRegion)keyRegions.elementAt(n3);
                            if (pointerInputKeyRegion.keyCode == by) {
                                keyRegions.removeElementAt(n3);
                                pointerInputKeyRegion.pointerOverDeferred = null;
                                pointerInputKeyRegion.buttonPressed = null;
                                ++n;
                                --n3;
                                --n2;
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        return n;
    }

    public static void jgInternalInitialize() {
        if (keyStates == null) {
            keyStates = new KeyState[128];
            keyStatesIndex = new int[128];
            int n = 0;
            while (n < 128) {
                PointerInputKeyManager.keyStatesIndex[n] = -1;
                ++n;
            }
        }
        PointerInputKeyManager.updateMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jgInternalManageEvent(int n, int n2, int n3, boolean bl, boolean bl2, PointerInputKeyRegion[] pointerInputKeyRegionArray) {
        if (keyRegions != null || pointerInputKeyRegionArray != null) {
            Object object;
            n2 -= translateX;
            n3 -= translateY;
            int n4 = 0;
            while (n4 < keyStatesCount) {
                object = keyStates[n4];
                ((KeyState)object).pressed = false;
                ((KeyState)object).released = false;
                ++n4;
            }
            n4 = 0;
            object = keyRegionMonitor;
            synchronized (object) {
                int n5;
                int n6;
                if (keyRegions != null) {
                    n4 = 1;
                    n6 = keyRegions.size();
                    n5 = 0;
                    while (n5 < n6) {
                        PointerInputKeyRegion pointerInputKeyRegion = (PointerInputKeyRegion)keyRegions.elementAt(n5);
                        pointerInputKeyRegion.pointerOverDeferred[n] = false;
                        if (!bl && pointerInputKeyRegion.type == 1) {
                            pointerInputKeyRegion.buttonPressed[n] = false;
                        }
                        PointerInputKeyManager.testKeyRegion(n, n2, n3, bl, bl2, pointerInputKeyRegion, true);
                        if (pointerInputKeyRegion.keyCode == 127 && pointerInputKeyRegion.keyStateInUse) {
                            if (bl) {
                                PointerInputKeyManager.handleKeyPressedLogic(n, pointerInputKeyRegion.keyState);
                            } else {
                                PointerInputKeyManager.handleKeyReleasedLogic(n, pointerInputKeyRegion.keyState);
                            }
                            PointerInputKeyManager.anonymousKeyManaged(pointerInputKeyRegion);
                        }
                        ++n5;
                    }
                }
                if (pointerInputKeyRegionArray != null) {
                    n4 = 1;
                    n6 = pointerInputKeyRegionArray.length;
                    n5 = n2 + translateX;
                    int n7 = n3 + translateY;
                    int n8 = 0;
                    while (n8 < n6) {
                        PointerInputKeyManager.testKeyRegion(n, n5, n7, bl, bl2, pointerInputKeyRegionArray[n8], false);
                        ++n8;
                    }
                }
            }
            if (bl) {
                if (n4 != 0) {
                    PointerInputKeyManager.handleKeyPressedLogic(n);
                }
            } else {
                PointerInputKeyManager.handleKeyReleasedLogic(n);
            }
            int n9 = 0;
            while (n9 < keyStatesCount) {
                KeyState keyState = keyStates[n9];
                if (keyState.pressed) {
                    JgCanvas.jgCanvas.keySetPressed(keyState.keycode);
                } else if (keyState.released) {
                    JgCanvas.jgCanvas.keySetReleased(keyState.keycode);
                    PointerInputKeyManager.removeKeyState(keyState.keycode);
                    --n9;
                }
                ++n9;
            }
        }
    }

    private static void anonymousKeyManaged(PointerInputKeyRegion pointerInputKeyRegion) {
        if (pointerInputKeyRegion.keyState.pressed) {
            if (pointerInputKeyRegion.deferredTypedCount < 127) {
                pointerInputKeyRegion.deferredTypedCount = (byte)(pointerInputKeyRegion.deferredTypedCount + 1);
            }
            pointerInputKeyRegion.deferredPressed = true;
            pointerInputKeyRegion.deferredReleased = false;
        } else if (pointerInputKeyRegion.keyState.released) {
            pointerInputKeyRegion.keyStateInUse = false;
            if (pointerInputKeyRegion.deferredPressed) {
                pointerInputKeyRegion.deferredReleased = true;
                pointerInputKeyRegion.deferredPressed = false;
            }
        }
    }

    private static void handleKeyPressedLogic(int n) {
        int n2 = 0;
        while (n2 < keyStatesCount) {
            PointerInputKeyManager.handleKeyPressedLogic(n, keyStates[n2]);
            ++n2;
        }
    }

    private static void handleKeyPressedLogic(int n, KeyState keyState) {
        if (multitouchEnabled) {
            if (!keyState.pressed) {
                keyState.wasPressedId[n] = false;
                if (keyState.wasPressed) {
                    keyState.released = true;
                    int n2 = 0;
                    while (n2 < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
                        if (n2 != n && keyState.wasPressedId[n2]) {
                            keyState.released = false;
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                keyState.wasPressedId[n] = true;
                keyState.pressed = !keyState.wasPressed;
            }
        } else {
            keyState.released = keyState.wasPressed && !keyState.pressed;
            keyState.pressed = keyState.pressed & !keyState.wasPressed;
        }
        keyState.wasPressed |= keyState.pressed;
    }

    private static void handleKeyReleasedLogic(int n) {
        int n2 = 0;
        while (n2 < keyStatesCount) {
            PointerInputKeyManager.handleKeyReleasedLogic(n, keyStates[n2]);
            ++n2;
        }
    }

    private static void handleKeyReleasedLogic(int n, KeyState keyState) {
        if (keyState.wasPressed) {
            keyState.released = true;
            if (multitouchEnabled) {
                keyState.wasPressedId[n] = false;
                int n2 = 0;
                while (n2 < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
                    if (n2 != n && keyState.wasPressedId[n2]) {
                        keyState.released = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (keyState.released) {
                keyState.pressed = false;
                keyState.wasPressed = false;
            }
        } else {
            keyState.released = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jgInternalUpdateStates() {
        Object object = keyRegionMonitor;
        synchronized (object) {
            if (keyRegions != null) {
                int n = keyRegions.size();
                int n2 = 0;
                while (n2 < n) {
                    PointerInputKeyRegion pointerInputKeyRegion = (PointerInputKeyRegion)keyRegions.elementAt(n2);
                    pointerInputKeyRegion.pointerOver = multitouchEnabled ? pointerInputKeyRegion.wasOverOnRelease || PointerInputKeyManager.checkAnyTrue(pointerInputKeyRegion.pointerOverDeferred, null, -1) : pointerInputKeyRegion.wasOverOnRelease || pointerInputKeyRegion.pointerOverDeferred[0];
                    pointerInputKeyRegion.wasOverOnRelease = false;
                    if (pointerInputKeyRegion.keyCode == 127) {
                        pointerInputKeyRegion.updateStates();
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jgInternalResetStates() {
        Object object = keyRegionMonitor;
        synchronized (object) {
            int n;
            int n2;
            if (keyStatesCount > 0) {
                n2 = keyStatesIndex.length;
                n = 0;
                while (n < n2) {
                    int n3 = keyStatesIndex[n];
                    if (n3 >= 0) {
                        PointerInputKeyManager.keyStatesIndex[n] = -1;
                    }
                    ++n;
                }
                n = 0;
                while (n < keyStatesCount) {
                    KeyState keyState = keyStates[n];
                    if (keyState.wasPressed) {
                        JgCanvas.jgCanvas.keySetReleased(keyState.keycode);
                    }
                    ++n;
                }
                keyStatesCount = 0;
            }
            if (keyRegions != null) {
                n2 = keyRegions.size();
                n = 0;
                while (n < n2) {
                    PointerInputKeyRegion pointerInputKeyRegion = (PointerInputKeyRegion)keyRegions.elementAt(n);
                    pointerInputKeyRegion.pointerOver = false;
                    pointerInputKeyRegion.wasOverOnRelease = false;
                    int n4 = 0;
                    while (n4 < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
                        pointerInputKeyRegion.pointerOverDeferred[n4] = false;
                        if (pointerInputKeyRegion.type == 1) {
                            pointerInputKeyRegion.buttonPressed[n4] = false;
                        }
                        ++n4;
                    }
                    if (pointerInputKeyRegion.keyCode == 127) {
                        pointerInputKeyRegion.deferredReleased = pointerInputKeyRegion.deferredPressed;
                        pointerInputKeyRegion.deferredPressed = false;
                        pointerInputKeyRegion.deferredTypedCount = 0;
                        pointerInputKeyRegion.typedCount = 0;
                        pointerInputKeyRegion.pressed = false;
                        pointerInputKeyRegion.released = false;
                    }
                    ++n;
                }
            }
        }
    }

    private static KeyState getKeyState(PointerInputKeyRegion pointerInputKeyRegion, boolean bl) {
        KeyState keyState = null;
        if (pointerInputKeyRegion != null) {
            byte by = pointerInputKeyRegion.keyCode;
            int n = PointerInputKeyManager.getKeyIndexFromCode(by);
            if (n >= 0 && n < keyStatesIndex.length) {
                int n2 = keyStatesIndex[n];
                if (n2 >= 0) {
                    keyState = keyStates[n2];
                } else if (bl) {
                    keyState = keyStates[keyStatesCount];
                    if (keyState == null) {
                        PointerInputKeyManager.keyStates[PointerInputKeyManager.keyStatesCount] = keyState = new KeyState();
                    } else {
                        keyState.released = false;
                        keyState.wasPressed = false;
                    }
                    if (multitouchEnabled) {
                        PointerInputKeyManager.initializeWasPressedId(keyState);
                    }
                    keyState.keycode = by;
                    PointerInputKeyManager.keyStatesIndex[n] = keyStatesCount++;
                }
            } else if (by == 127) {
                if (pointerInputKeyRegion.keyStateInUse) {
                    keyState = pointerInputKeyRegion.keyState;
                } else if (bl) {
                    keyState = pointerInputKeyRegion.keyState;
                    if (keyState == null) {
                        pointerInputKeyRegion.keyState = keyState = new KeyState();
                    } else {
                        keyState.released = false;
                        keyState.wasPressed = false;
                    }
                    if (multitouchEnabled) {
                        PointerInputKeyManager.initializeWasPressedId(keyState);
                    }
                    keyState.keycode = by;
                    pointerInputKeyRegion.keyStateInUse = true;
                }
            }
        }
        return keyState;
    }

    private static void initializeWasPressedId(KeyState keyState) {
        if (keyState.wasPressedId == null) {
            keyState.wasPressedId = new boolean[POINTER_INPUT_MAX_CONCURRENT_INPUT];
        } else {
            int n = 1;
            while (n < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
                keyState.wasPressedId[n] = false;
                ++n;
            }
        }
        keyState.wasPressedId[0] = keyState.wasPressed;
    }

    private static void removeKeyState(byte by) {
        int n;
        int n2 = PointerInputKeyManager.getKeyIndexFromCode(by);
        if (n2 >= 0 && n2 < keyStatesIndex.length && (n = keyStatesIndex[n2]) >= 0) {
            if (n < --keyStatesCount) {
                KeyState keyState;
                KeyState keyState2 = keyStates[n];
                PointerInputKeyManager.keyStates[n] = keyState = keyStates[keyStatesCount];
                PointerInputKeyManager.keyStatesIndex[PointerInputKeyManager.getKeyIndexFromCode((byte)keyState.keycode)] = n;
                PointerInputKeyManager.keyStates[PointerInputKeyManager.keyStatesCount] = keyState2;
            }
            PointerInputKeyManager.keyStatesIndex[n2] = -1;
        }
    }

    private static int getKeyIndexFromCode(byte n) {
        int n2 = n;
        if (n == 0 || n >= 64 || n < -64) {
            n2 = -1;
        } else if (n < 0) {
            n2 = 63 - n;
        }
        return n2;
    }

    private static void testKeyRegion(int n, int n2, int n3, boolean bl, boolean bl2, PointerInputKeyRegion pointerInputKeyRegion, boolean bl3) {
        if ((bl || bl3) && pointerInputKeyRegion.enabled) {
            KeyState keyState = null;
            if (pointerInputKeyRegion.contains(n2, n3)) {
                if (bl3) {
                    if (pointerInputKeyRegion.type != 1 || pointerInputKeyRegion.buttonPressed[n] || bl && bl2) {
                        pointerInputKeyRegion.pointerOverDeferred[n] = true;
                    }
                    if (!bl) {
                        if (keyState == null) {
                            keyState = PointerInputKeyManager.getKeyState(pointerInputKeyRegion, false);
                        }
                        if (keyState != null && keyState.wasPressed) {
                            pointerInputKeyRegion.wasOverOnRelease = true;
                            pointerInputKeyRegion.pointerOverDeferred[n] = false;
                        }
                    }
                }
                if (pointerInputKeyRegion.type == 1) {
                    if (bl && bl2) {
                        pointerInputKeyRegion.buttonPressed[n] = true;
                    }
                } else if (bl) {
                    if (pointerInputKeyRegion.type == 0) {
                        if (keyState == null) {
                            keyState = PointerInputKeyManager.getKeyState(pointerInputKeyRegion, true);
                        }
                        if (keyState != null) {
                            keyState.pressed = true;
                        }
                    } else {
                        PointerInputKeyManager.manageSwipeInput(n, n2, n3, pointerInputKeyRegion, pointerInputKeyRegion.keyCode);
                    }
                }
            }
            if (pointerInputKeyRegion.type == 1) {
                if (bl) {
                    if (pointerInputKeyRegion.buttonPressed[n]) {
                        if (keyState == null) {
                            keyState = PointerInputKeyManager.getKeyState(pointerInputKeyRegion, true);
                        }
                        if (keyState != null) {
                            keyState.pressed = true;
                        }
                    }
                } else {
                    if (multitouchEnabled && pointerInputKeyRegion.buttonPressed[n] && (pointerInputKeyRegion.pointerOverDeferred[n] || pointerInputKeyRegion.wasOverOnRelease) && !PointerInputKeyManager.checkAnyTrue(pointerInputKeyRegion.pointerOverDeferred, pointerInputKeyRegion.buttonPressed, n)) {
                        if (keyState == null) {
                            keyState = PointerInputKeyManager.getKeyState(pointerInputKeyRegion, true);
                        }
                        if (keyState != null) {
                            int n4 = 0;
                            while (n4 < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
                                if (n4 != n) {
                                    keyState.wasPressedId[n4] = false;
                                }
                                ++n4;
                            }
                        }
                        pointerInputKeyRegion.wasOverOnRelease = true;
                        pointerInputKeyRegion.pointerOverDeferred[n] = false;
                    }
                    pointerInputKeyRegion.buttonPressed[n] = false;
                }
            } else if (pointerInputKeyRegion.type == 2 && bl2 && !bl) {
                pointerInputKeyRegion.lastSwipePosition = -1;
            }
        }
    }

    private static boolean checkAnyTrue(boolean[] blArray, boolean[] blArray2, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < POINTER_INPUT_MAX_CONCURRENT_INPUT) {
            if (n2 != n && blArray[n2] && (blArray2 == null || blArray2[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private static void manageSwipeInput(int n, int n2, int n3, PointerInputKeyRegion pointerInputKeyRegion, byte by) {
        int n4 = pointerInputKeyRegion.direction == 0 || pointerInputKeyRegion.direction == 1 ? PointerInputKeyManager.updateSwipeData(n3, pointerInputKeyRegion.height, pointerInputKeyRegion, (byte)0) : PointerInputKeyManager.updateSwipeData(n2, pointerInputKeyRegion.width, pointerInputKeyRegion, (byte)2);
        int n5 = 0;
        while (n5 < n4) {
            JgCanvas.jgCanvas.keySetPressed(by);
            JgCanvas.jgCanvas.keySetReleased(by);
            ++n5;
        }
    }

    private static int updateSwipeData(int n, int n2, PointerInputKeyRegion pointerInputKeyRegion, byte by) {
        int n3 = 0;
        long l = JgCanvas.currentTimeMillis();
        if (pointerInputKeyRegion.other > 0 && pointerInputKeyRegion.lastSwipePosition >= 0 && l - pointerInputKeyRegion.lastSwipeTime <= 50L) {
            int n4 = pointerInputKeyRegion.direction == by ? pointerInputKeyRegion.lastSwipePosition - n : n - pointerInputKeyRegion.lastSwipePosition;
            if (n4 > 0) {
                int n5 = Math.abs(pointerInputKeyRegion.lastSwipePercentRemain) * n2 / pointerInputKeyRegion.other;
                int n6 = (n4 += n5 / 1024 + (n5 >= 512 ? 1 : 0)) * pointerInputKeyRegion.other;
                n3 = n6 / n2;
                int n7 = n6 % n2 * 1024 / n2;
                pointerInputKeyRegion.lastSwipePercentRemain = pointerInputKeyRegion.direction == by ? (short)(-n7) : (short)n7;
            } else if (n4 < 0) {
                pointerInputKeyRegion.lastSwipePercentRemain = 0;
            }
        } else {
            pointerInputKeyRegion.lastSwipePercentRemain = 0;
        }
        pointerInputKeyRegion.lastSwipeTime = l;
        pointerInputKeyRegion.lastSwipePosition = n;
        return n3;
    }

    static class KeyState {
        public byte keycode;
        public boolean pressed;
        public boolean released;
        public boolean wasPressed;
        public boolean[] wasPressedId;

        KeyState() {
        }
    }
}

