/*
 * Decompiled with CFR 0.152.
 */
package jg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import jg.JgCanvas;
import jg.MediaManager;
import jg.Resources;

public class MediaManagerImpl
implements Runnable,
MediaManager {
    private JgCanvas canvas;
    private int mediaMaxNumber;
    private volatile boolean shutdown;
    private int channelPendingId;
    private int channelStartedId;
    private int[] mediaLoop;
    private int[] mediaPriority;
    private int volumeLevel = 100;
    private int videoWidth = -1;
    private int videoHeight = -1;
    private Player[] players;
    private Player playerStarted;

    public synchronized void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.freeMedia(-1);
        }
    }

    public boolean isEnabled() {
        this.canvas.updateInternalUserSettings(false);
        return !this.shutdown && this.canvas.audioEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this.stopChannel(-1);
            this.canvas.audioEnabled = bl;
            this.canvas.updateInternalUserSettings(true);
        }
    }

    String getMimeType(byte by) {
        return by == 1 ? "audio/x-wav" : (by == 2 ? "audio/mpeg" : (by == 3 ? "audio/amr" : (by == 8 ? "audio/x-tone-seq" : (by == 10 ? "application/x-smaf" : "audio/midi"))));
    }

    private static Player createPlayer(byte[] byArray, int n, int n2, String string) throws MediaException, IOException {
        return Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)string);
    }

    public synchronized void run() {
        int n;
        if (this.isEnabled() && (n = this.channelPendingId) >= 0) {
            if (this.channelStartedId >= 0) {
                this.stopChannel(0);
            }
            this.channelPendingId = -1;
            Player player = this.players[n];
            try {
                player.prefetch();
            }
            catch (Throwable throwable) {
                return;
            }
            try {
                player.setMediaTime(0L);
            }
            catch (Throwable throwable) {}
            try {
                player.setLoopCount(this.mediaLoop[n]);
            }
            catch (Throwable throwable) {}
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(this.volumeLevel);
            }
            try {
                player.start();
            }
            catch (Throwable throwable) {
                return;
            }
            this.channelStartedId = n;
            this.playerStarted = player;
        }
    }

    public synchronized void allocateMedia(int n, int n2, int n3, int n4) {
        if (!this.shutdown) {
            if (this.players[n] != null) {
                this.freeMedia(n);
            }
            this.mediaLoop[n] = n3;
            this.mediaPriority[n] = n4;
            try {
                byte[] byArray = Resources.getBytes(n2);
                int n5 = 0;
                int n6 = byArray.length;
                this.players[n] = MediaManagerImpl.createPlayer(byArray, n5, n6, this.getMimeType(Resources.getType(n2)));
                this.players[n].realize();
                this.players[n].prefetch();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void freeMedia(int n) {
        if (n == -1) {
            n = 0;
            while (n < this.mediaMaxNumber) {
                this.freeMedia(n);
                ++n;
            }
            return;
        }
        if (this.channelStartedId == n || this.channelPendingId == n) {
            this.stopChannel(0);
        }
        if (this.players[n] != null) {
            this.players[n].close();
            this.players[n] = null;
        }
    }

    public void startChannel(int n, int n2) {
        if (this.isEnabled() && this.players[n2] != null && (this.channelPendingId < 0 || this.mediaPriority[this.channelPendingId] <= this.mediaPriority[n2])) {
            int n3 = this.channelStartedId;
            Player player = this.playerStarted;
            if (player != null && player.getState() == 400 && this.mediaPriority[n3] > this.mediaPriority[n2]) {
                return;
            }
            this.channelPendingId = n2;
        }
    }

    public synchronized void stopChannel(int n) {
        if (this.playerStarted != null) {
            try {
                if (this.playerStarted.getState() == 400) {
                    this.playerStarted.stop();
                }
            }
            catch (Throwable throwable) {}
            this.playerStarted = null;
        }
        this.channelPendingId = -1;
        this.channelStartedId = -1;
    }

    public synchronized void setChannelVolume(int n, int n2) {
    }

    public MediaManagerImpl(JgCanvas jgCanvas, int n) {
        this.canvas = jgCanvas;
        this.channelPendingId = -1;
        this.channelStartedId = -1;
        this.mediaMaxNumber = n;
        this.mediaLoop = new int[n];
        this.mediaPriority = new int[n];
        this.players = new Player[n];
        jgCanvas.jgMediaManager = this;
    }
}

