/*
 * Decompiled with CFR 0.152.
 */
package jg;

import java.io.DataInputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import jg.MediaManagerImpl;
import jg.Resources;
import jg.input.PointerInputEventManager;
import jg.input.PointerInputKeyManager;
import jg.input.PointerInputKeyRegion;

public abstract class JgCanvas
extends GameCanvas
implements Runnable {
    public static JgCanvas jgCanvas;
    private long canvasCreationTime;
    static Thread canvasThread;
    private static volatile byte canvasRunnableState;
    private static volatile boolean canvasShowNotifyCalled;
    private long currentTime;
    protected MIDlet midlet;
    MediaManagerImpl jgMediaManager;
    private Vector httpTransactions;
    private volatile boolean httpTransactionRunnableScheduled;
    private volatile boolean networkTransferCompleteScheduled;
    private volatile int networkTransferCompleteStatus;
    private volatile byte[] networkTransferCompleteData;
    private Object networkTransferCompleteSync;
    public static byte[] byteArraySourceData;
    public static byte[] byteArrayTargetData;
    public static int byteArraySourceOffset;
    public static int byteArrayTargetOffset;
    private boolean mediaSettingsInitialized;
    boolean audioEnabled;
    private boolean vibrationEnabled;
    private boolean flashBacklightEnabled;
    private boolean sizeChanged;
    private static int left;
    private static int bottom;
    private static int right;
    private static int top;
    private DataInputStream levelDis;
    private int levelBitBuffer;
    private int levelBitsInBuffer;
    private Object jgKeyMonitor = new Object();
    private static final int[] KEY_MAP;
    private byte[] keyStates = new byte[128];
    private byte[] keyDeferredStates = new byte[128];
    private int typedStates = 1;
    private int pressedStates = 1;
    private int releasedStates = 1;
    private boolean keyDeferredIsAnyTyped;
    private boolean keyIsAnyTyped;
    private static int[] ignoredKeyCodes;
    private static byte nextAvailableKeyCode;
    private final Object jgPointerKeyRegionMonitor = new Object();
    private static int POINTER_INPUT_MAX_CONCURRENT_INPUT;
    private PointerInputKeyRegion[] onScreenKeyRegions;
    private int elapsedMillisSinceLastTick = 10;
    private int minMillisPerTick = 10;
    private int maxMillisPerTick = 100;
    private boolean resetTime;
    private int returnedMillisVariance;
    private int userMinMillisPerTick = this.minMillisPerTick;
    private int userMaxMillisPerTick = this.maxMillisPerTick;
    private boolean timerDebuggerReset;
    private boolean timerDebuggerEnabled;
    private int[] timerDebuggerMillis;
    private int jgGameWidth;
    private int jgGameHeight;
    private int jgGameXOffset;
    private int jgGameYOffset;
    private boolean canvasActiveSizeChanged;
    private volatile int lastSystemEventResumeOrInterruptReceived = -1;
    private volatile boolean gameFullRepaint;
    private volatile boolean deferredFullRepaint;
    private volatile long lastSystemEventResumeOrInterruptReceivedMillis;
    private int lastSystemEventResumeOrInterruptPerformed = 2;

    static {
        KEY_MAP = new int[64];
        nextAvailableKeyCode = (byte)63;
        JgCanvas.KEY_MAP[9] = -10;
        JgCanvas.KEY_MAP[15] = -8;
        POINTER_INPUT_MAX_CONCURRENT_INPUT = 1;
    }

    public abstract void paintGameView(Graphics var1);

    public abstract void tickGameLogic();

    private Object getNetworkTransferCompleteSyncObject() {
        if (this.networkTransferCompleteSync == null) {
            this.networkTransferCompleteSync = new Object();
        }
        return this.networkTransferCompleteSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callNetworkTransferComplete() {
        if (!this.networkTransferCompleteScheduled && !this.httpTransactionRunnableScheduled) {
            return;
        }
        Object object = this.getNetworkTransferCompleteSyncObject();
        synchronized (object) {
            if (this.networkTransferCompleteScheduled) {
                this.networkTransferCompleteScheduled = false;
                this.networkTransferComplete(this.networkTransferCompleteStatus, this.networkTransferCompleteData);
                this.networkTransferCompleteData = null;
            }
            if (this.httpTransactionRunnableScheduled && this.httpTransactions != null) {
                while (!this.httpTransactions.isEmpty()) {
                    Runnable runnable = (Runnable)this.httpTransactions.elementAt(0);
                    this.httpTransactions.removeElementAt(0);
                    runnable.run();
                }
                this.httpTransactionRunnableScheduled = false;
            }
        }
    }

    public static int randomNextIntStatic(Random random, int n) {
        n = random.nextInt() % n;
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public static void threadSleep(int n) {
        if (n > 0) {
            if (n >= 50) {
                Thread.yield();
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void byteArrayWriteBoolean(boolean bl) {
        JgCanvas.byteArrayWriteByte((byte)(bl ? 1 : 0));
    }

    public static void byteArrayWriteByte(byte by) {
        JgCanvas.byteArrayTargetData[JgCanvas.byteArrayTargetOffset] = by;
        ++byteArrayTargetOffset;
    }

    public static void byteArrayWriteShort(short s) {
        JgCanvas.byteArrayTargetData[JgCanvas.byteArrayTargetOffset] = (byte)(s >> 8);
        JgCanvas.byteArrayTargetData[++JgCanvas.byteArrayTargetOffset] = (byte)s;
        ++byteArrayTargetOffset;
    }

    public static void byteArrayWriteChar(char c) {
        JgCanvas.byteArrayWriteShort((short)c);
    }

    public static void byteArrayWriteInt(int n) {
        JgCanvas.byteArrayTargetData[JgCanvas.byteArrayTargetOffset] = (byte)(n >> 24);
        JgCanvas.byteArrayTargetData[++JgCanvas.byteArrayTargetOffset] = (byte)(n >> 16);
        JgCanvas.byteArrayTargetData[++JgCanvas.byteArrayTargetOffset] = (byte)(n >> 8);
        JgCanvas.byteArrayTargetData[++JgCanvas.byteArrayTargetOffset] = (byte)n;
        ++byteArrayTargetOffset;
    }

    public static void byteArrayWriteString(String string) {
        int n = string.length();
        JgCanvas.byteArrayWriteChar((char)n);
        int n2 = 0;
        while (n2 < n) {
            JgCanvas.byteArrayTargetData[JgCanvas.byteArrayTargetOffset] = (byte)string.charAt(n2);
            ++byteArrayTargetOffset;
            ++n2;
        }
    }

    public static boolean byteArrayReadBoolean() {
        return JgCanvas.byteArrayReadByte() != 0;
    }

    public static byte byteArrayReadByte() {
        return byteArraySourceData[byteArraySourceOffset++];
    }

    public static short byteArrayReadShort() {
        return (short)(byteArraySourceData[byteArraySourceOffset++] << 8 | byteArraySourceData[byteArraySourceOffset++] & 0xFF);
    }

    public static char byteArrayReadChar() {
        return (char)JgCanvas.byteArrayReadShort();
    }

    public static int byteArrayReadInt() {
        return byteArraySourceData[byteArraySourceOffset++] << 24 | (byteArraySourceData[byteArraySourceOffset++] & 0xFF) << 16 | (byteArraySourceData[byteArraySourceOffset++] & 0xFF) << 8 | byteArraySourceData[byteArraySourceOffset++] & 0xFF;
    }

    public static String byteArrayReadString() {
        int n = JgCanvas.byteArrayReadChar();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)(byteArraySourceData[byteArraySourceOffset + n2] & 0xFF);
            ++n2;
        }
        byteArraySourceOffset += n;
        return new String(cArray);
    }

    public static void combSort(int[] nArray, int n) {
        boolean bl;
        int n2 = n--;
        do {
            if (n2 != 1) {
                n2 = n2 * 197 >> 8;
            }
            bl = false;
            int n3 = n - n2;
            int n4 = n;
            while (n3 >= 0) {
                if (nArray[n3] > nArray[n4]) {
                    int n5 = nArray[n3];
                    nArray[n3] = nArray[n4];
                    nArray[n4] = n5;
                    bl = true;
                }
                --n3;
                --n4;
            }
        } while (bl || n2 > 1);
    }

    public static boolean rectsIntersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n < n5 + n7 && n5 < n + n3 && n2 < n6 + n8 && n6 < n2 + n4;
    }

    public static void appendInt(StringBuffer stringBuffer, int n) {
        JgCanvas.appendInt(stringBuffer, n, 0);
    }

    public static void appendInt(StringBuffer stringBuffer, int n, int n2) {
        JgCanvas.appendInt(stringBuffer, n, n2, stringBuffer.length());
    }

    public static void appendInt(StringBuffer stringBuffer, int n, int n2, int n3) {
        if (n < 0) {
            n = -n;
            stringBuffer.insert(n3, '-');
            ++n3;
        }
        if (n >= 65536) {
            stringBuffer.insert(n3, n);
        } else {
            int n4;
            do {
                n4 = n * 52429 >>> 19;
                int n5 = n - ((n4 << 3) + (n4 << 1));
                stringBuffer.insert(n3, (char)(48 + n5));
                --n2;
            } while ((n = n4) != 0);
            while (n2 > 0) {
                --n2;
                stringBuffer.insert(n3, '0');
            }
        }
    }

    public byte[] dataPersistenceLoadFromStore(int n) {
        byte[] byArray;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)String.valueOf(n), (boolean)false);
            if (recordStore != null) {
                int n2 = recordStore.getNumRecords();
                int n3 = 0;
                int n4 = 1;
                while (n4 <= n2) {
                    n3 += recordStore.getRecordSize(n4);
                    ++n4;
                }
                byArray = new byte[n3];
                n3 = 0;
                n4 = 1;
                while (n4 <= n2) {
                    n3 += recordStore.getRecord(n4, byArray, n3);
                    ++n4;
                }
            } else {
                byArray = null;
            }
        }
        catch (Throwable throwable) {
            byArray = null;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
        return byArray;
    }

    public boolean dataPersistenceSaveToStore(int n, byte[] byArray) {
        String string = String.valueOf(n);
        RecordStore recordStore = null;
        boolean bl = true;
        try {
            int n2;
            String[] stringArray = RecordStore.listRecordStores();
            if (stringArray != null) {
                n2 = 0;
                while (n2 < stringArray.length) {
                    if (string.equals(stringArray[n2])) {
                        RecordStore.deleteRecordStore((String)string);
                        break;
                    }
                    ++n2;
                }
            }
            if (byArray != null) {
                recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                n2 = (byArray.length + 4096 - 1) / 4096;
                int n3 = 0;
                int n4 = 1;
                while (n4 <= n2) {
                    int n5 = byArray.length - n3;
                    if (n5 > 4096) {
                        n5 = 4096;
                    }
                    recordStore.addRecord(byArray, n3, n5);
                    n3 += n5;
                    ++n4;
                }
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    synchronized void updateInternalUserSettings(boolean bl) {
        if (!this.mediaSettingsInitialized) {
            this.mediaSettingsInitialized = true;
            this.audioEnabled = true;
            this.vibrationEnabled = true;
            this.flashBacklightEnabled = true;
        }
    }

    private void processPreferredInitialOrientation() {
    }

    private void testCanvasOrientationChanged() {
    }

    public static void graphicsDrawRGBStatic(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    private static int getOutcode(int n, int n2) {
        int n3 = 0;
        if (n2 < top) {
            n3 |= 8;
        }
        if (n2 > bottom) {
            n3 |= 4;
        }
        if (n > right) {
            n3 |= 2;
        }
        if (n < left) {
            n3 |= 1;
        }
        return n3;
    }

    public static void graphicsDrawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        left = graphics.getClipX();
        top = graphics.getClipY();
        right = left + graphics.getClipWidth() - 1;
        bottom = top + graphics.getClipHeight() - 1;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = JgCanvas.getOutcode(n, n2);
        int n6 = JgCanvas.getOutcode(n3, n4);
        do {
            int n7;
            int n8;
            int n9;
            if ((n5 | n6) == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            if ((n5 & n6) != 0) {
                bl2 = true;
                continue;
            }
            int n10 = n9 = n5 != 0 ? n5 : n6;
            if ((n9 & 8) != 0) {
                n8 = n + (n3 - n) * (top - n2) / (n4 - n2);
                n7 = top;
            } else if ((n9 & 4) != 0) {
                n8 = n + (n3 - n) * (bottom - n2) / (n4 - n2);
                n7 = bottom;
            } else if ((n9 & 2) != 0) {
                n7 = n2 + (n4 - n2) * (right - n) / (n3 - n);
                n8 = right;
            } else {
                n7 = n2 + (n4 - n2) * (left - n) / (n3 - n);
                n8 = left;
            }
            if (n9 == n5) {
                n = n8;
                n2 = n7;
                n5 = JgCanvas.getOutcode(n8, n7);
                continue;
            }
            n3 = n8;
            n4 = n7;
            n6 = JgCanvas.getOutcode(n8, n7);
        } while (!bl2);
        if (bl) {
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    public Image imageCreateImage(int n, int n2, boolean bl, int n3) {
        if (bl) {
            throw new IllegalArgumentException();
        }
        return JgCanvas.imageCreateOpaqueMutableImage(n, n2, n3);
    }

    private static Image imageCreateOpaqueMutableImage(int n, int n2, int n3) {
        Image image = Image.createImage((int)n, (int)n2);
        if ((n3 &= 0xFFFFFF) != 0xFFFFFF) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(n3);
            graphics.fillRect(0, 0, n, n2);
        }
        return image;
    }

    public static void imageGetRGBStatic(Image image, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        image.getRGB(nArray, n, n2, n3, n4, n5, n6);
    }

    public final void levelLoadResource(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        this.levelDis = Resources.getStream(n);
        this.levelBitBuffer = 0;
        this.levelBitsInBuffer = 0;
        n = this.levelReadUInt(8);
        boolean bl2 = bl = n << 24 < 0;
        if (this.levelReadBoolean()) {
            n = this.levelReadUInt(10);
            this.levelCallbackGlobalEntity(n);
            if (bl) {
                this.validatePostCallBackChecksum();
            }
        }
        if (this.levelReadBoolean()) {
            n9 = this.levelReadUInt(12);
            n8 = this.levelReadBoolean() ? this.levelReadUInt(10) : -1;
            n7 = this.levelReadUInt(12);
            this.levelCallbackTilesetHeader(this.levelReadUInt(8), n9, this.levelReadSInt(17), this.levelReadUInt(10), this.levelReadUInt(10), n8, n7);
            char[] cArray = new char[n7 + 1];
            n6 = this.levelReadUInt(4);
            n = 0;
            while (n < n7) {
                n5 = this.levelReadUInt(n6) - 1;
                cArray[++n] = (char)(n5 % n9 + 1 | n5 / n9 << 12);
            }
            n = 0;
            while (n < n7) {
                this.levelCallbackTilesetEntity(n8, cArray[++n]);
            }
            if (bl) {
                this.validatePostCallBackChecksum();
            }
            n5 = this.levelReadUInt(12);
            n4 = this.levelReadUInt(12);
            this.levelCallbackTileGridHeader(n5, n4);
            n3 = 0;
            int n10 = n7;
            while (n10 > 0) {
                ++n3;
                n10 >>= 1;
            }
            n2 = 0;
            while (n2 < n4) {
                n = 0;
                while (n < n5) {
                    this.levelCallbackTileGridCell(n, n2, cArray[this.levelReadUInt(n3)]);
                    ++n;
                }
                ++n2;
            }
        }
        if (this.levelReadBoolean()) {
            n9 = this.levelReadUInt(16);
            n8 = this.levelReadUInt(10);
            n7 = this.levelReadUInt(10);
            int n11 = this.levelReadUInt(10);
            n6 = this.levelReadUInt(5);
            n5 = 0;
            while (n5 < n11) {
                n4 = this.levelReadUInt(10);
                n3 = this.levelReadUInt(12);
                this.levelCallbackLocalHeader(n4, n3);
                int[] nArray = new int[n3];
                n2 = 0;
                n = 0;
                while (n < n3) {
                    nArray[n] = n2 += this.levelReadUInt(n6);
                    ++n;
                }
                n = 0;
                while (n < n3) {
                    this.levelCallbackLocalEntity(n4, n8 + nArray[n] % n9, n7 + nArray[n] / n9);
                    ++n;
                }
                if (bl) {
                    this.validatePostCallBackChecksum();
                }
                ++n5;
            }
        }
        this.levelDis = null;
    }

    private void validatePostCallBackChecksum() {
        this.levelReadUInt(6);
    }

    public final int levelReadUInt(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 > 0) {
            if (this.levelBitsInBuffer == 0) {
                try {
                    this.levelBitBuffer = this.levelDis.read();
                }
                catch (Exception exception) {}
                this.levelBitsInBuffer = 8;
            }
            int n4 = Math.min(n3, this.levelBitsInBuffer);
            n2 |= (this.levelBitBuffer >> (this.levelBitsInBuffer -= n4) & ~(-1 << n4)) << (n3 -= n4);
        }
        return n2;
    }

    public final int levelReadSInt(int n) {
        return this.levelReadUInt(n) << 32 - n >> 32 - n;
    }

    public final boolean levelReadBoolean() {
        return this.levelReadUInt(1) == 1;
    }

    public void levelCallbackGlobalEntity(int n) {
    }

    public void levelCallbackTilesetHeader(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void levelCallbackTilesetEntity(int n, int n2) {
    }

    public void levelCallbackTileGridHeader(int n, int n2) {
    }

    public void levelCallbackTileGridCell(int n, int n2, int n3) {
    }

    public void levelCallbackLocalHeader(int n, int n2) {
    }

    public void levelCallbackLocalEntity(int n, int n2, int n3) {
    }

    static int findIndexIntoSorted(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 <= n) {
            int n4 = n3 + n >> 1;
            int n5 = nArray[n4];
            if (n5 < n2) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 > n2) {
                n = n4 - 1;
                continue;
            }
            return n4;
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyUpdateStates() {
        Object object = this.jgKeyMonitor;
        synchronized (object) {
            this.keyRemoveIncorrectSoftkeyEvents();
            byte[] byArray = this.keyStates;
            this.keyStates = this.keyDeferredStates;
            this.keyDeferredStates = byArray;
            int n = 0;
            while (n < 128) {
                this.keyDeferredStates[n] = (byte)(this.keyStates[n] & 0x40);
                if ((this.keyStates[n] & 0x3F) != 0) {
                    int n2 = n;
                    this.keyStates[n2] = (byte)(this.keyStates[n2] | 0x40);
                }
                ++n;
            }
            this.keyIsAnyTyped = this.keyDeferredIsAnyTyped;
            this.keyDeferredIsAnyTyped = false;
            this.typedStates = 1;
            this.pressedStates = 1;
            this.releasedStates = 1;
            this.keyReleaseKeysIfBugNoKeyRelease();
        }
        PointerInputKeyManager.jgInternalUpdateStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyResetStates() {
        Object object = this.jgKeyMonitor;
        synchronized (object) {
            int n = 1;
            while (n < 128) {
                this.keyDeferredStates[n] = (this.keyStates[n] & 0x40) != 0 ? -128 : 0;
                this.keyStates[n] = 0;
                ++n;
            }
            this.keyDeferredIsAnyTyped = false;
            this.keyIsAnyTyped = false;
            this.typedStates = 1;
            this.pressedStates = 1;
            this.releasedStates = 1;
        }
        PointerInputKeyManager.jgInternalResetStates();
    }

    public boolean keyIsPressed(byte by) {
        return this.isStateSet(by, (byte)64);
    }

    public boolean keyIsReleased(byte by) {
        return this.isStateSet(by, (byte)-128);
    }

    public boolean keyIsAnyTyped() {
        return this.keyIsAnyTyped;
    }

    public void keySetPressed(byte by) {
        int n = this.getKeyIndex(by);
        if (n > 0) {
            this.keyIndexManaged(n, true);
        }
    }

    public void keySetReleased(byte by) {
        int n = this.getKeyIndex(by);
        if (n > 0) {
            this.keyIndexManaged(n, false);
        }
    }

    private int getKeyIndex(int n) {
        if (n == 0 || n >= 64 || n < -64) {
            n = -1;
        } else if (n < 0) {
            n = 63 - n;
        }
        return n;
    }

    private boolean isStateSet(byte by, byte by2) {
        return (this.getState(by) & by2) != 0;
    }

    private byte getState(byte by) {
        int n = this.getKeyIndex(by);
        byte by2 = 0;
        if (n >= 0) {
            by2 = this.keyStates[n];
        }
        return by2;
    }

    protected void keyPressed(int n) {
        n = this.getTranslatedKeyCode(n);
        this.keyManaged(n, true);
        super.keyPressed(n);
    }

    protected void keyReleased(int n) {
        n = this.getTranslatedKeyCode(n);
        this.keyManaged(n, false);
        super.keyReleased(n);
    }

    protected void keyRepeated(int n) {
        super.keyRepeated(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keyManaged(int n, boolean bl) {
        if (n != 0) {
            Object object = this.jgKeyMonitor;
            synchronized (object) {
                int n2;
                if (bl) {
                    n2 = 0;
                    if (ignoredKeyCodes != null) {
                        int n3 = ignoredKeyCodes.length - 1;
                        while (n3 >= 0) {
                            if (n == ignoredKeyCodes[n3]) {
                                n2 = 1;
                                break;
                            }
                            --n3;
                        }
                    }
                    if (n2 == 0) {
                        this.keyDeferredIsAnyTyped = true;
                    }
                }
                if (!bl) {
                    n2 = 0;
                    while (n2 < this.keyDeferredStates.length) {
                        if ((this.keyDeferredStates[n2] & 0x40) != 0) {
                            this.keyDeferredStates[n2] = (byte)(this.keyDeferredStates[n2] & 0xFFFFFFBF | 0xFFFFFF80);
                        }
                        ++n2;
                    }
                }
                n2 = 1;
                while (n2 < 64) {
                    if (!(KEY_MAP[n2] != n || bl && (this.keyDeferredStates[n2] & 0x40) != 0)) {
                        this.keyIndexManaged(n2, bl);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keyIndexManaged(int n, boolean bl) {
        Object object = this.jgKeyMonitor;
        synchronized (object) {
            byte by = (byte)(this.keyDeferredStates[n] & 0x3F);
            if (bl) {
                if (by < 63) {
                    by = (byte)(by + 1);
                }
                this.keyDeferredStates[n] = (byte)(0x40 | by);
                this.keyDeferredIsAnyTyped = true;
            } else if ((this.keyDeferredStates[n] & 0x40) != 0) {
                this.keyDeferredStates[n] = (byte)(0xFFFFFF80 | by);
            }
        }
    }

    private int getTranslatedKeyCode(int n) {
        return n;
    }

    private void keyRemoveIncorrectSoftkeyEvents() {
    }

    private void keyReleaseKeysIfBugNoKeyRelease() {
    }

    private void initializeLegacyPointerInput() {
    }

    private void initializePointerInput() {
        PointerInputKeyManager.jgInternalInitialize();
        PointerInputEventManager.jgInternalInitialize();
    }

    private void pointerInputUpdateMetrics() {
        PointerInputKeyManager.updateMetrics();
        PointerInputEventManager.updateMetrics();
    }

    protected void pointerPressed(int n, int n2) {
        long l = 0L;
        this.pointerPressed(n, n2, 0, l);
        super.pointerPressed(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        long l = 0L;
        this.pointerReleased(n, n2, 0, l);
        super.pointerReleased(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        long l = 0L;
        this.pointerDragged(n, n2, 0, l);
        super.pointerDragged(n, n2);
    }

    final void pointerPressed(int n, int n2, int n3, long l) {
        n3 = 0;
        PointerInputKeyManager.jgInternalManageEvent(n3, n, n2, true, true, this.onScreenKeyRegions);
        if (PointerInputEventManager.isEventsEnabled()) {
            PointerInputEventManager.jgInternalAddPointerEvent((byte)n3, n, n2, (byte)1, l);
        }
    }

    final void pointerReleased(int n, int n2, int n3, long l) {
        n3 = 0;
        PointerInputKeyManager.jgInternalManageEvent(n3, n, n2, false, true, this.onScreenKeyRegions);
        if (PointerInputEventManager.isEventsEnabled()) {
            PointerInputEventManager.jgInternalAddPointerEvent((byte)n3, n, n2, (byte)3, l);
        }
    }

    final void pointerDragged(int n, int n2, int n3, long l) {
        n3 = 0;
        PointerInputKeyManager.jgInternalManageEvent(n3, n, n2, true, false, this.onScreenKeyRegions);
        if (PointerInputEventManager.isEventsEnabled()) {
            PointerInputEventManager.jgInternalAddPointerEvent((byte)n3, n, n2, (byte)2, l);
        }
    }

    private void pointerResetIds() {
    }

    public void frameTimingSetMinMillisPerTick(int n) {
        this.userMinMillisPerTick = n;
        this.updateFrameTimingMaxAndMin();
    }

    public int frameTimingGetElapsedMillisSinceLastTick() {
        return this.elapsedMillisSinceLastTick;
    }

    private void updateFrameTimingMaxAndMin() {
        this.minMillisPerTick = Math.min(this.userMinMillisPerTick, this.userMaxMillisPerTick);
        this.minMillisPerTick = Math.max(this.minMillisPerTick, 0);
        this.maxMillisPerTick = Math.max(this.userMinMillisPerTick, this.userMaxMillisPerTick);
        this.maxMillisPerTick = Math.max(this.maxMillisPerTick, 1);
    }

    private long jgInternalCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    private void updateCurrentTime() {
        long l = this.jgInternalCurrentTimeMillis();
        if (this.resetTime) {
            this.resetTime = false;
            this.elapsedMillisSinceLastTick = this.minMillisPerTick;
            this.returnedMillisVariance = 0;
            if (this.timerDebuggerEnabled) {
                this.timerDebuggerReset = true;
            }
        } else {
            int n;
            int n2 = (int)(l - this.currentTime);
            int n3 = n2 = this.fixSystemTimerDeltaBug(n2);
            if (n3 < this.minMillisPerTick) {
                n3 = this.minMillisPerTick;
            }
            if (this.timerDebuggerEnabled) {
                this.timerDebuggerMillis[1] = n2;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = n3 - n2) > 250) {
                n = 250;
            } else if (n < -250) {
                n = -250;
            }
            this.returnedMillisVariance += n;
            if (this.returnedMillisVariance > 500) {
                this.returnedMillisVariance = 500;
            } else if (this.returnedMillisVariance < -500) {
                this.returnedMillisVariance = -500;
            }
            if (this.returnedMillisVariance > 40) {
                this.returnedMillisVariance -= -n2;
                JgCanvas.threadSleep(this.returnedMillisVariance / 8);
                l = this.jgInternalCurrentTimeMillis();
                n2 = Math.max((int)(l - this.currentTime), 0);
                if (this.timerDebuggerEnabled) {
                    int n4 = this.returnedMillisVariance / 8;
                    int n5 = this.timerDebuggerMillis[1] + n4;
                    if (n2 >= n5) {
                        this.timerDebuggerMillis[4] = n2 - n5;
                        this.timerDebuggerMillis[3] = 0;
                    } else {
                        this.timerDebuggerMillis[4] = 0;
                        this.timerDebuggerMillis[3] = n5 - n2;
                        n4 -= n5 - n2;
                    }
                    this.timerDebuggerMillis[2] = n4;
                }
                this.returnedMillisVariance += -n2;
            } else if (this.timerDebuggerEnabled) {
                this.timerDebuggerMillis[2] = 0;
                this.timerDebuggerMillis[4] = 0;
                this.timerDebuggerMillis[3] = 0;
            }
            this.elapsedMillisSinceLastTick = n3 > this.maxMillisPerTick ? this.maxMillisPerTick : n3;
            if (this.timerDebuggerEnabled) {
                this.timerDebuggerMillis[5] = this.elapsedMillisSinceLastTick;
            }
        }
        this.currentTime = l;
    }

    private int fixSystemTimerDeltaBug(int n) {
        if (n > 4000) {
            this.postSystemEvent(2);
        }
        return n;
    }

    private final void emulatorProcessPendingStartStopInstructions() {
    }

    private void playbackInitialize() {
    }

    private void playbackTickLogic() {
    }

    private void initializePainting() {
    }

    public final void paint(Graphics graphics) {
    }

    private void callPaintGameView(Graphics graphics) {
        boolean bl;
        if (graphics == null) {
            this.deferredFullRepaint = true;
            return;
        }
        int n = this.canvasGetFullWidth();
        int n2 = this.canvasGetFullHeight();
        boolean bl2 = bl = n != this.jgGameWidth || n2 != this.jgGameHeight;
        if (bl) {
            if (this.gameFullRepaint) {
                int n3 = n2 - this.jgGameHeight + 1 >>> 1;
                graphics.setColor(-16777216);
                if (n3 > 0) {
                    if (this.jgGameYOffset > 0) {
                        graphics.fillRect(0, 0, n, this.jgGameYOffset);
                    }
                    graphics.fillRect(0, n2 - n3, n, n3);
                }
                if ((n3 = n - this.jgGameWidth + 1 >>> 1) > 0) {
                    if (this.jgGameXOffset > 0) {
                        graphics.fillRect(0, this.jgGameYOffset, this.jgGameXOffset, this.jgGameHeight);
                    }
                    graphics.fillRect(n - n3, this.jgGameYOffset, n3, this.jgGameHeight);
                }
            }
            graphics.translate(this.jgGameXOffset, this.jgGameYOffset);
        }
        this.canvasResetClip(graphics);
        this.paintGameView(graphics);
    }

    public void canvasSetActiveSize(int n, int n2) {
        this.canvasActiveSizeChanged = true;
        this.deferredFullRepaint = true;
        int n3 = this.canvasGetFullWidth();
        int n4 = this.canvasGetFullHeight();
        if (n <= 0) {
            n = n3;
        }
        if (n2 <= 0) {
            n2 = n4;
        }
        this.jgGameWidth = n;
        this.jgGameHeight = n2;
        this.jgGameXOffset = n3 - n;
        this.jgGameYOffset = n4 - n2;
        if (this.jgGameXOffset < 0) {
            ++this.jgGameXOffset;
        }
        if (this.jgGameYOffset < 0) {
            ++this.jgGameYOffset;
        }
        this.jgGameXOffset >>= 1;
        this.jgGameYOffset >>= 1;
        this.pointerInputUpdateMetrics();
    }

    public void canvasResetClip(Graphics graphics) {
        graphics.setClip(0, 0, this.jgGameWidth, this.jgGameHeight);
    }

    public int canvasGetFullWidth() {
        int n = 240;
        return n;
    }

    public int canvasGetFullHeight() {
        int n = 400;
        return n;
    }

    public int canvasGetActiveWidth() {
        return this.jgGameWidth;
    }

    public int canvasGetActiveHeight() {
        return this.jgGameHeight;
    }

    public int canvasGetXLocation() {
        return this.jgGameXOffset;
    }

    public int canvasGetYLocation() {
        return this.jgGameYOffset;
    }

    public void canvasSetFullRepaint() {
        this.deferredFullRepaint = true;
    }

    protected void sizeChanged(int n, int n2) {
        this.canvasSetFullRepaint();
        this.sizeChanged = true;
    }

    private void testCanvasSizeChanged() {
    }

    private boolean updateScreenSizeAndOrientation() {
        return false;
    }

    public void onSystemEvent(int n) {
        if (n == 3) {
            if (canvasRunnableState == 4) {
                return;
            }
            this.jgPerformMIDletShutdown();
            this.midlet.notifyDestroyed();
        }
        if (n == 0 || n == 1 || n == 2) {
            this.deferredFullRepaint = true;
            this.resetTime = true;
            this.keyResetStates();
            this.pointerResetIds();
        }
    }

    private void jgPerformMIDletShutdown() {
        canvasRunnableState = (byte)4;
        canvasThread = null;
        Resources.deactivatePack();
        if (this.jgMediaManager != null) {
            this.jgMediaManager.shutdown();
        }
    }

    public final void hideNotify() {
        this.postSystemEvent(1);
    }

    public final void showNotify() {
        this.postSystemEvent(2);
        canvasShowNotifyCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSystemEvent(int n) {
        if (canvasRunnableState == 4) {
            return;
        }
        if (n == 3) {
            this.onSystemEvent(n);
            return;
        }
        if (n == 1 || n == 2) {
            if (canvasRunnableState == 3) {
                if (n == 1) {
                    if (this.jgMediaManager != null) {
                        this.jgMediaManager.stopChannel(-1);
                    }
                    PointerInputEventManager.jgInternalSetPopSuspended(true);
                } else if (this.jgMediaManager != null) {
                    this.jgMediaManager.stopChannel(-1);
                }
                if (canvasThread == null) {
                    this.lastSystemEventResumeOrInterruptReceived = n;
                    this.lastSystemEventResumeOrInterruptReceivedMillis = System.currentTimeMillis();
                } else {
                    Thread thread = canvasThread;
                    synchronized (thread) {
                        this.lastSystemEventResumeOrInterruptReceived = n;
                        this.lastSystemEventResumeOrInterruptReceivedMillis = System.currentTimeMillis();
                    }
                }
            }
        } else {
            this.onSystemEvent(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void performPendingSystemEventInterruptOrResume() {
        while (this.lastSystemEventResumeOrInterruptReceived != -1) {
            if (this.lastSystemEventResumeOrInterruptPerformed != 1) {
                PointerInputEventManager.jgInternalSetPushSuspended(true);
                PointerInputEventManager.jgInternalReleaseAllPointers();
                PointerInputEventManager.jgInternalSetPopSuspended(false);
                this.onSystemEvent(1);
                this.lastSystemEventResumeOrInterruptPerformed = 1;
            }
            if ((var1_1 = JgCanvas.canvasThread) == null) {
                return;
            }
            var2_2 = var1_1;
            synchronized (var2_2) {
                if (this.lastSystemEventResumeOrInterruptReceived == 1) {
                    this.lastSystemEventResumeOrInterruptReceived = -1;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl21
            }
            do {
                JgCanvas.threadSleep(50);
lbl21:
                // 2 sources

            } while (this.lastSystemEventResumeOrInterruptReceived == 2 && !this.isShown());
            while (this.lastSystemEventResumeOrInterruptReceived == 2 && this.isShown()) {
                var2_3 = (int)(System.currentTimeMillis() - this.lastSystemEventResumeOrInterruptReceivedMillis);
                if (var2_3 < 750) {
                    JgCanvas.threadSleep(250);
                    continue;
                }
                var3_4 = var1_1;
                synchronized (var3_4) {
                    if (this.lastSystemEventResumeOrInterruptReceived != 2) {
                        continue;
                    }
                    this.lastSystemEventResumeOrInterruptReceived = -1;
                }
                this.onSystemEvent(2);
                PointerInputEventManager.jgInternalSetPopSuspended(false);
                PointerInputEventManager.jgInternalSetPushSuspended(false);
                this.lastSystemEventResumeOrInterruptPerformed = 2;
                this.onSystemEvent(5);
            }
        }
    }

    private final void lifecycleTestInterruptUsingIsShown() {
    }

    private final void lifecycleTestForAudioResumed() {
    }

    public void networkTransferComplete(int n, byte[] byArray) {
    }

    public final void run() {
        while (!canvasShowNotifyCalled) {
            JgCanvas.threadSleep(50);
        }
        this.processPreferredInitialOrientation();
        this.initializePointerInput();
        this.initializePainting();
        this.initializeLegacyPointerInput();
        if (!this.canvasActiveSizeChanged) {
            this.canvasSetActiveSize(-1, -1);
        }
        this.sizeChanged = false;
        this.updateScreenSizeAndOrientation();
        canvasRunnableState = (byte)3;
        this.onSystemEvent(0);
        while (canvasRunnableState != 4) {
            this.testCanvasSizeChanged();
            this.testCanvasOrientationChanged();
            this.lifecycleTestInterruptUsingIsShown();
            this.performPendingSystemEventInterruptOrResume();
            if (this.isShown()) {
                this.updateCurrentTime();
                this.lifecycleTestForAudioResumed();
                this.playbackTickLogic();
                this.callNetworkTransferComplete();
                this.tickGameLogic();
                if (canvasRunnableState == 4) {
                    return;
                }
                if (this.jgMediaManager != null && this.isShown()) {
                    this.emulatorProcessPendingStartStopInstructions();
                    this.jgMediaManager.run();
                }
                if (canvasRunnableState == 4) {
                    return;
                }
                if (this.isShown()) {
                    this.gameFullRepaint = this.deferredFullRepaint;
                    this.deferredFullRepaint = false;
                    this.callPaintGameView(this.getGraphics());
                    this.flushGraphics();
                }
            } else {
                JgCanvas.threadSleep(100);
                this.resetTime = true;
            }
            Thread.yield();
        }
        if (canvasRunnableState == 4) {
            PointerInputKeyManager.removeKeyRegions((byte)0);
            PointerInputEventManager.setMultitouchEnabled(false);
            PointerInputEventManager.setEventsEnabled(false);
            PointerInputEventManager.clearAllEvents();
            PointerInputEventManager.jgInternalSetPushSuspended(false);
            PointerInputEventManager.jgInternalSetPopSuspended(false);
            jgCanvas = null;
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public JgCanvas(MIDlet mIDlet) {
        super(false);
        this.setFullScreenMode(true);
        this.canvasCreationTime = System.currentTimeMillis();
        jgCanvas = this;
        this.midlet = mIDlet;
        canvasRunnableState = 0;
        canvasShowNotifyCalled = false;
        canvasThread = new Thread(this);
        canvasThread.start();
        this.updateFrameTimingMaxAndMin();
        this.playbackInitialize();
        this.canvasSetActiveSize(-1, -1);
        this.canvasActiveSizeChanged = false;
    }
}

