/*
 * Decompiled with CFR 0.152.
 */
package jg.input;

import jg.JgCanvas;

public final class PointerInputEventManager {
    private static final Object eventMonitor = new Object();
    private static final Object eventRegionMonitor = new Object();
    private static boolean enabled;
    private static int regionX;
    private static int regionY;
    private static int regionWidth;
    private static int regionHeight;
    private static int regionSizeWidth;
    private static int regionSizeHeight;
    private static final long EVENT_TIMESTAMP_OFFSET;
    private static int eventBufferCurrentIndex;
    private static int eventBufferLastIndex;
    private static Event[] eventDataArray;
    private static boolean[] beingPressed;
    private static long[] pressedTimestamp;
    private static int[] previousX;
    private static int[] previousY;
    private static long[] previousTimestamp;
    private static boolean[] clickCountReset;
    private static boolean multitouchEnabled;
    private static boolean popSuspended;
    private static boolean pushSuspended;
    private static int translateX;
    private static int translateY;
    private static int eventCount;
    private static int eventX;
    private static int eventY;
    private static byte eventType;
    private static long eventTimestamp;
    private static byte eventId;

    static {
        EVENT_TIMESTAMP_OFFSET = System.currentTimeMillis();
    }

    private PointerInputEventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setEventsEnabled(boolean bl) {
        Object object = eventMonitor;
        synchronized (object) {
            if (enabled != bl) {
                enabled = bl;
                if (bl) {
                    eventDataArray = new Event[20];
                    int n = eventDataArray.length - 1;
                    while (n >= 0) {
                        PointerInputEventManager.eventDataArray[n] = new Event();
                        --n;
                    }
                    PointerInputEventManager.clearAllEvents();
                } else {
                    eventDataArray = null;
                    eventCount = 0;
                }
            }
        }
        return true;
    }

    public static boolean isEventsEnabled() {
        return enabled;
    }

    public static void updateMetrics() {
        if (regionSizeWidth < 0 || regionSizeHeight < 0) {
            PointerInputEventManager.setClip(regionX, regionY, regionSizeWidth, regionSizeHeight);
        }
        PointerInputEventManager.setTranslation(JgCanvas.jgCanvas.canvasGetXLocation(), JgCanvas.jgCanvas.canvasGetYLocation());
    }

    public static void setTranslation(int n, int n2) {
        translateX = n;
        translateY = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setClip(int n, int n2, int n3, int n4) {
        Object object = eventRegionMonitor;
        synchronized (object) {
            regionSizeWidth = n3;
            regionSizeHeight = n4;
            regionX = n;
            regionY = n2;
            regionWidth = n3 < 0 ? JgCanvas.jgCanvas.canvasGetActiveWidth() : n3;
            regionHeight = n4 < 0 ? JgCanvas.jgCanvas.canvasGetActiveHeight() : n4;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean popNextEvent() {
        if (eventCount > 0 && !popSuspended) {
            boolean bl = false;
            Object object = eventMonitor;
            synchronized (object) {
                if (enabled) {
                    Event event = eventDataArray[eventBufferCurrentIndex];
                    eventX = event.eventX;
                    eventY = event.eventY;
                    eventType = event.type;
                    eventTimestamp = (long)event.timestamp + EVENT_TIMESTAMP_OFFSET;
                    eventId = event.eventId;
                    --eventCount;
                    eventBufferCurrentIndex = (eventBufferCurrentIndex + 1) % 20;
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllEvents() {
        Object object = eventMonitor;
        synchronized (object) {
            eventCount = 0;
            eventBufferLastIndex = 19;
            eventBufferCurrentIndex = 0;
            eventX = 0;
            eventY = 0;
            eventType = 0;
            eventTimestamp = -1L;
        }
    }

    public static int eventGetX() {
        return eventX;
    }

    public static int eventGetY() {
        return eventY;
    }

    public static byte eventGetType() {
        return eventType;
    }

    public static boolean setMultitouchEnabled(boolean bl) {
        return !bl;
    }

    public static void jgInternalInitialize() {
        regionSizeWidth = -1;
        regionSizeHeight = -1;
        regionWidth = JgCanvas.jgCanvas.canvasGetActiveWidth();
        regionHeight = JgCanvas.jgCanvas.canvasGetActiveHeight();
        pressedTimestamp = new long[1];
        previousX = new int[1];
        previousY = new int[1];
        previousTimestamp = new long[1];
        clickCountReset = new boolean[1];
        beingPressed = new boolean[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jgInternalAddPointerEvent(byte by, int n, int n2, byte by2, long l) {
        if (!pushSuspended && (multitouchEnabled || by == 0)) {
            boolean bl;
            n -= translateX;
            n2 -= translateY;
            Object object = eventRegionMonitor;
            synchronized (object) {
                boolean bl2 = bl = n >= regionX && n2 >= regionY && n < regionX + regionWidth && n2 < regionY + regionHeight;
                if (!bl && beingPressed[by]) {
                    by2 = (byte)3;
                    if (n < regionX) {
                        n = regionX;
                    } else if (n >= regionX + regionWidth) {
                        n = regionX + regionWidth - 1;
                    }
                    if (n2 < regionY) {
                        n2 = regionY;
                    } else if (n2 >= regionY + regionHeight) {
                        n2 = regionY + regionHeight - 1;
                    }
                    bl = true;
                }
            }
            if (bl) {
                if (!beingPressed[by]) {
                    if (by2 == 3) {
                        return;
                    }
                    if (by2 == 2) {
                        by2 = 1;
                    }
                }
                if (by2 == 1 && beingPressed[by]) {
                    PointerInputEventManager.jgInternalAddPointerEventInRegion(by, previousX[by], previousY[by], (byte)3, previousTimestamp[by]);
                }
                PointerInputEventManager.jgInternalAddPointerEventInRegion(by, n, n2, by2, l);
            }
        }
    }

    public static void jgInternalSetPopSuspended(boolean bl) {
        popSuspended = bl;
    }

    public static void jgInternalReleaseAllPointers() {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < beingPressed.length) {
            if (beingPressed[n]) {
                PointerInputEventManager.jgInternalAddPointerEventInRegion((byte)n, previousX[n], previousY[n], (byte)3, l);
            }
            ++n;
        }
    }

    public static void jgInternalSetPushSuspended(boolean bl) {
        pushSuspended = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jgInternalAddPointerEventInRegion(byte by, int n, int n2, byte by2, long l) {
        Object object = eventMonitor;
        synchronized (object) {
            if (enabled) {
                PointerInputEventManager.eventIncrementBufferIndex();
                ++eventCount;
                Event event = eventDataArray[eventBufferLastIndex];
                event.eventX = (short)n;
                event.eventY = (short)n2;
                event.type = by2;
                event.eventId = by;
                event.timestamp = (int)(l - EVENT_TIMESTAMP_OFFSET);
            }
        }
        PointerInputEventManager.beingPressed[by] = by2 == 1 || by2 == 2;
        PointerInputEventManager.previousX[by] = n;
        PointerInputEventManager.previousY[by] = n2;
        PointerInputEventManager.previousTimestamp[by] = l;
    }

    private static void eventIncrementBufferIndex() {
        eventBufferLastIndex = (eventBufferLastIndex + 1) % 20;
        if (eventCount > 0 && eventBufferLastIndex == eventBufferCurrentIndex) {
            int n = 1;
            int n2 = eventBufferCurrentIndex;
            byte by = PointerInputEventManager.eventDataArray[n2].type;
            boolean bl = false;
            if (by == 3) {
                n2 = (n2 + 1) % 20;
                by = PointerInputEventManager.eventDataArray[n2].type;
                bl = true;
            }
            if (by == 1) {
                int n3 = (n2 + 1) % 20;
                if (PointerInputEventManager.eventDataArray[n3].type == 3) {
                    n = 2;
                } else {
                    PointerInputEventManager.eventMove(n2, n3);
                }
            }
            if (bl) {
                if (n == 2) {
                    n2 = (n2 + 1) % 20;
                }
                PointerInputEventManager.eventMove(eventBufferCurrentIndex, n2);
            }
            eventBufferCurrentIndex = (eventBufferCurrentIndex + n) % 20;
            eventCount -= n;
        }
    }

    private static void eventMove(int n, int n2) {
        Event event = eventDataArray[n];
        PointerInputEventManager.eventDataArray[n] = eventDataArray[n2];
        PointerInputEventManager.eventDataArray[n2] = event;
    }

    private static class Event {
        byte eventId;
        byte type;
        short eventX;
        short eventY;
        int timestamp;

        private Event() {
        }
    }
}

