/*
 * Decompiled with CFR 0.152.
 */
package jg;

import javax.microedition.lcdui.Graphics;
import jg.Gob;
import jg.JgCanvas;
import jg.Resources;

class GobAlpha8Bits
extends Gob {
    private byte alphaLevel = (byte)-1;
    private byte argbsAlphaLevel;
    private byte argbsTrans;
    private int[] argbs;
    private byte[] sourceAlphas;

    GobAlpha8Bits(Gob gob) {
        gob.copyPropertiesTo(this);
        this.extractPixelsOfGobRegion(gob);
    }

    private GobAlpha8Bits() {
    }

    private void extractPixelsOfGobRegion(Gob gob) {
        Resources.runGarbageCollection();
        this.argbs = new int[this.width * this.height];
        JgCanvas.imageGetRGBStatic(gob.image, this.argbs, 0, this.width, gob.gobClipX, gob.gobClipY, this.width, this.height);
    }

    private void updateAlpha() {
        if (this.alphaLevel == 0) {
            return;
        }
        if (this.argbsAlphaLevel == 0) {
            if ((this.alphaLevel & 0xFF) == 255) {
                return;
            }
            this.findOptimalAlphaMethodAndInitializeAlphaValues();
            this.argbsAlphaLevel = (byte)-1;
        }
        if (this.sourceAlphas != null) {
            int n = (this.alphaLevel & 0xFF) + 1 << 16;
            int n2 = this.argbs.length - 1;
            while (n2 >= 0) {
                this.argbs[n2] = (this.sourceAlphas[n2] & 0xFF) * n & 0xFF000000 | this.argbs[n2] & 0xFFFFFF;
                --n2;
            }
        } else {
            int n = (this.alphaLevel ^ this.argbsAlphaLevel) << 24;
            int n3 = this.argbs.length - 1;
            while (n3 >= 0) {
                if (this.argbs[n3] != 0xFF00FF) {
                    int n4 = n3;
                    this.argbs[n4] = this.argbs[n4] ^ n;
                }
                --n3;
            }
        }
        this.argbsAlphaLevel = this.alphaLevel;
    }

    private void findOptimalAlphaMethodAndInitializeAlphaValues() {
        int n;
        boolean bl = false;
        int n2 = this.argbs.length - 1;
        while (n2 >= 0) {
            n = this.argbs[n2] >>> 24;
            if (n != 0 && n != 255) {
                bl = true;
                break;
            }
            --n2;
        }
        if (bl) {
            this.sourceAlphas = new byte[this.argbs.length];
            n2 = this.argbs.length - 1;
            while (n2 >= 0) {
                this.sourceAlphas[n2] = (byte)(this.argbs[n2] >>> 24);
                --n2;
            }
        } else {
            n2 = this.argbs.length - 1;
            while (n2 >= 0) {
                n = this.argbs[n2];
                this.argbs[n2] = (n & 0xFF000000) != 0 ? 0xFF000000 | n & 0xFFFFFF : 0xFF00FF;
                --n2;
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        if (this.alphaLevel == 0) {
            return;
        }
        GobAlpha8Bits gobAlpha8Bits = this;
        gobAlpha8Bits.paintWithoutOffsets(graphics, n += this.getOffsetX(n3), n2 += this.getOffsetY(n3), n3);
    }

    private void paintWithoutOffsets(Graphics graphics, int n, int n2, int n3) {
        if (this.argbsTrans != n3) {
            this.applyTransformationsToArray(n3);
        }
        if (this.alphaLevel != this.argbsAlphaLevel) {
            this.updateAlpha();
        }
        JgCanvas.graphicsDrawRGBStatic(graphics, this.argbs, 0, this.width, n, n2, this.width, this.height, true);
    }

    public void setAlphaLevel(int n) {
        this.alphaLevel = (byte)n;
    }

    public Gob createAlphaGob() {
        return this;
    }

    private void applyTransformationsToArray(int n) {
        Gob.flip(this.argbs, (int)this.width, (int)this.height, this.argbsTrans ^ n);
        if (this.sourceAlphas != null) {
            Gob.flip(this.sourceAlphas, (int)this.width, (int)this.height, this.argbsTrans ^ n);
        }
        this.argbsTrans = (byte)n;
    }

    public final boolean isAlphaGob() {
        return true;
    }
}

