/*
 * Decompiled with CFR 0.152.
 */
package jg;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import jg.GobAlpha8Bits;
import jg.Paintable;
import jg.Resources;
import jg.graphics.CollisionBox;

public class Gob
extends Paintable {
    public short offsetX;
    public short offsetY;
    public short width;
    public short height;
    public short collisionX;
    public short collisionY;
    public short collisionWidth;
    public short collisionHeight;
    public byte collisionShape;
    short gobClipX;
    short gobClipY;
    private static int PIXELS_DIRECTIONS = 55524;
    Image image;

    void copyPropertiesTo(Gob gob) {
        gob.offsetX = this.offsetX;
        gob.offsetY = this.offsetY;
        gob.width = this.width;
        gob.height = this.height;
        gob.collisionX = this.collisionX;
        gob.collisionY = this.collisionY;
        gob.collisionWidth = this.collisionWidth;
        gob.collisionHeight = this.collisionHeight;
        gob.collisionShape = this.collisionShape;
    }

    public int getOffsetX(int n) {
        return (n & 2) == 0 ? this.offsetX : -(this.offsetX + this.width);
    }

    public int getOffsetY(int n) {
        return (n & 1) == 0 ? this.offsetY : -(this.offsetY + this.height);
    }

    public int getWidth(int n) {
        return this.width;
    }

    public int getHeight(int n) {
        return this.height;
    }

    public boolean getCollisionBox(CollisionBox collisionBox, int n, int n2, int n3) {
        if (n3 == 0) {
            collisionBox.x = this.offsetX + this.collisionX;
            collisionBox.y = this.offsetY + this.collisionY;
            collisionBox.width = this.collisionWidth;
            collisionBox.height = this.collisionHeight;
        } else if ((n3 & 4) == 0) {
            collisionBox.x = (n3 & 2) == 0 ? this.offsetX + this.collisionX : -(this.offsetX + this.collisionX + this.collisionWidth);
            collisionBox.y = (n3 & 1) == 0 ? this.offsetY + this.collisionY : -(this.offsetY + this.collisionY + this.collisionHeight);
            collisionBox.width = this.collisionWidth;
            collisionBox.height = this.collisionHeight;
        } else {
            collisionBox.x = (n3 & 1) == 0 ? this.offsetY + this.collisionY : -(this.offsetY + this.collisionY + this.collisionHeight);
            collisionBox.y = (n3 & 2) == 0 ? this.offsetX + this.collisionX : -(this.offsetX + this.collisionX + this.collisionWidth);
            collisionBox.width = this.collisionHeight;
            collisionBox.height = this.collisionWidth;
        }
        collisionBox.userDefinedType = -1;
        collisionBox.shapeType = this.collisionShape == 0 ? 3 : 4;
        collisionBox.x += n;
        collisionBox.y += n2;
        return this.collisionWidth > 0 && this.collisionHeight > 0;
    }

    public int getCollisionBoxesByType(int n, CollisionBox[] collisionBoxArray, int n2) {
        int n3;
        int n4 = n3 = this.collisionWidth <= 0 || this.collisionHeight <= 0 ? 0 : 1;
        if (n3 == 1 && collisionBoxArray.length >= 1) {
            this.getCollisionBox(collisionBoxArray[0], 0, 0, n);
        }
        return n3;
    }

    public int getCollisionNumber() {
        return this.collisionWidth <= 0 || this.collisionHeight <= 0 ? 0 : 1;
    }

    static void flip(int[] nArray, int n, int n2, int n3) {
        if (n3 == 3) {
            Gob.flipXY(nArray, n, n2);
        } else {
            if ((n3 & 2) != 0) {
                Gob.flipX(nArray, n, n2);
            }
            if ((n3 & 1) != 0) {
                Gob.flipY(nArray, n, n2);
            }
        }
    }

    static void flipXY(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = nArray.length - 1;
        while (n3 < n4) {
            int n5 = nArray[n3];
            nArray[n3] = nArray[n4];
            nArray[n4] = n5;
            ++n3;
            --n4;
        }
    }

    static void flipX(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3;
            int n6 = n3 + n - 1;
            int n7 = 0;
            int n8 = n >>> 1;
            while (n7 < n8) {
                int n9 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n9;
                ++n5;
                --n6;
                ++n7;
            }
            n3 += n;
            ++n4;
        }
    }

    static void flipY(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            int n5 = n4 + n * (n2 - 1);
            int n6 = 0;
            int n7 = n2 >>> 1;
            while (n6 < n7) {
                int n8 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n8;
                n4 += n;
                n5 -= n;
                ++n6;
            }
            ++n3;
        }
    }

    static void flip(byte[] byArray, int n, int n2, int n3) {
        if (n3 == 3) {
            Gob.flipXY(byArray, n, n2);
        } else {
            if ((n3 & 2) != 0) {
                Gob.flipX(byArray, n, n2);
            }
            if ((n3 & 1) != 0) {
                Gob.flipY(byArray, n, n2);
            }
        }
    }

    static void flipXY(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = byArray.length - 1;
        while (n3 < n4) {
            byte by = byArray[n3];
            byArray[n3] = byArray[n4];
            byArray[n4] = by;
            ++n3;
            --n4;
        }
    }

    static void flipX(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3;
            int n6 = n3 + n - 1;
            int n7 = 0;
            int n8 = n >>> 1;
            while (n7 < n8) {
                byte by = byArray[n5];
                byArray[n5] = byArray[n6];
                byArray[n6] = by;
                ++n5;
                --n6;
                ++n7;
            }
            n3 += n;
            ++n4;
        }
    }

    static void flipY(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            int n5 = n4 + n * (n2 - 1);
            int n6 = 0;
            int n7 = n2 >>> 1;
            while (n6 < n7) {
                byte by = byArray[n4];
                byArray[n4] = byArray[n5];
                byArray[n5] = by;
                n4 += n;
                n5 -= n;
                ++n6;
            }
            ++n3;
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        n += (n3 & 2) == 0 ? this.offsetX : -(this.offsetX + this.width);
        n2 += (n3 & 1) == 0 ? this.offsetY : -(this.offsetY + this.height);
        short s = this.width;
        short s2 = this.height;
        short s3 = this.gobClipX;
        short s4 = this.gobClipY;
        if (s > 0 && s2 > 0) {
            graphics.drawRegion(this.image, (int)s3, (int)s4, (int)s, (int)s2, n3, n, n2, 20);
        }
    }

    static void loadImage(Gob[] gobArray, int n, byte[] byArray, DataInputStream dataInputStream) {
        Image image = Resources.getImage(n, byArray);
        int n2 = 0;
        while (n2 < gobArray.length) {
            gobArray[n2].image = image;
            ++n2;
        }
    }

    void initPropertiesAndSplitImage(short[] sArray) {
        this.offsetX = sArray[0];
        this.offsetY = sArray[1];
        this.gobClipX = sArray[2];
        this.gobClipY = sArray[3];
        this.width = sArray[4];
        this.height = sArray[5];
        this.collisionX = sArray[6];
        this.collisionY = sArray[7];
        this.collisionWidth = (short)(sArray[8] & Short.MAX_VALUE);
        this.collisionHeight = sArray[9];
        this.collisionShape = (byte)(sArray[8] >>> 15);
    }

    public Gob createAlphaGob() {
        Resources.runGarbageCollection();
        GobAlpha8Bits gobAlpha8Bits = new GobAlpha8Bits(this);
        return gobAlpha8Bits;
    }

    public boolean isAlphaGob() {
        return false;
    }

    public void setAlphaLevel(int n) {
    }

    public static void createAlphaGobs(Gob[] gobArray) {
        if (gobArray.length > 0 && !gobArray[0].isAlphaGob()) {
            int n = 0;
            while (n < gobArray.length) {
                gobArray[n] = gobArray[n].createAlphaGob();
                ++n;
            }
        }
    }

    Gob() {
    }
}

