/*
 * Decompiled with CFR 0.152.
 */
package jg;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import jg.Frame;
import jg.Gob;
import jg.Resources;
import jg.graphics.CollisionBox;

public class AnimSet {
    int rpIndex;
    Gob[] gobs;
    int[] animMetaData;
    int[] animDurations;
    byte[] animData1;
    int[] animData2;
    char[] animFrameViewMetaData1;
    int[] animFrameViewMetaData2;
    int[] animFrameViewGobData;
    int[] animFrameViewCollisionData1;
    char[] animFrameViewCollisionData2;
    char[] animTimeDelayPalette;
    private Frame[] frames;
    private Frame[] animations;
    private static int[] sharedXywh = new int[4];
    private static DataInputStream animDis;

    AnimSet() {
    }

    Frame getAnimation(int n) {
        Frame frame;
        if (this.animations == null) {
            this.animations = new Frame[this.getAnimationNumber()];
        }
        if ((frame = this.animations[n]) == null) {
            this.getAnimationBounds(n, 0, sharedXywh);
            this.animations[n] = frame = new Frame(this, -n, sharedXywh);
        }
        return frame;
    }

    public Frame getFrame(int n) {
        Frame frame;
        if (this.frames == null) {
            this.frames = new Frame[this.getFrameNumber()];
        }
        if ((frame = this.frames[n]) == null) {
            this.getFrameBounds(n, 0, sharedXywh);
            this.frames[n] = frame = new Frame(this, n, sharedXywh);
        }
        return frame;
    }

    public void getAnimationBounds(int n, int n2, int[] nArray) {
        int n3 = this.getFrameNumber(n);
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = this.animMetaData[n] >>> 16;
        int n9 = 0;
        while (n9 < n3) {
            int n10 = this.animData2[n8 + n9];
            int n11 = n10 >> 22;
            int n12 = n10 << 10 >> 22;
            int n13 = n10 << 20 >> 22;
            Frame frame = this.getFrame(n11);
            int n14 = frame.getOffsetX(n2);
            int n15 = frame.getOffsetY(n2);
            if (n2 != 0) {
                n14 += AnimSet.getTransformedX(n12, n13, 0, 0, n2);
                n15 += AnimSet.getTransformedY(n12, n13, 0, 0, n2);
            } else {
                n14 += n12;
                n15 += n13;
            }
            n4 = Math.min(n4, n14);
            n5 = Math.min(n5, n15);
            n6 = Math.max(n6, n14 + frame.getWidth(n2));
            n7 = Math.max(n7, n15 + frame.getHeight(n2));
            ++n9;
        }
        nArray[0] = n4;
        nArray[1] = n5;
        nArray[2] = n4 == Integer.MAX_VALUE && n6 == Integer.MIN_VALUE ? 0 : n6 - n4;
        nArray[3] = n5 == Integer.MAX_VALUE && n7 == Integer.MIN_VALUE ? 0 : n7 - n5;
    }

    public void getFrameBounds(int n, int n2, int[] nArray) {
        n = this.animFrameViewMetaData2[n];
        int n3 = n >>> 16;
        int n4 = n3 + (n & 0xFF);
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        while (n3 < n4) {
            n = this.animFrameViewGobData[n3++];
            int n9 = n & 3 ^ n2;
            Gob gob = this.gobs[n >>> 22];
            int n10 = gob.offsetX + (n << 10 >> 22);
            int n11 = gob.offsetY + (n << 20 >> 22);
            if ((n9 & 2) != 0) {
                n10 = -(n10 + gob.width);
            }
            if ((n9 & 1) != 0) {
                n11 = -(n11 + gob.height);
            }
            n5 = Math.min(n5, n10);
            n6 = Math.min(n6, n11);
            n7 = Math.max(n7, n10 + gob.width);
            n8 = Math.max(n8, n11 + gob.height);
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n5 == Integer.MAX_VALUE && n7 == Integer.MIN_VALUE ? 0 : n7 - n5;
        nArray[3] = n6 == Integer.MAX_VALUE && n8 == Integer.MIN_VALUE ? 0 : n8 - n6;
    }

    public int getFrameCollisionBoxesByType(int n, int n2, CollisionBox[] collisionBoxArray, int n3) {
        int n4 = this.animFrameViewMetaData1[n];
        int n5 = this.animFrameViewMetaData2[n] >> 8 & 0xFF;
        int n6 = n4 + n5;
        int n7 = 0;
        while (n4 < n6 && n7 < collisionBoxArray.length) {
            boolean bl;
            n = this.animFrameViewCollisionData1[n4];
            int n8 = n >> 21;
            int n9 = n << 11 >> 21;
            int n10 = n & 0x3FF;
            n = this.animFrameViewCollisionData2[n4++];
            int n11 = n >> 6;
            int n12 = n & 0x1F;
            boolean bl2 = bl = (n & 0x20) != 0;
            if (n3 >= 0 && n12 != n3) continue;
            CollisionBox collisionBox = collisionBoxArray[n7];
            if (n2 != 0) {
                if ((n2 & 4) != 0) {
                    collisionBox.x = AnimSet.getTransformedX(n8, n9, n10, n11, n2);
                    collisionBox.y = AnimSet.getTransformedY(n8, n9, n10, n11, n2);
                    int n13 = n10;
                    n10 = n11;
                    n11 = n13;
                } else {
                    collisionBox.x = (n2 & 2) == 0 ? n8 : -(n8 + n10);
                    collisionBox.y = (n2 & 1) == 0 ? n9 : -(n9 + n11);
                }
            } else {
                collisionBox.x = n8;
                collisionBox.y = n9;
            }
            collisionBox.width = n10;
            collisionBox.height = n11;
            collisionBox.userDefinedType = n12;
            collisionBox.shapeType = bl ? 4 : 3;
            ++n7;
        }
        return n7;
    }

    public int getFrameCollisionNumber(int n) {
        return this.animFrameViewMetaData2[n] >> 8 & 0xFF;
    }

    public int getAnimationNumber() {
        return this.animMetaData.length;
    }

    public int getFrameNumber() {
        return this.animFrameViewMetaData2.length;
    }

    public int getFrameNumber(int n) {
        return this.animMetaData[n] & 0x3FF;
    }

    public void paintFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this.animFrameViewMetaData2[n];
        int n5 = n >>> 16;
        int n6 = n5 + (n & 0xFF);
        while (n5 < n6) {
            n = this.animFrameViewGobData[n5++];
            int n7 = n << 10 >> 22;
            int n8 = n << 20 >> 22;
            Gob gob = this.gobs[n >>> 22];
            gob.offsetX = (short)(gob.offsetX + n7);
            gob.offsetY = (short)(gob.offsetY + n8);
            gob.paint(graphics, n2, n3, n & 3 ^ n4);
            gob.offsetX = (short)(gob.offsetX - n7);
            gob.offsetY = (short)(gob.offsetY - n8);
        }
    }

    public void setGobs(Gob[] gobArray) {
        this.gobs = gobArray;
    }

    static AnimSet load(int n) {
        AnimSet animSet = new AnimSet();
        try {
            animDis = Resources.getStream(n);
            animSet.rpIndex = n;
            animDis.read();
            int n2 = animDis.readChar();
            animSet.animMetaData = new int[n2];
            animSet.animDurations = new int[n2];
            n = AnimSet.readLoop1(animSet.animMetaData);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3++;
                animSet.animMetaData[n4] = animSet.animMetaData[n4] | (0x3F & AnimSet.readNextSigned()) << 10;
            }
            animSet.animData1 = new byte[n];
            animSet.animData2 = new int[n];
            n3 = 0;
            while (n3 < n) {
                n2 = AnimSet.readNextUnsigned();
                animSet.animData1[n3] = (byte)n2;
                animSet.animData2[n3] = n2 >> 8;
                ++n3;
            }
            AnimSet.readLoop2(animSet.animData2);
            char c = animDis.readChar();
            animSet.animFrameViewMetaData1 = new char[c];
            animSet.animFrameViewMetaData2 = new int[c];
            n = AnimSet.readLoop1(animSet.animFrameViewMetaData2);
            animSet.animFrameViewGobData = new int[n];
            int n5 = 0;
            n3 = 0;
            while (n3 < n) {
                if (n5 == 0) {
                    n2 = AnimSet.readNextUnsigned();
                    n5 = 8;
                }
                animSet.animFrameViewGobData[n3] = 3 & n2 >> (n5 -= 2);
                ++n3;
            }
            AnimSet.readLoop2(animSet.animFrameViewGobData);
            n = 0;
            n3 = 0;
            while (n3 < c) {
                n2 = AnimSet.readNextUnsigned();
                int n6 = n3;
                animSet.animFrameViewMetaData2[n6] = animSet.animFrameViewMetaData2[n6] | n2 << 8;
                animSet.animFrameViewMetaData1[n3] = (char)n;
                n += n2;
                ++n3;
            }
            animSet.animFrameViewCollisionData1 = new int[n];
            animSet.animFrameViewCollisionData2 = new char[n];
            n3 = 0;
            while (n3 < n) {
                animSet.animFrameViewCollisionData1[n3++] = AnimSet.readNextSigned() << 21;
            }
            n3 = 0;
            while (n3 < n) {
                int n7 = n3++;
                animSet.animFrameViewCollisionData1[n7] = animSet.animFrameViewCollisionData1[n7] | AnimSet.readNextSigned() << 21 >>> 11;
            }
            n3 = 0;
            while (n3 < n) {
                int n8 = n3++;
                animSet.animFrameViewCollisionData1[n8] = animSet.animFrameViewCollisionData1[n8] | AnimSet.readNextUnsigned();
            }
            n3 = 0;
            while (n3 < n) {
                animSet.animFrameViewCollisionData2[n3++] = (char)(AnimSet.readNextUnsigned() << 6);
            }
            n3 = 0;
            while (n3 < n) {
                int n9 = n3++;
                animSet.animFrameViewCollisionData2[n9] = (char)(animSet.animFrameViewCollisionData2[n9] | (char)AnimSet.readNextUnsigned());
            }
            n2 = animDis.readChar();
            animSet.animTimeDelayPalette = new char[n2];
            n3 = 0;
            while (n3 < n2) {
                animSet.animTimeDelayPalette[n3] = (char)AnimSet.readNextUnsigned();
                ++n3;
            }
        }
        catch (Exception exception) {}
        animDis = null;
        return animSet;
    }

    private static int readNextUnsigned() throws Exception {
        int n = animDis.read();
        if (n == 255) {
            return animDis.readChar();
        }
        return n;
    }

    private static int readNextSigned() throws Exception {
        byte by = animDis.readByte();
        if (by == -128) {
            return animDis.readShort();
        }
        return by;
    }

    private static int readLoop1(int[] nArray) throws Exception {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = AnimSet.readNextUnsigned();
            nArray[n2++] = n << 16 | n3;
            n += n3;
        }
        return n;
    }

    private static void readLoop2(int[] nArray) throws Exception {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] | AnimSet.readNextUnsigned() << 22;
        }
        n2 = 0;
        while (n2 < n) {
            int n4 = n2++;
            nArray[n4] = nArray[n4] | AnimSet.readNextSigned() << 22 >>> 10;
        }
        n2 = 0;
        while (n2 < n) {
            int n5 = n2++;
            nArray[n5] = nArray[n5] | AnimSet.readNextSigned() << 22 >>> 20;
        }
    }

    public static int getTransformedX(int n, int n2, int n3, int n4, int n5) {
        n = (n5 & 4) != 0 ? ((n5 & 1) == 0 ? n2 : -(n2 + n4)) : ((n5 & 2) == 0 ? n : -(n + n3));
        return n;
    }

    public static int getTransformedY(int n, int n2, int n3, int n4, int n5) {
        n2 = (n5 & 4) != 0 ? ((n5 & 2) == 0 ? n : -(n + n3)) : ((n5 & 1) == 0 ? n2 : -(n2 + n4));
        return n2;
    }

    public int getAnimationDuration(int n) {
        int n2 = 0;
        if (n >= 0 && n < this.getAnimationNumber() && (n2 = this.animDurations[n]) == 0) {
            int n3 = this.animMetaData[n] >>> 16;
            int n4 = this.getFrameNumber(n);
            while (--n4 >= 0) {
                n2 += this.animTimeDelayPalette[this.animData1[n3 + n4] & 0x3F];
            }
            this.animDurations[n] = n2;
        }
        return n2;
    }
}

