/*
 * Decompiled with CFR 0.152.
 */
package jg.util.text;

import javax.microedition.lcdui.Graphics;
import jg.Gob;
import jg.JgCanvas;
import jg.util.text.RichFont;
import jg.util.text.StringHelper;

public class WrappedText {
    private static final char[] DEFAULT_DELIMITERS = new char[]{' ', '@', '-'};
    private JgCanvas canvas;
    private int leading;
    private String text;
    private short[] offsets;
    private char[] wordDelimiters;
    private int maxLineWidth;
    private RichFont font;
    private int fontHeight;
    private int alphaLevel = 255;

    public WrappedText(JgCanvas jgCanvas) {
        this.canvas = jgCanvas;
        this.reset();
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        if (this.text != null) {
            int n4;
            if (this.font.isGobFont() && this.alphaLevel != 255) {
                WrappedText.updateAlpha(this.font.getGobFont(), this.alphaLevel);
            }
            int n5 = n2;
            int n6 = (n3 & 1) == 1 ? n + (this.maxLineWidth >> 1) : ((n3 & 8) == 8 ? n + this.maxLineWidth : n);
            int n7 = graphics.getClipY();
            int n8 = graphics.getClipHeight();
            int n9 = this.getLineHeight();
            int n10 = n7 + n8;
            if (n2 < n7) {
                n4 = (n7 - n2) / n9;
                n5 += n4 * n9;
            } else {
                n4 = 0;
            }
            int n11 = n4 << 1;
            int n12 = this.offsets.length;
            while (n11 < n12 && n5 <= n10) {
                short s = this.offsets[n11];
                short s2 = this.offsets[n11 + 1];
                if (s2 > 0) {
                    this.font.drawText(graphics, this.text, (int)s, (int)s2, n6, n5, n3);
                }
                n5 += n9;
                n11 += 2;
            }
        }
    }

    public int wrapText(RichFont richFont, String string, int n) {
        this.text = string;
        this.maxLineWidth = n;
        int n2 = string.length();
        this.font = richFont;
        this.fontHeight = this.font.getHeight();
        short[] sArray = null;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                int n7;
                int n8 = 0;
                int n9 = n5;
                boolean bl = false;
                int n10 = 1;
                while (n8 <= n && n9 < n2) {
                    n7 = string.charAt(n9);
                    if (n5 == n9 && n7 == 32) {
                        ++n5;
                        if (++n9 >= n2) break;
                        n7 = string.charAt(n9);
                    }
                    if (n7 == 10 || n7 == 13) {
                        n10 = 1;
                        if (n7 == 13 && n9 + 1 < n2 && string.charAt(n9 + 1) == '\n') {
                            n10 = 2;
                        }
                        bl = true;
                        break;
                    }
                    n6 = this.font.getWidth((char)n7);
                    if (n8 + n6 > n) break;
                    n8 += n6;
                    ++n9;
                }
                if (!bl && n9 < n2) {
                    n7 = -1;
                    n6 = 0;
                    while (n6 < this.wordDelimiters.length) {
                        char c = this.wordDelimiters[n6];
                        int n11 = StringHelper.lastIndexOf(string, c, n5 + 1, n9);
                        if (!(n7 >= n11 || c == '-' && n11 + 1 < n2 && Character.isDigit(string.charAt(n11 + 1)))) {
                            n7 = n11;
                        }
                        ++n6;
                    }
                    if (n7 != -1 && n7 > n5 && n7 < n9) {
                        n9 = n7;
                        if (string.charAt(n7) == ' ') {
                            bl = true;
                        } else {
                            ++n9;
                            bl = false;
                        }
                    }
                }
                if (sArray != null) {
                    sArray[n4] = (short)n5;
                    sArray[n4 + 1] = (short)(n9 - n5);
                }
                n4 += 2;
                n5 = n9 + (bl ? n10 : 0);
            }
            if (sArray == null) {
                sArray = new short[n4];
            }
            ++n3;
        }
        this.offsets = sArray;
        return this.getLineCount();
    }

    public int getHeight() {
        return this.getLineHeight() * this.getLineCount();
    }

    public int getLineCount() {
        return this.offsets.length >> 1;
    }

    public int getLineHeight() {
        return this.fontHeight + this.leading;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public void reset() {
        this.text = null;
        this.leading = 0;
        this.fontHeight = 0;
        this.maxLineWidth = 0;
        this.font = null;
        this.offsets = new short[0];
        this.wordDelimiters = DEFAULT_DELIMITERS;
    }

    private static void updateAlpha(Gob[] gobArray, int n) {
        Gob.createAlphaGobs(gobArray);
        int n2 = 0;
        while (n2 < gobArray.length) {
            gobArray[n2].setAlphaLevel(n);
            ++n2;
        }
    }
}

