/*
 * Decompiled with CFR 0.152.
 */
package jg.util.text;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import jg.Resources;

public class Translation {
    private static StringBuffer sharedBuffer;
    private int textCount;
    private byte[] utfBytes;
    private int[] utfOffsetsInt;
    private char[] utfOffsetsChar;
    private String[] cachedStrings;

    public Translation(int n) {
        this(Resources.getBytes(n));
    }

    public Translation(byte[] byArray) {
        this(new DataInputStream(new ByteArrayInputStream(byArray)), byArray.length);
    }

    public Translation(DataInputStream dataInputStream, int n) {
        try {
            this.textCount = dataInputStream.readChar() + '\u0001';
            if (n <= 65535) {
                this.utfOffsetsChar = new char[this.textCount];
            } else {
                this.utfOffsetsInt = new int[this.textCount];
            }
            this.utfBytes = new byte[n - (this.textCount << 1)];
            --this.textCount;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.textCount) {
                if (this.utfOffsetsChar != null) {
                    this.utfOffsetsChar[n3] = (char)n2;
                } else {
                    this.utfOffsetsInt[n3] = n2;
                }
                n = dataInputStream.readShort();
                if (n > 0) {
                    dataInputStream.readFully(this.utfBytes, n2, n);
                }
                n2 += n;
                ++n3;
            }
            if (this.utfOffsetsChar != null) {
                this.utfOffsetsChar[this.textCount] = (char)n2;
            } else {
                this.utfOffsetsInt[this.textCount] = n2;
            }
        }
        catch (Exception exception) {}
    }

    public String get(int n) {
        String string;
        if (this.cachedStrings != null) {
            string = this.cachedStrings[n];
        } else {
            StringBuffer stringBuffer;
            int n2 = this.getEntrySize(n);
            if (n2 <= 128) {
                if (sharedBuffer == null) {
                    sharedBuffer = new StringBuffer();
                }
                stringBuffer = sharedBuffer;
            } else {
                stringBuffer = new StringBuffer(n2);
            }
            string = this.get(n, stringBuffer).toString();
        }
        return string;
    }

    public StringBuffer get(int n, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        return this.insert(n, stringBuffer, 0);
    }

    public StringBuffer insert(int n, StringBuffer stringBuffer, int n2) {
        if (this.cachedStrings != null) {
            return stringBuffer.insert(n2, this.cachedStrings[n]);
        }
        int n3 = this.getEntryOffset(n);
        int n4 = this.getEntrySize(n);
        try {
            Translation.decodeUtfText(this.utfBytes, n3, n4, stringBuffer, n2);
        }
        catch (Exception exception) {}
        return stringBuffer;
    }

    private int getEntryOffset(int n) {
        return this.utfOffsetsChar != null ? this.utfOffsetsChar[n] : this.utfOffsetsInt[n];
    }

    private int getEntrySize(int n) {
        int n2;
        if (this.utfOffsetsChar != null) {
            n2 = this.utfOffsetsChar[n + 1] - this.utfOffsetsChar[n];
            if (this.utfOffsetsChar[0] != '\u0000') {
                n2 -= 2;
            }
        } else {
            n2 = this.utfOffsetsInt[n + 1] - this.utfOffsetsInt[n];
            if (this.utfOffsetsInt[0] != 0) {
                n2 -= 2;
            }
        }
        return n2;
    }

    public static void decodeUtfText(byte[] byArray, int n, int n2, StringBuffer stringBuffer, int n3) {
        int n4;
        int n5 = 0;
        while (n5 < n2) {
            n4 = byArray[n + n5] & 0xFF;
            if (n4 > 127) break;
            ++n5;
            stringBuffer.insert(n3, (char)n4);
            ++n3;
        }
        while (n5 < n2) {
            n4 = byArray[n + n5] & 0xFF;
            ++n5;
            char c = '\u0000';
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    c = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    byte by = byArray[n + n5];
                    ++n5;
                    c = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    byte by = byArray[n + n5];
                    byte by2 = byArray[n + ++n5];
                    ++n5;
                    c = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                }
            }
            stringBuffer.insert(n3, c);
            ++n3;
        }
    }
}

