/*
 * Decompiled with CFR 0.152.
 */
package jg.graphics;

import javax.microedition.lcdui.Graphics;
import jg.Paintable;

public class CollisionBox
extends Paintable {
    public int x;
    public int y;
    public int width;
    public int height;
    public int shapeType;
    public int userDefinedType;
    public boolean filled;
    public boolean colorUsed;
    public int color;
    public static final CollisionBox sharedBox = new CollisionBox();

    public CollisionBox() {
        this.shapeType = 3;
    }

    public CollisionBox(int n, int n2, int n3, int n4, int n5) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.shapeType = n5;
    }

    public void copyModelTo(CollisionBox collisionBox) {
        collisionBox.x = this.x;
        collisionBox.y = this.y;
        collisionBox.width = this.width;
        collisionBox.height = this.height;
        collisionBox.userDefinedType = this.userDefinedType;
        collisionBox.shapeType = this.shapeType;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public boolean contains(int n, int n2) {
        if (this.shapeType == 3) {
            return this.width > 0 && this.height > 0 && n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
        }
        int n3 = this.width >> 1;
        int n4 = this.x + n3;
        int n5 = n - n4;
        int n6 = this.y + n3;
        int n7 = n2 - n6;
        return n5 * n5 + n7 * n7 < n3 * n3;
    }

    public boolean intersects(CollisionBox collisionBox) {
        if (this.shapeType == 3) {
            if (collisionBox.shapeType == 3) {
                return collisionBox.width + collisionBox.x > this.x && collisionBox.height + collisionBox.y > this.y && this.x + this.width > collisionBox.x && this.y + this.height > collisionBox.y && collisionBox.width > 0 && collisionBox.height > 0 && this.width > 0 && this.height > 0;
            }
            int n = collisionBox.width >> 1;
            int n2 = collisionBox.x + n;
            int n3 = collisionBox.y + n;
            return CollisionBox.intersectsCircleWithRect(n2, n3, n, this);
        }
        if (collisionBox.shapeType == 3) {
            int n = this.width >> 1;
            int n4 = this.x + n;
            int n5 = this.y + n;
            return CollisionBox.intersectsCircleWithRect(n4, n5, n, collisionBox);
        }
        int n = this.width >> 1;
        int n6 = this.x + n;
        int n7 = this.y + n;
        int n8 = collisionBox.width >> 1;
        int n9 = collisionBox.x + n8;
        int n10 = collisionBox.y + n8;
        return CollisionBox.intersectsCircles(n6, n7, n, n9, n10, n8);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.shapeType == 3) {
            return n3 + n > this.x && n4 + n2 > this.y && this.x + this.width > n && this.y + this.height > n2 && n3 > 0 && n4 > 0 && this.width > 0 && this.height > 0;
        }
        int n5 = this.width >> 1;
        int n6 = this.x + n5;
        int n7 = this.y + n5;
        CollisionBox.sharedBox.x = n;
        CollisionBox.sharedBox.y = n2;
        CollisionBox.sharedBox.width = n3;
        CollisionBox.sharedBox.height = n4;
        return CollisionBox.intersectsCircleWithRect(n6, n7, n5, sharedBox);
    }

    public String toString() {
        return "x,y:" + this.x + "," + this.y + ", WxH:" + this.width + "," + this.height;
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.paint(graphics);
        this.x -= n;
        this.y -= n2;
    }

    public void paint(Graphics graphics) {
        if (this.width > 0 && this.height > 0) {
            int n = 0;
            if (this.colorUsed) {
                n = graphics.getColor();
                graphics.setColor(this.color);
            }
            if (this.shapeType == 4) {
                if (this.filled) {
                    graphics.fillArc(this.x, this.y, this.width - 1, this.height - 1, 0, 360);
                } else {
                    graphics.drawArc(this.x, this.y, this.width - 1, this.height - 1, 0, 360);
                }
            } else if (this.filled) {
                graphics.fillRect(this.x, this.y, this.width, this.height);
            } else {
                graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
            }
            if (this.colorUsed) {
                graphics.setColor(n);
            }
        }
    }

    public int getOffsetX(int n) {
        return this.x;
    }

    public int getOffsetY(int n) {
        return this.y;
    }

    public int getWidth(int n) {
        return this.width;
    }

    public int getHeight(int n) {
        return this.height;
    }

    public static boolean intersectsCircles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - n4;
        int n8 = n2 - n5;
        int n9 = n7 * n7 + n8 * n8;
        int n10 = n3 + n6;
        return n9 <= n10 * n10;
    }

    public static boolean intersectsCircleWithRect(int n, int n2, int n3, CollisionBox collisionBox) {
        int n4 = collisionBox.width >> 1;
        int n5 = collisionBox.height >> 1;
        int n6 = Math.abs(n - collisionBox.x - n4);
        int n7 = Math.abs(n2 - collisionBox.y - n5);
        if (n6 > n4 + n3) {
            return false;
        }
        if (n7 > n5 + n3) {
            return false;
        }
        if (n6 <= n4) {
            return true;
        }
        if (n7 <= n5) {
            return true;
        }
        int n8 = n6 - n4;
        int n9 = n7 - n5;
        int n10 = n8 * n8 + n9 * n9;
        return n10 <= n3 * n3;
    }

    public int getCollisionNumber() {
        return this.width <= 0 || this.height <= 0 ? 0 : 1;
    }

    public int getCollisionBoxesByType(int n, CollisionBox[] collisionBoxArray, int n2) {
        int n3;
        int n4 = n3 = this.width <= 0 || this.height <= 0 || n2 >= 0 && n2 != this.userDefinedType ? 0 : 1;
        if (n3 == 1 && collisionBoxArray.length >= 1) {
            this.copyModelTo(collisionBoxArray[0]);
        }
        return n3;
    }
}

