/*
 * Decompiled with CFR 0.152.
 */
package jg;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import jg.AnimSet;
import jg.Gob;
import jg.io.resource.ResourcePack;

public class Resources {
    private static final ResourcePack resourcePack = new ResourcePack();
    static boolean[] gobHeaderBits;
    static byte[] gobBytesPerVar;
    static short[] gobVars;
    private static char lastGobsReadImageId;
    private static int resourcePaletteOffset;

    private Resources() {
    }

    public static Gob[] getGobs(int n) {
        return Resources.getGobs(n, null);
    }

    public static Gob[] getGobs(int n, byte[] byArray) {
        return Resources.getGobs(n, byArray, Resources.getStream(n), null);
    }

    private static Gob[] getGobs(int n, byte[] byArray, DataInputStream dataInputStream, DataInputStream dataInputStream2) {
        Gob[] gobArray;
        try {
            lastGobsReadImageId = (char)(dataInputStream.readChar() | n & 0xFC00);
            int n2 = dataInputStream.readByte();
            byte[] byArray2 = new byte[dataInputStream.readShort() - 4];
            int n3 = dataInputStream.readChar();
            int n4 = dataInputStream.readChar();
            dataInputStream.readFully(byArray2);
            if (gobHeaderBits == null) {
                Resources.runGarbageCollection();
                gobHeaderBits = new boolean[20];
                gobBytesPerVar = new byte[10];
                gobVars = new short[10];
            }
            int n5 = 32768;
            int n6 = 0;
            while (n6 < 4) {
                Resources.gobHeaderBits[16 + n6] = (n4 & n5) != 0;
                n5 >>= 1;
                ++n6;
            }
            dataInputStream = null;
            n4 &= 0xFFF;
            n2 = 0;
            while (n2 < 16) {
                Resources.gobHeaderBits[n2] = (n3 >> n2 & 1) == 0;
                ++n2;
            }
            n3 = 5;
            n2 = 0;
            n5 = 0;
            while (n5 < 3) {
                n6 = 0;
                while (n6 < (n5 == 0 ? 2 : 4)) {
                    Resources.gobBytesPerVar[n2++] = gobHeaderBits[n5] ? (gobHeaderBits[n3++] ? 2 : 1) : 0;
                    ++n6;
                }
                ++n5;
            }
            n3 = 0;
            Resources.runGarbageCollection();
            gobArray = new Gob[n4];
            n5 = 0;
            while (n5 < n4) {
                Gob gob;
                gobArray[n5] = gob = new Gob();
                ++n5;
            }
            Gob.loadImage(gobArray, lastGobsReadImageId, byArray, dataInputStream2);
            n5 = 0;
            while (n5 < n4) {
                n3 = 0;
                int n7 = 0;
                while (n7 < gobVars.length) {
                    n2 = 0;
                    int n8 = gobBytesPerVar[n7] - 1;
                    if (n8 >= 0) {
                        n3 += n5 << n8;
                        if (n8 == 0) {
                            n2 = byArray2[n3];
                            if (n7 > 1 && n7 != 6 && n7 != 7) {
                                n2 &= 0xFF;
                            }
                        } else {
                            n2 = (byArray2[n3] & 0xFF) << 8;
                            n2 |= byArray2[n3 + 1] & 0xFF;
                        }
                        n3 += n4 - n5 << n8;
                    }
                    Resources.gobVars[n7] = (short)n2;
                    ++n7;
                }
                gobArray[n5].initPropertiesAndSplitImage(gobVars);
                ++n5;
            }
        }
        catch (Exception exception) {
            gobArray = null;
        }
        return gobArray;
    }

    public static Image getImage(byte[] byArray, int n, int n2) {
        Resources.runGarbageCollection();
        Image image = Image.createImage((byte[])byArray, (int)n, (int)n2);
        Resources.runGarbageCollection();
        return image;
    }

    public static Image getImage(int n) {
        return Resources.getImage(n, null);
    }

    public static Image getImage(int n, byte[] byArray) {
        Image image = null;
        image = resourcePack.getImage(n, byArray);
        return image;
    }

    public static void swapPalettes(byte[] byArray, int n, byte[] byArray2) {
        if (byArray2 != null) {
            DataInputStream dataInputStream = Resources.getSafeDataInputStream(byArray, n, byArray.length - n);
            try {
                int n2 = Resources.getPaletteLength(dataInputStream);
                if (n2 != -1) {
                    int n3 = 0;
                    n += resourcePaletteOffset;
                    while (n3 < byArray2.length) {
                        byte by = byArray[n];
                        byArray[n++] = byArray2[n3];
                        byArray2[n3++] = by;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    private static int getPaletteLength(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(8);
        resourcePaletteOffset = 8;
        int n = -1;
        while (true) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            resourcePaletteOffset += 8;
            if (1347179589 == n3) {
                n = n2;
                break;
            }
            if (1229278788 == n3) break;
            dataInputStream.skipBytes(n2 + 4);
            resourcePaletteOffset += n2 + 4;
        }
        return n;
    }

    public static byte[] getBytes(int n) {
        return resourcePack.getBytes(n);
    }

    public static DataInputStream getStream(int n) {
        DataInputStream dataInputStream = resourcePack.getStream(n);
        if (dataInputStream.markSupported()) {
            dataInputStream.mark(0);
        }
        return dataInputStream;
    }

    public static byte getType(int n) {
        return resourcePack.getType(n);
    }

    public static void deactivatePack() {
        resourcePack.freeActivePack();
    }

    public static AnimSet getAnimSet(int n) {
        return AnimSet.load(n);
    }

    public static DataInputStream getSafeDataInputStream(byte[] byArray, int n, int n2) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, n2));
        return dataInputStream;
    }

    public static void runGarbageCollection() {
    }
}

