/*
 * Decompiled with CFR 0.152.
 */
package jg;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import jg.JgCanvas;
import jg.Paintable;

public final class CellLayer {
    private final boolean viewWindowBuffered;
    private final int viewWindowWidth;
    private final int viewWindowHeight;
    private final boolean viewWindowBackBufferTransparent;
    private final boolean tilesOptimizedSplit;
    private int viewWindowX;
    private int viewWindowY;
    private Image viewWindowBackBuffer;
    private Graphics viewWindowBackBufferGraphics;
    private int tilesCols;
    private int tilesRows;
    private short[] tilesGrid;
    private char[] tilesAnimated;
    private Image tilesImage;
    private char[] tilesClipX;
    private char[] tilesClipY;
    private int tilesWidth;
    private int tilesHeight;
    private int staticEntitiesUsed;
    private Paintable[] staticEntitiesPaintables;
    private short[] staticEntitiesOffsetX;
    private short[] staticEntitiesOffsetY;
    private short[] staticEntitiesWidth;
    private short[] staticEntitiesHeight;
    private short[] staticEntitiesX;
    private short[] staticEntitiesY;
    private byte[] staticEntitiesTrans;
    private int[] staticEntitiesPack;
    private int staticEntitiesLargestDim;
    private boolean staticEntitiesSortUncompiled;
    private boolean staticEntitiesSortVertically;
    private int[] staticEntitiesBuff;
    private boolean paintRegionUndrawnDynamicEntitiesOnly;

    public static CellLayer newUnbufferedInstance(int n, int n2) {
        return new CellLayer(false, false, false, n, n2);
    }

    private CellLayer(boolean arg0, boolean arg1, boolean arg2, int arg3, int arg4) {
        this.viewWindowBuffered = arg0;
        this.viewWindowWidth = arg3;
        this.viewWindowHeight = arg4;
        if (arg0 && this.viewWindowBackBuffer == null) {
            this.viewWindowBackBuffer = JgCanvas.jgCanvas.imageCreateImage(arg3, arg4, arg2, 0);
            this.viewWindowBackBufferGraphics = this.viewWindowBackBuffer.getGraphics();
        }
        this.viewWindowBackBufferTransparent = arg0 && arg2;
        this.tilesOptimizedSplit = arg1;
    }

    public void viewWindowSetPosition(int n, int n2) {
        this.viewWindowX = n;
        this.viewWindowY = n2;
    }

    public int viewWindowGetX() {
        return this.viewWindowX;
    }

    public int viewWindowGetY() {
        return this.viewWindowY;
    }

    public void viewWindowPaint(Graphics arg0) {
        if (!this.viewWindowBuffered) {
            this.viewWindowPaintUnbuffered(arg0);
        }
    }

    private void viewWindowPaintUnbuffered(Graphics graphics) {
        int n = this.viewWindowX;
        int n2 = this.viewWindowY;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.viewWindowWidth;
        int n6 = this.viewWindowHeight;
        int n7 = graphics.getClipX();
        if (n7 > 0) {
            n += n7;
            n5 -= n7;
            n3 = n7;
        }
        if ((n7 = n3 + n5 - (n7 + graphics.getClipWidth())) > 0) {
            n5 -= n7;
        }
        if ((n7 = graphics.getClipY()) > 0) {
            n2 += n7;
            n6 -= n7;
            n4 = n7;
        }
        if ((n7 = n4 + n6 - (n7 + graphics.getClipHeight())) > 0) {
            n6 -= n7;
        }
        if (n5 > 0 && n6 > 0) {
            int n8 = graphics.getClipX();
            int n9 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            this.paintRegion(graphics, n, n2, n3, n4, n5, n6);
            graphics.setClip(n8, n9, n10, n11);
        }
    }

    private void paintRegion(Graphics arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        block3: {
            arg0.setClip(arg3, arg4, arg5, arg6);
            if (this.paintRegionUndrawnDynamicEntitiesOnly) break block3;
            if (this.viewWindowBackBufferTransparent) {
                this.paintClearRegion(arg0, arg3, arg4, arg5, arg6);
            }
            if (this.tilesGrid != null) {
                this.paintTilesRegion(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }
            if (this.staticEntitiesUsed > 0) {
                this.paintStaticEntitiesRegion(arg1, arg2, arg3, arg4, arg5, arg6, arg0);
            }
        }
    }

    private void paintClearRegion(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void paintTilesRegion(Graphics arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        int n;
        int n2 = (arg1 + arg5 - 1) / this.tilesWidth;
        int n3 = n2 - arg1 / this.tilesWidth;
        int n4 = (arg2 + arg6 - 1) / this.tilesHeight;
        n2 += n4 * this.tilesCols;
        n4 -= arg2 / this.tilesHeight;
        int n5 = arg1 %= this.tilesWidth;
        int n6 = arg2 %= this.tilesHeight;
        int n7 = -(arg1 + arg5) % this.tilesWidth;
        if (n7 < 0) {
            n7 += this.tilesWidth;
        }
        if ((n = -(arg2 + arg6) % this.tilesHeight) < 0) {
            n += this.tilesHeight;
        }
        arg1 = arg3 - arg1 + this.tilesWidth * n3;
        arg2 = arg4 - arg2 + this.tilesHeight * n4;
        arg6 = n4;
        while (arg6 >= 0) {
            arg5 = n3;
            while (arg5 >= 0) {
                int n8 = this.tilesGrid[n2--];
                if ((n8 &= 0xFFF) > 0) {
                    --n8;
                    arg3 = 0;
                    arg4 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    if (arg5 == 0) {
                        arg3 = n5;
                    }
                    if (arg5 == n3) {
                        n9 = n7;
                    }
                    if (arg6 == 0) {
                        arg4 = n6;
                    }
                    if (arg6 == n4) {
                        n10 = n;
                    }
                    if (!this.tilesOptimizedSplit) {
                        arg0.drawRegion(this.tilesImage, this.tilesClipX[n8] + arg3, this.tilesClipY[n8] + arg4, this.tilesWidth - arg3 - n9, this.tilesHeight - arg4 - n10, 0, arg1 + arg3, arg2 + arg4, 20);
                    }
                }
                arg1 -= this.tilesWidth;
                --arg5;
            }
            n2 += 1 + n3 - this.tilesCols;
            arg1 += this.tilesWidth * (n3 + 1);
            arg2 -= this.tilesHeight;
            --arg6;
        }
    }

    public void tilesNewGrid(int arg0, int arg1, Image arg2, int arg3, int arg4) {
        int n = 0;
        int n2 = 0;
        int n3 = arg2.getWidth();
        int n4 = arg2.getHeight();
        this.tilesDispose();
        this.tilesCols = arg0;
        this.tilesRows = arg1;
        this.tilesGrid = new short[arg0 * arg1];
        this.tilesAnimated = new char[0];
        this.tilesWidth = arg3;
        this.tilesHeight = arg4;
        int n5 = n3 / this.tilesWidth * (n4 / this.tilesHeight);
        n3 -= this.tilesWidth;
        n4 -= this.tilesHeight;
        if (!this.tilesOptimizedSplit) {
            this.tilesImage = arg2;
            this.tilesClipX = new char[n5];
            this.tilesClipY = new char[n5];
            int n6 = 0;
            int n7 = 0;
            while (n7 <= n4) {
                int n8 = 0;
                while (n8 <= n3) {
                    this.tilesClipX[n6] = (char)(n + n8);
                    this.tilesClipY[n6] = (char)(n2 + n7);
                    ++n6;
                    n8 += this.tilesWidth;
                }
                n7 += this.tilesHeight;
            }
        }
    }

    public void tilesDispose() {
        this.tilesGrid = null;
        if (!this.tilesOptimizedSplit) {
            this.tilesImage = null;
            this.tilesClipX = null;
            this.tilesClipY = null;
        }
    }

    public void tilesSetCell(int arg0, int arg1, int arg2) {
        this.tilesGrid[arg1 * this.tilesCols + arg0] = (short)arg2;
    }

    public int tilesGetRows() {
        return this.tilesRows;
    }

    public void staticEntitiesSetCapacity(int n) {
        int n2 = this.tilesRows * this.tilesHeight;
        int n3 = this.tilesCols * this.tilesWidth;
        this.staticEntitiesSetCapacity(n, n2 > n3);
    }

    public void staticEntitiesSetCapacity(int arg0, boolean arg1) {
        this.staticEntitiesUsed = 0;
        this.staticEntitiesPaintables = null;
        this.staticEntitiesOffsetX = null;
        this.staticEntitiesOffsetY = null;
        this.staticEntitiesWidth = null;
        this.staticEntitiesHeight = null;
        this.staticEntitiesX = null;
        this.staticEntitiesY = null;
        this.staticEntitiesTrans = null;
        this.staticEntitiesPack = null;
        this.staticEntitiesLargestDim = 0;
        this.staticEntitiesSortUncompiled = true;
        this.staticEntitiesBuff = null;
        if (arg0 > 0) {
            this.staticEntitiesSortVertically = arg1;
            this.staticEntitiesPaintables = new Paintable[arg0];
            this.staticEntitiesOffsetX = new short[arg0];
            this.staticEntitiesOffsetY = new short[arg0];
            this.staticEntitiesWidth = new short[arg0];
            this.staticEntitiesHeight = new short[arg0];
            this.staticEntitiesX = new short[arg0];
            this.staticEntitiesY = new short[arg0];
            this.staticEntitiesTrans = new byte[arg0];
            this.staticEntitiesPack = new int[arg0];
            this.staticEntitiesBuff = new int[arg0];
        }
    }

    public void staticEntitiesAdd(Paintable paintable, int n, int n2, int n3) {
        int n4 = paintable.getOffsetX(n3);
        int n5 = paintable.getOffsetY(n3);
        int n6 = paintable.getWidth(n3);
        int n7 = paintable.getHeight(n3);
        n += n4;
        n2 += n5;
        this.staticEntitiesPaintables[this.staticEntitiesUsed] = paintable;
        this.staticEntitiesOffsetX[this.staticEntitiesUsed] = (short)n4;
        this.staticEntitiesOffsetY[this.staticEntitiesUsed] = (short)n5;
        this.staticEntitiesWidth[this.staticEntitiesUsed] = (short)n6;
        this.staticEntitiesHeight[this.staticEntitiesUsed] = (short)n7;
        this.staticEntitiesX[this.staticEntitiesUsed] = (short)n;
        this.staticEntitiesY[this.staticEntitiesUsed] = (short)n2;
        this.staticEntitiesTrans[this.staticEntitiesUsed] = (byte)(n3 & 3);
        this.staticEntitiesPack[this.staticEntitiesUsed] = (this.staticEntitiesSortVertically ? n2 : n) << 16 | this.staticEntitiesUsed;
        this.staticEntitiesLargestDim = Math.max(this.staticEntitiesLargestDim, this.staticEntitiesSortVertically ? n7 : n6);
        ++this.staticEntitiesUsed;
    }

    private void paintStaticEntitiesRegion(int n, int n2, int n3, int n4, int n5, int n6, Graphics graphics) {
        int n7;
        int n8;
        int n9;
        if (this.staticEntitiesSortUncompiled) {
            JgCanvas.combSort(this.staticEntitiesPack, this.staticEntitiesUsed);
            this.staticEntitiesSortUncompiled = false;
        }
        int n10 = this.staticEntitiesSortVertically ? (n6 += n2) : (n5 += n);
        int n11 = 0;
        int n12 = (this.staticEntitiesSortVertically ? n2 : n) - this.staticEntitiesLargestDim << 16;
        int n13 = n9 = JgCanvas.findIndexIntoSorted(this.staticEntitiesPack, this.staticEntitiesUsed - 1, n12);
        while (n13 < this.staticEntitiesUsed && (n8 = this.staticEntitiesPack[n13]) >> 16 < n10) {
            n7 = this.staticEntitiesX[n8 &= 0xFFFF];
            short s = this.staticEntitiesY[n8];
            if (n7 < n5 && s < n6 && n < n7 + this.staticEntitiesWidth[n8] && n2 < s + this.staticEntitiesHeight[n8]) {
                this.staticEntitiesBuff[n11++] = n8;
            }
            ++n13;
        }
        JgCanvas.combSort(this.staticEntitiesBuff, n11);
        n -= n3;
        n2 -= n4;
        n7 = 0;
        while (n7 < n11) {
            n8 = this.staticEntitiesBuff[n7];
            this.staticEntitiesPaintables[n8].paint(graphics, this.staticEntitiesX[n8] - this.staticEntitiesOffsetX[n8] - n, this.staticEntitiesY[n8] - this.staticEntitiesOffsetY[n8] - n2, this.staticEntitiesTrans[n8]);
            ++n7;
        }
    }
}

