/*
 * Decompiled with CFR 0.152.
 */
package jg;

import javax.microedition.lcdui.Graphics;
import jg.AnimSet;
import jg.Frame;
import jg.Paintable;
import jg.graphics.CollisionBox;

public class AnimPlayer
extends Paintable {
    private AnimSet animSet;
    private Frame animationSizes;
    private short animationIndex = (short)-1;
    private char animationFrameNumber;
    private char baseAnimDataInx;
    private char elapsed;
    private short currentFrame;
    private short currentVisibleFrame;
    private short lastX;
    private short lastY;
    private byte loopsLeft;
    private byte visibleFramePriority;
    public byte transformation;
    public byte collisionBoxFilterType = (byte)-1;
    public short x;
    public short y;
    public short oldX;
    public short oldY;

    public AnimPlayer() {
    }

    public AnimPlayer(AnimSet animSet) {
        this.animSet = animSet;
    }

    public int getCollisionBoxesByType(int n, CollisionBox[] collisionBoxArray, int n2) {
        int n3 = 0;
        if (this.animationFrameNumber > '\u0000') {
            n3 = this.animSet.getFrameCollisionBoxesByType(this.getAbsoluteFrameIndex(), n, collisionBoxArray, n2);
        }
        return n3;
    }

    public int getCollisionNumber() {
        int n = 0;
        if (this.animationFrameNumber > '\u0000') {
            n = this.animSet.getFrameCollisionNumber(this.getAbsoluteFrameIndex());
        }
        return n;
    }

    public int getDuration() {
        int n = 0;
        if (this.animSet != null) {
            n = this.animSet.getAnimationDuration(this.animationIndex);
        }
        return n;
    }

    public void setAnimIndex(int n) {
        this.animationIndex = (short)n;
        int n2 = this.animSet.animMetaData[n];
        this.animationFrameNumber = (char)(n2 & 0x3FF);
        this.baseAnimDataInx = (char)(n2 >>> 16);
        this.loopsLeft = (byte)(n2 << 16 >> 26);
        this.setFrameIndex(0);
        this.lastX = 0;
        this.lastY = 0;
    }

    public int getAnimIndex() {
        return this.animationIndex;
    }

    public int getTimeElapsed() {
        int n = this.elapsed;
        if (this.animationFrameNumber > '\u0000') {
            int n2 = this.currentFrame;
            while (--n2 >= 0) {
                n += this.animSet.animTimeDelayPalette[this.animSet.animData1[this.baseAnimDataInx + n2] & 0x3F];
            }
        }
        return n;
    }

    public void setFrameIndex(int n) {
        int n2 = this.animSet.animData2[this.baseAnimDataInx + n];
        int n3 = n2 << 10 >> 22;
        int n4 = n2 << 20 >> 22;
        this.elapsed = '\u0000';
        this.lastX = (short)n3;
        this.lastY = (short)n4;
        this.currentVisibleFrame = this.currentFrame = (short)n;
        this.visibleFramePriority = (byte)(this.animSet.animData1[this.baseAnimDataInx + this.currentVisibleFrame] >> 6 & 3);
    }

    public int getFrameIndex() {
        return this.currentFrame;
    }

    public int getFrameNumber() {
        return this.animationFrameNumber;
    }

    public int getLoopsRemaining() {
        return this.loopsLeft < 0 ? -1 : (int)this.loopsLeft;
    }

    public boolean update(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.loopsLeft == 0) {
            this.oldX = this.x;
            this.oldY = this.y;
            return false;
        }
        if (this.animationFrameNumber == '\u0000') {
            return false;
        }
        n += this.elapsed;
        short s = this.currentFrame;
        while (n >= (n6 = this.animSet.animTimeDelayPalette[this.animSet.animData1[this.baseAnimDataInx + this.currentFrame] & 0x3F])) {
            n -= n6;
            this.currentFrame = (short)(this.currentFrame + 1);
            if (this.currentFrame == this.animationFrameNumber) {
                if (this.loopsLeft > 0 && (this.loopsLeft = (byte)(this.loopsLeft - 1)) == 0) {
                    this.currentFrame = (short)(this.currentFrame - 1);
                    n = n6;
                    break;
                }
                this.currentFrame = 0;
                n5 = this.animSet.animData2[this.baseAnimDataInx + (this.animationFrameNumber - '\u0001')];
                this.lastX = (short)(this.lastX - (n5 << 10 >> 22));
                this.lastY = (short)(this.lastY - (n5 << 20 >> 22));
            }
            if (this.visibleFramePriority > (n4 = this.animSet.animData1[this.baseAnimDataInx + this.currentFrame] >> 6 & 3)) continue;
            this.visibleFramePriority = (byte)n4;
            s = this.currentFrame;
            if (n4 == 3) break;
        }
        n5 = this.animSet.animData2[this.baseAnimDataInx + this.currentFrame];
        n4 = n5 << 10 >> 22;
        int n7 = n5 << 20 >> 22;
        if ((n5 & 3) > 0 && this.loopsLeft != 0 && (this.currentFrame + 1 != this.animationFrameNumber || this.loopsLeft != 1)) {
            if (this.currentFrame + 1 == this.animationFrameNumber) {
                n3 = n4;
                n2 = n7;
                n5 = 0;
            } else {
                n3 = 0;
                n2 = 0;
                n5 = this.currentFrame + 1;
            }
            n5 = this.animSet.animData2[this.baseAnimDataInx + n5];
            int n8 = (n << 12) / n6;
            n4 += ((n3 += n5 << 10 >> 22) - n4) * n8 >> 12;
            n7 += ((n2 += n5 << 20 >> 22) - n7) * n8 >> 12;
        }
        n3 = n4 - this.lastX;
        n2 = n7 - this.lastY;
        this.elapsed = (char)n;
        this.lastX = (short)n4;
        this.lastY = (short)n7;
        this.currentVisibleFrame = s;
        this.oldX = this.x;
        this.oldY = this.y;
        if (this.transformation == 0) {
            this.x = (short)(this.x + n3);
            this.y = (short)(this.y + n2);
        } else if ((this.transformation & 4) == 0) {
            this.x = (short)(this.x + ((this.transformation & 2) == 0 ? n3 : -n3));
            this.y = (short)(this.y + ((this.transformation & 1) == 0 ? n2 : -n2));
        } else {
            this.x = (short)(this.x + ((this.transformation & 1) == 0 ? n2 : -n2));
            this.y = (short)(this.y + ((this.transformation & 2) == 0 ? n3 : -n3));
        }
        return this.loopsLeft != 0;
    }

    public void paint(Graphics graphics) {
        if (this.animSet != null && this.animationFrameNumber != '\u0000') {
            int n = this.animSet.animData2[this.baseAnimDataInx + this.currentVisibleFrame] >>> 22;
            this.animSet.paintFrame(graphics, n, this.x, this.y, this.transformation);
            this.visibleFramePriority = 0;
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        this.x = (short)(this.x + n);
        this.y = (short)(this.y + n2);
        this.transformation = (byte)(this.transformation ^ n3);
        this.paint(graphics);
        this.x = (short)(this.x - n);
        this.y = (short)(this.y - n2);
        this.transformation = (byte)(this.transformation ^ n3);
    }

    public Frame getAnimBounds() {
        if (this.animationSizes == null) {
            this.animationSizes = this.animSet.getAnimation(this.animationIndex);
        }
        return this.animationSizes;
    }

    public int getOffsetX(int n) {
        return this.getAnimBounds().getOffsetX(n);
    }

    public int getOffsetY(int n) {
        return this.getAnimBounds().getOffsetY(n);
    }

    public int getWidth(int n) {
        return this.getAnimBounds().getWidth(n);
    }

    public int getHeight(int n) {
        return this.getAnimBounds().getHeight(n);
    }

    public int getAbsoluteFrameIndex() {
        return this.animSet.animData2[this.baseAnimDataInx + this.currentVisibleFrame] >>> 22;
    }

    public Frame getAbsoluteFrame() {
        return this.animSet.getFrame(this.getAbsoluteFrameIndex());
    }

    public void setX(int n) {
        this.x = (short)n;
    }

    public void setY(int n) {
        this.y = (short)n;
    }

    public AnimSet getAnimSet() {
        return this.animSet;
    }
}

