/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class AnimatedObject {
    private AnimatedObject pNext;
    private int nPriority;
    private int nLayer;
    AnimatedObjectData pAnimatedObjectData;
    int nAObjectDataType;
    int nScreenPosX;
    int nScreenPosY;
    Image[] pImg;
    byte nFrameTick;
    int nCurrentAction;
    int nNextAction = -1;
    short nCurrentFrame;
    byte nFlags;
    byte nDelay = 1;
    boolean bLoop = true;
    boolean bUseWiseDraw;
    boolean bNeedDrawUpdate;
    static short[][] m_cueColorDark = new short[10][];
    static short[][] m_cueColorLight = new short[10][];
    static short[] m_cueStrokeColor = new short[]{110, 0};
    static short m_cueAlpha = (short)15;
    static AnimatedObject[] pRoot = new AnimatedObject[3];

    AnimatedObject() {
    }

    AnimatedObject(int n, int n2) {
        this.CreateAnimatedObject(n, n2, -1, 0, true, 0);
    }

    AnimatedObject(int n, int n2, int n3, int n4, boolean bl, int n5) {
        this.CreateAnimatedObject(n, n2, n3, n4, bl, n5);
    }

    void InitAnimatedObject(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (n != -99) {
            this.nAObjectDataType = (short)n;
        }
        this.nScreenPosX = n2;
        this.nScreenPosY = n3;
        if (n4 != -99) {
            this.nCurrentFrame = (short)n4;
        }
        if (n5 != -99) {
            this.nCurrentAction = n5;
        }
        if (n6 != -99) {
            this.nNextAction = n6;
        }
        this.changePriority(n7, n8);
        this.bUseWiseDraw = bl;
    }

    void CreateAnimatedObject(int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (n != -1) {
            GameCanvasEx.RM_Load(n);
        }
        if (n2 != -1) {
            GameCanvasEx.RM_Load(n2);
        }
        if (n3 != -1) {
            GameCanvasEx.RM_Load(n3);
        }
        GameCanvasEx.RM_Synchronize(-1);
        this.pAnimatedObjectData = AnimatedObjectData.loadData(GameCanvasEx.RM_GetResource_Array_Byte(n));
        this.nAObjectDataType = this.pAnimatedObjectData.nType;
        if (n2 != -1) {
            Image image = GameCanvasEx.RM_GetResource_Image(n2);
            if (n5 != 0) {
                this.pImg = new Image[4];
                int n6 = image.getWidth();
                int n7 = image.getHeight();
                this.pImg[0] = image;
                if ((n5 & 1) != 0) {
                    this.pImg[1] = Image.createImage((Image)image, (int)0, (int)0, (int)n6, (int)n7, (int)2);
                }
                if ((n5 & 2) != 0) {
                    this.pImg[2] = Image.createImage((Image)image, (int)0, (int)0, (int)n6, (int)n7, (int)1);
                }
                if ((n5 & 3) == 3 || (n5 & 8) != 0) {
                    this.pImg[3] = Image.createImage((Image)image, (int)0, (int)0, (int)n6, (int)n7, (int)3);
                }
            } else {
                this.pImg = new Image[1];
                this.pImg[0] = image;
            }
        }
        if (bl) {
            if (n3 != -1) {
                GameCanvasEx.RM_Free(n3);
            }
            if (n2 != -1) {
                GameCanvasEx.RM_Free(n2);
            }
            if (n != -1) {
                GameCanvasEx.RM_Free(n);
            }
            GameCanvasEx.RM_Synchronize(-1);
        }
    }

    private void play() {
        this.nFrameTick = (byte)(this.nFrameTick + 1);
        if (this.nNextAction != -1) {
            this.nCurrentAction = this.nNextAction;
            this.nCurrentFrame = 0;
            this.nFrameTick = 0;
            this.nNextAction = -1;
        } else if (this.nFrameTick >= this.nDelay) {
            this.nFrameTick = 0;
            this.nCurrentFrame = (short)(this.nCurrentFrame + 1);
            if (this.nCurrentFrame >= (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][0] & 0xFF)) {
                this.nCurrentFrame = this.bLoop ? (short)0 : (short)(this.nCurrentFrame - 1);
            }
        }
        this.nDelay = (byte)(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][1 + this.nCurrentFrame] & 0xFF) << 1] & 0x7F);
    }

    void setCurrentAction(int n) {
        this.nCurrentAction = (short)n;
        this.nNextAction = -1;
        this.rewind();
        this.bLoop = true;
    }

    void setLooping(boolean bl) {
        this.bLoop = bl;
    }

    void setPosition(int n, int n2) {
        this.nScreenPosX = (short)n;
        this.nScreenPosY = (short)n2;
    }

    Image getImage(int n) {
        return this.pImg[n];
    }

    void setImage(Image image) {
        if (this.pImg == null) {
            this.pImg = new Image[1];
        }
        this.pImg[0] = image;
    }

    boolean isInDrawList() {
        return AnimatedObject.AnimationPlayer_Check(this, this.nLayer);
    }

    void addToDrawList() {
        AnimatedObject.AnimationPlayer_Play(this, this.nLayer);
    }

    void removeFromDrawList() {
        AnimatedObject.AnimationPlayer_Stop(this);
    }

    void setFlag(boolean bl, byte by) {
        this.nFlags = bl ? (byte)(this.nFlags | by) : (byte)(this.nFlags & ~by);
    }

    void changePriority(int n, int n2) {
        boolean bl = this.isInDrawList();
        if (bl) {
            this.removeFromDrawList();
        }
        if (n >= 0) {
            this.nPriority = n;
        }
        if (n2 >= 0) {
            this.nLayer = n2;
        }
        if (bl) {
            this.addToDrawList();
        }
    }

    boolean isEndOfAnimation() {
        return this.nCurrentFrame == (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][0] & 0xFF) - 1;
    }

    void rewind() {
        this.nCurrentFrame = 0;
        this.nFrameTick = this.nDelay = this.pAnimatedObjectData != null ? (byte)(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][1 + this.nCurrentFrame] & 0xFF) << 1] & 0x7F) : (byte)0;
    }

    void drawATInterfaceBall(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, 13, 13);
        if (this.bLoop) {
            this.bNeedDrawUpdate = true;
            int n4 = 255 - (GameCanvasEx.m_iTimeTick & 0xF) * 16;
            int n5 = GameCanvasEx.Color_ChangeBrightness_RGB888(0xFF0000, n4);
            graphics.setClip(0, 0, 176, 208);
            graphics.setColor(n5);
            graphics.drawArc(n2 - 1, n3 - 1, 14, 14, 0, 360);
            GameCanvasEx.GfxFontDrawStringCenteredColor(graphics, Integer.toString(this.nCurrentFrame), n2 + 6, n3 + 2, 0);
        } else {
            graphics.drawImage(GameCanvasEx.RM_GetResource_Image(GameCanvasEx.p_imageBalls[this.nCurrentFrame]), n2, n3, 20);
        }
    }

    void drawWidescreenEffect(Graphics graphics) {
        graphics.setColor(0);
        graphics.setClip(0, 0, 176, 208);
        graphics.fillRect(0, 0, 176, 54);
        graphics.fillRect(0, 153, 176, 55);
    }

    void drawATPowerBar(int n, int n2, int n3, Graphics graphics) {
        n = 138 - n;
        graphics.setClip(n2, n3 + n, 6, 138 - n);
        graphics.drawImage(GameCanvasEx.RM_GetResource_Image(103), n2, n3, 20);
    }

    void drawATCue(int n, int n2, int n3, Graphics graphics, DirectGraphics directGraphics) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl = false;
        if (n < 10 || n > 245) {
            n16 = 1;
            n9 = 1;
            n12 = 0;
            n13 = -1;
            n14 = 0;
            n15 = 2;
        } else if (n < 52) {
            n16 = 2;
            bl = true;
            n8 = 1;
            n9 = 1;
            n10 = 1;
            n12 = 0;
            n13 = -1;
            n14 = 2;
            n15 = 1;
        } else if (n < 74) {
            n16 = 3;
            n8 = 1;
            n12 = -1;
            n13 = 0;
            n14 = 2;
            n15 = 0;
        } else if (n < 117) {
            n16 = 4;
            bl = true;
            n8 = 1;
            n9 = -1;
            n11 = -1;
            n12 = -1;
            n13 = 0;
            n14 = 1;
            n15 = -2;
        } else if (n < 138) {
            n16 = 5;
            n9 = -1;
            n12 = 0;
            n13 = 1;
            n14 = 0;
            n15 = -2;
        } else if (n < 181) {
            n16 = 6;
            bl = true;
            n8 = -1;
            n9 = -1;
            n10 = -1;
            n12 = 0;
            n13 = 1;
            n14 = -2;
            n15 = -1;
        } else if (n < 202) {
            n16 = 7;
            n8 = -1;
            n12 = 1;
            n13 = 0;
            n14 = -2;
            n15 = 0;
        } else {
            n16 = 8;
            bl = true;
            n8 = -1;
            n9 = 1;
            n11 = 1;
            n12 = 1;
            n13 = 0;
            n14 = -1;
            n15 = 2;
        }
        int n17 = 0;
        int n18 = 0;
        if (n17 < 0) {
            n17 *= -1;
            n18 = 1;
        }
        int n19 = n17 + 128;
        if (n > n17 && n < n19) {
            n18 = 1;
        } else if (n19 == 256) {
            if (n == n17 || n == 0) {
                n18 = 2;
            }
        } else if (n == n17 || n == n19) {
            n18 = 2;
        }
        int n20 = n2 + (GameCanvasEx.cos(n += 128) * 110 >> 14);
        int n21 = n3 - (GameCanvasEx.sin(n) * 110 >> 14);
        graphics.setClip(0, 0, 176, 208);
        if (n2 <= n20) {
            n7 = n2;
            n6 = n20;
        } else {
            n7 = n20;
            n6 = n2;
        }
        if (n3 <= n21) {
            n5 = n3;
            n4 = n21;
        } else {
            n5 = n21;
            n4 = n3;
        }
        int n22 = GameCanvasEx.CueBufferNeedsRefresh(n7 - 3, n5 - 3, n6 - n7 + 8, n4 - n5 + 8, n, m_cueAlpha);
        if (!GameCanvasEx.m_bIsCueValid || m_cueAlpha == 0) {
            return;
        }
        if (n22 == 1) {
            GameCanvasEx.ClearCueArray();
            if (n18 == 1) {
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n12, n3 + n13, n20 + n12, n21 + n13, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n14, n3 + n15, n20 + n14, n21 + n15, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n8, n3 + n9, n20 + n8, n21 + n9, m_cueColorDark[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                if (bl) {
                    GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n10, n3 + n11, n20 + n10, n21 + n11, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                }
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2, n3, n20, n21, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
            } else if (n18 == 2) {
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n12, n3 + n13, n20 + n12, n21 + n13, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n14, n3 + n15, n20 + n14, n21 + n15, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n8, n3 + n9, n20 + n8, n21 + n9, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                if (bl) {
                    GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 + n10, n3 + n11, n20 + n10, n21 + n11, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                }
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2, n3, n20, n21, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
            } else {
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 - n12, n3 - n13, n20 - n12, n21 - n13, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 - n14, n3 - n15, n20 - n14, n21 - n15, m_cueStrokeColor, true);
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 - n8, n3 - n9, n20 - n8, n21 - n9, m_cueColorDark[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                if (bl) {
                    GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2 - n10, n3 - n11, n20 - n10, n21 - n11, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
                }
                GameCanvasEx.DrawMultiColoredLineARGB(directGraphics, n2, n3, n20, n21, m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]], true);
            }
        }
        GameCanvasEx.DrawCueOnScreen(directGraphics);
    }

    void drawATString(int n, int n2, int n3, Graphics graphics) {
        String string = "";
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            string = string + GameCanvasEx.m_pStringAObjPool[this.nCurrentAction];
            if (this.nNextAction == 1) {
                GameCanvasEx.GfxFontDrawMultiStringsCenteredColor(graphics, string, n2, n3, this.nCurrentFrame);
            } else {
                GameCanvasEx.GfxFontDrawStringColor(graphics, string, n2, n3, this.nCurrentFrame);
            }
        }
    }

    void drawATDialog(int n, int n2, int n3, Graphics graphics) {
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            GameCanvasEx.Font_GfxFontDrawLinesCenteredColor(graphics, GameCanvasEx.m_pStringAObjPool[this.nCurrentAction], n2, n3, this.nCurrentFrame, this.nNextAction, 4);
        }
    }

    static void drawATView3D(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(0, 0, 176, 208);
        GameCanvasEx.Game_View3D_Refresh(graphics, n2, n3);
    }

    void drawATMenuBox(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, (int)this.nCurrentFrame, this.nCurrentAction);
        GameCanvasEx.Game_WideScreen_Dialog(graphics, n2, n3, this.nCurrentFrame, this.nCurrentAction, 0);
    }

    void drawATDialogBox(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, (int)this.nCurrentFrame, this.nCurrentAction);
        if (this.bLoop) {
            GameCanvasEx.Game_WideScreen_Dialog(graphics, 0, n3, 176, this.nCurrentAction, 0);
        } else {
            GameCanvasEx.Game_DrawBubble(graphics, n2, n3, this.nCurrentFrame, this.nCurrentAction, 0xFFFFFF, 0);
        }
    }

    void drawATColorBox(Graphics graphics) {
        graphics.setClip(this.nScreenPosX, this.nScreenPosY - 1 + 0, 15, 11);
        graphics.setColor(this.nNextAction);
        graphics.fillRect(this.nScreenPosX, this.nScreenPosY - 1 + 0, 14, 10);
        graphics.setColor(0x333399);
        graphics.drawRect(this.nScreenPosX, this.nScreenPosY - 1 + 0, 14, 10);
        if (this.nCurrentFrame == 1) {
            graphics.setColor((GameCanvasEx.m_iTimeTick & 1) != 0 ? 0x333399 : 0xFF0000);
        }
        this.drawArrows(graphics, this.nScreenPosX, this.nScreenPosY - 1 + 0);
        if (this.bLoop) {
            graphics.setClip(0, 0, 176, 208);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(this.nScreenPosX + 4, this.nScreenPosY + 4 + 0, 7, 4);
            graphics.drawArc(this.nScreenPosX + 5, this.nScreenPosY + 1 + 0, 4, 3, 0, 360);
        }
    }

    void drawArrows(Graphics graphics, int n, int n2) {
        graphics.setClip(n - 5 - 2, n2 + 5 - 2, n - 7, n2 + 5);
        graphics.drawLine(n - 5, n2 + 5 - 2, n - 5, n2 + 5 + 2);
        graphics.drawLine(n - 5 - 1, n2 + 5 - 1, n - 6, n2 + 5 + 1);
        graphics.drawLine(n - 5 - 2, n2 + 5, n - 7, n2 + 5);
        graphics.setClip(n + 14 + 5, n2 + 5 - 2, n + 14 + 7, n2 + 5);
        graphics.drawLine(n + 14 + 5, n2 + 5 - 2, n + 14 + 5, n2 + 5 + 2);
        graphics.drawLine(n + 14 + 6, n2 + 5 - 1, n + 14 + 6, n2 + 5 + 1);
        graphics.drawLine(n + 14 + 7, n2 + 5, n + 14 + 7, n2 + 5);
    }

    void drawATAimingLine(Graphics graphics) {
        if (GameCanvasEx.m_bAimingLinesOn) {
            PhysicalObject.PhysicEngine_resetSimulation();
            GameCanvasEx.ApplyShotParamsToBall(GameCanvasEx.m_pCueBall.pCopy, true);
            this.nCurrentAction = 1;
            AnimatedObject.Game_DrawAimingLines(graphics, this.bLoop);
        }
    }

    void drawATCursor(Graphics graphics, int n, int n2) {
        graphics.setClip(0, this.nScreenPosY - 4, 176, 14);
        graphics.setColor(n);
        graphics.fillRect(0, this.nScreenPosY - 3, 176, 13);
        graphics.setColor(n2);
        graphics.drawLine(0, this.nScreenPosY - 3, 176, this.nScreenPosY - 3);
        graphics.drawLine(0, this.nScreenPosY + 9, 176, this.nScreenPosY + 9);
    }

    static void drawATPause(Graphics graphics, int n) {
        int n2;
        int n3 = Math.max(176, 208);
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(n);
        for (n2 = 0; n2 <= n3; n2 += 2) {
            graphics.drawLine(0, n2, n2, 0);
        }
        for (n2 = n3; n2 >= 0; n2 -= 2) {
            graphics.drawLine(n3, n2, n2, n3);
        }
    }

    void drawATOptions(Graphics graphics, int n) {
        this.drawATString(n, this.nScreenPosX, this.nScreenPosY, graphics);
        if (this.bLoop) {
            graphics.setColor((GameCanvasEx.m_iTimeTick & 1) != 0 ? 0x333399 : 0xFF0000);
        } else {
            graphics.setColor(0x333399);
        }
        this.drawArrows(graphics, this.nScreenPosX - 7, this.nScreenPosY - 1 + 0);
    }

    void drawFrame(int n, int n2, int n3, Graphics graphics, DirectGraphics directGraphics) {
        int n4 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(n << 1) + 1] & 0xFF;
        int n5 = this.nAObjectDataType;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            byte by = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 0];
            byte by2 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 1];
            int n8 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 2] & 0xFF;
            byte by3 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 3];
            int n9 = 0;
            if ((this.nFlags & 1) != 0) {
                n7 = n2 - by - (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pModuleTypeAndSize[n8 * 3 + 1] & 0xFF);
                if ((by3 & 1) == 0) {
                    n9 |= 1;
                }
            } else {
                n7 = n2 + by;
                if ((by3 & 1) != 0) {
                    n9 |= 1;
                }
            }
            if ((this.nFlags & 2) != 0) {
                n6 = n3 - by2 - (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pModuleTypeAndSize[n8 * 3 + 2] & 0xFF);
                if ((by3 & 2) == 0) {
                    n9 |= 2;
                }
            } else {
                n6 = n3 + by2;
                if ((by3 & 2) != 0) {
                    n9 |= 2;
                }
            }
            this.pAnimatedObjectData.drawModule(this, n8, n7, n6, n9, graphics, directGraphics);
        }
    }

    void drawFrame(int n, Graphics graphics, DirectGraphics directGraphics) {
        switch (this.nAObjectDataType) {
            case 27: {
                this.drawATPowerBar(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 16: {
                graphics.setClip(0, 0, 176, 208);
                graphics.drawImage(GameCanvasEx.RM_GetResource_Image(96), this.nScreenPosX, this.nScreenPosY, 20);
                break;
            }
            case 24: {
                this.drawATCue(n, this.nScreenPosX, this.nScreenPosY, graphics, directGraphics);
                break;
            }
            case 39: {
                this.drawATString(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 79: {
                this.drawATDialog(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case -1: {
                break;
            }
            case 43: {
                AnimatedObject.drawATView3D(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 55: {
                this.drawATDialogBox(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 60: {
                this.drawATMenuBox(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 61: {
                this.drawATInterfaceBall(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 78: {
                this.drawWidescreenEffect(graphics);
                break;
            }
            case 81: {
                this.drawATColorBox(graphics);
                break;
            }
            case 90: {
                this.drawATOptions(graphics, n);
                break;
            }
            case 83: {
                this.drawATAimingLine(graphics);
                break;
            }
            case 41: {
                this.drawATCursor(graphics, 0x444466, 0x9999CC);
                break;
            }
            case 92: {
                AnimatedObject.drawATPause(graphics, 0x404040);
                break;
            }
            case 82: {
                graphics.setClip(GameCanvasEx.m_pClipAO[0], GameCanvasEx.m_pClipAO[1] - 15, GameCanvasEx.m_pClipAO[2], 15);
                GameCanvasEx.Game_DrawSplashBackGround(77, 0, 0);
                graphics.setClip(GameCanvasEx.m_pClipAO[0], GameCanvasEx.m_pClipAO[1] + GameCanvasEx.m_pClipAO[3], GameCanvasEx.m_pClipAO[2], 15);
                GameCanvasEx.Game_DrawSplashBackGround(77, 0, 0);
                break;
            }
            case 89: {
                GameCanvasEx.Game_FlashingBall(graphics, this.nCurrentFrame);
                break;
            }
            default: {
                this.drawFrame(n, this.nScreenPosX, this.nScreenPosY, graphics, directGraphics);
            }
        }
    }

    static boolean AnimationPlayer_Check(AnimatedObject animatedObject, int n) {
        if (animatedObject == null) {
            return false;
        }
        AnimatedObject animatedObject2 = pRoot[n];
        while (animatedObject2 != null) {
            if (animatedObject == animatedObject2) {
                return true;
            }
            animatedObject2 = animatedObject2.pNext;
        }
        return false;
    }

    static void AnimationPlayer_Play(AnimatedObject animatedObject, int n) {
        if (animatedObject == null) {
            return;
        }
        AnimatedObject animatedObject2 = pRoot[n];
        while (animatedObject2 != null) {
            if (animatedObject == animatedObject2) {
                return;
            }
            animatedObject2 = animatedObject2.pNext;
        }
        if (animatedObject.bUseWiseDraw) {
            animatedObject.bNeedDrawUpdate = true;
        }
        if (pRoot[n] == null) {
            animatedObject.pNext = null;
            AnimatedObject.pRoot[n] = animatedObject;
        } else if (AnimatedObject.pRoot[n].pNext == null) {
            if (animatedObject.nPriority <= AnimatedObject.pRoot[n].nPriority) {
                animatedObject.pNext = pRoot[n];
                AnimatedObject.pRoot[n] = animatedObject;
            } else {
                AnimatedObject.pRoot[n].pNext = animatedObject;
                animatedObject.pNext = null;
            }
        } else if (animatedObject.nPriority <= AnimatedObject.pRoot[n].nPriority) {
            animatedObject.pNext = pRoot[n];
            AnimatedObject.pRoot[n] = animatedObject;
        } else {
            AnimatedObject animatedObject3 = pRoot[n];
            AnimatedObject animatedObject4 = AnimatedObject.pRoot[n].pNext;
            while (animatedObject4 != null) {
                if (animatedObject.nPriority <= animatedObject4.nPriority) {
                    animatedObject3.pNext = animatedObject;
                    animatedObject.pNext = animatedObject4;
                    return;
                }
                animatedObject3 = animatedObject4;
                animatedObject4 = animatedObject4.pNext;
            }
            animatedObject3.pNext = animatedObject;
            animatedObject.pNext = animatedObject4;
        }
    }

    static void AnimationPlayer_Stop(AnimatedObject animatedObject) {
        int n = animatedObject.nLayer;
        AnimatedObject animatedObject2 = pRoot[n];
        if (animatedObject2 == animatedObject) {
            AnimatedObject.pRoot[n] = animatedObject.pNext;
            animatedObject.pNext = null;
            return;
        }
        while (animatedObject2 != null) {
            if (animatedObject2.pNext == animatedObject) {
                animatedObject2.pNext = animatedObject.pNext;
                animatedObject.pNext = null;
                return;
            }
            animatedObject2 = animatedObject2.pNext;
        }
    }

    static void AnimationPlayer_Execute(Graphics graphics, DirectGraphics directGraphics, boolean bl) {
        AnimatedObject.DrawBallsShadows(graphics, directGraphics, bl);
        for (int i = 0; i < 3; ++i) {
            AnimatedObject animatedObject = pRoot[i];
            while (animatedObject != null) {
                boolean bl2 = true;
                if (bl) {
                    if (animatedObject.bUseWiseDraw) {
                        if (graphics != null) {
                            if (GameCanvasEx.m_bRedrawWiseObject || animatedObject.bNeedDrawUpdate) {
                                animatedObject.bNeedDrawUpdate = false;
                            } else {
                                bl2 = false;
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                } else if (animatedObject.bUseWiseDraw) {
                    bl2 = false;
                }
                if (bl2) {
                    if (graphics == null) {
                        switch (animatedObject.nAObjectDataType) {
                            case 27: {
                                animatedObject.nCurrentFrame = (short)(GameCanvasEx.m_fPower_Interface * 138 >> 14);
                                break;
                            }
                            case -1: 
                            case 16: 
                            case 24: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 55: 
                            case 60: 
                            case 61: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 89: 
                            case 90: 
                            case 92: {
                                break;
                            }
                            default: {
                                if (!GameCanvasEx.m_bIsGamePaused) {
                                    animatedObject.play();
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        int n = 0;
                        switch (animatedObject.nAObjectDataType) {
                            case -1: 
                            case 16: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 55: 
                            case 60: 
                            case 61: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 89: 
                            case 90: 
                            case 92: {
                                break;
                            }
                            case 27: {
                                n = GameCanvasEx.m_fPower_Interface * 138 >> 14;
                                break;
                            }
                            case 24: {
                                n = GameCanvasEx.arctan(GameCanvasEx.m_cueTargetDirection[1], GameCanvasEx.m_cueTargetDirection[0]);
                                break;
                            }
                            default: {
                                n = AnimatedObjectData.pStaticAnimatedObjectData[animatedObject.pAnimatedObjectData.nType].pActions[animatedObject.nCurrentAction][1 + animatedObject.nCurrentFrame] & 0xFF;
                            }
                        }
                        animatedObject.drawFrame(n, graphics, directGraphics);
                    }
                }
                animatedObject = animatedObject.pNext;
            }
        }
    }

    static void DrawBallsShadows(Graphics graphics, DirectGraphics directGraphics, boolean bl) {
        if (graphics == null || pRoot == null || pRoot[1] == null) {
            return;
        }
        AnimatedObject animatedObject = pRoot[0];
        while (animatedObject != null) {
            if (animatedObject.nPriority == 1 || animatedObject.nPriority == 2) {
                boolean bl2 = true;
                if (bl) {
                    if (animatedObject.bUseWiseDraw) {
                        if (!GameCanvasEx.m_bRedrawWiseObject && !animatedObject.bNeedDrawUpdate) {
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                    }
                } else if (animatedObject.bUseWiseDraw) {
                    bl2 = false;
                }
                if (animatedObject.nAObjectDataType == 0) {
                    if (graphics != GameCanvasEx.g_graBackBuffer && GameMidlet.Instance_Game.SM_Game_state[GameMidlet.Instance_Game.SM_Game_depth] != 21 && GameMidlet.Instance_Game.SM_Game_state[GameMidlet.Instance_Game.SM_Game_depth] != 20) {
                        bl2 = false;
                    } else if (graphics == GameCanvasEx.g_graBackBuffer && !GameCanvasEx.bCueBallShadowLock && GameMidlet.Instance_Game.SM_Game_state[GameMidlet.Instance_Game.SM_Game_depth] == 9) {
                        GameCanvasEx.bCueBallShadowLock = true;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    int n = GameCanvasEx.m_tableOffset_X + 15;
                    int n2 = GameCanvasEx.m_tableOffset_Y + 13;
                    int n3 = 88;
                    int n4 = 180;
                    graphics.setClip(n, n2, n3, n4);
                    graphics.setColor(GameCanvasEx.s_iShadowColor);
                    graphics.fillArc(animatedObject.nScreenPosX - 1, animatedObject.nScreenPosY - 1, 6, 6, 0, 360);
                    for (int i = 0; i < 6; ++i) {
                        if (Math.abs(animatedObject.nScreenPosX - (GameCanvasEx.m_tableOffset_X + (GameCanvasEx.m_pPockets[i].x >> 14))) >= 12 || Math.abs(animatedObject.nScreenPosY - (-GameCanvasEx.m_pPockets[i].y >> 14)) >= 12) continue;
                        graphics.setClip(animatedObject.nScreenPosX - 1, animatedObject.nScreenPosY - 1, 6, 6);
                        graphics.setColor(0);
                        graphics.fillArc(GameCanvasEx.m_tableOffset_X + (GameCanvasEx.m_pPockets[i].x >> 14) - 6 + 1, GameCanvasEx.m_tableOffset_Y + ((-GameCanvasEx.m_pPockets[i].y >> 14) - 6) + 1, 12, 12, 0, 360);
                    }
                }
            }
            animatedObject = animatedObject.pNext;
        }
    }

    static void Game_DrawInterface() {
        GameCanvasEx.g_graBackBuffer.setClip(0, 0, 176, 208);
        Image image = GameCanvasEx.RM_GetResource_Image(186);
        Image image2 = GameCanvasEx.RM_GetResource_Image(185);
        GameCanvasEx.g_graBackBuffer.drawImage(image, GameCanvasEx.m_tableOffset_X - 58, GameCanvasEx.m_tableOffset_Y, 20);
        GameCanvasEx.g_graBackBuffer.drawImage(image2, GameCanvasEx.m_tableOffset_X + 118, GameCanvasEx.m_tableOffset_Y, 20);
    }

    static void Game_AimingLineSetShotParams() {
        GameCanvasEx.m_nbCollisions = 0;
        GameCanvasEx.m_pCueBall.pCopy.jumpTimeLeft = 0;
        GameCanvasEx.m_pCueBall.pCopy.jumpStep = 0;
        GameCanvasEx.Vector2D_setTo3(GameCanvasEx.m_pCueBall.pCopy.XY_spin, 0, 0);
        GameCanvasEx.m_pCueBall.pCopy.Z_spin_ratio = 0;
        if (GameCanvasEx.m_pCueBall.pCopy.speed != 0) {
            GameCanvasEx.m_pCueBall.pCopy.speed = 1228800;
        }
    }

    static void Game_DrawAimingLines(Graphics graphics, boolean bl) {
        int n;
        int n2;
        if (GameCanvasEx.m_bRecalculateCueLine) {
            n2 = 0;
            n = 1000;
            GameCanvasEx.m_bDrawGhost = false;
            AnimatedObject.Game_AimingLineSetShotParams();
            graphics.setClip(0, 0, 176, 208);
            PhysicalObject.g_iBallsMovingInFrame = 1;
            while (PhysicalObject.g_iBallsMovingInFrame != 0 && n2 < 1) {
                PhysicalObject.g_iBallsMovingInFrame = 0;
                if ((n = PhysicalObject.PhysicEngine_updateBallsToFirstCollision(PhysicalObject.PhysicEngine_pRootBalls_sim, n, true)) >= 0) {
                    if (PhysicalObject.PhysicEngine_pCollidingObject.type == 1) {
                        GameCanvasEx.m_pCueAimingBallHit = PhysicalObject.PhysicEngine_pCollidingBall;
                        GameCanvasEx.m_iCueAimingBallVisorX = GameCanvasEx.fixed_add(GameCanvasEx.m_pCueAimingBallHit.x, GameCanvasEx.m_pCueAimingBallHit.direction[0] * 14) >> 14;
                        GameCanvasEx.m_iCueAimingBallVisorY = -GameCanvasEx.fixed_add(GameCanvasEx.m_pCueAimingBallHit.y, GameCanvasEx.m_pCueAimingBallHit.direction[1] * 14) >> 14;
                    } else {
                        GameCanvasEx.m_pCueAimingBallHit = null;
                    }
                    if (PhysicalObject.PhysicEngine_pCollidingObject.type == 1 || PhysicalObject.PhysicEngine_pCollidingObject.type == 8 || PhysicalObject.PhysicEngine_pCollidingObject.type == 16) {
                        GameCanvasEx.m_bDrawGhost = true;
                    } else {
                        n2 = 1;
                    }
                    ++n2;
                    continue;
                }
                n = 1000;
            }
            GameCanvasEx.m_bRecalculateCueLine = false;
            GameCanvasEx.m_iLastCueTargetX = GameCanvasEx.m_pCueBall.pCopy.x >> 14;
            GameCanvasEx.m_iLastCueTargetY = (-GameCanvasEx.m_pCueBall.pCopy.y >> 14) + 1;
            PhysicalObject physicalObject = GameCanvasEx.m_pCueBall.pCopy;
            if (physicalObject.speed > 16384) {
                GameCanvasEx.m_iCueAimingVisorX = GameCanvasEx.fixed_add(physicalObject.x, physicalObject.direction[0] * 14) >> 14;
                GameCanvasEx.m_iCueAimingVisorY = (-GameCanvasEx.fixed_add(physicalObject.y, physicalObject.direction[1] * 14) >> 14) + 1;
            } else {
                GameCanvasEx.m_iCueAimingVisorX = GameCanvasEx.m_iLastCueTargetX;
                GameCanvasEx.m_iCueAimingVisorY = GameCanvasEx.m_iLastCueTargetY;
            }
        }
        if (bl) {
            graphics.setClip(0, 0, 176, 208);
            n2 = GameCanvasEx.m_iLastCueTargetX - 3 + GameCanvasEx.m_tableOffset_X;
            n = GameCanvasEx.m_iLastCueTargetY - 3 + GameCanvasEx.m_tableOffset_Y - 1;
            graphics.setColor(GameCanvasEx.m_colorBalls[0]);
            graphics.drawLine(GameCanvasEx.m_pCueBall.m_animObject.nScreenPosX, GameCanvasEx.m_pCueBall.m_animObject.nScreenPosY, GameCanvasEx.m_iLastCueTargetX + GameCanvasEx.m_tableOffset_X, GameCanvasEx.m_iLastCueTargetY + GameCanvasEx.m_tableOffset_Y);
            if (GameCanvasEx.m_bDrawGhost) {
                graphics.setColor(GameCanvasEx.m_colorBalls[0]);
                graphics.drawLine(GameCanvasEx.m_iCueAimingVisorX + GameCanvasEx.m_tableOffset_X, GameCanvasEx.m_iCueAimingVisorY + GameCanvasEx.m_tableOffset_Y, GameCanvasEx.m_iLastCueTargetX + GameCanvasEx.m_tableOffset_X, GameCanvasEx.m_iLastCueTargetY + GameCanvasEx.m_tableOffset_Y);
                if (GameCanvasEx.m_pCueAimingBallHit != null) {
                    int n3 = GameCanvasEx.m_pCueAimingBallHit.m_type;
                    if (GameCanvasEx.m_nRules == 1 && n3 != 8) {
                        int n4 = n3 = n3 < 8 ? 1 : 3;
                    }
                    if (n3 <= 8 && bl) {
                        graphics.setColor(GameCanvasEx.m_colorBalls[n3]);
                        graphics.drawLine(GameCanvasEx.m_iCueAimingBallVisorX + GameCanvasEx.m_tableOffset_X, GameCanvasEx.m_iCueAimingBallVisorY + GameCanvasEx.m_tableOffset_Y, GameCanvasEx.m_pCueAimingBallHit.m_animObject.nScreenPosX, GameCanvasEx.m_pCueAimingBallHit.m_animObject.nScreenPosY);
                    } else if (bl) {
                        int[] nArray = new int[]{3, GameCanvasEx.m_colorBalls[0], 3, GameCanvasEx.m_colorBalls[n3]};
                        GameCanvasEx.DrawMultiColoredLine(graphics, GameCanvasEx.m_iCueAimingBallVisorX + GameCanvasEx.m_tableOffset_X, GameCanvasEx.m_iCueAimingBallVisorY + GameCanvasEx.m_tableOffset_Y, GameCanvasEx.m_pCueAimingBallHit.m_animObject.nScreenPosX, GameCanvasEx.m_pCueAimingBallHit.m_animObject.nScreenPosY, nArray, false);
                        nArray = null;
                    }
                }
                graphics.setClip(0, 0, 176, 208);
                graphics.setColor(GameCanvasEx.readIntBigEndian(GameCanvasEx.s_pTableColors, GameCanvasEx.s_iTableColor << 2));
                graphics.fillArc(n2 + 1, n + 2, GameCanvasEx.s_nAimingGhostDiameter - 1, GameCanvasEx.s_nAimingGhostDiameter - 1, 0, 360);
                graphics.setColor(0xFFFFFF);
                graphics.drawArc(n2, n + 1, GameCanvasEx.s_nAimingGhostDiameter, GameCanvasEx.s_nAimingGhostDiameter, 0, 360);
            }
        }
        GameCanvasEx.m_pCueBall.pCopy.speed = 0;
    }

    static void Game_LoadCueColor(int n) {
        int n2;
        if (m_cueColorLight[n] != null && m_cueColorDark[n] != null) {
            return;
        }
        if (GameCanvasEx.s_pCueColorsData == null) {
            GameCanvasEx.RM_Load(21);
            GameCanvasEx.RM_Synchronize(-1);
            GameCanvasEx.s_pCueColorsData = GameCanvasEx.RM_GetResource_Array_Byte(21);
        }
        int n3 = n * 24;
        short[] sArray = new short[6];
        for (n2 = 0; n2 < 6; ++n2) {
            int n4 = GameCanvasEx.readIntBigEndian(GameCanvasEx.s_pCueColorsData, n3);
            sArray[n2] = (short)((n4 & 0xF00000) >> 12 | (n4 & 0xF000) >> 8 | (n4 & 0xF0) >> 4);
            n3 += 4;
        }
        AnimatedObject.m_cueColorLight[n] = new short[14];
        AnimatedObject.m_cueColorDark[n] = new short[14];
        n2 = 0;
        AnimatedObject.m_cueColorLight[n][n2] = 1;
        AnimatedObject.m_cueColorDark[n][n2] = 1;
        AnimatedObject.m_cueColorLight[n][++n2] = 0;
        AnimatedObject.m_cueColorDark[n][n2] = 0;
        AnimatedObject.m_cueColorLight[n][++n2] = 1;
        AnimatedObject.m_cueColorDark[n][n2] = 1;
        AnimatedObject.m_cueColorLight[n][++n2] = sArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = sArray[5];
        AnimatedObject.m_cueColorLight[n][++n2] = 71;
        AnimatedObject.m_cueColorDark[n][n2] = 71;
        AnimatedObject.m_cueColorLight[n][++n2] = sArray[0];
        AnimatedObject.m_cueColorDark[n][n2] = sArray[1];
        AnimatedObject.m_cueColorLight[n][++n2] = 1;
        AnimatedObject.m_cueColorDark[n][n2] = 1;
        AnimatedObject.m_cueColorLight[n][++n2] = sArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = sArray[5];
        AnimatedObject.m_cueColorLight[n][++n2] = 34;
        AnimatedObject.m_cueColorDark[n][n2] = 34;
        AnimatedObject.m_cueColorLight[n][++n2] = sArray[2];
        AnimatedObject.m_cueColorDark[n][n2] = sArray[3];
        AnimatedObject.m_cueColorLight[n][++n2] = 1;
        AnimatedObject.m_cueColorDark[n][n2] = 1;
        AnimatedObject.m_cueColorLight[n][++n2] = sArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = sArray[5];
        AnimatedObject.m_cueColorLight[n][++n2] = 1;
        AnimatedObject.m_cueColorDark[n][n2] = 1;
        AnimatedObject.m_cueColorLight[n][++n2] = 0;
        AnimatedObject.m_cueColorDark[n][n2] = 0;
        sArray = null;
    }
}

