/*
 * Decompiled with CFR 0.152.
 */
class PhysicalObject {
    int m_type;
    PhysicalObject _pNext;
    AnimatedObject m_animObject;
    static int s_cueAlphaCumul;
    boolean m_inactive;
    int m_timeAnimBallInPocket = 3;
    int type;
    PhysicalObject pNext;
    PhysicalObject pCopy;
    int x;
    int y;
    int[] direction;
    int speed;
    boolean bDesactivated;
    int[] deltaPosition;
    int[] XY_spin;
    int Z_spin_ratio;
    int jumpTimeLeft;
    int jumpStep;
    PhysicalObject pPocketCollide;
    int[] point0;
    int[] point1;
    static int g_iBallsMovingInFrame;
    static PhysicalObject PhysicEngine_pRootBalls;
    static PhysicalObject PhysicEngine_pRootBalls_sim;
    static PhysicalObject PhysicEngine_pRootCushionsEdge;
    static PhysicalObject PhysicEngine_pRootCushionsVertex;
    static PhysicalObject PhysicEngine_pRootPockets;
    static PhysicalObject PhysicEngine_pRootOutOfBounds;
    static PhysicalObject PhysicEngine_pRootTable;
    static PhysicalObject PhysicEngine_pCollidingBall;
    static PhysicalObject PhysicEngine_pCollidingObject;
    static PhysicalObject[] PhysicEngine_CushionsEdge;
    static PhysicalObject[] PhysicEngine_CushionsEdgeVertical;
    static PhysicalObject[] PhysicEngine_CushionsEdgeHorizontal;
    static PhysicalObject[] PhysicEngine_CushionsVertex;
    static int PhysicEngine_CushionCollisionsToCheck;
    static int[] m_pFindFirstCollisionResultTime;
    static PhysicalObject[][] m_pFindFirstCollisionResultPhysicalObject;
    static int m_iFindFirstCollisionBallsToUpdate;
    static int m_iFindFirstCollisionListCurrentSize;
    static int m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate;

    public void update() {
        if (this.type == 1) {
            if (this.jumpTimeLeft > 0) {
                this.m_animObject.changePriority(2, -1);
                if (this.jumpTimeLeft > this.jumpStep << 1) {
                    this.m_animObject.setCurrentAction(3);
                } else if (this.jumpTimeLeft > this.jumpStep) {
                    this.m_animObject.setCurrentAction(4);
                } else {
                    this.m_animObject.setCurrentAction(3);
                }
            } else if (this.bDesactivated) {
                if (!this.m_inactive) {
                    this.doAnimBallInPocket();
                }
            } else if (this.speed != 0 || this.XY_spin[0] != 0 || this.XY_spin[1] != 0) {
                if (this.m_animObject.nCurrentAction != 0) {
                    this.m_animObject.setCurrentAction(0);
                }
            } else if (this.m_animObject.nCurrentAction == 0 || this.m_type == 0 && this.m_animObject.nCurrentAction != 2) {
                this.m_animObject.setCurrentAction(this.m_type > 8 ? (GameCanvasEx._rand.nextInt() & 3) + 2 : 2);
            }
            this.m_animObject.setPosition((this.x >> 14) + GameCanvasEx.m_tableOffset_X, -(this.y >> 14) + GameCanvasEx.m_tableOffset_Y);
        } else if (this.m_type == 66) {
            switch (this.m_animObject.nCurrentAction) {
                case 0: {
                    int n = ((GameCanvasEx.m_pBallMovedByHand.x >> 14) + GameCanvasEx.m_tableOffset_X - this.m_animObject.nScreenPosX) / 3;
                    int n2 = (-(GameCanvasEx.m_pBallMovedByHand.y >> 14) - this.m_animObject.nScreenPosY + GameCanvasEx.m_tableOffset_Y) / 3;
                    this.m_animObject.setPosition(this.m_animObject.nScreenPosX + n, this.m_animObject.nScreenPosY + n2);
                    if (n != 0 || n2 != 0) break;
                    GameCanvasEx.m_pBallMovedByHand.m_animObject.bUseWiseDraw = false;
                    this.m_animObject.setPosition((GameCanvasEx.m_pBallMovedByHand.x >> 14) + GameCanvasEx.m_tableOffset_X, -(GameCanvasEx.m_pBallMovedByHand.y >> 14) + GameCanvasEx.m_tableOffset_Y);
                    this.m_animObject.setCurrentAction(1);
                    break;
                }
                case 1: {
                    GameCanvasEx.m_pBallMovedByHand.m_animObject.bUseWiseDraw = false;
                    if (!GameCanvasEx.m_bIsHandFinisedAnim) {
                        int n = ((GameCanvasEx.m_pBallMovedByHand.point0[0] >> 14) + GameCanvasEx.m_tableOffset_X - this.m_animObject.nScreenPosX) / 3;
                        int n3 = (-(GameCanvasEx.m_pBallMovedByHand.point0[1] >> 14) - this.m_animObject.nScreenPosY + GameCanvasEx.m_tableOffset_Y) / 3;
                        GameCanvasEx.m_pBallMovedByHand.setPosition(GameCanvasEx.m_pBallMovedByHand.x + (n << 14), GameCanvasEx.m_pBallMovedByHand.y + (-n3 << 14));
                        if (GameCanvasEx.m_pBallMovedByHand != null && this.m_animObject != null) {
                            this.m_animObject.setPosition((GameCanvasEx.m_pBallMovedByHand.x >> 14) + GameCanvasEx.m_tableOffset_X, -(GameCanvasEx.m_pBallMovedByHand.y >> 14) + GameCanvasEx.m_tableOffset_Y);
                        }
                        if (n != 0 || n3 != 0) break;
                        GameCanvasEx.m_pBallMovedByHand.setPosition(GameCanvasEx.m_pBallMovedByHand.point0[0], GameCanvasEx.m_pBallMovedByHand.point0[1]);
                        GameCanvasEx.m_bIsHandFinisedAnim = true;
                        break;
                    }
                    this.m_animObject.setPosition((GameCanvasEx.m_pBallMovedByHand.x >> 14) + GameCanvasEx.m_tableOffset_X, -(GameCanvasEx.m_pBallMovedByHand.y >> 14) + GameCanvasEx.m_tableOffset_Y);
                }
            }
        } else if (this.type == 512) {
            switch (this.m_animObject.nCurrentAction) {
                case 3: {
                    this.m_animObject.bUseWiseDraw = false;
                    GameCanvasEx.m_cueDistanceFromBall += 32768;
                    break;
                }
                case 5: {
                    this.m_animObject.bUseWiseDraw = false;
                    GameCanvasEx.m_cueDistanceFromBall = 131072;
                    GameCanvasEx.m_cueDistanceFromBall = GameCanvasEx.m_fPower_Effective * 46 + 131072;
                    break;
                }
                case 4: {
                    if ((GameCanvasEx.m_cueDistanceFromBall -= GameCanvasEx.s_bIsBigSwing ? 0x190000 : 245760) >= 53248) break;
                    GameCanvasEx.m_cueDistanceFromBall = 53248;
                    break;
                }
                case 8: {
                    this.m_animObject.bUseWiseDraw = false;
                    if ((GameCanvasEx.m_cueDistanceFromBall -= 81920) >= 53248) break;
                    GameCanvasEx.m_cueDistanceFromBall = 53248;
                    break;
                }
                case 9: {
                    this.m_animObject.bUseWiseDraw = false;
                    GameCanvasEx.m_cueDistanceFromBall += 81920;
                    break;
                }
                case 10: {
                    this.m_animObject.nCurrentAction = 11;
                    this.m_animObject.bUseWiseDraw = false;
                    AnimatedObject.m_cueAlpha = (short)(15 - ((s_cueAlphaCumul += (int)(((long)(GameCanvasEx.m_iTimeDiff * 15 << 14) << 28) / 0xBB8000L >> 14)) >> 14));
                    if ((GameCanvasEx.m_fadeOutTimeLeft -= GameCanvasEx.m_iTimeDiff) > 0 && AnimatedObject.m_cueAlpha > 0) break;
                    AnimatedObject.m_cueAlpha = 0;
                    s_cueAlphaCumul = 0;
                    this.m_animObject.nCurrentAction = 11;
                }
            }
            if (this.m_animObject.nCurrentAction != 10 && this.m_animObject.nCurrentAction != 11) {
                int[] nArray = GameCanvasEx.new1_Vector2D(GameCanvasEx.m_cueTargetDirection);
                GameCanvasEx.Vector2D_normalize(nArray);
                GameCanvasEx.Vector2D_mul(nArray, -GameCanvasEx.m_cueDistanceFromBall);
                this.m_animObject.setPosition((GameCanvasEx.m_pCueBall.x + nArray[0] >> 14) + GameCanvasEx.m_tableOffset_X, -(GameCanvasEx.m_pCueBall.y + nArray[1] >> 14) + GameCanvasEx.m_tableOffset_Y);
            }
        }
    }

    void doAnimBallInPocket() {
        if (this.m_animObject.nCurrentAction == 1) {
            if (!this.m_inactive && this.m_animObject.isEndOfAnimation()) {
                this.m_inactive = true;
                this.m_animObject.removeFromDrawList();
            }
        } else if (this.pPocketCollide == null || this.IsBallFullyInsidePocket()) {
            this.m_animObject.setCurrentAction(1);
        } else {
            int n = this.pPocketCollide.x - this.x;
            int n2 = this.pPocketCollide.y - this.y;
            this.x += n >> 1;
            this.y += n2 >> 1;
        }
    }

    boolean IsBallFullyInsidePocket() {
        int n;
        int[] nArray = new int[]{this.pPocketCollide.x - this.x, this.pPocketCollide.y - this.y};
        int n2 = GameCanvasEx.Vector2D_squareLengthOf(nArray);
        return n2 < (n = GameCanvasEx.fixed_square(45056));
    }

    PhysicalObject(int n, AnimatedObject animatedObject) {
        this.type = n;
        switch (this.type) {
            case 1: {
                this.direction = GameCanvasEx.new2_Vector2D(0, 0);
                this.deltaPosition = new int[2];
                this.XY_spin = new int[2];
                this.point0 = new int[2];
                this.point1 = new int[2];
                this.pNext = PhysicEngine_pRootBalls;
                PhysicEngine_pRootBalls = this;
                this.pCopy = new PhysicalObject(this);
                this.pCopy.pNext = PhysicEngine_pRootBalls_sim;
                PhysicEngine_pRootBalls_sim = this.pCopy;
                break;
            }
            case 2: {
                this.point0 = new int[2];
                this.pNext = PhysicEngine_pRootPockets;
                PhysicEngine_pRootPockets = this;
                break;
            }
            case 8: {
                this.point0 = new int[2];
                this.point1 = new int[2];
                this.direction = GameCanvasEx.new2_Vector2D(0, 0);
                this.pNext = PhysicEngine_pRootCushionsEdge;
                PhysicEngine_pRootCushionsEdge = this;
                break;
            }
            case 16: {
                this.pNext = PhysicEngine_pRootCushionsVertex;
                PhysicEngine_pRootCushionsVertex = this;
                break;
            }
            case 128: {
                this.pNext = PhysicEngine_pRootOutOfBounds;
                PhysicEngine_pRootOutOfBounds = this;
                break;
            }
            case 512: {
                this.point0 = new int[2];
                this.point1 = new int[2];
            }
        }
        if (animatedObject != null) {
            this.m_animObject = animatedObject;
            this.m_type = this.m_animObject.nAObjectDataType;
        }
    }

    PhysicalObject(PhysicalObject physicalObject) {
        this.m_animObject = physicalObject.m_animObject;
        this._pNext = physicalObject._pNext;
        this.m_inactive = physicalObject.m_inactive;
        this.m_timeAnimBallInPocket = physicalObject.m_timeAnimBallInPocket;
        this.type = physicalObject.type;
        this.x = physicalObject.x;
        this.y = physicalObject.y;
        this.bDesactivated = physicalObject.bDesactivated;
        this.jumpTimeLeft = physicalObject.jumpTimeLeft;
        this.jumpStep = physicalObject.jumpStep;
        this.Z_spin_ratio = physicalObject.Z_spin_ratio;
        this.pPocketCollide = physicalObject.pPocketCollide;
        this.speed = physicalObject.speed;
        if (physicalObject.direction != null) {
            this.direction = GameCanvasEx.new1_Vector2D(physicalObject.direction);
        }
        if (physicalObject.deltaPosition != null) {
            this.deltaPosition = GameCanvasEx.new1_Vector2D(physicalObject.deltaPosition);
        }
        if (physicalObject.XY_spin != null) {
            this.XY_spin = GameCanvasEx.new1_Vector2D(physicalObject.XY_spin);
        }
        if (physicalObject.point0 != null) {
            this.point0 = GameCanvasEx.new1_Vector2D(physicalObject.point0);
        }
        if (physicalObject.point1 != null) {
            this.point1 = GameCanvasEx.new1_Vector2D(physicalObject.point1);
        }
    }

    void setTo(PhysicalObject physicalObject) {
        int n;
        if (this.type != physicalObject.type) {
            System.out.println("Assert failed: Cannot set object " + this + " to object " + physicalObject + ": members type are not the same.");
            n = 1 / 0;
        }
        this.m_type = physicalObject.m_type;
        this.m_animObject = physicalObject.m_animObject;
        this._pNext = physicalObject._pNext;
        this.m_inactive = physicalObject.m_inactive;
        this.m_timeAnimBallInPocket = physicalObject.m_timeAnimBallInPocket;
        this.type = physicalObject.type;
        this.x = physicalObject.x;
        this.y = physicalObject.y;
        switch (this.type) {
            case 1: {
                this.speed = physicalObject.speed;
                this.direction[0] = physicalObject.direction[0];
                this.direction[1] = physicalObject.direction[1];
                this.bDesactivated = physicalObject.bDesactivated;
                this.jumpTimeLeft = physicalObject.jumpTimeLeft;
                this.jumpStep = physicalObject.jumpStep;
                this.Z_spin_ratio = physicalObject.Z_spin_ratio;
                this.pPocketCollide = physicalObject.pPocketCollide;
                this.deltaPosition[0] = physicalObject.deltaPosition[0];
                this.deltaPosition[1] = physicalObject.deltaPosition[1];
                this.XY_spin[0] = physicalObject.XY_spin[0];
                this.XY_spin[1] = physicalObject.XY_spin[1];
                break;
            }
            default: {
                System.out.println("Assert failed: PhysicalObject.setTo(PhysicalObject) not implemented for type " + this.type);
                n = 1 / 0;
            }
        }
    }

    void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    void computeMove(int n) {
        if (this.jumpTimeLeft == 0) {
            this.deltaPosition[0] = GameCanvasEx.fixed_mul(this.direction[0], this.speed) * n >> 10;
            this.deltaPosition[1] = GameCanvasEx.fixed_mul(this.direction[1], this.speed) * n >> 10;
        } else {
            if (this.jumpTimeLeft <= n) {
                this.jumpTimeLeft = 0;
                this.jumpStep = 0;
                PhysicalObject physicalObject = PhysicEngine_pRootPockets;
                while (physicalObject != null) {
                    if (PhysicalObject.PhysicEngine_getPocketCollision(this.jumpTimeLeft, GameCanvasEx.m_pCueBall, physicalObject) == 0) {
                        GameCanvasEx.Game_NotifyCollision(GameCanvasEx.m_pCueBall, physicalObject);
                        PhysicalObject.doCollisionPocket(GameCanvasEx.m_pCueBall, physicalObject);
                        this.bDesactivated = true;
                        break;
                    }
                    physicalObject = physicalObject.pNext;
                }
                if (!this.bDesactivated) {
                    if (this.x - 53248 < 245760 || this.x + 53248 > 1687552 || -this.y - 53248 < 212992 || -this.y + 53248 > 0x300000) {
                        this.speed = 0;
                        GameCanvasEx.Game_NotifyCollision(GameCanvasEx.m_pCueBall, PhysicEngine_pRootOutOfBounds);
                        this.bDesactivated = true;
                    } else {
                        GameCanvasEx.Game_NotifyCollision(GameCanvasEx.m_pCueBall, PhysicEngine_pRootTable);
                        this.speed >>= 1;
                    }
                }
            } else {
                this.jumpTimeLeft -= n;
            }
            this.deltaPosition[0] = GameCanvasEx.fixed_mul(this.direction[0], this.speed) / 3 * n >> 10;
            this.deltaPosition[1] = GameCanvasEx.fixed_mul(this.direction[1], this.speed) / 3 * n >> 10;
        }
    }

    void doMove(int n) {
        this.x += this.deltaPosition[0];
        this.y += this.deltaPosition[1];
        int n2 = n << 14 >> 10;
        if (this.speed != 0) {
            this.speed -= GameCanvasEx.fixed_mul(196608, n2);
            if (this.speed < 16384) {
                this.speed = 0;
                this.deltaPosition[0] = 0;
                this.deltaPosition[1] = 0;
            }
        }
        if (this.XY_spin[0] != 0 || this.XY_spin[1] != 0) {
            int[] nArray;
            int n3 = GameCanvasEx.Vector2D_lengthOf(this.XY_spin);
            if (n3 != 0) {
                nArray = new int[]{-this.XY_spin[0], -this.XY_spin[1]};
                GameCanvasEx.Vector2D_div(nArray, n3);
                int n4 = GameCanvasEx.fixed_mul(2457600, n2);
                GameCanvasEx.Vector2D_mul(nArray, n4);
                if (n4 > n3) {
                    this.XY_spin[0] = 0;
                    this.XY_spin[1] = 0;
                } else {
                    GameCanvasEx.Vector2D_add(this.XY_spin, nArray);
                }
            } else {
                this.XY_spin[0] = 0;
                this.XY_spin[1] = 0;
            }
            nArray = new int[]{this.XY_spin[0], this.XY_spin[1]};
            GameCanvasEx.Vector2D_mul(nArray, n2);
            GameCanvasEx.Vector2D_mul(this.direction, this.speed);
            GameCanvasEx.Vector2D_add(this.direction, nArray);
            this.speed = GameCanvasEx.Vector2D_lengthOf(this.direction);
            if (this.speed != 0) {
                GameCanvasEx.Vector2D_div(this.direction, this.speed);
            }
        }
    }

    boolean isMoving() {
        return this.speed != 0 || this.XY_spin[0] != 0 || this.XY_spin[1] != 0;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                int n = this.m_type;
                return "Ball " + (n == 0 ? "cue" : Integer.toString(n));
            }
            case 2: {
                return "Pocket";
            }
            case 8: {
                return "Cushion";
            }
            case 16: {
                return "Cushion corner";
            }
            case 128: {
                return "Out of table";
            }
        }
        return "Unknown type" + this.type;
    }

    static void PhysicEngine_update(int n) {
        PhysicalObject.PhysicEngine_updateBalls(PhysicEngine_pRootBalls, n);
    }

    static void PhysicEngine_ResetCollisionList() {
        m_iFindFirstCollisionBallsToUpdate = -1;
        m_iFindFirstCollisionListCurrentSize = 0;
        m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate = -1;
    }

    static void PhysicEngine_updateBalls(PhysicalObject physicalObject, int n) {
        int n2 = n;
        PhysicalObject.PhysicEngine_ResetCollisionList();
        while (n2 > 0) {
            PhysicalObject physicalObject2 = physicalObject;
            while (physicalObject2 != null) {
                physicalObject2.computeMove(n2);
                physicalObject2 = physicalObject2.pNext;
            }
            PhysicalObject.PhysicEngine_findFirstCollision(physicalObject, n2, true, true, true);
            int n3 = m_pFindFirstCollisionResultTime[0];
            PhysicEngine_pCollidingBall = m_pFindFirstCollisionResultPhysicalObject[0][0];
            PhysicEngine_pCollidingObject = m_pFindFirstCollisionResultPhysicalObject[0][1];
            boolean bl = m_iFindFirstCollisionListCurrentSize > 0 && n3 <= n2;
            physicalObject2 = physicalObject;
            while (physicalObject2 != null) {
                if (bl) {
                    physicalObject2.computeMove(n3);
                    physicalObject2.doMove(n3);
                } else {
                    physicalObject2.doMove(n2);
                    physicalObject2.update();
                }
                physicalObject2 = physicalObject2.pNext;
            }
            if (!bl) break;
            GameCanvasEx.Game_NotifyCollision(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
            switch (PhysicalObject.PhysicEngine_pCollidingObject.type) {
                case 1: {
                    PhysicalObject.doCollisionBall(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 8: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 64: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 32: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 16: {
                    PhysicalObject.doCollisionCushionVertex(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 2: {
                    PhysicalObject.doCollisionPocket(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                default: {
                    System.out.println("Unknown colliding object physical type");
                }
            }
            if (m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate != -1 && --m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate == 0) {
                PhysicalObject.PhysicEngine_ResetCollisionList();
                n2 -= n3;
                continue;
            }
            m_iFindFirstCollisionBallsToUpdate = 1 << PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[0][0].m_type;
            if (PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[0][1].type == 1) {
                m_iFindFirstCollisionBallsToUpdate |= 1 << PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[0][1].m_type;
            }
            PhysicalObject physicalObject3 = m_pFindFirstCollisionResultPhysicalObject[0][0];
            PhysicalObject physicalObject4 = m_pFindFirstCollisionResultPhysicalObject[0][1];
            int n4 = 0;
            int n5 = m_iFindFirstCollisionListCurrentSize;
            for (int i = 0; i < n5; ++i) {
                ++n4;
                while (n4 < n5 && (m_pFindFirstCollisionResultPhysicalObject[n4][1] == physicalObject3 || physicalObject4.type == 1 && (m_pFindFirstCollisionResultPhysicalObject[n4][0] == physicalObject4 || m_pFindFirstCollisionResultPhysicalObject[n4][1] == physicalObject4))) {
                    ++n4;
                    --m_iFindFirstCollisionListCurrentSize;
                }
                if (n4 == n5) {
                    while (i < n5) {
                        PhysicalObject.m_pFindFirstCollisionResultTime[i] = Integer.MAX_VALUE;
                        ++i;
                    }
                    break;
                }
                PhysicalObject.m_pFindFirstCollisionResultTime[i] = m_pFindFirstCollisionResultTime[n4] - n3;
                PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[i][0] = m_pFindFirstCollisionResultPhysicalObject[n4][0];
                PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[i][1] = m_pFindFirstCollisionResultPhysicalObject[n4][1];
            }
            --m_iFindFirstCollisionListCurrentSize;
            n2 -= n3;
        }
    }

    static void traceCushionCollisionFlag() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 23; i >= 0; --i) {
            if (i == 5 || i == 11) {
                stringBuffer.append("|");
            }
            stringBuffer.append(PhysicEngine_CushionCollisionsToCheck >> i & 1);
        }
        System.out.println("PhysicEngine_CushionCollisionsToCheck: " + stringBuffer.toString());
    }

    static void BuildTableCushionCollisionFlag(PhysicalObject physicalObject) {
        PhysicEngine_CushionCollisionsToCheck = 0xFFFFFF;
        int n = physicalObject.x + 53248;
        int n2 = physicalObject.x - 53248;
        int n3 = physicalObject.y + 53248;
        int n4 = physicalObject.y - 53248;
        PhysicEngine_CushionCollisionsToCheck = physicalObject.direction[0] < 0 ? (PhysicEngine_CushionCollisionsToCheck &= n < PhysicalObject.PhysicEngine_CushionsVertex[1].x ? 16260728 : 0xFFFE7F) : (PhysicEngine_CushionCollisionsToCheck &= n2 > PhysicalObject.PhysicEngine_CushionsVertex[0].x ? 517063 : 0xFFF3FF);
        PhysicEngine_CushionCollisionsToCheck = physicalObject.direction[1] < 0 ? (n3 < PhysicalObject.PhysicEngine_CushionsVertex[4].y ? (PhysicEngine_CushionCollisionsToCheck &= 0x1E070C) : (n3 < PhysicalObject.PhysicEngine_CushionsVertex[3].y ? (PhysicEngine_CushionCollisionsToCheck &= 0x3F071E) : (n3 < PhysicalObject.PhysicEngine_CushionsVertex[2].y ? (PhysicEngine_CushionCollisionsToCheck &= 0x7F8F9E) : (PhysicEngine_CushionCollisionsToCheck &= 0xFFFFBF)))) : (n4 > PhysicalObject.PhysicEngine_CushionsVertex[3].y ? (PhysicEngine_CushionCollisionsToCheck &= 0x8078E1) : (n4 > PhysicalObject.PhysicEngine_CushionsVertex[4].y ? (PhysicEngine_CushionCollisionsToCheck &= 0xC0F8F3) : (n4 > PhysicalObject.PhysicEngine_CushionsVertex[5].y ? (PhysicEngine_CushionCollisionsToCheck &= 0xE1FDF3) : (PhysicEngine_CushionCollisionsToCheck &= 0xFFFDFF))));
    }

    static void PhysicEngine_findFirstCollisionAddResult(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n2 = m_iFindFirstCollisionListCurrentSize - 1;
        if (m_iFindFirstCollisionListCurrentSize == 7) {
            if (m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate == -1) {
                m_iFindFirstCollisionNbOfUpdatesBeforeCompleteUpdate = 7;
            }
            if (n < m_pFindFirstCollisionResultTime[n2]) {
                --n2;
            } else {
                return;
            }
        }
        while (n2 >= 0 && n < m_pFindFirstCollisionResultTime[n2]) {
            PhysicalObject.m_pFindFirstCollisionResultTime[n2 + 1] = m_pFindFirstCollisionResultTime[n2];
            PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[n2 + 1][0] = m_pFindFirstCollisionResultPhysicalObject[n2][0];
            PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[n2 + 1][1] = m_pFindFirstCollisionResultPhysicalObject[n2][1];
            --n2;
        }
        PhysicalObject.m_pFindFirstCollisionResultTime[++n2] = n;
        PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[n2][0] = physicalObject;
        PhysicalObject.m_pFindFirstCollisionResultPhysicalObject[n2][1] = physicalObject2;
        if (m_iFindFirstCollisionListCurrentSize < 7) {
            ++m_iFindFirstCollisionListCurrentSize;
        }
    }

    static int PhysicEngine_findFirstCollision(PhysicalObject physicalObject, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 1;
        PhysicalObject physicalObject2 = physicalObject;
        while (physicalObject2 != null) {
            n3 <<= 1;
            if (bl3 && n2 != Integer.MAX_VALUE) {
                PhysicalObject.PhysicEngine_findFirstCollisionAddResult(n2, PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                n2 = Integer.MAX_VALUE;
            }
            if (!bl3 || (m_iFindFirstCollisionBallsToUpdate & 1 << physicalObject2.m_type) != 0) {
                if (physicalObject2.bDesactivated) {
                    if (!physicalObject2.m_inactive) {
                        g_iBallsMovingInFrame |= n3;
                    }
                } else if (physicalObject2.jumpTimeLeft > 0) {
                    g_iBallsMovingInFrame |= n3;
                } else {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    boolean bl4;
                    boolean bl5 = bl4 = physicalObject2.speed != 0 || physicalObject2.XY_spin[0] != 0 || physicalObject2.XY_spin[1] != 0;
                    if (bl4) {
                        g_iBallsMovingInFrame |= n3;
                    }
                    int n9 = physicalObject2.deltaPosition[0] > 0 ? physicalObject2.x + physicalObject2.deltaPosition[0] : physicalObject2.x;
                    int n10 = physicalObject2.deltaPosition[0] > 0 ? physicalObject2.x : physicalObject2.x + physicalObject2.deltaPosition[0];
                    int n11 = physicalObject2.deltaPosition[1] > 0 ? physicalObject2.y + physicalObject2.deltaPosition[1] : physicalObject2.y;
                    int n12 = physicalObject2.deltaPosition[1] > 0 ? physicalObject2.y : physicalObject2.y + physicalObject2.deltaPosition[1];
                    PhysicalObject physicalObject3 = bl3 && m_iFindFirstCollisionBallsToUpdate != -1 ? physicalObject : physicalObject2.pNext;
                    while (physicalObject3 != null) {
                        if (!(bl3 && m_iFindFirstCollisionBallsToUpdate != -1 && physicalObject2.m_type <= physicalObject3.m_type && (m_iFindFirstCollisionBallsToUpdate & 1 << physicalObject3.m_type) != 0 || physicalObject3.bDesactivated || physicalObject3 == physicalObject2 || physicalObject3.jumpTimeLeft > 0)) {
                            boolean bl6;
                            boolean bl7 = bl6 = physicalObject3.speed != 0 || physicalObject3.XY_spin[0] != 0 || physicalObject3.XY_spin[1] != 0;
                            if ((bl6 || bl4) && (!GameCanvasEx.m_bUseOptimizedCollisions || Math.abs(physicalObject2.y - physicalObject3.y) <= 393216 && Math.abs(physicalObject2.x - physicalObject3.x) <= 393216)) {
                                n8 = physicalObject3.deltaPosition[0] > 0 ? physicalObject3.x + physicalObject3.deltaPosition[0] : physicalObject3.x;
                                n7 = physicalObject3.deltaPosition[0] > 0 ? physicalObject3.x : physicalObject3.x + physicalObject3.deltaPosition[0];
                                n6 = physicalObject3.deltaPosition[1] > 0 ? physicalObject3.y + physicalObject3.deltaPosition[1] : physicalObject3.y;
                                int n13 = n5 = physicalObject3.deltaPosition[1] > 0 ? physicalObject3.y : physicalObject3.y + physicalObject3.deltaPosition[1];
                                if (n9 + 53248 >= n7 - 53248 && n8 + 53248 >= n10 - 53248 && n11 + 53248 >= n5 - 53248 && n6 + 53248 >= n12 - 53248 && (n4 = PhysicalObject.PhysicEngine_getBallCollision(n, physicalObject2, physicalObject3)) < Integer.MAX_VALUE) {
                                    if (n4 < n2) {
                                        n2 = n4;
                                        PhysicEngine_pCollidingBall = physicalObject2;
                                        PhysicEngine_pCollidingObject = physicalObject3;
                                    }
                                    if (n2 == 0 && !bl3) {
                                        return n2;
                                    }
                                }
                            }
                        }
                        physicalObject3 = physicalObject3.pNext;
                    }
                    if (bl4) {
                        PhysicalObject physicalObject4 = PhysicEngine_pRootPockets;
                        while (physicalObject4 != null) {
                            if ((!GameCanvasEx.m_bUseOptimizedCollisions || Math.abs(physicalObject2.y - physicalObject4.y) <= 393216 && Math.abs(physicalObject2.x - physicalObject4.x) <= 393216) && n9 + 53248 >= physicalObject4.x - 98304 && physicalObject4.x + 98304 >= n10 - 53248 && n11 + 53248 >= physicalObject4.y - 98304 && physicalObject4.y + 98304 >= n12 - 53248 && (n4 = PhysicalObject.PhysicEngine_getPocketCollision(n, physicalObject2, physicalObject4)) < Integer.MAX_VALUE) {
                                if (n4 < n2) {
                                    n2 = n4;
                                    PhysicEngine_pCollidingBall = physicalObject2;
                                    PhysicEngine_pCollidingObject = physicalObject4;
                                }
                                if (n2 == 0 && !bl3) {
                                    return n2;
                                }
                            }
                            physicalObject4 = physicalObject4.pNext;
                        }
                        PhysicalObject.BuildTableCushionCollisionFlag(physicalObject2);
                        physicalObject4 = null;
                        n7 = -1;
                        for (n8 = 0; n8 < 24; ++n8) {
                            int n14;
                            if (n7 >= 6 || n8 % 3 == 0) {
                                ++n7;
                            }
                            if ((PhysicEngine_CushionCollisionsToCheck & 1 << n7) == 0) continue;
                            physicalObject4 = PhysicEngine_CushionsEdge[n8];
                            if (GameCanvasEx.m_bUseOptimizedCollisions && (Math.abs(physicalObject2.y - physicalObject4.point0[1]) > 393216 || Math.abs(physicalObject2.y - physicalObject4.point1[1]) > 393216) && (Math.abs(physicalObject2.x - physicalObject4.point0[0]) > 393216 || Math.abs(physicalObject2.x - physicalObject4.point1[0]) > 393216)) continue;
                            n6 = physicalObject4.point0[0] > physicalObject4.point1[0] ? physicalObject4.point0[0] : physicalObject4.point1[0];
                            n5 = physicalObject4.point0[0] > physicalObject4.point1[0] ? physicalObject4.point1[0] : physicalObject4.point0[0];
                            int n15 = physicalObject4.point0[1] > physicalObject4.point1[1] ? physicalObject4.point0[1] : physicalObject4.point1[1];
                            int n16 = n14 = physicalObject4.point0[1] > physicalObject4.point1[1] ? physicalObject4.point1[1] : physicalObject4.point0[1];
                            if (n9 + 53248 < n5 || n6 < n10 - 53248 || n11 + 53248 < n14 || n15 < n12 - 53248 || (n4 = PhysicalObject.PhysicEngine_getCushionEdgeCollision(n, physicalObject2, physicalObject4)) >= Integer.MAX_VALUE) continue;
                            if (n4 < n2) {
                                n2 = n4;
                                PhysicEngine_pCollidingBall = physicalObject2;
                                PhysicEngine_pCollidingObject = physicalObject4;
                            }
                            if (n2 != 0 || bl3) continue;
                            return n2;
                        }
                        physicalObject4 = null;
                        n8 = 0;
                        n7 = 12;
                        while (n8 < 12) {
                            if ((PhysicEngine_CushionCollisionsToCheck & 1 << n7) != 0) {
                                physicalObject4 = PhysicEngine_CushionsVertex[n8];
                                if ((!GameCanvasEx.m_bUseOptimizedCollisions || Math.abs(physicalObject2.y - physicalObject4.y) <= 393216 && Math.abs(physicalObject2.x - physicalObject4.x) <= 393216) && n9 + 53248 >= physicalObject4.x && physicalObject4.x >= n10 - 53248 && n11 + 53248 >= physicalObject4.y && physicalObject4.y >= n12 - 53248 && (n4 = PhysicalObject.PhysicEngine_getCushionVertexCollision(n, physicalObject2, physicalObject4)) < Integer.MAX_VALUE) {
                                    if (n4 < n2) {
                                        n2 = n4;
                                        PhysicEngine_pCollidingBall = physicalObject2;
                                        PhysicEngine_pCollidingObject = physicalObject4;
                                    }
                                    if (n2 == 0 && !bl3) {
                                        return n2;
                                    }
                                }
                            }
                            ++n8;
                            ++n7;
                        }
                    }
                }
            }
            physicalObject2 = physicalObject2.pNext;
        }
        if (bl3 && n2 != Integer.MAX_VALUE) {
            PhysicalObject.PhysicEngine_findFirstCollisionAddResult(n2, PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
        }
        return n2;
    }

    static int PhysicEngine_getBallCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n2 = Integer.MAX_VALUE;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        nArray = new int[]{physicalObject2.x - physicalObject.x, physicalObject2.y - physicalObject.y};
        int n3 = GameCanvasEx.Vector2D_squareLengthOf(nArray);
        if (n == 0) {
            if (n3 < 692224) {
                n2 = 0;
            }
        } else {
            nArray2 = new int[]{physicalObject.deltaPosition[0], physicalObject.deltaPosition[1]};
            GameCanvasEx.Vector2D_sub(nArray2, physicalObject2.deltaPosition);
            int n4 = GameCanvasEx.Vector2D_squareLengthOf(nArray2);
            int n5 = GameCanvasEx.Vector2D_dot(nArray2, nArray);
            if (n5 > 0) {
                int n6;
                int n7;
                int n8;
                nArray3 = new int[]{nArray2[0], nArray2[1]};
                int n9 = GameCanvasEx.fixed_sqrt(n4);
                GameCanvasEx.Vector2D_div(nArray3, n9);
                int n10 = GameCanvasEx.Vector2D_dot(nArray3, nArray);
                if (n10 > 0 && (n8 = n3 - GameCanvasEx.fixed_square(n10)) <= 692224 && (n7 = n10 - GameCanvasEx.fixed_sqrt(n6 = 692224 - n8)) <= n9) {
                    int n11 = (int)(((long)n7 << 28) / (long)n9 >> 14);
                    n2 = n * n11 >> 14;
                    if (n2 < 0) {
                        n2 = 1;
                    }
                    if (n2 < 0) {
                        System.out.println("Assert failed: Negative time for collision between two balls: " + n2);
                        int n12 = 1 / 0;
                    }
                }
            }
        }
        return n2;
    }

    static void doCollisionBall(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        GameCanvasEx.Vector2D_mul(physicalObject.direction, physicalObject.speed);
        GameCanvasEx.Vector2D_mul(physicalObject2.direction, physicalObject2.speed);
        int[] nArray3 = physicalObject.direction;
        int[] nArray4 = physicalObject2.direction;
        nArray2[0] = physicalObject2.x - physicalObject.x;
        nArray2[1] = physicalObject2.y - physicalObject.y;
        GameCanvasEx.Vector2D_normalize(nArray2);
        int n = GameCanvasEx.Vector2D_dot(nArray2, nArray3);
        int n2 = GameCanvasEx.Vector2D_dot(nArray2, nArray4);
        int n3 = n - n2;
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        GameCanvasEx.Vector2D_mul(nArray, n3);
        GameCanvasEx.Vector2D_sub(nArray3, nArray);
        GameCanvasEx.Vector2D_add(nArray4, nArray);
        if (GameCanvasEx.m_bIsBreakDone) {
            GameCanvasEx.Vector2D_mul(nArray3, 15360);
            GameCanvasEx.Vector2D_mul(nArray4, 15360);
        }
        physicalObject.speed = GameCanvasEx.Vector2D_lengthOf(nArray3);
        if (physicalObject.speed != 0) {
            GameCanvasEx.Vector2D_div(nArray3, physicalObject.speed);
        }
        physicalObject2.speed = GameCanvasEx.Vector2D_lengthOf(nArray4);
        if (physicalObject2.speed != 0) {
            GameCanvasEx.Vector2D_div(nArray4, physicalObject2.speed);
        }
    }

    static void doCollisionPocket(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        physicalObject.direction[0] = GameCanvasEx.fixed_mul(physicalObject2.x - physicalObject.x, 5734);
        physicalObject.direction[1] = GameCanvasEx.fixed_mul(physicalObject2.y - physicalObject.y, 5734);
        physicalObject.speed = GameCanvasEx.Vector2D_lengthOf(physicalObject.direction);
        if (physicalObject.speed != 0) {
            GameCanvasEx.Vector2D_div(physicalObject.direction, physicalObject.speed);
        }
        physicalObject.XY_spin[0] = 0;
        physicalObject.XY_spin[1] = 0;
        physicalObject.pPocketCollide = physicalObject2;
        physicalObject.bDesactivated = true;
    }

    static int PhysicEngine_getCushionEdgeCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n2 = PhysicalObject.PhysicEngine_getCollisionTime_circle_lineSegment(n, physicalObject, physicalObject2.point0, physicalObject2.point1);
        return n2;
    }

    static int PhysicEngine_getCushionEdgeCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2, boolean bl) {
        int n2;
        boolean bl2;
        int n3;
        int n4;
        int n5;
        int n6 = Integer.MAX_VALUE;
        if (bl) {
            n5 = 0;
            n4 = 1;
            int n7 = physicalObject.x;
            n3 = physicalObject.y;
            bl2 = physicalObject2.point1[1] < physicalObject2.point0[0];
        } else {
            n5 = 1;
            n4 = 0;
            int n8 = physicalObject.y;
            n3 = physicalObject.x;
            bl2 = physicalObject2.point1[1] >= physicalObject2.point0[1];
        }
        int[] nArray = new int[]{physicalObject.deltaPosition[0], physicalObject.deltaPosition[1]};
        int n9 = n2 = bl2 ? -nArray[n4] : nArray[n4];
        if (n2 > 0) {
            int n10;
            int[] nArray2 = physicalObject2.point0;
            int[] nArray3 = physicalObject2.point1;
            int n11 = (bl2 ? -(nArray2[n4] - n3) : nArray2[n4] - n3) - 53248;
            if (n2 >= n11 && (n10 = (int)(((long)n11 << 28) / (long)n2 >> 14)) >= 0) {
                GameCanvasEx.Vector2D_mul(nArray, n10);
                int[] nArray4 = new int[]{physicalObject.x + nArray[0], physicalObject.y + nArray[1]};
                nArray4[0] = nArray4[0] + (bl2 ? 53248 : -53248);
                if ((nArray2[n5] < nArray3[n5] ? nArray2[n4] < nArray4[n4] && nArray4[n4] < nArray3[n4] : nArray3[n4] < nArray4[n4] && nArray4[n5] < nArray2[n5]) && (n6 = n * n10 >> 14) < 0) {
                    n6 = 1;
                }
            }
        }
        return n6;
    }

    static int PhysicEngine_getCushionVertexCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = physicalObject.x;
        nArray[1] = physicalObject.y;
        nArray2[0] = physicalObject2.x;
        nArray2[1] = physicalObject2.y;
        int n2 = PhysicalObject.PhysicEngine_getCollisionTime(nArray, nArray2, physicalObject.deltaPosition, n, 53248, 173056);
        return n2;
    }

    static int PhysicEngine_getCushionCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n2;
        if (physicalObject2.type == 8) {
            n2 = PhysicalObject.PhysicEngine_getCollisionTime_circle_lineSegment(n, physicalObject, physicalObject2.point0, physicalObject2.point1);
        } else {
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            nArray[0] = physicalObject.x;
            nArray[1] = physicalObject.y;
            nArray2[0] = physicalObject2.x;
            nArray2[1] = physicalObject2.y;
            n2 = PhysicalObject.PhysicEngine_getCollisionTime(nArray, nArray2, physicalObject.deltaPosition, n, 53248, 173056);
        }
        return n2;
    }

    static void doCollisionCushion(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        if (physicalObject.speed == 0) {
            System.err.println("WARNING: Collision with immobile ball!!!");
            return;
        }
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = new int[2];
        nArray2 = new int[2];
        GameCanvasEx.Vector2D_mul(physicalObject.direction, physicalObject.speed);
        int[] nArray3 = physicalObject.direction;
        nArray[0] = physicalObject2.direction[0];
        nArray[1] = physicalObject2.direction[1];
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        GameCanvasEx.Vector2D_normal(nArray2);
        int n = GameCanvasEx.Vector2D_dot(nArray3, nArray2);
        int n2 = (int)(((long)n << 28) / (long)physicalObject.speed >> 14);
        n2 = GameCanvasEx.fixed_mul(n2, 8192);
        n2 = 16384 - n2;
        GameCanvasEx.Vector2D_mul(nArray2, -(n << 1));
        GameCanvasEx.Vector2D_add(nArray3, nArray2);
        nArray[0] = nArray3[0];
        nArray[1] = nArray3[1];
        GameCanvasEx.Vector2D_normal(nArray);
        GameCanvasEx.Vector2D_mul(nArray, physicalObject.Z_spin_ratio);
        GameCanvasEx.Vector2D_add(nArray3, nArray);
        physicalObject.Z_spin_ratio = 0;
        GameCanvasEx.Vector2D_mul(nArray3, n2);
        physicalObject.speed = GameCanvasEx.Vector2D_lengthOf(nArray3);
        if (physicalObject.speed != 0) {
            GameCanvasEx.Vector2D_div(nArray3, physicalObject.speed);
        }
    }

    static void doCollisionCushionVertex(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        if (physicalObject.speed == 0) {
            System.err.println("WARNING: Collision with immobile ball!!!");
            return;
        }
        int[] nArray = new int[]{physicalObject2.x - physicalObject.x, physicalObject2.y - physicalObject.y};
        GameCanvasEx.Vector2D_normalize(nArray);
        GameCanvasEx.Vector2D_mul(physicalObject.direction, physicalObject.speed);
        int n = GameCanvasEx.Vector2D_dot(nArray, physicalObject.direction);
        GameCanvasEx.Vector2D_mul(nArray, -(n << 1));
        GameCanvasEx.Vector2D_add(physicalObject.direction, nArray);
        int n2 = (int)(((long)n << 28) / (long)physicalObject.speed >> 14);
        n2 = GameCanvasEx.fixed_mul(n2, 8192);
        n2 = 16384 - n2;
        GameCanvasEx.Vector2D_mul(physicalObject.direction, n2);
        physicalObject.speed = GameCanvasEx.Vector2D_lengthOf(physicalObject.direction);
        if (physicalObject.speed != 0) {
            GameCanvasEx.Vector2D_div(physicalObject.direction, physicalObject.speed);
        }
    }

    static int PhysicEngine_getCollisionTime_circle_lineSegment(int n, PhysicalObject physicalObject, int[] nArray, int[] nArray2) {
        int n2;
        block6: {
            int n3;
            block7: {
                n2 = Integer.MAX_VALUE;
                if (nArray[0] == nArray2[0] && Math.abs((nArray[0] >> 14) - (physicalObject.x >> 14)) < 2) {
                    return 1;
                }
                if (nArray[1] == nArray2[1] && Math.abs((nArray[1] >> 14) - (physicalObject.y >> 14)) < 2) {
                    return 1;
                }
                int[] nArray3 = null;
                int[] nArray4 = null;
                int[] nArray5 = null;
                int[] nArray6 = null;
                nArray3 = new int[]{nArray2[0], nArray2[1]};
                GameCanvasEx.Vector2D_sub(nArray3, nArray);
                GameCanvasEx.Vector2D_normal(nArray3);
                GameCanvasEx.Vector2D_normalize(nArray3);
                nArray4 = new int[]{physicalObject.deltaPosition[0], physicalObject.deltaPosition[1]};
                int n4 = GameCanvasEx.Vector2D_dot(nArray3, nArray4);
                if (n4 <= 0) break block6;
                nArray5 = new int[]{nArray[0] - physicalObject.x, nArray[1] - physicalObject.y};
                int n5 = GameCanvasEx.Vector2D_dot(nArray3, nArray5) - 53248;
                if (n4 < n5 || (n3 = (int)(((long)n5 << 28) / (long)n4 >> 14)) < 0) break block6;
                GameCanvasEx.Vector2D_mul(nArray4, n3);
                nArray6 = new int[]{physicalObject.x + nArray4[0], physicalObject.y + nArray4[1]};
                GameCanvasEx.Vector2D_mul(nArray3, 53248);
                GameCanvasEx.Vector2D_add(nArray6, nArray3);
                if (nArray[0] >= nArray2[0] ? nArray2[0] < nArray6[0] && nArray6[0] < nArray[0] : nArray[0] < nArray6[0] && nArray6[0] < nArray2[0]) break block7;
                if (!(nArray[1] < nArray2[1] ? nArray[1] < nArray6[1] && nArray6[1] < nArray2[1] : nArray2[1] < nArray6[1] && nArray6[1] < nArray[1])) break block6;
            }
            if ((n2 = n * n3 >> 14) < 0) {
                n2 = 1;
            }
        }
        return n2;
    }

    static int PhysicEngine_getPocketCollision(int n, PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n2 = Integer.MAX_VALUE;
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = new int[]{physicalObject2.x - physicalObject.x, physicalObject2.y - physicalObject.y};
        int n3 = GameCanvasEx.Vector2D_squareLengthOf(nArray);
        if (n == 0) {
            if (n3 < 589824) {
                n2 = 0;
            }
        } else {
            int[] nArray3 = physicalObject.deltaPosition;
            int n4 = GameCanvasEx.Vector2D_squareLengthOf(nArray3);
            if (n3 - 589824 <= n4) {
                int n5;
                int n6;
                int n7;
                int n8;
                nArray2 = new int[]{nArray3[0], nArray3[1]};
                int n9 = GameCanvasEx.fixed_sqrt(n4);
                GameCanvasEx.Vector2D_div(nArray2, n9);
                int n10 = GameCanvasEx.Vector2D_dot(nArray2, nArray);
                if (n10 > 0 && (n8 = n3 - GameCanvasEx.fixed_square(n10)) <= 589824 && (n7 = n10 - GameCanvasEx.fixed_sqrt(n6 = 589824 - n8)) <= n9 && (n2 = n * (n5 = (int)(((long)n7 << 28) / (long)n9 >> 14)) >> 14) < 0) {
                    n2 = 1;
                }
            }
        }
        return n2;
    }

    static boolean PhysicEngine_isAnyBallMoving(PhysicalObject physicalObject) {
        PhysicalObject physicalObject2 = physicalObject;
        while (physicalObject2 != null) {
            if (physicalObject2.isMoving()) {
                return true;
            }
            physicalObject2 = physicalObject2.pNext;
        }
        return false;
    }

    static int PhysicEngine_getCollisionTime(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3) {
        int[] nArray4 = nArray3;
        int[] nArray5 = nArray2;
        GameCanvasEx.Vector2D_sub(nArray5, nArray);
        int n4 = GameCanvasEx.Vector2D_squareLengthOf(nArray4);
        int n5 = GameCanvasEx.Vector2D_squareLengthOf(nArray5);
        if (n5 - n3 > n4) {
            return Integer.MAX_VALUE;
        }
        int[] nArray6 = new int[]{nArray4[0], nArray4[1]};
        int n6 = GameCanvasEx.fixed_sqrt(n4);
        GameCanvasEx.Vector2D_div(nArray6, n6);
        int n7 = GameCanvasEx.Vector2D_dot(nArray6, nArray5);
        if (n7 < 0) {
            return Integer.MAX_VALUE;
        }
        int n8 = n5 - GameCanvasEx.fixed_square(n7);
        if (n8 > n3) {
            return Integer.MAX_VALUE;
        }
        int n9 = n3 - n8;
        int n10 = n7 - GameCanvasEx.fixed_sqrt(n9);
        if (n10 > n6) {
            return Integer.MAX_VALUE;
        }
        int n11 = (int)(((long)n10 << 28) / (long)n6 >> 14);
        int n12 = n * n11 >> 14;
        if (n12 < 0) {
            n12 = 1;
        }
        return n12;
    }

    static boolean PhysicEngine_isColliding(PhysicalObject physicalObject) {
        PhysicalObject physicalObject2 = PhysicEngine_pRootBalls;
        while (physicalObject2 != null) {
            if (physicalObject2 != physicalObject && !physicalObject2.bDesactivated && PhysicalObject.PhysicEngine_getBallCollision(0, physicalObject, physicalObject2) == 0) {
                return true;
            }
            physicalObject2 = physicalObject2.pNext;
        }
        physicalObject2 = PhysicEngine_pRootPockets;
        while (physicalObject2 != null) {
            if (physicalObject2 != physicalObject && PhysicalObject.PhysicEngine_getPocketCollision(0, physicalObject, physicalObject2) == 0) {
                return true;
            }
            physicalObject2 = physicalObject2.pNext;
        }
        return false;
    }

    static void PhysicEngine_resetSimulation() {
        PhysicalObject physicalObject = PhysicEngine_pRootBalls;
        while (physicalObject != null) {
            physicalObject.pCopy.setTo(physicalObject);
            physicalObject = physicalObject.pNext;
        }
    }

    static void PhysicEngine_stopMovingBalls() {
        PhysicalObject physicalObject = PhysicEngine_pRootBalls;
        while (physicalObject != null) {
            physicalObject.direction[0] = 0;
            physicalObject.direction[1] = 0;
            physicalObject.speed = 0;
            physicalObject = physicalObject.pNext;
        }
    }

    static int PhysicEngine_updateBallsToFirstCollision(PhysicalObject physicalObject, int n, boolean bl) {
        int n2 = Integer.MAX_VALUE;
        PhysicalObject physicalObject2 = physicalObject;
        while (physicalObject2 != null) {
            physicalObject2.computeMove(n);
            physicalObject2 = physicalObject2.pNext;
        }
        if ((n -= (n2 = PhysicalObject.PhysicEngine_findFirstCollision(physicalObject, n, true, bl, false))) < 0) {
            physicalObject2 = physicalObject;
            while (physicalObject2 != null) {
                physicalObject2.doMove(n + n2);
                physicalObject2 = physicalObject2.pNext;
            }
        } else {
            physicalObject2 = physicalObject;
            while (physicalObject2 != null) {
                physicalObject2.computeMove(n2);
                physicalObject2.doMove(n2);
                physicalObject2 = physicalObject2.pNext;
            }
            GameCanvasEx.Game_NotifyCollision(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
            switch (PhysicalObject.PhysicEngine_pCollidingObject.type) {
                case 1: {
                    PhysicalObject.doCollisionBall(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 8: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 16: {
                    PhysicalObject.doCollisionCushionVertex(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 64: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 32: {
                    PhysicalObject.doCollisionCushion(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                case 2: {
                    PhysicalObject.doCollisionPocket(PhysicEngine_pCollidingBall, PhysicEngine_pCollidingObject);
                    break;
                }
                default: {
                    System.out.println("Unknown colliding object physical type");
                }
            }
        }
        return n;
    }

    static void emptyList(PhysicalObject physicalObject) {
        while (physicalObject != null) {
            PhysicalObject physicalObject2 = physicalObject.pNext;
            physicalObject.pNext = null;
            physicalObject = physicalObject2;
        }
    }

    static int FindInitialPower(int n, int n2) {
        int n3 = 196608;
        int n4 = GameCanvasEx.fixed_sqrt(GameCanvasEx.fixed_square(n) + GameCanvasEx.fixed_mul(GameCanvasEx.fixed_mul(n3, n2), 32768));
        int n5 = (int)(((long)(-n + n4) << 28) / (long)n3 >> 14);
        int n6 = (int)(((long)(-n - n4) << 28) / (long)n3 >> 14);
        if (n5 < 0 && n6 < 0) {
            return 0;
        }
        if (n5 < 0) {
            n5 = n6;
        }
        return n + GameCanvasEx.fixed_mul(n5 >>= 8, n3);
    }

    static {
        PhysicEngine_pRootOutOfBounds = new PhysicalObject(128, null);
        PhysicEngine_pRootTable = new PhysicalObject(256, null);
        PhysicEngine_CushionsEdge = new PhysicalObject[24];
        PhysicEngine_CushionsEdgeVertical = new PhysicalObject[0];
        PhysicEngine_CushionsEdgeHorizontal = new PhysicalObject[0];
        PhysicEngine_CushionsVertex = new PhysicalObject[12];
        m_pFindFirstCollisionResultTime = new int[7];
        m_pFindFirstCollisionResultPhysicalObject = new PhysicalObject[7][2];
    }
}

