/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.MGCC;

import com.kitmaker.MGCC.MGCC;
import com.kitmaker.MGCC.MiscUtils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import javak.microedition.lcdui.Font;
import javak.microedition.lcdui.Graphics;
import javak.microedition.lcdui.Image;

public class FntManager {
    public static final boolean USE_DELTA = false;
    static final int FONT_SMALL = 0;
    static final int FONT_NORMAL = 1;
    static final int FONT_BIG = 2;
    private static final String[] FONT_URL = new String[]{"0", "1", "2"};
    private static final byte NUM_FONTS = (byte)FONT_URL.length;
    private static Font[] ms_SystemFont = new Font[NUM_FONTS];
    private static int[][] SYSTEM_FONTS = new int[NUM_FONTS][3];
    private static int[][] SYSTEM_STROKE = new int[NUM_FONTS][];
    private static int[][] SYSTEM_SHADOW = new int[NUM_FONTS][];
    private static final int[] FNTSYS_MASK_SIZE = new int[]{8, 0, 16};
    private static final int[] FNTSYS_MASK_STYLE = new int[]{0, 1, 2};
    private static byte[] FNTSYS_HEIGHT = new byte[NUM_FONTS];
    private static byte[] FNTSYS_BASELI = new byte[NUM_FONTS];
    private static byte[] FNTSYS_MAXHEIGHT = new byte[NUM_FONTS];
    static final byte FNTDATA_X = 0;
    static final byte FNTDATA_WIDTH = 1;
    static final byte FNTDATA_Y = 2;
    static final byte FNTDATA_HEIGHT = 3;
    static final byte FNTDATA_BASEDIFF = 4;
    static short[][][] ms_iCharData = new short[NUM_FONTS][][];
    private static byte[][][] FNTGFX_LINE_DATA = new byte[NUM_FONTS][][];
    private static short[][][] FNTGFX_CHARPOS_X = new short[NUM_FONTS][][];
    private static String[] ms_zCharSet = new String[NUM_FONTS];
    private static byte[] FNTGFX_HEIGHT = new byte[NUM_FONTS];
    private static byte[] FNTGFX_BASELI = new byte[NUM_FONTS];
    private static byte[] FNTGFX_MAXHEIGHT = new byte[NUM_FONTS];
    public static byte[] FNT_SPACINGX = new byte[NUM_FONTS];
    public static byte[] FNT_HEIGHT = new byte[NUM_FONTS];
    public static byte[] FNT_BASELI = new byte[NUM_FONTS];
    public static byte[] FNT_MAXHEIGHT = new byte[NUM_FONTS];
    static final int PAL0 = 0;
    static final int PAL1 = 256;
    static final int PAL2 = 512;
    public static final int HCENTER = 1;
    public static final int RIGHT = 8;
    public static final int LEFT = 4;
    public static final int VCENTER = 2;
    public static final int BASELINE = 64;
    public static final int TOP = 16;
    public static final int DELTAMOVE = 128;
    static Image[][] ms_vFont = new Image[NUM_FONTS][5];
    static int ms_iApostrophe;
    static int ms_iApostropheExtraY;
    static int ms_iApostropheeCaseH;
    static int ms_iLetterHeight;
    static final int SHADOW_PIXELS = 1;
    private static final char[][] APOSTROPHE_LATIN;
    public static final int FTYPE_SYSTEM = 0;
    public static final int FTYPE_GRAPHIC = 1;
    private static int ms_iFontType;
    private static String[] ms_zDrawRectFontStr;
    public static byte ms_iDrawRectFontLines;
    public static short ms_iDrawRectFontLetters;
    private static int ms_iDrawRectChars;
    private static int ms_iDrawRectY;
    public static final int DELTA_INC = 32;

    public static void InitFontManager() {
        for (int i = 0; i < NUM_FONTS; ++i) {
            FntManager.LoadFont(i);
        }
    }

    public static void DeleteFont(int _iIndex) {
        FntManager.ms_vFont[_iIndex][0] = null;
        System.gc();
        FntManager.ms_zCharSet[_iIndex] = null;
        FntManager.FNTGFX_CHARPOS_X[_iIndex] = null;
        FntManager.FNTGFX_LINE_DATA[_iIndex] = null;
        System.gc();
    }

    public static void LoadFont(int _iIndex) {
        int j;
        FilterInputStream vInputS = null;
        try {
            FntManager.ms_vFont[_iIndex][0] = Image.createImage("/" + FONT_URL[_iIndex] + ".png");
            System.gc();
            MiscUtils.DebugMsg("FntManager.inst - " + (Object)((Object)MGCC.ms_vInstance));
            vInputS = new DataInputStream(((Object)((Object)MGCC.ms_vInstance)).getClass().getResourceAsStream("/" + FONT_URL[_iIndex] + ".dat"));
            int iFontNameLenght = ((DataInputStream)vInputS).readByte();
            String zFontName = "";
            for (int i = 0; i < iFontNameLenght; ++i) {
                zFontName = zFontName + ((DataInputStream)vInputS).readChar();
            }
            FntManager.ms_zCharSet[_iIndex] = "";
            int iCharSetLenght = ((DataInputStream)vInputS).readShort();
            for (j = 0; j < iCharSetLenght; ++j) {
                int n = _iIndex;
                ms_zCharSet[n] = ms_zCharSet[n] + String.valueOf(((DataInputStream)vInputS).readChar());
            }
            int iCharXLenght = ((DataInputStream)vInputS).readShort();
            FntManager.FNTGFX_CHARPOS_X[_iIndex] = new short[iCharXLenght][];
            for (int s = 0; s < iCharXLenght; ++s) {
                int iSubCharXLenght = ((DataInputStream)vInputS).readShort();
                FntManager.FNTGFX_CHARPOS_X[_iIndex][s] = new short[iSubCharXLenght];
                for (int t = 0; t < iSubCharXLenght; ++t) {
                    FntManager.FNTGFX_CHARPOS_X[_iIndex][s][t] = ((DataInputStream)vInputS).readShort();
                }
            }
            int iLineDataLenght = ((DataInputStream)vInputS).readShort();
            FntManager.FNTGFX_LINE_DATA[_iIndex] = new byte[iLineDataLenght][];
            for (int s = 0; s < iLineDataLenght; ++s) {
                int iSubLineDataLenght = ((DataInputStream)vInputS).readShort();
                FntManager.FNTGFX_LINE_DATA[_iIndex][s] = new byte[iSubLineDataLenght];
                for (int t = 0; t < iSubLineDataLenght; ++t) {
                    FntManager.FNTGFX_LINE_DATA[_iIndex][s][t] = ((DataInputStream)vInputS).readByte();
                }
            }
            FntManager.FNT_SPACINGX[_iIndex] = ((DataInputStream)vInputS).readByte();
            ms_iApostropheeCaseH = ((DataInputStream)vInputS).readByte();
            ms_iLetterHeight = ((DataInputStream)vInputS).readByte();
            short iSize = ((DataInputStream)vInputS).readShort();
            FntManager.SYSTEM_FONTS[_iIndex][0] = Math.min(2, iSize / 25);
            FntManager.SYSTEM_FONTS[_iIndex][1] = ((DataInputStream)vInputS).readByte();
            FntManager.SYSTEM_FONTS[_iIndex][2] = ((DataInputStream)vInputS).readInt();
            byte iStrokeSize = ((DataInputStream)vInputS).readByte();
            byte iShadowSizeX = ((DataInputStream)vInputS).readByte();
            byte iShadowSizeY = ((DataInputStream)vInputS).readByte();
            int iStrokeColor = ((DataInputStream)vInputS).readInt();
            int iShadowColor = ((DataInputStream)vInputS).readInt();
            if (iStrokeSize > 0) {
                FntManager.SYSTEM_STROKE[_iIndex] = new int[1];
                FntManager.SYSTEM_STROKE[_iIndex][0] = iStrokeColor;
            }
            if (iShadowSizeX != 0 && iShadowSizeY != 0) {
                FntManager.SYSTEM_SHADOW[_iIndex] = new int[3];
                FntManager.SYSTEM_SHADOW[_iIndex][0] = iShadowColor;
                FntManager.SYSTEM_SHADOW[_iIndex][1] = iShadowSizeX;
                FntManager.SYSTEM_SHADOW[_iIndex][2] = iShadowSizeY;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (vInputS != null) {
                vInputS.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        FntManager.ms_SystemFont[_iIndex] = Font.getFont(0, FNTSYS_MASK_STYLE[SYSTEM_FONTS[_iIndex][1]], FNTSYS_MASK_SIZE[SYSTEM_FONTS[_iIndex][0]]);
        FntManager.FNTSYS_MAXHEIGHT[_iIndex] = (byte)ms_SystemFont[_iIndex].getHeight();
        FntManager.FNTSYS_HEIGHT[_iIndex] = (byte)ms_SystemFont[_iIndex].getHeight();
        FntManager.FNTSYS_BASELI[_iIndex] = (byte)ms_SystemFont[_iIndex].getBaselinePosition();
        System.arraycopy(FNTSYS_HEIGHT, 0, FNT_HEIGHT, 0, FNTSYS_HEIGHT.length);
        System.arraycopy(FNTSYS_BASELI, 0, FNT_BASELI, 0, FNTSYS_BASELI.length);
        System.arraycopy(FNTSYS_MAXHEIGHT, 0, FNT_MAXHEIGHT, 0, FNTSYS_MAXHEIGHT.length);
        FntManager.FNTGFX_HEIGHT[_iIndex] = FNTGFX_LINE_DATA[_iIndex][0][0];
        FntManager.FNTGFX_BASELI[_iIndex] = FNTGFX_LINE_DATA[_iIndex][0][1];
        FntManager.FNTGFX_MAXHEIGHT[_iIndex] = 0;
        for (j = 0; j < FNTGFX_LINE_DATA[_iIndex].length; ++j) {
            if (FNTGFX_LINE_DATA[_iIndex][j][0] <= FNTGFX_MAXHEIGHT[_iIndex]) continue;
            FntManager.FNTGFX_MAXHEIGHT[_iIndex] = FNTGFX_LINE_DATA[_iIndex][j][0];
        }
        System.arraycopy(FNTGFX_HEIGHT, 0, FNT_HEIGHT, 0, FNT_HEIGHT.length);
        System.arraycopy(FNTGFX_BASELI, 0, FNT_BASELI, 0, FNT_BASELI.length);
        System.arraycopy(FNTGFX_MAXHEIGHT, 0, FNT_MAXHEIGHT, 0, FNT_MAXHEIGHT.length);
        try {
            FntManager.ms_iCharData[_iIndex] = new short[255][5];
            for (j = 0; j < ms_zCharSet[_iIndex].length(); ++j) {
                int iCharRow;
                int iCharPosYGfx = 0;
                int iCharCodeAcum = 0;
                for (iCharRow = 0; iCharRow < FNTGFX_CHARPOS_X[_iIndex].length && j >= iCharCodeAcum + FNTGFX_CHARPOS_X[_iIndex][iCharRow].length - 1; ++iCharRow) {
                    iCharCodeAcum += FNTGFX_CHARPOS_X[_iIndex][iCharRow].length - 1;
                    iCharPosYGfx += FNTGFX_LINE_DATA[_iIndex][iCharRow][0];
                }
                FntManager.ms_iCharData[_iIndex][j][0] = FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum];
                FntManager.ms_iCharData[_iIndex][j][1] = (short)(FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum + 1] - FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum]);
                FntManager.ms_iCharData[_iIndex][j][2] = (short)iCharPosYGfx;
                FntManager.ms_iCharData[_iIndex][j][3] = FNTGFX_LINE_DATA[_iIndex][iCharRow][0];
                FntManager.ms_iCharData[_iIndex][j][4] = (short)(FNTGFX_BASELI[_iIndex] - FNTGFX_LINE_DATA[_iIndex][iCharRow][1]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        FntManager.FNTGFX_LINE_DATA[_iIndex] = null;
        FntManager.FNTGFX_CHARPOS_X[_iIndex] = null;
    }

    static int StringWidth(int _iFontID, String _Frase) {
        if (FntManager.IsGfxFontWritable(_Frase)) {
            int iAnchoFrase = 0;
            int iNumCharsFrase = _Frase.length();
            if (iNumCharsFrase == 0) {
                return 0;
            }
            for (int i = 0; i < iNumCharsFrase; ++i) {
                char iChar = _Frase.charAt(i);
                iAnchoFrase += ms_iCharData[_iFontID][FntManager.Font_GetArrayCode(_iFontID, iChar) & 0xFF][1] + FNT_SPACINGX[_iFontID];
            }
            ms_iApostrophe = 0;
            ms_iApostropheExtraY = 0;
            return iAnchoFrase;
        }
        return ms_SystemFont[_iFontID].stringWidth(_Frase);
    }

    static int GetHeight(int _iFontID) {
        return FNT_MAXHEIGHT[_iFontID];
    }

    static int GetBaseline(int _iFontID) {
        return FNT_BASELI[_iFontID];
    }

    public static void DrawFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        if (FntManager.IsGfxFontWritable(_Frase)) {
            FntManager.DrawGraphicFont(_g, _iFontID, _Frase, _iPosX, _iPosY, _iAnchor, _iChars);
        } else {
            FntManager.DrawSystemFont(_g, _iFontID, _Frase, _iPosX, _iPosY, _iAnchor, _iChars);
        }
    }

    private static void DrawGraphicFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        int iAnchoFraseStr;
        int iPalette = _iAnchor >> 8;
        int iIndex = 0;
        int iPosX = _iPosX;
        int iPosY = _iPosY;
        int n = iAnchoFraseStr = _iChars >= 0 ? Math.min(_iChars, _Frase.length()) : _Frase.length();
        if ((_iAnchor & 1) != 0) {
            iPosX -= FntManager.StringWidth(_iFontID, _Frase) >> 1;
        } else if ((_iAnchor & 8) != 0) {
            iPosX -= FntManager.StringWidth(_iFontID, _Frase);
        }
        if ((_iAnchor & 0x40) != 0) {
            iPosY -= ms_iLetterHeight;
        } else if ((_iAnchor & 2) != 0) {
            iPosY -= ms_iLetterHeight >> 1;
        }
        while (iIndex < iAnchoFraseStr) {
            int iChar = _Frase.charAt(iIndex);
            iChar = FntManager.Font_GetArrayCode(_iFontID, iChar);
            int iCurrentChar = iChar & 0xFF;
            _g.setClip(iPosX, iPosY + ms_iCharData[_iFontID][iCurrentChar][4], ms_iCharData[_iFontID][iCurrentChar][1], ms_iCharData[_iFontID][iCurrentChar][3]);
            _g.drawImage(ms_vFont[_iFontID][iPalette], iPosX - ms_iCharData[_iFontID][iCurrentChar][0], iPosY - ms_iCharData[_iFontID][iCurrentChar][2] + ms_iCharData[_iFontID][iCurrentChar][4], 20);
            if (ms_iApostrophe != 0) {
                int iApostropheX = iPosX + (ms_iCharData[_iFontID][iCurrentChar][1] >> 1) - (ms_iCharData[_iFontID][ms_iApostrophe][1] >> 1);
                _g.setClip(iApostropheX, iPosY + ms_iCharData[_iFontID][ms_iApostrophe][4] - ms_iApostropheExtraY, ms_iCharData[_iFontID][ms_iApostrophe][1], ms_iCharData[_iFontID][ms_iApostrophe][3]);
                _g.drawImage(ms_vFont[_iFontID][iPalette], iApostropheX - ms_iCharData[_iFontID][ms_iApostrophe][0], iPosY - ms_iCharData[_iFontID][ms_iApostrophe][2] + ms_iCharData[_iFontID][ms_iApostrophe][4] - ms_iApostropheExtraY, 20);
                ms_iApostrophe = 0;
                ms_iApostropheExtraY = 0;
            }
            iPosX += ms_iCharData[_iFontID][iCurrentChar][1] + FNT_SPACINGX[_iFontID];
            ++iIndex;
        }
        _g.setClip(0, 0, 176, 206);
    }

    static void DrawSystemFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        int iAnchoFraseStr = _iChars >= 0 ? Math.min(_iChars, _Frase.length()) : _Frase.length();
        _g.setFont(ms_SystemFont[_iFontID]);
        if ((_iAnchor & 1) != 0) {
            _iPosX -= ms_SystemFont[_iFontID].stringWidth(_Frase) >> 1;
        } else if ((_iAnchor & 8) != 0) {
            _iPosX -= ms_SystemFont[_iFontID].stringWidth(_Frase);
        }
        if ((_iAnchor & 2) != 0) {
            _iPosY -= FNTSYS_HEIGHT[_iFontID] >> 1;
        }
        if ((_iAnchor & 0x40) != 0) {
            _iPosY -= FNTSYS_BASELI[_iFontID];
        }
        if (SYSTEM_SHADOW[_iFontID] != null) {
            _g.setColor(SYSTEM_SHADOW[_iFontID][0]);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX + SYSTEM_SHADOW[_iFontID][1], _iPosY + SYSTEM_SHADOW[_iFontID][2], 0);
        }
        if (SYSTEM_STROKE[_iFontID] != null) {
            _g.setColor(SYSTEM_STROKE[_iFontID][0]);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX + 1, _iPosY + 1, 0);
        }
        _g.setColor(SYSTEM_FONTS[_iFontID][2]);
        _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX, _iPosY, 0);
    }

    public static int Font_GetArrayCode(int _iFontID, int _iCharCode) {
        int iFinalArrayCode = 0;
        try {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf(_iCharCode);
        }
        catch (Exception ex) {
            System.err.checkError();
        }
        if (_iCharCode >= 192 && _iCharCode <= 196) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("A");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 192]);
            ms_iApostropheExtraY = ms_iApostropheeCaseH;
        } else if (_iCharCode >= 200 && _iCharCode <= 203) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("E");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 200]);
            ms_iApostropheExtraY = ms_iApostropheeCaseH;
        } else if (_iCharCode >= 204 && _iCharCode <= 207) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("I");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 204]);
            ms_iApostropheExtraY = ms_iApostropheeCaseH;
        } else if (_iCharCode >= 210 && _iCharCode <= 214) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("O");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 210]);
            ms_iApostropheExtraY = ms_iApostropheeCaseH;
        } else if (_iCharCode >= 217 && _iCharCode <= 220) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("U");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 217]);
            ms_iApostropheExtraY = ms_iApostropheeCaseH;
        } else if (_iCharCode >= 224 && _iCharCode <= 228) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("a");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 224]);
        } else if (_iCharCode >= 232 && _iCharCode <= 235) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("e");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 232]);
        } else if (_iCharCode >= 236 && _iCharCode <= 239) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf(305);
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 236]);
        } else if (_iCharCode >= 242 && _iCharCode <= 246) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("o");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 242]);
        } else if (_iCharCode >= 249 && _iCharCode <= 252) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("u");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 249]);
        }
        if (iFinalArrayCode == -1) {
            iFinalArrayCode = ms_zCharSet[_iFontID].length() - 1;
        }
        return iFinalArrayCode;
    }

    public static void SetFontType(int _iType) {
        ms_iFontType = _iType;
    }

    private static boolean IsGfxFontWritable(String _zString) {
        return ms_iFontType == 1 && _zString.charAt(0) < '\u0100';
    }

    public static void DrawFontInRectangle(Graphics _g, int _iFontID, String[] _iTextArray, int _iPosX, int _iPosY, int _iW, int _iFontSpacingY, int _iFontAnchor, int _iBoxAnchorY, int _iChars, boolean _bCalculateStrings) {
        ms_iDrawRectChars = 0;
        if (_iChars < 0) {
            _iChars = 999;
        }
        ms_iDrawRectY = _iPosY;
        if (_bCalculateStrings) {
            ms_iDrawRectFontLines = FntManager.SplitString(_iTextArray, _iW, _iFontID);
        }
        if ((_iBoxAnchorY & 0x40) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines;
        } else if ((_iBoxAnchorY & 2) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines >> 1;
        }
        if (ms_zDrawRectFontStr == null || _iChars == 0) {
            return;
        }
        int iPY = ms_iDrawRectY;
        for (int i = 0; i < ms_zDrawRectFontStr.length && ms_zDrawRectFontStr[i] != null; ++i) {
            if (_iChars >= (ms_iDrawRectChars += ms_zDrawRectFontStr[i].length() - 1)) {
                if (!ms_zDrawRectFontStr[i].equals("")) {
                    FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX, iPY, _iFontAnchor, -1);
                }
            } else {
                if (ms_zDrawRectFontStr[i].equals("")) break;
                FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX, iPY, _iFontAnchor, ms_zDrawRectFontStr[i].length() - 1 - (ms_iDrawRectChars - _iChars));
                break;
            }
            iPY += _iFontSpacingY;
        }
    }

    public static void DrawFontInRectangle(Graphics _g, int _iFontID, String[] _iTextArray, short[] _iIndexArray, int _iPosX, int _iPosY, int _iW, int _iFontSpacingY, int _iFontAnchor, int _iBoxAnchorY, int _iChars, boolean _bCalculateStrings) {
        int i;
        ms_iDrawRectChars = 0;
        ms_iDrawRectY = _iPosY;
        if (_bCalculateStrings) {
            String[] zArray = new String[_iIndexArray.length];
            for (i = 0; i < _iIndexArray.length; ++i) {
                zArray[i] = _iTextArray[_iIndexArray[i]];
            }
            ms_iDrawRectFontLines = FntManager.SplitString(zArray, _iW, _iFontID);
        }
        if ((_iBoxAnchorY & 0x40) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines;
        } else if ((_iBoxAnchorY & 2) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines >> 1;
        }
        if (_iChars < 0) {
            _iChars = 999;
        }
        if (ms_zDrawRectFontStr == null || _iChars == 0) {
            return;
        }
        int iPY = ms_iDrawRectY;
        for (i = 0; i < ms_zDrawRectFontStr.length && ms_zDrawRectFontStr[i] != null; ++i) {
            if (_iChars < (ms_iDrawRectChars += ms_zDrawRectFontStr[i].length() - 1)) {
                FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX, iPY, _iFontAnchor, ms_zDrawRectFontStr[i].length() - 1 - (ms_iDrawRectChars - _iChars));
                break;
            }
            FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX, iPY, _iFontAnchor, -1);
            iPY += _iFontSpacingY;
        }
    }

    public static byte SplitString(String[] _iTextArray, short[] _iTextIndexes, int _iWidth, int _iFontID) {
        String[] zText = new String[_iTextIndexes.length];
        for (int i = 0; i < zText.length; ++i) {
            zText[0] = _iTextArray[_iTextIndexes[i]];
        }
        return FntManager.SplitString(zText, _iWidth, _iFontID);
    }

    public static byte SplitString(String[] _iTextArray, int _iWidth, int _iFontID) {
        int iIndex = 0;
        int iInicio = 0;
        int iFinal = 0;
        int iFrase = 0;
        int iWidth = 0;
        byte iLineasGuardadas = 0;
        ms_iDrawRectFontLetters = 0;
        for (int i = 0; i < ms_zDrawRectFontStr.length; ++i) {
            FntManager.ms_zDrawRectFontStr[i] = null;
        }
        while (iFrase < _iTextArray.length) {
            String zFrase = _iTextArray[iFrase];
            while (zFrase != null && iIndex < zFrase.length()) {
                boolean bCheckPoint;
                boolean bJapanese = MGCC.ms_zLanguage.equals("ja") && zFrase.charAt(iIndex) > '\u00ff';
                boolean bl = bCheckPoint = zFrase.charAt(iIndex) == ' ' || zFrase.charAt(iIndex) == '/' || bJapanese;
                if (bCheckPoint || iIndex + 1 == zFrase.length()) {
                    int n = iWidth = iInicio < iIndex + 1 ? FntManager.StringWidth(_iFontID, zFrase.substring(iInicio, iIndex + 1)) : 0;
                }
                if ((bCheckPoint || iIndex + 1 == zFrase.length()) && iWidth < _iWidth) {
                    iFinal = iIndex + 1;
                }
                if (bCheckPoint && iWidth >= _iWidth || iIndex + 1 == zFrase.length()) {
                    if (iInicio == iFinal) {
                        iFinal = iIndex;
                    }
                    if (iInicio == iFinal) {
                        iFinal = iIndex;
                    }
                    FntManager.ms_zDrawRectFontStr[iLineasGuardadas] = zFrase.substring(iInicio, iFinal);
                    ms_iDrawRectFontLetters = (short)(ms_iDrawRectFontLetters + (iFinal - iInicio));
                    iLineasGuardadas = (byte)(iLineasGuardadas + 1);
                    iInicio = iFinal;
                    iFinal = iIndex + 1;
                }
                if (++iIndex < zFrase.length() || iInicio >= iIndex) continue;
                FntManager.ms_zDrawRectFontStr[iLineasGuardadas] = zFrase.substring(iInicio, iIndex);
                ms_iDrawRectFontLetters = (short)(ms_iDrawRectFontLetters + (iIndex - iInicio));
                iLineasGuardadas = (byte)(iLineasGuardadas + 1);
            }
            ++iFrase;
            iIndex = 0;
            iInicio = 0;
            iFinal = 0;
            iWidth = 0;
        }
        ms_iDrawRectFontLines = iLineasGuardadas;
        return iLineasGuardadas;
    }

    static {
        APOSTROPHE_LATIN = new char[][]{{'`', '\u00b4', '\u02c6', '\u02dc', '\u00a8'}, {'`', '\u00b4', '\u02c6', '\u00a8'}};
        ms_iFontType = 1;
        ms_zDrawRectFontStr = new String[32];
        int iMove = 4;
        for (int i = 0; i < 64; ++i) {
        }
    }
}

