/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.MGCC;

import com.kitmaker.MGCC.FntManager;
import com.kitmaker.MGCC.SndManager;
import javak.microedition.lcdui.Graphics;

public class VirtualKeyBoard {
    private int ms_iPosX;
    private int ms_iPosY;
    private int ms_iFontID;
    private int ms_iWidth;
    private int ms_iHeight;
    private int keySeparation;
    private int keySizeX = 0;
    private int keySizeY = 0;
    private static String[][] TECLADO_VIRTUAL = new String[][]{{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P"}, {"A", "S", "D", "F", "G", "H", "J", "K", "L", "\u00d1"}, {"Z", "X", "C", "V", "B", "N", "M", ">", "<"}};
    private int[][][] posicionesTecladoVirtual = new int[TECLADO_VIRTUAL.length][TECLADO_VIRTUAL[0].length][2];
    private int[] deltaXPosRow = new int[3];
    private int[] focusKey = new int[2];
    private static final char NULL_CHAR = '#';
    private char charSelected = (char)35;
    public static boolean ms_bPressedKey;

    public boolean hasCharOnBuffer() {
        return this.charSelected != '#';
    }

    public VirtualKeyBoard(int _iFontID, int _iY, int _iDiametreX, int _iDiametreY, int _iSeparation) {
        this.ms_iFontID = _iFontID;
        this.ms_iPosY = _iY;
        this.keySizeX = _iDiametreX;
        this.keySizeY = _iDiametreY;
        this.keySeparation = _iSeparation;
        this.ms_iWidth = TECLADO_VIRTUAL[0].length * (this.keySizeX + this.keySeparation) - this.keySeparation * 2;
        this.ms_iPosX = 88 - (this.ms_iWidth >> 1);
        this.ms_iHeight = (FntManager.FNT_MAXHEIGHT[this.ms_iFontID] + this.keySeparation) * TECLADO_VIRTUAL.length;
        this.deltaXPosRow[0] = 0;
        this.deltaXPosRow[1] = (this.ms_iWidth >> 1) - (TECLADO_VIRTUAL[1].length * (this.keySizeX + this.keySeparation) - this.keySeparation * 2 >> 1);
        this.deltaXPosRow[2] = (this.ms_iWidth >> 1) - (TECLADO_VIRTUAL[2].length * (this.keySizeX + this.keySeparation) - this.keySeparation * 2 >> 1);
        int tmpX = this.ms_iPosX;
        int tmpY = this.ms_iPosY;
        for (int r = 0; r < TECLADO_VIRTUAL.length; ++r) {
            tmpX = this.ms_iPosX + this.deltaXPosRow[r];
            for (int c = 0; c < TECLADO_VIRTUAL[r].length; ++c) {
                this.posicionesTecladoVirtual[r][c][0] = tmpX;
                this.posicionesTecladoVirtual[r][c][1] = tmpY;
                tmpX += this.keySizeX + this.keySeparation;
            }
            tmpY += this.keySizeY + this.keySeparation;
        }
    }

    public int getWidht() {
        return this.ms_iWidth;
    }

    public int getHeight() {
        return this.ms_iHeight;
    }

    public void paint(Graphics _g, int _iExtraX) {
        int tmpy = this.ms_iPosY;
        int focusPosX = -1;
        int focusPosY = -1;
        String zFocusLetter = "";
        for (int r = 0; r < TECLADO_VIRTUAL.length; ++r) {
            int tmpx = this.ms_iPosX + this.deltaXPosRow[r] + _iExtraX;
            for (int c = 0; c < TECLADO_VIRTUAL[r].length; ++c) {
                if (r == this.focusKey[0] && c == this.focusKey[1]) {
                    focusPosX = tmpx;
                    focusPosY = tmpy;
                    zFocusLetter = TECLADO_VIRTUAL[r][c];
                }
                if (TECLADO_VIRTUAL[r][c].equals(">")) {
                    _g.setColor(-48128);
                    _g.fillTriangle(tmpx + (this.keySizeX >> 1), tmpy + (this.keySizeY >> 1) - 5, tmpx + (this.keySizeX >> 1) + 5, tmpy + (this.keySizeY >> 1), tmpx + (this.keySizeX >> 1), tmpy + (this.keySizeY >> 1) + 5);
                } else if (TECLADO_VIRTUAL[r][c].equals("<")) {
                    _g.setColor(-48128);
                    _g.fillTriangle(tmpx + (this.keySizeX >> 1) - 2, tmpy + (this.keySizeY >> 1), tmpx + (this.keySizeX >> 1) + 2, tmpy + (this.keySizeY >> 1) - 5, tmpx + (this.keySizeX >> 1) + 2, tmpy + (this.keySizeY >> 1) + 5);
                } else {
                    FntManager.DrawFont(_g, 2, TECLADO_VIRTUAL[r][c], tmpx + (this.keySizeX >> 1), tmpy + (this.keySizeY >> 1), 3, -1);
                }
                tmpx += this.keySizeX + this.keySeparation;
            }
            tmpy += this.keySizeY + this.keySeparation;
        }
        if (!zFocusLetter.equals("") && ms_bPressedKey) {
            _g.setColor(0xFFFFFF);
            _g.fillRoundRect(focusPosX - (this.keySizeY >> 2), (focusPosY -= this.keySizeY) + (this.keySizeY >> 3), this.keySizeX + (this.keySizeY >> 1), this.keySizeY - (this.keySizeY >> 2), this.keySizeX + (this.keySizeY >> 1), this.keySizeY - (this.keySizeY >> 2));
            _g.fillTriangle(focusPosX + (this.keySizeX >> 1) - (this.keySizeX >> 2), focusPosY + this.keySizeY - (this.keySizeY >> 3), focusPosX + (this.keySizeX >> 1) + (this.keySizeX >> 2), focusPosY + this.keySizeY - (this.keySizeY >> 3), focusPosX + (this.keySizeX >> 1), focusPosY + this.keySizeY + (this.keySizeY >> 2));
            if (zFocusLetter.equals(">")) {
                _g.setColor(-48128);
                _g.fillTriangle(focusPosX + (this.keySizeX >> 1), focusPosY + (this.keySizeY >> 1) - 5, focusPosX + (this.keySizeX >> 1) + 5, focusPosY + (this.keySizeY >> 1), focusPosX + (this.keySizeX >> 1), focusPosY + (this.keySizeY >> 1) + 5);
            } else if (zFocusLetter.equals("<")) {
                _g.setColor(-48128);
                _g.fillTriangle(focusPosX + (this.keySizeX >> 1) - 2, focusPosY + (this.keySizeY >> 1), focusPosX + (this.keySizeX >> 1) + 2, focusPosY + (this.keySizeY >> 1) - 5, focusPosX + (this.keySizeX >> 1) + 2, focusPosY + (this.keySizeY >> 1) + 5);
            } else {
                FntManager.DrawFont(_g, 2, zFocusLetter, focusPosX + (this.keySizeX >> 1), focusPosY + (this.keySizeY >> 1), 3, -1);
            }
        }
    }

    public String getCurrentString() {
        if (this.charSelected == '#') {
            return "";
        }
        String ch = "" + this.charSelected;
        this.charSelected = (char)35;
        return ch;
    }

    public char getCurrentChar() {
        if (this.charSelected == '#') {
            return '\u0000';
        }
        char ch = this.charSelected;
        this.charSelected = (char)35;
        return ch;
    }

    public boolean keyboardPressed(int x, int y) {
        int iKeySizeX = this.keySizeX + this.keySeparation;
        int iKeySizeY = this.keySizeY + this.keySeparation;
        ms_bPressedKey = false;
        int keyRow = -1;
        int posy = y - this.ms_iPosY;
        if (posy >= 0 && posy <= iKeySizeY) {
            keyRow = 0;
        } else if (posy >= iKeySizeY && posy <= iKeySizeY << 1) {
            keyRow = 1;
        } else if (posy >= iKeySizeY << 1 && posy <= (iKeySizeY << 1) + iKeySizeY + (iKeySizeY >> 1)) {
            keyRow = 2;
        }
        if (keyRow >= 0) {
            for (int keyColumn = 0; keyColumn < TECLADO_VIRTUAL[keyRow].length; ++keyColumn) {
                int xx = this.posicionesTecladoVirtual[keyRow][keyColumn][0];
                int yy = this.posicionesTecladoVirtual[keyRow][keyColumn][1];
                if (x < xx || x > xx + iKeySizeX || y < yy || y > yy + iKeySizeY) continue;
                if (this.focusKey[0] != keyRow || this.focusKey[1] != keyColumn) {
                    SndManager.PlayFX((byte)1, 0);
                }
                this.focusKey[0] = keyRow;
                this.focusKey[1] = keyColumn;
                ms_bPressedKey = true;
                return ms_bPressedKey;
            }
        }
        return ms_bPressedKey;
    }

    public boolean keyboardReleased(int x, int y) {
        if (!ms_bPressedKey) {
            return false;
        }
        int iKeySizeX = this.keySizeX + this.keySeparation;
        int iKeySizeY = this.keySizeY + this.keySeparation;
        ms_bPressedKey = false;
        int posy = y - this.ms_iPosY;
        int keyRow = -1;
        if (posy >= 0 && posy <= iKeySizeY) {
            keyRow = 0;
        } else if (posy >= iKeySizeY && posy <= iKeySizeY << 1) {
            keyRow = 1;
        } else if (posy >= iKeySizeY << 1 && posy <= (iKeySizeY << 1) + iKeySizeY + (iKeySizeY >> 1)) {
            keyRow = 2;
        }
        if (keyRow >= 0) {
            for (int keyColumn = 0; keyColumn < TECLADO_VIRTUAL[keyRow].length; ++keyColumn) {
                int xx = this.posicionesTecladoVirtual[keyRow][keyColumn][0];
                int yy = this.posicionesTecladoVirtual[keyRow][keyColumn][1];
                if (x < xx || x > xx + iKeySizeX || y < yy || y > yy + iKeySizeY) continue;
                this.charSelected = TECLADO_VIRTUAL[keyRow][keyColumn].charAt(0);
                if (this.charSelected == '>') {
                    this.charSelected = (char)32;
                }
                this.focusKey[0] = keyRow;
                this.focusKey[1] = keyColumn;
                return true;
            }
        }
        return false;
    }
}

