/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.MGCC;

import com.kitmaker.MGCC.Define;
import com.kitmaker.MGCC.MGCC;
import com.kitmaker.MGCC.Main;
import com.kitmaker.MGCC.ModeGame;
import java.io.DataInputStream;
import java.io.InputStream;
import javak.microedition.lcdui.Graphics;
import javak.microedition.lcdui.Image;

public class GfxManager {
    public static final short ANGLE_STEPS = 2048;
    public static final short ANGLE_STEPS2 = 1024;
    public static final short ANGLE_STEPS4 = 512;
    public static final short ANGLE_STEPS8 = 256;
    public static final short ANGLE_STEPS16 = 128;
    public static final int SINCOS_PRECISIONBITS = 16;
    public static int[] SINCOS = new int[]{0, 804, 1608, 2412, 3215, 4018, 4821, 5622, 6423, 7223, 8022, 8819, 9616, 10410, 11204, 11995, 12785, 13573, 14359, 15142, 15923, 16702, 17479, 18253, 19024, 19792, 20557, 21319, 22078, 22833, 23586, 24334, 25079, 25820, 26557, 27291, 28020, 28745, 29465, 30181, 30893, 31600, 32302, 32999, 33692, 34379, 35061, 35738, 36409, 37075, 37736, 38390, 39039, 39682, 40319, 40950, 41575, 42194, 42806, 43412, 44011, 44603, 45189, 45768, 46340, 46906, 47464, 48015, 48558, 49095, 49624, 50146, 50660, 51166, 51665, 52155, 52639, 53114, 53581, 54040, 54491, 54933, 55368, 55794, 56212, 56621, 57022, 57414, 57797, 58172, 58538, 58895, 59243, 59583, 59913, 60235, 60547, 60850, 61144, 61429, 61705, 61971, 62228, 62475, 62714, 62942, 63162, 63371, 63571, 63762, 63943, 64115, 64276, 64428, 64571, 64703, 64826, 64939, 65043, 65136, 65220, 65294, 65358, 65412, 65457, 65491, 65516, 65531, 65536, 65531, 65516, 65491, 65457, 65412, 65358, 65294, 65220, 65136, 65043, 64939, 64826, 64703, 64571, 64428, 64276, 64115, 63943, 63762, 63571, 63371, 63162, 62942, 62714, 62475, 62228, 61971, 61705, 61429, 61144, 60850, 60547, 60235, 59913, 59583, 59243, 58895, 58538, 58172, 57797, 57414, 57022, 56621, 56212, 55794, 55368, 54933, 54491, 54040, 53581, 53114, 52639, 52155, 51665, 51166, 50660, 50146, 49624, 49095, 48558, 48015, 47464, 46906, 46340, 45768, 45189, 44603, 44011, 43412, 42806, 42194, 41575, 40950, 40319, 39682, 39039, 38390, 37736, 37075, 36409, 35738, 35061, 34379, 33692, 32999, 32302, 31600, 30893, 30181, 29465, 28745, 28020, 27291, 26557, 25820, 25079, 24334, 23586, 22833, 22078, 21319, 20557, 19792, 19024, 18253, 17479, 16702, 15923, 15142, 14359, 13573, 12785, 11995, 11204, 10410, 9616, 8819, 8022, 7223, 6423, 5622, 4821, 4018, 3215, 2412, 1608, 804, 0, -804, -1608, -2412, -3215, -4018, -4821, -5622, -6423, -7223, -8022, -8819, -9616, -10410, -11204, -11995, -12785, -13573, -14359, -15142, -15923, -16702, -17479, -18253, -19024, -19792, -20557, -21319, -22078, -22833, -23586, -24334, -25079, -25820, -26557, -27291, -28020, -28745, -29465, -30181, -30893, -31600, -32302, -32999, -33692, -34379, -35061, -35738, -36409, -37075, -37736, -38390, -39039, -39682, -40319, -40950, -41575, -42194, -42806, -43412, -44011, -44603, -45189, -45768, -46340, -46906, -47464, -48015, -48558, -49095, -49624, -50146, -50660, -51166, -51665, -52155, -52639, -53114, -53581, -54040, -54491, -54933, -55368, -55794, -56212, -56621, -57022, -57414, -57797, -58172, -58538, -58895, -59243, -59583, -59913, -60235, -60547, -60850, -61144, -61429, -61705, -61971, -62228, -62475, -62714, -62942, -63162, -63371, -63571, -63762, -63943, -64115, -64276, -64428, -64571, -64703, -64826, -64939, -65043, -65136, -65220, -65294, -65358, -65412, -65457, -65491, -65516, -65531, -65536, -65531, -65516, -65491, -65457, -65412, -65358, -65294, -65220, -65136, -65043, -64939, -64826, -64703, -64571, -64428, -64276, -64115, -63943, -63762, -63571, -63371, -63162, -62942, -62714, -62475, -62228, -61971, -61705, -61429, -61144, -60850, -60547, -60235, -59913, -59583, -59243, -58895, -58538, -58172, -57797, -57414, -57022, -56621, -56212, -55794, -55368, -54933, -54491, -54040, -53581, -53114, -52639, -52155, -51665, -51166, -50660, -50146, -49624, -49095, -48558, -48015, -47464, -46906, -46340, -45768, -45189, -44603, -44011, -43412, -42806, -42194, -41575, -40950, -40319, -39682, -39039, -38390, -37736, -37075, -36409, -35738, -35061, -34379, -33692, -32999, -32302, -31600, -30893, -30181, -29465, -28745, -28020, -27291, -26557, -25820, -25079, -24334, -23586, -22833, -22078, -21319, -20557, -19792, -19024, -18253, -17479, -16702, -15923, -15142, -14359, -13573, -12785, -11995, -11204, -10410, -9616, -8819, -8022, -7223, -6423, -5622, -4821, -4018, -3215, -2412, -1608, -804};
    static final int ZOOM_FAR = 0;
    static final int ZOOM_NEAR = 1;
    static int ms_iZoom = 0;
    static final String GFX_FILE = "/gfx";
    static final String SPRDATA_FILE = "/sprdata";
    static int[] ms_iLoadedGfxBM = new int[4];
    static int[] ms_iLoadingGfxBM = new int[4];
    static int ms_iGfxPrepared;
    static Image[] ms_vBuildImgList;
    static final byte[] CHNK_IHDR;
    static final byte PAL_LOADED = 0;
    static final byte PAL_LOADING = 1;
    static short[][] ms_iGfxData;
    static final int TRANS_FLIPH = 2;
    static final int TRANS_FLIPV = 1;
    static final String GFX_PREV = "/";
    static final String GFX_FORMAT = ".png";
    static final String[] GFX_FILENAME;
    static final byte FLG_TRANSFORMABLE = 1;
    static final byte FLG_OPAQUE = 2;
    static byte[] GFX_FLAGS;
    static final int GFXID_KITLOGO = 0;
    static final int GFXID_GAME_HUD = 1;
    static final int GFXID_MENU_SOFTKEYS = 2;
    static final int GFXID_W0_FARSET1 = 3;
    static final int GFXID_W0_FARSET2 = 4;
    static final int GFXID_W0_FARSET3 = 5;
    static final int GFXID_W0_FARSET4 = 6;
    static final int GFXID_W0_NEARSET1 = 7;
    static final int GFXID_W0_NEARSET2 = 8;
    static final int GFXID_W0_NEARSET3 = 9;
    static final int GFXID_W0_NEARSET4 = 10;
    static final int GFXID_W1_FARSET1 = 11;
    static final int GFXID_W1_FARSET2 = 12;
    static final int GFXID_W1_FARSET3 = 13;
    static final int GFXID_W1_FARSET4 = 14;
    static final int GFXID_W1_NEARSET1 = 15;
    static final int GFXID_W1_NEARSET2 = 16;
    static final int GFXID_W1_NEARSET3 = 17;
    static final int GFXID_W1_NEARSET4 = 18;
    static final int GFXID_W2_FARSET1 = 19;
    static final int GFXID_W2_FARSET2 = 20;
    static final int GFXID_W2_FARSET3 = 21;
    static final int GFXID_W2_FARSET4 = 22;
    static final int GFXID_W2_NEARSET1 = 23;
    static final int GFXID_W2_NEARSET2 = 24;
    static final int GFXID_W2_NEARSET3 = 25;
    static final int GFXID_W2_NEARSET4 = 26;
    static final int GFXID_W3_FARSET1 = 27;
    static final int GFXID_W3_FARSET2 = 28;
    static final int GFXID_W3_FARSET3 = 29;
    static final int GFXID_W3_FARSET4 = 30;
    static final int GFXID_W3_NEARSET1 = 31;
    static final int GFXID_W3_NEARSET2 = 32;
    static final int GFXID_W3_NEARSET3 = 33;
    static final int GFXID_W3_NEARSET4 = 34;
    static final int GFXID_W4_FARSET1 = 35;
    static final int GFXID_W4_FARSET2 = 36;
    static final int GFXID_W4_FARSET3 = 37;
    static final int GFXID_W4_FARSET4 = 38;
    static final int GFXID_W4_NEARSET1 = 39;
    static final int GFXID_W4_NEARSET2 = 40;
    static final int GFXID_W4_NEARSET3 = 41;
    static final int GFXID_W4_NEARSET4 = 42;
    static final int GFXID_SHADOW = 43;
    static final int GFXID_WORLDMAP = 44;
    static final int GFXID_WORLDSELECT = 45;
    static final int GFXID_WORLDELEMS = 46;
    static final int GFXID_WORLDHAND = 47;
    static final int GFXID_WORLDCUPS = 48;
    static final int GFXID_WORLDCLOUDS = 49;
    static final int GFXID_CUP = 50;
    static final int GFXID_TITLE_BIG = 51;
    static final int GFXID_TITLE_SMALL = 52;
    static final int GFXID_ORANGE = 53;
    static final int GFXID_CLOUDS_BG = 54;
    static final int GFXID_STRAW = 55;
    static final int GFXID_BALL = 56;
    static final int GFXID_BASE_TITLE = 57;
    static final int GFXID_COW = 58;
    static final int GFXID_MENU_BOTTON = 59;
    static final int GFXID_CHAR_SELECT_BG = 60;
    static final int GFXID_CHAR_1 = 61;
    static final int GFXID_CHAR_2 = 62;
    static final int GFXID_CHAR_3 = 63;
    static final int GFXID_CHAR_4 = 64;
    static final int GFXID_CHAR_DETAIL_1 = 65;
    static final int GFXID_CHAR_DETAIL_2 = 66;
    static final int GFXID_CHAR_DETAIL_3 = 67;
    static final int GFXID_CHAR_DETAIL_4 = 68;
    static final int GFXID_BOTTON_ELEMENT = 69;
    static final int GFXID_COW_PIG = 70;
    static final int GFXID_MENU_STARS = 71;
    static final int GFXID_CHARACTERS_CHALL = 72;
    static final int GFXID_WOMAN_FAR = 73;
    static final int GFXID_SISTERS_FAR = 74;
    static final int GFXID_BARBARIAN_FAR = 75;
    static final int GFXID_ASTRONAUT_FAR = 76;
    static final int GFXID_WOMAN_NEAR = 77;
    static final int GFXID_SISTERS_NEAR = 78;
    static final int GFXID_BARBARIAN_NEAR = 79;
    static final int GFXID_ASTRONAUT_NEAR = 80;
    static final int GFXID_FLAG_FAR = 81;
    static final int GFXID_FLAG_NEAR = 82;
    static final int GFXID_PART_STARS = 83;
    static final int GFXID_GAME_POWUP = 84;
    static final int GFXID_CHAR_ICONS = 85;
    static final int GFXID_W1_MO_FAR = 86;
    static final int GFXID_W1_MO_NEAR = 87;
    static final int GFXID_W2_MO_FAR = 88;
    static final int GFXID_W2_MO_NEAR = 89;
    static final int GFXID_W3_MO_FAR = 90;
    static final int GFXID_W3_MO_NEAR = 91;
    static final int GFXID_W4_MO_FAR = 92;
    static final int GFXID_W4_MO_NEAR = 93;
    static final int GFXID_W1_SO_FAR = 94;
    static final int GFXID_W1_SO_NEAR = 95;
    static final int GFXID_W2_SO_FAR = 96;
    static final int GFXID_W2_SO_NEAR = 97;
    static final int GFXID_W3_SO_FAR = 98;
    static final int GFXID_W3_SO_NEAR = 99;
    static final int GFXID_W4_SO_FAR = 100;
    static final int GFXID_W4_SO_NEAR = 101;
    static final int GFXID_PAD = 102;
    static final int SPR_ID = 0;
    static final int SPR_POS_X = 1;
    static final int SPR_POS_Y = 2;
    static final int SPR_WIDTH = 3;
    static final int SPR_HEIGHT = 4;
    static final int SPR_HOT_X = 5;
    static final int SPR_HOT_Y = 6;
    static short[][] SPRITE_DATA;
    static final int SPRID_GAME_HUD = 0;
    static final int SPRID_SOFTKEYS = 6;
    static final int SPRID_WORLDMAP = 10;
    static final int SPRID_WORLDSELECT = 15;
    static final int SPRID_WORLDELEMENS = 19;
    static final int SPRID_COW_ABDUCED = 34;
    static final int SPRID_WORLD_OVNI = 35;
    static final int SPRID_WORLDCLOUDS = 36;
    static final int SPRID_WORLDELOREAN = 38;
    static final int SPRID_CLOUDS_BG = 42;
    static final int SPRID_BOTTON_MENU = 44;
    static final int SPRID_BOTTON_ELEMENT = 47;
    static final int SPRID_COW_PIG = 50;
    static final int SPRID_STARS = 54;
    static final int SPRID_CHARACTERS_CHALL = 57;
    static final int SPRID_FLAG_FAR = 62;
    static final int SPRID_FLAG_NEAR = 66;
    static final int SPRID_POWERUP = 70;
    static final int SPRID_WORLDCUPS = 74;
    static final int SPRID_W1_MO_FAR = 85;
    static final int SPRID_W1_MO_NEAR = 86;
    static final int SPRID_W2_MO_FAR = 87;
    static final int SPRID_W2_MO_NEAR = 91;
    static final int SPRID_W3_MO_FAR = 95;
    static final int SPRID_W3_MO_NEAR = 101;
    static final int SPRID_W4_MO_FAR = 107;
    static final int SPRID_W4_MO_NEAR = 113;
    static final int SPRID_W1_SO_FAR = 119;
    static final int SPRID_W1_SO_NEAR = 124;
    static final int SPRID_W2_SO_FAR = 119;
    static final int SPRID_W2_SO_NEAR = 124;
    static final int SPRID_W3_SO_FAR = 119;
    static final int SPRID_W3_SO_NEAR = 124;
    static final int SPRID_W4_SO_FAR = 119;
    static final int SPRID_W4_SO_NEAR = 124;
    static final int SPRID_PAD = 129;
    static final int SPRID_PLAYER_ID = 71;
    static final int[] CLOUDS_BG;
    static final int[] BOTTON_MENU;
    static final int[] BOTTON_ELEMENT;
    static final int[] COW_PIG;
    static final int[] STARS;
    static final int[] FLAG_FN;
    static final int[] POWER_UP;
    static final int[][][] MOBILEOBJ_SPRID;
    static final int[][][] STATICOBJ_SPRID;
    static final int[][] PAD;
    public static Image[] ms_Grafico;
    static int[] ms_iGfxStart;
    static int[] ms_iGfxPixelsArea;
    static byte ms_iNumGfx;
    static byte ms_iNumPalettes;
    static int[] ms_iPalStart;
    static int[] ms_iPalSize;
    public static InputStream ms_vRscPalInput;
    static int ms_iLoadingBarTotal;
    static int ms_iLoadingBarCurrent;
    static boolean ms_bLoadingBarActive;
    static int ms_bLoadingBarFrame;
    static int ms_iNumLoadings;
    static int ms_iChunkSearchIndex;
    static byte[] ms_iChunkSearchBuffer;
    private static final int FP_SHIFT = 13;
    public static final int FAST_RESAMPLE = 0;
    public static final int SLOW_RESAMPLE = 1;
    public static final int RESAMPLE = 1;
    private static final int FP_BITS = 13;
    static int ms_iRGBTransparentColor;
    static int ms_iTransparentColor;
    static Image ms_vTransparentImage;
    static final int[] THUNDER_COLOR;
    static final byte THUNDER_SECTIONS = 8;
    static final byte THUNDER_RANDOM_FACTOR = 11;
    static final int SUN_ANGLE_INC = 16;
    public static final int SUN_RADIUS;
    static final int SUN_FRAMES = 32;
    static final int SUN_SPEED = 2;
    public static final int APPEARING = 0;
    public static final int DISAPPEARING = 1;
    private static int[][] ms_bStars;
    private static final int STARS_NUMBER = 50;
    private static int ms_iCount;
    private static int ms_iCountDraw;
    private static int ms_iPosX;
    private static int ms_iPosY;
    public static int ms_iTimeTransition;

    static void InitSpriteManager() {
        try {
            ms_iNumGfx = (byte)GFX_FILENAME.length;
            ms_iGfxPixelsArea = new int[ms_iNumGfx];
            DataInputStream ms_vRscInput = new DataInputStream(((Object)((Object)MGCC.ms_vInstance)).getClass().getResourceAsStream("/imagecoords.dat"));
            int iNumImages = ms_vRscInput.readShort();
            for (int i = 0; i < iNumImages; ++i) {
                GfxManager.ms_iGfxPixelsArea[i] = ms_vRscInput.readInt();
            }
            ms_vRscInput.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ms_iGfxData = new short[ms_iNumGfx][2];
        ms_Grafico = new Image[ms_iNumGfx];
    }

    public static void ResetGraphics() {
        for (int i = 0; i < ms_iLoadingGfxBM.length; ++i) {
            GfxManager.ms_iLoadingGfxBM[i] = 0;
        }
        ms_iGfxPrepared = 0;
    }

    public static void UnloadGraphics() {
        for (int i = 0; i < ms_Grafico.length; ++i) {
            GfxManager.ms_Grafico[i] = null;
        }
        System.gc();
    }

    public static void SetGraphics(short[] _iGfxList) {
        GfxManager.ResetGraphics();
        for (int i = 0; i < _iGfxList.length; ++i) {
            GfxManager.AddGraphic(_iGfxList[i]);
        }
    }

    public static void AddGraphic(int _iGfxID) {
        if (_iGfxID != -1 && (ms_iLoadingGfxBM[_iGfxID >> 5] & 1 << (_iGfxID & 0x1F)) == 0) {
            int n = _iGfxID >> 5;
            ms_iLoadingGfxBM[n] = ms_iLoadingGfxBM[n] | 1 << (_iGfxID & 0x1F);
            ++ms_iGfxPrepared;
        }
    }

    public static void FlushGraphics() {
        int i;
        int iGfxBitmap = 0;
        int iGfxBit = 0;
        for (i = 0; i < ms_iNumGfx; ++i) {
            int iBit = 1 << iGfxBit;
            if ((ms_iLoadedGfxBM[iGfxBitmap] & iBit) != 0) {
                GfxManager.ms_Grafico[i] = null;
            }
            if ((iGfxBit = (int)((byte)(iGfxBit + 1))) < 32) continue;
            iGfxBit = 0;
            iGfxBitmap = (byte)(iGfxBitmap + 1);
        }
        for (i = 0; i < ms_iLoadedGfxBM.length; ++i) {
            GfxManager.ms_iLoadedGfxBM[i] = 0;
        }
    }

    public static void LoadGraphics(boolean _bShowLoadingBar) {
        int iBit;
        int i;
        if (ms_iNumLoadings > 0 && _bShowLoadingBar) {
            ms_bLoadingBarActive = true;
            ms_bLoadingBarFrame = 0;
        }
        if (ms_bLoadingBarActive) {
            ms_iLoadingBarCurrent = 0;
            ms_iLoadingBarTotal = 1;
            Main.ms_vMain.repaint();
            Main.ms_vMain.serviceRepaints();
        }
        int iGfxBitmap = 0;
        int iGfxBit = 0;
        for (i = 0; i < ms_iNumGfx; ++i) {
            iBit = 1 << iGfxBit;
            if ((ms_iLoadingGfxBM[iGfxBitmap] & iBit) == 0 && (ms_iLoadedGfxBM[iGfxBitmap] & iBit) != 0) {
                GfxManager.ms_Grafico[i] = null;
            }
            if ((iGfxBit = (int)((byte)(iGfxBit + 1))) < 32) continue;
            iGfxBit = 0;
            iGfxBitmap = (byte)(iGfxBitmap + 1);
        }
        System.gc();
        int[] iSortedGfx = new int[ms_iGfxPrepared];
        int[] iSortedGfxArea = new int[ms_iGfxPrepared];
        int iLoadingGfxIndex = 0;
        iGfxBitmap = 0;
        iGfxBit = 0;
        for (i = 0; i < ms_iNumGfx; ++i) {
            iBit = 1 << iGfxBit;
            if ((ms_iLoadingGfxBM[iGfxBitmap] & iBit) != 0) {
                iSortedGfx[iLoadingGfxIndex] = i;
                iSortedGfxArea[iLoadingGfxIndex] = ms_iGfxPixelsArea[i];
                ++iLoadingGfxIndex;
            }
            if ((iGfxBit = (int)((byte)(iGfxBit + 1))) < 32) continue;
            iGfxBit = 0;
            iGfxBitmap = (byte)(iGfxBitmap + 1);
        }
        for (i = 0; i < ms_iGfxPrepared - 1; ++i) {
            for (int j = ms_iGfxPrepared - 2; j >= i; --j) {
                if (iSortedGfxArea[j] >= iSortedGfxArea[j + 1]) continue;
                int iAux = iSortedGfxArea[j];
                iSortedGfxArea[j] = iSortedGfxArea[j + 1];
                iSortedGfxArea[j + 1] = iAux;
                iAux = iSortedGfx[j];
                iSortedGfx[j] = iSortedGfx[j + 1];
                iSortedGfx[j + 1] = iAux;
            }
        }
        iGfxBit = iGfxBitmap;
        ms_iLoadingBarTotal = ms_iGfxPrepared;
        for (i = 0; i < ms_iGfxPrepared; ++i) {
            if (ms_bLoadingBarActive) {
                ms_iLoadingBarCurrent = i;
                Main.ms_vMain.repaint();
                Main.ms_vMain.serviceRepaints();
            }
            if ((ms_iLoadingGfxBM[iGfxBitmap = (int)((byte)(iSortedGfx[i] / 32))] & (iBit = 1 << iSortedGfx[i] % 32)) != 0 && (ms_iLoadedGfxBM[iGfxBitmap] & iBit) == 0) {
                GfxManager.ms_Grafico[iSortedGfx[i]] = GfxManager.LoadStandardGraphic(iSortedGfx[i]);
            }
            if ((iGfxBit = (int)((byte)(iGfxBit + 1))) < 32) continue;
            iGfxBit = 0;
            iGfxBitmap = (byte)(iGfxBitmap + 1);
        }
        if (ms_bLoadingBarActive) {
            ms_iLoadingBarCurrent = i;
            Main.ms_vMain.repaint();
            Main.ms_vMain.serviceRepaints();
        }
        for (i = 0; i < ms_iLoadedGfxBM.length; ++i) {
            GfxManager.ms_iLoadedGfxBM[i] = ms_iLoadingGfxBM[i];
            GfxManager.ms_iLoadingGfxBM[i] = 0;
        }
        ms_bLoadingBarActive = false;
        System.gc();
        ++ms_iNumLoadings;
    }

    static Image LoadStandardGraphic(int _iGfxID) {
        Image vImg = null;
        try {
            Image vSourceImg = Image.createImage(GFX_FILENAME[_iGfxID]);
            if ((GFX_FLAGS[_iGfxID] & 2) != 0) {
                vImg = Image.createImage(vSourceImg.getWidth(), vSourceImg.getHeight());
                vImg.getGraphics().drawImage(vSourceImg, 0, 0, 0);
            } else {
                vImg = vSourceImg;
            }
            GfxManager.ms_iGfxData[_iGfxID][0] = (short)vImg.getWidth();
            GfxManager.ms_iGfxData[_iGfxID][1] = (short)vImg.getHeight();
        }
        catch (Exception ex) {
            System.gc();
            Runtime.getRuntime().gc();
        }
        System.gc();
        return vImg;
    }

    static int SearchPNGChunk(byte[] _iBuffer, byte[] _iChunkString, int _iStartPos, int _iMaxBlock) {
        int i;
        int iChunkDataStart = -1;
        for (i = 0; i < ms_iChunkSearchBuffer.length; ++i) {
            GfxManager.ms_iChunkSearchBuffer[i] = 0;
        }
        ms_iChunkSearchIndex = 0;
        for (i = _iStartPos; iChunkDataStart == -1 && i < _iStartPos + _iMaxBlock; ++i) {
            int j;
            GfxManager.ms_iChunkSearchBuffer[GfxManager.ms_iChunkSearchIndex] = _iBuffer[i];
            ms_iChunkSearchIndex = (byte)((ms_iChunkSearchIndex + 1) % 6);
            for (j = 0; j < 4 && ms_iChunkSearchBuffer[(ms_iChunkSearchIndex + 2 + j) % 6] == _iChunkString[j]; ++j) {
            }
            if (j != 4) continue;
            iChunkDataStart = i + 1;
        }
        return iChunkDataStart;
    }

    static Image resizeImage(Image src, int mode) {
        try {
            int srcW = src.getWidth();
            int srcH = src.getHeight();
            int destW = (srcW << 13) * 176 / 240 >> 13;
            int destH = (srcH << 13) * 206 / 320 >> 13;
            int[] srcPixels = new int[srcW];
            int[] destPixels = new int[destW * destH];
            int ratioW = (srcW << 13) / destW;
            int ratioH = (srcH << 13) / destH;
            if (mode == 0) {
                long ini = System.currentTimeMillis();
                int p = 0;
                for (int destY = 0; destY < destH; ++destY) {
                    int srcY = destY * ratioH >> 13;
                    src.getRGB(srcPixels, 0, srcW, 0, srcY, srcW, 1);
                    for (int destX = 0; destX < destW; ++destX) {
                        int srcX = destX * ratioW >> 13;
                        destPixels[p++] = srcPixels[srcX];
                    }
                }
                System.out.println("fast: " + (System.currentTimeMillis() - ini) + "ms");
            } else {
                int a;
                int r;
                int g;
                int b;
                int count;
                long ini = System.currentTimeMillis();
                byte[] tmpA = new byte[destW * srcH];
                byte[] tmpR = new byte[tmpA.length];
                byte[] tmpG = new byte[tmpA.length];
                byte[] tmpB = new byte[tmpA.length];
                int p = 0;
                for (int y = 0; y < srcH; ++y) {
                    src.getRGB(srcPixels, 0, srcW, 0, y, srcW, 1);
                    for (int x = 0; x < destW; ++x) {
                        int srcX = x * ratioW >> 13;
                        int srcX2 = (x + 1) * ratioW >> 13;
                        if (srcX2 >= srcW) {
                            srcX2 = srcW - 1;
                        }
                        count = srcX2 - srcX + 1;
                        b = 0;
                        g = 0;
                        r = 0;
                        a = 0;
                        while (srcX <= srcX2) {
                            int argb = srcPixels[srcX];
                            a += argb >> 24 & 0xFF;
                            r += argb >> 16 & 0xFF;
                            g += argb >> 8 & 0xFF;
                            b += argb & 0xFF;
                            ++srcX;
                        }
                        tmpA[p] = (byte)(a / count);
                        tmpR[p] = (byte)(r / count);
                        tmpG[p] = (byte)(g / count);
                        tmpB[p] = (byte)(b / count);
                        ++p;
                    }
                }
                for (int x = 0; x < destW; ++x) {
                    int y = 0;
                    int xx = x;
                    while (y < destH) {
                        int srcY = y * ratioH >> 13;
                        int srcY2 = (y + 1) * ratioH >> 13;
                        if (srcY2 >= srcH) {
                            srcY2 = srcH - 1;
                        }
                        count = srcY2 - srcY + 1;
                        p = x + srcY * destW;
                        g = 0;
                        b = 0;
                        r = 0;
                        a = 0;
                        while (srcY <= srcY2) {
                            a += tmpA[p] & 0xFF;
                            r += tmpR[p] & 0xFF;
                            g += tmpG[p] & 0xFF;
                            b += tmpB[p] & 0xFF;
                            ++srcY;
                            p += destW;
                        }
                        destPixels[xx] = a / count << 24 | r / count << 16 | g / count << 8 | b / count;
                        ++y;
                        xx += destW;
                    }
                }
                System.out.println("slow: " + (System.currentTimeMillis() - ini) + "ms");
            }
            return Image.createRGBImage(destPixels, destW, destH, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    static int GetImageWidth(int _iGfxID) {
        return ms_iGfxData[_iGfxID][0];
    }

    static int GetImageHeight(int _iGfxID) {
        return ms_iGfxData[_iGfxID][1];
    }

    static void DrawFlashSprite(int _iSprID, int _iPosX, int _iPosY, int _iTransform, int _iColor) {
        int iDrawRGB_Offset = 0;
        short[] vData = SPRITE_DATA[_iSprID];
        try {
            short srcH;
            int srcW;
            short iPosXClip;
            short iPosYClip;
            int iPosYImg;
            int iPosXImg;
            switch (vData.length) {
                case 1: {
                    iPosXImg = _iPosX;
                    iPosYImg = _iPosY;
                    iPosYClip = 0;
                    iPosXClip = 0;
                    srcW = ms_iGfxData[vData[0]][0];
                    srcH = ms_iGfxData[vData[0]][1];
                    break;
                }
                case 5: {
                    iPosXImg = _iPosX;
                    iPosYImg = _iPosY;
                    iPosXClip = vData[1];
                    iPosYClip = vData[2];
                    srcW = vData[3];
                    srcH = vData[4];
                    break;
                }
                case 7: {
                    iPosXImg = _iPosX - vData[5];
                    iPosYImg = _iPosY - vData[6];
                    iPosXClip = vData[1];
                    iPosYClip = vData[2];
                    srcW = vData[3];
                    srcH = vData[4];
                    if ((_iTransform & 2) != 0) {
                        iPosXImg = _iPosX - (vData[3] - vData[5]);
                    }
                    if ((_iTransform & 1) == 0) break;
                    iPosYImg = _iPosY - (vData[4] - vData[6]);
                    break;
                }
                default: {
                    return;
                }
            }
            int[] srcPixels = new int[srcW];
            int[] destPixels = new int[srcW];
            int iInitialY = 0;
            if (iPosYImg < 0) {
                iInitialY = -iPosYImg;
            }
            for (int iY = iInitialY; iY < srcH; ++iY) {
                int iX;
                ms_Grafico[vData[0]].getRGB(srcPixels, 0, srcW, iPosXClip, iPosYClip + iY, srcW, 1);
                if ((_iTransform & 2) != 0) {
                    for (iX = 0; iX < srcW; ++iX) {
                        destPixels[srcW - 1 - iX] = srcPixels[iX];
                        if ((destPixels[srcW - 1 - iX] >> 24 & 0xFF) == 0) continue;
                        destPixels[srcW - 1 - iX] = _iColor;
                    }
                } else {
                    for (iX = 0; iX < srcW; ++iX) {
                        destPixels[iX] = srcPixels[iX];
                        if ((destPixels[iX] >> 24 & 0xFF) == 0) continue;
                        destPixels[iX] = _iColor;
                    }
                }
                Main.ms_XGraphics.drawRGB(destPixels, iDrawRGB_Offset, srcW, iPosXImg, iPosYImg + iY, srcW, 1, true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static void DrawStar(Graphics _g, int _iX, int _iY, int _iRadiusExt, int _iRadiusInt, int _iVerts, int _iFrame, int _iColor) {
        int i;
        int[] iCosExt = new int[_iVerts];
        int[] iSinExt = new int[_iVerts];
        int[] iCosInt = new int[_iVerts];
        int[] iSinInt = new int[_iVerts];
        for (i = 0; i < _iVerts; ++i) {
            int angle = 512 * i / 5;
            iCosExt[i] = -_iRadiusExt * SINCOS[(angle + _iFrame) % 512] >> 16;
            iSinExt[i] = -_iRadiusExt * SINCOS[(angle + _iFrame + 127) % 512] >> 16;
            iCosInt[i] = _iRadiusInt * SINCOS[(angle + _iFrame) % 512] >> 16;
            iSinInt[i] = _iRadiusInt * SINCOS[(angle + _iFrame + 127) % 512] >> 16;
        }
        _g.setColor(_iColor);
        for (i = 0; i < _iVerts; ++i) {
            _g.fillTriangle(_iX + iCosExt[i + 0], _iY + iSinExt[i + 0], _iX + iCosInt[(i + _iVerts / 2) % _iVerts], _iY + iSinInt[(i + _iVerts / 2) % _iVerts], _iX + iCosInt[(i + 1 + _iVerts / 2) % _iVerts], _iY + iSinInt[(i + 1 + _iVerts / 2) % _iVerts]);
            _g.fillTriangle(_iX + iCosInt[0], _iY + iSinInt[0], _iX + iCosInt[i % _iVerts], _iY + iSinInt[i % _iVerts], _iX + iCosInt[(i + 1) % _iVerts], _iY + iSinInt[(i + 1) % _iVerts]);
        }
    }

    static void DrawThunder(Graphics _g, int _x0, int _y0, int _x1, int _y1, int _density, int _sections, int _color) {
        int k;
        int j;
        int[] iX = new int[_sections + 1];
        int[] iY = new int[_sections + 1];
        _g.setColor(_color);
        iX[0] = _x0;
        iY[0] = _y0;
        iX[_sections] = _x1;
        iY[_sections] = _y1;
        for (j = 1; j < _sections + 1; ++j) {
            iX[j] = _x0 + (_x1 - _x0) / _sections * j + Main.ms_Random.nextInt() % 11;
            iY[j] = _y0 + (_y1 - _y0) / _sections * j + Main.ms_Random.nextInt() % 11;
        }
        if (_density == 1) {
            for (j = 0; j < _sections; ++j) {
                _g.drawLine(iX[j], iY[j], iX[j + 1], iY[j + 1]);
            }
        } else if (Math.abs(_x0 - _x1) > Math.abs(_y0 - _y1)) {
            for (k = 0; k < _density; ++k) {
                for (int j2 = 0; j2 < _sections; ++j2) {
                    _g.drawLine(iX[j2], iY[j2] - (_density >> 1) + k, iX[j2 + 1], iY[j2 + 1] - (_density >> 1) + k);
                }
            }
        } else {
            for (k = 0; k < _density; ++k) {
                for (int j3 = 0; j3 < _sections; ++j3) {
                    _g.drawLine(iX[j3] - (_density >> 1) + k, iY[j3], iX[j3 + 1] - (_density >> 1) + k, iY[j3 + 1]);
                }
            }
        }
    }

    static void DrawSun(Graphics _g, int _iColor, int _iX, int _iY, int _iSunRadius, int _iClipX, int _iClipY, int _iClipW, int _iClipH) {
        if (_iSunRadius > 0) {
            _g.setColor(_iColor);
            _g.fillRoundRect(_iX - (_iSunRadius >> 1), _iY - (_iSunRadius >> 1), _iSunRadius, _iSunRadius, _iSunRadius, _iSunRadius);
        }
        int iFrame = (Main.ms_iFrame >> 1) * 2 % 32;
        _g.saveClip();
        _g.clipRect(_iClipX, _iClipY, _iClipW, _iClipH);
        for (int i = 0; i < 512; i += 32) {
            int x1 = _iX + (SUN_RADIUS * SINCOS[(i + iFrame + 127) % 512] >> 16);
            int y1 = _iY + (SUN_RADIUS * SINCOS[(i + iFrame) % 512] >> 16);
            int x2 = _iX + (SUN_RADIUS * SINCOS[(i + iFrame + 16 + 127) % 512] >> 16);
            int y2 = _iY + (SUN_RADIUS * SINCOS[(i + iFrame + 16) % 512] >> 16);
            _g.fillTriangle(_iX, _iY, x1, y1, x2, y2);
        }
        _g.restoreClip();
    }

    static void DrawSun(Graphics _g, int[] _iColor, int _iX, int _iY, int _iSunRadius, int _iExtraDispX, int _iExtraDispY, int _iClipX, int _iClipY, int _iClipW, int _iClipH, int _iFrame) {
        int iFrame = Main.ms_iFrame * 2 % 32;
        _g.saveClip();
        _g.clipRect(_iClipX, _iClipY, _iClipW, _iClipH);
        int iIteration = 0;
        for (int i = 0; i < 512; i += 32) {
            int x0 = _iX + (SUN_RADIUS * SINCOS[(i + iFrame + 127) % 512] >> 16);
            int y0 = _iY + (SUN_RADIUS * SINCOS[(i + iFrame) % 512] >> 16);
            int x1 = _iX + (SUN_RADIUS * SINCOS[(i + iFrame + 16 + 127) % 512] >> 16);
            int y1 = _iY + (SUN_RADIUS * SINCOS[(i + iFrame + 16) % 512] >> 16);
            int x2 = _iX + (SUN_RADIUS * SINCOS[(i + iFrame + 16 + 16 + 127) % 512] >> 16);
            int y2 = _iY + (SUN_RADIUS * SINCOS[(i + iFrame + 16 + 16) % 512] >> 16);
            _g.setColor(_iColor[0]);
            _g.fillTriangle(_iX + _iExtraDispX, _iY + _iExtraDispY, x0, y0, x1, y1);
            _g.setColor(_iColor[1]);
            _g.fillTriangle(_iX + _iExtraDispX, _iY + _iExtraDispY, x1, y1, x2, y2);
            if (_iFrame >> 1 < ++iIteration) break;
        }
        if (_iSunRadius > 0) {
            _g.setColor(_iColor[0]);
            _g.fillRoundRect(_iX + _iExtraDispX - (_iSunRadius >> 1), _iY + _iExtraDispX - (_iSunRadius >> 1), _iSunRadius, _iSunRadius, _iSunRadius, _iSunRadius);
        }
        _g.restoreClip();
    }

    static void DrawTile(int _iSprID, int _iPosX, int _iPosY) {
        int iTransform = 0;
        if (_iSprID < 0) {
            iTransform = 2;
            _iSprID += 128;
        }
        try {
            _iPosY -= Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4] + Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][6];
            if ((iTransform & 2) != 0) {
                Main.ms_XGraphics.setClip(0, 0, 176, 206);
                Main.ms_XGraphics.drawRegion(ms_Grafico[Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][0]], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][1], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][2], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4], iTransform, _iPosX += (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][0][3] >> 1) - (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3] - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][5]), _iPosY, 0);
            } else {
                Main.ms_XGraphics.setClip(_iPosX -= (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][0][3] >> 1) + Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][5], _iPosY, Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4]);
                if (_iSprID >= ModeGame.O_SPEEDUP_DR[ModeGame.ms_iStageField] - 1 && _iSprID < ModeGame.O_SPEEDUP_DR[ModeGame.ms_iStageField] - 1 + 4) {
                    int[] iSpr = new int[]{_iSprID, 0};
                    iSpr = ModeGame.SetSpeedUpImage(iSpr);
                    Main.ms_XGraphics.drawRegion(ms_Grafico[Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][iSpr[0]][0]], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][iSpr[0]][1], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][iSpr[0]][2], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][iSpr[0]][3], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][iSpr[0]][4], iSpr[1], _iPosX, _iPosY, 0);
                } else {
                    Main.ms_XGraphics.drawImage(ms_Grafico[Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][0]], _iPosX - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][1], _iPosY - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][2], 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("" + _iSprID);
        }
    }

    static void DrawTile(Graphics _g, int _iSprID, int _iPosX, int _iPosY) {
        int iTransform = 0;
        if (_iSprID < 0) {
            iTransform = 2;
            _iSprID += 128;
        }
        try {
            _iPosY -= Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4] + Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][6];
            if ((iTransform & 2) != 0) {
                _g.drawRegion(ms_Grafico[Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][0]], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][1], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][2], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4], iTransform, _iPosX += (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][0][3] >> 1) - (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3] - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][5]), _iPosY, 0);
            } else {
                _g.clipRect(_iPosX -= (Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][0][3] >> 1) + Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][5], _iPosY, Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][3], Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][4]);
                _g.drawImage(ms_Grafico[Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][0]], _iPosX - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][1], _iPosY - Define.TILE_DATA[ModeGame.ms_iStageField][ms_iZoom][_iSprID][2], 0);
                _g.restoreClip();
            }
        }
        catch (Exception e) {
            System.out.println("" + _iSprID);
        }
    }

    static void DrawSprite(int _iSprID, int _iPosX, int _iPosY, int _iTransform) {
        if (_iSprID == -1) {
            return;
        }
        short[] vData = SPRITE_DATA[_iSprID];
        if (ms_Grafico[vData[0]] == null) {
            return;
        }
        try {
            int iPosXClip;
            int iPosYClip;
            int iPosYImg;
            int iPosXImg;
            switch (vData.length) {
                case 1: {
                    iPosXImg = _iPosX;
                    iPosYImg = _iPosY;
                    iPosYClip = 0;
                    iPosXClip = 0;
                    break;
                }
                case 5: {
                    iPosXImg = _iPosX - vData[1];
                    iPosYImg = _iPosY - vData[2];
                    iPosXClip = _iPosX;
                    iPosYClip = _iPosY;
                    if ((_iTransform & 2) != 0) {
                        iPosXImg = _iPosX - (ms_iGfxData[vData[0]][0] - vData[1] - vData[3]);
                    }
                    if ((_iTransform & 1) == 0) break;
                    iPosYImg = _iPosY - (ms_iGfxData[vData[0]][1] - vData[2] - vData[4]);
                    break;
                }
                case 7: {
                    iPosXClip = _iPosX - vData[5];
                    iPosYClip = _iPosY - vData[6];
                    iPosXImg = _iPosX - vData[1] - vData[5];
                    iPosYImg = _iPosY - vData[2] - vData[6];
                    if ((_iTransform & 2) != 0) {
                        iPosXClip = _iPosX - (vData[3] - vData[5]);
                        iPosXImg = _iPosX - (ms_iGfxData[vData[0]][0] - vData[1] - vData[3]) - (vData[3] - vData[5]);
                    }
                    if ((_iTransform & 1) == 0) break;
                    iPosYClip = _iPosY + (vData[4] - vData[6]);
                    iPosYImg = _iPosY - (ms_iGfxData[vData[0]][1] - vData[2] - vData[4]) + (vData[4] - vData[6]);
                    iPosYClip -= vData[4];
                    iPosYImg -= vData[4];
                    break;
                }
                default: {
                    return;
                }
            }
            if (_iTransform != 0) {
                Main.ms_XGraphics.drawRegion(ms_Grafico[vData[0]], vData[1], vData[2], vData[3], vData[4], _iTransform, iPosXClip, iPosYClip, 0);
            } else {
                if (vData.length != 1) {
                    Main.ms_XGraphics.clipRect(iPosXClip, iPosYClip, vData[3], vData[4]);
                }
                Main.ms_XGraphics.drawImage(ms_Grafico[vData[0]], iPosXImg, iPosYImg, 20);
                if (vData.length != 1) {
                    Main.ms_XGraphics.restoreClip();
                }
            }
        }
        catch (Exception e) {
            System.out.println("" + e.toString());
            System.out.println("" + vData[0]);
        }
    }

    static void DrawStar(javax.microedition.lcdui.Graphics _g, int _iX, int _iY, int _iRadiusExt, int _iRadiusInt, int _iVerts, int _iFrame, int _iColor) {
        int i;
        int[] iCosExt = new int[_iVerts];
        int[] iSinExt = new int[_iVerts];
        int[] iCosInt = new int[_iVerts];
        int[] iSinInt = new int[_iVerts];
        for (i = 0; i < _iVerts; ++i) {
            int angle = 512 * i / 5;
            iCosExt[i] = -_iRadiusExt * SINCOS[(angle + _iFrame) % 512] >> 16;
            iSinExt[i] = -_iRadiusExt * SINCOS[(angle + _iFrame + 127) % 512] >> 16;
            iCosInt[i] = _iRadiusInt * SINCOS[(angle + _iFrame) % 512] >> 16;
            iSinInt[i] = _iRadiusInt * SINCOS[(angle + _iFrame + 127) % 512] >> 16;
        }
        for (i = 0; i < _iVerts; ++i) {
            _g.fillTriangle(_iX + iCosExt[i + 0], _iY + iSinExt[i + 0], _iX + iCosInt[(i + _iVerts / 2) % _iVerts], _iY + iSinInt[(i + _iVerts / 2) % _iVerts], _iX + iCosInt[(i + 1 + _iVerts / 2) % _iVerts], _iY + iSinInt[(i + 1 + _iVerts / 2) % _iVerts]);
            _g.fillTriangle(_iX + iCosInt[0], _iY + iSinInt[0], _iX + iCosInt[i % _iVerts], _iY + iSinInt[i % _iVerts], _iX + iCosInt[(i + 1) % _iVerts], _iY + iSinInt[(i + 1) % _iVerts]);
        }
    }

    private static void updateStars() {
        block14: for (int i = 0; i < ms_iCount; ++i) {
            if (Main.ms_iFrame % ms_bStars[i][4] != 0) continue;
            block0 : switch (ms_bStars[i][2]) {
                case 0: {
                    switch (ms_bStars[i][3]) {
                        case 0: {
                            GfxManager.ms_bStars[i][3] = 1;
                            break;
                        }
                        case 1: {
                            GfxManager.ms_bStars[i][3] = 0;
                            break;
                        }
                        case 2: {
                            GfxManager.ms_bStars[i][3] = 0;
                        }
                    }
                    continue block14;
                }
                case 1: {
                    switch (ms_bStars[i][3]) {
                        case 0: {
                            GfxManager.ms_bStars[i][3] = 1;
                            break block0;
                        }
                        case 1: {
                            GfxManager.ms_bStars[i][3] = 2;
                            break block0;
                        }
                        case 2: {
                            GfxManager.ms_bStars[i][3] = 1;
                        }
                    }
                }
            }
        }
    }

    static void drawStars(Graphics _g, int state, boolean regular_distribution) {
        if (ms_bStars == null) {
            ms_iPosX = 0;
            ms_iTimeTransition = 0;
            ms_iPosY = -22;
            ms_iCount = 0;
            ms_iCountDraw = 0;
            ms_bStars = new int[50][5];
            for (int i = 0; i < ms_bStars.length; ++i) {
                int mod_y;
                ms_iPosX = !regular_distribution ? (ms_iPosX += Main.Random(11, 22)) : (ms_iPosX += Main.Random(22, 44));
                if (ms_iPosX > 176) {
                    ms_iPosX = Main.Random(11, 22);
                    if (!regular_distribution) {
                        mod_y = ms_iPosY < 0 ? ms_iPosY * -1 : ms_iPosY;
                        ms_iPosY += Main.Random(12, 25) + Main.Random(0, mod_y >> 2);
                    } else {
                        ms_iPosY += Main.Random(25, 51);
                    }
                }
                GfxManager.ms_bStars[i][0] = ms_iPosX;
                if (!regular_distribution) {
                    mod_y = ms_iPosY < 0 ? ms_iPosY * -1 : ms_iPosY;
                    GfxManager.ms_bStars[i][1] = ms_iPosY + Main.Random(12, 25) + Main.Random(0, mod_y >> 1);
                } else {
                    GfxManager.ms_bStars[i][1] = ms_iPosY + Main.Random(25, 51);
                }
                GfxManager.ms_bStars[i][2] = ms_iPosY < 154 ? Main.Random(1, 2) : 0;
                if (!regular_distribution) {
                    int pos_y = ms_iPosY < 0 ? ms_iPosY * -1 : ms_iPosY;
                    GfxManager.ms_bStars[i][2] = Main.Random(0, pos_y) <= Main.Random(0, 51) ? 1 : (Main.Random(0, pos_y) <= Main.Random(0, 103) ? 0 : 2);
                } else {
                    GfxManager.ms_bStars[i][2] = Main.Random(1);
                }
                GfxManager.ms_bStars[i][3] = ms_bStars[i][2] == 2 ? 0 : Main.Random(3);
                GfxManager.ms_bStars[i][4] = ms_bStars[i][2] == 2 ? -1 : Main.Random(4, 16);
                ++ms_iCount;
            }
            int[][] aux = new int[1][4];
            for (int i = 0; i < ms_bStars.length - 1; ++i) {
                for (int x = i + 1; x < ms_bStars.length; ++x) {
                    if (ms_bStars[x][1] >= ms_bStars[i][1]) continue;
                    aux[0][0] = ms_bStars[i][0];
                    aux[0][1] = ms_bStars[i][1];
                    aux[0][2] = ms_bStars[i][2];
                    aux[0][3] = ms_bStars[i][3];
                    GfxManager.ms_bStars[i][0] = ms_bStars[x][0];
                    GfxManager.ms_bStars[i][1] = ms_bStars[x][1];
                    GfxManager.ms_bStars[i][2] = ms_bStars[x][2];
                    GfxManager.ms_bStars[i][3] = ms_bStars[x][3];
                    GfxManager.ms_bStars[x][0] = aux[0][0];
                    GfxManager.ms_bStars[x][1] = aux[0][1];
                    GfxManager.ms_bStars[x][2] = aux[0][2];
                    GfxManager.ms_bStars[x][3] = aux[0][3];
                }
            }
        } else {
            if (state == 0) {
                for (int i = 0; i < ms_iCountDraw; ++i) {
                    GfxManager.DrawSprite(STARS[ms_bStars[i][3]], ms_bStars[i][0], ms_bStars[i][1], 0);
                }
            } else if (state == 1) {
                for (int i = ms_iCountDraw - 1; i > 0; --i) {
                    GfxManager.DrawSprite(STARS[ms_bStars[i][3]], ms_bStars[i][0], ms_bStars[i][1], 0);
                }
            }
            if (Main.ms_iFrame % 2 == 0) {
                GfxManager.updateStars();
                ms_iCountDraw = state == 0 ? ++ms_iCountDraw : --ms_iCountDraw;
            }
            ++ms_iTimeTransition;
            if (ms_iCountDraw > ms_iCount) {
                ms_iCountDraw = ms_iCount;
            } else if (ms_iCountDraw < 0) {
                ms_iCountDraw = 0;
            }
        }
    }

    public static void deleteStars() {
        ms_bStars = null;
    }

    static {
        CHNK_IHDR = new byte[]{73, 72, 68, 82};
        GFX_FILENAME = new String[]{"/logo.png", "/g_sk.png", "/m_sk.png", "/w0_1_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w0_2_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w0_3_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w0_4_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w0_1_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w0_2_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w0_3_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w0_4_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w1_1_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_2_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_3_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_4_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_1_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w1_2_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w1_3_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w1_4_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_1_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_2_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_3_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_4_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_1_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_2_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_3_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_4_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_1_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_2_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_3_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_4_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_1_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_2_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_3_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_4_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_1_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_2_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_3_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_4_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_1_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_2_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_3_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_4_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/s_shadow.png", "/w_map.png", "/w_select.png", "/w_elements.png", "/w_hand.png", "/w_cups.png", "/w_clouds.png", "/copa.png", "/crazy1.png", "/crazy2.png", "/naranja.png", "/m_cloud.png", "/pajita.png", "/pelota.png", "/text.png", "/vaca.png", "/botton.png", "/s_bg.png", "/s_char_1.png", "/s_char_2.png", "/s_char_3.png", "/s_char_4.png", "/s_face_1.png", "/s_face_2.png", "/s_face_3.png", "/s_face_4.png", "/botton_elem.png", "/m_pig.png", "/m_star.png", "/w_chars.png", "/mujer_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/gemelas_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/barbaro_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/astronauta_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/mujer_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/gemelas_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/barbaro_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/astronauta_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/flag_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/flag_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/g_stars.png", "/g_powup.png", "/g_chars.png", "/w1_mo_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_mo_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_mo_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_mo_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_mo_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_mo_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_mo_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_mo_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w1_so_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w1_so_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w2_so_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w2_so_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w3_so" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w3_so" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/w4_so_" + Define.GFX_SET_INDEX[0] + GFX_FORMAT, "/w4_so_" + Define.GFX_SET_INDEX[1] + GFX_FORMAT, "/pad.png"};
        GFX_FLAGS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        SPRITE_DATA = new short[][]{{1, 0, 0, 34, 36, 17, 18}, {1, 34, 0, 20, 36, 10, 18}, {1, 54, 0, 22, 36, 12, 18}, {1, 77, 3, 7, 7, 3, 3}, {1, 77, 17, 7, 3, 3, 1}, {1, 85, 0, 20, 36, 10, 28}, {2, 0, 0, 26, 32, 13, 16}, {2, 27, 0, 30, 32, 15, 16}, null, null, {44, 0, 125, 71, 111, 96, 112}, {44, 71, 0, 65, 236, 110, 58}, {44, 136, 0, 156, 140, 45, 58}, {44, 136, 139, 108, 95, 0, 67}, {44, 0, 57, 58, 68, -49, 116}, {45, 0, 102, 76, 117, 99, 115}, {45, 76, 73, 228, 146, 114, 61}, {45, 0, 0, 114, 100, 3, 67}, {45, 114, 0, 63, 73, -47, 118}, {46, 0, 0, 71, 75, 111, -3}, {46, 71, 0, 71, 75, 111, -3}, {46, 0, 75, 56, 42, -47, 36}, {46, 56, 75, 45, 50, 74, 93}, {44, 22, 44, 11, 12, 82, 83}, {44, 33, 44, 11, 12, 82, 83}, {44, 44, 44, 11, 12, 82, 83}, {44, 267, 193, 25, 14, -40, -34}, {44, 246, 219, 24, 14, -40, -28}, {44, 276, 175, 15, 11, -65, 89}, {44, 264, 208, 11, 11, -67, 116}, {44, 275, 207, 8, 12, -70, 117}, {44, 283, 209, 9, 10, -69, 115}, {44, 270, 219, 22, 10, 67, -19}, {44, 33, 0, 27, 22, 0, 75}, {44, 42, 10, 3, 3, 0, 0}, {44, 0, 46, 15, 10, 8, 5}, {49, 43, 0, 46, 35, 0, 0}, {49, 79, 35, 31, 18, 0, 0}, {49, 0, 0, 43, 28, 21, 14}, {49, 29, 35, 23, 25, 10, 12}, {49, 52, 35, 27, 24, 13, 12}, {49, 0, 28, 29, 33, 14, 16}, {54, 0, 0, 80, 52, 40, 25}, {54, 0, 53, 118, 29, 59, 14}, {59, 0, 0, 139, 28, 69, 14}, {59, 0, 28, 139, 26, 69, 14}, {59, 0, 54, 139, 26, 69, 14}, {69, 0, 0, 29, 21, 0, 10}, {69, 29, 0, 22, 21, 0, 10}, {69, 51, 13, 8, 8, 4, 4}, {70, 0, 0, 27, 31, 13, 10}, {70, 0, 54, 24, 27, 12, 16}, {70, 0, 31, 25, 23, 17, 11}, {70, 26, 14, 36, 67, 18, 33}, {71, 0, 3, 2, 2, 1, 1}, {71, 2, 1, 4, 4, 2, 2}, {71, 6, 0, 5, 5, 2, 2}, {72, 0, 0, 48, 50, 23, 29}, {72, 48, 6, 46, 44, 23, 23}, {72, 94, 6, 44, 44, 23, 23}, {72, 139, 2, 49, 48, 27, 26}, {72, 189, 6, 48, 44, 23, 23}, {81, 0, 0, 11, 32, 1, 32}, {81, 11, 0, 11, 32, 1, 32}, {81, 22, 0, 11, 32, 1, 32}, {81, 33, 0, 11, 32, 1, 32}, {82, 0, 0, 22, 64, 2, 64}, {82, 22, 0, 22, 64, 2, 64}, {82, 44, 0, 22, 64, 2, 64}, {82, 66, 0, 22, 64, 2, 64}, {84, 0, 0, 40, 35, 5, 0}, {84, 40, 0, 34, 35, 0, 1}, {84, 75, 0, 40, 35, 3, 0}, {84, 115, 0, 34, 35, 0, 0}, {48, 0, 0, 17, 17, 0, 0}, {48, 17, 0, 17, 17, 0, 0}, {48, 34, 0, 17, 17, 0, 0}, {48, 51, 0, 16, 17, 0, 0}, {48, 68, 0, 17, 17, 0, 0}, null, null, null, null, null, null, {86, 0, 0, 32, 16, 16, 16}, {87, 0, 0, 64, 32, 32, 32}, {88, 0, 1, 16, 13, 8, 13}, {88, 16, 0, 16, 14, 8, 14}, {88, 32, 3, 17, 11, 8, 11}, {88, 49, 2, 17, 12, 8, 12}, {89, 0, 2, 28, 22, 14, 22}, {89, 28, 0, 27, 24, 14, 24}, {89, 55, 5, 30, 19, 15, 19}, {89, 85, 4, 29, 20, 15, 20}, {90, 0, 0, 24, 12, 12, 12}, {90, 0, 12, 23, 12, 12, 12}, {90, 0, 24, 22, 14, 11, 12}, {90, 23, 0, 23, 15, 12, 12}, {90, 23, 15, 24, 13, 12, 12}, {90, 23, 28, 23, 14, 11, 12}, {91, 0, 0, 42, 22, 19, 22}, {91, 0, 22, 42, 21, 19, 21}, {91, 0, 43, 42, 24, 19, 24}, {91, 42, 0, 40, 25, 18, 25}, {91, 42, 25, 40, 23, 18, 23}, {91, 42, 48, 40, 24, 18, 24}, {92, 0, 0, 21, 12, 10, 12}, {92, 0, 12, 21, 14, 10, 14}, {92, 0, 26, 21, 14, 11, 14}, {92, 23, 0, 21, 12, 10, 12}, {92, 23, 12, 21, 14, 10, 14}, {92, 22, 26, 22, 14, 11, 14}, {93, 0, 0, 43, 24, 21, 24}, {93, 0, 24, 43, 28, 21, 28}, {93, 0, 52, 42, 28, 24, 28}, {93, 43, 0, 44, 24, 22, 24}, {93, 42, 24, 45, 28, 22, 28}, {93, 42, 52, 45, 28, 22, 28}, {94, 0, 0, 30, 15, 15, 16}, {94, 0, 16, 30, 16, 15, 16}, {94, 30, 0, 29, 32, 15, 32}, {94, 59, 0, 31, 18, 16, 18}, {94, 59, 18, 36, 17, 18, 17}, {95, 0, 0, 64, 32, 28, 32}, {95, 0, 32, 64, 32, 28, 32}, {95, 64, 0, 64, 65, 28, 65}, {95, 127, 16, 64, 48, 28, 48}, {95, 191, 31, 65, 34, 28, 34}, null, null, null, null, null, null};
        CLOUDS_BG = new int[]{42, 43};
        BOTTON_MENU = new int[]{44, 45, 46, 47};
        BOTTON_ELEMENT = new int[]{47, 48, 49, 50};
        COW_PIG = new int[]{50, 51, 52, 53};
        STARS = new int[]{54, 55, 56};
        FLAG_FN = new int[]{62, 66};
        POWER_UP = new int[]{70, 71, 72, 73};
        MOBILEOBJ_SPRID = new int[][][]{(int[][])null, new int[][]{{85}, {86}}, new int[][]{{87, 88, 89, 90, 91}, {91, 92, 93, 94, 95}}, new int[][]{{95, 96, 97, 98, 99, 100}, {101, 102, 103, 104, 105, 106}}, new int[][]{{107, 108, 109, 110, 111, 112}, {113, 114, 115, 116, 117, 118}}};
        STATICOBJ_SPRID = new int[][][]{(int[][])null, new int[][]{{119, 120, 122, 121, 123, 121, 123, 122, 120}, {124, 125, 127, 126, 128, 126, 128, 127, 125}}, (int[][])null, (int[][])null, (int[][])null};
        PAD = new int[][]{{129, 130}, {131, 132, 133, 134}};
        ms_iChunkSearchBuffer = new byte[6];
        THUNDER_COLOR = new int[]{0xFFFFFF, 43775};
        SUN_RADIUS = Math.max(176, 206);
    }
}

