/*
 * Decompiled with CFR 0.152.
 */
public class FloatInt {
    public int m_Val;
    public int m_E;
    public static final FloatInt ZERO = new FloatInt(0, 0);
    public static final FloatInt ONE = new FloatInt(1, 0);
    public static final FloatInt ONE_AND_HALF = new FloatInt(15, -1);
    public static final FloatInt TWO = new FloatInt(2, 0);
    public static final FloatInt STEP_ENTRY = new FloatInt(10, -1);
    public static final FloatInt STEPDIV2_ENTRY = new FloatInt(5, -1);
    public static final FloatInt GRAVITY = new FloatInt(105, -4);
    int distx1;
    int disty1;
    int distx2;
    int disty2;
    int p1;
    int p2;
    int p3;
    int p4;
    int p5;
    int p6;

    public FloatInt() {
        this.m_Val = 0;
        this.m_E = 0;
    }

    public FloatInt(int val) {
        this.m_Val = val;
        this.m_E = 0;
    }

    public FloatInt(int val, int exp) {
        this.m_Val = val;
        this.m_E = exp;
    }

    public FloatInt(String val) {
        this.m_Val = Integer.parseInt(val.substring(0, val.indexOf(".")) + val.substring(val.indexOf(".") + 1, val.length()));
        this.m_E = -(val.length() - (val.indexOf(".") + 1));
    }

    public FloatInt(FloatInt float1) {
        this.m_Val = float1.m_Val;
        this.m_E = float1.m_E;
    }

    public void set(FloatInt float1) {
        this.m_Val = float1.m_Val;
        this.m_E = float1.m_E;
    }

    public void set(int value) {
        this.m_Val = value;
        this.m_E = 0;
    }

    public int toInteger() {
        int tmpE = this.m_E;
        int tmpVal = this.m_Val;
        while (tmpE != 0) {
            if (tmpE < 0) {
                tmpVal /= 10;
                ++tmpE;
                continue;
            }
            tmpVal *= 10;
            --tmpE;
        }
        return tmpVal;
    }

    public void Add(FloatInt value) {
        if (value.m_Val == 0) {
            return;
        }
        int e1 = this.m_E;
        int e2 = value.m_E;
        int v1 = this.m_Val;
        int v2 = value.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 21474836) {
                    v1 *= 10;
                    --e1;
                    continue;
                }
                v2 /= 10;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 21474836) {
                v2 *= 10;
                --e2;
                continue;
            }
            v1 /= 10;
            ++e1;
        }
        if (v1 > 0 && v2 > Integer.MAX_VALUE - v1 || v1 < 0 && v2 < Integer.MIN_VALUE - v1) {
            v1 /= 10;
            ++e1;
            v2 /= 10;
            ++e2;
        }
        if (v1 > 0 && v2 > Integer.MAX_VALUE - v1) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        if (v1 < 0 && v2 < Integer.MIN_VALUE - v1) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        this.m_Val = v1 + v2;
        this.m_E = e1;
    }

    public void Sub(FloatInt value) {
        if (value.m_Val == 0) {
            return;
        }
        this.Add(new FloatInt(-value.m_Val, value.m_E));
    }

    public void Mul(FloatInt value) {
        int v;
        if (value.m_Val == 1 && value.m_E == 0) {
            return;
        }
        if (value.m_Val == 0 || this.m_Val == 0) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        while (true) {
            if (Math.abs(value.m_Val) > Math.abs(this.m_Val)) {
                if (Integer.MAX_VALUE / Math.abs(this.m_Val) >= Math.abs(value.m_Val)) break;
                value.m_Val /= 10;
                ++value.m_E;
                continue;
            }
            if (Integer.MAX_VALUE / Math.abs(value.m_Val) >= Math.abs(this.m_Val)) break;
            this.m_Val /= 10;
            ++this.m_E;
        }
        int e = this.m_E + value.m_E;
        this.m_Val = v = this.m_Val * value.m_Val;
        this.m_E = e;
    }

    public void Div(FloatInt value) {
        if (value.m_Val == 1 && value.m_E == 0) {
            return;
        }
        int e1 = this.m_E;
        int e2 = value.m_E;
        int v1 = this.m_Val;
        if (v1 == 0) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        int v2 = value.m_Val;
        if (v2 == 0) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        int val = 0;
        while ((v1 %= v2) != 0 && Math.abs(val += v1 / v2) <= 0xCCCCCCC) {
            if (Math.abs(v1) > 0xCCCCCCC) {
                v2 /= 10;
                ++e2;
            } else {
                v1 *= 10;
                --e1;
            }
            val *= 10;
        }
        FloatInt f = new FloatInt(val, e1 - e2);
        f.RemoveZero();
        this.m_Val = f.m_Val;
        this.m_E = f.m_E;
    }

    public void RemoveZero() {
        if (this.m_Val == 0) {
            return;
        }
        while (this.m_Val % 10 == 0) {
            this.m_Val /= 10;
            ++this.m_E;
        }
    }

    public boolean Great(FloatInt x) {
        int e1 = this.m_E;
        int e2 = x.m_E;
        int v1 = this.m_Val;
        int v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 21474836) {
                    v1 *= 10;
                    --e1;
                    continue;
                }
                v2 /= 10;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 21474836) {
                v2 *= 10;
                --e2;
                continue;
            }
            v1 /= 10;
            ++e1;
        }
        return v1 > v2;
    }

    public boolean Less(FloatInt x) {
        int e1 = this.m_E;
        int e2 = x.m_E;
        int v1 = this.m_Val;
        int v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < 21474836) {
                    v1 *= 10;
                    --e1;
                    continue;
                }
                v2 /= 10;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < 21474836) {
                v2 *= 10;
                --e2;
                continue;
            }
            v1 /= 10;
            ++e1;
        }
        return v1 < v2;
    }

    public void sqrt(FloatInt x) {
        int sp = 0;
        boolean inv = false;
        if (x.m_Val == 0 || this.m_Val == 0) {
            this.m_Val = 0;
            this.m_E = 0;
            return;
        }
        if (x.m_Val == 1 || this.m_Val == 0) {
            this.m_Val = 1;
            this.m_E = 0;
            return;
        }
        if (x.Less(new FloatInt(0))) {
            FloatInt tmp = new FloatInt(1);
            tmp.Div(x);
            x.set(tmp);
            inv = true;
        }
        while (x.Great(new FloatInt(16))) {
            ++sp;
            x.Div(new FloatInt(16, 0));
        }
        FloatInt a = new FloatInt(2);
        for (int i = 3; i > 0; --i) {
            FloatInt b = new FloatInt(x);
            b.Div(a);
            a.Add(b);
            a.Mul(new FloatInt(5, -1));
        }
        while (sp > 0) {
            --sp;
            a.Mul(new FloatInt(4));
        }
        if (inv) {
            FloatInt tmp2 = new FloatInt(1);
            tmp2.Div(a);
            a.set(tmp2);
        }
        this.m_Val = a.m_Val;
        this.m_E = a.m_E;
    }

    public static final int sqrt2(int value) {
        int sqrt = 0;
        for (int k = 0x100000; k != 0; k >>= 2) {
            int tmp = sqrt + k;
            sqrt >>= 1;
            if (tmp > value) continue;
            value -= tmp;
            sqrt += k;
        }
        return sqrt;
    }

    int distance(FloatInt x1, FloatInt y1, FloatInt x2, FloatInt y2) {
        this.distx1 = x1.toInteger();
        this.disty1 = y1.toInteger();
        this.distx2 = x2.toInteger();
        this.disty2 = y2.toInteger();
        x1.Sub(x2);
        this.p1 = x1.toInteger();
        x1.Mul(x1);
        this.p2 = x1.toInteger();
        y1.Sub(y2);
        this.p3 = y1.toInteger();
        y1.Mul(y1);
        this.p4 = y1.toInteger();
        x1.Add(y1);
        this.p5 = x1.toInteger();
        x1.sqrt(x1);
        this.p6 = x1.toInteger();
        return x1.toInteger();
    }
}

