/*
 * Decompiled with CFR 0.152.
 */
class Point2D {
    public int x;
    public int y;
    static final byte NONE = -1;
    static final byte DOWN = 0;
    static final byte DOWN_RIGHT = 1;
    static final byte RIGHT = 2;
    static final byte UP_RIGHT = 3;
    static final byte UP = 4;
    static final byte UP_LEFT = 5;
    static final byte LEFT = 6;
    static final byte DOWN_LEFT = 7;

    Point2D() {
        this.x = -1;
        this.y = -1;
    }

    Point2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    Point2D(Point2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    int distance(int PX, int PY) {
        return Math.abs(this.x - PX) + Math.abs(this.y - PY);
    }

    boolean equals(Point2D obj) {
        return this.x == obj.x && this.y == obj.y;
    }

    void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    void setLocation(Point2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    static int getDirection(Point2D a, Point2D b) {
        if (b.equals(a)) {
            return -1;
        }
        if (b.x == a.x && b.y < a.y) {
            return 0;
        }
        if (b.x == a.x && b.y > a.y) {
            return 4;
        }
        if (b.x > a.x && b.y == a.y) {
            return 2;
        }
        if (b.x < a.x && b.y == a.y) {
            return 6;
        }
        return -1;
    }

    void moveDirection(int direction, int factor) {
        switch (direction) {
            case 4: {
                this.y += factor;
                break;
            }
            case 6: {
                this.x -= factor;
                break;
            }
            case 0: {
                this.y -= factor;
                break;
            }
            case 2: {
                this.x += factor;
            }
        }
    }

    static int distanceAbsolute(Point2D a, Point2D b) {
        return Math.abs(a.x - b.x) + Math.abs(a.y - b.y);
    }

    static byte getDirectionFrom(Point2D pos_end, Point2D pos_ini) {
        if (pos_ini.equals(pos_end)) {
            return -1;
        }
        if (pos_ini.x < pos_end.x && pos_ini.y < pos_end.y) {
            return 5;
        }
        if (pos_ini.x > pos_end.x && pos_ini.y < pos_end.y) {
            return 3;
        }
        if (pos_ini.x < pos_end.x && pos_ini.y > pos_end.y) {
            return 7;
        }
        if (pos_ini.x > pos_end.x && pos_ini.y > pos_end.y) {
            return 1;
        }
        if (pos_ini.x == pos_end.x && pos_ini.y < pos_end.y) {
            return 4;
        }
        if (pos_ini.x == pos_end.x && pos_ini.y > pos_end.y) {
            return 0;
        }
        if (pos_ini.x > pos_end.x && pos_ini.y == pos_end.y) {
            return 2;
        }
        if (pos_ini.x < pos_end.x && pos_ini.y == pos_end.y) {
            return 6;
        }
        return -1;
    }

    static byte getDirectionFrom(int pos_end_x, int pos_end_y, int pos_ini_x, int pos_ini_y) {
        if (pos_end_x == pos_ini_x && pos_end_y == pos_ini_y) {
            return -1;
        }
        if (pos_ini_x < pos_end_x && pos_ini_y < pos_end_y) {
            return 5;
        }
        if (pos_ini_x > pos_end_x && pos_ini_y < pos_end_y) {
            return 3;
        }
        if (pos_ini_x < pos_end_x && pos_ini_y > pos_end_y) {
            return 7;
        }
        if (pos_ini_x > pos_end_x && pos_ini_y > pos_end_y) {
            return 1;
        }
        if (pos_ini_x == pos_end_x && pos_ini_y < pos_end_y) {
            return 4;
        }
        if (pos_ini_x == pos_end_x && pos_ini_y > pos_end_y) {
            return 0;
        }
        if (pos_ini_x > pos_end_x && pos_ini_y == pos_end_y) {
            return 2;
        }
        if (pos_ini_x < pos_end_x && pos_ini_y == pos_end_y) {
            return 6;
        }
        return -1;
    }
}

