/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ShellyTextField
implements Constants,
langdefs {
    private final int KEY_DELAY_TIME_FOR_NEXT_INPUT;
    private FrontEnd shelly = null;
    private final int key;
    private final String label;
    private final StringBuffer strBuffer = new StringBuffer(0);
    private final String[] textIn;
    private long keyPressStartTime;
    private int keyInputNow;
    private int keyInputCnt;
    private int keyInputCursor;
    private boolean strCase = true;
    private boolean bDefaultNotReturned;
    private String defString = null;
    private final int maxLength;
    private final boolean bWrapMode;
    private int fontHandle = -1;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private boolean selected = false;
    private int plinkCnt = 0;
    private int cursorColor = 0;
    private int xpos = -9999;
    private int ypos = -9999;
    private boolean textWasCapped = false;
    private int cursorX = 0;
    private int cursorY = 0;
    private boolean centerText = false;
    protected static final String[] textInNum = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "", ""};
    protected static final String[] textInChar = new String[]{"*", "*", "abc", "def", "ghi", "jkl", "mno", "pqrs", "tuv", "wxyz", "c", "*"};

    public ShellyTextField(int n, boolean bl, int n2, String string, String string2, boolean bl2, boolean bl3) {
        this.KEY_DELAY_TIME_FOR_NEXT_INPUT = 1000;
        this.key = n;
        this.maxLength = n2;
        this.label = string;
        this.textIn = bl ? textInNum : textInChar;
        this.bDefaultNotReturned = bl2;
        this.defString = string2;
        if (!this.bDefaultNotReturned && string2 != null) {
            this.strBuffer.append(string2);
        }
        this.bWrapMode = bl3;
    }

    public boolean isSingleLine() {
        return !this.bWrapMode;
    }

    public int getKey() {
        return this.key;
    }

    public int length() {
        return this.strBuffer.length();
    }

    public void clearText() {
        this.strBuffer.delete(0, this.strBuffer.length());
        this.keyInputCursor = 0;
        this.keyInputCnt = 0;
        this.keyInputNow = 0;
        if (!this.bDefaultNotReturned && this.defString != null) {
            this.strBuffer.append(this.defString);
        }
    }

    public boolean isCusorPosLast() {
        if (this.keyInputCursor == this.strBuffer.length()) {
            return true;
        }
        return this.textWasCapped;
    }

    public void setText(String string) {
        this.clearText();
        this.strBuffer.append(string);
        this.keyInputCursor = this.strBuffer.length();
    }

    public void setDefaultAndText(String string) {
        this.defString = string;
        this.clearText();
    }

    public void setTextCentered(boolean bl) {
        this.centerText = bl;
    }

    public void keyInput() {
        if (!this.selected) {
            return;
        }
        int n = -1;
        long l = System.currentTimeMillis();
        if (FrontEnd.keyDownDB(262144)) {
            if (this.strBuffer.length() == 1) {
                this.strBuffer.setLength(0);
            } else if (this.strBuffer.length() > 0) {
                this.strBuffer.setLength(this.strBuffer.length() - 1);
            }
        }
        n = -1;
        n = FrontEnd.keyDownDB(1024) ? 10 : (FrontEnd.keyDownDB(2048) ? 11 : FrontEnd.keyGetNumericDB());
        if (!FrontEnd.numericKeyOnly && n != 10 && n != 11) {
            return;
        }
        if (n != -1) {
            int n2 = 0;
            if (this.textIn[n].compareTo("*") == 0) {
                return;
            }
            String string = this.strCase ? this.textIn[n].toUpperCase() : this.textIn[n];
            if (n == this.keyInputNow && l - this.keyPressStartTime < 1000L && this.textIn != textInNum) {
                n2 = this.keyInputCnt + 1;
                if (n2 >= string.length()) {
                    n2 = 0;
                }
                this.strBuffer.setLength(this.strBuffer.length() - 1);
                this.strBuffer.append(string.charAt(n2));
            } else if (this.strBuffer.length() < this.maxLength) {
                this.strBuffer.append(string.charAt(n2));
            }
            this.keyInputCnt = n2;
            this.keyInputNow = n;
            this.keyPressStartTime = l;
        }
    }

    public void capTextOnce() {
        this.strBuffer.setLength(this.strBuffer.length() - 1);
        this.textWasCapped = true;
    }

    public String getText() {
        if (this.isDefault()) {
            return this.defString;
        }
        return this.strBuffer.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isDefault() {
        return this.strBuffer.length() == 0 && this.defString != null;
    }

    public void setDisplay(int n, int n2, int n3, int n4, boolean bl) {
        if (!bl) {
            n2 = FrontEnd.font[n3].getHeight() * 2;
        }
        this.maxWidth = n;
        this.maxHeight = n2;
        this.fontHandle = n3;
        this.cursorColor = n4;
    }

    public void setDisplayPos(int n, int n2) {
        this.xpos = n;
        this.ypos = n2;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public int draw(Graphics graphics) {
        return this.draw(graphics, this.xpos, this.ypos);
    }

    public int draw(Graphics graphics, int n, int n2) {
        int n3 = 20;
        int n4 = n2;
        if (this.centerText) {
            n = HOALApplication.renderableWidth >> 1;
            n3 = 17;
        }
        this.textWasCapped = false;
        int n5 = FrontEnd.font[this.fontHandle].getHeight() + 1;
        String string = this.getLabel();
        if (string != null) {
            FrontEnd.textDraw(graphics, this.fontHandle, string, n, n2, n3);
            n2 += n5;
        }
        String string2 = this.getText();
        boolean bl = false;
        this.cursorX = n;
        this.cursorY = n2;
        boolean bl2 = false;
        int n6 = FrontEnd.font[this.fontHandle].stringWidth(string2);
        int n7 = 0;
        if (n6 > this.maxWidth - 4) {
            n7 = n6 - (this.maxWidth - 4);
            this.cursorX = n + this.maxWidth - 4;
            FrontEnd.storeClip(graphics);
            graphics.clipRect(n, n2, this.maxWidth, n5);
        } else {
            this.cursorX += n6;
        }
        FrontEnd.textDraw(graphics, this.fontHandle, string2, n - n7, n2, n3);
        if (n7 != 0) {
            FrontEnd.restoreClip(graphics);
        }
        ++this.plinkCnt;
        if (this.selected && this.plinkCnt % 5 <= 2) {
            if (this.centerText) {
                this.cursorX = (HOALApplication.renderableWidth >> 1) + (FrontEnd.font[this.fontHandle].stringWidth(string2) >> 1);
            } else if (this.cursorX > n + this.maxWidth - 2) {
                this.cursorX = n;
                this.cursorY += n5;
            }
            if (this.cursorY <= n4 + this.maxHeight) {
                this.drawCursor(graphics, this.cursorX, this.cursorY, 2, n5, this.cursorColor);
            }
        }
        return this.maxHeight;
    }

    public void drawCursor(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getColor();
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(n6);
    }

    public void drawCursor(Graphics graphics, int n, int n2, int n3) {
        this.drawCursor(graphics, this.cursorX, this.cursorX, n, n2, n3);
    }
}

