/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HFont {
    public static final boolean HFONT_DEBUG = false;
    public static final boolean HFONT_DEBUG_FULL = false;
    public static final boolean HFONT_COLORS = false;
    private static final boolean HF_RECTS = false;
    private static final boolean HF_STRIPS = false;
    private static final boolean HF_HOMAGE = false;
    private static final boolean HF_PACKED = true;
    private static final boolean noColourLookup = false;
    private Image glyphs;
    private Image[] glyphStrips;
    private int numStrips;
    private int glyphs_std;
    private int glyphs_extra;
    private int glyphs_all;
    private byte[] gwidth;
    public byte[] cwidth;
    private byte[] heights;
    private byte[] offsets;
    private byte[] xpos;
    private byte[] ypos;
    private byte[] rects;
    private byte[][] rectdata;
    private char[] extend_map = null;
    private int line_spacing;
    private int char_spacing;
    private int chars_extend;
    private int extra_horiz;
    private int extra_vert;
    private int color = 0xFFFFFF;
    private static DataInputStream stream = null;
    private static int first_res = 0;
    private static final boolean nbspBeforePunctuation = true;
    private static final String nbspPunctuationMarks = "!?;:@/-";
    private static final int BYTEMASK = 255;
    private static final int CHARMASK = 65535;
    private static final int INTERLINESPACE = 0;
    public static final int HFONT_CANSCROLLUP = 0x200000;
    public static final int HFONT_CANSCROLLDOWN = 0x400000;
    public static final int HFONT_HEIGHT = 1023;
    private static final int META = 4;
    private static final int META_WIDE_HI = 0;
    private static final int META_WIDE_LO = 1;
    private static final int META_LINES = 2;
    static final int PNG_foNt = 1718570612;
    static final int PNG_PLTE = 1347179589;
    static final int PNG_tRNS = 1951551059;
    static final int PNG_IEND = 1229278788;
    protected long png_crc;
    protected static final long png_crc_reset = 0xFFFFFFFFL;
    private static long[] png_laCRC = new long[256];
    private int numShades = 0;
    private int curShade = 0;
    private Image[] fntImage = null;
    private int[][] colourSet;
    private Random random = new Random();
    int rectColour = 0xFFFFFF;
    static final int DEFAULT_HOMAGE_BUFFERSIZE = 32;
    static final int FLAG_HOMAGE_NO_RT_DEPACK = -1;
    static final int COLOUR_NO_CHANGE = -1;
    static final int SHADING_INVERT_FLAG = 0x1000000;
    int typeOfFont = -1;
    static final int TYPE_OF_FONT_HOMAGE = 1;
    static final int TYPE_OF_FONT_PACKED = 2;
    static final int TYPE_OF_FONT_STRIPPED = 3;
    static final int TYPE_OF_FONT_RECTS = 4;
    private static final byte bLF = 10;
    private static final byte bCR = 13;
    private static final byte bSPACE = 32;
    private static final byte bXTEND = -128;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int clipR;
    private int clipB;

    public void setCurrentColor(int n) {
        if (this.fntImage == null) {
            if (n == 0) {
                this.applyColour(0xFFFFFF, 0);
            } else {
                this.applyColour(this.colourSet[n - 1][1] & 0xFFFFFF, this.colourSet[n - 1][0] & 0xFFFFFF);
            }
        } else {
            if (n < 0 || n >= this.fntImage.length) {
                n = 0;
            }
            this.curShade = n;
            this.glyphs = this.fntImage[this.curShade];
        }
    }

    private void generateColors(InputStream inputStream, int[][] nArray) throws Exception {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        for (n2 = 0; n2 < 8; ++n2) {
            dataOutputStream.writeByte(dataInputStream.readByte());
        }
        n2 = 0;
        while (n2 == 0) {
            n = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            boolean bl = true;
            switch (n5) {
                case 1229278788: {
                    n2 = 1;
                    break;
                }
                case 1718570612: {
                    break;
                }
                case 1347179589: {
                    n3 = byteArrayOutputStream.size();
                    n4 = n;
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeInt(n5);
                    byArray = new byte[n];
                    dataInputStream.read(byArray, 0, n);
                    dataOutputStream.write(byArray, 0, n);
                    dataOutputStream.writeInt(dataInputStream.readInt());
                    bl = false;
                }
            }
            if (!bl) continue;
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n5);
            byte[] byArray3 = new byte[n];
            dataInputStream.read(byArray3, 0, n);
            dataOutputStream.write(byArray3, 0, n);
            dataOutputStream.writeInt(dataInputStream.readInt());
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        inputStream = null;
        dataInputStream = null;
        dataOutputStream = null;
        byteArrayOutputStream = null;
        this.numShades = nArray.length + 1;
        this.fntImage = new Image[this.numShades];
        this.fntImage[0] = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        for (n = 0; n < this.numShades - 1; ++n) {
            this.recolourPalette(byArray2, byArray, n3, n4, nArray[n][0], nArray[n][1]);
            this.fntImage[n + 1] = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        this.setCurrentColor(0);
    }

    private void recolourPalette(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n3 >> 16 & 0xFF;
        nArray[1] = n3 >> 8 & 0xFF;
        nArray[2] = n3 & 0xFF;
        nArray2[0] = (n4 >> 16 & 0xFF) - nArray[0];
        nArray2[1] = (n4 >> 8 & 0xFF) - nArray[1];
        nArray2[2] = (n4 & 0xFF) - nArray[2];
        for (n6 = 1; n6 < n2 / 3; ++n6) {
            n5 = byArray2[n6 * 3];
            if (n5 < 0) {
                n5 += 256;
            }
            int n7 = n + 8 + n6 * 3;
            for (int i = 0; i < 3; ++i) {
                int n8 = nArray[i] + (n5 * nArray2[i] >> 8);
                byArray[n7 + i] = (byte)n8;
            }
        }
        this.png_crc = 0xFFFFFFFFL;
        for (n6 = n + 4; n6 < n + 8 + n2; ++n6) {
            n5 = byArray[n6];
            this.png_crc = png_laCRC[(int)(this.png_crc ^ (long)n5) & 0xFF] ^ this.png_crc >> 8;
        }
        this.png_crc ^= 0xFFFFFFFFL;
        byArray[n + 8 + n2] = (byte)(this.png_crc >> 24);
        byArray[n + 9 + n2] = (byte)(this.png_crc >> 16);
        byArray[n + 10 + n2] = (byte)(this.png_crc >> 8);
        byArray[n + 11 + n2] = (byte)this.png_crc;
    }

    public HFont(InputStream inputStream) {
        this(inputStream, (int[][])null);
    }

    public HFont(InputStream inputStream, int[][] nArray) {
        try {
            this.readBin(inputStream);
            if (nArray == null) {
                this.glyphs = Image.createImage((InputStream)inputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HFont(String string) {
        this.readBin(string);
        if (this.typeOfFont == 2) {
            try {
                this.glyphs = Image.createImage((String)(string + ".png"));
            }
            catch (Exception exception) {
                HFont.debugout("createImage " + string + " Exception " + exception);
            }
            HFont.debugout("Loading Font: " + string);
        }
    }

    public HFont(String string, int[][] nArray) {
        this.readBin(string);
        if (this.typeOfFont == 2) {
            try {
                InputStream inputStream = "".getClass().getResourceAsStream(string + ".png");
                if (nArray == null) {
                    this.glyphs = Image.createImage((InputStream)inputStream);
                }
            }
            catch (Exception exception) {
                HFont.debugout("createImage " + string + " Exception " + exception);
            }
            HFont.debugout("Loading Font: " + string);
        }
    }

    void applyColour(int n) {
        this.applyColour(n, n, 255, false);
    }

    void applyColour(int n, int n2) {
        this.applyColour(n, n2, 255, false);
    }

    int decodeColour(int n) {
        if (n >= 0) {
            return n;
        }
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        boolean bl = false;
        int n5 = n4;
        n5 += n3 << 8;
        n5 += n2 << 16;
        if (bl) {
            n5 += 0x1000000;
        }
        return n5;
    }

    void applyColour(int n, int n2, int n3, boolean bl) {
        int n4 = this.decodeColour(n);
        int n5 = this.decodeColour(n2);
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        boolean bl2 = (n4 & 0x1000000) > 0;
        int n9 = n5 >> 16 & 0xFF;
        int n10 = n5 >> 8 & 0xFF;
        int n11 = n5 & 0xFF;
        if (this.typeOfFont != 1) {
            if (bl2) {
                n6 = 255 - n6;
                n7 = 255 - n7;
                n8 = 255 - n8;
            }
            this.rectColour = (n3 << 24) + (n6 << 16) + (n7 << 8) + n8;
        }
    }

    public HFont(String string, int n) {
        this.setupHFont(string, n, -1, 32, null);
    }

    public HFont(String string, int n, int n2) {
        this.setupHFont(string, n, n2, 32, null);
    }

    public HFont(String string, int n, int n2, boolean bl) {
        if (bl) {
            this.setupHFont(string, n, n2, -1, null);
        } else {
            this.setupHFont(string, n, n2, 32, null);
        }
    }

    public HFont(String string, int n, int n2, HFont hFont) {
        this.setupHFont(string, n, 0, n2, hFont);
    }

    public HFont(String string, int n, int n2, int n3) {
        this.setupHFont(string, n, n2, n3, null);
    }

    public HFont(String string, int n, int n2, int n3, HFont hFont) {
        this.setupHFont(string, n, n2, n3, hFont);
    }

    void setupHFont(String string, int n, int n2, int n3, HFont hFont) {
        this.readBin(string);
        this.setupHFontHomage(n, n2, n3, hFont);
    }

    public HFont(int n, int n2) {
    }

    public HFont(int n, int n2, int n3) {
        this.setupHFont(n, n2, n3, 32, null);
    }

    public HFont(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.setupHFont(n, n2, n3, -1, null);
        } else {
            this.setupHFont(n, n2, n3, 32, null);
        }
    }

    public HFont(int n, int n2, int n3, HFont hFont) {
        this.setupHFont(n, n2, 0, n3, hFont);
    }

    public HFont(int n, int n2, int n3, int n4) {
        this.setupHFont(n, n2, n3, n4, null);
    }

    public HFont(int n, int n2, int n3, int n4, HFont hFont) {
        this.setupHFont(n, n2, n3, n4, hFont);
    }

    void setupHFont(int n, int n2, int n3, int n4, HFont hFont) {
        this.readBin(n);
        this.setupHFontHomage(n2, n3, n4, hFont);
    }

    void setupHFontHomage(int n, int n2, int n3, HFont hFont) {
    }

    private void readBin(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        n = inputStream.read();
        n = inputStream.read() & 0xFF;
        this.typeOfFont = n >> 5;
        this.char_spacing = inputStream.read();
        this.line_spacing = inputStream.read();
        this.glyphs_std = inputStream.read();
        this.glyphs_extra = inputStream.read();
        this.glyphs_all = this.glyphs_std + this.glyphs_extra;
        this.chars_extend = inputStream.read();
        this.extend_map = new char[this.chars_extend << 1];
        byte[] byArray = new byte[this.chars_extend << 2];
        inputStream.read(byArray);
        this.xpos = new byte[this.glyphs_all];
        inputStream.read(this.xpos, 0, this.glyphs_all);
        this.ypos = new byte[this.glyphs_all];
        inputStream.read(this.ypos, 0, this.glyphs_all);
        this.heights = new byte[this.glyphs_all];
        inputStream.read(this.heights, 0, this.glyphs_all);
        this.gwidth = new byte[this.glyphs_all + this.chars_extend];
        inputStream.read(this.gwidth, 0, this.glyphs_all);
        this.offsets = new byte[this.glyphs_all];
        inputStream.read(this.offsets, 0, this.glyphs_all);
        int n2 = 0;
        int n3 = this.glyphs_all;
        int n4 = 0;
        while (n2 < this.chars_extend << 1) {
            char c = (char)(((byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF) & 0xFFFF);
            byte by = byArray[n4++];
            byte by2 = byArray[n4++];
            this.gwidth[n3++] = (byte)(Math.max(this.getWidth(by), this.getWidth(by2)) - this.char_spacing & 0xFF);
            this.extend_map[n2++] = c;
            this.extend_map[n2++] = (char)(((by & 0xFF) << 8 | by2 & 0xFF) & 0xFFFF);
        }
        this.cwidth = new byte[255];
        for (n2 = 32; n2 < 128 + this.glyphs_extra + this.chars_extend; ++n2) {
            this.cwidth[n2] = (byte)(this.getWidth((byte)n2) & 0xFF);
        }
    }

    private static void debugout(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBin(String string) {
        InputStream inputStream = null;
        try {
            inputStream = "".getClass().getResourceAsStream(string + ".hf");
            this.readBin(inputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        inputStream = null;
    }

    private void readBin(int n) {
        try {
            byte[] byArray = HOALApplication.loadAsset(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, HOALApplication.loadAsset_offset, HOALApplication.loadAsset_len);
            this.readBin(byteArrayInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setInputStream(DataInputStream dataInputStream, int n) {
        stream = dataInputStream;
        first_res = n;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public byte[] getFromRes(int n) {
        byte[] byArray = this.getFromRes(new int[]{n}, (byte[][])null);
        return byArray;
    }

    public byte[] getFromRes(int[] nArray, String[] stringArray) {
        byte[][] byArrayArray = new byte[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            byArrayArray[i] = this.getFromString(stringArray[i]);
        }
        return this.getFromRes(nArray, byArrayArray);
    }

    public byte[] getFromRes(int[] nArray, byte[][] byArray) {
        int n;
        if (stream == null) {
            return null;
        }
        int n2 = 4;
        int n3 = 0;
        int n4 = 4;
        byte[] byArray2 = null;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        if (byArray != null && byArray.length > 0) {
            for (n = 0; n < byArray.length && n < nArray.length; ++n) {
                if (byArray[n] == null) continue;
                n2 += byArray[n].length - 4;
            }
        }
        try {
            for (n = 0; n < nArray.length; ++n) {
                int n5 = n;
                nArray[n5] = nArray[n5] - first_res;
                stream.reset();
                stream.skip(nArray[n] << 2);
                nArray3[n] = stream.readInt() + 2;
                stream.skip(nArray3[n]);
                nArray2[n] = stream.readChar();
                int n6 = n;
                nArray3[n6] = nArray3[n6] + ((nArray[n] << 2) + 2 + 4);
                n2 += nArray2[n];
            }
            byArray2 = new byte[n2];
            for (n = 0; n < nArray.length; ++n) {
                stream.reset();
                stream.skip(nArray3[n]);
                for (n3 = 0; n3 < nArray2[n]; n3 += stream.read(byArray2, n3 + n4, nArray2[n] - n3)) {
                }
                n4 += n3;
                if (byArray == null || n >= byArray.length || byArray[n] == null || byArray[n].length <= 0) continue;
                System.arraycopy(byArray[n], 4, byArray2, n4, byArray[n].length - 4);
                n4 += byArray[n].length - 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n4 < n2 || byArray2 == null) {
            return null;
        }
        n3 = 4;
        n4 = 4;
        block6: while (n3 < n2) {
            if ((byArray2[n3] & 0xFFFFFF80) == 0) {
                byArray2[n4++] = byArray2[n3++];
                continue;
            }
            char c = (char)(byArray2[n3++] << 8 & 0xFF00);
            c = (char)(c | byArray2[n3++] & 0xFF);
            boolean bl = true;
            for (int i = 0; i < this.chars_extend << 1; i += 2) {
                if (c != this.extend_map[i]) continue;
                bl = false;
                byArray2[n4++] = (byte)(-128 + (i >> 1) + this.glyphs_extra);
                continue block6;
            }
        }
        if (n4 < n2) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            byArray2 = null;
            return byArray3;
        }
        return byArray2;
    }

    public byte[] getFromString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = new char[n];
        byte[] byArray = new byte[n + 4];
        string.getChars(0, n, cArray, 0);
        block0: for (int i = 0; i < n; ++i) {
            if (cArray[i] < '\u0080') {
                if (cArray[i] >= 32 + this.glyphs_std) continue;
                byArray[i + 4] = (byte)(cArray[i] & 0x7F);
                continue;
            }
            cArray[i] = (char)(0xC080 | cArray[i] << 2 & 0x1F00 | cArray[i] & 0x3F);
            boolean bl = true;
            for (int j = 0; j < this.chars_extend << 1; j += 2) {
                if (cArray[i] != this.extend_map[j]) continue;
                byArray[i + 4] = (byte)(-128 + (j >> 1) + this.glyphs_extra);
                bl = false;
                continue block0;
            }
        }
        return byArray;
    }

    public String toString(byte[] byArray) {
        return this.toString(byArray, 4, byArray.length - 4);
    }

    private String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i] & 0xFF;
            if (n3 < 128) {
                cArray[i] = (char)(byArray[n + i] & 0x7F);
                continue;
            }
            cArray[i] = this.extend_map[(byArray[n + i] ^ 0xFFFFFF80) - this.glyphs_extra << 1];
            cArray[i] = (char)((cArray[i] & 0x1F00) >> 2 | cArray[i] & 0x3F);
        }
        return new String(cArray);
    }

    int getWidth(byte by) {
        if (0 <= by && by < 32) {
            return 0;
        }
        if ((by & 0xFFFFFF80) == 0) {
            if (by - 32 >= this.glyphs_std) {
                return 0;
            }
            return this.gwidth[by - 32] + this.char_spacing;
        }
        return this.gwidth[(by ^ 0xFFFFFF80) + this.glyphs_std] + this.char_spacing;
    }

    public int getWidth(byte[] byArray) {
        int n;
        if (byArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (n >= n3) {
            return 0;
        }
        for (n = 4; n < n3 && byArray[n] != 10 && byArray[n] != 13; ++n) {
            n2 += this.cwidth[byArray[n] & 0xFF] + this.extra_horiz;
        }
        return n2 - (this.char_spacing + this.extra_horiz);
    }

    public int getWidthLastLine(byte[] byArray) {
        int n = 4;
        int n2 = 0;
        int n3 = byArray.length;
        if (n >= n3) {
            return 0;
        }
        for (n = n3 - 1; n >= 4 && byArray[n] != 10 && byArray[n] != 13; --n) {
            n2 += this.cwidth[byArray[n] & 0xFF] + this.extra_horiz;
        }
        return n2 - (this.char_spacing + this.extra_horiz);
    }

    public String getWidthClip(byte[] byArray, int n, String string) {
        int n2;
        if (byArray == null) {
            return null;
        }
        int n3 = 0;
        int n4 = byArray.length;
        if (n2 >= n4) {
            return null;
        }
        for (n2 = 4; n2 < n4; ++n2) {
            if (byArray[n2] == 10 || byArray[n2] == 13) {
                n3 = 0;
                break;
            }
            if (n3 >= n) {
                if (--n2 < 0) {
                    n2 = 0;
                }
                HFont.debugout("getWidthClip is too long: '" + this.toString(byArray, 0, n2) + string + "' from " + this.toString(byArray, 0, n4) + " , w: " + n3 + " , c : " + n);
                return this.toString(byArray, 0, n2) + string;
            }
            n3 += this.cwidth[byArray[n2] & 0xFF] + this.extra_horiz;
        }
        return this.toString(byArray, 0, n4);
    }

    int charWidth(char c) {
        int n = this.cwidth[c & 0xFF] + this.extra_horiz;
        return n;
    }

    public String stringWidthClip(String string, int n, String string2) {
        return this.getWidthClip(this.getFromString(string), n, string2);
    }

    public int stringWidth(String string) {
        return this.getWidth(this.getFromString(string));
    }

    public int getHeight() {
        return this.line_spacing + this.extra_vert;
    }

    int lineHeight() {
        return this.line_spacing + this.extra_vert;
    }

    public int getHeight(byte[] byArray) {
        int n;
        int n2 = this.line_spacing + this.extra_vert;
        int n3 = byArray.length;
        if (n >= n3) {
            return 0;
        }
        for (n = 4; n < n3; ++n) {
            if (byArray[n] != 10 && byArray[n] != 13) continue;
            n2 += this.line_spacing + this.extra_vert;
        }
        return n2 - (0 + this.extra_vert);
    }

    public int getNumLines(byte[] byArray) {
        int n;
        int n2 = 1;
        int n3 = byArray.length;
        if (n >= n3) {
            return 0;
        }
        for (n = 4; n < n3; ++n) {
            if (byArray[n] != 10 && byArray[n] != 13) continue;
            ++n2;
        }
        return n2;
    }

    public int setLineSpacing(int n) {
        this.extra_vert = n;
        return this.line_spacing + n;
    }

    public void setCharSpacing(int n) {
        this.extra_horiz = n;
    }

    public int doLinebreaks(byte[] byArray, int n) {
        if (byArray == null || byArray.length <= 4) {
            return 0;
        }
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length;
        int n8 = ((byArray[0] & 0x7F) << 8) + (byArray[1] & 0xFF);
        if (n8 == n) {
            return byArray[2] & 0xFF;
        }
        if (n8 != 0) {
            do {
                if (byArray[n3] != 13) continue;
                byArray[n3] = 32;
            } while (++n3 < n7);
            n3 = 4;
        }
        while (n3 < n7) {
            n6 = 0;
            while (n6 < n && n3 < n7 && byArray[n3] != 10) {
                n6 += this.cwidth[byArray[n3] & 0xFF] + this.extra_horiz;
                if (byArray[n3] == 32) {
                    if (n6 < n) {
                        if (++n3 < n7) {
                            if (nbspPunctuationMarks.indexOf(byArray[n3]) != -1) continue;
                            n5 = n3 - 1;
                            continue;
                        }
                    } else {
                        if (n3 + 1 < n7 && nbspPunctuationMarks.indexOf(byArray[n3 + 1]) != -1) {
                            ++n3;
                            continue;
                        }
                        n5 = n3;
                        break;
                    }
                }
                ++n3;
            }
            if (n6 >= n && n5 > n4) {
                byArray[n5] = 13;
                n3 = n5;
            }
            n4 = n3++;
            ++n2;
        }
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n2 & 0xFF);
        return n2;
    }

    private int getJitter() {
        int n = this.random.nextInt();
        n = n >= 0 ? n : -n;
        return n % 3 - 1;
    }

    public int drawString(Graphics graphics, String string, int n, int n2, int n3) {
        return this.drawString(graphics, string, n, n2, n3, false);
    }

    public int drawString(Graphics graphics, String string, int n, int n2, int n3, boolean bl) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        byte[] byArray = this.getFromString(string);
        return this.drawText(graphics, byArray, n, n2, -1, -1, 0, n3, bl) >> 10 & 0x3FF;
    }

    public int drawTxtRes(Graphics graphics, int n, int n2, int n3, int n4) {
        return this.drawTxtRes(graphics, n, n2, n3, n4, false);
    }

    public int drawTxtRes(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray = this.getFromRes(n);
        if (byArray == null || byArray.length < 4) {
            return 0;
        }
        return this.drawText(graphics, byArray, n2, n3, -1, -1, 0, n4, bl) >> 10 & 0x3FF;
    }

    public int drawStringWrapped(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        return this.drawStringWrapped(graphics, string, n, n2, n3, n4, false);
    }

    public int drawStringWrapped(Graphics graphics, String string, int n, int n2, int n3, int n4, boolean bl) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        byte[] byArray = this.getFromString(string);
        this.doLinebreaks(byArray, n3);
        return this.drawText(graphics, byArray, n, n2, n3, -1, 0, n4, bl);
    }

    public int drawTxtResWrapped(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        byte[] byArray = this.getFromRes(n);
        if (byArray == null || byArray.length < 4) {
            return 0;
        }
        this.doLinebreaks(byArray, n4);
        return this.drawText(graphics, byArray, n2, n3, n4, -1, 0, n5, bl);
    }

    int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.drawText(graphics, byArray, n, n2, n3, n4, n5, n6, false);
    }

    int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.drawText(graphics, byArray, n2, n3, n4, n5, n6, n7, false);
    }

    int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        return this.drawText(graphics, byArray, n2, n3, n4, n5, n6, n7, bl);
    }

    public int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (byArray == null) {
            return 0;
        }
        return this.drawText(graphics, byArray, n, n2, n3, n4, n5, n6, false, bl);
    }

    private final int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7;
        int n8 = 4;
        int n9 = byArray.length;
        int n10 = n;
        int n11 = n2;
        int n12 = 0;
        int n13 = this.line_spacing + this.extra_vert;
        int n14 = 0;
        if (n8 >= n9) {
            return 0;
        }
        if (n6 == 0) {
            n6 = 20;
        }
        if ((n6 & 0x60) != 0) {
            n11 -= this.getHeight(byArray);
        } else if ((n6 & 2) != 0) {
            n11 -= this.getHeight(byArray) >> 1;
        }
        n2 = n11;
        n11 -= n5;
        this.saveClip(graphics);
        if (n3 > 0) {
            n10 = (n6 & 8) != 0 ? n - n3 : ((n6 & 1) != 0 ? n - (n3 >> 1) : n);
            if (n4 > 0) {
                this.mergeClip(graphics, n10, n2, n3, n4);
            } else {
                this.mergeClip(graphics, n10, n2, n3, this.clipH);
            }
        } else {
            n10 = (n6 & 8) != 0 ? n - this.clipW : ((n6 & 1) != 0 ? n - (this.clipW >> 1) : n);
            if (n4 > 0) {
                this.mergeClip(graphics, n10, n2, this.clipW, n4);
            }
        }
        this.saveClip(graphics);
        if (n4 > 0) {
            if (n11 >= n2 + n4 - (n13 - this.extra_vert)) {
                return 0x200000;
            }
            while (n11 <= n2 - n13) {
                n12 |= 0x200000;
                do {
                    n7 = byArray[n8++] & 0xFF;
                } while (n8 < n9 && n7 != 13 && n7 != 10);
                if (n8 >= n9) {
                    return 0x200000;
                }
                n11 += n13;
            }
            if (n11 < n2) {
                n12 |= 0x200000;
            }
        }
        boolean bl3 = (n6 & 9) != 0;
        int n15 = 0;
        int n16 = 0;
        while (n8 < n9) {
            if (bl2) {
                n16 = this.getJitter();
            }
            n7 = byArray[n8] & 0xFF;
            if (bl3 || n7 < 32) {
                if (bl3 || n7 == 10 || n7 == 13) {
                    if ((n6 & 4) == 0) {
                        int n17 = n8;
                        n10 = n7 < 32 ? 0 : this.cwidth[byArray[n17] & 0xFF] + this.extra_horiz;
                        while (++n17 < n9 && byArray[n17] != 10 && byArray[n17] != 13) {
                            n10 += this.cwidth[byArray[n17] & 0xFF] + this.extra_horiz;
                        }
                        if ((n10 -= this.char_spacing + this.extra_horiz) > n14) {
                            n14 = n10;
                        }
                        n10 = (n6 & 8) != 0 ? n - n10 : ((n6 & 1) != 0 ? n - (n10 >> 1) : n);
                    } else {
                        if ((n10 -= n) > n14) {
                            n14 = n10;
                        }
                        n10 = n;
                    }
                    if (bl3) {
                        bl3 = false;
                        continue;
                    }
                    if (n4 > 0 && (n11 += n13) >= n2 + n4) {
                        return n12 | 0x400000 | n4 | n3 << 10;
                    }
                }
            } else if (n7 == 32) {
                n10 += this.gwidth[0] + (this.char_spacing + this.extra_horiz);
            } else if (n7 < 128) {
                n10 += this.drawGlyph(graphics, n7 - 32, n10 + n15, n11 + n16) + (this.char_spacing + this.extra_horiz);
            } else if ((n7 -= 128) < this.glyphs_extra) {
                n10 += this.drawGlyph(graphics, n7 + this.glyphs_std, n10 + n15, n11 + n16) + (this.char_spacing + this.extra_horiz);
            } else {
                n7 -= this.glyphs_extra;
                for (int i = 8; i >= 0; i -= 8) {
                    int n18 = this.extend_map[(n7 << 1) + 1] >> i & 0xFF;
                    if (n18 < 32) continue;
                    n18 = n18 < 128 ? (n18 -= 32) : (n18 -= 128 - this.glyphs_std);
                    if (n18 >= this.glyphs_all) continue;
                    this.drawGlyph(graphics, n18, n10 + (this.gwidth[this.glyphs_all + n7] - this.gwidth[n18] >> 1), n11);
                }
                n10 += this.gwidth[this.glyphs_all + n7] + (this.char_spacing + this.extra_horiz);
            }
            ++n8;
        }
        if ((n6 & 4) != 0 && (n10 -= n) > n14) {
            n14 = n10;
        }
        if (n4 > 0 && n11 + n13 > n2 + n4) {
            return n12 | 0x400000 | n4 | n14 << 10;
        }
        return n12 | n11 + n13 - n2 | n14 << 10;
    }

    private int drawGlyph(Graphics graphics, int n, int n2, int n3) {
        byte by = this.gwidth[n];
        if (this.typeOfFont == 2) {
            byte by2 = this.heights[n];
            int n4 = n2;
            int n5 = n3 + this.offsets[n];
            int n6 = this.xpos[n] & 0xFF;
            int n7 = this.ypos[n] & 0xFF;
            graphics.drawRegion(this.glyphs, n6, n7, (int)by, (int)by2, 0, n4, n5, 20);
            this.restoreClip(graphics);
        }
        return by;
    }

    private void saveClip(Graphics graphics) {
        this.clipX = graphics.getClipX();
        this.clipY = graphics.getClipY();
        this.clipW = graphics.getClipWidth();
        this.clipH = graphics.getClipHeight();
        this.clipR = this.clipX + this.clipW;
        this.clipB = this.clipY + this.clipH;
    }

    private void restoreClip(Graphics graphics) {
        graphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean mergeClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n + n3;
        if (n5 < this.clipX) {
            n5 = this.clipX;
        }
        if (n6 > this.clipR) {
            n6 = this.clipR;
        }
        if (n6 <= n5) {
            return false;
        }
        int n7 = n2;
        int n8 = n2 + n4;
        if (n7 < this.clipY) {
            n7 = this.clipY;
        }
        if (n8 > this.clipB) {
            n8 = this.clipB;
        }
        if (n8 <= n7) {
            return false;
        }
        graphics.setClip(n5, n7, n6 - n5, n8 - n7);
        return true;
    }

    public int length(byte[] byArray) {
        return byArray.length - 4;
    }

    public byte[] concat(byte[] byArray, byte[] byArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + byArray2.length - 4);
        for (int i = 0; i < 4; ++i) {
            byteArrayOutputStream.write(-1);
        }
        byteArrayOutputStream.write(byArray, 4, byArray.length - 4);
        byteArrayOutputStream.write(byArray2, 4, byArray2.length - 4);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] setCharAt(byte[] byArray, int n, int n2) {
        int n3 = -1;
        if ((n += 4) < byArray.length) {
            if ((n2 & 0xFFFF) < 128) {
                n3 = (byte)(n2 & 0x7F);
            } else {
                char c = (char)(0xC080 | n2 << 2 & 0x1F00 | n2 & 0x3F);
                for (int i = 0; i < this.chars_extend << 1; i += 2) {
                    if (c != this.extend_map[i]) continue;
                    n3 = (byte)(-128 + (i >> 1) + this.glyphs_extra);
                    break;
                }
            }
            if (n3 != -1) {
                byArray[n] = n3;
                for (n = 0; n < 4; ++n) {
                    byArray[n] = -1;
                }
            }
        }
        return byArray;
    }

    public byte[] substring(byte[] byArray, int n) {
        return this.substring(byArray, n, byArray.length - (n + 4));
    }

    public byte[] substring(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        if (n == 0 && n2 == byArray.length - 4) {
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 + 4);
        for (int i = 0; i < 4; ++i) {
            byteArrayOutputStream.write(-1);
        }
        if (n2 > byArray.length - (n + 4)) {
            n2 = byArray.length - (n + 4);
        }
        byteArrayOutputStream.write(byArray, 4 + n, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] replace(byte[] byArray, char c, char c2) {
        int n = 4;
        int n2 = -1;
        if ((c2 & 0xFFFF) < 128) {
            n2 = (byte)(c2 & 0x7F);
        } else {
            char c3 = (char)(0xC080 | c2 << 2 & 0x1F00 | c2 & 0x3F);
            for (int i = 0; i < this.chars_extend << 1; i += 2) {
                if (c3 != this.extend_map[i]) continue;
                n2 = (byte)(-128 + (i >> 1) + this.glyphs_extra);
                break;
            }
        }
        if (n2 == -1) {
            return byArray;
        }
        while ((n = this._indexOf(byArray, c, n, true)) >= 4) {
            byArray[n] = n2;
        }
        for (n = 0; n < 4; ++n) {
            byArray[n] = -1;
        }
        return byArray;
    }

    public byte[] replaceX(byte[] byArray, String string, String string2) {
        return this.replaceX(byArray, this.getFromString(string), this.getFromString(string2));
    }

    public byte[] replaceX(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            return byArray;
        }
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = byArray2.length - 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        boolean bl = false;
        for (n = 0; n < 4; ++n) {
            byteArrayOutputStream.write(-1);
        }
        while (n < n3) {
            while (n + n2 < n3 && byArray[n + n2] == byArray2[4 + n2]) {
                if (++n2 != n4) continue;
                bl = true;
                byteArrayOutputStream.write(byArray3, 4, byArray3.length - 4);
                n += n2;
                n2 = 0;
            }
            byteArrayOutputStream.write(byArray[n++]);
        }
        if (bl) {
            return byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public char charAt(byte[] byArray, int n) {
        if ((n += 4) < byArray.length) {
            char c = (char)(byArray[n] & 0xFFFF);
            if (c < '\u0080') {
                return c;
            }
            char c2 = this.extend_map[(byArray[n] ^ 0xFFFFFF80) - this.glyphs_extra << 1];
            return (char)((c2 & 0x1F00) >> 2 | c2 & 0x3F);
        }
        return '\u0000';
    }

    public int indexOf(byte[] byArray, int n) {
        return this._indexOf(byArray, n, 4, true) - 4;
    }

    public int indexOf(byte[] byArray, int n, int n2) {
        return this._indexOf(byArray, n, n2 + 4, true) - 4;
    }

    public int lastIndexOf(byte[] byArray, int n) {
        return this._indexOf(byArray, n, byArray.length - 1, false) - 4;
    }

    public int lastIndexOf(byte[] byArray, int n, int n2) {
        return this._indexOf(byArray, n, n2 + 4, false) - 4;
    }

    private int _indexOf(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        byte by = 0;
        if ((n & 0xFFFF) < 128) {
            by = (byte)(n & 0x7F);
        } else {
            char c = (char)(0xC080 | n << 2 & 0x1F00 | n & 0x3F);
            for (n3 = 0; n3 < this.chars_extend << 1; n3 += 2) {
                if (c != this.extend_map[n3]) continue;
                by = (byte)(-128 + (n3 >> 1) + this.glyphs_extra);
                break;
            }
        }
        int n4 = bl ? 1 : -1;
        n3 = bl ? byArray.length : 3;
        if (bl && n2 < n3 || !bl && n2 > n3) {
            for (int i = n2; i != n3; i += n4) {
                if (by != byArray[i]) continue;
                return i;
            }
        }
        return 3;
    }

    int getWidestLine(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        for (int i = 4; i < n3; ++i) {
            if (byArray[i] == 10 || byArray[i] == 13) {
                if (n > n2) {
                    n2 = n;
                }
                n = 0;
                continue;
            }
            n += this.cwidth[byArray[i] & 0xFF] + this.extra_horiz;
        }
        if (n > n2) {
            n2 = n;
        }
        return n2 - (this.char_spacing + this.extra_horiz);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                l = (l & 1L) != 0L ? 0xEDB88320L ^ l >> 1 : l >> 1;
            }
            HFont.png_laCRC[i] = l;
        }
    }
}

