/*
 * Decompiled with CFR 0.152.
 */
package com.spl;

import com.spl.BundlerFont;
import com.spl.Constants;
import com.spl.MoreGamesScreen;
import com.spl.Selector;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class SelectorCanvas
extends GameCanvas
implements Constants,
Runnable {
    private int IMAGE_Y_POS;
    private int IMAGE_Y_GAP;
    private int state;
    public static final int STATE_LANGUAGE_SCREEN = 0;
    public static final int STATE_SELECT_SCREEN = 1;
    public static final int STATE_MOREGAMES_SCREEN = 2;
    public static final int STATE_WAITING_SCREEN = 5;
    private final String[] LANGUAGE_MENU = new String[]{"English", "Fran\u00c7ais", "Italiano", "Deutsch", "Espa\u00d1ol"};
    private final String[] LANGUAGE_BINARIES = new String[]{"/en.txt", "/fr.txt", "/it.txt", "/de.txt", "/es.txt"};
    private final String[] MG_PRODUCTS_GAMENAMES = new String[]{"TET", "SM2", "HPP"};
    private final String IMAGE_BIN;
    public int selectedLanguage = 0;
    public String[] localText;
    private static Image[] images;
    private BundlerFont font;
    private boolean isAnimated = false;
    private int animatedTextPosision;
    private boolean animTmp = false;
    private int menuLength;
    private MoreGamesScreen moreGamesScreen;
    public boolean isRunning = false;
    public static int fonHeight;
    public static String strLocale;
    public static int haveMoreGames;
    public String[] idMoreGames;
    public int[] numBuffMG = new int[]{-1, -1, -1};
    public int cntBuffMG = 3;
    private boolean runGamePressed = false;
    int yRamka;
    int hMore;
    int heightRamka;
    private static int[] imageSizeData;
    private static byte[][] imageFlatData;

    protected SelectorCanvas(boolean bl) {
        super(bl);
        this.IMAGE_BIN = "/image.bin";
        this.setFullScreenMode(true);
    }

    public void init() {
        this.moreGames_Products_Definition();
        this.makeNumBuffMG();
        haveMoreGames = this.moreGames_Impl_Definition();
        this.state = 0;
        try {
            this.loadImages();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.loadFont();
        this.menuLength = 2;
        if (haveMoreGames != 0) {
            ++this.menuLength;
        }
        this.moreGamesScreen = new MoreGamesScreen(this, this.font);
        this.initSelectionMenu();
        this.localeDefinition();
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.start();
        fonHeight = SelectorCanvas.getImage(2).getHeight();
    }

    public void setState(int n) {
        this.state = n;
        if (this.state == 2) {
            this.moreGamesScreen.init();
        }
    }

    public void initSelectionMenu() {
        int n = 160 - SelectorCanvas.getImage(2).getHeight();
        for (int i = 0; i < this.menuLength; ++i) {
            if (i == 2) {
                n -= SelectorCanvas.getImage(4 + i + 4).getHeight() + 2 + 2;
                continue;
            }
            n -= SelectorCanvas.getImage(4 + i).getHeight();
        }
        this.IMAGE_Y_POS = this.IMAGE_Y_GAP = n / (this.menuLength + 1);
    }

    private void drawSoftKeyBar(Graphics graphics) {
        graphics.drawImage(SelectorCanvas.getImage(2), 0, 160, 36);
        graphics.drawImage(SelectorCanvas.getImage(0), 0, 160 - fonHeight / 2, 6);
        graphics.drawImage(SelectorCanvas.getImage(1), 128, 160 - fonHeight / 2, 10);
    }

    private void drawLanguageScreen(Graphics graphics) {
        graphics.setClip(0, 0, 128, 160);
        graphics.setColor(19855);
        graphics.fillRect(0, 0, 128, 160);
        graphics.drawImage(SelectorCanvas.getImage(2), 0, 160, 36);
        graphics.drawImage(SelectorCanvas.getImage(0), 0, 160 - fonHeight / 2, 6);
        int n = SelectorCanvas.getImage(23).getHeight();
        int n2 = 160 - SelectorCanvas.getImage(2).getHeight() - n * 5;
        int n3 = n2 / 6;
        if (n3 <= 0) {
            n3 = 1;
        }
        int n4 = n3 + 0;
        for (int i = 0; i < 5; ++i) {
            Image image = SelectorCanvas.getImage(23);
            graphics.drawImage(image, 64, n4, 17);
            if (this.selectedLanguage == i) {
                graphics.drawImage(SelectorCanvas.getImage(24), 64, n4, 17);
            }
            int n5 = 0;
            this.font.drawString(graphics, this.LANGUAGE_MENU[i].toUpperCase(), 64, n4 + (n - this.font.getHeight()) / 2 - n5, 1);
            n4 += n3 + n;
        }
    }

    private void drawSelectionMenu(Graphics graphics) {
        int n;
        int n2;
        graphics.setClip(0, 0, 128, 160);
        graphics.setColor(19855);
        graphics.fillRect(0, 0, 128, 160);
        Image image = SelectorCanvas.getImage(26 + this.selectedLanguage * 3);
        Image image2 = SelectorCanvas.getImage(27 + this.selectedLanguage * 3);
        Image image3 = SelectorCanvas.getImage(28 + this.selectedLanguage * 3);
        int n3 = this.IMAGE_Y_POS + 1;
        for (n2 = 0; n2 < this.menuLength; ++n2) {
            Image image4 = n2 == 2 ? SelectorCanvas.getImage(4 + n2 + this.selectedLanguage) : SelectorCanvas.getImage(4 + n2);
            n = image4.getHeight();
            int n4 = image4.getWidth();
            int n5 = (128 - n4) / 2;
            this.hMore = 0;
            if (n2 == 2) {
                this.hMore = 160 - fonHeight - n3;
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, n3, 128, 160 - n3);
                graphics.drawImage(image4, n5, n3 + (this.hMore >> 1), 6);
            } else {
                graphics.drawImage(image4, n5, n3, 20);
            }
            int n6 = 0;
            int n7 = 0;
            if (n2 == 0) {
                graphics.drawImage(image, n5 + 84, n3 + 15, n7);
                graphics.drawImage(image2, n5 + 0 - n6, n3 + 22, n7);
            }
            if (n2 == 1) {
                graphics.drawImage(image3, n5 + 0 - n6, n3 + 20, n7);
            }
            if (Selector.selectedMIDlet == n2) {
                this.yRamka = n3;
                this.heightRamka = n;
            }
            n3 += n + this.IMAGE_Y_GAP;
        }
        this.drawSoftKeyBar(graphics);
        for (n2 = 0; n2 < this.menuLength; ++n2) {
            if (Selector.selectedMIDlet != n2) continue;
            graphics.setColor(16754725);
            if (n2 == 0) {
                graphics.drawRect(1, this.yRamka - 2, 125, this.heightRamka + 3);
                graphics.drawRect(2, this.yRamka - 1, 123, this.heightRamka + 1);
                continue;
            }
            if (n2 == 1) {
                graphics.drawRect(1, this.yRamka - 2, 125, this.heightRamka + 3);
                graphics.drawRect(2, this.yRamka - 1, 123, this.heightRamka + 1);
                continue;
            }
            n = 1;
            graphics.drawRect(0, this.yRamka, 127, this.hMore + n - 1);
            graphics.drawRect(1, this.yRamka + 1, 125, this.hMore + n - 3);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, 128, 160);
        switch (this.state) {
            case 0: {
                this.drawLanguageScreen(graphics);
                break;
            }
            case 1: {
                this.drawSelectionMenu(graphics);
                break;
            }
            case 2: {
                this.moreGamesScreen.paint(graphics);
                break;
            }
            case 5: {
                graphics.setColor(16, 16, 16);
                graphics.fillRect(0, 0, 128, 160);
                String string = "Please wait";
                switch (this.selectedLanguage) {
                    case 0: {
                        string = "Please wait";
                        break;
                    }
                    case 1: {
                        string = "Veuillez patienter";
                        break;
                    }
                    case 2: {
                        string = "Attendi...";
                        break;
                    }
                    case 3: {
                        string = "Bitte warte.";
                        break;
                    }
                    case 4: {
                        string = "Por favor, espera";
                    }
                }
                graphics.setColor(0);
                graphics.drawString(string, 66, 82, 65);
                graphics.setColor(255, 255, 255);
                graphics.drawString(string, 64, 80, 65);
            }
        }
    }

    protected void keyPressed(int n) {
        if (this.runGamePressed) {
            return;
        }
        Selector.startAppThreadReady = false;
        switch (this.state) {
            case 0: {
                switch (n) {
                    case -7: {
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.loadText(this.selectedLanguage);
                        this.setState(1);
                        break;
                    }
                    case -2: 
                    case 56: {
                        if (++this.selectedLanguage <= 4) break;
                        this.selectedLanguage = 0;
                        break;
                    }
                    case -1: 
                    case 50: {
                        if (--this.selectedLanguage >= 0) break;
                        this.selectedLanguage = 4;
                    }
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 1: {
                switch (n) {
                    case -6: 
                    case -5: 
                    case 53: {
                        if (haveMoreGames != 0 && Selector.selectedMIDlet == this.menuLength - 1) {
                            this.setState(2);
                            break;
                        }
                        this.runGamePressed = true;
                        this.runGame();
                        break;
                    }
                    case -7: {
                        Selector.midlet.notifyDestroyed();
                        break;
                    }
                    case -2: 
                    case 56: {
                        if (++Selector.selectedMIDlet <= this.menuLength - 1) break;
                        Selector.selectedMIDlet = 0;
                        break;
                    }
                    case -1: 
                    case 50: {
                        if (--Selector.selectedMIDlet >= 0) break;
                        Selector.selectedMIDlet = this.menuLength - 1;
                    }
                }
                if (this.runGamePressed) break;
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 2: {
                switch (n) {
                    case 53: {
                        n = -5;
                        break;
                    }
                    case 50: {
                        n = -1;
                        break;
                    }
                    case 56: {
                        n = -2;
                        break;
                    }
                    case 52: {
                        n = -3;
                        break;
                    }
                    case 54: {
                        n = -4;
                    }
                }
                if (!this.moreGamesScreen.keyPressed(n)) break;
                this.setState(1);
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 5: {
                return;
            }
        }
        Selector.startAppThreadReady = true;
    }

    private void runGame() {
        this.setState(5);
        this.destroy();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.repaint();
        this.serviceRepaints();
        if (!Selector.gameStarted) {
            new Thread(Selector.midlet).start();
        }
    }

    public void destroy() {
        int n;
        this.isRunning = false;
        this.isAnimated = false;
        if (images != null) {
            for (n = 0; n < images.length; ++n) {
                SelectorCanvas.images[n] = null;
            }
            images = null;
        }
        System.gc();
        imageFlatData = null;
        imageSizeData = null;
        System.gc();
        this.moreGamesScreen.destroy();
        this.moreGamesScreen = null;
        if (this.localText != null) {
            for (n = 0; n < 10; ++n) {
                this.localText[n] = null;
            }
            this.localText = null;
        }
        if (this.font != null) {
            this.font.destroyFont();
            this.font = null;
        }
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadText(int n) {
        this.localText = new String[10];
        String string = this.LANGUAGE_BINARIES[this.selectedLanguage];
        switch (this.selectedLanguage) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = "";
        int n2 = 0;
        try {
            InputStream inputStream = "".getClass().getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readChar();
            while (true) {
                char c;
                if ((c = dataInputStream.readChar()) == '\r') {
                    this.localText[n2] = string2;
                    ++n2;
                    string2 = "";
                    dataInputStream.readChar();
                    continue;
                }
                string2 = string2 + c;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.localText[n2] = string2;
        for (int i = 0; i < this.numBuffMG.length; ++i) {
            if (this.numBuffMG[i] < 0) continue;
            this.localText[6 + i] = Selector.midlet.getJadAttribute("MG_BUYURI_" + this.MG_PRODUCTS_GAMENAMES[this.numBuffMG[i]]);
            if (this.localText[6 + i] == null || !this.localText[6 + i].trim().equals("")) continue;
            this.localText[6 + i] = null;
        }
    }

    private void loadFont() {
        this.font = new BundlerFont();
    }

    public static Image getImage(int n) {
        if (images[n] == null) {
            SelectorCanvas.images[n] = Image.createImage((byte[])imageFlatData[n], (int)0, (int)imageSizeData[n]);
            return images[n];
        }
        return images[n];
    }

    private void loadImages() throws IOException {
        int n;
        InputStream inputStream = "".getClass().getResourceAsStream("/image.bin");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        imageSizeData = new int[n2];
        imageFlatData = new byte[n2][];
        for (n = 0; n < n2; ++n) {
            SelectorCanvas.imageSizeData[n] = dataInputStream.readInt();
        }
        images = new Image[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = imageSizeData[n];
            if (n3 <= 0) continue;
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = dataInputStream.readByte();
            }
            SelectorCanvas.imageFlatData[n] = new byte[n3];
            System.arraycopy(byArray, 0, imageFlatData[n], 0, n3);
        }
    }

    public void run() {
        try {
            while (this.isRunning) {
                if (this.state == 1) {
                    if (this.isAnimated) {
                        if (this.animTmp) {
                            Thread.sleep(1000L);
                            this.animTmp = false;
                        }
                        this.repaint();
                    }
                } else if (this.state == 2) {
                    this.repaint();
                    Thread.sleep(500L);
                }
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    void localeDefinition() {
        strLocale = System.getProperty("microedition.locale");
        if (strLocale == null) {
            this.state = 0;
        } else if (strLocale.startsWith("en")) {
            this.selectedLanguage = 0;
            this.goToSelScrn();
        } else if (strLocale.startsWith("fr")) {
            this.selectedLanguage = 1;
            this.goToSelScrn();
        } else if (strLocale.startsWith("it")) {
            this.selectedLanguage = 2;
            this.goToSelScrn();
        } else if (strLocale.startsWith("de")) {
            this.selectedLanguage = 3;
            this.goToSelScrn();
        } else if (strLocale.startsWith("es")) {
            this.selectedLanguage = 4;
            this.goToSelScrn();
        } else {
            this.state = 0;
        }
    }

    private void goToSelScrn() {
        this.loadText(this.selectedLanguage);
        this.setState(1);
    }

    public int moreGames_Impl_Definition() {
        try {
            if (this.idMoreGames == null) {
                return 0;
            }
            String string = Selector.midlet.getAppProperty("MG_Impl").trim().toLowerCase();
            if (string == null) {
                return 0;
            }
            if (string.equals("off")) {
                return 0;
            }
            if (string.equals("wap")) {
                return 1;
            }
            if (string.equals("static")) {
                return 2;
            }
            if (string.equals("wapstatic")) {
                return 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void moreGames_Products_Definition() {
        int n;
        String string = Selector.midlet.getAppProperty("MG_PRODUCTS");
        if (string == null || string.equals("")) {
            return;
        }
        string = string.trim();
        String[] stringArray = new String[3];
        int n2 = 0;
        while (string != null) {
            String string2;
            if (string.indexOf(44) != -1) {
                string2 = string.substring(0, string.indexOf(44));
                for (n = 0; n < this.MG_PRODUCTS_GAMENAMES.length; ++n) {
                    if (!string2.equals(this.MG_PRODUCTS_GAMENAMES[n])) continue;
                    stringArray[n2] = this.MG_PRODUCTS_GAMENAMES[n];
                    ++n2;
                    break;
                }
                string = string.substring(string.indexOf(44) + 1);
                continue;
            }
            string2 = string;
            for (n = 0; n < this.MG_PRODUCTS_GAMENAMES.length; ++n) {
                if (!string2.equals(this.MG_PRODUCTS_GAMENAMES[n])) continue;
                stringArray[n2] = this.MG_PRODUCTS_GAMENAMES[n];
                ++n2;
            }
            string = null;
        }
        if (n2 != 0) {
            this.idMoreGames = new String[n2];
            for (n = 0; n < n2; ++n) {
                if (stringArray[n] == null) continue;
                this.idMoreGames[n] = stringArray[n];
            }
        } else {
            this.idMoreGames = null;
        }
    }

    public void makeNumBuffMG() {
        this.cntBuffMG = 0;
        if (this.idMoreGames != null) {
            for (int i = 0; i < this.idMoreGames.length; ++i) {
                this.numBuffMG[i] = -1;
                for (int j = 0; j < 3; ++j) {
                    if (!this.idMoreGames[i].equals(this.MG_PRODUCTS_GAMENAMES[j])) continue;
                    this.numBuffMG[i] = j;
                    ++this.cntBuffMG;
                }
            }
        }
    }
}

