/*
 * Decompiled with CFR 0.152.
 */
package com.spl;

import com.spl.SelectorCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BundlerFont {
    private Image fontImage = SelectorCanvas.getImage(3);
    private byte[][] m_bteFrameData;
    private boolean m_bEqualSpacedFrames;
    private int m_iEqFrameWidth;
    private int m_iEqFrameHeight;
    public int m_iFramesWide;
    public int m_iFramesHigh;
    public int charSpacing = 0;
    private int fontHeight = 20;
    private byte[] fontSpacing = new byte[]{7, 3, 6, 12, 9, 12, 11, 4, 6, 6, 8, 9, 4, 6, 3, 6, 9, 9, 9, 8, 10, 9, 9, 8, 9, 9, 3, 3, 8, 8, 8, 8, 0, 11, 9, 9, 9, 8, 8, 9, 9, 7, 9, 9, 8, 11, 9, 9, 9, 10, 9, 9, 9, 9, 9, 12, 10, 9, 8, 6, 6, 6, 8, 9, 4, 8, 8, 8, 8, 8, 7, 8, 8, 5, 7, 8, 5, 11, 8, 8, 8, 8, 8, 7, 7, 8, 9, 13, 9, 8, 7, 6, 3, 6, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 11, 11, 11, 11, 11, 11, 7, 7, 8, 8, 8, 8, 7, 7, 8, 7, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 8, 9, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 6, 5, 5, 6, 8, 8, 8, 8, 8, 8, 8, 9, 8, 8, 8, 8, 8, 8, 7, 8};

    BundlerFont() {
        this.extractFrames(this.fontSpacing, this.fontHeight);
    }

    public void extractFrames(byte[] byArray, int n) {
        this.m_bteFrameData = new byte[byArray.length][3];
        int n2 = 0;
        int n3 = 0;
        this.m_iEqFrameHeight = n;
        for (int i = 0; i < byArray.length; ++i) {
            this.m_bteFrameData[i][0] = (byte)(n2 - 128);
            this.m_bteFrameData[i][1] = (byte)(n3 - 128);
            this.m_bteFrameData[i][2] = (byte)(byArray[i] - 128);
            if ((n2 += byArray[i]) <= this.fontImage.getWidth()) continue;
            n2 = 0;
            this.m_bteFrameData[i][1] = (byte)((n3 += n) - 128);
            this.m_bteFrameData[i][0] = (byte)(n2 - 128);
            n2 += byArray[i];
        }
        this.m_bEqualSpacedFrames = false;
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        switch (n3) {
            case 1: 
            case 17: {
                n -= this.getSringLength(string) / 2;
                break;
            }
            case 8: {
                n += this.getSringLength(string);
                break;
            }
            case 33: {
                n -= this.getSringLength(string) / 2;
                n2 -= this.getHeight();
                break;
            }
            case 36: {
                n2 -= this.getHeight();
            }
        }
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            n5 = string.charAt(i);
            if (n5 == 124) continue;
            n5 -= 32;
            if (n + n6 <= 176 && n + n6 >= -176) {
                this.DrawFrame(graphics, n5, n + n6, n2);
            }
            n6 += this.m_bteFrameData[n5][2] + 128 + this.charSpacing;
        }
    }

    public int getSringLength(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = string.charAt(i);
            if (n2 == 124) continue;
            n3 += this.m_bteFrameData[n2 -= 32][2] + 128 + this.charSpacing;
        }
        return n3;
    }

    public void DrawFrame(Graphics graphics, int n, int n2, int n3) {
        if (this.m_bEqualSpacedFrames) {
            int n4 = n / this.m_iFramesWide;
            int n5 = n - n4 * this.m_iFramesWide;
            graphics.setClip(n2, n3, this.m_iEqFrameWidth, this.m_iEqFrameHeight);
            graphics.drawImage(this.fontImage, n2 - (n5 *= this.m_iEqFrameWidth), n3 - (n4 *= this.m_iEqFrameHeight), 20);
        } else {
            int n6 = this.m_bteFrameData[n][0] + 128;
            int n7 = this.m_bteFrameData[n][1] + 128;
            int n8 = this.m_bteFrameData[n][2] + 128;
            graphics.setClip(n2, n3, n8, this.m_iEqFrameHeight);
            graphics.drawImage(this.fontImage, n2 - n6, n3 - n7, 20);
        }
        graphics.setClip(0, 0, 176, 220);
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public void destroyFont() {
        this.fontImage = null;
        this.m_bteFrameData = null;
        this.fontSpacing = null;
    }
}

