/*
 * Decompiled with CFR 0.152.
 */
package com.spl;

import com.spl.BundlerFont;
import com.spl.Constants;
import com.spl.Selector;
import com.spl.SelectorCanvas;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Graphics;

public class MoreGamesScreen
implements Constants {
    public static final int STATE_PRODUCT_SCREEN = 2;
    public static final int STATE_BUY_SCREEN = 3;
    private int state;
    private int currProductScreen;
    private final int ONLY_BUY_SCREEN;
    private final int NO_BUTTONS;
    private final int STATIC_MORE;
    private int productScreenType = 0;
    private SelectorCanvas canvas;
    private boolean arrowFlag = false;
    private int img5AnimCount = 0;
    private int selectedBuyButton = 0;
    private BundlerFont mFont;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_BLACK = 0;
    private static final int COLOR_BLUE = 19855;
    private final byte LINES_FIT = (byte)5;
    private final short ARROW_SIZE = (short)10;
    private static final String NEWLINE_STR = "~!";
    private static final String EMPTY_STR = "";
    private static final char SPACE_CHAR = ' ';
    private final byte ITEM_X = (byte)10;

    public MoreGamesScreen(SelectorCanvas selectorCanvas, BundlerFont bundlerFont) {
        this.ONLY_BUY_SCREEN = 0;
        this.NO_BUTTONS = 1;
        this.STATIC_MORE = 2;
        this.canvas = selectorCanvas;
        this.mFont = bundlerFont;
    }

    public void init() {
        this.currProductScreen = 0;
        this.setState(2);
    }

    private void setState(int n) {
        this.state = n;
        if (this.state == 2) {
            this.checkProductScreenType();
        }
    }

    private void checkProductScreenType() {
        this.productScreenType = 0;
        switch (SelectorCanvas.haveMoreGames) {
            case 2: {
                this.productScreenType = 2;
                break;
            }
            case 1: {
                if (this.getText(6 + this.currProductScreen) == null) {
                    this.productScreenType = 1;
                    break;
                }
                this.productScreenType = 0;
                break;
            }
            case 3: {
                this.productScreenType = this.getText(6 + this.currProductScreen) == null ? 2 : 0;
            }
        }
    }

    public boolean keyPressed(int n) {
        switch (this.state) {
            case 2: {
                switch (n) {
                    case -7: {
                        return true;
                    }
                    case -6: 
                    case -5: {
                        if (this.productScreenType == 1) break;
                        this.selectedBuyButton = 0;
                        this.setState(3);
                        break;
                    }
                    case -4: {
                        ++this.currProductScreen;
                        if (this.currProductScreen == this.canvas.cntBuffMG) {
                            this.currProductScreen = 0;
                        }
                        this.checkProductScreenType();
                        this.img5AnimCount = 0;
                        break;
                    }
                    case -3: {
                        --this.currProductScreen;
                        if (this.currProductScreen < 0) {
                            this.currProductScreen = this.canvas.cntBuffMG - 1;
                        }
                        this.checkProductScreenType();
                        this.img5AnimCount = 0;
                        break;
                    }
                    case -2: {
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case -7: {
                        this.setState(2);
                        break;
                    }
                    case -6: 
                    case -5: {
                        if (this.productScreenType == 2) break;
                        if (this.selectedBuyButton == 0) {
                            String string = this.getIgnoreRegisterText(6 + this.currProductScreen);
                            try {
                                Selector.midlet.platformRequest(string);
                            }
                            catch (ConnectionNotFoundException connectionNotFoundException) {
                                connectionNotFoundException.printStackTrace();
                            }
                            Selector.midlet.notifyDestroyed();
                            break;
                        }
                        this.setState(2);
                        break;
                    }
                    case -2: {
                        if (++this.selectedBuyButton <= 1) break;
                        this.selectedBuyButton = 0;
                        break;
                    }
                    case -1: {
                        if (--this.selectedBuyButton >= 0) break;
                        this.selectedBuyButton = 1;
                    }
                }
                this.canvas.repaint();
                this.canvas.serviceRepaints();
            }
        }
        return false;
    }

    public void paint(Graphics graphics) {
        switch (this.state) {
            case 2: {
                this.drawProductScreen(graphics);
                break;
            }
            case 3: {
                this.drawBuyScreen(graphics);
            }
        }
    }

    private String getIgnoreRegisterText(int n) {
        return this.canvas.localText[n];
    }

    private String getText(int n) {
        return this.canvas.localText[n];
    }

    private void drawProductScreen(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(19855);
        graphics.fillRect(0, 0, 240, 320);
        graphics.drawImage(SelectorCanvas.getImage(11 + this.canvas.numBuffMG[this.currProductScreen]), 120, 0, 17);
        if (this.canvas.idMoreGames != null && this.canvas.idMoreGames.length > 1) {
            boolean bl = this.arrowFlag = !this.arrowFlag;
            if (this.arrowFlag) {
                graphics.drawImage(SelectorCanvas.getImage(14), 120 - SelectorCanvas.getImage(16).getWidth() / 2 - SelectorCanvas.getImage(14).getWidth(), 160, 3);
                graphics.drawImage(SelectorCanvas.getImage(15), 120 + SelectorCanvas.getImage(16).getWidth() / 2 + SelectorCanvas.getImage(14).getWidth(), 160, 3);
            } else {
                graphics.drawImage(SelectorCanvas.getImage(14), 120 - SelectorCanvas.getImage(16).getWidth() / 2 - SelectorCanvas.getImage(14).getWidth() * 5 / 4, 160, 3);
                graphics.drawImage(SelectorCanvas.getImage(15), 120 + SelectorCanvas.getImage(16).getWidth() / 2 + SelectorCanvas.getImage(14).getWidth() * 5 / 4, 160, 3);
            }
        }
        if (this.productScreenType != 1) {
            if (this.img5AnimCount++ > 5) {
                this.img5AnimCount = 0;
            }
            graphics.drawImage(SelectorCanvas.getImage(16 + this.img5AnimCount), 120, 160, 3);
            this.mFont.drawString(graphics, this.getText(3), 120, (320 - SelectorCanvas.getImage(16).getHeight()) / 2 - this.mFont.getHeight() / 2, 33);
            this.mFont.drawString(graphics, this.getText(4), 120, (320 + SelectorCanvas.getImage(16).getHeight()) / 2 + this.mFont.getHeight() / 2, 17);
        }
        this.drawSoftKeyBar(graphics);
    }

    private void drawBuyScreen(Graphics graphics) {
        int n;
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(19855);
        graphics.fillRect(0, 0, 240, 320);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 240, SelectorCanvas.getImage(6 + this.canvas.selectedLanguage).getHeight() + 6);
        graphics.drawImage(SelectorCanvas.getImage(6 + this.canvas.selectedLanguage), 120, 3, 17);
        String string = this.productScreenType == 2 ? this.getText(5) : this.getText(2);
        Vector vector = this.getWrappedText(string, 240);
        int n2 = 320 - SelectorCanvas.getImage(6 + this.canvas.selectedLanguage).getHeight() - 6 - SelectorCanvas.getImage(2).getHeight();
        n2 -= vector.size() * this.mFont.getHeight();
        int n3 = (n2 -= 2 * SelectorCanvas.getImage(23).getHeight()) / 4;
        int n4 = n3 + SelectorCanvas.getImage(6 + this.canvas.selectedLanguage).getHeight() + 6;
        for (n = vector.size(); n > 0; --n) {
            String string2 = (String)vector.elementAt(n - 1);
            this.mFont.drawString(graphics, string2, 120, n4 + this.mFont.getHeight() * (n - 1), 17);
        }
        n4 += vector.size() * this.mFont.getHeight();
        if (this.productScreenType != 2) {
            for (n = 0; n <= 1; ++n) {
                n4 += n3;
                if (this.selectedBuyButton == n) {
                    graphics.drawImage(SelectorCanvas.getImage(24), 120, n4, 17);
                } else {
                    graphics.drawImage(SelectorCanvas.getImage(23), 120, n4, 17);
                }
                this.mFont.drawString(graphics, this.getText(0 + n), 120, n4 + (SelectorCanvas.getImage(23).getHeight() - this.mFont.getHeight()) / 2 - 0, 17);
                n4 += SelectorCanvas.getImage(23).getHeight();
            }
        }
        this.drawSoftKeyBar(graphics);
    }

    private void drawSoftKeyBar(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.drawImage(SelectorCanvas.getImage(2), 0, 320, 36);
        graphics.drawImage(SelectorCanvas.getImage(25), 240, 320 - SelectorCanvas.fonHeight / 2, 10);
        if (this.productScreenType != 1 && (this.productScreenType != 2 || this.state != 3)) {
            graphics.drawImage(SelectorCanvas.getImage(0), 0, 320 - SelectorCanvas.fonHeight / 2, 6);
        }
    }

    private void drawSoftKeyBarBack(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.drawImage(SelectorCanvas.getImage(2), 0, 320, 36);
        graphics.drawImage(SelectorCanvas.getImage(25), 240, 320 - SelectorCanvas.fonHeight / 2, 10);
    }

    public void destroy() {
        this.mFont = null;
    }

    public Vector getWrappedText(String string, int n) {
        String string2 = null;
        String string3 = EMPTY_STR;
        int n2 = 10;
        boolean bl = false;
        if (!string.endsWith(NEWLINE_STR)) {
            string = string + NEWLINE_STR;
        }
        Vector<String> vector = new Vector<String>();
        if (string == null || string.equals(EMPTY_STR)) {
            return vector;
        }
        while (string != null) {
            bl = false;
            if (string.indexOf(32) != -1 || string.indexOf(NEWLINE_STR) != -1) {
                string2 = string.indexOf(32) != -1 ? string.substring(0, string.indexOf(32) + 1) : string;
                if (string2.indexOf(NEWLINE_STR) != -1) {
                    string2 = string.substring(0, string.indexOf(NEWLINE_STR));
                    if ((n2 += this.mFont.getSringLength(string2)) < n || string3.equals(EMPTY_STR)) {
                        string3 = string3 + string2;
                        string = string.substring(string.indexOf(NEWLINE_STR) + 2);
                    }
                    bl = true;
                } else if ((n2 += this.mFont.getSringLength(string2)) < n || string3.equals(EMPTY_STR)) {
                    string3 = string3 + string2;
                    string = string.substring(string.indexOf(32) + 1);
                } else if (string.trim().equals(EMPTY_STR)) {
                    bl = true;
                    string = null;
                } else {
                    bl = true;
                }
            } else {
                bl = true;
                if (string.trim().equals(EMPTY_STR)) {
                    string = null;
                } else if (string3.equals(EMPTY_STR)) {
                    string3 = string;
                    string = null;
                }
            }
            if (!bl || string3.equals(EMPTY_STR) && string == null) continue;
            vector.addElement(string3);
            string3 = EMPTY_STR;
            n2 = 10;
        }
        n = -1;
        return vector;
    }
}

