/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Ball {
    int _x;
    int _y;
    int _dx;
    int _dy;
    int _size;
    int _size_div2;
    int _speed;
    ASpriteInstance _instance;
    boolean _inboss = false;
    boolean _lost;
    int _break;
    int counterFrames = 0;
    boolean _bFakeBall;
    int prev_x;
    int prev_y;

    Ball(int x, int y, int dx, int dy) {
        this._x = x;
        this.prev_x = x;
        this._y = y;
        this.prev_y = y;
        this._dx = dx;
        this._dy = dy;
        this._size = 2816;
        this._size_div2 = 1408;
        if (!cGame._bPong && !Level._bIsRandom) {
            if (cGame.firstBall) {
                this._speed = 1160 + 5 * cGame._current_level;
                cGame.firstBall = false;
            } else {
                this._speed = cGame.returnSpeed();
            }
        } else {
            this._speed = 1408;
        }
        this._bFakeBall = false;
        if (this._dx != 0 || this._dy != 0) {
            this.computeSpeed();
        }
        this._instance = new ASpriteInstance(cGame._ball_sprite);
    }

    Ball(Ball ball, int additionalSpeed) {
        this._x = ball._x;
        this._y = ball._y;
        this.prev_x = this._x;
        this.prev_y = this._y;
        this._dx = ball._dx;
        this._dy = ball._dy;
        this._size = ball._size;
        this._size_div2 = ball._size_div2;
        this._speed = ball._speed;
        this._instance = new ASpriteInstance(cGame._ball_sprite);
    }

    public final int bottom() {
        return this._y + this._size_div2;
    }

    void collide(int sensor, int w, int h) {
        if (this._size == 3841) {
            return;
        }
        byte dir = this.getDirection();
        this._x -= 5376;
        this._y -= 12032;
        this._break = 0;
        this.counterFrames = 6;
        if (cGame._ballMustAccelerateCounter == 0) {
            cGame._ballMustAccelerateCounter = 1;
        }
        this._speed += 16 + (cGame._current_level >> 1);
        block0 : switch (sensor) {
            case 12: {
                switch (dir) {
                    case 1: 
                    case 2: {
                        this._dx = -this._dx;
                        break;
                    }
                    case 4: 
                    case 8: {
                        this._dy = -this._dy;
                    }
                }
                break;
            }
            case 3: {
                switch (dir) {
                    case 4: 
                    case 8: {
                        this._dx = -this._dx;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this._dy = -this._dy;
                    }
                }
                break;
            }
            case 10: {
                switch (dir) {
                    case 1: 
                    case 4: {
                        this._dy = -this._dy;
                        break;
                    }
                    case 2: 
                    case 8: {
                        this._dx = -this._dx;
                    }
                }
                break;
            }
            case 5: {
                switch (dir) {
                    case 2: 
                    case 8: {
                        this._dy = -this._dy;
                        break;
                    }
                    case 1: 
                    case 4: {
                        this._dx = -this._dx;
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                this._dx = -this._dx;
                this._dy = -this._dy;
                break;
            }
            case 1: {
                switch (dir) {
                    case 1: {
                        int x = this.left() % w;
                        int y = this.top() % h;
                        if (x >= y) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 2: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 4: {
                        this._dx = -this._dx;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (dir) {
                    case 1: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 2: {
                        int x = this.right() % w;
                        int y = this.top() % h;
                        if (x >= y) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        this._dx = -this._dx;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (dir) {
                    case 1: {
                        this._dx = -this._dx;
                        break block0;
                    }
                    case 4: {
                        int x = this.left() % w;
                        int y = this.bottom() % h;
                        if (x >= y) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        this._dy = -this._dy;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (dir) {
                    case 2: {
                        this._dx = -this._dx;
                        break block0;
                    }
                    case 4: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        int x = this.right() % w;
                        int y = this.bottom() % h;
                        if (x >= y) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                }
            }
        }
        this.computeSpeed();
        this._x += 5376;
        this._y += 12032;
    }

    boolean collideRacket(int delta, int acc, boolean bGoingDown) {
        if (this._dy < 0 && bGoingDown) {
            return false;
        }
        if (this._dy > 0 && !bGoingDown) {
            return false;
        }
        this._dx = delta * 5 / 4;
        this._dy = -this._dy;
        if (cGame._ballMustAccelerateCounter == 0) {
            cGame._ballMustAccelerateCounter = 1;
        }
        this._speed += 12 + (cGame._current_level >> 1);
        if (Racket.yoyo_status > 0) {
            this._speed = cGame.returnSpeed();
        }
        this.computeSpeed();
        return true;
    }

    void computeSpeed() {
        if (this._speed < 768) {
            this._speed = 768;
        }
        if (this._dy == 0) {
            this._dy = 1160;
        }
        if (Math.abs((this._dx << 8) / this._dy) > 1024) {
            this._dx = cGame.SGN(this._dx) * (Math.abs(this._dy) * 1024 >> 8);
        }
        int ray = cGame.squareRoot(this._dx * this._dx + this._dy * this._dy);
        if (this._size == 3840 || this._size == 3841) {
            this._dx = (this._speed + 256) * this._dx / ray;
            this._dy = (this._speed + 256) * this._dy / ray;
        } else {
            this._dx = this._speed * this._dx / ray;
            this._dy = this._speed * this._dy / ray;
        }
    }

    void drawBall(Graphics g) {
        if (this._y >> 8 < 273 + (this._size >> 8)) {
            this._instance.setPosition(this._x, this._y);
            if (cGame._state == 27) {
                this._instance.drawASpriteInstance(0, 0, 0, false, false);
            } else {
                this._instance.drawASpriteInstance(0, 0, 0, true, false);
            }
        }
    }

    public final byte getDirection() {
        if (this._dx > 0) {
            if (this._dy > 0) {
                return 1;
            }
            return 4;
        }
        if (this._dy > 0) {
            return 2;
        }
        return 8;
    }

    public boolean isColliding(Racket aRacket) {
        int x1 = Math.max(this.left(), aRacket.left());
        int y1 = Math.max(this.top(), aRacket.top());
        int x2 = Math.min(this.right(), aRacket.right());
        int y2 = Math.min(this.bottom(), aRacket.bottom());
        if (x1 > x2) {
            return false;
        }
        if (y1 > y2) {
            return false;
        }
        cGame.PlaySound(9);
        return true;
    }

    public final int left() {
        return this._x - this._size_div2;
    }

    public final int right() {
        return this._x + this._size_div2;
    }

    public final int top() {
        return this._y - this._size_div2;
    }

    void updateBall() {
        if (Racket.yoyo_status > 0 || Racket._yoyo) {
            if (Racket._yoyo_call) {
                this._instance.setAnim(5);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(5);
                }
            } else {
                this._instance.setAnim(1);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(1);
                }
            }
            this.counterFrames = 0;
        } else {
            Racket._yoyo = false;
            if (this._size == 3840 || this._size == 3841) {
                if (this._size == 3840) {
                    this._instance.setAnim(2);
                    if (cGame._racket._ball != null) {
                        cGame._racket._ball._instance.setAnim(2);
                    }
                } else {
                    this._instance.setAnim(6);
                    if (cGame._racket._ball != null) {
                        cGame._racket._ball._instance.setAnim(6);
                    }
                }
                this.counterFrames = 0;
            } else if (this._bFakeBall) {
                this._instance.setAnim(7);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(7);
                }
                this.counterFrames = 0;
            } else if (this.counterFrames == 0) {
                this._instance.setAnim(0);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(0);
                }
            } else {
                if (this.counterFrames == 6) {
                    this._instance.setAnim(4);
                } else if (this.counterFrames == 3) {
                    this._instance.setAnim(3);
                }
                --this.counterFrames;
            }
        }
        if (!cGame._bPong) {
            if (this._dy == 0) {
                this._dy += 10;
                return;
            }
            if (this._dx == 0) {
                this._dx += 10;
                return;
            }
        }
        if (this._speed > 2048 || Racket.yoyo_status > 0) {
            this._speed = 2048;
        }
        if (Racket.yoyo_status > 0) {
            this.computeSpeed();
        }
        this._y += cGame.SGN(this._y) * this._dy;
        this._x += cGame.SGN(this._x) * this._dx;
        if (this._x - this._size_div2 <= 5376) {
            this.counterFrames = 6;
            this._x = 5376 + this._size_div2;
            this._dx = -this._dx;
            this._speed += 12 + (cGame._current_level >> 1);
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        } else if (this._x + this._size_div2 >= 56064) {
            this.counterFrames = 6;
            this._x = 56064 - this._size_div2;
            this._dx = -this._dx;
            this._speed += 12 + (cGame._current_level >> 1);
            if (cGame._ballMustAccelerateCounter == 0) {
                cGame._ballMustAccelerateCounter = 1;
            }
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        } else if (this._y - this._size_div2 <= 12032) {
            this.counterFrames = 6;
            this._y = 12032 + this._size_div2;
            this._dy = -this._dy;
            this._speed += 12 + (cGame._current_level >> 1);
            if (cGame._ballMustAccelerateCounter == 0) {
                cGame._ballMustAccelerateCounter = 1;
            }
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        }
    }
}

