/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Level {
    static byte[][] _map_metallic;
    Image _bgPixels;
    Image _brickBBImg;
    byte[] _stack_explosion;
    byte[][] _map_copy;
    byte[][] _map;
    byte[][] _item;
    int[][] _bingo_bricks;
    int[] _bingo_bricks_counter;
    static boolean _brick_changed;
    static boolean _bIsRandom;
    static boolean _bAllLightsOn;
    static int _lights_counter;
    static int _x;
    static int _y;
    static int _width;
    static int _height;
    static int _flags;
    static int totalNumberOfObjects;
    static int briks_on;
    static int briks_on1;
    static int _se_first;
    static int _se_last;
    static int _brickPongCounter;
    static byte _sensor;
    static byte _switch_hit;
    static byte _switch_step;
    static byte _switch_j;
    static byte _switch_i;
    static ASprite _brick;
    static ASpriteInstance _brick_instance;
    int[] _brick_x = new int[]{0, 0, 0, 0};
    int[] _brick_y = new int[]{0, 0, 0, 0};
    byte[] _brick_id = new byte[]{0, 0, 0, 0};
    int[] prevBrickX = new int[]{0, 0, 0, 0};
    int[] prevBrickY = new int[]{0, 0, 0, 0};
    byte[] prevBrickId = new byte[]{0, 0, 0, 0};
    byte[] __temp_brick_id = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] __temp_brick_x = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] __temp_brick_y = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    byte[] __temp_order_1000 = new byte[]{0, 1, 3, 4};
    byte[] __temp_order_0100 = new byte[]{2, 1, 5, 4};
    byte[] __temp_order_0010 = new byte[]{6, 7, 3, 4};
    byte[] __temp_order_0001 = new byte[]{8, 5, 7, 4};
    int[] __temp_size = new int[]{256, 0, 0};

    boolean addExplosion(int x, int y) {
        if (x != -1 && _se_first != _se_last) {
            if (_se_first < _se_last) {
                for (int i = _se_first; i < _se_last; i += 3) {
                    if (this._stack_explosion[i] != x || this._stack_explosion[i + 1] != y) continue;
                    return false;
                }
            } else {
                for (int i = _se_first; i <= 255 + _se_last; i += 3) {
                    if (this._stack_explosion[i & 0xFF] != x || this._stack_explosion[i + 1 & 0xFF] != y) continue;
                    return false;
                }
            }
        }
        this._stack_explosion[Level._se_last] = (byte)x;
        this._stack_explosion[Level._se_last + 1] = (byte)y;
        this._stack_explosion[Level._se_last + 2] = 2;
        _se_last = _se_last + 3 & 0xFF;
        return true;
    }

    void addRandomBrick(int type) {
        int randi = Math.abs(cGame._random.nextInt() % _width);
        int randj = Math.abs(cGame._random.nextInt() % _height);
        for (int step = 0; step < Math.min(_height, _width); ++step) {
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    if (Math.abs(randi - i) > step || Math.abs(randj - j) > step || this._map[i][j] != 0) continue;
                    this._map[i][j] = (byte)type;
                    _brick_changed = true;
                    return;
                }
            }
        }
    }

    void ChangeBingoBrick(int index, int delay) {
        if (this._bingo_bricks_counter[index] % delay == 0) {
            byte old_type = this._map[this._bingo_bricks[index][0]][this._bingo_bricks[index][1]];
            int type = 25 + Math.abs(cGame._random.nextInt() % 3);
            if (type == old_type) {
                type = 25 + Math.abs((type - 25 + 1) % 3);
            }
            this._map[this._bingo_bricks[index][0]][this._bingo_bricks[index][1]] = (byte)type;
            _brick_changed = true;
        }
    }

    boolean collideBrick(Ball ball) {
        int i;
        int[] corner = new int[4];
        int ball_x = ball._x - ball._size_div2 - 5376;
        int ball_y = ball._y - ball._size_div2 - 12032;
        int deltaX = ball._x - ball.prev_x;
        int deltaY = ball._y - ball.prev_y;
        ball.prev_x = ball._x;
        ball.prev_y = ball._y;
        if ((ball_x + ball._size) / 4608 < _x || (ball_x + 256) / 4608 >= _x + _width || (ball_y + 256 + ball._size) / 2304 < _y || ball_y / 2304 >= _y + _height) {
            return false;
        }
        this.testBrickCollisions(ball, ball_x, ball_y);
        if (this._brick_id[0] != 0) {
            corner[0] = Level.testCornel(ball_x - ball._dx + 256, ball_y - ball._dy + 256, this._brick_x[0] * 4608 + 2304, this._brick_y[0] * 2304 + 1152);
        }
        if (this._brick_id[1] != 0) {
            corner[1] = Level.testCornel(ball_x - ball._dx + ball._size, ball_y - ball._dy + 256, this._brick_x[1] * 4608 + 2304, this._brick_y[1] * 2304 + 1152);
        }
        if (this._brick_id[2] != 0) {
            corner[2] = Level.testCornel(ball_x - ball._dx + 256, ball_y - ball._dy + ball._size, this._brick_x[2] * 4608 + 2304, this._brick_y[2] * 2304 + 1152);
        }
        if (this._brick_id[3] != 0) {
            corner[3] = Level.testCornel(ball_x - ball._dx + ball._size, ball_y - ball._dy + ball._size, this._brick_x[3] * 4608 + 2304, this._brick_y[3] * 2304 + 1152);
        }
        if (_sensor == 0) {
            return false;
        }
        byte _oldSensor = _sensor;
        boolean speed = false;
        int sgn = -1;
        if (ball._size != 3841 && _sensor != 0) {
            while (deltaX != 0 || deltaY != 0) {
                sgn = (byte)(_sensor != 0 ? -1 : 1);
                ball._x += (deltaX /= 2) * sgn;
                ball._y += (deltaY /= 2) * sgn;
                ball_x += deltaX * sgn;
                ball_y += deltaY * sgn;
                if (_sensor != 0) {
                    _oldSensor = _sensor;
                    for (i = 0; i < 4; ++i) {
                        this.prevBrickX[i] = this._brick_x[i];
                        this.prevBrickY[i] = this._brick_y[i];
                        this.prevBrickId[i] = this._brick_id[i];
                    }
                }
                this.testBrickCollisions(ball, ball_x, ball_y);
            }
        }
        if (_sensor != 0) {
            _oldSensor = _sensor;
            for (i = 0; i < 4; ++i) {
                this.prevBrickX[i] = this._brick_x[i];
                this.prevBrickY[i] = this._brick_y[i];
                this.prevBrickId[i] = this._brick_id[i];
            }
        }
        ball.prev_x = ball._x;
        ball.prev_y = ball._y;
        if (this.prevBrickId[0] > 0) {
            ball._break += this.hitBrick(this.prevBrickX[0], this.prevBrickY[0], false, corner[0], ball._bFakeBall, true);
        }
        if (this.prevBrickId[1] > 0 && (this.prevBrickX[0] != this.prevBrickX[1] || this.prevBrickY[0] != this.prevBrickY[1])) {
            ball._break += this.hitBrick(this.prevBrickX[1], this.prevBrickY[1], false, corner[1], ball._bFakeBall, true);
        }
        if (this.prevBrickId[2] > 0 && (this.prevBrickX[0] != this.prevBrickX[2] || this.prevBrickY[0] != this.prevBrickY[2])) {
            ball._break += this.hitBrick(this.prevBrickX[2], this.prevBrickY[2], false, corner[2], ball._bFakeBall, true);
        }
        if (!(this.prevBrickId[3] <= 0 || this.prevBrickX[1] == this.prevBrickX[3] && this.prevBrickY[1] == this.prevBrickY[3] || this.prevBrickX[2] == this.prevBrickX[3] && this.prevBrickY[2] == this.prevBrickY[3])) {
            ball._break += this.hitBrick(this.prevBrickX[3], this.prevBrickY[3], false, corner[3], ball._bFakeBall, true);
        }
        if (ball._size != 3840 || ball._size != 3841 || ball._break >= 4) {
            ball.collide(_oldSensor, 4608, 2304);
        }
        return true;
    }

    boolean collideLayer(Ball ball, int layer_x, int layer_y, int layer_w, int layer_h) {
        int ball_x = ball._x - ball._size_div2 - 5376;
        int ball_y = ball._y - ball._size_div2 - 12032;
        boolean bCol = false;
        if (ball_x + ball._size < layer_x || ball_x + 256 >= layer_x + layer_w || ball_y + 256 + ball._size < layer_y || ball_y >= layer_y + layer_h) {
            return false;
        }
        bCol = ball_x + 256 >= layer_x && ball_x + 256 <= layer_x + layer_w && ball_y + 256 >= layer_y && ball_y + 256 <= layer_y + layer_h;
        _sensor = (byte)(bCol ? 8 : 0);
        bCol = ball_x + ball._size >= layer_x && ball_x + ball._size <= layer_x + layer_w && ball_y + 256 >= layer_y && ball_y + 256 <= layer_y + layer_h;
        _sensor = (byte)(_sensor | (byte)(bCol ? 4 : 0));
        bCol = ball_x + 256 >= layer_x && ball_x + 256 <= layer_x + layer_w && ball_y + ball._size >= layer_y && ball_y + ball._size <= layer_y + layer_h;
        _sensor = (byte)(_sensor | (byte)(bCol ? 2 : 0));
        bCol = ball_x + ball._size >= layer_x && ball_x + ball._size <= layer_x + layer_w && ball_y + ball._size >= layer_y && ball_y + ball._size <= layer_y + layer_h;
        if ((_sensor = (byte)(_sensor | (byte)(bCol ? 1 : 0))) == 0) {
            return false;
        }
        if (_sensor == 15) {
            int magnitude = cGame.squareRoot(ball._dx * ball._dx + ball._dy * ball._dy);
            int mag = magnitude >> 8;
            int ndx = (int)((long)(ball._dx << 8) / (long)magnitude);
            int ndy = (int)((long)(ball._dy << 8) / (long)magnitude);
            ball._x -= ndx;
            ball._y -= ndy;
            this.collideLayer(ball, layer_x, layer_y, layer_w, layer_h);
            return true;
        }
        ball.collide(_sensor, layer_w, layer_h);
        return true;
    }

    void draw(Graphics g, boolean showBorder) {
        boolean nb = false;
        int ligtsON = 0;
        int ligtsOFF = 0;
        ASprite._g = g;
        if (_brickPongCounter > 0) {
            --_brickPongCounter;
        }
        if (cGame._state == 26) {
            g.setClip(0, 47, 240, 226);
            g.drawImage(this._bgPixels, 0, 0, 0);
        } else if (showBorder || cGame._isBoss) {
            g.setClip(0, 0, 240, 320);
            g.drawImage(this._bgPixels, 0, 0, 0);
            cGame._isBoss = false;
        } else {
            g.setClip(0, 42, 240, 278);
            g.drawImage(this._bgPixels, 0, 0, 0);
        }
        int offset_x = _x * 18 + 21;
        int offset_y = _y * 9 + 47;
        if (this._brickBBImg == null) {
            this._brickBBImg = Image.createImage((int)(_width * 18), (int)(_height * 9));
            this._map_copy = new byte[_width][_height];
            briks_on = 0;
            briks_on1 = 0;
            totalNumberOfObjects = 0;
            ASprite._g = this._bgPixels.getGraphics();
            Graphics temp1 = this._brickBBImg.getGraphics();
            temp1.setClip(0, 0, _width * 18, _height * 9);
            temp1.drawImage(this._bgPixels, -offset_x, -offset_y, 0);
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    int brick = this._map[i][j] & 0xFF;
                    if (brick > 0 && brick != 4 && brick != 17 && brick != 16) {
                        ++briks_on;
                        ++briks_on1;
                        ++totalNumberOfObjects;
                    }
                    if (brick == 20 || brick == 21 || brick == 22 || brick == 24) {
                        brick = 10;
                    } else if (brick == 23) {
                        brick = 2;
                    } else if (brick == 25 || brick == 26 || brick == 27) {
                        brick -= 5;
                    } else if (brick == 28 || brick == 29) {
                        brick = 9;
                    }
                    if (brick > 0) {
                        ASprite._g.setClip(0, 0, 240, 320);
                        _brick_instance.setAnim(brick - 1);
                        _brick_instance.drawASpriteInstance(-i * 18 - offset_x, -j * 9 - offset_y, 0, false, false);
                    }
                    this._map_copy[i][j] = (byte)brick;
                }
            }
            _brick_changed = false;
        } else if (_brick_changed) {
            briks_on = 0;
            briks_on1 = 0;
            ASprite._g = this._bgPixels.getGraphics();
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    int brick = this._map[i][j] & 0xFF;
                    int brick_copy = this._map_copy[i][j] & 0xFF;
                    if (brick > 0) {
                        ++briks_on1;
                        if (brick != 4 && brick != 17 && brick != 16) {
                            ++briks_on;
                        }
                    }
                    if (brick == 19) {
                        ++ligtsON;
                    } else if (brick == 18) {
                        ++ligtsOFF;
                    }
                    if (brick == brick_copy) continue;
                    this._map_copy[i][j] = (byte)brick;
                    if (brick == 0) {
                        ASprite._g.setClip(offset_x + i * 18, offset_y + j * 9, 18, 9);
                        ASprite._g.drawImage(this._brickBBImg, offset_x, offset_y, 0);
                        continue;
                    }
                    ASprite._g.setClip(0, 0, 240, 320);
                    if (brick == 20 || brick == 21 || brick == 22 || brick == 24) {
                        brick = 10;
                    } else if (brick == 23) {
                        brick = 2;
                    } else if (brick == 25 || brick == 26 || brick == 27) {
                        brick -= 5;
                    } else if (brick == 28 || brick == 29) {
                        brick = 9;
                    }
                    _brick_instance.setAnim(brick - 1);
                    _brick_instance.drawASpriteInstance(-i * 18 - offset_x, -j * 9 - offset_y, 0, true, false);
                }
            }
            _brick_changed = false;
        }
        ASprite._g = g;
        if (ligtsON > 0 && ligtsOFF == 0) {
            _bAllLightsOn = true;
        }
    }

    boolean explode(int x, int y, int explo_range) {
        boolean result = false;
        x -= _x;
        y -= _y;
        for (int j = -explo_range; j <= explo_range; ++j) {
            for (int i = -explo_range; i <= explo_range; ++i) {
                if (x + i < 0 || x + i >= _width || y + j < 0 || y + j >= _height || this._map[x + i][y + j] == 0 || this._map[x + i][y + j] == 4) continue;
                result |= this.addExplosion(x + i + _x, y + j + _y);
            }
        }
        return result;
    }

    void ExplodeAllLights() {
        if (++_lights_counter == 1) {
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    if (this._map[i][j] != 19) continue;
                    ASpriteInstance fx = new ASpriteInstance(_brick);
                    fx.setAnim(22);
                    fx.setPosition((i + _x) * 4608 + 5376, (j + _y) * 2304 + 12032);
                    cGame.addFX(fx);
                }
            }
        } else if (_lights_counter >= 18) {
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    if (this._map[i][j] != 19) continue;
                    cGame.addItem(this._item[i][j], i * 4608 + 5376 + 1280, (j + 1) * 2304 + 12032);
                    this._item[i][j] = 0;
                    this._map[i][j] = 0;
                    _brick_changed = true;
                    ASpriteInstance fx = new ASpriteInstance(cGame._fx_sprite);
                    fx.setPosition((i + _x) * 4608 + 5376, (j + _y) * 2304 + 12032);
                    cGame.addFX(fx);
                    cGame._levelScore += 300L;
                }
            }
            _bAllLightsOn = false;
            _lights_counter = 0;
        }
    }

    byte getBrick(int x, int y) {
        if ((x -= _x) < 0 || x >= _width || (y -= _y) < 0 || y >= _height) {
            return 0;
        }
        return this._map[x][y];
    }

    int hitBrick(int x, int y, boolean destroy, int corner, boolean _bFake, boolean isBall) {
        if (isBall) {
            destroy = destroy || (cGame._ball[0]._size >= 3840 || Racket.yoyo_status > 0) && !Racket.isBulletActive;
        }
        int result = 0;
        switch (this._map[x - _x][y - _y]) {
            case 6: {
                cGame._levelScore += 600L;
            }
            case 1: 
            case 9: 
            case 16: 
            case 17: {
                if (this._map[x - _x][y - _y] == 16) {
                    this.addRandomBrick(16);
                    cGame._levelScore += 15L;
                } else {
                    cGame._levelScore = this._map[x - _x][y - _y] == 17 ? (cGame._levelScore += 15L) : (cGame._levelScore += 300L);
                }
                cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                if (this._map[x - _x][y - _y] == 6) {
                    cGame.PlaySound(10);
                } else {
                    cGame.PlaySound(7);
                }
                this._map[x - Level._x][y - Level._y] = 0;
                this._item[x - Level._x][y - Level._y] = 0;
                _brick_changed = true;
                ASpriteInstance fx = new ASpriteInstance(cGame.bricXplosion);
                fx.setAnim(0);
                fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                cGame.addFX(fx);
                ++result;
                break;
            }
            case 2: 
            case 11: 
            case 23: {
                if (destroy) {
                    cGame._levelScore = this._map[x - _x][y - _y] == 2 ? (cGame._levelScore += 600L) : (cGame._levelScore += 900L);
                    cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                    this._item[x - Level._x][y - Level._y] = 0;
                    this._map[x - Level._x][y - Level._y] = 0;
                    _brick_changed = true;
                    ASpriteInstance fx = new ASpriteInstance(cGame.bricXplosion);
                    fx.setAnim(0);
                    fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                    cGame.addFX(fx);
                    ++result;
                } else {
                    this._map[x - Level._x][y - Level._y] = this._map[x - _x][y - _y] == 23 ? 11 : 6;
                    _brick_changed = true;
                    ++result;
                }
                cGame.PlaySound(10);
                break;
            }
            case 3: {
                this.addExplosion(x, y);
                this.addExplosion(-1, -1);
                return ++result;
            }
            case 4: {
                result += 4;
                byte[] byArray = _map_metallic[x - _x];
                int n = y - _y;
                byArray[n] = (byte)(byArray[n] - 1);
                if (destroy || _map_metallic[x - _x][y - _y] <= 0 && !cGame._bPong) {
                    cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                    ASpriteInstance fx = new ASpriteInstance(cGame.bricXplosion);
                    fx.setAnim(0);
                    fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                    cGame.addFX(fx);
                    this._map[x - Level._x][y - Level._y] = 0;
                    this._item[x - Level._x][y - Level._y] = 0;
                    _brick_changed = true;
                    cGame._levelScore += 900L;
                    cGame.PlaySound(10);
                } else {
                    ASpriteInstance fx = new ASpriteInstance(_brick);
                    fx.setAnim(6);
                    fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                    cGame.addFX(fx);
                    cGame.PlaySound(8);
                }
                return result;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                _switch_hit = (byte)(this._map[x - _x][y - _y] - 20);
                _switch_i = (byte)(x - _x);
                _switch_j = (byte)(y - _y);
                _switch_step = 1;
                cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                this._map[x - Level._x][y - Level._y] = 0;
                _brick_changed = true;
                ASpriteInstance fx = new ASpriteInstance(cGame.bricXplosion);
                fx.setAnim(0);
                fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                cGame.addFX(fx);
                this._map[x - Level._x][y - Level._y] = 0;
                this._item[x - Level._x][y - Level._y] = 0;
                _brick_changed = true;
                cGame.PlaySound(16);
                cGame._levelScore += 300L;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                if (destroy || this._map[x - _x][y - _y] == 12 && (corner & 1) == 0 || this._map[x - _x][y - _y] == 13 && (corner & 1) != 0 || this._map[x - _x][y - _y] == 14 && corner < 2 || this._map[x - _x][y - _y] == 15 && corner > 1) {
                    cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                    ASpriteInstance fx = new ASpriteInstance(cGame.bricXplosion);
                    fx.setAnim(0);
                    fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                    cGame.addFX(fx);
                    this._map[x - Level._x][y - Level._y] = 0;
                    this._item[x - Level._x][y - Level._y] = 0;
                    _brick_changed = true;
                    cGame._levelScore += 750L;
                    cGame.PlaySound(7);
                    break;
                }
                result += 4;
                cGame.PlaySound(10);
                break;
            }
            case 18: {
                this._map[x - Level._x][y - Level._y] = 19;
                _brick_changed = true;
                cGame.PlaySound(7);
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                int i;
                for (i = 0; i < 20; ++i) {
                    if (this._bingo_bricks_counter[i] < 0 || this._bingo_bricks[i][0] != x - _x || this._bingo_bricks[i][1] != y - _y) continue;
                    return result;
                }
                for (i = 0; i < 20; ++i) {
                    if (this._bingo_bricks_counter[i] >= 0) continue;
                    this._bingo_bricks_counter[i] = 0;
                    this._bingo_bricks[i][0] = x - _x;
                    this._bingo_bricks[i][1] = y - _y;
                    return result;
                }
                break;
            }
            case 28: {
                if (_brickPongCounter != 0 || _bFake) break;
                cGame.MultiplyBall(3, true);
                _brickPongCounter = 10;
                break;
            }
            case 29: {
                if (_bFake) break;
                cGame.MakePongSmallOrBig();
            }
        }
        return result;
    }

    Level() {
        if (_brick_instance == null) {
            _brick_instance = new ASpriteInstance(_brick);
        }
        this._stack_explosion = new byte[259];
    }

    void load(int level) {
        int i;
        for (i = 0; i < 4; ++i) {
            Racket.bullety2[i] = -1;
            Racket.bullety1[i] = -1;
        }
        briks_on = 1;
        _switch_hit = (byte)-1;
        _bIsRandom = false;
        _bAllLightsOn = false;
        _lights_counter = 0;
        this._brickBBImg = null;
        System.gc();
        this._bingo_bricks = new int[20][2];
        this._bingo_bricks_counter = new int[20];
        cGame._delay_add_random_brick = 100;
        for (i = 0; i < 20; ++i) {
            this._bingo_bricks_counter[i] = -1;
        }
        try {
            int j;
            InputStream in_files = this.getClass().getResourceAsStream("/levels.dat");
            in_files.skip(2 + cGame.nr_levels * 4 + cGame.levels_offsets[level]);
            byte[] tmp = new byte[5];
            in_files.read(tmp);
            _x = tmp[0] & 0xFF;
            _y = tmp[1] & 0xFF;
            _width = tmp[2] & 0xFF;
            _height = tmp[3] & 0xFF;
            _flags = tmp[4] & 0xFF;
            tmp = new byte[_width * _height];
            in_files.read(tmp);
            this._map = new byte[_width][_height];
            _map_metallic = new byte[_width][_height];
            totalNumberOfObjects = 0;
            for (j = 0; j < _height; ++j) {
                for (i = 0; i < _width; ++i) {
                    this._map[i][j] = tmp[i + j * _width];
                    if (this._map[i][j] != 0) {
                        ++totalNumberOfObjects;
                    }
                    Level._map_metallic[i][j] = this._map[i][j] == 4 ? 25 : 0;
                }
            }
            in_files.read(tmp);
            this._item = new byte[_width][_height];
            for (j = 0; j < _height; ++j) {
                for (i = 0; i < _width; ++i) {
                    this._item[i][j] = tmp[i + j * _width];
                    if (this._item[i][j] != 0) {
                        ++totalNumberOfObjects;
                    }
                    if (this._item[i][j] != 21) continue;
                    _bIsRandom = true;
                    if (cGame._delay_add_random_brick <= 20) continue;
                    cGame._delay_add_random_brick -= 10;
                }
            }
            in_files.close();
        }
        catch (Exception e) {
            this._map = null;
        }
        System.gc();
    }

    void testBrickCollisions(Ball ball, int ball_x, int ball_y) {
        int idx;
        int i;
        this.__temp_size[1] = ball._size_div2;
        this.__temp_size[2] = ball._size;
        for (int j = 0; j < 3; ++j) {
            for (i = 0; i < 3; ++i) {
                idx = j * 3 + i;
                this.__temp_brick_x[idx] = (ball_x + this.__temp_size[i]) / 4608;
                this.__temp_brick_y[idx] = (ball_y + this.__temp_size[j]) / 2304;
                this.__temp_brick_id[idx] = this.getBrick(this.__temp_brick_x[idx], this.__temp_brick_y[idx]);
            }
        }
        this.__temp_brick_x[0] = this.__temp_brick_x[1] + this.__temp_brick_x[3] >> 1;
        this.__temp_brick_y[0] = this.__temp_brick_y[1] + this.__temp_brick_y[3] >> 1;
        this.__temp_brick_id[0] = this.getBrick(this.__temp_brick_x[0], this.__temp_brick_y[0]);
        this.__temp_brick_x[2] = this.__temp_brick_x[1] + this.__temp_brick_x[5] >> 1;
        this.__temp_brick_y[2] = this.__temp_brick_y[1] + this.__temp_brick_y[5] >> 1;
        this.__temp_brick_id[2] = this.getBrick(this.__temp_brick_x[2], this.__temp_brick_y[2]);
        this.__temp_brick_x[6] = this.__temp_brick_x[3] + this.__temp_brick_x[7] >> 1;
        this.__temp_brick_y[6] = this.__temp_brick_y[3] + this.__temp_brick_y[7] >> 1;
        this.__temp_brick_id[6] = this.getBrick(this.__temp_brick_x[6], this.__temp_brick_y[6]);
        this.__temp_brick_x[8] = this.__temp_brick_x[5] + this.__temp_brick_x[7] >> 1;
        this.__temp_brick_y[8] = this.__temp_brick_y[5] + this.__temp_brick_y[7] >> 1;
        this.__temp_brick_id[8] = this.getBrick(this.__temp_brick_x[8], this.__temp_brick_y[8]);
        _sensor = 0;
        for (i = 0; i < 4; ++i) {
            idx = this.__temp_order_1000[i];
            this._brick_x[0] = this.__temp_brick_x[idx];
            this._brick_y[0] = this.__temp_brick_y[idx];
            this._brick_id[0] = this.__temp_brick_id[idx];
            if (this._brick_id[0] == 0) continue;
            _sensor = (byte)8;
            break;
        }
        for (i = 0; i < 4; ++i) {
            idx = this.__temp_order_0100[i];
            this._brick_x[1] = this.__temp_brick_x[idx];
            this._brick_y[1] = this.__temp_brick_y[idx];
            this._brick_id[1] = this.__temp_brick_id[idx];
            if (this._brick_id[1] == 0) continue;
            _sensor = (byte)(_sensor | 4);
            break;
        }
        for (i = 0; i < 4; ++i) {
            idx = this.__temp_order_0010[i];
            this._brick_x[2] = this.__temp_brick_x[idx];
            this._brick_y[2] = this.__temp_brick_y[idx];
            this._brick_id[2] = this.__temp_brick_id[idx];
            if (this._brick_id[2] == 0) continue;
            _sensor = (byte)(_sensor | 2);
            break;
        }
        for (i = 0; i < 4; ++i) {
            idx = this.__temp_order_0001[i];
            this._brick_x[3] = this.__temp_brick_x[idx];
            this._brick_y[3] = this.__temp_brick_y[idx];
            this._brick_id[3] = this.__temp_brick_id[idx];
            if (this._brick_id[3] == 0) continue;
            _sensor = (byte)(_sensor | 1);
            break;
        }
    }

    static int testCornel(int ballX, int ballY, int brickX, int brickY) {
        int cornel = 0;
        if (ballY > brickY) {
            cornel += 2;
        }
        if (ballX > brickX) {
            ++cornel;
        }
        return cornel;
    }

    void UpdateBingoBricks() {
        for (int i = 0; i < 20; ++i) {
            if (this._bingo_bricks_counter[i] < 0) continue;
            int n = i;
            this._bingo_bricks_counter[n] = this._bingo_bricks_counter[n] + 1;
            if (this._bingo_bricks_counter[i] < 20) {
                this.ChangeBingoBrick(i, 2);
                continue;
            }
            if (this._bingo_bricks_counter[i] >= 20 && this._bingo_bricks_counter[i] < 40) {
                this.ChangeBingoBrick(i, 4);
                continue;
            }
            if (this._bingo_bricks_counter[i] >= 40 && this._bingo_bricks_counter[i] < 60) {
                this.ChangeBingoBrick(i, 6);
                continue;
            }
            if (this._bingo_bricks_counter[i] >= 60 && this._bingo_bricks_counter[i] < 80) {
                this.ChangeBingoBrick(i, 10);
                continue;
            }
            this._bingo_bricks_counter[i] = -1;
            if (this._map[this._bingo_bricks[i][0]][this._bingo_bricks[i][1]] != 27) continue;
            cGame.addItem(this._item[this._bingo_bricks[i][0]][this._bingo_bricks[i][1]], (this._bingo_bricks[i][0] + _x) * 4608 + 5376 + 1280, (this._bingo_bricks[i][1] + _y + 1) * 2304 + 12032);
            this._map[this._bingo_bricks[i][0]][this._bingo_bricks[i][1]] = 0;
            this._item[this._bingo_bricks[i][0]][this._bingo_bricks[i][1]] = 0;
            _brick_changed = true;
            ASpriteInstance fx = new ASpriteInstance(cGame._fx_sprite);
            fx.setPosition((this._bingo_bricks[i][0] + _x) * 4608 + 5376, (this._bingo_bricks[i][1] + _y) * 2304 + 12032);
            cGame.addFX(fx);
            cGame._levelScore += 1500L;
        }
    }

    void updateExplosion() {
        int first = _se_first;
        boolean next = false;
        boolean exp_add = false;
        while (this._stack_explosion[first] != -1) {
            if (this._stack_explosion[first + 2] == 2) {
                byte x = this._stack_explosion[first];
                byte y = this._stack_explosion[first + 1];
                if (this._map[x - _x][y - _y] == 3) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int i = -1; i <= 1; ++i) {
                            if (x + i - _x < 0 || x + i - _x >= _width || y + j - _y < 0 || y + j - _y >= _height || this._map[x + i - _x][y + j - _y] != 3) continue;
                            exp_add |= this.explode(x, y, 1);
                        }
                    }
                }
                if (this._map[x - _x][y - _y] == 20 || this._map[x - _x][y - _y] == 21 || this._map[x - _x][y - _y] == 22) {
                    _switch_hit = (byte)(this._map[x - _x][y - _y] - 20);
                    _switch_i = (byte)(x - _x);
                    _switch_j = (byte)(y - _y);
                    _switch_step = 1;
                }
                this._map[x - Level._x][y - Level._y] = 0;
                _brick_changed = true;
                cGame.addItem(this._item[x - _x][y - _y], x * 4608 + 5376 + 1280, (y + 1) * 2304 + 12032);
                ASpriteInstance fx = new ASpriteInstance(cGame._fx_sprite);
                fx.setPosition(x * 4608 + 5376, y * 2304 + 12032);
                cGame.addFX(fx);
                cGame._levelScore += 150L;
                this._item[x - Level._x][y - Level._y] = 0;
            }
            int n = first + 2;
            this._stack_explosion[n] = (byte)(this._stack_explosion[n] - 1);
            next |= this._stack_explosion[first + 2] == 0;
            first = first + 3 & 0xFF;
        }
        _se_first = first + 3 & 0xFF;
        if (exp_add) {
            this.addExplosion(-1, -1);
        }
    }

    void updateSwitch() {
        if (_switch_hit < 0) {
            return;
        }
        if (_switch_hit == 4) {
            if (_switch_i - _switch_step >= 0) {
                this._map[Level._switch_i - Level._switch_step][Level._switch_j] = 0;
            }
            if (_switch_i - _switch_step - 1 >= 0) {
                this._map[Level._switch_i - Level._switch_step - 1][Level._switch_j] = 0;
            }
            if (_switch_i + _switch_step < _width) {
                this._map[Level._switch_i + Level._switch_step][Level._switch_j] = 0;
            }
            if (_switch_i + _switch_step + 1 < _width) {
                this._map[Level._switch_i + Level._switch_step + 1][Level._switch_j] = 0;
            }
            _brick_changed = true;
            _switch_step = (byte)(_switch_step + 2);
        } else {
            for (int j = 0; j < _height; ++j) {
                for (int i = 0; i < _width; ++i) {
                    if (Math.abs(_switch_i - i) > _switch_step || Math.abs(_switch_j - j) > _switch_step) continue;
                    if (this._item[i][j] >= 30 + 10 * _switch_hit && this._item[i][j] < 30 + 10 * (_switch_hit + 1)) {
                        switch (this._item[i][j] - (30 + 10 * _switch_hit)) {
                            case 0: {
                                this._map[i][j] = 1;
                                break;
                            }
                            case 1: {
                                this._map[i][j] = 2;
                                break;
                            }
                            case 2: {
                                this._map[i][j] = 23;
                                break;
                            }
                            case 3: {
                                this._map[i][j] = 3;
                                break;
                            }
                            case 4: {
                                this._map[i][j] = 12;
                                break;
                            }
                            case 5: {
                                this._map[i][j] = 13;
                                break;
                            }
                            case 6: {
                                this._map[i][j] = 14;
                                break;
                            }
                            case 7: {
                                this._map[i][j] = 15;
                                break;
                            }
                            case 8: {
                                this._map[i][j] = 0;
                            }
                        }
                        this._item[i][j] = 0;
                        _brick_changed = true;
                        continue;
                    }
                    if (this._item[i][j] < 60 + 10 * _switch_hit || this._item[i][j] >= 60 + 10 * (_switch_hit + 1)) continue;
                    switch (this._item[i][j] - (60 + 10 * _switch_hit)) {
                        case 0: {
                            this._map[i][j] = 9;
                            this._item[i][j] = 14;
                            break;
                        }
                        case 1: {
                            this._map[i][j] = 9;
                            this._item[i][j] = 13;
                            break;
                        }
                        case 2: {
                            this._map[i][j] = 9;
                            this._item[i][j] = 8;
                            break;
                        }
                        case 3: {
                            this._map[i][j] = 9;
                            this._item[i][j] = 6;
                        }
                    }
                    _brick_changed = true;
                }
            }
            _switch_step = (byte)(_switch_step + 1);
        }
        if (_switch_step > _width && _switch_step > _height) {
            _switch_hit = (byte)-1;
        }
    }

    void XplodeBrick(int x, int y) {
        cGame._instanceXplosion.setAnim(0);
        cGame._instanceXplosion.setPosition(x * 4608 + 5376, y * 2304 + 12032);
        cGame._instanceXplosion.drawASpriteInstance(0, 0, 0, true, false);
    }

    static {
        totalNumberOfObjects = 0;
    }
}

