/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class ASpriteInstance {
    int _posX;
    int _posY;
    int _pos_ox;
    int _pos_oy;
    private ASprite _sprite;
    int _nCrtAnim;
    int _nCrtAFrame;
    int _nCrtTime;
    int[] _rect;
    int _nCrtAnimFrameWidth;
    int _nCrtAnimFrameHeight;
    boolean _no_loop;
    boolean _loop;
    static final boolean DRAW_DEBUG_FRAMES = false;
    private int _vis;

    ASpriteInstance() {
        this._rect = new int[4];
    }

    ASpriteInstance(ASprite spr) {
        this._posX = 0;
        this._posY = 0;
        this._sprite = spr;
        this._rect = new int[4];
    }

    ASpriteInstance(ASprite spr, int posX, int posY, ASpriteInstance parent) {
        this._posX = posX << 8;
        this._posY = posY << 8;
        this._sprite = spr;
        this._rect = new int[4];
    }

    void SetSprite(ASprite spr) {
        this._sprite = spr;
        this._nCrtAnim = 0;
        this._nCrtAFrame = 0;
        this._nCrtTime = 0;
        this._pos_ox = 0;
        this._pos_oy = 0;
    }

    boolean IsSpriteNull() {
        return false;
    }

    void setAnim(int id) {
        if (this == Level._brick_instance) {
            this._nCrtAFrame = 0;
        }
        if (id != this._nCrtAnim) {
            this._loop = false;
            this._nCrtAnim = id;
            this._nCrtAFrame = 0;
            this._nCrtTime = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        }
    }

    void ApplyAnimOff() {
        this._posX -= this._pos_ox;
        this._posY -= this._pos_oy;
        int off = (this._sprite._anims_af_start[this._nCrtAnim] + this._nCrtAFrame) * 5;
        this._pos_ox = (this._sprite._aframes[off + 2] << 8) * 1 / 1;
        this._pos_oy = (this._sprite._aframes[off + 3] << 8) * 1 / 1;
        this._posX += this._pos_ox;
        this._posY += this._pos_oy;
    }

    boolean IsAnimEnded() {
        if (this._nCrtAFrame != this._sprite.GetAFrames(this._nCrtAnim) - 1) {
            return false;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        return time == 0 || this._nCrtTime >= time - 1;
    }

    void PaintSprite(Graphics g, int x, int y, int manipulation) {
        if (this._sprite == null) {
            return;
        }
        int posX = this._posX;
        int posY = this._posY;
        posX = ASpriteInstance.ZOOM_IN_FIXED_X(posX) + 0 - x;
        posY = ASpriteInstance.ZOOM_IN_FIXED_Y(posY) + 0 - y;
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(g, this._nCrtAnim, this._nCrtAFrame, posX, posY, manipulation, 0, 0);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(g, this._nCrtAnim, posX, posY, manipulation);
        } else if (this._nCrtAFrame >= 0) {
            this._sprite.PaintFrame(g, this._nCrtAFrame, posX, posY, manipulation, 0, 0);
        }
    }

    void UpdateSpriteAnim() {
        if (this._sprite == null) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (time == 0) {
            return;
        }
        ++this._nCrtTime;
        if (time > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        ++this._nCrtAFrame;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            this._loop = true;
            this._nCrtAFrame = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        } else {
            this._loop = false;
        }
    }

    void UpdateSpriteAnimTo(int dest) {
        if (this._sprite == null) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (time == 0) {
            return;
        }
        ++this._nCrtTime;
        if (time > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        ++this._nCrtAFrame;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            this._nCrtAFrame = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
            this.setAnim(dest);
        }
    }

    int[] GetRect() {
        if (this._sprite != null) {
            if (this._nCrtTime >= 0) {
                this._sprite.GetAFrameRect(this._rect, this._nCrtAnim, this._nCrtAFrame, this._posX, this._posY, 0, 0, 0);
            } else if (this._nCrtAnim >= 0) {
                this._sprite.GetModuleRect(this._rect, this._nCrtAnim, this._posX, this._posY, 0);
            } else if (this._nCrtAFrame >= 0) {
                this._sprite.GetFrameRect(this._rect, this._nCrtAFrame, this._posX, this._posY, 0, 0, 0);
            }
        }
        return this._rect;
    }

    static boolean IsRectCrossing(int[] rect1, int[] rect2) {
        if (rect1[0] > rect2[2]) {
            return false;
        }
        if (rect1[2] < rect2[0]) {
            return false;
        }
        if (rect1[1] > rect2[3]) {
            return false;
        }
        return rect1[3] >= rect2[1];
    }

    static boolean IsPointInRect(int x, int y, int[] rect) {
        if (x < rect[0]) {
            return false;
        }
        if (x > rect[2]) {
            return false;
        }
        if (y < rect[1]) {
            return false;
        }
        return y <= rect[3];
    }

    void OnScreenTest() {
        int ox = 0;
        int oy = 0;
        int[] rect = this.GetRect();
        rect[0] = rect[0] + (ox - 61440);
        rect[1] = rect[1] + (oy - 81920);
        rect[2] = rect[2] + ox;
        rect[3] = rect[3] + oy;
        this._vis = 0;
        if (rect[0] < 0 && rect[2] >= 0 && rect[1] < 0 && rect[3] >= 0) {
            this._vis = 15;
        }
    }

    boolean IsOnScreen(int style) {
        return (this._vis & style) != 0;
    }

    int getWidth() {
        this.GetRect();
        return ASpriteInstance.ZOOM_IN_FIXED_X(this._rect[2] - this._rect[0]);
    }

    int getHeight() {
        this.GetRect();
        return ASpriteInstance.ZOOM_IN_FIXED_Y(this._rect[3] - this._rect[1]);
    }

    void drawASpriteInstance(int x, int y, int manipulation, boolean update, boolean clipped) {
        if (update) {
            this.UpdateSpriteAnim();
        }
        if (this._no_loop && this._loop) {
            return;
        }
        this.PaintSprite(ASprite._g, x, y, manipulation);
    }

    void setPosition(int posX, int posY) {
        this._posX = posX;
        this._posY = posY;
    }

    static int ZOOM_IN_FIXED_X(int x) {
        return (x >> 8) * 1 / 1;
    }

    static int ZOOM_IN_FIXED_Y(int y) {
        return (y >> 8) * 1 / 1;
    }
}

