/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CSprite {
    static final int k_CanvasHeight = 220;
    private static int[] m_iTmpBuffer = new int[30720];
    private static final short PIXEL_FORMAT_8888 = -30584;
    private static final short PIXEL_FORMAT_4444 = 17476;
    private static final short ENCODE_FORMAT_I2 = 512;
    private static final short ENCODE_FORMAT_I4 = 1024;
    private static final short ENCODE_FORMAT_I16 = 5632;
    private static final short ENCODE_FORMAT_I256 = 22018;
    private static final short ENCODE_FORMAT_I64RLE = 25840;
    private static final short ENCODE_FORMAT_I127RLE = 10225;
    private static final short ENCODE_FORMAT_I256RLE = 22258;
    static final byte FLAG_FLIP_X = 1;
    static final byte FLAG_FLIP_Y = 2;
    static final byte FLAG_ROT_180 = 3;
    static final byte FLAG_ROT_90 = 4;
    static final byte FLAG_ROT_270 = 6;
    static final byte FLAG_HYPER_FM = 16;
    static final byte FLAG_OFFSET_FM = 16;
    static final byte FLAG_OFFSET_AF = 32;
    private static final int BS_FM_OFF_SHORT = 1024;
    short[] m_asModuleWidth;
    short[] m_asModuleHeight;
    short[] m_asModuleIndices;
    short[] m_asFModuleOfsX;
    short[] m_asFModuleOfsY;
    byte[] m_abFModuleFlags;
    short[] m_asNumFModules;
    private byte[] m_abFrameRectX;
    private byte[] m_abFrameRectY;
    private short[] m_asFrameRectW;
    private short[] m_asFrameRectH;
    short[] m_asFirstFModuleIndices;
    short[] m_asFrameIndices;
    public byte[] m_abAFrameTime;
    public byte[] m_abAFrameOfsX;
    public byte[] m_abAFrameOfsY;
    public byte[] m_abAFrameFlags;
    public short[] m_asNumAFrames;
    short[] m_asFirstAFrameIndices;
    private int[][] m_aaiPaletteData;
    public int m_iNumPalettes;
    private int m_iCurPal;
    private boolean m_hasTransparentColor;
    private short m_sDataFormat;
    int _i64rle_color_mask;
    int _i64rle_color_bits;
    private byte[][] m_aabModuleData;
    Image[][] m_imgModules;
    int[] m_aiTextEndingPos = new int[2];
    boolean m_bWiseModule = true;
    boolean m_bFontNum;
    int m_iHSpacing;
    private static final int MAX_LINES = 80;
    static int[] CACHE_STR_W = new int[80];
    static String[] CACHE_STR = new String[80];
    public static int s_iStringWidth;
    public static int s_iStringHeight;
    public static int s_iNumLines;
    public int m_iLineHeight;
    public static byte[] s_abCharMap;
    static final char k_cBeginTile = '[';
    static final char k_cSignTile = 'T';
    static final String k_sSignTile = "[T";
    static int len;
    static int textW;
    static int mark;
    static int pos;
    static final int k_numSpacePerTab = 3;
    static final int k_TabNone = -1;
    static final int k_TabSingle = 0;
    static final int k_TabDouble = 1;
    static final String k_TabSign = "-+";
    static final String k_TabSingleReplace = "   ";
    static int m_iTab;
    public boolean m_bUseTab = false;
    static final int k_MaxLineInPage = 40;
    static final int k_ReachStickTileId = 90;
    static final int k_DealerStickTileId = 91;
    private static int[] m_aiPosY;
    private static boolean isDrawTile;
    private static boolean isCheckedLine;
    private static int tile;
    private static int iLine;
    private static int iLength;
    private static int iDrawTile_OffY;
    private static int m_iLimitUp;
    private static int m_iLimitDown;

    private static final short ReadShort(byte[] data, int offset) {
        return (short)((data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8));
    }

    public CSprite() {
        this.ResetLimitDrawString();
    }

    public void Load(byte[] data, int offset) {
        try {
            int i;
            offset += 2;
            int bsFlags = (data[offset++] & 0xFF) + ((data[offset++] & 0xFF) << 8) + ((data[offset++] & 0xFF) << 16) + ((data[offset++] & 0xFF) << 24);
            int numModules = CSprite.ReadShort(data, offset);
            offset += 2;
            if (numModules > 0) {
                this.m_asModuleWidth = new short[numModules];
                this.m_asModuleHeight = new short[numModules];
                for (i = 0; i < numModules; ++i) {
                    this.m_asModuleWidth[i] = (short)(data[offset++] & 0xFF);
                    this.m_asModuleHeight[i] = (short)(data[offset++] & 0xFF);
                }
            }
            short numFModules = CSprite.ReadShort(data, offset);
            offset += 2;
            if (numFModules > 0) {
                this.m_asModuleIndices = new short[numFModules];
                this.m_asFModuleOfsX = new short[numFModules];
                this.m_asFModuleOfsY = new short[numFModules];
                this.m_abFModuleFlags = new byte[numFModules];
                for (i = 0; i < numFModules; ++i) {
                    this.m_asModuleIndices[i] = (short)(data[offset++] & 0xFF);
                    if ((bsFlags & 0x400) != 0) {
                        this.m_asFModuleOfsX[i] = CSprite.ReadShort(data, offset);
                        this.m_asFModuleOfsY[i] = CSprite.ReadShort(data, offset += 2);
                        offset += 2;
                    } else {
                        this.m_asFModuleOfsX[i] = data[offset++];
                        this.m_asFModuleOfsY[i] = data[offset++];
                    }
                    this.m_abFModuleFlags[i] = data[offset++];
                }
            }
            short numFrames = CSprite.ReadShort(data, offset);
            offset += 2;
            if (numFrames > 0) {
                this.m_asNumFModules = new short[numFrames];
                this.m_abFrameRectX = new byte[numFrames];
                this.m_abFrameRectY = new byte[numFrames];
                this.m_asFrameRectW = new short[numFrames];
                this.m_asFrameRectH = new short[numFrames];
                this.m_asFirstFModuleIndices = new short[numFrames];
                for (i = 0; i < numFrames; ++i) {
                    this.m_asNumFModules[i] = CSprite.ReadShort(data, offset);
                    this.m_asFirstFModuleIndices[i] = CSprite.ReadShort(data, offset += 2);
                    offset += 2;
                }
                for (i = 0; i < numFrames; ++i) {
                    this.m_abFrameRectX[i] = data[offset++];
                    this.m_abFrameRectY[i] = data[offset++];
                    this.m_asFrameRectW[i] = (short)(data[offset++] & 0xFF);
                    this.m_asFrameRectH[i] = (short)(data[offset++] & 0xFF);
                }
            }
            short numAFrames = CSprite.ReadShort(data, offset);
            offset += 2;
            if (numAFrames > 0) {
                this.m_asFrameIndices = new short[numAFrames];
                this.m_abAFrameTime = new byte[numAFrames];
                this.m_abAFrameOfsX = new byte[numAFrames];
                this.m_abAFrameOfsY = new byte[numAFrames];
                this.m_abAFrameFlags = new byte[numAFrames];
                for (i = 0; i < numAFrames; ++i) {
                    this.m_asFrameIndices[i] = (short)(data[offset++] & 0xFF);
                    this.m_abAFrameTime[i] = data[offset++];
                    this.m_abAFrameOfsX[i] = data[offset++];
                    this.m_abAFrameOfsY[i] = data[offset++];
                    this.m_abAFrameFlags[i] = data[offset++];
                }
            }
            short numAnims = CSprite.ReadShort(data, offset);
            offset += 2;
            if (numAnims > 0) {
                this.m_asNumAFrames = new short[numAnims];
                this.m_asFirstAFrameIndices = new short[numAnims];
                for (i = 0; i < numAnims; ++i) {
                    this.m_asNumAFrames[i] = CSprite.ReadShort(data, offset);
                    this.m_asFirstAFrameIndices[i] = CSprite.ReadShort(data, offset += 2);
                    offset += 2;
                }
            }
            short pixelFormat = CSprite.ReadShort(data, offset);
            offset += 2;
            this.m_iNumPalettes = data[offset++] & 0xFF;
            int numColors = data[offset++] & 0xFF;
            this.m_iCurPal = 0;
            this.m_aaiPaletteData = new int[this.m_iNumPalettes][];
            this.m_hasTransparentColor = false;
            if (numColors == 0) {
                numColors = 256;
            }
            block12: for (i = 0; i < this.m_iNumPalettes; ++i) {
                this.m_aaiPaletteData[i] = new int[numColors];
                switch (pixelFormat) {
                    case -30584: {
                        int color;
                        int c;
                        for (c = 0; c < numColors; ++c) {
                            if (((color = (data[offset++] & 0xFF) + ((data[offset++] & 0xFF) << 8) + ((data[offset++] & 0xFF) << 16) + ((data[offset++] & 0xFF) << 24)) & 0xFF000000) != -16777216) {
                                this.m_hasTransparentColor = true;
                            }
                            this.m_aaiPaletteData[i][c] = color;
                        }
                        continue block12;
                    }
                    case 17476: {
                        int color;
                        int c;
                        for (c = 0; c < numColors; ++c) {
                            if (((color = (data[offset++] & 0xFF) + ((data[offset++] & 0xFF) << 8)) & 0xF000) != 61440) {
                                this.m_hasTransparentColor = true;
                            }
                            this.m_aaiPaletteData[i][c] = (color & 0xF000) << 16 | (color & 0xF000) << 12 | (color & 0xF00) << 12 | (color & 0xF00) << 8 | (color & 0xF0) << 8 | (color & 0xF0) << 4 | (color & 0xF) << 4 | color & 0xF;
                        }
                        continue block12;
                    }
                }
            }
            this.m_sDataFormat = CSprite.ReadShort(data, offset);
            offset += 2;
            if (this.m_sDataFormat == 25840) {
                int clrs = numColors - 1;
                this._i64rle_color_mask = 1;
                this._i64rle_color_bits = 0;
                while (clrs != 0) {
                    clrs >>= 1;
                    this._i64rle_color_mask <<= 1;
                    ++this._i64rle_color_bits;
                }
                --this._i64rle_color_mask;
            }
            this.m_aabModuleData = new byte[numModules][];
            for (i = 0; i < numModules; ++i) {
                short moduleSize = CSprite.ReadShort(data, offset);
                this.m_aabModuleData[i] = new byte[moduleSize];
                System.arraycopy(data, offset += 2, this.m_aabModuleData[i], 0, moduleSize);
                offset += moduleSize;
            }
            this.ResetLineHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void BuildCacheImages(int pal, int moduleID1, int moduleID2) {
        this.BuildCacheImages(pal, moduleID1, moduleID2, 0);
    }

    private void BuildCacheImages(int pal, int moduleID1, int moduleID2, int flags) {
        if (moduleID1 < 0) {
            moduleID1 = 0;
        }
        if (moduleID2 < 0) {
            moduleID2 = this.m_asModuleWidth.length - 1;
        }
        if (this.m_imgModules == null) {
            this.m_imgModules = new Image[this.m_iNumPalettes][];
        }
        if (this.m_imgModules[pal] == null) {
            this.m_imgModules[pal] = new Image[this.m_asModuleWidth.length];
        }
        for (int i = moduleID1; i <= moduleID2; ++i) {
            if (this.m_imgModules[pal][i] != null || this.m_asModuleWidth[i] <= 0 || this.m_asModuleHeight[i] <= 0) continue;
            this.m_imgModules[pal][i] = (flags & 4) != 0 ? Image.createRGBImage((int[])this.DecodeImage(i, pal, flags), (int)this.m_asModuleHeight[i], (int)this.m_asModuleWidth[i], (boolean)this.m_hasTransparentColor) : Image.createRGBImage((int[])this.DecodeImage(i, pal, flags), (int)this.m_asModuleWidth[i], (int)this.m_asModuleHeight[i], (boolean)this.m_hasTransparentColor);
        }
    }

    public void FreeModuleData() {
        this.m_aaiPaletteData = null;
        this.m_aabModuleData = null;
    }

    public void FreeCacheImages() {
        this.m_imgModules = null;
    }

    public void FreeModuleImage(int moduleId) {
        this.m_imgModules[this.m_iCurPal][moduleId] = null;
    }

    private int[] DecodeImage(int moduleID, int palID, int flags) {
        int[] imgData = m_iTmpBuffer;
        int[] pal = this.m_aaiPaletteData[palID];
        byte[] image = this.m_aabModuleData[moduleID];
        int si = 0;
        int di = 0;
        int ds = this.m_asModuleWidth[moduleID] * this.m_asModuleHeight[moduleID];
        switch (this.m_sDataFormat) {
            case 10225: {
                int clr;
                int c;
                while (di < ds) {
                    if ((c = image[si++] & 0xFF) > 127) {
                        int c2 = image[si++] & 0xFF;
                        clr = pal[c2];
                        c -= 128;
                        while (c-- > 0) {
                            imgData[di++] = clr;
                        }
                        continue;
                    }
                    imgData[di++] = pal[c];
                }
                break;
            }
            case 5632: {
                while (di < ds) {
                    imgData[di++] = pal[image[si] >> 4 & 0xF];
                    imgData[di++] = pal[image[si] & 0xF];
                    ++si;
                }
                break;
            }
            case 1024: {
                while (di < ds) {
                    imgData[di++] = pal[image[si] >> 6 & 3];
                    imgData[di++] = pal[image[si] >> 4 & 3];
                    imgData[di++] = pal[image[si] >> 2 & 3];
                    imgData[di++] = pal[image[si] & 3];
                    ++si;
                }
                break;
            }
            case 512: {
                while (di < ds) {
                    imgData[di++] = pal[image[si] >> 7 & 1];
                    imgData[di++] = pal[image[si] >> 6 & 1];
                    imgData[di++] = pal[image[si] >> 5 & 1];
                    imgData[di++] = pal[image[si] >> 4 & 1];
                    imgData[di++] = pal[image[si] >> 3 & 1];
                    imgData[di++] = pal[image[si] >> 2 & 1];
                    imgData[di++] = pal[image[si] >> 1 & 1];
                    imgData[di++] = pal[image[si] & 1];
                    ++si;
                }
                break;
            }
            case 22018: {
                while (di < ds) {
                    imgData[di++] = pal[image[si++] & 0xFF];
                }
                break;
            }
            case 22258: {
                int clr;
                int c;
                while (di < ds) {
                    if ((c = image[si++] & 0xFF) > 127) {
                        c -= 128;
                        while (c-- > 0) {
                            imgData[di++] = pal[image[si++] & 0xFF];
                        }
                        continue;
                    }
                    clr = pal[image[si++] & 0xFF];
                    while (c-- > 0) {
                        imgData[di++] = clr;
                    }
                }
                break;
            }
            case 25840: {
                int clr;
                int c;
                while (di < ds) {
                    c = image[si++] & 0xFF;
                    clr = pal[c & this._i64rle_color_mask];
                    c >>= this._i64rle_color_bits;
                    while (c-- >= 0) {
                        imgData[di++] = clr;
                    }
                }
                break;
            }
        }
        if (flags != 0) {
            int tmp;
            if (flags == 3) {
                int index1 = 0;
                int index2 = ds - 1;
                int size = ds / 2;
                do {
                    tmp = imgData[index1];
                    imgData[index1] = imgData[index2];
                    imgData[index2] = tmp;
                    --index2;
                } while (++index1 < size);
            }
            if (flags == 4) {
                int[] tmpImgData = new int[ds];
                short height = this.m_asModuleHeight[moduleID];
                int index1 = 0;
                int start = height - 1;
                do {
                    for (int index2 = start; index2 < ds; index2 += height) {
                        tmpImgData[index2] = imgData[index1++];
                    }
                } while (--start >= 0);
                System.arraycopy(tmpImgData, 0, imgData, 0, ds);
            }
            if (flags == 1) {
                tmp = 0;
                short w = this.m_asModuleWidth[moduleID];
                int h = this.m_asModuleHeight[moduleID];
                for (int i = 0; i < h; ++i) {
                    for (int j = 0; j < w / 2; ++j) {
                        tmp = imgData[i * w + j];
                        imgData[i * w + j] = imgData[i * w + w - j - 1];
                        imgData[i * w + w - j - 1] = tmp;
                    }
                }
            }
        }
        return imgData;
    }

    public void PaintAFrame(Graphics g, int animID, int aframeID, int posX, int posY, int flags, int hx, int hy) {
        int index = this.m_asFirstAFrameIndices[animID] + aframeID;
        if ((flags & 0x20) != 0) {
            hx = (flags & 1) != 0 ? (hx += this.m_abAFrameOfsX[index]) : (hx -= this.m_abAFrameOfsX[index]);
            hy = (flags & 2) != 0 ? (hy += this.m_abAFrameOfsY[index]) : (hy -= this.m_abAFrameOfsY[index]);
        }
        this.PaintFrame(g, this.m_asFrameIndices[index], posX - hx, posY - hy, flags ^ this.m_abAFrameFlags[index] & 0xF, hx, hy);
    }

    public void PaintFrame(Graphics g, int frameID, int posX, int posY, int flags, int hx, int hy) {
        int numFModules = this.m_asNumFModules[frameID];
        for (int i = 0; i < numFModules; ++i) {
            this.PaintFModule(g, frameID, i, posX, posY, flags, hx, hy);
        }
    }

    public void PaintFModule(Graphics g, int frameID, int fmoduleID, int posX, int posY, int flags, int hx, int hy) {
        int index = this.m_asFirstFModuleIndices[frameID] + fmoduleID;
        int fmFlags = this.m_abFModuleFlags[index] & 0xFF;
        posX = (flags & 1) != 0 ? (posX -= this.m_asFModuleOfsX[index]) : (posX += this.m_asFModuleOfsX[index]);
        posY = (flags & 2) != 0 ? (posY -= this.m_asFModuleOfsY[index]) : (posY += this.m_asFModuleOfsY[index]);
        if ((fmFlags & 0x10) != 0) {
            this.PaintFrame(g, this.m_asModuleIndices[index], posX, posY, flags ^ fmFlags & 0xF, hx, hy);
        } else {
            short moduleID = this.m_asModuleIndices[index];
            if ((flags & 1) != 0) {
                posX -= this.m_asModuleWidth[moduleID];
            }
            if ((flags & 2) != 0) {
                posY -= this.m_asModuleHeight[moduleID];
            }
            this.PaintModule(g, moduleID, posX, posY, flags ^ fmFlags & 0xF);
        }
    }

    public void PaintModule(Graphics g, int moduleID, int posX, int posY, int flags) {
        short sizeX = this.m_asModuleWidth[moduleID];
        short sizeY = this.m_asModuleHeight[moduleID];
        if (this.m_bWiseModule) {
            if (this.m_imgModules == null) {
                this.m_imgModules = new Image[this.m_iNumPalettes][];
            }
            if (this.m_imgModules[this.m_iCurPal] == null) {
                this.m_imgModules[this.m_iCurPal] = new Image[this.m_asModuleWidth.length];
            }
            if (this.m_imgModules[this.m_iCurPal][moduleID] == null) {
                this.m_imgModules[this.m_iCurPal][moduleID] = (flags & 4) != 0 ? Image.createRGBImage((int[])this.DecodeImage(moduleID, this.m_iCurPal, flags), (int)this.m_asModuleHeight[moduleID], (int)this.m_asModuleWidth[moduleID], (boolean)this.m_hasTransparentColor) : Image.createRGBImage((int[])this.DecodeImage(moduleID, this.m_iCurPal, flags), (int)this.m_asModuleWidth[moduleID], (int)this.m_asModuleHeight[moduleID], (boolean)this.m_hasTransparentColor);
            }
        }
        if (this.m_imgModules != null && this.m_imgModules[this.m_iCurPal] != null && this.m_imgModules[this.m_iCurPal][moduleID] != null) {
            Image img = this.m_imgModules[this.m_iCurPal][moduleID];
            if (flags == 0) {
                g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 0, posX, posY, 0);
            } else if (flags == 4) {
                g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 5, posX, posY, 0);
            } else if (flags == 6) {
                g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 6, posX, posY, 0);
            } else if ((flags & 1) != 0) {
                if ((flags & 2) != 0) {
                    g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 3, posX, posY, 0);
                } else {
                    g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 2, posX, posY, 0);
                }
            } else if ((flags & 2) != 0) {
                g.drawRegion(img, 0, 0, (int)sizeX, (int)sizeY, 1, posX, posY, 0);
            }
        } else {
            if (posY + sizeY < g.getClipY()) {
                return;
            }
            g.drawRGB(this.DecodeImage(moduleID, this.m_iCurPal, flags), 0, (int)sizeX, posX, posY, (int)sizeX, (int)sizeY, this.m_hasTransparentColor);
        }
    }

    public void PaintModule(Graphics g, int moduleID, int posX, int posY, int flags, int anchor) {
        short sizeX = this.m_asModuleWidth[moduleID];
        short sizeY = this.m_asModuleHeight[moduleID];
        if ((anchor & 1) != 0) {
            posX = flags == 4 || flags == 6 ? (posX -= sizeY >> 1) : (posX -= sizeX >> 1);
        }
        if ((anchor & 2) != 0) {
            posY = flags == 4 || flags == 6 ? (posY -= sizeX >> 1) : (posY -= sizeY >> 1);
        }
        if ((anchor & 8) != 0) {
            posX = flags == 4 || flags == 6 ? (posX -= sizeY) : (posX -= sizeX);
        }
        if ((anchor & 0x20) != 0) {
            posY = flags == 4 || flags == 6 ? (posY -= sizeX) : (posY -= sizeY);
        }
        this.PaintModule(g, moduleID, posX, posY, flags);
    }

    public void SetCurrentPalette(int palette) {
        this.m_iCurPal = palette;
    }

    public int GetPalette() {
        return this.m_iCurPal;
    }

    public String GetPaletteString(String s, int pos) {
        if (pos >= s.length()) {
            return "";
        }
        String numbers = "0123456789";
        String strPal = "";
        while (pos < s.length() && numbers.indexOf(s.charAt(pos)) != -1) {
            strPal = strPal + s.charAt(pos);
            ++pos;
        }
        return strPal;
    }

    public int GetPalette(String s, int pos) {
        String strPal = this.GetPaletteString(s, pos);
        if (strPal.length() == 0) {
            return 0;
        }
        return Integer.parseInt(strPal);
    }

    public int GetPaletteLength(String s, int pos) {
        return this.GetPaletteString(s, pos).length();
    }

    public void DrawString(Graphics g, String s, int x, int y, int anchor, int palette) {
        int tmpPalette = this.m_iCurPal;
        this.SetCurrentPalette(palette);
        this.DrawString(g, s, x, y, anchor);
        this.SetCurrentPalette(tmpPalette);
    }

    public void DrawString(Graphics g, String s, int x, int y, int anchor) {
        if (anchor == 0) {
            this.DrawString(g, s, x, y);
        } else {
            this.UpdateStringSize(s, -1, -1, true);
            if ((anchor & 0x20) != 0) {
                y -= s_iStringHeight;
            }
            if ((anchor & 2) != 0) {
                y -= s_iStringHeight >> 1;
            }
            if ((anchor & 8) != 0) {
                for (int i = 0; i < s_iNumLines; ++i) {
                    this.DrawString(g, CACHE_STR[i], x - CACHE_STR_W[i], y);
                    y += this.m_iLineHeight;
                }
            } else if ((anchor & 1) != 0) {
                for (int i = 0; i < s_iNumLines; ++i) {
                    this.DrawString(g, CACHE_STR[i], x - (CACHE_STR_W[i] >> 1), y);
                    y += this.m_iLineHeight;
                }
            } else {
                for (int i = 0; i < s_iNumLines; ++i) {
                    this.DrawString(g, CACHE_STR[i], x, y);
                    y += this.m_iLineHeight;
                }
            }
        }
    }

    public int GetTile(String s, int pos) {
        String numbers = "0123456789";
        String strTile = "";
        while (pos < s.length() && numbers.indexOf(s.charAt(pos)) != -1) {
            strTile = strTile + s.charAt(pos);
            ++pos;
        }
        return Integer.parseInt(strTile);
    }

    private int InsertTab(StringBuffer sb, int iTab, int posTab) {
        if (iTab == 1) {
            if (k_TabSign.indexOf(sb.charAt(posTab)) != -1) {
                sb.deleteCharAt(posTab);
                sb.insert(posTab, k_TabSingleReplace);
                sb.insert(posTab, k_TabSign.charAt(1));
                sb.insert(posTab, k_TabSingleReplace);
            } else {
                sb.insert(posTab + 1, k_TabSingleReplace);
                sb.insert(posTab + 1, k_TabSingleReplace);
            }
            len += k_TabSingleReplace.length() * 2;
            return k_TabSingleReplace.length();
        }
        sb.insert(posTab + 1, k_TabSingleReplace);
        len += k_TabSingleReplace.length();
        return 0;
    }

    public void UseTab(boolean useTab) {
        this.m_bUseTab = useTab;
        m_iTab = -1;
    }

    public String FixStringWidth(String s, int width) {
        StringBuffer sb = new StringBuffer(s);
        len = sb.length();
        textW = 0;
        mark = -1;
        int lastWidth = 0;
        int curPal = -1;
        boolean hasIndent = false;
        for (pos = 0; pos < len; ++pos) {
            int c = sb.charAt(pos);
            if (this.m_bUseTab && k_TabSign.indexOf(sb.charAt(pos)) != -1 && (pos <= 0 || sb.charAt(pos - 1) == '\n')) {
                m_iTab = k_TabSign.indexOf(c);
                int iSpaces = this.InsertTab(sb, m_iTab, pos);
                pos += iSpaces;
                textW += (this.m_asModuleWidth[0] + this.m_asFModuleOfsX[0]) * iSpaces;
            }
            if (c == 46 && (pos == 0 || sb.charAt(pos - 1) == '\n')) {
                hasIndent = true;
                sb = sb.insert(pos + 1, " ");
                ++len;
            }
            if (c == 94) {
                pos += (curPal = this.GetPalette(sb.toString(), ++pos)) < 10 ? 0 : 1;
                continue;
            }
            if (c <= 32) {
                if (c == 32) {
                    if (textW >= width && mark > 0) {
                        lastWidth = textW -= lastWidth;
                        this.InsertLineBreak(sb, curPal, hasIndent);
                        if (this.m_bUseTab && m_iTab != -1) {
                            this.InsertTab(sb, m_iTab, mark);
                        }
                    } else {
                        lastWidth = textW;
                        textW += this.m_asModuleWidth[0] + this.m_asFModuleOfsX[0];
                    }
                    mark = pos;
                    continue;
                }
                if (c != 10) continue;
                if (textW >= width && mark > 0) {
                    this.InsertLineBreak(sb, curPal, hasIndent);
                    if (this.m_bUseTab && m_iTab != -1) {
                        this.InsertTab(sb, m_iTab, mark);
                    }
                }
                m_iTab = -1;
                textW = 0;
                mark = -1;
                hasIndent = false;
                curPal = -1;
                continue;
            }
            c = s_abCharMap[c] & 0xFF;
            short moduleID = this.m_asModuleIndices[c];
            textW += this.m_asModuleWidth[moduleID] - this.m_asFModuleOfsX[moduleID] + this.m_asFModuleOfsX[0];
        }
        if (textW > width && mark > 0) {
            this.InsertLineBreak(sb, curPal, hasIndent);
        }
        return new String(sb);
    }

    private void InsertLineBreak(StringBuffer sb, int curPal, boolean hasIndent) {
        sb.setCharAt(mark, '\n');
        if (curPal != -1) {
            if ("0123456789".indexOf(sb.charAt(mark + 1) + "") != -1) {
                sb.insert(mark + 1, "^" + String.valueOf(curPal) + " ");
                pos += 3;
                len += 3;
                mark += 3;
            } else {
                sb.insert(mark + 1, "^" + String.valueOf(curPal));
                pos += 2;
                len += 2;
                mark += 2;
            }
        }
        if (hasIndent) {
            sb = sb.insert(mark + 1, "  ");
            len += 2;
            pos += 2;
            textW += 2 * (this.m_asModuleWidth[0] + this.m_asFModuleOfsX[0]);
        }
    }

    public void ResetLineHeight() {
        this.m_iLineHeight = this.m_asModuleHeight[0];
    }

    public void UpdateStringSize(String s, int fromIndex, int toIndex) {
        this.UpdateStringSize(s, fromIndex, toIndex, false);
    }

    void SetLimitDrawString(int up, int down) {
        m_iLimitUp = up;
        m_iLimitDown = down;
    }

    void ResetLimitDrawString() {
        m_iLimitUp = 0;
        m_iLimitDown = 220;
    }

    private void DrawString(Graphics g, String s, int x, int y) {
        int c;
        int i;
        int pal = this.m_iCurPal;
        int xx = x;
        int yy = y -= this.m_asFModuleOfsY[0];
        int index1 = 0;
        int index2 = s.length();
        iDrawTile_OffY = this.m_iLineHeight + 4 >> 1;
        isDrawTile = false;
        isCheckedLine = false;
        iLine = 0;
        iLength = s.length();
        for (i = 0; i < 40; ++i) {
            CSprite.m_aiPosY[i] = 0;
        }
        if (s.indexOf(k_sSignTile) != -1) {
            isDrawTile = true;
            for (i = 0; i < iLength; ++i) {
                c = s.charAt(i);
                if (c == 10) {
                    ++iLine;
                    isCheckedLine = false;
                    continue;
                }
                if (isCheckedLine || c != 91 || i + 1 >= iLength || s.charAt(i + 1) != 'T') continue;
                isCheckedLine = true;
                int n = iLine;
                m_aiPosY[n] = m_aiPosY[n] + iDrawTile_OffY;
                int n2 = iLine + 1;
                m_aiPosY[n2] = m_aiPosY[n2] + iDrawTile_OffY;
            }
        }
        yy += m_aiPosY[0];
        iLine = 1;
        for (i = index1; i < index2; ++i) {
            c = s.charAt(i);
            if (yy < m_iLimitUp && c != 10) continue;
            if (yy > m_iLimitDown) break;
            if (c == 94) {
                this.m_iCurPal = this.GetPalette(s, ++i);
                i += this.m_iCurPal < 10 ? 0 : 1;
                continue;
            }
            if (c <= 32) {
                if (c == 32) {
                    xx += this.m_asModuleWidth[0] + this.m_asFModuleOfsX[0];
                    continue;
                }
                if (c != 10) continue;
                xx = x;
                if (isDrawTile) {
                    yy += m_aiPosY[iLine];
                    ++iLine;
                }
                yy += this.m_iLineHeight;
                continue;
            }
            c = s_abCharMap[c] & 0xFF;
            short moduleID = this.m_asModuleIndices[c];
            this.PaintFModule(g, 0, c, xx, yy, 0, 0, 0);
            if (this.m_bUseTab && k_TabSign.indexOf(s.charAt(i)) != -1) {
                if (i <= 0 || s.charAt(i - 1) == '\n' || s.charAt(i + 1) == ' ') continue;
                xx += this.m_asModuleWidth[moduleID] - this.m_asFModuleOfsX[moduleID] + this.m_asFModuleOfsX[0] + this.m_iHSpacing;
                continue;
            }
            xx += this.m_asModuleWidth[moduleID] - this.m_asFModuleOfsX[moduleID] + this.m_asFModuleOfsX[0] + this.m_iHSpacing;
        }
        this.m_iCurPal = pal;
        this.m_aiTextEndingPos[0] = xx;
        this.m_aiTextEndingPos[1] = yy;
        if (isDrawTile) {
            this.m_aiTextEndingPos[1] = this.m_aiTextEndingPos[1] + m_aiPosY[iLine];
        }
    }

    private void UpdateStringSize(String s, int fromIndex, int toIndex, boolean cacheString) {
        int i;
        s_iNumLines = 0;
        s_iStringWidth = 0;
        s_iStringHeight = this.m_iLineHeight;
        fromIndex = fromIndex >= 0 ? fromIndex : 0;
        toIndex = toIndex >= 0 ? toIndex : s.length() - 1;
        int pos = fromIndex;
        int textW = 0;
        for (i = fromIndex; i <= toIndex; ++i) {
            int c = s.charAt(i);
            if (c == 94) {
                i += this.GetPaletteLength(s, i + 1);
                continue;
            }
            if (c <= 32) {
                if (c == 32) {
                    textW += this.m_asModuleWidth[0] + this.m_asFModuleOfsX[0];
                    continue;
                }
                if (c != 10) continue;
                if (cacheString) {
                    CSprite.CACHE_STR[CSprite.s_iNumLines] = i - pos >= 0 ? s.substring(pos, i) : "";
                    CSprite.CACHE_STR_W[CSprite.s_iNumLines] = textW;
                    pos = i + 1;
                }
                ++s_iNumLines;
                if (s_iStringWidth < textW) {
                    s_iStringWidth = textW;
                }
                s_iStringHeight += this.m_iLineHeight;
                textW = 0;
                continue;
            }
            c = s_abCharMap[c] & 0xFF;
            short moduleID = this.m_asModuleIndices[c];
            textW += this.m_asModuleWidth[moduleID] - this.m_asFModuleOfsX[moduleID] + this.m_asFModuleOfsX[0] + this.m_iHSpacing;
        }
        if (cacheString && pos <= i) {
            CSprite.CACHE_STR[CSprite.s_iNumLines] = s.substring(pos, i);
            CSprite.CACHE_STR_W[CSprite.s_iNumLines] = textW;
        }
        ++s_iNumLines;
        if (s_iStringWidth < textW) {
            s_iStringWidth = textW;
        }
        if (s_iStringWidth > 0) {
            s_iStringWidth -= this.m_asFModuleOfsX[0];
        }
    }

    static {
        m_aiPosY = new int[40];
        isDrawTile = false;
        isCheckedLine = false;
    }
}

