/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ASprite {
    static Graphics _g;
    boolean _cacheUsedModules = false;
    int _last_Frame = -1;
    public int _current_frame = 0;
    int[] _lastFrameRect = new int[]{0, 0, 0, 0};
    int newSizeX = 0;
    int newSizeY = 0;
    static final int MAX_SPRITE_PALETTES = 16;
    static final int MAX_MODULE_MAPPINGS = 16;
    static final int MAX_FLIP_COUNT = 8;
    static final int TMP_BUFFER_SIZE = 20480;
    static final int PNG_BUFFER_SIZE = 20480;
    static final short BSPRITE_v003 = 991;
    static final int BS_MODULES = 1;
    static final int BS_MODULES_XY = 2;
    static final int BS_MODULES_IMG = 4;
    static final int BS_MODULES_WH_SHORT = 16;
    static final int BS_MODULES_XY_SHORT = 32;
    static final int BS_FRAMES = 256;
    static final int BS_FM_OFF_SHORT = 1024;
    static final int BS_NFM_1_BYTE = 2048;
    static final int BS_SKIP_FRAME_RC = 4096;
    static final int BS_FRAME_COLL_RC = 8192;
    static final int BS_FM_PALETTE = 16384;
    static final int BS_ANIMS = 65536;
    static final int BS_AF_OFF_SHORT = 262144;
    static final int BS_NAF_1_BYTE = 524288;
    static final int BS_MODULE_IMAGES = 0x1000000;
    static final int BS_PNG_CRC = 0x2000000;
    static final int BS_KEEP_PAL = 0x4000000;
    static final int BS_TRANSP_FIRST = 0x8000000;
    static final int BS_TRANSP_LAST = 0x10000000;
    static final int BS_SINGLE_IMAGE = 0x20000000;
    static final int BS_MODULE_USAGE = 0x40000000;
    static final int BS_DEFAULT_DOJA = 65793;
    static final int BS_DEFAULT_MIDP2 = 0x1010101;
    static final int BS_DEFAULT_NOKIA = 0x1010101;
    static final int BS_DEFAULT_MIDP1 = 65795;
    static final int BS_DEFAULT_MIDP1b = 0x3010101;
    static final int BS_DEFAULT_MIDP1c = 536936707;
    static final short PIXEL_FORMAT_8888 = -30584;
    static final short PIXEL_FORMAT_4444 = 17476;
    static final short PIXEL_FORMAT_1555 = 21781;
    static final short PIXEL_FORMAT_0565 = 25861;
    static final short ENCODE_FORMAT_I2 = 512;
    static final short ENCODE_FORMAT_I4 = 1024;
    static final short ENCODE_FORMAT_I16 = 5632;
    static final short ENCODE_FORMAT_I256 = 22018;
    static final short ENCODE_FORMAT_I64RLE = 25840;
    static final short ENCODE_FORMAT_I127RLE = 10225;
    static final short ENCODE_FORMAT_I256RLE = 22258;
    static final byte FLAG_FLIP_X = 1;
    static final byte FLAG_FLIP_Y = 2;
    static final byte FLAG_ROT_90 = 4;
    static final byte FLAG_USER0 = 16;
    static final byte FLAG_USER1 = 32;
    static final byte FLAG_HYPER_FM = 16;
    static final int FLAG_INDEX_EX_MASK = 192;
    static final int INDEX_MASK = 1023;
    static final int INDEX_EX_MASK = 768;
    static final int INDEX_EX_SHIFT = 2;
    static final byte FLAG_OFFSET_FM = 16;
    static final byte FLAG_OFFSET_AF = 32;
    static final int[] midp2_flags;
    static int _text_w;
    static int _text_h;
    static byte[] _map_char;
    private int _line_spacing = 0;
    static short[] _sizes;
    static int _index1;
    static int _index2;
    int _old_pal;
    static int[] temp;
    int _nModules;
    byte[] _modules_x;
    byte[] _modules_y;
    byte[] _modules_w;
    byte[] _modules_h;
    byte[] _frames_nfm;
    short[] _frames_fm_start;
    byte[] _frames_rc;
    byte[] _frames_col;
    byte[] _fmodules;
    byte[] _anims_naf;
    short[] _anims_af_start;
    byte[] _aframes;
    int[][] _map;
    private int _cur_map;
    int _bs_flags;
    int[][] _pal;
    byte[][] _transp;
    byte[] _pal_data;
    int _palettes;
    int _colors;
    private int _crt_pal;
    boolean _alpha;
    short _data_format;
    int _i64rle_color_mask;
    int _i64rle_color_bits;
    byte[] _modules_data;
    int[] _modules_data_off;
    Image[][] _modules_image;
    Image[] _main_image;
    int[] _PNG_packed_PLTE_CRC;
    int[] _PNG_packed_tRNS_CRC;
    int[] _PNG_packed_IHDR_CRC;
    int[] _PNG_packed_IDAT_ADLER;
    int[] _PNG_packed_IDAT_CRC;
    static int _images_count;
    static int _images_size;
    static final boolean DEBUG_bDbgS = false;
    static final boolean DEBUG_bErr = false;
    static final boolean DEBUG_bDbgVM = false;
    static final boolean DEBUG_bDbgO = false;
    static final boolean DEBUG_bEmu = false;
    static final boolean DEBUG_bDbgI = false;
    static final boolean DEBUG_bDbgModuleUsage = false;

    void initCacheUsedModules() {
        this._cacheUsedModules = true;
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
            for (int i = 0; i < this._palettes; ++i) {
                this._modules_image[i] = new Image[this._nModules];
                for (int j = 0; j < this._nModules; ++j) {
                    this._modules_image[i][j] = null;
                }
            }
        }
    }

    void unloadCachedModules() {
        if (this._modules_image != null) {
            for (int i = 0; i < this._palettes; ++i) {
                if (this._modules_image[i] == null) continue;
                for (int j = 0; j < this._nModules; ++j) {
                    this._modules_image[i][j] = null;
                }
            }
        }
    }

    int getWidthASprite() {
        if (this._last_Frame != this._current_frame) {
            this._last_Frame = this._current_frame;
            this.GetFrameRect(this._lastFrameRect, this._current_frame, 0, 0, 0, 0, 0);
        }
        return this._lastFrameRect[2] >> 8;
    }

    int getHeightASprite() {
        if (this._last_Frame != this._current_frame) {
            this._last_Frame = this._current_frame;
            this.GetFrameRect(this._lastFrameRect, this._current_frame, 0, 0, 0, 0, 0);
        }
        return this._lastFrameRect[3] >> 8;
    }

    void printSprite(Graphics g, int pal, int x, int y, byte[] str, int align) {
        int anchor = 4;
        anchor &= 0xFFFFFFFD;
        switch (align) {
            case 2: {
                anchor = 1;
                break;
            }
            case 0: {
                anchor = 4;
                break;
            }
            case 1: {
                anchor = 8;
                break;
            }
            case 3: {
                anchor = 3;
            }
        }
        this.SetCurrentPalette(pal);
        this.DrawString(g, str, x, y, anchor);
    }

    public byte[] ScaleImage(int module, int factor1, int factor2) {
        if (this._modules_data == null || this._modules_data_off == null) {
            return null;
        }
        int sizeX = this._modules_w[module] & 0xFF;
        int sizeY = this._modules_h[module] & 0xFF;
        byte[] image = this._modules_data;
        int si = this._modules_data_off[module];
        this.newSizeX = factor1 * sizeX / factor2;
        this.newSizeY = factor1 * sizeY / factor2;
        boolean di = false;
        int ds = this.newSizeX * this.newSizeY;
        int i = 0;
        int j = 0;
        try {
            for (i = 0; i < this.newSizeY; ++i) {
                int i0 = i * sizeY / this.newSizeY * sizeX;
                int i1 = i * this.newSizeX;
                for (j = 0; j < this.newSizeX; ++j) {
                    cGame.buf_img_data[j + i1] = image[si + j * sizeX / this.newSizeX + i0];
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cGame.buf_img_data;
    }

    void PaintImage(Graphics g, byte[] img, int posX, int posY, int sizeX, int sizeY) {
        if (sizeX <= 0 || sizeY <= 0) {
            return;
        }
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int[] img_data = temp;
        int[] pal = this._pal[this._crt_pal];
        byte[] image = img;
        int si = 0;
        int di = 0;
        int ds = sizeX * sizeY;
        while (di < ds) {
            img_data[di++] = pal[img[si++] & 0xFF];
        }
        g.drawRGB(img_data, 0, sizeX, posX, posY, sizeX, sizeY, this._alpha);
    }

    static void DrawLine(Graphics g, int x1, int y1, int x2, int y2, int color, int radius, int initial) {
        int ix = 0;
        int iy = 0;
        int old_color = g.getColor();
        g.setColor(color);
        int currX = x1;
        int currY = y1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx >= 0) {
            ix = 1;
        }
        if (dx < 0) {
            ix = -1;
            dx = Math.abs(dx);
        }
        if (dy >= 0) {
            iy = 1;
        }
        if (dy < 0) {
            iy = -1;
            dy = Math.abs(dy);
        }
        int dx2 = dx * 2;
        int dy2 = dy * 2;
        int dist = 0;
        int maxdist = (5 - initial) * radius;
        if (dx > dy) {
            int err = dy2 - dx;
            for (int i = 0; i <= dx; ++i) {
                if (dist == maxdist) {
                    g.fillRoundRect(currX - radius, currY - radius, radius * 2, radius * 2, 30, 30);
                }
                if ((dist += ix * ix + iy * iy) > 6 * radius) {
                    dist = 0;
                }
                if (err >= 0) {
                    err -= dx2;
                    currY += iy;
                }
                err += dy2;
                currX += ix;
            }
        } else {
            int err = dx2 - dy;
            for (int i = 0; i <= dy; ++i) {
                if (dist == maxdist) {
                    g.fillRoundRect(currX - radius, currY - radius, radius * 2, radius * 2, 30, 30);
                }
                if ((dist += ix * ix + iy * iy) > 6 * radius) {
                    dist = 0;
                }
                if (err >= 0) {
                    err -= dy2;
                    currX += ix;
                }
                err += dx2;
                currY += iy;
            }
        }
        g.setColor(old_color);
    }

    void Load(byte[] file, int offset) {
        try {
            int nAnims;
            int nAFrames;
            int nFrames;
            int nFModules;
            System.gc();
            short bs_version = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            this._bs_flags = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24);
            this._nModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
            if (this._nModules > 0) {
                this._modules_w = new byte[this._nModules];
                this._modules_h = new byte[this._nModules];
                for (int i = 0; i < this._nModules; ++i) {
                    this._modules_w[i] = file[offset++];
                    this._modules_h[i] = file[offset++];
                }
            }
            if ((nFModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._fmodules = new byte[nFModules * 6];
                System.arraycopy(file, offset, this._fmodules, 0, this._fmodules.length);
                offset += this._fmodules.length;
            }
            if ((nFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._frames_nfm = new byte[nFrames];
                this._frames_fm_start = new short[nFrames];
                short frame_start = 0;
                for (int i = 0; i < nFrames; ++i) {
                    this._frames_nfm[i] = file[offset++];
                    this._frames_fm_start[i] = frame_start;
                    frame_start = (short)(frame_start + (this._frames_nfm[i] & 0xFF));
                }
            }
            if ((nAFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._aframes = new byte[nAFrames * 5];
                System.arraycopy(file, offset, this._aframes, 0, this._aframes.length);
                offset += this._aframes.length;
            }
            if ((nAnims = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._anims_naf = new byte[nAnims];
                this._anims_af_start = new short[nAnims];
                short af_start = 0;
                for (int i = 0; i < nAnims; ++i) {
                    this._anims_naf[i] = file[offset++];
                    this._anims_af_start[i] = af_start;
                    af_start = (short)(af_start + this._anims_naf[i]);
                }
            }
            if (this._nModules <= 0) {
                System.gc();
                return;
            }
            if ((this._bs_flags & 0x1000000) != 0) {
                short _pixel_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
                this._palettes = file[offset++] & 0xFF;
                this._colors = file[offset++] & 0xFF;
                if (this._colors == 0) {
                    this._colors = 256;
                }
                this._pal = new int[16][];
                for (int p = 0; p < this._palettes; ++p) {
                    int a;
                    int c;
                    this._pal[p] = new int[this._colors];
                    if (_pixel_format == -30584) {
                        for (c = 0; c < this._colors; ++c) {
                            int _8888 = file[offset++] & 0xFF;
                            _8888 += (file[offset++] & 0xFF) << 8;
                            _8888 += (file[offset++] & 0xFF) << 16;
                            if (((_8888 += (file[offset++] & 0xFF) << 24) & 0xFF000000) != -16777216) {
                                this._alpha = true;
                            }
                            this._pal[p][c] = _8888;
                        }
                        continue;
                    }
                    if (_pixel_format == 17476) {
                        for (c = 0; c < this._colors; ++c) {
                            int _4444 = file[offset++] & 0xFF;
                            if (((_4444 += (file[offset++] & 0xFF) << 8) & 0xF000) != 61440) {
                                this._alpha = true;
                            }
                            this._pal[p][c] = (_4444 & 0xF000) << 16 | (_4444 & 0xF000) << 12 | (_4444 & 0xF00) << 12 | (_4444 & 0xF00) << 8 | (_4444 & 0xF0) << 8 | (_4444 & 0xF0) << 4 | (_4444 & 0xF) << 4 | _4444 & 0xF;
                        }
                        continue;
                    }
                    if (_pixel_format == 21781) {
                        for (c = 0; c < this._colors; ++c) {
                            int _1555 = file[offset++] & 0xFF;
                            int n = offset++;
                            a = -16777216;
                            if (((_1555 += (file[n] & 0xFF) << 8) & 0x8000) != 32768) {
                                a = 0;
                                this._alpha = true;
                            }
                            this._pal[p][c] = a | (_1555 & 0x7C00) << 9 | (_1555 & 0x3E0) << 6 | (_1555 & 0x1F) << 3;
                        }
                        continue;
                    }
                    if (_pixel_format != 25861) continue;
                    for (c = 0; c < this._colors; ++c) {
                        int _0565 = file[offset++] & 0xFF;
                        int n = offset++;
                        a = -16777216;
                        if ((_0565 += (file[n] & 0xFF) << 8) == 63519) {
                            a = 0;
                            this._alpha = true;
                        }
                        this._pal[p][c] = a | (_0565 & 0xF800) << 8 | (_0565 & 0x7E0) << 5 | (_0565 & 0x1F) << 3;
                    }
                }
                this._data_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
                if (this._data_format == 25840) {
                    int clrs = this._colors - 1;
                    this._i64rle_color_mask = 1;
                    this._i64rle_color_bits = 0;
                    while (clrs != 0) {
                        clrs >>= 1;
                        this._i64rle_color_mask <<= 1;
                        ++this._i64rle_color_bits;
                    }
                    --this._i64rle_color_mask;
                }
                if (this._nModules > 0) {
                    int size;
                    int m;
                    this._modules_data_off = new int[this._nModules];
                    int len = 0;
                    int off = offset;
                    for (m = 0; m < this._nModules; ++m) {
                        size = (file[off++] & 0xFF) + ((file[off++] & 0xFF) << 8);
                        this._modules_data_off[m] = len;
                        off += size;
                        len += size;
                    }
                    this._modules_data = new byte[len];
                    for (m = 0; m < this._nModules; ++m) {
                        size = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
                        System.arraycopy(file, offset, this._modules_data, this._modules_data_off[m], size);
                        offset += size;
                    }
                }
            }
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void BuildCacheImages(int pal, int m1, int m2, int pal_copy, boolean eraseModuleData) {
        if (this._nModules == 0) {
            return;
        }
        if (m2 == -1) {
            m2 = this._nModules - 1;
        }
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        if ((this._bs_flags & 0x1000000) != 0) {
            if (this._modules_image[pal] == null) {
                this._modules_image[pal] = new Image[this._nModules];
            }
            if (pal_copy >= 0) {
                for (int i = m1; i <= m2; ++i) {
                    this._modules_image[pal][i] = this._modules_image[pal_copy][i];
                }
            } else {
                int old_pal = this._crt_pal;
                this._crt_pal = pal;
                System.gc();
                for (int i = m1; i <= m2; ++i) {
                    int[] image_data;
                    int sizeX = this._modules_w[i] & 0xFF;
                    int sizeY = this._modules_h[i] & 0xFF;
                    if (sizeX <= 0 || sizeY <= 0 || (image_data = this.DecodeImage(i, 0)) == null) continue;
                    boolean bAlpha = false;
                    int size = sizeX * sizeY;
                    for (int ii = 0; ii < size; ++ii) {
                        if ((image_data[ii] & 0xFF000000) == -16777216) continue;
                        bAlpha = true;
                        break;
                    }
                    this._modules_image[pal][i] = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)bAlpha);
                    image_data = null;
                }
                System.gc();
                this._crt_pal = old_pal;
            }
        }
        if (eraseModuleData) {
            this._modules_data = null;
            this._modules_data_off = null;
        }
        System.gc();
    }

    void FreeCacheData() {
        this._modules_data = null;
        this._modules_data_off = null;
        System.gc();
    }

    int GetAFrameTime(int anim, int aframe) {
        return this._aframes[(this._anims_af_start[anim] + aframe) * 5 + 1] & 0xFF;
    }

    int GetAFrames(int anim) {
        return this._anims_naf[anim] & 0xFF;
    }

    int GetFModules(int frame) {
        return this._frames_nfm[frame] & 0xFF;
    }

    int GetModuleWidth(int module) {
        return this._modules_w[module] & 0xFF;
    }

    int GetModuleHeight(int module) {
        return this._modules_h[module] & 0xFF;
    }

    int GetFrameWidth(int frame) {
        return this._frames_rc[frame * 4 + 2] & 0xFF;
    }

    int GetFrameHeight(int frame) {
        return this._frames_rc[frame * 4 + 3] & 0xFF;
    }

    int GetFrameModuleX(int frame, int fmodule) {
        int off = (this._frames_fm_start[frame] + fmodule) * 6;
        return ASprite.Mem_GetShort(this._fmodules, off + 1);
    }

    int GetFrameModuleY(int frame, int fmodule) {
        int off = (this._frames_fm_start[frame] + fmodule) * 6;
        return ASprite.Mem_GetShort(this._fmodules, off + 3);
    }

    int GetFrameModuleWidth(int frame, int fmodule) {
        int off = (this._frames_fm_start[frame] + fmodule) * 6;
        int index = this._fmodules[off] & 0xFF;
        return this._modules_w[index] & 0xFF;
    }

    int GetFrameModuleHeight(int frame, int fmodule) {
        int off = (this._frames_fm_start[frame] + fmodule) * 6;
        int index = this._fmodules[off] & 0xFF;
        return this._modules_h[index] & 0xFF;
    }

    int GetAnimFrame(int anim, int aframe) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        return this._aframes[off] & 0xFF;
    }

    void GetAFrameRect(int[] rc, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        int frame = this._aframes[off] & 0xFF;
        if ((flags & 0x20) != 0) {
            hx = (flags & 1) != 0 ? (hx += this._aframes[off + 2]) : (hx -= this._aframes[off + 2]);
            hy = (flags & 2) != 0 ? (hy += this._aframes[off + 3]) : (hy -= this._aframes[off + 3]);
        }
        this.GetFrameRect(rc, frame, posX, posY, flags ^ this._aframes[off + 4] & 0xF, hx, hy);
    }

    void GetFrameRect(int[] rc, int frame, int posX, int posY, int flags, int hx, int hy) {
        int x1 = 65280;
        int y1 = 65280;
        int x2 = -x1;
        int y2 = -y1;
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.GetFModuleRect(rc, frame, fmodule, posX, posY, flags, hx, hy);
            if (rc[0] < x1) {
                x1 = rc[0];
            }
            if (rc[1] < y1) {
                y1 = rc[1];
            }
            if (rc[2] > x2) {
                x2 = rc[2];
            }
            if (rc[3] <= y2) continue;
            y2 = rc[3];
        }
        hx <<= 8;
        hy <<= 8;
        hx = (flags & 1) != 0 ? (hx += x2) : (hx -= x1);
        hy = (flags & 2) != 0 ? (hy += y2) : (hy -= y1);
        rc[0] = posX - hx;
        rc[1] = posY - hy;
        rc[2] = rc[0] + x2 - x1;
        rc[3] = rc[1] + y2 - y1;
    }

    void GetFModuleRect(int[] rc, int frame, int fmodule, int posX, int posY, int flags, int hx, int hy) {
        rc[0] = this.GetFrameModuleX(frame, fmodule) << 8;
        rc[1] = this.GetFrameModuleY(frame, fmodule) << 8;
        rc[2] = rc[0] + (this.GetFrameModuleWidth(frame, fmodule) << 8);
        rc[3] = rc[1] + (this.GetFrameModuleHeight(frame, fmodule) << 8);
    }

    void GetModuleRect(int[] rc, int module, int posX, int posY, int flags) {
        rc[0] = posX;
        rc[1] = posY;
        rc[2] = posX + ((this._modules_w[module] & 0xFF) << 8);
        rc[3] = posY + ((this._modules_h[module] & 0xFF) << 8);
    }

    void PaintAFrame(Graphics g, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        int frame = this._aframes[off] & 0xFF;
        if ((flags & 4) != 0) {
            hx = (flags & 1) != 0 ? (hx += this._aframes[off + 2]) : (hx -= this._aframes[off + 2]);
            hy = (flags & 2) != 0 ? (hy += this._aframes[off + 3]) : (hy -= this._aframes[off + 3]);
        } else {
            hx = (flags & 1) != 0 ? (hx += this._aframes[off + 2]) : (hx -= this._aframes[off + 2]);
            hy = (flags & 2) != 0 ? (hy += this._aframes[off + 3]) : (hy -= this._aframes[off + 3]);
        }
        this.PaintFrame(g, frame, posX - hx, posY - hy, flags ^ this._aframes[off + 4] & 0xF, hx, hy);
    }

    void PaintFrame(Graphics g, int frame, int posX, int posY, int flags, int hx, int hy) {
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.PaintFModule(g, frame, fmodule, posX, posY, flags, hx, hy);
        }
    }

    void PaintFModule(Graphics g, int frame, int fmodule, int posX, int posY, int flags, int hx, int hy) {
        int off = (this._frames_fm_start[frame] + fmodule) * 6;
        int fm_flags = this._fmodules[off + 5] & 0xFF;
        int index = this._fmodules[off] & 0xFF;
        short ox = ASprite.Mem_GetShort(this._fmodules, off + 1);
        short oy = ASprite.Mem_GetShort(this._fmodules, off + 3);
        if ((flags & 4) != 0) {
            if ((fm_flags & 0x10) != 0) {
                posY = (flags & 1) != 0 ? (posY -= ox) : (posY += ox);
                posX = (flags & 2) != 0 ? (posX -= oy) : (posX += oy);
            } else {
                posY = (flags & 1) != 0 ? (posY -= ox + (this._modules_w[index] & 0xFF)) : (posY += ox);
                posX = (flags & 2) != 0 ? (posX -= oy + (this._modules_h[index] & 0xFF)) : (posX += oy);
            }
        } else if ((fm_flags & 0x10) != 0) {
            posX = (flags & 1) != 0 ? (posX -= ox) : (posX += ox);
            posY = (flags & 2) != 0 ? (posY -= oy) : (posY += oy);
        } else {
            posX = (flags & 1) != 0 ? (posX -= ox + (this._modules_w[index] & 0xFF)) : (posX += ox);
            posY = (flags & 2) != 0 ? (posY -= oy + (this._modules_h[index] & 0xFF)) : (posY += oy);
        }
        if ((fm_flags & 0x10) != 0) {
            this.PaintFrame(g, index, posX, posY, flags ^ fm_flags & 0xF, hx, hy);
        } else {
            this.PaintModule(g, index, posX, posY, flags ^ fm_flags & 0xF);
        }
    }

    static short Mem_GetShort(byte[] src, int src_off) {
        return (short)(src[src_off++] & 0xFF | (src[src_off++] & 0xFF) << 8);
    }

    void PaintModule(Graphics g, int module, int posX, int posY, int flags) {
        int sizeX = this._modules_w[module] & 0xFF;
        int sizeY = this._modules_h[module] & 0xFF;
        if (sizeX <= 0 || sizeY <= 0) {
            return;
        }
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (posX + sizeX < cx || posY + sizeY < cy || posX >= cx + cw || posY >= cy + ch) {
            return;
        }
        Image img = null;
        if ((this._bs_flags & 0x1000000) != 0) {
            if (this._modules_image != null && this._modules_image[this._crt_pal] != null) {
                img = this._modules_image[this._crt_pal][module];
            }
            if (img == null) {
                int[] image_data = this.DecodeImage(module, flags);
                if (image_data == null) {
                    return;
                }
                img = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)this._alpha);
                if (this._cacheUsedModules) {
                    this._modules_image[this._crt_pal][module] = img;
                }
            }
            sizeX = img.getWidth();
            sizeY = img.getHeight();
            g.drawRegion(img, 0, 0, sizeX, sizeY, midp2_flags[flags & 7], posX, posY, 0);
        }
    }

    int[] DecodeImage(int module, int flags) {
        int[] img_data;
        block16: {
            int[] pal;
            int ds;
            int di;
            int si;
            byte[] image;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    if (this._modules_data == null || this._modules_data_off == null) {
                                        return null;
                                    }
                                    int sizeX = this._modules_w[module] & 0xFF;
                                    int sizeY = this._modules_h[module] & 0xFF;
                                    image = this._modules_data;
                                    si = this._modules_data_off[module];
                                    di = 0;
                                    ds = sizeX * sizeY;
                                    img_data = temp;
                                    pal = this._pal[this._crt_pal];
                                    if (pal == null) {
                                        return null;
                                    }
                                    if (this._data_format != 25840) break block15;
                                    while (di < ds) {
                                        int c = image[si++] & 0xFF;
                                        int clr = pal[c & this._i64rle_color_mask];
                                        c >>= this._i64rle_color_bits;
                                        while (c-- >= 0) {
                                            img_data[di++] = clr;
                                        }
                                    }
                                    break block16;
                                }
                                if (this._data_format != 10225) break block17;
                                while (di < ds) {
                                    int c;
                                    if ((c = image[si++] & 0xFF) > 127) {
                                        int c2 = image[si++] & 0xFF;
                                        int clr = pal[c2];
                                        c -= 128;
                                        while (c-- > 0) {
                                            img_data[di++] = clr;
                                        }
                                        continue;
                                    }
                                    img_data[di++] = pal[c];
                                }
                                break block16;
                            }
                            if (this._data_format != 22258) break block18;
                            while (di < ds) {
                                int c;
                                if ((c = image[si++] & 0xFF) > 127) {
                                    c -= 128;
                                    while (c-- > 0) {
                                        img_data[di++] = pal[image[si++] & 0xFF];
                                    }
                                    continue;
                                }
                                int clr = pal[image[si++] & 0xFF];
                                while (c-- > 0) {
                                    img_data[di++] = clr;
                                }
                            }
                            break block16;
                        }
                        if (this._data_format != 5632) break block19;
                        while (di < ds) {
                            img_data[di++] = pal[image[si] >> 4 & 0xF];
                            img_data[di++] = pal[image[si] & 0xF];
                            ++si;
                        }
                        break block16;
                    }
                    if (this._data_format != 1024) break block20;
                    while (di < ds) {
                        img_data[di++] = pal[image[si] >> 6 & 3];
                        img_data[di++] = pal[image[si] >> 4 & 3];
                        img_data[di++] = pal[image[si] >> 2 & 3];
                        img_data[di++] = pal[image[si] & 3];
                        ++si;
                    }
                    break block16;
                }
                if (this._data_format != 512) break block21;
                while (di < ds) {
                    img_data[di++] = pal[image[si] >> 7 & 1];
                    img_data[di++] = pal[image[si] >> 6 & 1];
                    img_data[di++] = pal[image[si] >> 5 & 1];
                    img_data[di++] = pal[image[si] >> 4 & 1];
                    img_data[di++] = pal[image[si] >> 3 & 1];
                    img_data[di++] = pal[image[si] >> 2 & 1];
                    img_data[di++] = pal[image[si] >> 1 & 1];
                    img_data[di++] = pal[image[si] & 1];
                    ++si;
                }
                break block16;
            }
            if (this._data_format != 22018) break block16;
            while (di < ds) {
                img_data[di++] = pal[image[si++] & 0xFF];
            }
        }
        return img_data;
    }

    private void DRAW_STRINGS_SYSTEM___() {
    }

    int GetLineSpacing() {
        return this._line_spacing;
    }

    void SetLineSpacing(int spacing) {
        this._line_spacing = spacing;
    }

    void SetLineSpacingToDefault() {
        this._line_spacing = (this._modules_h[0] & 0xFF) >> 1;
    }

    short[] WraptextB(byte[] s, int width, int height) {
        int c;
        int i;
        int str_len = s.length;
        int strLines = str_len * (this._modules_w[1] & 0xFF) / width;
        short lineSize = 0;
        int cnt = 1;
        int lastSpacePos = 0;
        int distFromLastSpacePos = 0;
        boolean bSpaceFound = false;
        int lines = 0;
        for (i = 0; i < str_len; ++i) {
            c = s[i] & 0xFF;
            if (c != 10) continue;
            ++lines;
        }
        for (i = 0; i < str_len; ++i) {
            int m;
            c = s[i] & 0xFF;
            if (c == 32) {
                lineSize = (short)(lineSize + ((this._modules_w[0] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, 1)));
                lastSpacePos = i;
                distFromLastSpacePos = 0;
                bSpaceFound = true;
                if (lineSize <= width) continue;
                bSpaceFound = false;
                for (int pos = lastSpacePos; pos >= 0 && s[pos] == 32; --pos) {
                    lineSize = (short)(lineSize - ((this._modules_w[0] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, 1)));
                }
                while (lastSpacePos < str_len && s[lastSpacePos] == 32) {
                    lastSpacePos = (short)(lastSpacePos + 1);
                }
                i = lastSpacePos = (int)((short)(lastSpacePos - 1));
                int n = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n] = (short)(lastSpacePos + 1);
                int n2 = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n2] = (short)(lineSize - distFromLastSpacePos);
                lineSize = 0;
                continue;
            }
            if (c == 10) {
                int n = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n] = (short)i;
                int n3 = cnt;
                cnt = (short)(cnt + 1);
                ASprite._sizes[n3] = lineSize;
                lineSize = 0;
                distFromLastSpacePos = 0;
                continue;
            }
            if (c < 32) {
                if (c == 1) {
                    ++i;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            } else {
                c = _map_char[c] & 0xFF;
            }
            if (c >= this.GetFModules(0)) {
                c = 0;
            }
            if ((m = this._fmodules[c * 6] & 0xFF) >= this._nModules) {
                m = 0;
                c = 0;
            }
            int charSize = (this._modules_w[m] & 0xFF) - ASprite.Mem_GetShort(this._fmodules, c * 6 + 1) + ASprite.Mem_GetShort(this._fmodules, 1);
            distFromLastSpacePos = (short)(distFromLastSpacePos + charSize);
            if ((lineSize = (short)(lineSize + charSize)) <= width || !bSpaceFound) continue;
            bSpaceFound = false;
            for (int pos = lastSpacePos; pos >= 0 && s[pos] == 32; --pos) {
                lineSize = (short)(lineSize - ((this._modules_w[0] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, 1)));
            }
            int n = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n] = (short)(lastSpacePos + 1);
            int n4 = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n4] = (short)(lineSize - distFromLastSpacePos);
            lineSize = 0;
            i = lastSpacePos;
        }
        if (lineSize != 0) {
            int n = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n] = (short)str_len;
            int n5 = cnt;
            cnt = (short)(cnt + 1);
            ASprite._sizes[n5] = lineSize;
        }
        ASprite._sizes[0] = (short)(cnt / 2);
        return _sizes;
    }

    void DrawPageB(Graphics g, byte[] s, short[] sizes, int x, int y, int startLine, int maxLines, int anchor) {
        short lines = sizes[0];
        int maxchar = this._modules_h[0] & 0xFF;
        if (maxLines == -1) {
            maxLines = lines + 1;
        }
        int th = this.GetLineSpacing() + maxchar;
        if ((anchor & 0x20) != 0) {
            y -= th * (lines - 1);
        } else if ((anchor & 2) != 0) {
            y -= th * (lines - 1) >> 1;
        }
        this._old_pal = this._crt_pal;
        int k = 0;
        for (int j = startLine; j < lines && k <= maxLines - 1; ++j, ++k) {
            _index1 = j > 0 ? sizes[(j - 1) * 2 + 1] : 0;
            _index2 = sizes[j * 2 + 1];
            if (_index1 < s.length && s[_index1] == 10) {
                ++_index1;
            }
            int xx = x;
            int yy = y + k * th;
            if ((anchor & 0x2B) != 0) {
                if ((anchor & 8) != 0) {
                    xx -= sizes[(j + 1) * 2];
                } else if ((anchor & 1) != 0) {
                    xx -= sizes[(j + 1) * 2] >> 1;
                }
                if ((anchor & 0x20) != 0) {
                    yy -= this._modules_h[1] & 0xFF;
                } else if ((anchor & 2) != 0) {
                    yy -= (this._modules_h[1] & 0xFF) >> 1;
                }
            }
            this.DrawString(g, s, xx, yy, 0, false);
        }
        _index1 = -1;
        _index2 = -1;
        this._crt_pal = this._old_pal;
    }

    static void SetSubString(int i1, int i2) {
        _index1 = i1;
        _index2 = i2;
    }

    void UpdateStringSize(byte[] s) {
        _text_w = 0;
        _text_h = this._modules_h[0] & 0xFF;
        int tw = 0;
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length;
        for (int i = index1; i < index2; ++i) {
            int c = s[i] & 0xFF;
            if (c > 32) {
                c = _map_char[c] & 0xFF;
            } else {
                if (c == 32) {
                    tw += (this._modules_w[0] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, 1);
                    continue;
                }
                if (c == 10) {
                    if (tw > _text_w) {
                        _text_w = tw;
                    }
                    tw = 0;
                    _text_h += this._line_spacing + (this._modules_h[0] & 0xFF);
                    continue;
                }
                if (c == 1) {
                    ++i;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            }
            int m = this._fmodules[c * 6] & 0xFF;
            tw += (this._modules_w[m] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, c * 6 + 1) + ASprite.Mem_GetShort(this._fmodules, 1);
        }
        if (tw > _text_w) {
            _text_w = tw;
        }
        if (_text_w > 0) {
            _text_w -= ASprite.Mem_GetShort(this._fmodules, 1);
        }
    }

    void DrawString(Graphics g, byte[] s, int x, int y, int anchor) {
        this.DrawString(g, s, x, y, anchor, true);
    }

    void SetColor(int index, int color) {
        this._pal[this._crt_pal][index] = color;
    }

    void DrawString(Graphics g, byte[] s, int x, int y, int anchor, boolean restorecol) {
        y -= ASprite.Mem_GetShort(this._fmodules, 3);
        if ((anchor & 0x2B) != 0) {
            this.UpdateStringSize(s);
            if ((anchor & 8) != 0) {
                x -= _text_w;
            } else if ((anchor & 1) != 0) {
                x -= _text_w >> 1;
            }
            if ((anchor & 0x20) != 0) {
                y -= _text_h;
            } else if ((anchor & 2) != 0) {
                y -= _text_h >> 1;
            }
        }
        int xx = x;
        int yy = y;
        if (restorecol) {
            this._old_pal = this._crt_pal;
        }
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length;
        for (int i = index1; i < index2; ++i) {
            int c = s[i] & 0xFF;
            if (c > 32) {
                c = _map_char[c] & 0xFF;
            } else {
                if (c == 32) {
                    xx += (this._modules_w[0] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, 1);
                    continue;
                }
                if (c == 10) {
                    xx = x;
                    yy += this._line_spacing + (this._modules_h[0] & 0xFF);
                    continue;
                }
                if (c == 1) {
                    if ((s[++i] & 0xFF) < this._palettes) {
                        this._crt_pal = s[i] & 0xFF;
                    }
                    if ((s[i] & 0xFF) != 255) continue;
                    this._crt_pal = this._old_pal;
                    continue;
                }
                if (c != 2) continue;
                c = s[++i] & 0xFF;
            }
            int m = this._fmodules[c * 6] & 0xFF;
            this.PaintFModule(g, 0, c, xx, yy, 0, 0, 0);
            xx += (this._modules_w[m] & 0xFF) + ASprite.Mem_GetShort(this._fmodules, c * 6 + 1) + ASprite.Mem_GetShort(this._fmodules, 1);
        }
        if (restorecol) {
            this._crt_pal = this._old_pal;
        }
    }

    static int StringTokenize(byte[] s, int index1, int index2, char token, int[] indices) {
        int lines = 0;
        indices[0] = index1 - 1;
        for (int i = index1; i < index2; ++i) {
            if (s[i] != token) continue;
            indices[++lines] = i;
        }
        indices[++lines] = index2;
        return lines;
    }

    void DrawPage(Graphics g, byte[] s, int x, int y, int anchor) {
        this.DrawPage(g, s, x, y, anchor, 0, s.length);
    }

    void DrawPage(Graphics g, byte[] s, int x, int y, int anchor, int start, int end) {
        int[] off = new int[100];
        int lines = ASprite.StringTokenize(s, start, end, '\n', off);
        int th = this._line_spacing + (this._modules_h[0] & 0xFF);
        if ((anchor & 0x20) != 0) {
            y -= th * (lines - 1);
        } else if ((anchor & 2) != 0) {
            y -= th * (lines - 1) >> 1;
        }
        for (int j = 0; j < lines; ++j) {
            _index1 = off[j] + 1;
            _index2 = off[j + 1];
            this.DrawString(g, s, x, y + j * th, anchor);
        }
        _index1 = -1;
        _index2 = -1;
    }

    private void ___DRAW_STRINGS_SYSTEM() {
    }

    void SetCurrentPalette(int pal) {
        if (pal < this._palettes) {
            this._crt_pal = pal;
        }
    }

    int GetCurrentPalette() {
        return this._crt_pal;
    }

    static int[] GenPalette(int type, int[] pal) {
        if (type < 0) {
            return pal;
        }
        if (type == 0) {
            return null;
        }
        int[] new_pal = new int[pal.length];
        switch (type) {
            case 4: {
                for (int i = 0; i < pal.length; ++i) {
                    int a = pal[i] & 0xFF000000;
                    int r = (pal[i] & 0xFF0000) >> 16;
                    int g = (pal[i] & 0xFF00) >> 8;
                    int b = pal[i] & 0xFF;
                    int l = (r + b + g) / 3 & 0xFF;
                    new_pal[i] = l << 16 | l << 8 | l | a;
                }
                break;
            }
        }
        return new_pal;
    }

    void ModifyPaletteAlpha(int palNb, short alpha) {
        alpha = (short)((alpha << 4) / 100);
        for (int i = 0; i < this._pal[palNb].length; ++i) {
            if ((this._pal[palNb][i] & 0xFFF) == 3855) continue;
            this._pal[palNb][i] = (short)((alpha & 0xF) << 12 | this._pal[palNb][i] & 0xFFF);
        }
    }

    ASprite() {
    }

    static {
        midp2_flags = new int[]{0, 2, 1, 3, 5, 7, 4, 6};
        _sizes = new short[100];
        _index1 = -1;
        _index2 = -1;
        temp = new int[20480];
    }
}

