/*
 * Decompiled with CFR 0.152.
 */
class FlyingPipe {
    public static final byte PRECISION = 4;
    public int x;
    public int y;
    public short destCellX;
    public short destCellY;
    public int destX;
    public int destY;
    private int stepX;
    private int stepY;
    public byte pipeType;
    public boolean hasReachedDest = false;

    public FlyingPipe(byte by, short s, short s2, short s3, short s4, short s5, short s6, int n) {
        this.pipeType = by;
        this.x = s << 4;
        this.y = s2 << 4;
        this.destCellX = s5;
        this.destCellY = s6;
        this.destX = s3 << 4;
        this.destY = s4 << 4;
        this.stepX = (this.destX - this.x) / n;
        this.stepY = (this.destY - this.y) / n;
    }

    public void updatePosition() {
        this.x += this.stepX;
        if (this.stepX < 0 && this.x < this.destX || this.stepX > 0 && this.x > this.destX) {
            this.hasReachedDest = true;
            this.x = this.destX;
        }
        this.y += this.stepY;
        if (this.stepY < 0 && this.y < this.destY || this.stepY > 0 && this.y > this.destY) {
            this.hasReachedDest = true;
            this.y = this.destY;
        }
    }

    public int getX() {
        return this.x >> 4;
    }

    public int getY() {
        return this.y >> 4;
    }

    public boolean hasReachedDest() {
        return this.hasReachedDest;
    }
}

