/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class Level {
    public static final byte CELL_EMPTY = 0;
    public static final byte CELL_START = 1;
    public static final byte CELL_END = 2;
    public static final byte CELL_DEATH = 3;
    public static final byte CELL_GROUND = 4;
    public static final byte CELL_KEY = 5;
    public static final byte CELL_CLOCK = 6;
    public static final byte CELL_MEGA_BONUS = 7;
    public static final byte CELL_DRUG = 8;
    public static final byte CELL_SAW = 9;
    public static final byte CELL_BONUS = 10;
    public static final byte CELL_INVISIBLE_GROUND = 11;
    public static final byte CELL_ICE = 12;
    public static final byte CELL_FIRE = 13;
    public static final byte CELL_SPRING = 14;
    public static final byte CELL_MINE = 15;
    public static final byte CELL_CENTER = 16;
    public static final byte CELL_SPIKES = 17;
    public static final byte CELL_KEY_0 = 40;
    public static final byte CELL_CLOCK_0 = 42;
    public static final byte CELL_MEGA_BONUS_0 = 43;
    public static final byte CELL_DRUG_0 = 45;
    public static final byte CELL_BONUS_0 = 50;
    public static final byte CELL_MATRIX_TELEPORT = 0;
    public static final byte CELL_MATRIX_KEY = 1;
    public static final byte CELL_MATRIX_CLOCK = 2;
    public static final byte CELL_MATRIX_BONUS = 3;
    public static final byte CELL_MATRIX_MEGABONUS = 4;
    public static final byte CELL_MATRIX_DRUG = 5;
    public static final byte CELL_MATRIX_SPIKES = 6;
    public static final byte CELL_MATRIX_SPRING = 7;
    public static final byte CELL_MATRIX_SAW = 8;
    public static final byte CELL_MATRIX_START = 9;
    public static byte[] bonusesCount = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static byte[][][] bonusesMap;
    public static boolean[][][] hiddenBonusesMap;
    public static byte DIRECTION_FORWARD;
    public static byte DIRECTION_BACKWARD;
    public static boolean isTrapsActive;
    public static short ballPosX;
    public static short ballPosY;
    public static short ballPosZ;
    public static byte ballDirFront;
    public static byte ballDirTop;
    public static byte ballDirLeft;
    public static int ballBufferStart;
    public static int ballBufferLength;
    public static float ballScale;
    public static int _iDimX;
    public static int _iDimY;
    public static int _iDimZ;
    public static int currentLevel;
    public static int _oY;
    public static int _oZ;
    public static short trapsDisplace;
    public static byte[] _cells;
    public static short startPosX;
    public static short startPosY;
    public static short startPosZ;
    public static float ballAngleX;
    public static float ballAngleY;
    public static float ballAngleZ;
    public static float bonusesAngle;
    public static float ballInitialAngleX;
    public static float ballInitialAngleY;
    public static float ballInitialAngleZ;
    public static float ballDesirableAngle;
    public static float ballScaleX;
    public static float ballScaleY;
    public static float ballScaleZ;
    public static float curScale;
    public static float ballMaxScale;
    public static float ballMinScale;
    public static float curScaleAdd;
    public static float ballSettlingIncrementX;
    public static float ballSettlingIncrementY;
    public static float ballSettlingIncrementZ;
    public static float ballCurrentPosM3GX;
    public static float ballCurrentPosM3GY;
    public static float ballCurrentPosM3GZ;
    public static int iInvisibleCellsCount;

    public static void uploadLevel(qMesh qMesh2, bMesh bMesh2, bGeometry[] bGeometryArray) {
    }

    public static void fixSpikes(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                Level.setCell(6, 6, 0, 17);
                Level.setCell(2, 6, 0, 17);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                Level.setCell(2, 4, 7, 17);
                break;
            }
            case 11: {
                Level.setCell(4, 1, 3, 17);
                Level.setCell(5, 6, 1, 17);
                Level.setCell(7, 1, 1, 17);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                Level.setCell(6, 1, 5, 17);
                break;
            }
        }
    }

    protected static void newCells(int n, int n2, int n3) {
        _iDimX = n;
        _iDimY = n2;
        _iDimZ = n3;
        int n4 = _iDimX * _iDimY * _iDimZ;
        _oY = _iDimX;
        _oZ = _iDimX * _iDimY;
        _cells = null;
        if (n4 > 0) {
            _cells = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                Level._cells[i] = 0;
            }
        }
    }

    public static int cellIndex(int n, int n2, int n3) {
        if (n < 0 || n >= _iDimX || n2 < 0 || n2 >= _iDimY || n3 < 0 || n3 >= _iDimZ) {
            return -1;
        }
        return n + _oY * n2 + _oZ * n3;
    }

    public static boolean isSolidCell(int n) {
        byte by;
        return n != -1 && ((by = _cells[n]) == 4 || by == 12 || by == 13 || by == 3);
    }

    public static boolean isSolidCell(int n, int n2, int n3) {
        return Level.isSolidCell(Level.cellIndex(n, n2, n3));
    }

    public static boolean isCellSolid(short s, short s2, short s3) {
        byte by = Level.getCell(s, s2, s3);
        switch (by) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 17: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTrapsOnLevel() {
        return bonusesCount[8] != 0 || bonusesCount[6] != 0;
    }

    public static boolean isCellGround(short s, short s2, short s3) {
        byte by = Level.getCell(s, s2, s3);
        switch (by) {
            case 4: {
                return true;
            }
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCellSolidBonus(short s, short s2, short s3) {
        byte by = Level.getCell(s, s2, s3);
        switch (by) {
            case 17: {
                return true;
            }
            case 14: {
                return true;
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCellSpikes(short s, short s2, short s3) {
        byte by = Level.getCell(s, s2, s3);
        switch (by) {
            case 17: {
                return true;
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBonusDestroyable(int n, int n2, int n3) {
        short s = Level.getCellMatrixID(n, n2, n3);
        return s == 1 || s == 2 || s == 4 || s == 5 || s == 3;
    }

    public static void destroyBonus(int n, int n2, int n3) {
        if (Level.getBonusCell(n, n2, n3) == -1) {
            return;
        }
        if (Level.getCellMatrixID(n, n2, n3) == 5) {
            vE.bIsDrugged = true;
            vE.iTimeDruggedStart = Logic._iGameplayTime;
        }
        short s = Level.getCellStart(n, n2, n3);
        short s2 = Level.getCellLength(Level.getCellMatrixID(n, n2, n3));
        bMesh.destroyBonus(s, s2);
        Visual.hideCellItem(n, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateTraps() {
        int n = Logic._iTick % 3;
        if (n != 0) {
            if (!isTrapsActive) return;
            trapsDisplace = 0;
            isTrapsActive = false;
            return;
        } else {
            short s;
            trapsDisplace = s = (short)(256 - Utils.abs(Logic._iGameplayTime - (Logic._iTick * 1000 - 500)) * 256 / 500);
            if (Logic._iGameplayTime < Logic._iTick * 1000 - 500) {
                Level.animateTraps(vE.bmesh, DIRECTION_FORWARD, trapsDisplace);
            } else {
                Level.animateTraps(vE.bmesh, DIRECTION_FORWARD, trapsDisplace);
            }
            isTrapsActive = true;
        }
    }

    public static void animateTraps(bMesh bMesh2, byte by, short s) {
        short s2 = -1;
        for (short s3 = 0; s3 < _iDimX; s3 = (short)((short)(s3 + 1))) {
            for (short s4 = 0; s4 < _iDimY; s4 = (short)((short)(s4 + 1))) {
                for (short s5 = 0; s5 < _iDimZ; s5 = (short)((short)(s5 + 1))) {
                    boolean bl = false;
                    if (Level.getCell(s3, s4, s5) != 9 && Level.getCell(s3, s4, s5) != 17) continue;
                    s2 = Level.getCellMatrixID(s3, s4, s5);
                    short s6 = Level.getCellStart(s3, s4, s5);
                    short s7 = Level.getCellLength(s2);
                    short s8 = 0;
                    short s9 = 0;
                    short s10 = 0;
                    if (Level.isCellGround(s3, s4, (short)(s5 - 1))) {
                        s10 = (short)(-1 * by * s);
                    }
                    if (Level.isCellGround(s3, s4, (short)(s5 + 1))) {
                        s10 = (short)(1 * by * s);
                    }
                    if (Level.isCellGround(s3, (short)(s4 - 1), s5)) {
                        s9 = (short)(-1 * by * s);
                    }
                    if (Level.isCellGround(s3, (short)(s4 + 1), s5)) {
                        s9 = (short)(1 * by * s);
                    }
                    if (Level.isCellGround((short)(s3 - 1), s4, s5)) {
                        s8 = (short)(-1 * by * s);
                    }
                    if (Level.isCellGround((short)(s3 + 1), s4, s5)) {
                        s8 = (short)(1 * by * s);
                    }
                    bMesh.displaceShortAbsolute(s6, s7, s8, s9, s10);
                }
            }
        }
    }

    public static void place(bMesh bMesh2) {
        short s = -1;
        for (int n = 0; n < _iDimX; n = (int)((short)(n + 1))) {
            for (int n2 = 0; n2 < _iDimY; n2 = (int)((short)(n2 + 1))) {
                for (int n3 = 0; n3 < _iDimZ; n3 = (int)((short)(n3 + 1))) {
                    int n4 = 0;
                    if (currentLevel == 13 && n == 0 && n2 == 4 && n3 == 1) {
                        n4 = -2;
                    }
                    if (currentLevel == 17 && n == 0 && n2 == 12 && n3 == 1) {
                        n4 = -2;
                    }
                    if ((s = (short)Level.getCellMatrixID(n, n2, n3)) == -1) continue;
                    short s2 = Level.getCellStart(n, n2, n3);
                    short s3 = Level.getCellLength(s);
                    if (s == 9) {
                        ballBufferStart = s2;
                        ballBufferLength = s3;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    bMesh.placeInLevel(s2, s3, (short)(n + n5), (short)(n2 + n6), (short)(n3 + n4 + n7));
                }
            }
        }
    }

    public static void placeSolids(bMesh bMesh2) {
        short s = -1;
        for (short s2 = 0; s2 < _iDimX; s2 = (short)((short)(s2 + 1))) {
            for (short s3 = 0; s3 < _iDimY; s3 = (short)((short)(s3 + 1))) {
                for (short s4 = 0; s4 < _iDimZ; s4 = (short)((short)(s4 + 1))) {
                    int n = 0;
                    if (currentLevel == 13 && s2 == 0 && s3 == 4 && s4 == 1) {
                        n = -2;
                    }
                    if (currentLevel == 17 && s2 == 0 && s3 == 12 && s4 == 1) {
                        n = -2;
                    }
                    if ((s = (short)Level.getCellMatrixID(s2, s3, s4)) == -1) continue;
                    short s5 = Level.getCellStart(s2, s3, s4);
                    short s6 = Level.getCellLength(s);
                    int n2 = 0;
                    int n3 = 0;
                    short s7 = 0;
                    if (Level.getCell(s2, s3, s4) == 14) {
                        if (Level.isCellGround(s2, s3, (short)(s4 - 1))) {
                            s7 = -1;
                        }
                        if (Level.isCellGround(s2, s3, (short)(s4 + 1))) {
                            s7 = 1;
                        }
                        if (Level.isCellGround(s2, (short)(s3 - 1), s4)) {
                            n3 = -1;
                        }
                        if (Level.isCellGround(s2, (short)(s3 + 1), s4)) {
                            n3 = 1;
                        }
                        if (Level.isCellGround((short)(s2 - 1), s3, s4)) {
                            n2 = -1;
                        }
                        if (Level.isCellGround((short)(s2 + 1), s3, s4)) {
                            n2 = 1;
                        }
                    }
                    if (Level.getCell(s2, s3, s4) == 17 || Level.getCell(s2, s3, s4) == 9) {
                        if (Level.isCellGround(s2, s3, (short)(s4 - 1))) {
                            s7 = -1;
                        }
                        if (Level.isCellGround(s2, s3, (short)(s4 + 1))) {
                            s7 = 1;
                        }
                        if (Level.isCellGround(s2, (short)(s3 - 1), s4)) {
                            n3 = -1;
                        }
                        if (Level.isCellGround(s2, (short)(s3 + 1), s4)) {
                            n3 = 1;
                        }
                        if (Level.isCellGround((short)(s2 - 1), s3, s4)) {
                            n2 = -1;
                        }
                        if (Level.isCellGround((short)(s2 + 1), s3, s4)) {
                            n2 = 1;
                        }
                    }
                    if (Level.getCell(s2, s3, s4) == 2 && currentLevel == 17) {
                        s7 = (short)(s4 - 3);
                    }
                    bMesh.placeInLevel(s5, s6, (short)n2, (short)n3, s7);
                    if (Level.getCell(s2, s3, s4) == 2 && currentLevel != 17) continue;
                }
            }
        }
    }

    public static void setBallPatern(int n) {
        switch (n) {
            case 1: {
                bMesh.restoreTexture(vE.bmesh, vE.bgeometry[9], ballBufferStart, ballBufferLength);
                break;
            }
            case 2: {
                bMesh.restoreTexture(vE.bmesh, vE.bgeometry[9], ballBufferStart, ballBufferLength);
                bMesh.displaceTexture(ballBufferStart, ballBufferLength, (short)64, (short)0);
                break;
            }
            case 3: {
                bMesh.restoreTexture(vE.bmesh, vE.bgeometry[9], ballBufferStart, ballBufferLength);
                bMesh.displaceTexture(ballBufferStart, ballBufferLength, (short)130, (short)0);
            }
        }
    }

    public static void updateBallPatern() {
        Level.setBallPatern(Logic._iFirePatternNum);
    }

    public static void orient(bMesh bMesh2) {
        short s = -1;
        for (short s2 = 0; s2 < _iDimX; s2 = (short)((short)(s2 + 1))) {
            for (short s3 = 0; s3 < _iDimY; s3 = (short)((short)(s3 + 1))) {
                for (short s4 = 0; s4 < _iDimZ; s4 = (short)((short)(s4 + 1))) {
                    s = Level.getCellMatrixID(s2, s3, s4);
                    if (s == -1) continue;
                    short s5 = Level.getCellStart(s2, s3, s4);
                    short s6 = Level.getCellLength(s);
                    if (Level.isCellSpikes(s2, s3, s4)) {
                        if (Level.isCellGround(s2, s3, (short)(s4 - 1))) {
                            bMesh.rotate(s5, s6, 180.0f, 0.0f, 0.0f, s2, s3, s4);
                            vE.bmesh.updateSolidVertFaces();
                            Level.orientByLine(s5, s6, s2, s3, (short)(s4 - 1), s2, s3, s4);
                            continue;
                        }
                        if (Level.isCellGround(s2, s3, (short)(s4 + 1))) {
                            Level.orientByLine(s5, s6, s2, s3, (short)(s4 + 1), s2, s3, s4);
                            continue;
                        }
                        if (Level.isCellGround(s2, (short)(s3 - 1), s4)) {
                            bMesh.rotate(s5, s6, 90.0f, 0.0f, 0.0f, s2, s3, s4);
                            Level.orientByLine(s5, s6, s2, (short)(s3 - 1), s4, s2, s3, s4);
                            continue;
                        }
                        if (Level.isCellGround(s2, (short)(s3 + 1), s4)) {
                            bMesh.rotate(s5, s6, -90.0f, 0.0f, 0.0f, s2, s3, s4);
                            Level.orientByLine(s5, s6, s2, (short)(s3 + 1), s4, s2, s3, s4);
                            continue;
                        }
                        if (Level.isCellGround((short)(s2 - 1), s3, s4)) {
                            bMesh.rotate(s5, s6, 0.0f, -90.0f, 0.0f, s2, s3, s4);
                            Level.orientByLine(s5, s6, (short)(s2 - 1), s3, s4, s2, s3, s4);
                            continue;
                        }
                        if (Level.isCellGround((short)(s2 + 1), s3, s4)) {
                            bMesh.rotate(s5, s6, 0.0f, 90.0f, 0.0f, s2, s3, s4);
                            Level.orientByLine(s5, s6, (short)(s2 + 1), s3, s4, s2, s3, s4);
                            continue;
                        }
                    } else if (Level.isCellSolid(s2, s3, (short)(s4 - 1))) {
                        bMesh.rotate(s5, s6, 180.0f, 0.0f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid(s2, s3, (short)(s4 + 1))) continue;
                    if (Level.isCellSolid(s2, (short)(s3 - 1), s4)) {
                        bMesh.rotate(s5, s6, 90.0f, 0.0f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid(s2, (short)(s3 + 1), s4)) {
                        bMesh.rotate(s5, s6, -90.0f, 0.0f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid((short)(s2 - 1), s3, s4)) {
                        bMesh.rotate(s5, s6, 0.0f, -90.0f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (!Level.isCellSolid((short)(s2 + 1), s3, s4)) continue;
                    bMesh.rotate(s5, s6, 0.0f, 90.0f, 0.0f, s2, s3, s4);
                }
            }
        }
    }

    public static void animateBonuses(bMesh bMesh2, float f) {
        short s = -1;
        for (short s2 = 0; s2 < _iDimX; s2 = (short)((short)(s2 + 1))) {
            for (short s3 = 0; s3 < _iDimY; s3 = (short)((short)(s3 + 1))) {
                for (short s4 = 0; s4 < _iDimZ; s4 = (short)((short)(s4 + 1))) {
                    s = Level.getCellMatrixID(s2, s3, s4);
                    if (s == -1 || s != 0 && (s < 1 || s > 5)) continue;
                    short s5 = Level.getCellStart(s2, s3, s4);
                    short s6 = Level.getCellLength(s);
                    if (Level.isCellSolid(s2, s3, (short)(s4 - 1))) {
                        bMesh.rotateSolid(s5, s6, 0.0f, 0.0f, -f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid(s2, s3, (short)(s4 + 1))) {
                        bMesh.rotateSolid(s5, s6, 0.0f, 0.0f, f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid(s2, (short)(s3 - 1), s4)) {
                        bMesh.rotateSolid(s5, s6, 0.0f, -f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid(s2, (short)(s3 + 1), s4)) {
                        bMesh.rotateSolid(s5, s6, 0.0f, f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (Level.isCellSolid((short)(s2 - 1), s3, s4)) {
                        bMesh.rotateSolid(s5, s6, f, 0.0f, 0.0f, s2, s3, s4);
                        continue;
                    }
                    if (!Level.isCellSolid((short)(s2 + 1), s3, s4)) continue;
                    bMesh.rotateSolid(s5, s6, -f, 0.0f, 0.0f, s2, s3, s4);
                }
            }
        }
    }

    public static void orientByLine(int n, int n2, short s, short s2, short s3, short s4, short s5, short s6) {
        if (Level.isCellGround(s, s2, (short)(s3 - 1))) {
            bMesh.rotate(n, n2, 90.0f, 0.0f, 0.0f, s4, s5, s6);
            return;
        }
        if (Level.isCellGround(s, s2, (short)(s3 + 1))) {
            bMesh.rotate(n, n2, 90.0f, 0.0f, 0.0f, s4, s5, s6);
            return;
        }
        if (Level.isCellGround(s, (short)(s2 - 1), s3)) {
            bMesh.rotate(n, n2, 0.0f, 0.0f, 90.0f, s4, s5, s6);
            return;
        }
        if (Level.isCellGround(s, (short)(s2 + 1), s3)) {
            bMesh.rotate(n, n2, 0.0f, 0.0f, 90.0f, s4, s5, s6);
            return;
        }
        if (Level.isCellGround((short)(s - 1), s2, s3)) {
            bMesh.rotate(n, n2, 0.0f, 0.0f, 0.0f, s4, s5, s6);
            return;
        }
        if (Level.isCellGround((short)(s + 1), s2, s3)) {
            bMesh.rotate(n, n2, 0.0f, 0.0f, 0.0f, s4, s5, s6);
            return;
        }
    }

    public static short getCellLength(short s) {
        return vE.bgeometry[s].vertexCount;
    }

    public static short getCellMatrixID(int n, int n2, int n3) {
        int n4;
        byte by = Level.getCell(n, n2, n3);
        if (by == 2) {
            n4 = 0;
        } else if (by == 5 || by == 40 || by == 41) {
            n4 = 1;
        } else if (by == 42 || by == 6) {
            n4 = 2;
        } else if (by >= 50 && by <= 65) {
            n4 = 3;
        } else if (by == 43 || by == 44) {
            n4 = 4;
        } else if (by >= 45 && by <= 50) {
            n4 = 5;
        } else if (by == 17) {
            n4 = 6;
        } else if (by == 9) {
            n4 = 8;
        } else if (by == 14) {
            n4 = 7;
        } else if (by == 1) {
            n4 = 9;
        } else {
            return -1;
        }
        return (short)n4;
    }

    public static short getCellStart(int n, int n2, int n3) {
        int n4 = -1;
        byte by = Level.getBonusCell(n, n2, n3);
        short s = 0;
        if (by == -1) {
            return -1;
        }
        byte by2 = Level.getCell(n, n2, n3);
        if (by2 == 2) {
            n4 = 0;
        } else if (by2 == 5 || by2 == 40 || by2 == 41) {
            n4 = 1;
        } else if (by2 == 42 || by2 == 6) {
            n4 = 2;
        } else if (by2 >= 50 && by2 <= 65) {
            n4 = 3;
        } else if (by2 == 43 || by2 == 44) {
            n4 = 4;
        } else if (by2 >= 45 && by2 <= 50) {
            n4 = 5;
        } else if (by2 == 9) {
            n4 = 8;
        } else if (by2 == 17) {
            n4 = 6;
        } else if (by2 == 14) {
            n4 = 7;
        } else if (by2 == 1) {
            n4 = 9;
        } else {
            return -1;
        }
        for (int i = 0; i < n4; ++i) {
            s = (short)(s + vE.bgeometry[i].vertexCount * (short)bonusesCount[i]);
        }
        s = (short)(s + vE.bgeometry[n4].vertexCount * (short)by);
        return s;
    }

    public static byte getCell(int n, int n2, int n3) {
        try {
            return _cells[Level.cellIndex(n, n2, n3)];
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static byte getBonusCell(int n, int n2, int n3) {
        try {
            return bonusesMap[n][n2][n3];
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void setCell(int n, int n2, int n3, int n4) {
        try {
            int n5 = Level.cellIndex(n, n2, n3);
            Level._cells[n5] = (byte)n4;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void loadLevel(int n) {
        try {
            currentLevel = n;
            DataInputStream dataInputStream = Utils.setFileStream("/l" + n);
            if (dataInputStream == null) {
                return;
            }
            dataInputStream.skip(2L);
            dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.readByte();
            int n3 = dataInputStream.readByte();
            int n4 = dataInputStream.readByte();
            Level.newCells(n2, n3, n4);
            int n5 = dataInputStream.readUnsignedShort();
            for (int i = 0; i < n5; ++i) {
                Level.setCell(dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readUnsignedByte());
            }
            n2 = dataInputStream.readByte();
            n3 = dataInputStream.readByte();
            n4 = dataInputStream.readByte();
            if (n2 == _iDimX) {
                n2 = (byte)(n2 - 1);
            }
            if (n3 == _iDimY) {
                n3 = (byte)(n3 - 1);
            }
            if (n4 == _iDimZ) {
                n4 = (byte)(n4 - 1);
            }
            if (n2 < 0) {
                n2 = (byte)(-n2);
            }
            if (n3 < 0) {
                n3 = (byte)(-n3);
            }
            if (n4 < 0) {
                n4 = (byte)(-n4);
            }
            if (n == 7) {
                n2 = 4;
                n3 = 0;
                n4 = 2;
            }
            if (n == 13) {
                n2 = 16;
                n3 = 3;
                n4 = 0;
                Logic._start_cell[3] = -3;
                Logic._start_cell[4] = 1;
                Logic._start_cell[5] = 2;
            }
            Level.setCell(n2, n3, n4, 1);
            startPosX = (short)n2;
            startPosY = (short)n3;
            startPosZ = (short)n4;
            ballDirFront = dataInputStream.readByte();
            ballDirTop = dataInputStream.readByte();
            ballDirLeft = dataInputStream.readByte();
            n2 = dataInputStream.readByte();
            n3 = dataInputStream.readByte();
            n4 = dataInputStream.readByte();
            if (n2 == _iDimX) {
                n2 = (byte)(n2 - 1);
            }
            if (n3 == _iDimY) {
                n3 = (byte)(n3 - 1);
            }
            if (n4 == _iDimZ) {
                n4 = (byte)(n4 - 1);
            }
            if (n2 < 0) {
                n2 = (byte)(-n2);
            }
            if (n3 < 0) {
                n3 = (byte)(-n3);
            }
            if (n4 < 0) {
                n4 = (byte)(-n4);
            }
            if (n == 2) {
                n2 = 0;
                n3 = 1;
                n4 = 1;
            }
            if (n == 13) {
                n2 = 1;
                n3 = 3;
                n4 = 3;
                Logic._end_cell[3] = 3;
                Logic._end_cell[4] = 2;
                Logic._end_cell[5] = 1;
                Level.setCell(0, 4, 1, 0);
            }
            Level.setCell(n2, n3, n4, 2);
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            Level.fixSpikes(n);
            if (n == 5) {
                Level.setCell(0, 8, 13, 4);
            }
            if (n == 7) {
                Level.setCell(2, 0, 2, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void researchLevel() {
        int n;
        iInvisibleCellsCount = 0;
        bonusesMap = new byte[_iDimX][_iDimY][_iDimZ];
        for (n = 0; n < bonusesCount.length; ++n) {
            Level.bonusesCount[n] = 0;
        }
        for (n = 0; n < _iDimX; ++n) {
            for (int i = 0; i < _iDimY; ++i) {
                for (int j = 0; j < _iDimZ; ++j) {
                    byte by = Level.getCell(n, i, j);
                    if (by == 2) {
                        Level.bonusesMap[n][i][j] = bonusesCount[0];
                        bonusesCount[0] = (byte)(bonusesCount[0] + 1);
                        continue;
                    }
                    if (by == 5 || by == 40 || by == 41) {
                        Level.bonusesMap[n][i][j] = bonusesCount[1];
                        bonusesCount[1] = (byte)(bonusesCount[1] + 1);
                        continue;
                    }
                    if (by == 42 || by == 6) {
                        Level.bonusesMap[n][i][j] = bonusesCount[2];
                        bonusesCount[2] = (byte)(bonusesCount[2] + 1);
                        continue;
                    }
                    if (by >= 50 && by <= 65) {
                        Level.bonusesMap[n][i][j] = bonusesCount[3];
                        bonusesCount[3] = (byte)(bonusesCount[3] + 1);
                        continue;
                    }
                    if (by == 43 || by == 44) {
                        Level.bonusesMap[n][i][j] = bonusesCount[4];
                        bonusesCount[4] = (byte)(bonusesCount[4] + 1);
                        continue;
                    }
                    if (by >= 45 && by <= 50 || by == 8) {
                        Level.bonusesMap[n][i][j] = bonusesCount[5];
                        bonusesCount[5] = (byte)(bonusesCount[5] + 1);
                        continue;
                    }
                    if (by == 17) {
                        Level.bonusesMap[n][i][j] = bonusesCount[6];
                        bonusesCount[6] = (byte)(bonusesCount[6] + 1);
                        continue;
                    }
                    if (by == 9) {
                        Level.bonusesMap[n][i][j] = bonusesCount[8];
                        bonusesCount[8] = (byte)(bonusesCount[8] + 1);
                        continue;
                    }
                    if (by == 14 || by == 7) {
                        Level.bonusesMap[n][i][j] = bonusesCount[7];
                        bonusesCount[7] = (byte)(bonusesCount[7] + 1);
                        continue;
                    }
                    if (by == 14) {
                        Level.bonusesMap[n][i][j] = bonusesCount[7];
                        bonusesCount[7] = (byte)(bonusesCount[7] + 1);
                        continue;
                    }
                    if (by == 11) {
                        ++iInvisibleCellsCount;
                        continue;
                    }
                    if (by == 1) {
                        Level.bonusesMap[n][i][j] = bonusesCount[9];
                        bonusesCount[9] = (byte)(bonusesCount[9] + 1);
                        ballPosX = (short)n;
                        ballPosY = (short)i;
                        ballPosZ = (short)j;
                        continue;
                    }
                    Level.bonusesMap[n][i][j] = -1;
                }
            }
        }
    }

    public static void buildBinaryMesh(bGeometry[] bGeometryArray, bMesh bMesh2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        short s = 0;
        int n7 = 0;
        int n8 = 0;
        bMesh.transform.setIdentity();
        try {
            for (n = 0; n < bonusesCount.length; ++n) {
                s = (short)(s + (short)bonusesCount[n] * vE.bgeometry[n].vertexCount);
                n7 += bonusesCount[n] * vE.bgeometry[n].stripElementsCount;
                n8 += bonusesCount[n] * vE.bgeometry[n].stripCount;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            bMesh.initVertices(s);
            bMesh.initStripArrays(n7, n8);
            for (n = 0; n < bonusesCount.length; ++n) {
                for (int i = 0; i < bonusesCount[n]; ++i) {
                    System.arraycopy(bGeometryArray[n].__vertFaces, 0, bMesh.__vertFaces, n2, bGeometryArray[n].vertexCount * 3);
                    System.arraycopy(bGeometryArray[n].__normFaces, 0, bMesh.__normFaces, n2, bGeometryArray[n].vertexCount * 3);
                    System.arraycopy(bGeometryArray[n].__texFaces, 0, bMesh.__texFaces, n3, bGeometryArray[n].vertexCount * 2);
                    System.arraycopy(bGeometryArray[n].stripIndexes, 0, bMesh.stripIndexes, n4, bGeometryArray[n].stripElementsCount);
                    System.arraycopy(bGeometryArray[n].stripLength, 0, bMesh.stripLength, n5, bGeometryArray[n].stripCount);
                    int n9 = n4;
                    while (n9 < n4 + bGeometryArray[n].stripElementsCount) {
                        int n10 = n9++;
                        bMesh.stripIndexes[n10] = bMesh.stripIndexes[n10] + n6;
                    }
                    n2 += bGeometryArray[n].vertexCount * 3;
                    n3 += bGeometryArray[n].vertexCount * 2;
                    n4 += bGeometryArray[n].stripElementsCount;
                    n5 += bGeometryArray[n].stripCount;
                    n6 += bGeometryArray[n].vertexCount;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bMesh.initVertexArrays(s);
        bMesh2.initVertexBuffer();
        bMesh2.initIndexBuffer();
        bMesh.complete = true;
        Level.place(bMesh2);
        int n11 = 0;
        while (true) {
            if (n11 >= bMesh.__solidVertFaces.length) break;
            bMesh.__solidVertFaces[n11] = bMesh.__vertFaces[n11];
            ++n11;
        }
        Level.orient(bMesh2);
        Level.placeSolids(bMesh2);
        n11 = 0;
        while (true) {
            if (n11 >= bMesh.__solidVertFaces.length) break;
            bMesh.__solidVertFaces[n11] = bMesh.__vertFaces[n11];
            ++n11;
        }
    }

    public static void loadBinaryGeometry(bGeometry[] bGeometryArray) {
        int n;
        for (n = 0; n < bGeometryArray.length; ++n) {
            bGeometryArray[n] = new bGeometry();
        }
        for (n = 0; n < bGeometryArray.length; ++n) {
            Level.loadBinaryMesh(n, bGeometryArray[n]);
            Load.nextLoadPhase();
        }
    }

    public static void loadBinaryMesh(int n, bGeometry bGeometry2) {
        try {
            int n2;
            DataInputStream dataInputStream = Utils.setFileStream("/m" + n);
            if (dataInputStream == null) {
                return;
            }
            bGeometry2.setFaces(dataInputStream.readShort());
            for (n2 = 0; n2 < bGeometry2.vertexCount * 3; ++n2) {
                bGeometry2.__vertFaces[n2] = dataInputStream.readByte();
            }
            for (n2 = 0; n2 < bGeometry2.vertexCount * 3; ++n2) {
                bGeometry2.__normFaces[n2] = dataInputStream.readByte();
            }
            for (n2 = 0; n2 < bGeometry2.vertexCount * 2; ++n2) {
                bGeometry2.__texFaces[n2] = n2 % 2 == 0 ? (short)dataInputStream.readUnsignedByte() : (short)(256 - dataInputStream.readUnsignedByte());
            }
            bGeometry2.setStripDim(dataInputStream.readShort());
            for (n2 = 0; n2 < bGeometry2.stripCount; ++n2) {
                bGeometry2.stripLength[n2] = dataInputStream.readByte();
            }
            bGeometry2.setStrips(dataInputStream.readShort());
            for (n2 = 0; n2 < bGeometry2.stripElementsCount; ++n2) {
                bGeometry2.stripIndexes[n2] = dataInputStream.readShort();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR Level.loadBinaryMesh" + n + " ------------------------------");
            exception.printStackTrace();
        }
    }

    public static qMesh genLevelMesh() {
        qMesh qMesh2 = new qMesh();
        try {
            qMesh2.prepareFaces(_iDimX * _iDimY * _iDimZ * 6);
        }
        catch (Exception exception) {
            System.out.println("Error prepare faces");
            exception.printStackTrace();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            int n4 = 0;
            while (true) {
                if (currentLevel != 5 || n != 0 || n2 != 8 || n3 == 13) {
                    // empty if block
                }
                if (Level.isSolidCell(n4)) {
                    boolean bl = false;
                    byte by = Level.getCell(n, n2, n3);
                    if (Level.isCellSolidBonus((short)n, (short)n2, (short)(n3 - 1))) {
                        bl = true;
                    }
                    if (Level.isCellSolidBonus((short)n, (short)n2, (short)(n3 + 1))) {
                        bl = true;
                    }
                    if (Level.isCellSolidBonus((short)n, (short)(n2 - 1), (short)n3)) {
                        bl = true;
                    }
                    if (Level.isCellSolidBonus((short)n, (short)(n2 + 1), (short)n3)) {
                        bl = true;
                    }
                    if (Level.isCellSolidBonus((short)(n - 1), (short)n2, (short)n3)) {
                        bl = true;
                    }
                    if (Level.isCellSolidBonus((short)(n + 1), (short)n2, (short)n3)) {
                        bl = true;
                    }
                    if (!(bl = false)) {
                        int n5 = Level.getCell(n, n2, n3);
                        if (n == 0 || !Level.isSolidCell(n4 - 1)) {
                            n5 = Level.getSideTile(24, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(24, n5, n, n2, n3);
                        }
                        if (n == _iDimX - 1 || !Level.isSolidCell(n4 + 1)) {
                            n5 = Level.getSideTile(36, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(36, n5, n, n2, n3);
                        }
                        if (n2 == 0 || !Level.isSolidCell(n4 - _oY)) {
                            n5 = Level.getSideTile(0, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(0, n5, n, n2, n3);
                        }
                        if (n2 == _iDimY - 1 || !Level.isSolidCell(n4 + _oY)) {
                            n5 = Level.getSideTile(12, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(12, n5, n, n2, n3);
                        }
                        if (n3 == 0 || !Level.isSolidCell(n4 - _oZ)) {
                            n5 = Level.getSideTile(48, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(48, n5, n, n2, n3);
                        }
                        if (n3 == _iDimZ - 1 || !Level.isSolidCell(n4 + _oZ)) {
                            n5 = Level.getSideTile(60, (short)n, (short)n2, (short)n3);
                            qMesh2.addFace(60, n5, n, n2, n3);
                        }
                    }
                }
                if (++n >= _iDimX) {
                    n = 0;
                    if (++n2 >= _iDimY) {
                        n2 = 0;
                        if (++n3 >= _iDimZ) break;
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            System.out.println("Error main cycle");
            exception.printStackTrace();
        }
        try {
            qMesh2.complete(true);
        }
        catch (Exception exception) {
            System.out.println("Error prepare complete");
            exception.printStackTrace();
        }
        return qMesh2;
    }

    public static qMesh genInvisibleCells() {
        if (iInvisibleCellsCount == 0) {
            return null;
        }
        qMesh qMesh2 = new qMesh();
        int n = 11;
        try {
            qMesh2.prepareFaces(iInvisibleCellsCount * 6);
        }
        catch (Exception exception) {
            System.out.println("Error prepare faces");
            exception.printStackTrace();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            int n5 = 0;
            while (true) {
                if (_cells[n5] == 11) {
                    if (n2 == 0 || !Level.isSolidCell(n5 - 1)) {
                        qMesh2.addFace(24, n, n2, n3, n4);
                    }
                    if (n2 == _iDimX - 1 || !Level.isSolidCell(n5 + 1)) {
                        qMesh2.addFace(36, n, n2, n3, n4);
                    }
                    if (n3 == 0 || !Level.isSolidCell(n5 - _oY)) {
                        qMesh2.addFace(0, n, n2, n3, n4);
                    }
                    if (n3 == _iDimY - 1 || !Level.isSolidCell(n5 + _oY)) {
                        qMesh2.addFace(12, n, n2, n3, n4);
                    }
                    if (n4 == 0 || !Level.isSolidCell(n5 - _oZ)) {
                        qMesh2.addFace(48, n, n2, n3, n4);
                    }
                    if (n4 == _iDimZ - 1 || !Level.isSolidCell(n5 + _oZ)) {
                        qMesh2.addFace(60, n, n2, n3, n4);
                    }
                }
                if (++n2 >= _iDimX) {
                    n2 = 0;
                    if (++n3 >= _iDimY) {
                        n3 = 0;
                        if (++n4 >= _iDimZ) break;
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println("Error main cycle");
            exception.printStackTrace();
        }
        try {
            qMesh2.complete(true);
        }
        catch (Exception exception) {
            System.out.println("Error prepare complete");
            exception.printStackTrace();
        }
        return qMesh2;
    }

    public static int getSideTile(int n, short s, short s2, short s3) {
        switch (n) {
            case 0: {
                if (Level.isCellSolidBonus(s, (short)(s2 - 1), s3)) {
                    return Level.getCell(s, (short)(s2 - 1), s3);
                }
                return Level.getCell(s, s2, s3);
            }
            case 12: {
                if (Level.isCellSolidBonus(s, (short)(s2 + 1), s3)) {
                    return Level.getCell(s, (short)(s2 + 1), s3);
                }
                return Level.getCell(s, s2, s3);
            }
            case 24: {
                if (Level.isCellSolidBonus((short)(s - 1), s2, s3)) {
                    return Level.getCell((short)(s - 1), s2, s3);
                }
                return Level.getCell(s, s2, s3);
            }
            case 36: {
                if (Level.isCellSolidBonus((short)(s + 1), s2, s3)) {
                    return Level.getCell((short)(s + 1), s2, s3);
                }
                return Level.getCell(s, s2, s3);
            }
            case 48: {
                if (Level.isCellSolidBonus(s, s2, (short)(s3 - 1))) {
                    return Level.getCell(s, s2, (short)(s3 - 1));
                }
                return Level.getCell(s, s2, s3);
            }
            case 60: {
                if (Level.isCellSolidBonus(s, s2, (short)(s3 + 1))) {
                    return Level.getCell(s, s2, (short)(s3 + 1));
                }
                return Level.getCell(s, s2, s3);
            }
        }
        return -1;
    }

    public static void updateAnglesDynamicAxises(float f) {
        if (Logic._posBallOld[3] == Logic._posBall[3]) {
            switch (Logic._posBall[3]) {
                case 1: {
                    ballAngleX += f;
                    break;
                }
                case -1: {
                    ballAngleX -= f;
                    break;
                }
                case 2: {
                    ballAngleY += f;
                    break;
                }
                case -2: {
                    ballAngleY -= f;
                    break;
                }
                case 3: {
                    ballAngleZ += f;
                    break;
                }
                case -3: {
                    ballAngleZ -= f;
                }
            }
        }
        if (Logic._posBallOld[4] == Logic._posBall[4]) {
            switch (Logic._posBall[4]) {
                case 1: {
                    ballAngleX += f;
                    break;
                }
                case -1: {
                    ballAngleX -= f;
                    break;
                }
                case 2: {
                    ballAngleY += f;
                    break;
                }
                case -2: {
                    ballAngleY -= f;
                    break;
                }
                case 3: {
                    ballAngleZ += f;
                    break;
                }
                case -3: {
                    ballAngleZ -= f;
                }
            }
        }
        if (Logic._posBallOld[5] == Logic._posBall[5]) {
            switch (Logic._posBall[5]) {
                case 1: {
                    ballAngleX += f;
                    break;
                }
                case -1: {
                    ballAngleX -= f;
                    break;
                }
                case 2: {
                    ballAngleY += f;
                    break;
                }
                case -2: {
                    ballAngleY -= f;
                    break;
                }
                case 3: {
                    ballAngleZ += f;
                    break;
                }
                case -3: {
                    ballAngleZ -= f;
                }
            }
        }
    }

    public static void rotateTop(float f) {
        switch (Logic._start_cell[4]) {
            case 1: {
                ballAngleX += f;
                break;
            }
            case -1: {
                ballAngleX -= f;
                break;
            }
            case 2: {
                ballAngleY += f;
                break;
            }
            case -2: {
                ballAngleY -= f;
                break;
            }
            case 3: {
                ballAngleY += f;
                break;
            }
            case -3: {
                ballAngleZ -= f;
            }
        }
    }

    public static void rotateSide(float f) {
        switch (Logic._start_cell[5]) {
            case 1: {
                ballAngleX += f;
                break;
            }
            case -1: {
                ballAngleX -= f;
                break;
            }
            case 2: {
                ballAngleX += f;
                break;
            }
            case -2: {
                ballAngleX -= f;
                break;
            }
            case 3: {
                ballAngleZ += f;
                break;
            }
            case -3: {
                ballAngleZ -= f;
            }
        }
    }

    static {
        DIRECTION_FORWARD = (byte)-1;
        DIRECTION_BACKWARD = 1;
        isTrapsActive = false;
        ballScale = 0.7f;
        currentLevel = 0;
        trapsDisplace = 0;
        startPosX = 0;
        startPosY = 0;
        startPosZ = 0;
        ballAngleX = 0.0f;
        ballAngleY = 0.0f;
        ballAngleZ = 0.0f;
        bonusesAngle = 0.0f;
        ballInitialAngleX = 0.0f;
        ballInitialAngleY = 0.0f;
        ballInitialAngleZ = 0.0f;
        ballDesirableAngle = 0.0f;
        ballScaleX = 1.0f;
        ballScaleY = 1.0f;
        ballScaleZ = 1.0f;
        curScale = 1.0f;
        ballMaxScale = 1.0f;
        ballMinScale = 0.86f;
        curScaleAdd = 0.0f;
        ballSettlingIncrementX = 0.0f;
        ballSettlingIncrementY = 0.0f;
        ballSettlingIncrementZ = 0.0f;
        ballCurrentPosM3GX = Logic._posBall[0] * 256;
        ballCurrentPosM3GY = Logic._posBall[1] * 256;
        ballCurrentPosM3GZ = Logic._posBall[2] * 256;
        iInvisibleCellsCount = 0;
    }
}

