/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class Utils {
    private static final Random _rnd = new Random(System.currentTimeMillis());
    public static int _iFPSCounter = 0;
    public static long _lFPSTime = System.currentTimeMillis();
    public static DataInputStream _dis = null;
    private static int[] sin_t = new int[]{0, 174, 342, 500, 643, 766, 866, 940, 985, 1000};

    public static final int rnd(int n) {
        return (_rnd.nextInt() & Integer.MAX_VALUE) % n;
    }

    static int mascotSqrt(int n) {
        n = (int)Math.sqrt(n);
        return n;
    }

    static int mascotSin(int n) {
        double d = (double)n * 0.0878;
        d = (int)Math.sin(Math.toRadians(d));
        n = (int)(d * 1024.0);
        return n;
    }

    static int mascotCos(int n) {
        double d = (double)n * 0.0878;
        d = (int)Math.cos(Math.toRadians(d));
        n = (int)(d * 1024.0);
        return n;
    }

    static float[] cutFloat(float[] fArray, int n) {
        int n2;
        float f = 1.0f;
        for (n2 = 0; n2 < n; ++n2) {
            f *= 10.0f;
        }
        n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = fArray[n2] * f;
            int n3 = (int)fArray[n2];
            fArray[n2] = n3;
            int n4 = n2++;
            fArray[n4] = fArray[n4] / f;
        }
        return fArray;
    }

    static boolean hasFile(String string) {
        try {
            return ((Object)((Object)M._instance)).getClass().getResourceAsStream(string) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final int ensureRange(int n, int n2, int n3) {
        return n >= n3 ? n3 : (n <= n2 ? n2 : n);
    }

    public static final int abs(int n) {
        return n >= 0 ? n : -n;
    }

    public static final float abs(float f) {
        return f >= 0.0f ? f : -f;
    }

    public static final int abs(short s) {
        return s >= 0 ? s : -s;
    }

    public static final int sgn(int n) {
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static double tg(float f) {
        double d = (double)Math.abs(f) * Math.PI / 180.0;
        return Math.sin(d) / Math.cos(d);
    }

    public static float setValidAngle(float f) {
        if (Utils.abs(f) > 360.0f) {
            while (Utils.abs(f) > 360.0f) {
                if (f > 0.0f) {
                    f -= 360.0f;
                }
                if (!(f < 0.0f)) continue;
                f += 360.0f;
            }
        }
        return f;
    }

    public static final int interp_angle(int n, int n2, int n3, int n4) {
        return n + (n2 - n) * n3 / n4;
    }

    public static final void refreshFPS() {
        long l = System.currentTimeMillis();
        long l2 = l - _lFPSTime;
        if (l2 > 1000L) {
            _iFPSCounter = 0;
            _lFPSTime = l;
        } else {
            ++_iFPSCounter;
        }
    }

    public static final DataInputStream getFileStream(int n) throws Exception {
        return new DataInputStream(((Object)((Object)M._instance)).getClass().getResourceAsStream("/" + n));
    }

    public static final byte[] getFileBytes(int n) throws Exception {
        DataInputStream dataInputStream = Utils.getFileStream(n);
        byte[] byArray = new byte[dataInputStream.readUnsignedShort()];
        dataInputStream.read(byArray);
        return byArray;
    }

    public static final DataInputStream setFileStream(String string) {
        _dis = null;
        _dis = new DataInputStream(((Object)((Object)M._instance)).getClass().getResourceAsStream(string));
        return _dis;
    }

    public static final byte[] readBytes(int n) throws Exception {
        byte[] byArray = new byte[n];
        _dis.read(byArray);
        return byArray;
    }

    public static final byte[] readBytesW() throws Exception {
        return Utils.readBytes(_dis.readUnsignedShort());
    }

    public static final byte[] readBytesW(DataInputStream dataInputStream) throws Exception {
        return Utils.readBytes(dataInputStream.readUnsignedShort());
    }

    public static final byte[] readBytesD() throws Exception {
        return Utils.readBytes(_dis.readInt());
    }

    public static final ByteArrayInputStream readBaisW() throws Exception {
        return new ByteArrayInputStream(Utils.readBytesW());
    }

    public static final void skipBytesW() throws Exception {
        _dis.skip(_dis.readUnsignedShort());
    }

    public static final void skipBytesD() throws Exception {
        _dis.skip(_dis.readInt());
    }

    private static final void readChunk(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n) throws Exception {
        short s = dataInputStream.readShort();
        if (s == -1) {
            return;
        }
        byte[] byArray = new byte[s + 4];
        dataInputStream.read(byArray);
        dataOutputStream.writeInt(s);
        dataOutputStream.writeInt(n);
        ((OutputStream)dataOutputStream).write(byArray);
    }

    public static final Image loadImage() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(-1991225785);
        dataOutputStream.writeInt(218765834);
        Utils.readChunk(_dis, dataOutputStream, 1229472850);
        Utils.readChunk(_dis, dataOutputStream, 1347179589);
        Utils.readChunk(_dis, dataOutputStream, 1951551059);
        Utils.readChunk(_dis, dataOutputStream, 1229209940);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(1229278788);
        dataOutputStream.writeInt(-1371381630);
        return Image.createImage((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.size());
    }

    public static int sinus(int n) {
        int n2 = n / 10;
        if (n % 10 == 0) {
            return sin_t[n2];
        }
        return (sin_t[n2 + 1] - sin_t[n2]) * (n % 10) / 10 + sin_t[n2];
    }

    public static int sin(int n) {
        int n2 = 1;
        if ((n %= 360) < 0) {
            n = -n;
            n2 = -1;
        }
        if (n <= 90) {
            return n2 * Utils.sinus(n);
        }
        if (n <= 180) {
            return n2 * Utils.sinus(180 - n);
        }
        if (n <= 270) {
            return -n2 * Utils.sinus(n - 180);
        }
        return -n2 * Utils.sinus(360 - n);
    }

    public static int cos(int n) {
        if ((n %= 360) < 0) {
            n = -n;
        }
        if (n <= 90) {
            return Utils.sinus(90 - n);
        }
        if (n <= 180) {
            return -Utils.sinus(n - 90);
        }
        if (n <= 270) {
            return -Utils.sinus(270 - n);
        }
        return Utils.sinus(n - 270);
    }
}

